<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) exit();

	//Include the KYC Enterprise Model
	require_once(__MODELS__.'kyc_enterprise.model.php');
	
	//Include the KYC Personal Model
	require_once(__MODELS__.'kyc_personal.model.php');
	
	class _ProfileModel {
		private $DBLink;
		
		private $Users;
		
		private $KYCEnterpriseModel;
		private $KYCPersonalModel;
		
		public function __construct(&$DBLink) {
			//Continue if DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			
			//Logout Function or Invalid Session
			if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
				$this->Users->_Logout();
				
				header('Location: ./login');
				exit();
			}
		}
		
		public function _DeleteProfile($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);
			
			//Declare the KYC Enterprise Model
			if (!($this->KYCEnterpriseModel instanceof _KYC_EnterpriseModel)) {
				$this->KYCEnterpriseModel = new _KYC_EnterpriseModel($this->DBLink);
			}
			
			//Declare the KYC Personal Model
			if (!($this->KYCPersonalModel instanceof _KYC_PersonalModel)) {
				$this->KYCPersonalModel = new _KYC_PersonalModel($this->DBLink);
			}
			
			//Declare the KYC Personal Model
			if (!($this->KYCPersonalModel instanceof _KYC_PersonalModel)) {
				$this->KYCPersonalModel = new _KYC_PersonalModel($this->DBLink);
			}
			
			//Stop the DataBase Auto-Commit
			mysqli_autocommit($this->DBLink, false);
			
			//Disable the Foreign Key Checks
			if (!mysqli_query($this->DBLink, "SET foreign_key_checks = 0;")) {
				return -1;
			}
			
			//Try to Delete the Withdrawals for this User
			if ($this->_DeleteWithdrawalsByID($UserID) !== true) {
				//echo 'Delete Withdrawals'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -2;
			}
			
			//Try to Delete the Exchanges for this User
			if ($this->_DeleteExchangesByID($UserID) !== true) {
				//echo 'Delete Exchanges'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -3;
			}
			
			//Try to Delete the Sales for this User
			if ($this->_DeleteSalesByID($UserID) !== true) {
				//echo 'Delete Sales'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -4;
			}
			
			//Try to Delete the KYC Enterprise Verification for this User
			if ($this->KYCEnterpriseModel->_DeleteKYC($UserID) !== true) {
				//echo 'Delete KYC Enterprise'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -5;
			}
			
			//Try to Delete the KYC Personal Verification for this User
			if ($this->KYCPersonalModel->_DeleteKYC($UserID) !== true) {
				//echo 'Delete KYC Personal'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -6;
			}
			
			//Try to Delete the Tickets for this User
			if ($this->_DeleteTicketsByID($UserID) !== true) {
				//echo 'Delete Tickets'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -7;
			}
			
			//Try to Delete the Reset Codes for this User
			if ($this->_DeleteResetCodesByID($UserID) !== true) {
				//echo 'Delete Reset Codes'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -8;
			}
			
			//Try to Delete the Verification Codes for this User
			if ($this->_DeleteVerificationCodesByID($UserID) !== true) {
				//echo 'Delete Verification Codes'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -9;
			}
			
			//Try to Delete the Update Codes for this User
			if ($this->_DeleteUpdateCodesByID($UserID) !== true) {
				//echo 'Delete Update Codes'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -10;
			}
			
			//Try to Delete the Logins for this User
			if ($this->_DeleteLoginsByID($UserID) !== true) {
				//echo 'Delete Logins'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -11;
			}
			
			//Try to Delete the Referrals for this User
			if ($this->_DeleteReferralsByID($UserID) !== true) {
				//echo 'Delete Referrals'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -12;
			}
			
			//Try to Delete this User
			if ($this->Users->_DeleteUser($UserID) !== true) {
				//echo 'Delete this User'.PHP_EOL;
				
				//Enable the Foreign Key Checks
				mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");
				
				//Revert the DataBase Queries
				mysqli_rollback($this->DBLink);
				
				//Start the DataBase Auto-Commit
				mysqli_autocommit($this->DBLink, true);
				
				return -13;
			}
			
			//Enable the Foreign Key Checks
			if (!mysqli_query($this->DBLink, "SET foreign_key_checks = 1;")) {
				return -1;
			}
			
			//Start the DataBase Auto-Commit
			mysqli_autocommit($this->DBLink, true);
			
			return true;
		}
		
		private function _DeleteWithdrawalsByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			//Delete this User Withdrawals
			if (!mysqli_query($this->DBLink, "DELETE FROM `withdrawals` WHERE (`withdrawal_user` = '{$UserID}');")) {
				return -1;
			}
			
			//Update the Withdrawals where the User is the Verifier
			if (!mysqli_query($this->DBLink, "UPDATE `withdrawals` SET `withdrawal_verifier` = NULL WHERE (`withdrawal_verifier` = '{$UserID}');")) {
				return -2;
			}
			
			return true;
		}
		
		private function _DeleteExchangesByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			if (!mysqli_query($this->DBLink, "DELETE FROM `exchanges` WHERE (`exchange_user` = '{$UserID}');")) {
				return -1;
			}
			
			return true;
		}
		
		private function _DeleteSalesByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			//Delete this User Bonuses
			if (!mysqli_query($this->DBLink, "DELETE FROM `sales_bonuses` WHERE (`bonus_user` = '{$UserID}');")) {
				return -1;
			}
			
			//Update the Sales for this User
			if (!mysqli_query($this->DBLink, "UPDATE `sales` SET `sale_user` = NULL WHERE (`sale_user` = '{$UserID}');")) {
				return -2;
			}
			
			//Update the Sales where the User is the Verifier
			if (!mysqli_query($this->DBLink, "UPDATE `sales` SET `sale_verifier` = NULL WHERE (`sale_verifier` = '{$UserID}');")) {
				return -3;
			}
			
			return true;
		}
		
		private function _DeleteTicketsByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			//Get this User Tickets
			if ($Query = mysqli_query($this->DBLink, "SELECT `ticket_id` FROM `tickets` WHERE (`ticket_user` = '{$UserID}');")) {
				//Check if have any Ticket
				if (mysqli_num_rows($Query) > 0) {
					//Loop around the Tickets
					while ($Ticket = mysqli_fetch_assoc($Query)) {
						//Delete this Ticket Messages
						if (!mysqli_query($this->DBLink, "DELETE FROM `message` WHERE (`message_ticket_id` = '{$Ticket['ticket_id']}');")) {
							return -1;
						}
					}
				}
			} else {
				//DataBase Query Error
				return -2;
			}
			
			//Delete this User Messages
			if (!mysqli_query($this->DBLink, "DELETE FROM `message` WHERE (`message_user` = '{$UserID}');")) {
				return -3;
			}
			
			//Delete this User Tickets
			if (!mysqli_query($this->DBLink, "DELETE FROM `tickets` WHERE (`ticket_user` = '{$UserID}');")) {
				return -4;
			}
			
			//Update the Tickets where the User is the Assistant
			if (!mysqli_query($this->DBLink, "UPDATE `tickets` SET `ticket_assistant` = NULL WHERE (`ticket_assistant` = '{$UserID}');")) {
				return -5;
			}
			
			return true;
		}
		
		private function _DeleteResetCodesByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			if (!mysqli_query($this->DBLink, "DELETE FROM `reset_codes` WHERE (`reset_user` = '{$UserID}');")) {
				return -1;
			}
			
			return true;
		}
		
		private function _DeleteVerificationCodesByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			if (!mysqli_query($this->DBLink, "DELETE FROM `verification_codes` WHERE (`verification_user` = '{$UserID}');")) {
				return -1;
			}
			
			return true;
		}
		
		private function _DeleteUpdateCodesByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			if (!mysqli_query($this->DBLink, "DELETE FROM `update_codes` WHERE (`update_user` = '{$UserID}');")) {
				return -1;
			}
			
			return true;
		}
		
		private function _DeleteLoginsByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);	
			
			if (!mysqli_query($this->DBLink, "DELETE FROM `logins` WHERE (`login_user` = '{$UserID}');")) {
				return -1;
			}
			
			return true;
		}
		
		private function _DeleteReferralsByID($UserID) {
			$UserID = mysqli_real_escape_string($this->DBLink, $UserID);
            
			$this->Users = new _UsersModel($this->DBLink);
            
            $User = $this->Users->_GetUserData($UserID);
				if (!empty($User['user_referrer']) && is_numeric($User['user_referrer']) && $User['user_referrer'] != 0) {
				//Remove 1 from the Referrals Count and the Referrals Points from the Previous Referrer
				if (!mysqli_query($this->DBLink, "UPDATE `users` SET `user_referrals` = `user_referrals` - 1, `user_referrals_points` = (`user_referrals_points` - ".REFERRALS_POINTS.") WHERE (`user_id` = '{$User['user_referrer']}');")) {
					//Revert the DataBase Queries
					mysqli_rollback($this->DBLink);
					
					//Start the DataBase Auto-Commit
					mysqli_autocommit($this->DBLink, true);
				
					//Bad Query Error
					return -4;
				}
			}
            
            //Update the Users where the User is the Referrer
			if (!mysqli_query($this->DBLink, "UPDATE `users` SET `user_referrer` = NULL WHERE (`user_referrer` = '{$UserID}');")) {
				return -2;
			}
			
			return true;
		}
	}
?>