<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) exit();


//Include the Browser Detection Library
require_once(__LIBRARIES__ . 'browser.php');
//Include the GeoIP Library
require_once(__LIBRARIES__ . 'maxmind/autoload.php');
require_once(__LIBRARIES__ . 'anti_csrf.class.php');

class _Profile
{
	private $DBLink;
	private $Profile;
	private $Users;
	private $Sales;
	private $Browser;

	public function __construct(&$DBLink)
	{
		//If DataBase Link is Valid
		if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
			//Link the Class DataBase Link to the Given DataBase Link
			$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
		} else trigger_error('No MySQL connection!', E_USER_ERROR);

		$this->Users = new _UsersModel($this->DBLink);

		//Logout Function or Invalid Session
		if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
			$this->Users->_Logout();

			header('Location: ./login');
			exit();
		}

		//Get this User Information
		$User_Data = $this->Users->_GetUserData();
		//$User_Data['user_id']
		//$User_Data['user_role']
		//$User_Data['user_origin']
		//$User_Data['user_referrer']
		//$User_Data['user_email']
		//$User_Data['user_password']
		//$User_Data['user_purchases']
		//$User_Data['user_bonuses']
		//$User_Data['user_referrals']
		//$User_Data['user_tokens']
		//$User_Data['user_oneups']
		//$User_Data['user_address']
		//$User_Data['user_avatar']
		//$User_Data['user_code']
		//$User_Data['user_last_seen']
		//$User_Data['user_first_seen']

		//Check the User Permissions
		if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {
			//Check the User Index Page
			if (is_array($User_Data) && isset($User_Data['user_role'])) {
				//Get the User Index Page
				$Index = _RoleHome($User_Data['user_role']);

				//Check for Valid Index Page
				if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {
					header('Location: ./' . $Index);
					exit();
				} else if ($Index !== false) {
					header('Location: ./' . $Index);
					exit();
				}
			}



			header('Location: ./login');
			exit();
		}

		if (!(isset($_GET['id']) && !empty($_GET['id']) && is_numeric($_GET['id']) && $_GET['id'] > 0)) {
			header('Location: ./members');
			exit();
		}



		//Check for Role Change
		if (isset($_POST['role']) && !empty($_POST['role']) && is_numeric($_POST['role']) && NoCSRF::check('csrf_token', $_POST)) {
			echo 'faef';
			$RoleChange = $this->Users->_ChangeRole($_GET['id'], $_POST['role']);

			if ($RoleChange !== true) {
				echo 'Role Change: ' . $RoleChange;
				exit();
			}

			header('Location: ./profile?id=' . $_GET['id']);
			exit();
		}



		//Get the User Information
		$User = $this->Users->_GetUserData($_GET['id']);
		$csrf_token = NoCSRF::generate('csrf_token');
		if (!is_array($User)) {
			header('Location: ./members');
			exit();
		}

		//Load the Header Template
		require_once(__VIEWS__ . 'header.template.php');

		//Load the Profile Page Template
		require_once(__VIEWS__ . 'profile.template.php');

		//Load the Footer Template
		require_once(__VIEWS__ . 'footer.template.php');
	}

	function _ParseBrowser($UserAgent)
	{
		if (!($this->Browser instanceof Browser)) {
			$this->Browser = new Browser($UserAgent);
		} else {
			$this->Browser->setUserAgent($UserAgent);
		}

		$Browser = $this->Browser->getBrowser();

		if ($Browser == false || $Browser == 'unknown') {
			return 'Desconocido';
		}

		$Version = $this->Browser->getVersion();

		if ($Version == false || $Version == 'unknown') {
			return 'Desconocido';
		}


		return $Browser . ' ' . $Version;
	}

	//https://stackoverflow.com/questions/1416697/converting-timestamp-to-time-ago-in-php-e-g-1-day-ago-2-days-ago
	function time_elapsed_string($datetime, $full = false)
	{
		$now = new DateTime;
		$ago = new DateTime($datetime);
		$diff = $now->diff($ago);

		$diff->w = floor($diff->d / 7);
		$diff->d -= $diff->w * 7;

		$string = array(
			'y' => _('año'),
			'm' => _('mes'),
			'w' => _('semana'),
			'd' => _('día'),
			'h' => _('hora'),
			'i' => _('minuto'),
			's' => _('segundo'),
		);
		foreach ($string as $k => &$v) {
			if ($diff->$k) {
				$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
			} else {
				unset($string[$k]);
			}
		}

		if (!$full) $string = array_slice($string, 0, 1);
		return $string ? implode(', ', $string) . _(' atrás') : _('justo ahora');
	}
}
