<div class="content-wrapper">



    <div class="row profile-page ">



        <div class="col-md-12 mb-8">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/rhvddzym.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Envíos programados</p>

                        <span id="programados_count" class="">
                            <?php echo count($Programados); ?>
                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>




    <div class="row profile-page">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">



                    <div class="pt-0 ">



                        <div class="row ">

                            <!-- Historial de Acceso -->



                            <div class="col-md-12">


                                <div class="card card-cuenta">



                                    <div class="card-body card-table-body">

                                        <div class="table-responsive">

                                            <table id="order-listing" class="table">

                                                <thead>

                                                    <tr>

                                                        <th
                                                            style="padding-left: 32px !important;padding-right: 50px !important;">
                                                            ID</th>




                                                        <th>Fecha de envío</th>

                                                        <th>Número presupuesto</th>
                                                        <th>Email</th>
                                                        <th>Estado</th>



                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>



                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminaci贸n de cuenta -->



                            <!-- /Eliminaci贸n de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



</div>





<!-- MODALS -->


<div class="modal fade" id="modalEditarEnvio" role="dialog" aria-labelledby="exampleModalCenterTitle3"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Editar envío</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-lg p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">
                                <label>Fecha de envío</label>
                                <input type="date" class="form-control" id="fecha_envio" placeholder="">
                            </div>

                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" type="button" id="btn_edit_envio">

                    Editar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>





<div class="modal modal-cambiar fade" id="modalEliminarEnvio" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar envío</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el envío definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>


            <div class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_envio" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>




<script>
(function($) {

    'use strict';

    $(function() {

        var Table = $('#order-listing').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en envíos progrmados",
                infoEmpty: "Mostrando 0 a 0 de 0 en envíos progrmados",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [
                'colvis'
            ],
            "searching": true,
            "ajax": {
                url: '/api/presupuestos.php?programados=1', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                dataSrc: function(data) {
                    console.log(data);

                    $("#programados_count").text(data.length)
                    return data;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#order-listing').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_presupuesto",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "programado"
                },
                {
                    "data": "numero"
                },
                {
                    "data": "email"
                },
                {
                    "data": null,
                    "render": function(data, type, row, meta) {
                        // Reemplaza con tu fecha en formato de cadena

                        // Convertir la cadena a un objeto Moment
                        var fecha = moment(data.programado);

                        // Obtener la fecha y hora actual
                        var fechaActual = moment();

                        // Comparar las fechas
                        if (fecha.isBefore(fechaActual)) {
                            return "Enviado";
                        } else if (fecha.isAfter(fechaActual)) {
                            return "No enviado";
                        }

                    }
                },
                {
                    "data": "id_presupuesto",
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');



                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_editar_envio p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data);
                        buttonEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;

                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_envio p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data);
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;


                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        });



        $(document).on("click", ".btn_eliminar_envio", function(e) {



            $("#btn_eliminar_envio").data("id", $(this).data("id"))

            $("#modalEliminarEnvio").modal('show');




        })
        $('#btn_eliminar_envio').click(function(event) {

            var id_envio_eliminar = $("#btn_eliminar_envio").data("id")
            var programado = "No"

            $.ajax({
                type: 'POST',
                url: './api/presupuestos.php',
                data: {
                    programado: programado,
                    id_presupuesto_editar_envio: id_envio_eliminar

                },
                cache: false,
                success: function(result) {

                    $('#modalEliminarEnvio').modal('hide');
                    $.toast({
                        heading: 'Envío eliminado',
                        text: 'Se ha eliminado el envío correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })


                    $('#modalEliminarEnvio').modal('hide');

                    Table.ajax.reload(null, false);


                }
            });

            return false;
        });

        function VerificarEdit() {
            var result = true;
            var fecha = moment($('#fecha_envio').val(), 'YYYY-MM-DD')
            if (fecha.isBefore(moment())) {
                $.toast({
                    heading: 'Fecha no válida.',
                    text: 'Selecciona una fecha válida.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }


            return result;
        }
        $(document).on("click", ".btn_editar_envio", function() {
            var id_presupuesto_programado = $(this).data("id")
            console.log(id_presupuesto_programado)
            $.ajax({
                type: 'GET',
                url: './api/presupuestos.php?id_presupuesto=' +
                    id_presupuesto_programado,
                cache: false,
                async: false,
                dataType: "json",
                success: function(r) {


                    $("#btn_edit_envio").data("id", id_presupuesto_programado);

                    $('#fecha_envio').val(r.programado);
                    $('#modalEditarEnvio').modal("show");
                }
            });
        });
        $("#btn_edit_envio").click(function(e) {
            $("#btn_edit_envio").addClass('btn-loading');
            var programado = moment($("#fecha_envio").val()).format('YYYY-MM-DD')
            var id_presupuesto_programado = $(this).data("id")
            if (!VerificarEdit()) {
                $("#btn_edit_envio").removeClass('btn-loading');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: './api/presupuestos.php',
                data: {
                    programado: programado,
                    id_presupuesto_editar_envio: id_presupuesto_programado

                },
                cache: false,
                success: function(response) {
                    $.toast({
                        heading: 'Envío editado',
                        text: 'Se ha editado el envío correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $("#btn_edit_envio").removeClass("btn-loading")
                    $('#modalEditarEnvio').modal("hide");
                    Table.ajax.reload(null, false);

                }
            })
        })






    });

})(jQuery);
</script>