<style>
#ms-public-methods {

    width: 100%;

}

#ms-public-methods .ms-selectable {

    background: transparent;

}

#ms-public-methods .ms-selection {

    background: transparent;

}

#select-all {

    float: left;

    width: 45%;

}

#deselect-all {

    float: right;

    width: 45%;

}

.custom-header {

    text-align: center;

    background: #e6e6e6;

    border-radius: 2px;

}
</style>

<div class="content-wrapper">

    <div class="row profile-page ">

        <div class="col-md-12 mb-8">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/hbzjlsuh.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Potenciales Clientes</p>

                        <span id="clientes_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>
    <div class="row profile-page mb-3">

        <div class="col-12">

            <div class="card">
                <div class="card-header">

                    <div class="row">

                        <div class="col-12 d-flex align-items-center justify-content-start">

                            <h4 class="mb-0" style="line-height: 1;">Importar clientes</h4>
                            <i class="ml-0 ml-sm-1 ti-help-alt" data-toggle="tooltip" data-placement="top"
                                title="Los clientes con códigos repetidos se actualizarán y los que no tengan código se añadirán de forma correlativa."
                                data-original-title="asdfa" style="font-size: 1.13rem;"></i>

                        </div>

                    </div>

                </div>




                <div class="card-body card-table-body">
                    <div class="form-group m-0">

                        <div class="row">

                            <div class="col-12 col-sm-auto pr-sm-0">
                                <a href="./assets/imports/import_base_clientes.xlsx"
                                    download="import_base_clientes.xlsx"
                                    class="w-100 mb-3 mb-sm-0 btn btn-sm btn-primary" id="">Descargar xlsx

                                    base</a>
                            </div>
                            <div class="col-12 col-sm-auto pr-sm-0">
                                <input type="file" id="input_archivo" accept=".xlsx"
                                    class="w-100 mb-3 mb-sm-0 py-1 mx-0 btn btn-sm btn-secondary"
                                    style="line-height: 18px;height: 32px!important;border: 0px;" />


                            </div>
                            <div class="col-12 col-sm-auto pr-sm-0">

                                <button class="w-100 btn btn-sm btn-success" id="button_archivo">Procesar

                                    archivo</button>
                            </div>

                        </div>
                    </div>

                </div>





            </div>

        </div>



    </div>

    <div class="row profile-page">

        <div class="col-12">

            <div class="card">
                <div class="card-header">

                    <div class="row">

                        <div class="col-12 d-flex align-items-center justify-content-start">

                            <h4 class="mb-0">Clientes potenciales</h4>


                        </div>

                    </div>

                </div>
                <div class="card-body card-table-body p-3">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-12 col-sm-auto pr-sm-0">

                                <button data-toggle="modal" data-target="#modalAgregarCliente"
                                    class="w-100 mb-3 mb-sm-0 btn btn-sm btn-primary">Agregar</button>
                            </div>
                            <div class="col-12 col-sm-auto pr-sm-0">
                                <button id="btn_editar_grupos" data-tipo="Potencial" data-toggle="modal"
                                    data-target="#modalEditarGrupos"
                                    class="mr-0 w-100 btn btn-sm btn-info">Grupos</button>

                            </div>
                        </div>


                    </div>






                    <div class="row">
                        <div class="col-12 col-sm-auto pr-sm-0">
                            <div class="form-group ">

                                <label for="my-input">Filtro por grupo</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_grupo file-upload-browse btn btn-danger"
                                            data-target="select_grupos2" type="button">-</button>

                                    </span>

                                    <select style="min-width: 200px;" id="select_grupos2"
                                        class="w-100 select_grupos custom-select select2 form-control">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarGrupo">+</button>

                                    </span>

                                </div>

                            </div>
                        </div>
                        <div class="col-12 col-sm-auto pr-sm-0">
                            <div class="form-group ">

                                <label for="my-input">Filtro por estado</label>

                                <select style="min-width: 200px;" id="select_activo"
                                    class="w-100 select custom-select select2 form-control">

                                    <option selected type="text" value="Todos">Todos
                                    </option>

                                    <option type="text" value="Activo">Activo</option>

                                    <option type="text" value="Inactivo">Inactivo
                                    </option>

                                </select>

                            </div>
                        </div>
                        <div class="col-12 col-sm-auto pr-sm-0">
                            <div class="form-group ">

                                <label for="my-input">Filtro por contacto</label>

                                <select style="min-width: 200px;" id="select_contacto"
                                    class="w-100 select custom-select select2 form-control">

                                    <option selected type="text" value="No">Todos
                                    </option>

                                    <option type="text" value="1">Habilitado</option>

                                    <option type="text" value="0">No habilitado</option>

                                </select>

                            </div>
                        </div>
                    </div>









                    <div class="table-responsive">

                        <table style="min-height:120px;" id="tabla_clientes_potenciales" cellspacing="0"
                            class="tabla_clientes table display nowrap">

                            <thead>

                                <tr>

                                    <th style="padding-left: 32px !important;padding-right: 50px !important;">

                                        Código</th>

                                    <th>Nombre</th>

                                    <th>Grupos</th>

                                    <th>Email</th>

                                    <th>Contacto</th>

                                    <th>Movil</th>

                                    <th style="padding-right: 60px !important;padding-left: 60px !important;">

                                        DNI</th>

                                    <th style="text-align:center;">Acciones</th>

                                </tr>

                            </thead>

                            <tbody>

                            </tbody>

                        </table>

                    </div>

                </div>



            </div>

        </div>

    </div>

</div>

<?php require_once __VIEWS__ . 'selects/grupos.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>

<script>
(function($) {

    'use strict';

    $(function() {

        $('#tabla_clientes_potenciales').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, 100],

                [10, 25, 50, 100]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en clientes potenciales",

                infoEmpty: "Mostrando 0 a 0 de 0 en clientes potenciales",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",

                zeroRecords: "Ningún resultado.",

                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [

                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }

            ],

            "searching": true,

            "initComplete": function() {

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": true,

            "ajax": {

                "url": "./ServerSide/serversideClientes.php",

                "data": function(d) {

                    // Agregar parámetros adicionales a la solicitud aquí

                    d.id_grupo = $("#select_grupos2").val();

                    d.estado_cliente = "Potencial";

                    d.activo = $("#select_activo").val();

                    d.terminos = $("#select_contacto").val()

                },

                dataSrc: function(json) {

                    $("#clientes_count").text(json.recordsFiltered);

                    console.log(json);

                    return json.data;

                },

                "error": function(xhr, error, thrown) {

                    // Manejo de errores

                    alert('Error en la carga de datos: ' + thrown);

                }

            },

            "columns": [{

                    "data": "codigo",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre"

                },

                {

                    "data": "grupos",

                    "render": function(data, type, row, meta) {

                        if (data.includes("null")) {
                            return ""
                        }

                        data = JSON.parse(data);

                        var ul = document.createElement('ul');

                        ul.classList.add("h-100", "list-group")

                        ul.style.overflowY = 'auto';

                        ul.style.maxHeight = '130px';

                        // Iterar sobre el arreglo de grupos

                        data.forEach(function(grupo) {

                            var li = document.createElement('li');

                            li.textContent = grupo.nombre;

                            li.classList.add("p-2",

                                "list-group-item", "d-flex",

                                "justify-content-between", "align-items-center")

                            // Establecer el atributo data-id con el id_grupo del grupo

                            li.setAttribute('data-id', grupo.id_grupo);

                            // Agregar el LI al UL

                            ul.appendChild(li);

                        });

                        return ul.outerHTML;

                    }

                },

                {

                    "data": "email"

                }, {

                    "data": "terminos",

                    "render": function(data, type, row, meta) {

                        if (data != 0) {

                            return '<span>Habilitado</span>';

                        } else {

                            return '<span>Denegado</span>';

                        }

                    }

                },

                {

                    "data": "movil"

                },

                {

                    "data": "cif"

                },

                {

                    "data": "client_id",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var linkVerPerfil = document.createElement('a');

                        linkVerPerfil.className = 'p-1 dropdown-item';

                        linkVerPerfil.href = `./cliente?id=${data}`;

                        linkVerPerfil.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#00000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Ver Perfil

                `;

                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'button-editar p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data);

                        buttonEditar.innerHTML = `

                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Editar

                `;

                        var buttonAceptar = document.createElement('button');

                        buttonAceptar.className = 'btn_aceptar_cliente p-1 dropdown-item';

                        buttonAceptar.setAttribute('type', 'button');

                        buttonAceptar.setAttribute('data-id', data);

                        buttonAceptar.innerHTML = `

                    <lord-icon src="./assets/lordicons/aceptar.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Aceptar

                `;

                        var buttonCambiarEstado = document.createElement('button');

                        buttonCambiarEstado.className =

                            'btn_cambiar_estado p-1 dropdown-item';

                        buttonCambiarEstado.setAttribute('type', 'button');

                        buttonCambiarEstado.setAttribute('data-id', data);

                        buttonCambiarEstado.innerHTML = `

                    <lord-icon src="./assets/lordicons/user.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Estado

                `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className = 'btn_eliminar_cliente p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;

                        dropdownMenu.appendChild(linkVerPerfil);

                        dropdownMenu.appendChild(buttonEditar);

                        dropdownMenu.appendChild(buttonEliminar);

                        dropdownMenu.appendChild(buttonCambiarEstado);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }

                }

            ]

        });

        $("#select_grupos2").change(function(e) {

            //$('.tabla_clientes').DataTable().ajax.reload(null, false);

            $('#tabla_clientes_potenciales').DataTable().ajax.reload(null, false);

        });

        $("#select_activo").change(function(e) {

            $('#tabla_clientes_potenciales').DataTable().ajax.reload(null, false);

        });

        $("#select_contacto").change(function(e) {

            $('#tabla_clientes_potenciales').DataTable().ajax.reload(null, false);

        });

    });

})(jQuery);
</script>

<script>
window.addEventListener('DOMContentLoaded', (event) => {

    document.getElementById('button_archivo').addEventListener('click', function() {

        const archivoInput = document.getElementById('input_archivo');

        const archivo = archivoInput.files[0];

        if (archivo) {

            const lector = new FileReader();

            lector.onload = function(e) {

                const contenido = e.target.result;

                const libro = XLSX.read(contenido, {

                    type: 'binary'

                });

                const hojaNombre = libro.SheetNames[0];

                const hoja = libro.Sheets[hojaNombre];

                const datos = XLSX.utils.sheet_to_json(hoja, {
                    defval: "",
                    cellDates: true
                });

                console.log(datos); // Muestra el array de objetos

                const camposRequeridos = ['nombre'];

                // Verificación
                const filasInvalidas = datos.filter((item, index) => {
                    // Verifica campos vacíos
                    const tieneVacios = camposRequeridos.some(campo => item[campo] ===
                        null || item[campo] === "");

                    // Verifica tipos de datos


                    // Verifica formato de fecha de nacimiento si no está vacío
                    let fechaNacimientoValida = true;
                    if (item.fecha_nacimiento !== null && item.fecha_nacimiento !== "") {
                        const regexFecha = /^\d{4}-\d{2}-\d{2}$/;
                        fechaNacimientoValida = regexFecha.test(item.fecha_nacimiento);
                    }

                    return (
                        tieneVacios ||

                        !fechaNacimientoValida
                    );
                });


                if (filasInvalidas.length > 0) {
                    $.toast({
                        heading: 'Error en archivo',
                        text: 'Hay filas con datos faltantes o tipos de datos incorrectos.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 6
                    });
                    return;
                }

                $("#button_archivo").addClass("btn-loading");

                // Enviar todos los datos en una única solicitud POST

                var fd = new FormData();

                fd.append('import_items', JSON.stringify(datos));

                $.ajax({

                    type: 'POST',

                    url: './api/clientes.php',

                    cache: false,

                    data: fd,

                    processData: false, // tell jQuery not to process the data

                    contentType: false, // tell jQuery not to set contentType

                    success: function(response) {

                        console.log(response);

                        response = JSON.parse(response);

                        $('#tabla_clientes_potenciales').DataTable().ajax.reload(null,
                            false);

                        $("#button_archivo").removeClass("btn-loading");

                        document.getElementById('input_archivo').value = "";

                        $.toast({

                            heading: 'Clientes agregados',

                            text: 'Se han agregado los clientes correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                    },

                    error: function(xhr, status, error) {
                        console.log("XHR:", xhr);

                        $("#button_archivo").removeClass("btn-loading");

                        let mensaje = 'Ocurrió un error al agregar los clientes.';

                        try {
                            const respuesta = JSON.parse(xhr.responseText);
                            if (respuesta.message) {
                                mensaje = respuesta.message;

                                // Si hay códigos duplicados, los mostramos también
                                if (respuesta.codigos_duplicados) {
                                    mensaje += ': ' + respuesta.codigos_duplicados.join(
                                        ', ');
                                }
                            }
                        } catch (e) {
                            console.warn('No se pudo parsear el JSON del error');
                        }

                        $.toast({
                            heading: 'Error',
                            text: mensaje,
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 6000,
                            stack: 6
                        });
                    }

                });

            };

            lector.readAsBinaryString(archivo);

        } else {

            $.toast({

                heading: 'Archivo faltante.',

                text: 'Por favor, seleccione un archivo.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 2000,

                stack: 6

            });

        }

    });

});
</script>