<style>
td.long_text span {
    max-width: 250px !important;
    overflow: hidden !important;
    word-wrap: break-word !important;
    display: -webkit-box !important;
    -webkit-line-clamp: 14 !important;
    -webkit-box-orient: vertical !important;
    white-space: pre-wrap !important;
}
</style>


<div class="content-wrapper">

    <div class="row profile-page ">
        <div class="col-md-12 mb-8">
            <div class="card satmar-bottom">
                <div class="sato-border-blue">

                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/dnbjoceq.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>
                        <p class="mb-2">Planes</p>
                        <span id="planes_count"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row ">
        <div class="col-12">
            <div class="card p-4">
                <div class="row">
                    <div class="col-12">
                        <button data-toggle="modal" data-target="#modalAgregarPlan"
                            class="btn btn-sm btn-primary">Agregar</button>
                    </div>
                </div>

            </div>

        </div>



        <!-- Historial de Acceso -->
        <div class="col-md-12">
            <div class="card card-cuenta">


                <div class="card-body card-table-body p-3 p-sm-4">

                    <table id="tabla_planes" style="min-height:120px;" cellspacing="0" class="table display nowrap">
                        <thead>
                            <tr>
                                <th style="padding-left: 32px !important;padding-right: 50px !important;">
                                    ID</th>
                                <th>Nombre</th>
                                <th>Sector</th>
                                <th>Importe</th>
                                <th>Total ingresado</th>
                                <th>Falta por ingresar</th>
                                <th>Fecha</th>
                                <th style="text-align:center;">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
        <!-- /Historial de Acceso -->
        <!-- Eliminación de cuenta -->

        <!-- /Eliminación de cuenta -->
    </div>
</div>


<div class="modal fade modal-cambiar" id="modalAgregarPlan" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar plan</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>
                            <input id="nombre" class="form-control" type="text" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Sector</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_sector file-upload-browse btn btn-danger"
                                        data-target="id_sector" type="button">-</button>
                                </span>
                                <select id="id_sector" class="select_sectores custom-select select2 form-control">
                                    <option value="No">
                                        Ninguno
                                    </option>
                                    <?php
                                    foreach ($Sectores as $Sector)
                                        {
                                        ?>
                                    <option value="<?php echo $Sector['id_sector']; ?>">
                                        <?php echo $Sector['nombre']; ?>
                                    </option>
                                    <?php
                                        }
                                    ?>
                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarSector">+</button>
                                </span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="my-input">Importe</label>
                            <input id="importe" class="form-control" type="number" step="any">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Fecha</label>
                            <input id="fecha" class="form-control" type="date" name="">
                        </div>
                    </div>
                </div>









            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">



                <button id="btn_agregar_plan" class="btn btn-success btn-fw" type="button" name="">
                    Agregar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalEditarPlan" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar plan</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>
                            <input id="nombre_editar" class="form-control" type="text" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Sector</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_sector file-upload-browse btn btn-danger"
                                        data-target="id_sector_editar" type="button">-</button>
                                </span>
                                <select id="id_sector_editar"
                                    class="select_sectores custom-select select2 form-control">
                                    <option value="No">
                                        Ninguno
                                    </option>
                                    <?php
                                    foreach ($Sectores as $Sector)
                                        {
                                        ?>
                                    <option value="<?php echo $Sector['id_sector']; ?>">
                                        <?php echo $Sector['nombre']; ?>
                                    </option>
                                    <?php
                                        }
                                    ?>
                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarSector">+</button>
                                </span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="my-input">Importe</label>
                            <div class="input-group">
                                <input id="importe_editar" class="form-control" type="number" step="any">
                                <div class="input-group-append">
                                    <span class="input-group-text">€</span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="my-input">Fecha</label>
                            <input id="fecha_editar" id="datetime-local" class="form-control" type="text" name="">
                        </div>
                    </div>
                </div>









            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">



                <button id="btn_editar_plan" class="btn btn-success btn-fw" type="button" name="">
                    Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar</button>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal modal-cambiar fade" id="modalEliminarPlan" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar plan</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el plan definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div style="margin-top:15px;" class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_plan" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal modal-cambiar fade" id="modalIngresos" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Gestionar ingresos</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="row mb-4">
                    <div class="col-md-6 mb-4">
                        <div class="form-group">
                            <label for="my-input">Monto</label>
                            <div class="input-group">
                                <input id="monto_ingreso" class="form-control" type="number" step="0.01" min="0.01"
                                    onchange="if(!validity.valid) handleInvalidInput(this);"
                                    style="pointer-events: all;">
                                <div class="input-group-append">
                                    <span class="input-group-text">€</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-4">
                        <div class="form-group">
                            <label for="my-input">Fecha</label>
                            <input id="fecha_ingreso" class="form-control" type="datetime-local" name="">
                        </div>
                    </div>
                    <div class="col-12 mb-4">
                        <div class="form-group">
                            <label for="my-input">Observaciones</label>

                            <textarea class="form-control" id="observaciones_ingreso" cols="30" rows="10"></textarea>
                        </div>
                    </div>
                    <div class="col-12 mb-4">
                        <button class="float-right btn btn-success btn-fw" id="btn_agregar_ingreso"
                            type="button">Agregar</button>
                    </div>
                </div>
                <div class="row mb-4">
                    <div class="col-12">
                        <table id="tabla_ingresos" style="min-height:120px;" cellspacing="0"
                            class="table display nowrap">
                            <thead>
                                <tr>
                                    <th style="padding-left: 32px !important;padding-right: 50px !important;">
                                        ID</th>
                                    <th>Monto</th>
                                    <th>Fecha</th>
                                    <th>Observaciones</th>
                                    <th style="text-align:center;">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>

                </div>
                <div class="row">
                    <div class="col-12">
                        <h4><strong>Importe total del plan: </strong> <span id="monto_total"></span></h4>
                        <h4><strong>Total ingresado: </strong> <span id="total_ingresado"></span></h4>
                        <h4><strong>Falta por ingresar: </strong> <span id="falta_ingresar"></span></h4>
                    </div>
                </div>


            </div>


            <div style="margin-top:15px;" class="modal-footer text-right">




                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cerrar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal modal-cambiar fade" id="modalEliminarIngreso" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar ingreso</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el ingreso definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div style="margin-top:15px;" class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_ingreso" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<!-- MODALS -->
<div class="modal fade" id="modalSubirArchivo" role="dialog">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Archivos</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-4">
                <div class="row">
                    <div class="col-12 col-md-6">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>

                            <input id="nombre_archivo" type="text" class="form-control">

                        </div>

                    </div>
                    <div class="col-12 col-md-6">
                        <div class="form-group">
                            <label for="my-input">Archivo</label>
                            <div class="input-group">
                                <input type="file" class="d-none" id="archivo_file" accept=".png, .jpg, .pdf">
                                <input disabled id="archivo_archivo" type="text" class="form-control"
                                    value="Ningún archivo seleccionado.">
                                <div class="input-group-append">
                                    <label for="archivo_file" class="mb-0 btn btn-success btn-fw" id="btn_subir_archivo"
                                        type="button">

                                        Seleccionar archivo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 text-left mb-2">
                        <button class="btn btn-success btn-fw" id="btn_add_archivo" type="button"">Subir</button>
                    </div>
                </div>

                <div class=" container-lg p-0">
                            <div id="lista_archivos" class="row">

                            </div>





                    </div>



                </div>





                <!-- /modal-body -->

            </div>

        </div>

    </div>
</div>
<div class="modal fade modal-cambiar" id="modalVerArchivo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div id="contenedor_archivo" class="modal-body pb-4">
                <!-- btn -->






            </div>

            <!-- /btn -->


            <!-- /modal-body -->
        </div>
    </div>
</div>
<style>
.archivo_lista {
    cursor: pointer;
    transition: all .3s ease;
    position: relative;
    height: 100%;
    width: 100%;
    background: #0000001a;
    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    aspect-ratio: 1/1;
    border-radius: 2% !important;
}

.archivo_lista img {
    object-fit: cover;
    max-height: 200px;
}

.archivo_lista:hover {
    opacity: .5;
    background: #000000;
}

.btn_eliminar_archivo {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    right: 0;
    top: 0;
    border-radius: 10% !important;
}

.archivo_lista:hover .btn_eliminar_archivo {
    opacity: 1;
}

.btn_eliminar_archivo i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #F1635F;
}

.btn_eliminar_archivo:hover i:before {
    color: #F1635F;
}

.btn_seleccionar_archivo {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    left: 0;
    top: 0;
    border-radius: 10% !important;
}

.archivo_lista:hover .btn_seleccionar_archivo {
    opacity: 1;
}

.btn_seleccionar_archivo i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #0cca8e;
}

.btn_seleccionar_archivo:hover i:before {
    color: #0cca8e;
}

.nombre_archivo_div {
    position: absolute;
    font-size: 18px;
    border-radius: 4px;
    transition: all .3s ease;
    opacity: 0;
    color: white;
    background-color: black;
    padding: .5rem;
    cursor: pointer;
}

.col-sm-3:hover .nombre_archivo_div {
    opacity: 1;
}

#lista_archivos {
    max-height: 723px;
    overflow-y: scroll;
}
</style>




<?php require_once __VIEWS__ . 'selects/sectores.template.php'; ?>
<script>
function handleInvalidInput(input) {

    input.value = ""
    $.toast({
        heading: 'Por favor ingresa un monto válido.',
        text: 'El monto debe ser un número decimal mayor que 0.',
        position: 'top-right',
        loaderBg: '#ff5c6c',
        icon: 'error',
        hideAfter: 5000,
        stack: 6
    });
    input.focus()



}
</script>

<script>
(function($) {

    'use strict';

    $(function() {

        var Table = $('#tabla_planes').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en usuarios",
                infoEmpty: "Mostrando 0 a 0 de 0 en usuarios",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/planes.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                dataSrc: function(json) {
                    var data = json
                    $("#planes_count").text(data.length)
                    console.log(data);
                    return data;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {

            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_plan",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "nombre"
                },
                {
                    "data": "sector"
                },
                {
                    "data": "importe",
                    "render": function(data, type, row, meta) {
                        return data + '€';
                    }
                },
                {
                    "data": "total_ingresado",
                    "render": function(data, type, row, meta) {
                        return data + '€';
                    }
                },
                {
                    "data": "falta_ingresar",
                    "render": function(data, type, row, meta) {
                        return data + '€';
                    }
                },
                {
                    "data": "fecha"
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonIngresos = document.createElement('button');
                        buttonIngresos.className = 'btn_ingresos p-1 dropdown-item';
                        buttonIngresos.setAttribute('type', 'button');
                        buttonIngresos.setAttribute('data-id', data.id_plan);
                        buttonIngresos.innerHTML = `
                    <lord-icon src="./assets/lordicons/pay.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Ingresos
                    
                `;
                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_editar_plan p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data.id_plan);
                        buttonEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;
                        var buttonFotos = document.createElement('button');
                        buttonFotos.className = 'btn_modal_archivos p-1 dropdown-item';
                        buttonFotos.setAttribute('type', 'button');
                        buttonFotos.setAttribute('data-id', data.id_plan);
                        buttonFotos.innerHTML = `
                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Archivos
                    
                `;
                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className = 'btn_eliminar_plan p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data.id_plan);
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;

                        dropdownMenu.appendChild(buttonFotos);
                        dropdownMenu.appendChild(buttonIngresos);
                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        });

        var config = {
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en usuarios",
                infoEmpty: "Mostrando 0 a 0 de 0 en usuarios",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "columnDefs": [{
                "targets": 3, // Índice de la columna (0 para la primera columna)
                "className": "long_text" // La clase CSS que deseas agregar
            }],
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/planes.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                dataSrc: function(json) {
                    var data = json
                    console.log(data);
                    $("#monto_total").text(data.importe + "€")
                    $("#total_ingresado").text(data.total_ingresado + "€")
                    $("#falta_ingresar").text(data.falta_ingresar + "€")
                    $("#btn_agregar_ingreso").data("importe", data.importe);
                    Table.ajax.reload(null, false);
                    return data.ingresos;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {

            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_ingreso_plan",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "monto",
                    "render": function(data, type, row, meta) {
                        return data + '€';
                    }
                },
                {
                    "data": "fecha"
                },
                {
                    "data": "observaciones",
                    "render": function(data, type, row, meta) {
                        return '<span>' +
                            data + '</span>';
                    }
                },
                {
                    "data": "id_ingreso_plan",
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        /* 
                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_editar_ingreso p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data);
                        buttonEditar.innerHTML = `
                        <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                        Editar
                        
                    `;*/

                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className = 'btn_eliminar_ingreso p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data);
                        buttonEliminar.innerHTML = `
                        <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                        Eliminar
                    `;



                        // dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        }

        var Table2;
        $("#fecha").val(moment().format('YYYY-MM-DD'))
        $("#fecha_ingreso").val(moment().format('YYYY-MM-DD HH:mm:ss'))




        $("#btn_agregar_ingreso").click(function() {

            var object = {
                fecha: moment($('#fecha_ingreso').val()).format('YYYY-MM-DD HH:mm:ss'),
                monto: $("#monto_ingreso").val(),
                observaciones: ($("#observaciones_ingreso").val() != "") ? $(
                    "#observaciones_ingreso").val() : null,
                id_plan: $(this).data("id")

            }
            if (Table2.column(1).data().length > 0) {
                ;
                var total = Table2.column(1).data().reduce(function(a, b) {
                    return parseFloat(parseFloat(a) + parseFloat(b));
                })
            } else {
                total = 0;
            }
            var monto = parseFloat(object.monto)
            var importe = parseFloat($("#btn_agregar_ingreso").data("importe"))

            console.log("Monto a sumar: " + parseFloat(total + monto));
            console.log("Importe total: " + importe);
            if (importe < parseFloat(total + monto)) {
                $.toast({
                    heading: 'Por favor ingresa un monto válido.',
                    text: 'Ingresa un monto menor o igual a ' + parseFloat(importe -
                        total).toFixed(2) + "€",
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#monto").focus()
                return false;
            }


            if (object.monto == "") {
                $.toast({
                    heading: 'Por favor ingresa un monto.',
                    text: 'No se ha ingresado ningun monto al ingreso.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#monto").focus()
                return false;
            }
            console.log(object);
            $("#btn_agregar_ingreso").attr("disabled", true);
            $("#btn_agregar_ingreso").addClass("btn-loading");



            $.ajax({
                type: 'POST',
                url: './api/planes.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    fecha: object.fecha,
                    monto: object.monto,
                    observaciones: object.observaciones,
                    id_plan: object.id_plan
                },
                success: function(r) {
                    console.log(r);
                    if (r != 0) {
                        $.toast({
                            heading: 'Ingreso agregado',
                            text: 'Se ha agregado el ingreso correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 4
                        })
                        if ($.fn.DataTable.isDataTable('#tabla_ingresos')) {
                            // Destruir la instancia de DataTable
                            $('#tabla_ingresos').DataTable().destroy();
                        }

                        Table2 = $('#tabla_ingresos').DataTable(config);
                        var url = "/api/planes.php?id_plan=" + object.id_plan
                        Table2.ajax.url(url).load();

                    } else {
                        $.toast({
                            heading: 'Cantidad máxima de ingresos alcanzada.',
                            text: 'Elimina un ingreso existente y vuelve a intentar.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                    }
                    $("#btn_agregar_ingreso").attr("disabled", false);
                    $("#btn_agregar_ingreso").removeClass("btn-loading");

                }

            });

        })
        $("#btn_agregar_plan").click(function() {

            var nombre = $("#nombre").val()
            var id_sector = ($("#id_sector").val() != "No") ? $("#id_sector").val() : null
            var importe = $("#importe").val()
            var fecha = moment($('#fecha').val()).format('YYYY-MM-DD')
            if (nombre == "") {
                $.toast({
                    heading: 'Por favor ingresa un nombre.',
                    text: 'No se ha ingresado ningun nombre al plan.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#nombre").focus()
                return false;
            }
            if (importe == "") {
                $.toast({
                    heading: 'Por favor ingresa un importe.',
                    text: 'No se ha ingresado ningun importe al plan.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#importe").focus()
                return false;
            }
            $("#btn_agregar_plan").attr("disabled", true);
            $("#btn_agregar_plan").addClass("btn-loading");



            $.ajax({
                type: 'POST',
                url: './api/planes.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre,
                    id_sector: id_sector,
                    importe: importe,
                    fecha: fecha
                },
                success: function(r) {
                    console.log(r);
                    $.toast({
                        heading: 'Plan creado',
                        text: 'Se ha creado el plan correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                    Table.ajax.reload(null, false);
                    $("#btn_agregar_plan").attr("disabled", false);
                    $("#btn_agregar_plan").removeClass("btn-loading");
                    $("#modalAgregarPlan").modal("hide")
                }

            });
        })
        $("#btn_editar_plan").click(function() {

            var nombre = $("#nombre_editar").val()
            var id_sector = ($("#id_sector_editar").val() != "No") ? $("#id_sector_editar").val() :
                null
            var importe = $("#importe_editar").val()
            var fecha = moment($('#fecha_editar').val()).format('YYYY-MM-DD HH:mm:ss')
            var id_plan = $("#btn_editar_plan").data("id")
            if (nombre == "") {
                $.toast({
                    heading: 'Por favor ingresa un nombre.',
                    text: 'No se ha ingresado ningun nombre al plan.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#nombre_editar").focus()
                return false;
            }
            if (importe == "") {
                $.toast({
                    heading: 'Por favor ingresa un importe.',
                    text: 'No se ha ingresado ningun importe al plan.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#importe_editar").focus()
                return false;
            }
            $("#btn_editar_plan").attr("disabled", true);
            $("#btn_editar_plan").addClass("btn-loading");



            $.ajax({
                type: 'POST',
                url: './api/planes.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre,
                    id_sector: id_sector,
                    importe: importe,
                    fecha: fecha,
                    id_plan: id_plan
                },
                success: function(r) {
                    console.log(r);
                    $.toast({
                        heading: 'Plan editado',
                        text: 'Se ha editado el plan correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                    Table.ajax.reload(null, false);
                    $("#btn_editar_plan").attr("disabled", false);
                    $("#btn_editar_plan").removeClass("btn-loading");
                    $("#modalEditarPlan").modal("hide")
                }

            });
        })

        $(document).on("click", ".btn_editar_plan", function(event) {
            var id = $(this).data("id")
            $("#btn_editar_plan").data("id", id);

            $.ajax({
                url: './api/planes.php?id_plan=' + id,
                type: 'GET',
                async: false,
                cache: false,
                dataType: 'json', // added data type
                success: function(result) {
                    console.log(result);

                    if (result.id_sector != null) {
                        $("#id_sector_editar").val(result.id_sector)
                            .trigger("change")
                    } else {
                        $("#id_sector_editar").val("No").trigger("change")
                    }
                    $("#nombre_editar").val(result.nombre)
                    $("#importe_editar").val(result.importe)
                    $("#fecha_editar").val(result.fecha)
                    $('#modalEditarPlan').modal('show')
                }
            });



        })

        $(document).on("click", ".btn_eliminar_ingreso", function(event) {
            var id = $(this).data("id")
            $("#btn_eliminar_ingreso").data("id", id);

            $("#modalEliminarIngreso").modal("show")
        })
        $('#btn_eliminar_ingreso').click(function(event) {

            var id_ingreso_eliminar = $("#btn_eliminar_ingreso").data("id")
            var id_plan = $("#btn_agregar_ingreso").data("id")

            $.ajax({
                type: 'DELETE',
                url: './api/planes.php?id_ingreso_eliminar=' + id_ingreso_eliminar,
                async: false,
                cache: false,
                success: function(result) {


                    $.toast({
                        heading: 'Ingreso eliminado',
                        text: 'Se ha eliminado el ingreso correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })


                    $('#modalEliminarIngreso').modal('hide');

                    if ($.fn.DataTable.isDataTable('#tabla_ingresos')) {
                        // Destruir la instancia de DataTable
                        $('#tabla_ingresos').DataTable().destroy();
                    }

                    Table2 = $('#tabla_ingresos').DataTable(config);
                    var url = "/api/planes.php?id_plan=" + id_plan
                    Table2.ajax.url(url).load();
                }
            });

            return false;
        });
        $(document).on("click", ".btn_eliminar_plan", function(event) {
            var id = $(this).data("id")
            $("#btn_eliminar_plan").data("id", id);
            $("#modalEliminarPlan").modal("show")
        })
        $(document).on("click", ".btn_ingresos", function(event) {
            var id = $(this).data("id")
            $("#btn_agregar_ingreso").data("id", id);
            if ($.fn.DataTable.isDataTable('#tabla_ingresos')) {
                // Destruir la instancia de DataTable
                $('#tabla_ingresos').DataTable().destroy();
            }

            Table2 = $('#tabla_ingresos').DataTable(config);
            var url = "/api/planes.php?id_plan=" + id
            Table2.ajax.url(url).load();




            $("#modalIngresos").modal("show")
        })
        $('#btn_eliminar_plan').click(function(event) {

            var id_plan_eliminar = $("#btn_eliminar_plan").data("id")


            $.ajax({
                type: 'DELETE',
                url: './api/planes.php?id=' + id_plan_eliminar,
                async: false,
                cache: false,
                success: function(result) {


                    $.toast({
                        heading: 'Plan eliminado',
                        text: 'Se ha eliminado el plan correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })


                    $('#modalEliminarPlan').modal('hide');

                    Table.ajax.reload(null, false);


                }
            });

            return false;
        });
    });

})(jQuery);
</script>


<script>
$("#archivo_file").change(function(e) {
    var archivo = $('#archivo_file')[0].files[0];

    $("#archivo_archivo").val(archivo.name)

});
$("#btn_add_archivo").click(function() {

    var archivo = $('#archivo_file')[0].files[0];
    var id_alumno = $('#btn_subir_archivo').data("id")

    var nombre = $("#nombre_archivo").val();
    if (!archivo) {
        $.toast({
            heading: 'Ningún archivo seleccionado.',
            text: 'Por favor, selecciona un archivo para subir.',
            position: 'top-right',
            loaderBg: '#ff5c6c',
            icon: 'error',
            hideAfter: 5000,
            stack: 6
        });
        return false
    }

    if (nombre == "") {
        $.toast({
            heading: 'Ningún nombre seleccionado.',
            text: 'Por favor, agrega un nombre al archivo para subir.',
            position: 'top-right',
            loaderBg: '#ff5c6c',
            icon: 'error',
            hideAfter: 5000,
            stack: 6
        });
        return false
    }
    var extension = archivo.type.split('/').pop();
    if (extension == "jpeg") {
        extension = "jpg"
    }

    if (archivo.size > 3000000) {
        $.toast({
            heading: 'Archivo demasiado pesado.',
            text: 'El archivo debe pesar menos 3 MB.',
            position: 'top-right',
            loaderBg: '#ff5c6c',
            icon: 'error',
            hideAfter: 5000,
            stack: 6
        });
        return false
    }
    var fd = new FormData();
    fd.append('archivo', archivo);
    fd.append('extension', extension);
    fd.append('nombre', nombre);
    fd.append('id_plan_archivo', id_alumno);

    var contenedor = document.getElementById('lista_archivos');
    var divElement = document.createElement('div');
    divElement.classList.add('col-sm-3', 'p-2', 'd-flex',
        'justify-content-center', 'align-items-center');

    // Crear un elemento div para la clase "archivo_lista"
    var archivoListaDiv = document.createElement('div');
    archivoListaDiv.classList.add('archivo_lista', 'd-flex',
        'justify-content-center', 'align-items-center');

    var imgElement = document.createElement('img');
    imgElement.classList.add('img-fluid');
    imgElement.setAttribute('alt', '');
    imgElement.setAttribute('src', './assets/images/oval.svg');
    // Agregar elementos al div "archivo_lista"
    archivoListaDiv.appendChild(imgElement);

    divElement.appendChild(archivoListaDiv);
    // Agregar el div "archivo_lista" al div principal

    contenedor.insertAdjacentElement('afterbegin', divElement);


    $.ajax({
        url: './api/planes.php',
        type: 'POST',
        data: fd,
        async: false,
        cache: false,
        processData: false, // tell jQuery not to process the data
        contentType: false, // tell jQuery not to set contentType
        success: function(result) {
            console.log(result);
            if (result == "0") {
                $.toast({
                    heading: 'Nombre repetido.',
                    text: 'Selecciona otro nombre para el archivo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                divElement.remove()
                return false
            } else

            {

                CargarArchivos(id_alumno)
                $.toast({
                    heading: 'Nuevo archivo subido.',
                    text: 'Se subido el nuevo archivo correctamente.',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 4
                })
            }
        }
    });

});

function CargarArchivos(id_alumno) {
    var contenedor = document.getElementById('lista_archivos');
    contenedor.innerHTML = ""
    $.ajax({
        url: './api/planes.php?id_plan_archivos=' + id_alumno,
        type: 'GET',
        cache: false,
        async: false,
        dataType: 'json', // added data type
        success: function(result) {
            console.log(result);
            for (let r of result) {
                r.url = r.url.slice(1)
                console.log(r);
                var divElement = document.createElement('div');
                divElement.classList.add('col-sm-3', 'p-2', 'd-flex',
                    'justify-content-center', 'align-items-center');

                // Crear un elemento div para la clase "archivo_lista"
                var archivoListaDiv = document.createElement('div');
                archivoListaDiv.classList.add('archivo_lista', 'd-flex',
                    'justify-content-center', 'align-items-center');

                if (r.extension != "pdf") {
                    // Crear un elemento img
                    var imgElement = document.createElement('img');
                    imgElement.classList.add('img-fluid');
                    imgElement.setAttribute('alt', '');
                    imgElement.setAttribute('src', r.url);
                } else {
                    var iframe = document.createElement('iframe');

                    iframe.setAttribute('src', r.url);
                    iframe.style.width = "100%";
                    iframe.style.height = "100%";

                }


                // Crear un botón para eliminar
                var btnEliminar = document.createElement('button');
                btnEliminar.classList.add('p-1', 'btn_eliminar_archivo', 'btn');
                btnEliminar.setAttribute('data-url', r.url);
                btnEliminar.setAttribute('data-id', id_alumno);
                btnEliminar.setAttribute('type', 'button');
                btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';

                // Crear un botón para seleccionar
                var btnSeleccionar = document.createElement('button');
                btnSeleccionar.classList.add('p-1', 'btn_seleccionar_archivo',
                    'btn');
                btnSeleccionar.setAttribute('data-url', r.url);
                btnSeleccionar.setAttribute('data-extension', r.extension);
                btnSeleccionar.setAttribute('type', 'button');
                btnSeleccionar.innerHTML = '<i class="m-0 fa fa-eye"></i>';




                var nombre = document.createElement('a');
                nombre.textContent = r.nombre
                nombre.setAttribute('data-nombre', r.nombre);
                nombre.setAttribute('data-url', r.url);
                nombre.setAttribute('data-extension', r.extension);
                nombre.classList.add("nombre_archivo_div")
                nombre.innerHTML += '<i class="ml-2 fa fa-download"></i>';
                // Agregar elementos al div "archivo_lista"
                if (r.extension != "pdf") {
                    // Crear un elemento img
                    archivoListaDiv.appendChild(imgElement);

                } else {
                    archivoListaDiv.appendChild(iframe);

                }
                archivoListaDiv.appendChild(btnEliminar);
                archivoListaDiv.appendChild(btnSeleccionar);

                // Agregar el div "archivo_lista" al div principal
                divElement.appendChild(archivoListaDiv);

                divElement.appendChild(nombre);
                contenedor.appendChild(divElement);

            }
        }
    })

}
$(document).on("click", ".btn_modal_archivos", function() {


    $('#btn_subir_archivo').data("id", $(this).data("id"))
    CargarArchivos($(this).data("id"))

    $("#modalSubirArchivo").modal("show");
});

$(document).on("click", ".btn_seleccionar_archivo", function() {
    var url = $(this).data("url");
    var extension = $(this).data("extension");
    var div = document.getElementById("contenedor_archivo")
    div.innerHTML = ""
    if (extension !== "pdf") {
        // Crear un elemento <img>


        var imgElement = document.createElement("img");

        // Establecer los atributos del elemento <img>
        imgElement.id = "archivo_modal";
        imgElement.className = "w-100 img-fluid";
        imgElement.src = url; // Aquí establece la fuente de la imagen que desees
        imgElement.alt = "";

        // Agregar el elemento <img> al documento
        div.appendChild(imgElement);
    } else {
        var iframe = document.createElement('iframe');
        iframe.setAttribute('id', 'archivo_modal');
        iframe.setAttribute('src', url);
        iframe.style.width = "100%"
        iframe.style.height = "400px"
        div.appendChild(iframe);
    }



    $("#modalVerArchivo").modal("show");


});
$(document).on("click", ".nombre_archivo_div", function() {
    var nombre = $(this).data("nombre");
    var url = $(this).data("url");
    var extension = $(this).data("extension");

    $(this).attr("download", nombre)
    $(this).attr("href", url)
});
$(document).on("click", ".btn_eliminar_archivo", function() {
    var id = $(this).data("id");
    var url = $(this).data("url");


    $.ajax({
        type: "DELETE",
        url: "./api/planes.php?url=" + url,
        cache: false,
        async: false,
        success: function(response) {
            console.log(response);
            CargarArchivos(id)
            $.toast({
                heading: 'Archivo eliminado.',
                text: 'Se eliminado el archivo correctamente.',
                position: 'top-right',
                loaderBg: '#32a852',
                icon: 'success',
                hideAfter: 2000,
                stack: 4
            })
        }

    })
});
</script>