<div class="content-wrapper">

    <div class="container-fluid p-0">

        <div class="row">

            <div class="col-12">

                <div class="card p-3 p-sm-4">

                    <ul class="nav nav-tabs" role="tablist">



                        <li class="nav-item"> <a id="tab_menu" class="flex-column align-items-center nav-link active"
                                data-toggle="tab" href="#menu" role="tab"><span class="hidden-sm-up">

                                    <lord-icon class="sidebar-menu-icon" src="https://cdn.lordicon.com/zlphstwx.json"
                                        trigger="hover"
                                        colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                        style="width:40px;height:40px">

                                    </lord-icon>

                                </span> <span class="hidden-xs-down">Menú</span></a>

                        </li>





                        <li class="nav-item"> <a id="tab_logs" class="flex-column align-items-center nav-link"
                                data-toggle="tab" href="#logs" role="tab"><span class="hidden-sm-up">

                                    <lord-icon class="sidebar-menu-icon" src="https://cdn.lordicon.com/ocpunbms.json"
                                        trigger="hover"
                                        colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                        style="width:40px;height:40px">

                                    </lord-icon>

                                </span> <span class="hidden-xs-down">Logs</span></a>

                        </li>



                    </ul>

                    <div class="tab-content tabcontent-border">





                        <div class="tab-pane active" id="menu" role="tabpanel">

                            <div class="table-responsive pt-4">





                                <h4>Menu principal</h4>

                                <table id="tabla_links" class="display" style="width:100%">

                                    <thead>



                                        <th style="padding-left: 32px !important;padding-right: 50px !important;">Orden

                                        </th>

                                        <th>Nombre menú</th>

                                        <th>Nombre visible</th>

                                        <th>Visible/oculto</th>
                                        <th>Eliminar</th>

                                    </thead>

                                    <tbody>



                                        <?php

                                        $menu = json_decode(file_get_contents('menu.json'), true);

                                        usort($menu['elementos'], function ($a, $b) {

                                            return $a['orden'] <=> $b['orden'];

                                        });

                                        foreach ($menu['elementos'] as $Elemento) {

if($Elemento["bloqueado"] == false){

                                        ?>



                                        <tr>

                                            <td class="td-tablet">



                                                <?php echo htmlentities($Elemento['orden'], ENT_QUOTES); ?>







                                            </td>



                                            <td class="td-id">



                                                <?php echo htmlentities($Elemento['nombre'], ENT_QUOTES); ?>



                                            </td>



                                            <td class="td-tablet">



                                                <input class="form-control nombre_menu_editar"
                                                    data-nombre="<?php echo htmlentities($Elemento['nombre'], ENT_QUOTES); ?>"
                                                    value="<?php echo htmlentities($Elemento['nombre_visible'], ENT_QUOTES); ?>"
                                                    type="text" name="">





                                            </td>

                                            <td class="td">





                                                <label class="m-0 custom-checkbox visible_oculto">

                                                    <input type="checkbox"
                                                        data-nombre="<?php echo htmlentities($Elemento['nombre'], ENT_QUOTES); ?>" <?php

                                                            if ($Elemento['visible'] == true) {

                                                                echo "checked";

                                                            }



                                                            ?>>

                                                    <span class="checkmark"></span>

                                                </label>



                                            </td>
                                            <td class="td d-flex flex-column align-items-start">



                                                <button class="btn_eliminar_link btn btn-danger"
                                                    data-nombre="<?php echo htmlentities($Elemento['nombre'], ENT_QUOTES); ?>"
                                                    type="button">Eliminar</button>
                                                <?php if($Elemento['tabla'] != false){ ?>
                                                <button class="btn_vaciar_tabla btn btn-primary mt-2"
                                                    data-tabla="<?php echo htmlentities($Elemento['tabla'], ENT_QUOTES); ?>"
                                                    type="button">Vaciar</button>

                                                <?php } ?>
                                            </td>


                                            <?php }} ?>

                                    </tbody>

                                </table>

                                <h4>Submenu</h4>



                                <table id="tabla_submenu" class="display" style="width:100%">

                                    <thead>





                                    </thead>

                                    <tbody>

                                    </tbody>

                                </table>





                            </div>

                        </div>

                        <div class="tab-pane" id="general" role="tabpanel">







                        </div>



                        <div class="tab-pane" id="logs" role="tabpanel">

                            <div class="row pt-4">



                                <div class="col-12 mb-3 mb-sm-4">

                                    <button class="btn btn-primary" data-toggle="modal" data-target="#modalAgregarLog"
                                        id="" type="button">Agregar log</button>

                                    <button type="button" id="btn_descargar_excel_logs"
                                        class="btn btn-sm btn-info">Descargar

                                        excel</button>

                                </div>

                                <div class="col-12">

                                    <div class="table-responsive">

                                        <table id="tabla_logs" class="table">



                                            <thead class="cuenta-table-head"> 

                                                <tr>
                                                    <th class=""><?php echo _("ID") ?></th>
                                                    <th class=""><?php echo _("Usuario") ?></th>

                                                    <th class=""><?php echo _("Fecha") ?></th>

                                                    <th class=""><?php echo _("Navegador") ?></th>

                                                    <th class=""><?php echo _("Dirección IP") ?></th>



                                                    <th class=""><?php echo _("Localización") ?></th>



                                                    <th class=""><?php echo _("Resultado") ?></th>

                                                    <th class=""><?php echo _("Acciones") ?></th>

                                                </tr>

                                            </thead>

                                            <tbody class="cuenta-table-body">



                                            </tbody>



                                        </table>

                                    </div>

                                </div>

                            </div>

                        </div>






                    </div>

                </div>

            </div>

        </div>

    </div>

</div>



</div>

<div class="modal fade" id="modalEditarLink" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered modal-sm" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0"> Editar apartado menu</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>



            <form method="POST" id="form_editar_link" action="">



                <div class="modal-body pb-0">



                    <div class="container p-0">



                        <div class="row">



                            <div class="col-12">

                                <div class="form-group">

                                    <label for="my-input">Nombre</label>

                                    <input id="nombre_link" class="form-control" name="nombre_link" type="text"
                                        readonly>

                                </div>



                            </div>



                            <div class="col-12">

                                <div class="form-group">

                                    <label for="my-input">Nombre Visible</label>

                                    <input id="nombre_visible_link" class="form-control" name="nombre_visible_link"
                                        type="text">

                                </div>



                            </div>

                            <div class="col-12">

                                <div class="d-flex align-items-center">

                                    <input id="visible_link" name="visible_link" class="m-0 form-check-input"
                                        type="checkbox">

                                    <label for="visible_link" class="ml-3 form-check-label">Visible</label>

                                </div>

                            </div>









                        </div>



                    </div>







                </div>



                <div class="modal-footer text-right">







                    <button class="btn btn-success btn-fw" type="submit" id="">



                        Editar</button>



                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                        Cancelar </button>











                </div>



            </form>



            <!-- /modal-body -->



        </div>



    </div>



</div>



<div class="modal fade" id="modalAgregarLog" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar Log</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>







            <div class="modal-body pb-0">



                <div class="container-fluid p-0">

                    <div class="row">

                        <div class="col-11">

                        </div>

                        <div class="col-1">

                            <div class="row">



                                <div class="col-12 d-flex justify-content-center align-items-center">





                                    <label class="custom-control custom-checkbox d-inline-block m-0">

                                        <input type="checkbox" id="habilitar_todos" class="custom-control-input">

                                        <span class="custom-control-label"></span>

                                    </label>







                                </div>









                            </div>









                        </div>

                    </div>

                    <?php

                    for ($i = 0; $i < 10; $i++) {

                    ?>

                    <div class="row login_row">





                        <div class="col-2">



                            <div class="form-group">







                                <label>Responsable</label>







                                <select name="login_user"
                                    class="login_user form-control custom-select text-center select2">

                                    <?php



                                        foreach ($User_List as $User) {

                                        ?>

                                    <option type="text"
                                        value="<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>">

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>

                                    <?php



                                        }

                                        ?>

                                </select>







                            </div>



                        </div>

                        <div class="col-2">

                            <div class="form-group">

                                <label>IP</label>



                                <input type="text" class="login_ip form-control" name="login_ip"
                                    placeholder="xxx.xxx.xxx.xxx" />

                            </div>

                        </div>



                        <div class="col-2">

                            <div class="form-group">

                                <label>Fecha</label>

                                <input type="datetime-local" class="login_date form-control" name="login_date"
                                    placeholder="" required>

                            </div>

                        </div>

                        <div class="col-1">

                            <div class="form-group">

                                <label>Exitoso</label>

                                <label class="custom-control custom-checkbox d-inline-block m-0">

                                    <input type="checkbox" name="login_success"
                                        class="login_success custom-control-input">

                                    <span class="custom-control-label"></span>

                                </label>



                            </div>

                        </div>

                        <div class="col-4">

                            <div class="form-group">



                                <label>Navegador</label>





                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_navegador file-upload-browse btn btn-danger"
                                            data-target="select_navegadores_<?php echo $i ?>" type="button">-</button>

                                    </span>

                                    <select id="select_navegadores_<?php echo $i ?>" name="login_agent"
                                        class="login_agent select_navegadores custom-select select2 form-control">



                                        <?php

                                            foreach ($Navegadores as $Navegador) {

                                            ?>

                                        <option value="<?php echo $Navegador['id_navegador']; ?>"><?php

                                                                                                            echo $Navegador['nombre'];

                                                                                                            ?></option>

                                        <?php

                                            }

                                            ?>

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarNavegador">+</button>

                                    </span>

                                </div>



                            </div>

                        </div>

                        <div class="col-1 d-flex justify-content-center align-items-center">





                            <label class="custom-control custom-checkbox d-inline-block m-0">

                                <input type="checkbox" class="habilitado_log custom-control-input">

                                <span class="custom-control-label"></span>

                            </label>







                        </div>







                    </div>

                    <?php } ?>





                </div>







            </div>



            <div style="margin-top:15px;" class="modal-footer text-right">







                <button class="btn btn-success btn-fw" id="btn_add_log" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>





            <!-- /modal-body -->



        </div>



    </div>



</div>







<div class="modal fade" id="modalVerCorreo" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">



        <div class="modal-content ">



            <div class="modal-header border-none">



                <h4 class="mb-0"> Visualizar correo</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>



            <div class="modal-body pb-0" id="ver-correo-body">







            </div>



        </div>



    </div>



</div>






<div class="modal fade modal-cambiar" id="modalEliminarLog" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el log definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button id="btn_eliminar_log" class="btn btn-danger btn-fw" type="button" name="">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalEliminarLink" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar elemento definitivamente</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Ingrese contraseña de administrador (esta acción no se puede
                                    deshacer)</label>
                                <div class="input-group show_hide_password">

                                    <input data-nombre="admin_password" id="admin_password" class="form-control"
                                        type="password">

                                    <div class="input-group-append">

                                        <span class="input-group-text btn btn-secondary"><i class="m-0 fa fa-eye-slash"
                                                aria-hidden="true"></i></span>

                                    </div>

                                </div>
                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_eliminar_link" class="btn btn-danger btn-fw" type="button">

                    Eliminar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalEliminarTabla" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Vaciar la tabla <span id="nombre_tabla"></span></h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Ingrese contraseña de administrador (esta acción no se puede
                                    deshacer)</label>
                                <div class="input-group show_hide_password">

                                    <input data-nombre="admin_password2" id="admin_password2" class="form-control"
                                        type="password">

                                    <div class="input-group-append">

                                        <span class="input-group-text btn btn-secondary"><i class="m-0 fa fa-eye-slash"
                                                aria-hidden="true"></i></span>

                                    </div>

                                </div>
                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_vaciar_tabla" class="btn btn-danger btn-fw" type="button">

                    Vaciar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalEliminarSubLink" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar elemento definitivamente</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Ingrese contraseña de administrador (esta acción no se puede
                                    deshacer)</label>
                                <div class="input-group show_hide_password">

                                    <input data-nombre="admin_password2" id="admin_password2" class="form-control"
                                        type="password">

                                    <div class="input-group-append">

                                        <span class="input-group-text btn btn-secondary"><i class="m-0 fa fa-eye-slash"
                                                aria-hidden="true"></i></span>

                                    </div>

                                </div>
                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_eliminar_sublink" class="btn btn-danger btn-fw" type="button">

                    Eliminar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<style>
#img_portada,

#img_admision {

    object-fit: contain;

    width: 100%;

    object-position: top;

}





#img_logo_portada,

#img_logo_superior {

    aspect-ratio: 1/1;

    object-fit: contain;

    width: 100%;

    object-position: top;

}



#img_fav_icon {

    aspect-ratio: 1/1;

    height: 100%;

    width: 100%;

}



#img_logo_portada,

#img_logo_superior {

    aspect-ratio: 512/68;

}



.asColorPicker-trigger {

    padding: 0px;

    width: 34px;

    height: 34px;

    border: none;

}



.asColorPicker-trigger span {

    width: 34px;

    height: 34px;

}



.dataTables_wrapper tbody td:first-child {

    cursor: grabbing;

}



.dataTables_wrapper tbody td:not(:first-child) {

    cursor: pointer;

}





.visible_oculto_submenu,

.visible_oculto {

    position: relative;

    display: inline-block;

    vertical-align: middle;



    width: 20px;

    height: 20px;

    cursor: pointer;

}



.visible_oculto_submenu input,

.visible_oculto input {

    position: absolute;

    opacity: 0;

    cursor: pointer;

}



.checkmark {

    position: absolute;

    top: 0;

    left: 0;

    width: 100%;

    height: 100%;

    display: flex;

    justify-content: center;

    align-items: center;

    font-size: 18px;

}



.select2-container {

    width: 160px !important;

}



.visible_oculto_submenu input:checked~.checkmark:after,

.visible_oculto input:checked~.checkmark:after {

    content: '\f06e';

    /* Icono de ojo */

    font-family: 'Font Awesome 5 Free';

    font-weight: 900;

    color: #000;

}



.visible_oculto_submenu input:not(:checked)~.checkmark:after,

.visible_oculto input:not(:checked)~.checkmark:after {

    content: '\f070';

    /* Icono de ojo tachado */

    font-family: 'Font Awesome 5 Free';

    font-weight: 900;

    color: #000;

}
</style>



<?php require_once __VIEWS__ . 'selects/navegadores.template.php'; ?>

<script>
$(document).on('click', '.btn_editar_link', function() {

    $("#nombre_link").val($(this).data("nombre"));

    $("#nombre_visible_link").val($(this).data("nombrevisible"));

    console.log($(this).data("display"));

    if ($(this).data("display") == "flex") {



        $("#visible_link").prop("checked", true)

    }



    $("#modalEditarLink").modal("show")





});



$("#form_editar_link").submit(function() {

    var nombre_link = $("#nombre_link").val();

    var nombre_visible_link = $("#nombre_visible_link").val();

    var visible_link;

    if ($("#visible_link").is(':checked')) {

        visible_link = "flex"

    } else {

        visible_link = "none"

    }



    $.ajax({

        type: 'POST',

        url: './personalizacion',

        cache: false,

        data: {

            nombre_link: nombre_link,

            nombre_visible_link: nombre_visible_link,

            visible_link: visible_link

        },

        success: function(result) {

            console.log(result);

            $('#modalEditarLink').modal('hide');

            $.toast({

                heading: 'Link editado',

                text: 'Se ha editado el link correctamente',

                position: 'top-right',

                loaderBg: '#32a852',

                icon: 'success',

                hideAfter: 2000,

                stack: 6

            });

            setTimeout(function() {





                window.location.href = './personalizacion?menutab=1';

            }, 2000);

        }

    });



    return false;



})
</script>



<?php



if (isset($SesionTab) && $SesionTab === 1) {



?>

<script>
(function($) {



    'use strict';



    $(function() {

        $('#tab_sesion').click()

    });



})(jQuery);
</script>

<?php



}

?>

<?php



if (isset($_GET["tab_copias"])) {



?>

<script>
(function($) {



    'use strict';



    $(function() {

        $('#tab_copias').click()

    });



})(jQuery);
</script>

<?php



}

?>

<?php



if (isset($IntranetTab) && $IntranetTab === 1) {



?>

<script>
(function($) {



    'use strict';



    $(function() {

        $('#tab_intranet').click()

    });



})(jQuery);
</script>

<?php



}

?>

<?php



if (isset($MenuTab) && $MenuTab === 1) {



?>

<script>
(function($) {



    'use strict';



    $(function() {

        $('#tab_menu').click()

    });



})(jQuery);
</script>

<?php



}

?>

<?php



if (isset($GeneralTab) && $GeneralTab == 1) {



?>

<script>
(function($) {



    'use strict';



    $(function() {

        $('#tab_general').click()

    });



})(jQuery);
</script>

<?php



}

?>

<?php



if (isset($_GET["tablogs"])) {



?>

<script>
(function($) {



    'use strict';



    $(function() {



        $('#tab_logs').click()

    });



})(jQuery);
</script>

<?php



}

?>





<script>
function showEmail(body) {

    $.ajax({

        type: 'GET',

        url: './api/personalizacion.php',

        cache: false,

        data: {

            id_mailing: body,

        },

        success: function(result) {

            result = JSON.parse(result);

            $("#ver-correo-body").html(result.body);

            $("#modalVerCorreo").modal("show")

        }

    });

}



(function($) {



    'use strict';



    $(function() {


        $(document).on('click', ".btn_eliminar_sublink", function(event) {

            $("#btn_eliminar_sublink").data("padre", $(this).data("padre"));
            $("#btn_eliminar_sublink").data("nombre", $(this).data("nombre"));
            $("#modalEliminarSubLink").modal("show")

        });


        $(document).on('click', ".btn_eliminar_link", function(event) {

            $("#btn_eliminar_link").data("nombre", $(this).data("nombre"));

            $("#modalEliminarLink").modal("show")

        });
        $(document).on('click', ".btn_vaciar_tabla", function(event) {
            $("#nombre_tabla").text($(this).data("tabla"))
            $("#btn_vaciar_tabla").data("tabla", $(this).data("tabla"));

            $("#modalEliminarTabla").modal("show")

        });
        $("#btn_vaciar_tabla").click(function(e) {
            var tabla = $(this).data("tabla")
            var password = $("#admin_password2").val()
            var password1 =
                "<?php echo htmlentities($personalizacion['password_admin'], ENT_QUOTES); ?>"
            if (password == password1) {
                $.ajax({

                    type: 'POST',

                    url: './api/menu.php',

                    cache: false,
                    dataType: 'json',

                    data: {

                        tabla_vaciar: tabla

                    },

                    success: function(result) {

                        console.log(result);

                        $('#modalVaciarTabla').modal('hide');

                        $.toast({

                            heading: 'Tabla vaciada',

                            text: 'Se ha vaciado la tabla correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                        setTimeout(function() {





                            //window.location.href = './personalizacion?menutab=1';

                        }, 2000);

                    }

                });





            } else {
                $.toast({

                    heading: 'Contraseña incorrecta',

                    text: 'Para vaciar esta tabla debes ingresar la contraseña de administrador.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'error',

                    hideAfter: 4000,

                    stack: 6

                });

                return false;

            }
        });
        $("#btn_eliminar_link").click(function(e) {
            var nombre = $(this).data("nombre")
            var password = $("#admin_password").val()
            var password1 =
                "<?php echo htmlentities($personalizacion['password_admin'], ENT_QUOTES); ?>"
            if (password == password1) {
                $.ajax({

                    type: 'POST',

                    url: './api/menu.php',

                    cache: false,
                    dataType: 'json',

                    data: {

                        nombre_link_bloquear: nombre

                    },

                    success: function(result) {

                        console.log(result);

                        $('#modalEditarLink').modal('hide');

                        $.toast({

                            heading: 'Link eliminado',

                            text: 'Se ha eliminado el link correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                        setTimeout(function() {





                            window.location.href =
                                './personalizacion?menutab=1';

                        }, 2000);

                    }

                });





            } else {
                $.toast({

                    heading: 'Contraseña incorrecta',

                    text: 'Para eliminar este link debes ingresar la contraseña de administrador.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'error',

                    hideAfter: 4000,

                    stack: 6

                });

                return false;

            }
        });


        $("#btn_eliminar_sublink").click(function(e) {
            var nombre = $(this).data("nombre")
            var padre = $(this).data("padre")
            var password = $("#admin_password2").val()
            var password1 =
                "<?php echo htmlentities($personalizacion['password_admin'], ENT_QUOTES); ?>"
            if (password == password1) {
                $.ajax({

                    type: 'POST',

                    url: './api/menu.php',

                    cache: false,
                    dataType: 'json',

                    data: {

                        nombre_sublink_bloquear: nombre,
                        padre_sublink_bloquear: padre

                    },

                    success: function(result) {

                        console.log(result);

                        $('#modalEditarSubLink').modal('hide');

                        $.toast({

                            heading: 'Link eliminado',

                            text: 'Se ha eliminado el link correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                        setTimeout(function() {





                            window.location.href =
                                './personalizacion?menutab=1';

                        }, 2000);

                    }

                });





            } else {
                $.toast({

                    heading: 'Contraseña incorrecta',

                    text: 'Para eliminar este link debes ingresar la contraseña de administrador.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'error',

                    hideAfter: 4000,

                    stack: 6

                });

                return false;

            }
        });

        $(document).on('click', ".show_hide_password span", function(event) {

            event.preventDefault();

            var container = $(this).closest('.show_hide_password');

            var inputField = container.find('input');

            var icon = container.find('i');



            if (inputField.attr("type") === "text") {

                inputField.attr('type', 'password');

                icon.addClass("fa-eye-slash").removeClass("fa-eye");

            } else if (inputField.attr("type") === "password") {

                inputField.attr('type', 'text');

                icon.removeClass("fa-eye-slash").addClass("fa-eye");

            }

        });

        tinymce.init({

            selector: "#mymce_cuerpo_email_presupuesto",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['cuerpo_email_presupuesto']); ?>
                    );

                });

            }

        });



        tinymce.init({

            selector: "#mymce_cuerpo_texto_admision",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['texto_admision']); ?>
                    );

                });

            }

        });



        tinymce.init({

            selector: "#mymce_cuerpo_texto_admision_aceptada",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['cabecera_email_usuario']); ?>
                    );

                });

            }

        });



        tinymce.init({

            selector: "#mymce_cuerpo_email_factura",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['cuerpo_email_factura']); ?>
                    );

                });

            }

        });



        tinymce.init({

            selector: "#mymce_texto_email_usuario",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['texto_email_usuario']); ?>
                    );

                });

            }

        });



        tinymce.init({

            selector: "#mymce_cuerpo_email_itv",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['cuerpo_email_itv']); ?>
                    );

                });

            }

        });



        tinymce.init({

            selector: "#mymce_cuerpo_email_financiacion",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['cuerpo_email_financiacion']); ?>
                    );

                });

            }

        });



        tinymce.init({

            selector: "#mymce_cuerpo_email_albaran",

            theme: "modern",

            height: 300,

            plugins: [

                "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",

                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",

                "save table contextmenu directionality emoticons template paste textcolor"

            ],

            toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            setup: function(editor) {

                editor.on('init', function() {

                    editor.setContent(
                        <?php echo json_encode($personalizacion['cuerpo_email_albaran']); ?>
                    );

                });

            }

        });






        $('#tab_sesion').on('shown.bs.tab', function(e) {



            $($.fn.dataTable.tables(true)).DataTable()

                .columns.adjust()

                .responsive.recalc();

        });
















        var tabla_logs = $('#tabla_logs').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "lengthMenu": [

                [5, 10, 15, -1],

                [5, 10, 15, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en logs",

                infoEmpty: "Mostrando 0 a 0 de 0 en logs",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                loadingRecords: "Cargando...",

                processing: "Procesando...",



                zeroRecords: "Sin resultados encontrados",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [



                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column'

                },

                {

                    extend: 'excel',

                    text: 'Excel',

                    exportOptions: {

                        columns: ':visible:not(:eq(6))' // Excluir la columna con índice 2

                    }

                }

            ],

            "searching": true,

            "ajax": {

                url: '/api/logins.php', // Ruta que devuelve los datos de los apartados

                method: 'GET',

                dataSrc: function(data) {

                    console.log(data);



                    return data;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },



            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado



                //$('#order-listing').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "login_id",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                }, {

                    "data": "nombre_usuario",


                }, {

                    "data": "login_date",



                    "render": function(data, type, row) {

                        //var nombre = (data.nombre_medida != null) ? data.nombre_medida : " "


                            // Ficheo el problema de que usa la zona horaria. Luis
                       if (row.login_date_str) {
            return moment(row.login_date_str).format("YYYY-MM-DD HH:mm:ss");
        }
        return '';

                    }

                }, {

                    "data": "login_agent",



                    "render": function(data, type, row) {

                        //var nombre = (data.nombre_medida != null) ? data.nombre_medida : " "



                        return GetAgent(data)

                    }

                }, {

                    "data": "login_ip"

                }, {

                    "data": null,



                    "render": function(data, type, row) {

                        //var nombre = (data.nombre_medida != null) ? data.nombre_medida : " "

                        // return GetLocation(data.login_ip)

                        return data.localizacion

                    }

                }, {

                    "data": "login_success",

                    "render": function(data, type, row, meta) {

                        var d = data == 1 ?

                            '<div class="badge badge-success" style="font-size:14px;">Exitoso</div>' :

                            '<div class="badge badge-danger" style="font-size:14px;">Fallido</div>'

                        return d

                    }

                },

                {

                    "data": "login_id",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');







                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =

                            'btn_eliminar_log p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;







                        dropdownMenu.appendChild(buttonEliminar);



                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);



                        return td.outerHTML;

                    }

                }

            ]



        });



        $('#logs').on('shown.bs.tab', function(e) {



            $($.fn.dataTable.tables(true)).DataTable()

                .columns.adjust()

                .responsive.recalc();

        });





        $(document).on("click", ".btn_eliminar_log", function(e) {







            $("#btn_eliminar_log").data("id", $(this).data("id"))



            $("#modalEliminarLog").modal('show');









        })

        $('#btn_eliminar_log').click(function(event) {



            var id_log_eliminar = $("#btn_eliminar_log").data("id")





            $.ajax({

                type: 'DELETE',

                url: './api/logins.php?login_id_eliminar=' + id_log_eliminar,

                cache: false,

                async: false,

                success: function(result) {



                    $('#modalEliminarLog').modal('hide');

                    $.toast({

                        heading: 'Log eliminado',

                        text: 'Se ha eliminado el log correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })





                    $('#modalEliminarLog').modal('hide');



                    tabla_logs.ajax.reload(null, false);





                }

            });



            return false;

        });



        $('#btn_descargar_excel_logs').click(function(event) {



            var nuevaUrl = "/api/logins.php"





            $.ajax({

                type: 'GET',

                url: nuevaUrl,

                cache: false,

                async: false,

                dataType: "json",

                success: function(logs) {

                    console.log(logs);









                    var libro = XLSX.utils.book_new();

                    var hoja = XLSX.utils.aoa_to_sheet([]);

                    var estiloNegrita = {

                        font: {

                            bold: true

                        }

                    };

                    var titulo = [

                        [

                            "Informe de logs <?php echo htmlentities($personalizacion['nombre'], ENT_QUOTES); ?>"

                        ]

                    ];

                    XLSX.utils.sheet_add_aoa(hoja, titulo, {

                        origin: "A1"

                    });



                    // Crear y agregar la fila de encabezado

                    var headers = ["Usuario", "Localización", "Navegador", "Fecha",

                        "IP", "Resultado"



                    ];

















                    XLSX.utils.sheet_add_aoa(hoja, [headers], {

                        origin: "A2"

                    });

                    logs.forEach(function(factura, index) {

                        var fila = [

                            factura.nombre_usuario,

                            factura.localizacion,

                            factura.login_agent,

                            moment.unix(factura.login_date).format(

                                'YYYY-MM-DD HH:mm:ss'),



                            factura.login_ip,

                            (factura.login_success) ? "Exitoso" : "Fallido"



                        ];

                        // La fila de datos empieza desde la tercera fila (índice 2 en cero-based)

                        XLSX.utils.sheet_add_aoa(hoja, [fila], {

                            origin: "A" + (index + 3)

                        });



                    });

                    var range = XLSX.utils.decode_range(hoja["!ref"]);

                    if (!hoja["!merges"]) hoja["!merges"] = [];

                    hoja["!merges"].push({

                        s: {

                            r: 0,

                            c: 0

                        },

                        e: {

                            r: 0,

                            c: range.e.c

                        }

                    });



                    XLSX.utils.book_append_sheet(libro, hoja, "Informe_logs");

                    const u8 = XLSX.write(libro, {

                        bookType: "xlsx",

                        type: "buffer"

                    });

                    const parts = [u8]; // `Blob` constructor expects this

                    /* create Blob */

                    const blob = new Blob(parts, {

                        type: "application/download"

                    });

                    var enlaceDescarga = document.createElement('a');

                    enlaceDescarga.href = window.URL.createObjectURL(blob);

                    enlaceDescarga.download = "Informe_logs.xlsx";



                    // Agregar el enlace al documento y simular el clic para iniciar la descarga

                    document.body.appendChild(enlaceDescarga);

                    enlaceDescarga.click();



                    // Eliminar el enlace después de la descarga

                    document.body.removeChild(enlaceDescarga);



                }

            });

            return false;

        });



        function checkIfValidIP(str) {

            // Regular expression to check if string is a IP address

            const regexExp =

                /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/gi;



            return regexExp.test(str);

        }



        $('.login_ip').inputmask({

            alias: "ip",

            greedy: false //The initial mask shown will be "" instead of "-____".

        });

        $('.login_ip').change(function() {



            if (!checkIfValidIP($(this).val())) {

                $.toast({

                    heading: 'IP no válida',

                    text: 'La dirección IP no es válida',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 2000,

                    stack: 6

                });

                return false;

            }

        })





        $("#habilitar_todos").change(function() {



            if ($(this).prop("checked")) {

                $(".habilitado_log ").each(function() {

                    $(this).prop("checked", true)

                })

            } else {

                $(".habilitado_log ").each(function() {

                    $(this).prop("checked", false)

                })

            }

        })



        function GetAgent(userAgentString) {

            var parser = new UAParser();





            var result = parser.setUA(userAgentString).getResult();

            var esNavegador = result.browser.name



            return esNavegador; // Devuelve true





        }







        $("#btn_add_log").click(function() {

            $("#btn_add_log").addClass("btn-loading")

            var logins = []

            var seguir = true

            $(".login_row").each(function() {

                if ($(this).find(".habilitado_log").prop("checked")) {

                    var login_user = $(this).find(".login_user").val()

                    var login_ip = $(this).find(".login_ip").val()

                    var login_agent = $(this).find(".login_agent").find(':selected').text()



                    var login_success = ($(this).find('.login_success').prop("checked")) ?

                        1 : 0

                    console.log(login_success);

                    var login_date = moment($(this).find('.login_date').val()).format(

                        'YYYY-MM-DD HH:mm:ss')





                    if (!checkIfValidIP(login_ip)) {

                        $.toast({

                            heading: 'IP no válida',

                            text: 'La dirección IP no es válida',

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 2000,

                            stack: 6

                        });

                        $(this).find(".login_ip").focus()

                        $("#btn_add_log").removeClass("btn-loading")



                        seguir = false;

                        return false

                    }



                    if (login_date == "Invalid date") {

                        $.toast({

                            heading: 'Ingresa una fecha',

                            text: 'La fecha es requerida',

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 2000,

                            stack: 6

                        });

                        $(this).find(".login_date").focus()

                        $("#btn_add_log").removeClass("btn-loading")



                        seguir = false;

                        return false

                    }



                    var data = {

                        login_user: login_user,

                        login_ip: login_ip,

                        login_agent: login_agent,

                        login_success: login_success,

                        login_date: login_date

                    }

                    logins.push(data)





                }

            })



            if (logins.length != 0 && seguir) {

                $.ajax({

                    type: 'POST',

                    url: './api/logins.php',

                    async: false,

                    data: {

                        logins: logins

                    },

                    success: function(result) {

                        console.log(result);



                        $.toast({

                            heading: 'Logs agregados',

                            text: 'Se han agregado los logs correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                        tabla_logs.ajax.reload(null, false);

                        $("#btn_add_log").removeClass("btn-loading")

                        $('#modalAgregarLog').modal("hide")











                    }

                });

            } else {

                $.toast({

                    heading: 'Debes seleccionar al menos un log y rellenar toda la info requerida',

                    text: 'Debes seleccionar al menos un log para agregar',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 2000,

                    stack: 6

                });



                $("#btn_add_log").removeClass("btn-loading")

                return false

            }



        })















    });



})(jQuery);
</script>



<script>
$(document).ready(function() {

    var TablaLinks = $('#tabla_links').DataTable({

        responsive: true,

        dom: 'Blfrtip',

        lengthMenu: [

            [5, 10, 15, -1],

            [5, 10, 15, "Todos"]

        ],

        iDisplayLength: 10,

        language: {

            search: "Buscar",

            emptyTable: "No hay información",

            info: "Mostrando _START_ a _END_ de _TOTAL_ en links",

            infoEmpty: "Mostrando 0 a 0 de 0 en links",

            infoFiltered: "(Filtrado de _MAX_ total entradas)",

            infoPostFix: "",

            thousands: ",",

            lengthMenu: "Mostrar _MENU_ Entradas",

            loadingRecords: "Cargando...",

            processing: "Procesando...",



            zeroRecords: "Sin resultados encontrados",

            paginate: {

                first: "Primero",

                last: "Ultimo",

                next: "Siguiente",

                previous: "Anterior"

            }

        },

        stateSave: true,

        stateSaveCallback: function(settings, data) {

            localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

        },

        stateLoadCallback: function(settings) {

            return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

        },

        buttons: [



            {

                extend: 'colvis',

                text: 'Ocultar Columnas',

                collectionLayout: 'fixed two-column',

                className: "form-control"

            }

        ],



        columns: [{

                data: 'orden'

            },

            {

                data: 'nombre'

            },

            {

                data: 'nombre_visible'

            },

            {

                data: 'visible_oculto'

            },

            {

                data: 'eliminar',

                title: "Eliminar"

            }

        ],

        rowReorder: {

            dataSrc: 'orden'

        }

    });



    var TablaSubmenu = $('#tabla_submenu').DataTable({

        responsive: true,

        dom: 'Blfrtip',

        lengthMenu: [

            [5, 10, 15, -1],

            [5, 10, 15, "Todos"]

        ],

        iDisplayLength: 10,

        language: {

            search: "Buscar",

            emptyTable: "No hay información",

            info: "Mostrando _START_ a _END_ de _TOTAL_ en links",

            infoEmpty: "Mostrando 0 a 0 de 0 en links",

            infoFiltered: "(Filtrado de _MAX_ total entradas)",

            infoPostFix: "",

            thousands: ",",

            lengthMenu: "Mostrar _MENU_ Entradas",

            loadingRecords: "Cargando...",

            processing: "Procesando...",



            zeroRecords: "Sin resultados encontrados",

            paginate: {

                first: "Primero",

                last: "Ultimo",

                next: "Siguiente",

                previous: "Anterior"

            }

        },

        stateSave: true,

        stateSaveCallback: function(settings, data) {

            localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

        },

        stateLoadCallback: function(settings) {

            return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

        },

        buttons: [



            {

                extend: 'colvis',

                text: 'Ocultar Columnas',

                collectionLayout: 'fixed two-column',

                className: "form-control"

            }

        ],

        colReorder: true,

        columns: [{

                data: 'orden',

                title: "Orden"

            },

            {

                data: 'nombre',

                title: "Nombre"

            },

            {

                data: 'nombre_visible',

                title: "Nombre visible"

            },

            {

                data: 'visible',

                title: "Visible"

            },

            {

                data: null,

                title: "Eliminar"

            }

        ],

        rowReorder: {

            dataSrc: 'orden'

        }

    });







    $("#btn_guardar_menu").click(function() {

        var data = TablaLinks.rows().data().toArray();

        console.log(data);

    })

    TablaLinks.on('row-reordered', function(e, details, changes) {

        // obtener el nuevo orden de las filas



        var data = TablaLinks.rows().data().toArray();



        // enviar los datos al servidor mediante una petición AJAX

        $.ajax({

            type: 'POST',

            url: './api/menu.php',

            data: {

                menu: data



            },

            success: function(menu) {

                //console.log(menu);

                console.log(JSON.parse(menu));

            },

            error: function() {

                console.log('Error al enviar los datos');

            }

        });

    });

    TablaSubmenu.on('row-reordered', function(e, details, changes) {

        // obtener el nuevo orden de las filas



        var data = TablaSubmenu.rows().data().toArray();

        var nombre = $('#tabla_submenu').data("nombre")

        // enviar los datos al servidor mediante una petición AJAX

        $.ajax({

            type: 'POST',

            url: './api/menu.php',

            data: {

                nombre: nombre,

                submenu: data



            },

            success: function(submenu) {

                //console.log(menu);

                console.log(JSON.parse(submenu));

            },

            error: function() {

                console.log('Error al enviar los datos');

            }

        });

    });



    TablaLinks.on('click', 'td:not(:first-child):not(:last-child)', function() {

        // Obtener el elemento HTML correspondiente a la fila seleccionada

        var fila = TablaLinks.row(this).data();

        $('#tabla_submenu').data("nombre", fila.nombre)



        $.ajax({

            url: "./api/menu.php?nombre=" + fila.nombre,

            type: 'GET',

            dataType: 'json', // added data type

            cache: false,

            success: function(submenu) {

                TablaSubmenu.clear().draw();



                if (submenu) {

                    var array = Object.values(submenu);



                    array.sort(function(a, b) {

                        return parseInt(a.orden) - parseInt(b.orden);

                    });

                    for (let elemento of array) {

                        console.log(elemento);
                        if (elemento.bloqueado == false) {

                            var newData = {

                                orden: elemento.orden,

                                nombre: elemento.nombre,

                                nombre_visible: "",

                                visible: "",
                                eliminar: elemento.bloqueado,

                            };

                            var input_nombre_visible = document.createElement("input");



                            // Establecer los atributos del input

                            input_nombre_visible.setAttribute("class",

                                "form-control nombre_sub_menu_editar");

                            input_nombre_visible.setAttribute("data-nombre", elemento
                                .nombre);

                            input_nombre_visible.setAttribute("data-menu", $(

                                '#tabla_submenu').data("nombre"));



                            input_nombre_visible.setAttribute("value", elemento
                                .nombre_visible);

                            input_nombre_visible.setAttribute("type", "text");





                            var label = document.createElement('label');

                            var input = document.createElement('input');



                            var span = document.createElement('span');



                            // Asignar atributos y clases

                            input.setAttribute('type', 'checkbox');

                            span.className = 'checkmark';

                            label.classList.add("visible_oculto_submenu", "custom-checkbox")

                            // Agregar elementos al DOM

                            label.appendChild(input);

                            label.appendChild(span);

                            if (elemento.visible == true) {

                                input.setAttribute('checked', true);

                            }

                            input.setAttribute('data-nombre', elemento.nombre);



                            var button = document.createElement('button');
                            button.setAttribute('type', 'button');
                            button.setAttribute('data-nombre', elemento.nombre);
                            button.setAttribute('data-padre', fila.nombre);
                            button.classList.add("btn_eliminar_sublink", "btn",
                                "btn-danger")
                            button.innerText = "Eliminar";

                            var button2 = document.createElement('button');
                            button2.setAttribute('type', 'button');
                            button2.setAttribute('data-tabla', elemento.tabla);

                            button2.classList.add("btn_vaciar_tabla", "btn",
                                "btn-primary", "mt-2")
                            button2.innerText = "Vaciar";





                            var row = TablaSubmenu.row.add(newData).draw().node();
                            var buttonCell = TablaSubmenu.cell(row, 4).node();
                            var lastCell = TablaSubmenu.cell(row, 3).node();

                            var NombreCell = TablaSubmenu.cell(row, 2).node();

                            lastCell.appendChild(label);

                            NombreCell.appendChild(input_nombre_visible);
                            buttonCell.classList.add("d-flex", "flex-column",
                                "align-items-start")
                            buttonCell.innerHTML = ""; // Limpiar el contenido de la celda
                            buttonCell.appendChild(button);
                            if (elemento.tabla != false) {
                                buttonCell.appendChild(button2);
                            }

                        }



                    }
                }
            }

        });

        // Ejecutar tu función JavaScript aquí



    });

    $(document).on("change", ".nombre_menu_editar", function() {

        var nombre = $(this).data("nombre")

        var nombre_visible = $(this).val()

        console.log(nombre);

        console.log(nombre_visible);

        $.ajax({

            type: 'POST',

            url: './api/menu.php',

            data: {

                nombre: nombre,

                nombre_visible: nombre_visible



            },

            success: function() {

                $("#elemento_" + nombre).text(nombre_visible)

                $.toast({

                    heading: 'Nombre cambiado.',

                    text: 'Se ha cambiado el nombre visible correctamente.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })



            },

            error: function() {

                console.log('Error al enviar los datos');

            }

        });



    });

    $(document).on("change", ".nombre_sub_menu_editar", function() {

        var nombre_menu = $(this).data("menu")

        var nombre = $(this).data("nombre")

        var nombre_visible = $(this).val()

        console.log(nombre);

        console.log(nombre_visible);

        $.ajax({

            type: 'POST',

            url: './api/menu.php',

            data: {

                nombre_menu: nombre_menu,

                nombre: nombre,

                nombre_visible: nombre_visible



            },

            success: function(r) {

                console.log(r);

                $("#elemento_" + nombre).text(nombre_visible)

                $.toast({

                    heading: 'Nombre cambiado.',

                    text: 'Se ha cambiado el nombre visible correctamente.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })



            },

            error: function() {

                console.log('Error al enviar los datos');

            }

        });



    });



    $(document).on("change", ".visible_oculto input", function() {

        var nombre_menu = $(this).data("nombre")

        var visible = $(this).prop("checked")

        console.log(nombre_menu);

        console.log(visible);

        $.ajax({

            type: 'POST',

            url: './api/menu.php',

            data: {

                nombre_menu: nombre_menu,

                visible: visible



            },

            success: function(submenu) {

                console.log(menu);

                // console.log(JSON.parse(submenu));

            },

            error: function() {

                console.log('Error al enviar los datos');

            }

        });

    })

    $(document).on("change", ".visible_oculto_submenu input", function() {

        var nombre_sub_menu = $(this).data("nombre")

        var nombre_menu = $('#tabla_submenu').data("nombre")

        var visible = $(this).prop("checked")

        console.log(nombre_menu);

        console.log(visible);

        console.log(nombre_sub_menu);

        $.ajax({

            type: 'POST',

            url: './api/menu.php',

            data: {

                nombre_sub_menu: nombre_sub_menu,

                nombre_menu: nombre_menu,

                visible: visible



            },

            success: function(submenu) {

                console.log(menu);

                // console.log(JSON.parse(submenu));

            },

            error: function() {

                console.log('Error al enviar los datos');

            }

        });

    })





    $(document).on("click", "#btn_modify_emails", function() {

        const text = $(this).html();

        $('#btn_modify_emails').html(

            '<svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="15px" height="15px" viewBox="0 0 50 50" style="enable-background:new 0 0 50 50;" xml:space="preserve"><path fill="#FFFFFF" d="M43.935,25.145c0-10.318-8.364-18.683-18.683-18.683c-10.318,0-18.683,8.365-18.683,18.683h4.068c0-8.071,6.543-14.615,14.615-14.615c8.072,0,14.615,6.543,14.615,14.615H43.935z"><animateTransform attributeType="xml"attributeName="transform"type="rotate"from="0 25 25"to="360 25 25"dur="0.6s"repeatCount="indefinite"/></path></svg>'

        );

        $('#btn_modify_emails').attr('disabled', 'disabled');



        var mymce_cuerpo_texto_admision_content = tinymce.get("mymce_cuerpo_texto_admision")
            .getContent();

        $("#mymce_cuerpo_texto_admision_input").val(mymce_cuerpo_texto_admision_content);



        var mymce_cuerpo_texto_admision_aceptada_content = tinymce.get(
            "mymce_cuerpo_texto_admision_aceptada").getContent();

        $("#mymce_cuerpo_texto_admision_aceptada_input").val(
            mymce_cuerpo_texto_admision_aceptada_content);



        var mymce_cuerpo_email_presupuesto_content = tinymce.get("mymce_cuerpo_email_presupuesto")
            .getContent();

        $("#mymce_cuerpo_email_presupuesto_input").val(mymce_cuerpo_email_presupuesto_content);



        var mymce_cuerpo_email_factura_content = tinymce.get("mymce_cuerpo_email_factura").getContent();

        $("#mymce_cuerpo_email_factura_input").val(mymce_cuerpo_email_factura_content);



        var mymce_texto_email_usuario_content = tinymce.get("mymce_texto_email_usuario").getContent();

        $("#mymce_texto_email_usuario_input").val(mymce_texto_email_usuario_content);



        var mymce_cuerpo_email_itv_content = tinymce.get("mymce_cuerpo_email_itv").getContent();

        $("#mymce_cuerpo_email_itv_input").val(mymce_cuerpo_email_itv_content);



        var mymce_cuerpo_email_financiacion_content = tinymce.get("mymce_cuerpo_email_financiacion")
            .getContent();

        $("#mymce_cuerpo_email_financiacion_input").val(mymce_cuerpo_email_financiacion_content);



        var mymce_cuerpo_email_albaran_content = tinymce.get("mymce_cuerpo_email_albaran").getContent();

        $("#mymce_cuerpo_email_albaran_input").val(mymce_cuerpo_email_albaran_content);



        $.ajax({

            url: './api/personalizacion.php',

            method: "POST",

            data: $("#modify-emails-form").serialize(),

            cache: false,

        }).done(function(result) {

            setTimeout(() => {

                $('#btn_modify_emails').html(text);

                $('#btn_modify_emails').removeAttr('disabled', 'disabled');

                result = JSON.parse(result);

                if (!result.status) {

                    $.toast({

                        heading: 'Faltan datos',

                        text: result['msg'],

                        position: 'top-right',

                        loaderBg: '#ff5c6c',

                        icon: 'error',

                        hideAfter: 2000,

                        stack: 6

                    });

                } else {

                    $.toast({

                        heading: 'Datos modificados.',

                        text: result['msg'],

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                }

            }, 1000);

        });

    });

});
</script>





<script>
jQuery(function($) {

    $(document).ready(function() {

        function rgbToHex(rgbValue) {

            var rgbArray = rgbValue.split(',');

            var r = parseInt(rgbArray[0].split('(')[1]);

            var g = parseInt(rgbArray[1]);

            var b = parseInt(rgbArray[2].split(')')[0]);



            var hexValue = "#" + ((r << 16) | (g << 8) | b).toString(16).padStart(6, '0');

            return hexValue;

        }

        var eventoHabilitado = true;

        $(document).on('asColorPicker::change', ".color", function(e) {

            var input = $(this)





            if (eventoHabilitado) {

                // Deshabilitar el evento

                eventoHabilitado = false;

                input.prop('disabled', true);

                // Código del evento



                // Esperar 0.3 segundos y luego habilitar el evento

                setTimeout(function() {

                    input.prop('disabled', false);

                    eventoHabilitado = true;

                    console.log("eee");

                }, 300); // 0.3 segundos de retraso

                var nombre = input.data("nombre")

                var valor = input.asColorPicker('get').val()







                $.ajax({

                    type: 'POST',

                    url: './api/personalizacion.php',

                    cache: false,

                    async: false,

                    data: {

                        nombre: nombre,

                        valor: valor

                    },

                    success: function(result2) {



                        $.toast({

                            heading: 'Valor cambiado.',

                            text: 'Se ha cambiado la configuración correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        })

                        if (nombre == "color_iconos_primario") {

                            $("lord-icon").each(function() {

                                var colors = $(this).attr("colors")

                                colors = colors.replace(

                                    /(primary:)(#[a-fA-F0-9]{6})/,

                                    `$1${valor}`);



                                $(this).attr("colors", colors)

                            })

                        }

                        if (nombre == "color_iconos_secundario") {

                            $("lord-icon").each(function() {

                                var colors = $(this).attr("colors")



                                colors = colors.replace(

                                    /(secondary:)(#[a-fA-F0-9]{6})/,

                                    `$1${valor}`);



                                $(this).attr("colors", colors)

                            })

                        }

                        if (nombre == "color_superior") {

                            $("#superior").css("background-color", valor);

                        }

                        if (nombre == "color_barra_superior") {

                            $(".top_bar").css("background-color", valor);

                        }

                        if (nombre == "color_fondo_menu") {

                            $("#menu_fondo").css("background-color", valor);

                        }

                        if (nombre == "color_links_menu") {

                            $(".menu-title").css("color", valor);

                        }

                    }

                });

            }



        });









        $(document).on("change", ".valor_personalizacion", function() {

            var nombre = $(this).data("nombre")

            var valor = (nombre != "automatico_presupuestos" && nombre !=

                "automatico_facturas") ? $(this).val() : $(

                "#" + nombre).prop(

                "checked")





            $.ajax({

                type: 'POST',

                url: './api/personalizacion.php',

                cache: false,

                async: false,

                data: {

                    nombre: nombre,

                    valor: valor

                },

                success: function(result2) {

                    console.log(result2);

                    $.toast({

                        heading: 'Valor cambiado.',

                        text: 'Se ha cambiado la configuración correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    if (nombre == "url_logo_superior") {

                        $("img.logo_superior").each(function() {

                            console.log($(this));

                            $(this).attr("src", valor)



                        })

                    }

                }

            });





        });











    });

})
</script>

<script>
(function($) {



    'use strict';



    $(function() {



        $('#expediente_presupuestos').on('input', function() {

            let inputValue = $(this).val();

            console.log(inputValue);

            if (/^[a-zA-Z]$/.test(inputValue)) {

                // Si es una letra, convierte a mayúsculas

                $(this).val(inputValue.toUpperCase());

            } else {

                // Si no es una letra, vacía el campo

                $(this).val('');

            }

        });



        $('#expediente_facturas').on('input', function() {

            let inputValue = $(this).val();

            console.log(inputValue);

            if (/^[a-zA-Z]$/.test(inputValue)) {

                // Si es una letra, convierte a mayúsculas

                $(this).val(inputValue.toUpperCase());

            } else {

                // Si no es una letra, vacía el campo

                $(this).val('');

            }

        });

        var initialOrderCaptured = false;

        var orderObject = {};

        var sortable = new Sortable(document.getElementById('sortable_presupuestos'), {

            animation: 150,





            onEnd: function(evt) {



                // Obtiene el orden real de los elementos después de la acción de arrastrar y soltar

                var orderedElements = Array.from(evt.from.children);



                // Construye el objeto de clave-valor

                orderObject = {};

                orderedElements.forEach(function(element, index) {

                    orderObject[element.id + "_presupuestos"] = index +

                        1; // Sumamos 1 para obtener un orden basado en 1 en lugar de 0

                });



                console.log("Objeto de clave-valor:", orderObject);





                $.ajax({

                    type: 'POST',

                    url: './api/personalizacion.php',

                    cache: false,

                    async: false,

                    data: orderObject,

                    success: function(result2) {



                        $.toast({

                            heading: 'Orden cambiado.',

                            text: 'Se ha cambiado el orden correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        })



                    }

                });











            }

        });

        var sortable2 = new Sortable(document.getElementById('sortable_facturas'), {

            animation: 150,





            onEnd: function(evt) {



                // Obtiene el orden real de los elementos después de la acción de arrastrar y soltar

                var orderedElements = Array.from(evt.from.children);



                // Construye el objeto de clave-valor

                orderObject = {};

                orderedElements.forEach(function(element, index) {

                    orderObject[element.id] = index +

                        1; // Sumamos 1 para obtener un orden basado en 1 en lugar de 0

                });



                console.log("Objeto de clave-valor:", orderObject);





                $.ajax({

                    type: 'POST',

                    url: './api/personalizacion.php',

                    cache: false,

                    async: false,

                    data: orderObject,

                    success: function(result2) {



                        $.toast({

                            heading: 'Orden cambiado.',

                            text: 'Se ha cambiado el orden correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        })



                    }

                });











            }

        });



        function validarEmail(email) {

            var patron = /^[\w\.-]+@[\w\.-]+\.\w+$/;

            return patron.test(email);

        }









    });







})(jQuery);
</script>