<div class="content-wrapper">

    <div class="row profile-page ">

        <div class="col-md-3 mb-8">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/eicikaeg.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Número de pagos pendientes</p>

                        <span id="pendientes_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-3 mb-8">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/swntouvh.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Total pendiente de pago</p>

                        <span id="total_pendiente" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-3 mb-8">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/eexszoni.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Total pagado</p>

                        <span id="total_pagado">

                        </span>

                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-3 mb-8">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/eexszoni.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Pagados</p>

                        <span id="pagados_count">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div class="row profile-page mb-4">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0 ">

                        <div class="row ">

                            <!-- Historial de Acceso -->

                            <div class="col-md-12">

                                <div class="card card-cuenta">

                                    <div class="row">

                                        <div class="col-12">

                                            <button data-toggle="modal" data-target="#modalAgregarPago"
                                                class="m-3 btn btn-sm btn-primary">Agregar</button>

                                            <button type="button" id="btn_descargar_excel"
                                                class="btn btn-sm btn-info">Descargar</button>

                                        </div>

                                    </div>

                                    <div class="card-body card-table-body">

                                        <h4>Pagos pendientes</h4>

                                        <div class="table-responsive">

                                            <table id="tabla_pago_proveedor_pendientes"
                                                class="tabla_pago_proveedores table">

                                                <thead>

                                                    <tr>

                                                        <th
                                                            style="padding-left: 32px !important;padding-right: 50px !important;">

                                                            ID</th>

                                                        <th>Empresa</th>

                                                        <th>Número de factura</th>

                                                        <th>Importe</th>

                                                        <th>Importe restante</th>

                                                        <th>Fecha de vencimiento</th>

                                                        <th>Fecha</th>

                                                        <th>

                                                            Pagos

                                                        </th>

                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>

                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminación de cuenta -->

                            <!-- /Eliminación de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div class="row profile-page">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0 ">

                        <div class="row ">

                            <!-- Historial de Acceso -->

                            <div class="col-md-12">

                                <div class="card card-cuenta">

                                    <div class="card-body card-table-body">

                                        <h4>Pagados</h4>

                                        <div class="table-responsive">

                                            <table id="tabla_pago_proveedor_pagados"
                                                class="tabla_pago_proveedores table">

                                                <thead>

                                                    <tr>

                                                        <th
                                                            style="padding-left: 32px !important;padding-right: 50px !important;">

                                                            ID</th>

                                                        <th>Empresa</th>

                                                        <th>Número de factura</th>

                                                        <th>Importe</th>

                                                        <th>Importe restante</th>

                                                        <th>Fecha de vencimiento</th>

                                                        <th>Fecha</th>

                                                        <th>

                                                            Pagos

                                                        </th>

                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>

                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminación de cuenta -->

                            <!-- /Eliminación de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<div class="modal fade" id="modalDescontar" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Descontar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label>Monto</label>

                                <input type="number" class="form-control" id="monto_descuento" placeholder=""
                                    value="0.00" required min="0.00" step="any">

                            </div>

                            <div class="form-group">

                                <label>Fecha</label>

                                <input type="datetime-local" class="form-control" id="fecha_descuento">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Método de pago</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_metodo file-upload-browse btn btn-danger"
                                            data-target="metodo_descuento" type="button">-</button>

                                    </span>

                                    <select id="metodo_descuento"
                                        class="select_metodos custom-select select2 form-control">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarMetodo">+</button>

                                    </span>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Banco</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_banco file-upload-browse btn btn-danger"
                                            data-target="banco_descuento" type="button">-</button>

                                    </span>

                                    <select id="banco_descuento"
                                        class="select_bancos custom-select select2 form-control">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarBanco">+</button>

                                    </span>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div style="margin-top:15px;" class="modal-footer text-right">

                <button id="btn_descontar" class="btn btn-success btn-fw" type="button">

                    Descontar</button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalPagar" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Marcar la factura como pagada?</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label>Fecha</label>

                                <input type="datetime-local" class="form-control" id="fecha_pago">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Banco</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_banco file-upload-browse btn btn-danger"
                                            data-target="banco_descuento2" type="button">-</button>

                                    </span>

                                    <select id="banco_descuento2"
                                        class="select_bancos custom-select select2 form-control">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarBanco">+</button>

                                    </span>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Método de pago</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_metodo file-upload-browse btn btn-danger"
                                            data-target="metodo_descuento2" type="button">-</button>

                                    </span>

                                    <select id="metodo_descuento2"
                                        class="select_metodos custom-select select2 form-control">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarMetodo">+</button>

                                    </span>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div style="margin-top:15px;" class="modal-footer text-right">

                <button id="btn_marcar_pagado" class="btn btn-success btn-fw" type="button">

                    Marcar como pagado</button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarPago" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Pago</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label>Proveedor</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_proveedor file-upload-browse btn btn-danger"
                                            data-target="id_proveedor" type="button">-</button>

                                    </span>

                                    <select id="id_proveedor"
                                        class="select_proveedores custom-select select2 form-control validable">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarProveedor">+</button>

                                    </span>

                                </div>

                            </div>

                        </div>

                        <div class="col-12" style="text-align: center;" id="show-proveedor-type">

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Fecha</label>

                                <input type="datetime-local" class="form-control validable"
                                    id="fecha_factura_proveedor">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Fecha de vencimiento</label>

                                <input type="datetime-local" class="form-control validable"
                                    id="fecha_vencimiento_factura_proveedor">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Importe</label>

                                <input type="number" class="form-control validable" id="importe_factura_proveedor"
                                    value="0.00" placeholder="" required step="any">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Número factura</label>

                                <input type="text" class="form-control validable" id="numero_factura_proveedor"
                                    name="numero_factura" placeholder="" required>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button class="btn btn-success btn-fw" id="btn_agregar_pago" type="button">

                    Guardar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEliminarFactura" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar pago</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->

                <p class="">¿Estás seguro de que deseas eliminar el pago definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">

                <input type="hidden" id="id_factura_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_factura_proveedor">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<style>
.archivo_lista {

    cursor: pointer;

    transition: all .3s ease;

    position: relative;

    height: 100%;

    width: 100%;

    background: #0000001a;

    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    aspect-ratio: 1/1;

    border-radius: 2% !important;

}

.archivo_lista img {

    object-fit: cover;

    max-height: 200px;

}

.archivo_lista:hover {

    opacity: .5;

    background: #000000;

}

.btn_eliminar_archivo {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    right: 0;

    top: 0;

    border-radius: 10% !important;

}

.archivo_lista:hover .btn_eliminar_archivo {

    opacity: 1;

}

.btn_eliminar_archivo i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #F1635F;

}

.btn_eliminar_archivo:hover i:before {

    color: #F1635F;

}

.btn_seleccionar_archivo {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    left: 0;

    top: 0;

    border-radius: 10% !important;

}

.archivo_lista:hover .btn_seleccionar_archivo {

    opacity: 1;

}

.btn_seleccionar_archivo i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #0cca8e;

}

.btn_seleccionar_archivo:hover i:before {

    color: #0cca8e;

}

.nombre_archivo_div {

    position: absolute;

    font-size: 18px;

    border-radius: 4px;

    transition: all .3s ease;

    opacity: 0;

    color: white;

    background-color: black;

    padding: .5rem;

    cursor: pointer;

}

.col-sm-3:hover .nombre_archivo_div {

    opacity: 1;

}

#lista_archivos {

    max-height: 723px;

    overflow-y: scroll;

}

table.dataTable thead>tr>th.sorting {

    padding: 10px !important;

}
</style>

<style>
.btn_eliminar_pago {

    position: absolute;

    right: 9px;

    top: 9px;

}
</style>

<div class="modal fade" id="modalSubirArchivo" role="dialog">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Archivos</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-4">

                <div class="row">

                    <div class="col-12 col-md-6">

                        <div class="form-group">

                            <label for="my-input">Nombre</label>

                            <input id="nombre_archivo" type="text" class="form-control">

                        </div>

                    </div>

                    <div class="col-12 col-md-6">

                        <div class="form-group">

                            <label for="my-input">Archivo</label>

                            <div class="input-group">

                                <input type="file" class="d-none" id="archivo_file" accept=".png, .jpg, .pdf">

                                <input disabled id="archivo_archivo" type="text" class="form-control"
                                    value="Ningún archivo seleccionado.">

                                <div class="input-group-append">

                                    <label for="archivo_file" class="mb-0 btn btn-success btn-fw" id="btn_subir_archivo"
                                        type="button">

                                        Seleccionar archivo</label>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="col-12 text-left mb-2">

                        <button class="btn btn-success btn-fw" id="btn_add_archivo" type="button">Subir</button>

                    </div>

                </div>

                <div class=" container-lg p-0">

                    <div id="lista_archivos" class="row">

                    </div>

                </div>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

</div>

<div class="modal fade modal-cambiar" id="modalVerArchivo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_archivo" class="modal-body">

                <!-- btn -->

            </div>

            <!-- /btn -->

            <!-- /modal-body -->

        </div>

    </div>

</div>

<?php require_once __VIEWS__ . 'selects/bancos.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/metodos_pago.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/proveedores.template.php'; ?>

<script>
(function($) {

    'use strict';

    $(function() {

        $('#fecha_pago').text(moment().format('YYYY-MM-DD HH:mm'))

        $('#fecha_descuento').text(moment().format('YYYY-MM-DD HH:mm'))

        $("#fecha_factura_proveedor").val(moment().format('YYYY-MM-DD HH:mm'))

        $("#fecha_vencimiento_factura_proveedor").val(moment().format('YYYY-MM-DD HH:mm'))

    });

})(jQuery);
</script>

<script>
(function($) {

    'use strict';

    $(function() {

        $('#btn_agregar_pago').click(function() {

            var repetido = false

            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalAgregarPago .validable').forEach(
                input => {

                    const evento = new CustomEvent('validar', {
                        bubbles: true,
                        detail: {
                            mensaje: 'Campo requerido'
                        }
                    });

                    // Disparar el evento de validación para cada input
                    input.dispatchEvent(evento);

                    // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                    if (!input.isValid) {
                        repetido = true;
                    }
                });

            if (repetido) {

                return false

            }

            $("#btn_agregar_pago").addClass('btn-loading');

            var id_proveedor = $('#id_proveedor').val()

            var fecha = new moment($("#fecha_factura_proveedor").val()).format(

                "YYYY-MM-DD HH:mm:ss");

            var fecha_vencimiento = new moment($("#fecha_vencimiento_factura_proveedor").val())

                .format("YYYY-MM-DD HH:mm:ss");

            var importe = $('#importe_factura_proveedor').val()

            var numero = $('#numero_factura_proveedor').val()

            $.ajax({

                type: 'POST',

                url: './api/factura_proveedor.php',

                data: {

                    id_proveedor: id_proveedor,

                    fecha: fecha,

                    fecha_vencimiento: fecha_vencimiento,

                    importe: importe,

                    numero: numero

                },

                success: function(result) {

                    console.log(result);

                    $.toast({

                        heading: 'Pago pendiente agregado',

                        text: 'Se ha agregado el pago correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    $('.tabla_pago_proveedores').DataTable().ajax.reload(null, false);

                    $("#btn_agregar_pago").removeClass('btn-loading');

                    $('#modalAgregarPago').modal('hide');

                }

            });

        })

        $(document).on("click", ".btn_descontar", function() {

            $("#btn_descontar").data("id", $(this).data("id"))

            $("#modalDescontar").modal("show")

            $("#fecha_descuento").val(new moment().format("YYYY-MM-DD HH:mm:ss"))

        })

        $(document).on("click", ".btn_marcar_pagado", function() {

            $("#btn_marcar_pagado").data("id", $(this).data("id"))

            $("#modalPagar").modal("show")

            $("#fecha_pago").val(new moment().format("YYYY-MM-DD HH:mm:ss"))

        })

        $(document).on("click", ".btn_eliminar_factura_proveedor", function() {

            $("#id_factura_eliminar").val($(this).data("id"))

            $("#modalEliminarFactura").modal("show");

        })

        $('#btn_eliminar_factura_proveedor').click(function(event) {

            var id_factura_eliminar = $("#id_factura_eliminar").val()

            $.ajax({

                type: 'DELETE',

                url: './api/factura_proveedor.php?id_factura_proveedor=' +

                    id_factura_eliminar,

                cache: false,

                success: function(result) {

                    $('#modalEliminarFactura').modal("hide")

                    $.toast({

                        heading: 'Pago eliminado',

                        text: 'Se ha eliminado el pago correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    $('.tabla_pago_proveedores').DataTable().ajax.reload(null, false);

                }

            });

            return false;

        });

        $(document).on("click", ".btn_eliminar_pago", function() {

            var id = $(this).data("id")

            $.ajax({

                type: 'DELETE',

                url: './api/factura_proveedor.php?id_pago_proveedor=' + id,

                cache: false,

                success: function(result) {

                    $.toast({

                        heading: 'Pago eliminado',

                        text: 'Se ha eliminado el pago correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    $('.tabla_pago_proveedores').DataTable().ajax.reload(null, false);

                }

            });

        })

        $("#btn_descontar").click(function() {

            var importe = parseFloat($("#monto_descuento").val())

            var id_banco = $("#banco_descuento").val()

            var id_metodo = $("#metodo_descuento").val()

            var id_factura_proveedor = $(this).data("id")

            var fecha = new moment($("#fecha_descuento").val()).format("YYYY-MM-DD HH:mm:ss");

            var pagado;

            var importe_total;

            var importe_restante;

            if (importe == 0) {

                $.toast({

                    heading: 'Monto incorrecto.',

                    text: 'El monto debe ser mayor que 0.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            $.ajax({

                url: "./api/factura_proveedor.php?id_factura_proveedor=" +

                    id_factura_proveedor,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(total) {

                    if (total != null) {

                        pagado = parseFloat(total)

                    } else {

                        pagado = 0

                    }

                }

            })

            $.ajax({

                url: "./api/factura_proveedor.php?id=" +

                    id_factura_proveedor,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(factura) {

                    importe_total = parseFloat(factura.importe);

                    importe_restante = importe_total - pagado

                }

            })

            console.log(parseFloat(importe_restante).toFixed(2));

            console.log(parseFloat(importe).toFixed(2));

            if (parseFloat(importe_restante) < parseFloat(importe)) {

                $.toast({

                    heading: 'Monto incorrecto.',

                    text: 'El monto debe ser menor o igual que el importe restante de ' +

                        parseFloat(importe_restante).toFixed(2) + "€.",

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            $.ajax({

                type: 'POST',

                url: './api/factura_proveedor.php',

                data: {

                    importe: importe,

                    id_banco: id_banco,

                    id_metodo: id_metodo,

                    id_factura_proveedor: id_factura_proveedor,

                    fecha: fecha

                },

                success: function(result) {

                    console.log(result);

                    $.toast({

                        heading: 'Descuento realizado',

                        text: 'Se ha descontado el monto de ' + importe +

                            ' € correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    $("#btn_descontar").removeClass('btn-loading');

                    $('#modalDescontar').modal('hide');

                    $('.tabla_pago_proveedores').DataTable().ajax.reload(null, false);

                }

            });

        })

        $("#btn_marcar_pagado").click(function() {

            var id_banco = $("#banco_descuento2").val()

            var id_metodo = $("#metodo_descuento2").val()

            var id_factura_proveedor = $(this).data("id")

            var fecha = new moment($("#fecha_pago").val()).format("YYYY-MM-DD HH:mm");

            var pagado;

            var importe_total;

            var importe_restante;

            $.ajax({

                url: "./api/factura_proveedor.php?id_factura_proveedor=" +

                    id_factura_proveedor,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(total) {

                    if (total != null) {

                        pagado = parseFloat(total)

                    } else {

                        pagado = 0

                    }

                    console.log("pagado" + pagado);

                }

            })

            $.ajax({

                url: "./api/factura_proveedor.php?id=" +

                    id_factura_proveedor,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(factura) {

                    importe_total = parseFloat(factura.importe);

                    importe_restante = importe_total - pagado

                }

            })

            $.ajax({

                type: 'POST',

                url: './api/factura_proveedor.php',

                data: {

                    importe: importe_restante,

                    id_banco: id_banco,

                    id_metodo: id_metodo,

                    id_factura_proveedor: id_factura_proveedor,

                    fecha: fecha

                },

                success: function(result) {

                    console.log(result);

                    $.toast({

                        heading: 'Pago realizado',

                        text: 'Se ha marcado el pago como pagado.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    $("#btn_marcar_pagado").removeClass('btn-loading');

                    $('#modalPagar').modal('hide');

                    $('.tabla_pago_proveedores').DataTable().ajax.reload(null, false);

                }

            });

        })

    });

})(jQuery);
</script>

<script>
(function($) {

    'use strict';

    $(function() {

        $('#tabla_pago_proveedor_pendientes').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, -1],

                [10, 25, 50, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en pagos pendientes",

                infoEmpty: "Mostrando 0 a 0 de 0 en pagos pendientes",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",

                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [

                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }

            ],

            "searching": true,

            "ajax": {

                url: '/api/factura_proveedor.php', // Ruta que devuelve los datos de los clientes

                method: 'GET',

                dataSrc: function(data) {

                    console.log(data);

                    var pendientes = data.filter(objeto => parseFloat(objeto

                        .importe) > parseFloat(objeto.total_pagado));

                    var pagados = data.filter(objeto => parseFloat(objeto

                        .importe) == parseFloat(objeto.total_pagado));

                    var total_pendiente = 0.00

                    var total_pagado = 0.00

                    pendientes.forEach(objeto => {

                        var importePendiente = parseFloat(objeto.importe) - parseFloat(

                            objeto.total_pagado);

                        total_pendiente += parseFloat(importePendiente);

                        total_pagado += parseFloat(objeto.total_pagado);

                    });

                    pagados.forEach(objeto => {

                        total_pagado += parseFloat(objeto.total_pagado);

                    });

                    $("#pendientes_count").text(pendientes.length)

                    $("#pagados_count").text(pagados.length)

                    $("#total_pagado").text(formatearNumero(parseFloat(total_pagado)

                        .toFixed(2)) + "€")

                    $("#total_pendiente").text(formatearNumero(parseFloat(total_pendiente)

                        .toFixed(2)) + "€")

                    return pendientes;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },

            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "id_factura_proveedor",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre"

                },

                {

                    "data": "numero"

                },

                {

                    "data": "importe",

                    "render": function(data, type, row, meta) {

                        var importe = formatearNumero(parseFloat(data).toFixed(2));

                        return importe + '€';

                    }

                },

                {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        var importe = parseFloat(data.importe) - parseFloat(data

                            .total_pagado)

                        importe = formatearNumero(parseFloat(importe).toFixed(2));

                        return importe + '€';

                    }

                },

                {

                    "data": "fecha_vencimiento",

                    "render": function(data, type, row, meta) {

                        return new moment(data).format("YYYY-MM-DD")

                    }

                },

                {

                    "data": "fecha",

                    "render": function(data, type, row, meta) {

                        return new moment(data).format("YYYY-MM-DD")

                    }

                },

                {

                    "data": "pagos",

                    "render": function(data, type, row, meta) {

                        // Crear la lista ul

                        const Div = document.createElement('div');

                        data.forEach(function(p) {

                            const nuevoDiv = document

                                .createElement('div');

                            nuevoDiv.classList.add('table-dropdown', 'mb-2');

                            var divDropdown = document.createElement(

                                'div');

                            divDropdown.className =

                                'dropdown d-block user-dropdown';

                            var link = document.createElement('a');

                            link.className =

                                'dropdown-toggle d-flex align-items-center';

                            link.id = 'UserDropdown';

                            link.href = '#';

                            link.setAttribute('data-toggle',

                                'dropdown');

                            link.setAttribute('aria-expanded', 'false');

                            link.textContent = new moment(p.fecha).format(

                                "YYYY-MM-DD")

                            var dropdownMenu = document.createElement(

                                'div');

                            dropdownMenu.className =

                                'p-2 dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                            dropdownMenu.setAttribute('aria-labelledby',

                                'UserDropdown');

                            var nuevoLi = document.createElement('p');

                            nuevoLi.className = 'mb-1';

                            // Crear el elemento <strong>

                            var strongElement = document.createElement('strong');

                            strongElement.textContent = "Método de pago: ";

                            // Agregar el <strong> al <p>

                            nuevoLi.appendChild(strongElement);

                            // Agregar el texto después del <strong>

                            var metodoText = document.createTextNode(p.metodo);

                            nuevoLi.appendChild(metodoText);

                            dropdownMenu.appendChild(

                                nuevoLi);

                            var nuevoLi3 = document

                                .createElement('p');

                            nuevoLi3.className =

                                'mb-1';

                            var strongElement2 = document.createElement('strong');

                            strongElement2.textContent = "Banco: ";

                            // Agregar el <strong> al <p>

                            nuevoLi3.appendChild(strongElement2);

                            // Agregar el texto después del <strong>

                            var bancoText = document.createTextNode(p.banco);

                            nuevoLi3.appendChild(bancoText);

                            dropdownMenu.appendChild(

                                nuevoLi3);

                            var nuevoLi4 = document

                                .createElement('p');

                            nuevoLi4.className =

                                'mb-0';

                            var strongElement3 = document.createElement('strong');

                            strongElement3.textContent = "Importe: ";

                            // Agregar el <strong> al <p>

                            nuevoLi4.appendChild(strongElement3);

                            // Agregar el texto después del <strong>

                            var importeText = document.createTextNode(

                                formatearNumero(

                                    parseFloat(p

                                        .importe).toFixed(2)

                                ) + "€");

                            nuevoLi4.appendChild(importeText);

                            dropdownMenu.appendChild(

                                nuevoLi4);

                            const nuevoEnlace = document

                                .createElement('a');

                            nuevoEnlace.setAttribute(

                                'data-id', p

                                .id_pago_proveedor);

                            nuevoEnlace.style.cursor =

                                'pointer';

                            nuevoEnlace.setAttribute('type',

                                'button');

                            nuevoEnlace.classList.add(

                                'btn_eliminar_pago');

                            // Crear el icono dentro del enlace

                            const nuevoIcono = document

                                .createElement('i');

                            nuevoIcono.classList.add(

                                'ti-trash');

                            nuevoEnlace.appendChild(

                                nuevoIcono);

                            dropdownMenu.appendChild(

                                nuevoEnlace);

                            divDropdown.appendChild(link);

                            divDropdown.appendChild(dropdownMenu);

                            nuevoDiv.appendChild(divDropdown);

                            Div.appendChild(nuevoDiv);

                        });

                        return Div.outerHTML;

                    }

                },

                {

                    "data": null,

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonEnviar = document.createElement('button');

                        buttonEnviar.className = 'btn_marcar_pagado p-1 dropdown-item';

                        buttonEnviar.setAttribute('type', 'button');

                        buttonEnviar.setAttribute('data-id', data.id_factura_proveedor)

                        buttonEnviar.innerHTML = `

                    <lord-icon src="./assets/lordicons/send.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Marcar como pagado`;

                        var buttonVerPresupuesto = document.createElement('button');

                        buttonVerPresupuesto.className =

                            'btn_descontar p-1 dropdown-item';

                        buttonVerPresupuesto.setAttribute('type', 'button');

                        buttonVerPresupuesto.setAttribute('data-id', data

                            .id_factura_proveedor)

                        buttonVerPresupuesto.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Descontar

                `;

                        var buttonFotos = document.createElement('button');

                        buttonFotos.className = 'btn_modal_archivos p-1 dropdown-item';

                        buttonFotos.setAttribute('type', 'button');

                        buttonFotos.setAttribute('data-id', data.id_factura_proveedor);

                        buttonFotos.innerHTML = `

                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Archivos

                `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =

                            'btn_eliminar_factura_proveedor p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data.id_factura_proveedor)

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;

                        dropdownMenu.appendChild(buttonVerPresupuesto);

                        dropdownMenu.appendChild(buttonFotos);

                        dropdownMenu.appendChild(buttonEnviar);

                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }

                }

            ]

        });

        $('#tabla_pago_proveedor_pagados').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, -1],

                [10, 25, 50, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en pagos completados",

                infoEmpty: "Mostrando 0 a 0 de 0 en pagos completados",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",

                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [

                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }

            ],

            "searching": true,

            "ajax": {

                url: '/api/factura_proveedor.php', // Ruta que devuelve los datos de los clientes

                method: 'GET',

                dataSrc: function(data) {

                    console.log(data);

                    var pendientes = data.filter(objeto => parseFloat(objeto

                        .importe) > parseFloat(objeto.total_pagado));

                    var pagados = data.filter(objeto => parseFloat(objeto

                        .importe) == parseFloat(objeto.total_pagado));

                    var total_pendiente = 0.00

                    pendientes.forEach(objeto => {

                        var importePendiente = parseFloat(objeto.importe) - parseFloat(

                            objeto.total_pagado);

                        total_pendiente += parseFloat(importePendiente);

                    });

                    $("#pendientes_count").text(pendientes.length)

                    $("#pagados_count").text(pagados.length)

                    $("#total_pendiente").text(formatearNumero(parseFloat(total_pendiente)

                        .toFixed(2)) + "€")

                    return pagados;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },

            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "id_factura_proveedor",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre"

                },

                {

                    "data": "numero"

                },

                {

                    "data": "importe",

                    "render": function(data, type, row, meta) {

                        var importe = formatearNumero(parseFloat(data).toFixed(2));

                        return importe + '€';

                    }

                },

                {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        var importe = parseFloat(data.importe) - parseFloat(data

                            .total_pagado)

                        importe = formatearNumero(parseFloat(importe).toFixed(2));

                        return importe + '€';

                    }

                },

                {

                    "data": "fecha_vencimiento",

                    "render": function(data, type, row, meta) {

                        return new moment(data).format("YYYY-MM-DD")

                    }

                },

                {

                    "data": "fecha",

                    "render": function(data, type, row, meta) {

                        return new moment(data).format("YYYY-MM-DD")

                    }

                },

                {

                    "data": "pagos",

                    "render": function(data, type, row, meta) {

                        // Crear la lista ul

                        const Div = document.createElement('div');

                        data.forEach(function(p) {

                            const nuevoDiv = document

                                .createElement('div');

                            nuevoDiv.classList.add('table-dropdown', 'mb-2');

                            var divDropdown = document.createElement(

                                'div');

                            divDropdown.className =

                                'dropdown d-block user-dropdown';

                            var link = document.createElement('a');

                            link.className =

                                'dropdown-toggle d-flex align-items-center';

                            link.id = 'UserDropdown';

                            link.href = '#';

                            link.setAttribute('data-toggle',

                                'dropdown');

                            link.setAttribute('aria-expanded', 'false');

                            link.textContent = new moment(p.fecha).format(

                                "YYYY-MM-DD")

                            var dropdownMenu = document.createElement(

                                'div');

                            dropdownMenu.className =

                                'p-2 dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                            dropdownMenu.setAttribute('aria-labelledby',

                                'UserDropdown');

                            var nuevoLi = document.createElement('p');

                            nuevoLi.className = 'mb-1';

                            // Crear el elemento <strong>

                            var strongElement = document.createElement('strong');

                            strongElement.textContent = "Método de pago: ";

                            // Agregar el <strong> al <p>

                            nuevoLi.appendChild(strongElement);

                            // Agregar el texto después del <strong>

                            var metodoText = document.createTextNode(p.metodo);

                            nuevoLi.appendChild(metodoText);

                            dropdownMenu.appendChild(

                                nuevoLi);

                            var nuevoLi3 = document

                                .createElement('p');

                            nuevoLi3.className =

                                'mb-1';

                            var strongElement2 = document.createElement('strong');

                            strongElement2.textContent = "Banco: ";

                            // Agregar el <strong> al <p>

                            nuevoLi3.appendChild(strongElement2);

                            // Agregar el texto después del <strong>

                            var bancoText = document.createTextNode(p.banco);

                            nuevoLi3.appendChild(bancoText);

                            dropdownMenu.appendChild(

                                nuevoLi3);

                            var nuevoLi4 = document

                                .createElement('p');

                            nuevoLi4.className =

                                'mb-0';

                            var strongElement3 = document.createElement('strong');

                            strongElement3.textContent = "Importe: ";

                            // Agregar el <strong> al <p>

                            nuevoLi4.appendChild(strongElement3);

                            // Agregar el texto después del <strong>

                            var importeText = document.createTextNode(

                                formatearNumero(

                                    parseFloat(p

                                        .importe).toFixed(2)

                                ) + "€");

                            nuevoLi4.appendChild(importeText);

                            dropdownMenu.appendChild(

                                nuevoLi4);

                            const nuevoEnlace = document

                                .createElement('a');

                            nuevoEnlace.setAttribute(

                                'data-id', p

                                .id_pago_proveedor);

                            nuevoEnlace.style.cursor =

                                'pointer';

                            nuevoEnlace.setAttribute('type',

                                'button');

                            nuevoEnlace.classList.add(

                                'btn_eliminar_pago');

                            // Crear el icono dentro del enlace

                            const nuevoIcono = document

                                .createElement('i');

                            nuevoIcono.classList.add(

                                'ti-trash');

                            nuevoEnlace.appendChild(

                                nuevoIcono);

                            dropdownMenu.appendChild(

                                nuevoEnlace);

                            divDropdown.appendChild(link);

                            divDropdown.appendChild(dropdownMenu);

                            nuevoDiv.appendChild(divDropdown);

                            Div.appendChild(nuevoDiv);

                        });

                        return Div.outerHTML;

                    }

                }, {

                    "data": null,

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonEnviar = document.createElement('button');

                        buttonEnviar.className = 'btn_marcar_pagado p-1 dropdown-item';

                        buttonEnviar.setAttribute('type', 'button');

                        buttonEnviar.setAttribute('data-id', data.id_factura_proveedor)

                        buttonEnviar.innerHTML = `

                    <lord-icon src="./assets/lordicons/send.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Marcar como pagado`;

                        var buttonVerPresupuesto = document.createElement('button');

                        buttonVerPresupuesto.className =

                            'btn_descontar p-1 dropdown-item';

                        buttonVerPresupuesto.setAttribute('type', 'button');

                        buttonVerPresupuesto.setAttribute('data-id', data

                            .id_factura_proveedor)

                        buttonVerPresupuesto.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Descontar

                `;

                        var buttonFotos = document.createElement('button');

                        buttonFotos.className = 'btn_modal_archivos p-1 dropdown-item';

                        buttonFotos.setAttribute('type', 'button');

                        buttonFotos.setAttribute('data-id', data.id_factura_proveedor);

                        buttonFotos.innerHTML = `

                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Archivos

                `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =

                            'btn_eliminar_factura_proveedor p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data.id_factura_proveedor)

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;

                        dropdownMenu.appendChild(buttonFotos);

                        // dropdownMenu.appendChild(buttonVerPresupuesto);

                        //dropdownMenu.appendChild(buttonEnviar);

                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }

                }

            ]

        });

        $("#archivo_file").change(function(e) {

            var archivo = $('#archivo_file')[0].files[0];

            $("#archivo_archivo").val(archivo.name)

        });

        $("#btn_add_archivo").click(function() {

            var archivo = $('#archivo_file')[0].files[0];

            var id_factura_proveedor = $('#btn_subir_archivo').data("id")

            var nombre = $("#nombre_archivo").val();

            if (!archivo) {

                $.toast({

                    heading: 'Ningún archivo seleccionado.',

                    text: 'Por favor, selecciona un archivo para subir.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            if (nombre == "") {

                $.toast({

                    heading: 'Ningún nombre seleccionado.',

                    text: 'Por favor, agrega un nombre al archivo para subir.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            var extension = archivo.type.split('/').pop();

            if (extension == "jpeg") {

                extension = "jpg"

            }

            if (archivo.size > 3000000) {

                $.toast({

                    heading: 'Archivo demasiado pesado.',

                    text: 'El archivo debe pesar menos 3 MB.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            var fd = new FormData();

            fd.append('archivo', archivo);

            fd.append('extension', extension);

            fd.append('nombre', nombre);

            fd.append('id_factura_proveedor_archivo', id_factura_proveedor);

            var contenedor = document.getElementById('lista_archivos');

            var divElement = document.createElement('div');

            divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

                'justify-content-center', 'align-items-center');

            // Crear un elemento div para la clase "archivo_lista"

            var archivoListaDiv = document.createElement('div');

            archivoListaDiv.classList.add('archivo_lista', 'd-flex',

                'justify-content-center', 'align-items-center');

            var imgElement = document.createElement('img');

            imgElement.classList.add('img-fluid');

            imgElement.setAttribute('alt', '');

            imgElement.setAttribute('src', './assets/images/oval.svg');

            // Agregar elementos al div "archivo_lista"

            archivoListaDiv.appendChild(imgElement);

            divElement.appendChild(archivoListaDiv);

            // Agregar el div "archivo_lista" al div principal

            contenedor.insertAdjacentElement('afterbegin', divElement);

            $.ajax({

                url: './api/factura_proveedor.php',

                type: 'POST',

                data: fd,

                async: false,

                cache: false,

                processData: false, // tell jQuery not to process the data

                contentType: false, // tell jQuery not to set contentType

                success: function(result) {

                    console.log(result);

                    if (result == "0") {

                        $.toast({

                            heading: 'Nombre repetido.',

                            text: 'Selecciona otro nombre para el archivo.',

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 5000,

                            stack: 6

                        });

                        divElement.remove()

                        return false

                    } else {

                        CargarArchivos(id_factura_proveedor)

                        $.toast({

                            heading: 'Nuevo archivo subido.',

                            text: 'Se subido el nuevo archivo correctamente.',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 4

                        })

                    }

                }

            });

        });

        function CargarArchivos(id_factura_proveedor) {

            var contenedor = document.getElementById('lista_archivos');

            contenedor.innerHTML = ""

            $.ajax({

                url: './api/factura_proveedor.php?id_factura_proveedor_archivos=' +

                    id_factura_proveedor,

                type: 'GET',

                cache: false,

                async: false,

                dataType: 'json', // added data type

                success: function(result) {

                    console.log(result);

                    for (let r of result) {

                        r.url = r.url.slice(1)

                        console.log(r);

                        var divElement = document.createElement('div');

                        divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

                            'justify-content-center', 'align-items-center');

                        // Crear un elemento div para la clase "archivo_lista"

                        var archivoListaDiv = document.createElement('div');

                        archivoListaDiv.classList.add('archivo_lista', 'd-flex',

                            'justify-content-center', 'align-items-center');

                        if (r.extension != "pdf") {

                            // Crear un elemento img

                            var imgElement = document.createElement('img');

                            imgElement.classList.add('img-fluid');

                            imgElement.setAttribute('alt', '');

                            imgElement.setAttribute('src', r.url);

                        } else {

                            var iframe = document.createElement('iframe');

                            iframe.setAttribute('src', r.url);

                            iframe.style.width = "100%";

                            iframe.style.height = "100%";

                        }

                        // Crear un botón para eliminar

                        var btnEliminar = document.createElement('button');

                        btnEliminar.classList.add('p-1', 'btn_eliminar_archivo', 'btn');

                        btnEliminar.setAttribute('data-url', r.url);

                        btnEliminar.setAttribute('data-id', id_factura_proveedor);

                        btnEliminar.setAttribute('type', 'button');

                        btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';

                        // Crear un botón para seleccionar

                        var btnSeleccionar = document.createElement('button');

                        btnSeleccionar.classList.add('p-1', 'btn_seleccionar_archivo',

                            'btn');

                        btnSeleccionar.setAttribute('data-url', r.url);

                        btnSeleccionar.setAttribute('data-extension', r.extension);

                        btnSeleccionar.setAttribute('type', 'button');

                        btnSeleccionar.innerHTML = '<i class="m-0 fa fa-eye"></i>';

                        var nombre = document.createElement('a');

                        nombre.textContent = r.nombre

                        nombre.setAttribute('data-nombre', r.nombre);

                        nombre.setAttribute('data-url', r.url);

                        nombre.setAttribute('data-extension', r.extension);

                        nombre.classList.add("nombre_archivo_div")

                        nombre.innerHTML += '<i class="ml-2 fa fa-download"></i>';

                        // Agregar elementos al div "archivo_lista"

                        if (r.extension != "pdf") {

                            // Crear un elemento img

                            archivoListaDiv.appendChild(imgElement);

                        } else {

                            archivoListaDiv.appendChild(iframe);

                        }

                        archivoListaDiv.appendChild(btnEliminar);

                        archivoListaDiv.appendChild(btnSeleccionar);

                        // Agregar el div "archivo_lista" al div principal

                        divElement.appendChild(archivoListaDiv);

                        divElement.appendChild(nombre);

                        contenedor.appendChild(divElement);

                    }

                }

            })

        }

        $(document).on("click", ".btn_modal_archivos", function() {

            $('#btn_subir_archivo').data("id", $(this).data("id"))

            CargarArchivos($(this).data("id"))

            $("#modalSubirArchivo").modal("show");

        });

        $(document).on("click", ".btn_seleccionar_archivo", function() {

            var url = $(this).data("url");

            var extension = $(this).data("extension");

            var div = document.getElementById("contenedor_archivo")

            div.innerHTML = ""

            if (extension !== "pdf") {

                // Crear un elemento <img>

                var imgElement = document.createElement("img");

                // Establecer los atributos del elemento <img>

                imgElement.id = "archivo_modal";

                imgElement.className = "w-100 img-fluid";

                imgElement.src = url; // Aquí establece la fuente de la imagen que desees

                imgElement.alt = "";

                // Agregar el elemento <img> al documento

                div.appendChild(imgElement);

            } else {

                var iframe = document.createElement('iframe');

                iframe.setAttribute('id', 'archivo_modal');

                iframe.setAttribute('src', url);

                iframe.style.width = "100%"

                iframe.style.height = "400px"

                div.appendChild(iframe);

            }

            $("#modalVerArchivo").modal("show");

        });

        $(document).on("click", ".nombre_archivo_div", function() {

            var nombre = $(this).data("nombre");

            var url = $(this).data("url");

            var extension = $(this).data("extension");

            $(this).attr("download", nombre + "." + extension)

            $(this).attr("href", url)

        });

        $(document).on("click", ".btn_eliminar_archivo", function() {

            var id = $(this).data("id");

            var url = $(this).data("url");

            $.ajax({

                type: "DELETE",

                url: "./api/factura_proveedor.php?url=" + url,

                cache: false,

                async: false,

                success: function(response) {

                    console.log(response);

                    CargarArchivos(id)

                    $.toast({

                        heading: 'Archivo eliminado.',

                        text: 'Se eliminado el archivo correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    })

                }

            })

        });

    });

})(jQuery);
</script>

<script>
(function($) {

    'use strict';

    $(function() {

        $('#btn_descargar_excel').click(function(event) {

            var fecha_i = new moment($("#fecha_i").val()).format("YYYY-MM-DD")

            var fecha_f = new moment($("#fecha_f").val()).format("YYYY-MM-DD")

            var nuevaUrl = "/api/factura_proveedor.php"

            $.ajax({

                type: 'GET',

                url: nuevaUrl,

                cache: false,

                async: false,

                dataType: "json",

                success: function(facturas) {

                    console.log(facturas);

                    var libro = XLSX.utils.book_new();

                    var hoja = XLSX.utils.aoa_to_sheet([]);

                    var estiloNegrita = {

                        font: {

                            bold: true

                        }

                    };

                    var titulo = [

                        [

                            "Informe de pagos a proveedores <?php echo htmlentities($personalizacion['nombre'], ENT_QUOTES); ?>"

                        ]

                    ];

                    XLSX.utils.sheet_add_aoa(hoja, titulo, {

                        origin: "A1"

                    });

                    // Crear y agregar la fila de encabezado

                    var headers = ["Número", "Proveedor", "Fecha", "Fecha vencimiento",

                        "Importe", "Importe restante"

                    ];

                    XLSX.utils.sheet_add_aoa(hoja, [headers], {

                        origin: "A2"

                    });

                    var currentRow = 3; // Fila inicial después del encabezado y título

                    facturas.forEach(factura => {

                        var importe_restante = parseFloat(factura.importe) -

                            parseFloat(factura

                                .total_pagado)

                        let fila = [

                            factura.numero,

                            factura.nombre,

                            new moment(factura.fecha).format("YYYY-MM-DD"),

                            new moment(factura.fecha_vencimiento).format(

                                "YYYY-MM-DD"),

                            formatearNumero(parseFloat(factura.importe)

                                .toFixed(2)),

                            formatearNumero(parseFloat(importe_restante)

                                .toFixed(2))

                        ];

                        XLSX.utils.sheet_add_aoa(hoja, [fila], {

                            origin: "A" + currentRow

                        });

                        currentRow++; // Incrementar la fila

                    });

                    var range = XLSX.utils.decode_range(hoja["!ref"]);

                    if (!hoja["!merges"]) hoja["!merges"] = [];

                    hoja["!merges"].push({

                        s: {

                            r: 0,

                            c: 0

                        },

                        e: {

                            r: 0,

                            c: range.e.c

                        }

                    });

                    XLSX.utils.book_append_sheet(libro, hoja, "Informe_pagos");

                    const u8 = XLSX.write(libro, {

                        bookType: "xlsx",

                        type: "buffer"

                    });

                    const parts = [u8]; // `Blob` constructor expects this

                    /* create Blob */

                    const blob = new Blob(parts, {

                        type: "application/download"

                    });

                    var enlaceDescarga = document.createElement('a');

                    enlaceDescarga.href = window.URL.createObjectURL(blob);

                    enlaceDescarga.download = "Informe_pagos.xlsx";

                    // Agregar el enlace al documento y simular el clic para iniciar la descarga

                    document.body.appendChild(enlaceDescarga);

                    enlaceDescarga.click();

                    // Eliminar el enlace después de la descarga

                    document.body.removeChild(enlaceDescarga);

                }

            });

            return false;

        });

    });

})(jQuery);
</script>