<div class="content-wrapper">

    <div class="row profile-page ">
        <div class="col-md-12 mb-8">
            <div class="card satmar-bottom">
                <div class="sato-border-blue">

                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/keborgyy.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>
                        <p class="mb-2">Formularios</p>
                        <span id="formularios_count"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row profile-page">
        <div class="col-12">
            <div class="card p-3 p-sm-4">
                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0">

                        <div class="row ">
                            <!-- Historial de Acceso -->
                            <div class="col-md-12">
                                <div class="card card-cuenta">

                                    <div class="card-body card-table-body p-3 p-sm-4">

                                        <table id="tabla_miembros" style="min-height:120px;" cellspacing="0"
                                            class="table display nowrap">
                                            <thead>
                                                <tr>
                                                    <th
                                                        style="padding-left: 32px !important;padding-right: 50px !important;">
                                                        ID</th>
                                                    <th>Nombre</th>
                                                    <th>Incripciones</th>
                                                    <th>Estado</th>


                                                    <th style="text-align:center;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                            <!-- /Historial de Acceso -->
                            <!-- Eliminación de cuenta -->

                            <!-- /Eliminación de cuenta -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEliminarFormulario" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el formulario definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">



                <button id="btn_eliminar_formulario" class="btn btn-danger btn-fw" type="button" name="">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<!-- MODALS -->



<script>
(function($) {

    'use strict';

    $(function() {

        var Table = $('#tabla_miembros').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en usuarios",
                infoEmpty: "Mostrando 0 a 0 de 0 en usuarios",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/formularios.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                dataSrc: function(json) {
                    var data = json
                    $("#formularios_count").text(data.length)
                    return data;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {

            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_formulario",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "nombre_formulario"
                },
                {
                    "data": "inscripciones"
                },
                {
                    "data": "estado"
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var linkEditar = document.createElement('a');
                        linkEditar.className = 'p-1 dropdown-item';
                        linkEditar.href = `./editar_formulario?id=${data.id_formulario}`;
                        linkEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#00000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                `;



                        // Obtener el protocolo (http o https)
                        var protocolo = window.location.protocol;

                        // Obtener el dominio (por ejemplo, www.ejemplo.com)
                        var dominio = window.location.hostname;

                        // Construir la URL base
                        var urlBase = protocolo + '//' + dominio;

                        var buttonCopiar = document.createElement('button');
                        buttonCopiar.className =
                            'btn_copiar_url p-1 dropdown-item';
                        buttonCopiar.setAttribute('type', 'button');
                        buttonCopiar.setAttribute('data-url', urlBase +
                            '/formulario?id=' + data.id_formulario);
                        buttonCopiar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Copiar
                `;




                        var buttonAceptar = document.createElement('button');
                        buttonAceptar.className =
                            'btn_activar_formulario p-1 dropdown-item';
                        buttonAceptar.setAttribute('type', 'button');
                        buttonAceptar.setAttribute('data-id', data.id_formulario)

                        buttonAceptar.setAttribute('data-estado', "Activo");
                        buttonAceptar.innerHTML = `
                    <lord-icon src="./assets/lordicons/aceptar.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Activar
                    
                `;
                        var buttonRechazar = document.createElement('button');
                        buttonRechazar.className =
                            'btn_activar_formulario p-1 dropdown-item';
                        buttonRechazar.setAttribute('type', 'button');
                        buttonRechazar.setAttribute('data-id', data.id_formulario)

                        buttonRechazar.setAttribute('data-estado', "Inactivo");
                        buttonRechazar.innerHTML = `
                    <lord-icon src="./assets/lordicons/rechazar.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Desactivar
                    
                `;


                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_formulario p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data.id_formulario);
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;

                        if (data.estado == "Activo") {

                            dropdownMenu.appendChild(buttonRechazar);
                        } else {

                            dropdownMenu.appendChild(buttonAceptar);
                        }

                        dropdownMenu.appendChild(linkEditar);
                        dropdownMenu.appendChild(buttonCopiar);

                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        });


        $(document).on("click", ".btn_activar_formulario", function() {
            var id_formulario_atributo = $(this).data("id")
            var atributo = "estado"
            var valor = $(this).data("estado")
            CambiarAtributo(id_formulario_atributo, valor, atributo)
            Table.ajax.reload(null, false);
        })

        function CambiarAtributo(id_formulario_atributo, valor, atributo) {
            var r = false
            $.ajax({
                type: 'POST',
                url: './api/formularios.php',
                cache: false,
                async: false,
                dataType: 'json',
                data: {
                    id_formulario_atributo: id_formulario_atributo,
                    valor: valor,
                    atributo: atributo
                },
                success: function(result2) {

                    r = result2
                    $.toast({
                        heading: 'Estado cambiado.',
                        text: 'Se ha cambiado el estado del formulario correctamente.',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                    return r
                }
            });
            return r

        }

        function copiarAlPortapapeles(url) {

            // Crea un campo de texto "oculto"
            var aux = document.createElement("input");

            // Asigna el contenido del elemento especificado al valor del campo
            aux.setAttribute("value", url);

            // Añade el campo a la página
            document.body.appendChild(aux);

            // Selecciona el contenido del campo
            aux.select();

            // Copia el texto seleccionado
            document.execCommand("copy");

            // Elimina el campo de la página
            document.body.removeChild(aux);

        }
        $(document).on("click", ".btn_copiar_url", function() {
            var url = $(this).data("url")
            copiarAlPortapapeles(url)
            $.toast({
                heading: 'URL copiada.',
                text: 'Se ha copiado la URL al portapapeles.',
                position: 'top-right',
                loaderBg: '#32a852',
                icon: 'success',
                hideAfter: 2000,
                stack: 6
            })
        });

        $(document).on("click", ".btn_eliminar_formulario", function() {
            var id = $(this).data("id")
            $("#btn_eliminar_formulario").data("id", id)
            $("#modalEliminarFormulario").modal('show');
        });

        $('#btn_eliminar_formulario').click(function(event) {

            var id = $("#btn_eliminar_formulario").data("id")


            $.ajax({
                type: 'DELETE',
                url: './api/formularios.php?id=' + id,
                cache: false,
                success: function(result) {


                    $.toast({
                        heading: 'Formulario eliminado',
                        text: 'Se ha eliminado el formulario correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })


                    $('#modalEliminarFormulario').modal('hide');

                    Table.ajax.reload(null, false);


                }
            });

            return false;
        });
    });

})(jQuery);
</script>