<div class="content-wrapper">



    <div class="row profile-page ">

        <div class="col-md-12">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/efdggetp.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Fichajes totales</p>

                        <span id="fichajes_count" class=""></span>

                    </div>

                </div>

            </div>

        </div>

    </div>





    <div class="row profile-page">

        <div class="col-12">

            <div class="card p-3">




                <div class="card-body p-3 card-table-body">




                    <div class="row ">
                        <div class="col-md-4 col-xl-3">

                            <div class="form-group">

                                <label for="my-input">Fecha de inicio</label>

                                <input class="form-control" type="month" id="fecha_i">

                            </div>



                        </div>

                        <div class="col-md-4 col-xl-3">

                            <div class="form-group">

                                <label for="my-input">Fecha de fin</label>

                                <input class="form-control" type="month" id="fecha_f">

                            </div>



                        </div>
                        <!-- Historial de Acceso -->

                        <div class="col-12 table-responsive">




                            <table id="tabla_fichajes" class="table tabla_fichajes">

                                <thead>

                                    <tr>

                                        <th style="padding-left: 32px !important;padding-right: 50px !important;">

                                            ID

                                        </th>



                                        <th>Fecha entrada</th>

                                        <th>En descanso</th>

                                        <th>Fecha salida</th>

                                        <th>Horas totales</th>

                                        <th>Estado</th>
                                        <th>Observaciones</th>
                                        <th>Acciones</th>

                                    </tr>

                                </thead>

                                <tbody>





                                </tbody>

                            </table>



                        </div>
                    </div>


                    <!-- /Historial de Acceso -->

                    <!-- Eliminación de cuenta -->



                    <!-- /Eliminación de cuenta -->

                </div>





            </div>

        </div>

    </div>



</div>





<!-- MODALS -->







<script>
(function($) {



    'use strict';



    $(function() {



        $("#fecha_i, #fecha_f").change(function() {

            var fecha_i = new moment($("#fecha_i").val()).format("YYYY-MM-DD")

            var fecha_f = new moment($("#fecha_f").val()).format("YYYY-MM-DD")



            if ($("#fecha_i").val() != "" && $("#fecha_f").val() != "") {

                var nuevaUrl = `./api/fichajes.php?id_miembro2=
                <?php if ($Miembro != null) {

                echo $Miembro["id_miembro"];

                } else {

                echo 0;

                } ?>&fecha_i=${fecha_i}&fecha_f=${fecha_f} `

                $('#tabla_fichajes').DataTable().ajax.url(nuevaUrl).load();

            } else {

                var nuevaUrl = `./api/fichajes.php?id_miembro2=
                <?php if ($Miembro != null) {

                echo $Miembro["id_miembro"];

                } else {

                echo 0;

                } ?>`

                $('#tabla_fichajes').DataTable().ajax.url(nuevaUrl).load();

            }

        })

        function segundosAHorasYMinutos(segundos) {

            const horas = Math.floor(segundos / 3600); // 3600 segundos en una hora

            const minutos = Math.floor((segundos % 3600) / 60); // El residuo en minutos

            return {

                horas: horas,

                minutos: minutos

            };

        }
        $('.tabla_fichajes').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, -1],

                [10, 25, 50, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en fichajes",

                infoEmpty: "Mostrando 0 a 0 de 0 en fichajes",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",



                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [



                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }

            ],

            "searching": true,

            "ajax": {

                url: `./api/fichajes.php?id_miembro2=
                <?php if ($Miembro != null) {

                echo $Miembro["id_miembro"];

                } else {

                echo 0;

                } ?>`,

                method: 'GET',

                cache: false,

                dataSrc: function(json) {

                    console.log(json);

                    var res = json

                    $("#fichajes_count").text(res.length)

                    return res;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },



            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado



                //$('#tabla_clientes_aceptados').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "id_fichaje",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "fecha_entrada"

                },

                {

                    "data": "horas_descanso",

                    "render": function(data, type, row, meta) {

                        var segundos = data; // Ejemplo de 7325 segundos

                        var resultado = segundosAHorasYMinutos(segundos);





                        return `${resultado.horas} hs, ${resultado.minutos} min`;

                    }

                },

                {

                    "data": "fecha_salida"

                },

                {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        var fechaInicioStr = data.fecha_entrada;

                        var fechaFinStr = data.fecha_salida;



                        // Convierte las fechas en objetos Moment

                        var fechaInicio = moment(fechaInicioStr, 'YYYY-MM-DD HH:mm:ss');

                        var fechaFin = moment(fechaFinStr, 'YYYY-MM-DD HH:mm:ss');



                        // Calcula la diferencia en minutos

                        var diferenciaMinutos = fechaFin.diff(fechaInicio, 'minutes');



                        // Calcula las horas y minutos

                        var horas = Math.floor(diferenciaMinutos / 60);

                        var minutos = diferenciaMinutos % 60;





                        return `${horas} hs, ${minutos} min`;

                    }

                },

                {

                    "data": "estado"

                },

                {

                    "data": null,

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';



                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Observaciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu drop_observaciones dropdown-menu-right navbar-dropdown p-3';

                        dropdownMenu.style.maxWidth = '200px';

                        dropdownMenu.setAttribute('data-id', data.id_fichaje);





                        var span = document.createElement('span');

                        span.className = 'p-1 observacion_span';


                        if (data.observaciones != null) {

                            span.innerHTML = `${data.observaciones}`;

                        } else {

                            span.innerHTML = ``;

                        }



                        span.contentEditable = false;
                        span.setAttribute('data-id', data.id_fichaje);
                        var editBtn = document.createElement('button');
                        editBtn.className =
                            'btn_edit_observaciones p-1 border-0 btn btn-sm btn-outline-primary position-absolute';
                        editBtn.style.top = '0px';
                        editBtn.style.right = '0px';
                        editBtn.setAttribute('data-id', data.id_fichaje);
                        editBtn.innerHTML =
                            '<i class="fas fa-pencil-alt m-0"></i>'; // Asegúrate de tener FontAwesome cargado



                        dropdownMenu.appendChild(editBtn); // Añadir primero el botón


                        dropdownMenu.appendChild(span);





                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);
                        return td.outerHTML;




                    }

                },

                {

                    "data": "id_fichaje",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');









                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className = 'btn_eliminar_fichaje p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

        <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

        Eliminar

    `;





                        dropdownMenu.appendChild(buttonEliminar);



                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);



                        return td.outerHTML;

                    }

                }

            ]



        });





        // Activar edición al hacer clic en el botón
        $(document).on('click', '.btn_edit_observaciones', function(e) {
            console.log('click en editar observaciones');

            e.stopPropagation(); // evita que se cierre el dropdown

            const id = $(this).data('id');
            const span = $('.observacion_span[data-id="' + id + '"]');

            span.attr('contenteditable', true).focus();
        });

        // Evitar que el dropdown se cierre al hacer clic dentro de él
        $(document).on('click', '.drop_observaciones', function(e) {
            console.log('click en editar observaciones');

            e.stopPropagation();
        });

        // Desactivar edición al perder el foco o presionar Enter
        $(document).on('keydown blur', '.observacion_span', function(e) {
            const span = $(this);
            const id = span.data('id');

            if (e.type === 'blur' || e.key === 'Enter') {
                e.preventDefault();
                span.attr('contenteditable', false);

                // Aquí podrías guardar el contenido actualizado
                const newText = span.text();

                $.ajax({

                    type: 'POST',

                    url: './api/fichajes.php',

                    cache: false,

                    async: false,

                    dataType: 'json',

                    data: {

                        id_fichaje_atributo: id,

                        valor: newText,

                        atributo: "observaciones"

                    },

                    success: function(result2) {





                        $.toast({

                            heading: 'Observaciones editadas.',

                            text: 'Se han cambiado las observaciones correctamente.',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 4

                        })
                        $('.tabla_fichajes').DataTable().ajax.reload(null, false);


                    }

                });

                // Ejemplo de AJAX para guardar los datos (opcional)
                /*
                $.post('/ruta/para/guardar', { id: id, texto: newText }, function (response) {
                    console.log('Guardado', response);
                });
                */
            }
        });




    });



})(jQuery);
</script>