<div class="content-wrapper">
    <div class="row profile-page ">
        <div class="col-md-6 mb-3">
            <div class="card satmar-bottom mb-0">
                <div class="sato-border-blue">
                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/gkubkjgd.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>
                        <p class="mb-2">Materiales totales</p>
                        <span id="user_count" class=""></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-3">

            <div class="card satmar-bottom mb-0">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/gmmzjbyl.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Packs totales</p>

                        <span id="packs_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>
    </div>
    <div class="row profile-page mb-3">
        <div class="col-12">
            <div class="card">
                <div class="" style="padding-bottom: 0px !important;">
                    <div class="pt-0 ">
                        <div class="row ">
                            <div class="col-md-12">
                                <div class="row p-3">
                                    <div class="col-12 col-sm-auto pr-sm-0">
                                        <button type="button" data-toggle="modal" data-target="#modalAgregarMaterial"
                                            class="btn btn-sm btn-primary">Agregar</button>
                                    </div>

                                </div>
                                <div class="card card-cuenta">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-12">
                                                <h4 class="mb-0">Listado de Materiales</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body card-table-body p-3">
                                        <div class="row">
                                            <div class="col-12 col-sm-auto pr-sm-0">
                                                <div class="form-group">
                                                    <label>Familia</label>
                                                    <div class="input-group">
                                                        <span class="input-group-prepend">
                                                            <button
                                                                class="btn_eliminar_familia file-upload-browse btn btn-danger"
                                                                data-target="filtro_familias" type="button">-</button>
                                                        </span>
                                                        <select id="filtro_familias"
                                                            class="select_familias custom-select select2 form-control"
                                                            data-target="filtro_subfamilias">
                                                        </select>
                                                        <span class="input-group-append">
                                                            <button class="file-upload-browse btn btn-info"
                                                                type="button" data-toggle="modal"
                                                                data-target="#modalAgregarFamilia">+</button>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-sm-auto pr-sm-0">
                                                <div class="form-group">
                                                    <label>Subfamilia</label>
                                                    <div class="input-group">
                                                        <span class="input-group-prepend">
                                                            <button
                                                                class="btn_eliminar_subfamilia file-upload-browse btn btn-danger"
                                                                data-target="filtro_subfamilias"
                                                                type="button">-</button>
                                                        </span>
                                                        <select id="filtro_subfamilias"
                                                            class="select_subfamilias custom-select select2 form-control">
                                                        </select>
                                                        <span class="input-group-append">
                                                            <button class="file-upload-browse btn btn-info"
                                                                type="button" data-toggle="modal"
                                                                data-target="#modalAgregarSubfamilia">+</button>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <table id="tabla_materiales" style="min-height:120px;" cellspacing="0"
                                            class="table display nowrap">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Nombre</th>


                                                    <th> Familia</th>
                                                    <th>Subfamilia</th>
                                                    <th>Estado</th>
                                                    <th>Precio por día</th>
                                                    <th>Stock</th>
                                                    <th style="text-align:center;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row profile-page">
        <div class="col-12">
            <div class="card">
                <div class="" style="padding-bottom: 0px !important;">
                    <div class="pt-0 ">
                        <div class="row ">
                            <div class="col-md-12">
                                <div class="row p-3">
                                    <div class="col-12">
                                        <button type="button" data-toggle="modal" data-target="#modalAgregarPack"
                                            class="btn btn-sm btn-primary">Agregar</button>
                                    </div>
                                </div>
                                <div class="card card-cuenta">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-12">
                                                <h4 class="mb-0">Listado de Packs</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body card-table-body p-3">
                                        <table id="tabla_packs" style="min-height:120px;" cellspacing="0"
                                            class="table display nowrap">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Nombre</th>

                                                    <th>Materiales</th>
                                                    <th style="text-align:center;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __VIEWS__ . 'selects/materiales.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/packs.template.php'; ?>

<!-- MODALS -->






<script>
(function($) {
    'use strict';
    $(function() {

        $("#filtro_subfamilias").change(function(e) {

            //$('.tabla_clientes').DataTable().ajax.reload(null, false);

            $('#tabla_materiales').DataTable().ajax.reload(null, false);

        });
        var Table = $('#tabla_materiales').DataTable({
            responsive: true,
            dom: 'Blfrtip',
            aLengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            iDisplayLength: 10,
            language: {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ materiales",
                infoEmpty: "Mostrando 0 a 0 de 0 materiales",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                lengthMenu: "Mostrar _MENU_ Entradas",
                processing: "Cargando...",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            stateSave: true,
            stateSaveCallback: function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            stateLoadCallback: function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            order: [
                [0, "desc"]
            ],
            buttons: [{
                extend: 'colvis',
                text: 'Ocultar Columnas',
                collectionLayout: 'fixed two-column',
                className: "form-control"
            }],
            searching: true,
            ajax: {
                url: '/api/materiales2.php',
                method: 'GET',
                data: function(d) {

                    // Agregar parámetros adicionales a la solicitud aquí

                    d.id_familia = $("#filtro_familias").val();

                    d.id_subfamilia = $("#filtro_subfamilias").val();


                },
                dataSrc: function(json) {
                    $("#user_count").text(json.length);
                    return json;
                }
            },
            columns: [{
                    data: "id_material"
                },
                {
                    data: "nombre"
                },
                {
                    data: "nombre_familia"
                },
                {
                    data: "nombre_subfamilia"
                },
                {
                    data: "estado"
                },
                {
                    data: "precio_dia",
                    render: function(data, type, row) {
                        return data ? `$${parseFloat(data).toFixed(2)}€` : '-';
                    }
                },
                {
                    data: "stock"
                },
                {
                    data: "id_material",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var linkVerPerfil = document.createElement('a');

                        linkVerPerfil.className = 'p-1 dropdown-item';

                        linkVerPerfil.href = `./cliente?id=${data}`;

                        linkVerPerfil.innerHTML = `

 <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#00000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Ver Perfil

 `;

                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'btn_edit_material p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data);

                        buttonEditar.innerHTML = `

 <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Editar

 `;

                        var buttonAceptar = document.createElement('button');

                        buttonAceptar.className =
                            'btn_complementos_material p-1 dropdown-item';

                        buttonAceptar.setAttribute('type', 'button');

                        buttonAceptar.setAttribute('data-id', data);

                        buttonAceptar.innerHTML = `

 <lord-icon src="./assets/lordicons/mic.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Complementos

 `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =
                            'btn_eliminar_material p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

 `;

                        var buttonCambiarEstado = document.createElement('button');

                        buttonCambiarEstado.className =

                            'btn_cambiar_estado p-1 dropdown-item';

                        buttonCambiarEstado.setAttribute('type', 'button');

                        buttonCambiarEstado.setAttribute('data-id', data);

                        buttonCambiarEstado.innerHTML = `

 <lord-icon src="./assets/lordicons/user.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Estado

 `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =
                            'btn_eliminar_material p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

 <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Eliminar

 `;

                        dropdownMenu.appendChild(buttonAceptar);

                        dropdownMenu.appendChild(buttonEditar);

                        dropdownMenu.appendChild(buttonEliminar);

                        //     dropdownMenu.appendChild(buttonCambiarEstado);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }
                }
            ]
        });

        $('#tabla_packs').DataTable({
            responsive: true,
            dom: 'Blfrtip',
            aLengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            iDisplayLength: 10,
            language: {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ packs",
                infoEmpty: "Mostrando 0 a 0 de 0 packs",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                lengthMenu: "Mostrar _MENU_ Entradas",
                processing: "Cargando...",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            stateSave: true,
            stateSaveCallback: function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            order: [
                [0, "desc"]
            ],
            buttons: [{
                extend: 'colvis',
                text: 'Ocultar Columnas',
                collectionLayout: 'fixed two-column',
                className: "form-control"
            }],
            ajax: {
                url: '/api/packs.php',
                method: 'GET',
                dataSrc: function(json) {


                    $("#packs_count").text(json.length);
                    return json;
                }
            },
            columns: [{
                    data: "id_pack"
                },
                {
                    data: "nombre"
                },
                {
                    data: "materiales",


                    render: function(data, type, row, meta) {



                        var ul = document.createElement('ul');

                        ul.classList.add("h-100", "list-group")

                        ul.style.overflowY = 'auto';

                        ul.style.maxHeight = '130px';

                        // Iterar sobre el arreglo de grupos

                        data.forEach(function(grupo) {

                            var li = document.createElement('li');

                            li.textContent = grupo.nombre + " (x" + grupo.cantidad +
                                ")";

                            li.classList.add("p-2",

                                "list-group-item", "d-flex",

                                "justify-content-between", "align-items-center")

                            // Establecer el atributo data-id con el id_grupo del grupo

                            li.setAttribute('data-id', grupo.id_material);

                            // Agregar el LI al UL

                            ul.appendChild(li);

                        });

                        return ul.outerHTML;

                    }
                },
                {
                    data: "id_pack",
                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var linkVerPerfil = document.createElement('a');

                        linkVerPerfil.className = 'p-1 dropdown-item';

                        linkVerPerfil.href = `./cliente?id=${data}`;

                        linkVerPerfil.innerHTML = `

 <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#00000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Ver Perfil

 `;

                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'btn_edit_pack p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data);

                        buttonEditar.innerHTML = `

 <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Editar

 `;

                        var buttonAceptar = document.createElement('button');

                        buttonAceptar.className = 'btn_aceptar_cliente p-1 dropdown-item';

                        buttonAceptar.setAttribute('type', 'button');

                        buttonAceptar.setAttribute('data-id', data);

                        buttonAceptar.innerHTML = `

 <lord-icon src="./assets/lordicons/aceptar.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Aceptar

 `;

                        var buttonCambiarEstado = document.createElement('button');

                        buttonCambiarEstado.className =

                            'btn_cambiar_estado p-1 dropdown-item';

                        buttonCambiarEstado.setAttribute('type', 'button');

                        buttonCambiarEstado.setAttribute('data-id', data);

                        buttonCambiarEstado.innerHTML = `

 <lord-icon src="./assets/lordicons/user.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Estado

 `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =
                            'btn_eliminar_pack p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

 <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000"
     style="width:30px;height:30px"></lord-icon>

 Eliminar

 `;

                        // dropdownMenu.appendChild(linkVerPerfil);

                        dropdownMenu.appendChild(buttonEditar);

                        dropdownMenu.appendChild(buttonEliminar);

                        //  dropdownMenu.appendChild(buttonCambiarEstado);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }
                }
            ]
        });

    });
})(jQuery);
</script>