<div class="content-wrapper">

    <div class="row profile-page ">
        <div class="col-12 d-flex justify-content-center flex-column align-items-center mb-0">
            <div class="card mb-3" style="max-width: 600px;">

                <div class="card-body p-3">
                    <div class="row">
                        <div class="col-12">
                            <h4 class="mb-3">Escaner de códigos de barra</h4>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div id="camera"></div>
                        </div>
                    </div>



                </div>


            </div>

            <!-- /Historial de Acceso -->
            <!-- Eliminación de cuenta -->

            <div class="card w-100 m-auto" style="max-width: 600px;">

                <div class="card-body p-3">
                    <div class="row">

                        <div class="col-12">
                            <button class="w-100 mb-3 btn btn-success btn-fw" id="btn_escanear"
                                type="button">Escanear</button>
                            <button class="w-100 btn btn-danger btn-fw" id="btn_pausar" type="button">Pausar</button>
                        </div>

                    </div>


                </div>

                <!-- /Historial de Acceso -->
                <!-- Eliminación de cuenta -->


            </div>
        </div>


    </div>

</div>





<style>
#camera video {
    width: 100%;
    border-radius: 0.25rem
}

#camera canvas {
    position: absolute;
    z-index: 1000;
    right: 0;
    width: 100%;
}
</style>





<?php require_once __VIEWS__ . 'js/pedidos.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/transportistas.template.php'; ?>

<script>
(function($) {

    'use strict';

    $(function() {

        // Configuración de QuaggaJS
        Quagga.init({
            inputStream: {
                name: "Live",
                type: "LiveStream",
                target: document.querySelector('#camera')
            },
            decoder: {
                readers: ["code_128_reader"]
            }
        }, function(err) {
            if (err) {
                console.log(err);
                return
            }

            Quagga.stop();

        });

        $("#btn_escanear").click(function(e) {
            Quagga.init({
                inputStream: {
                    name: "Live",
                    type: "LiveStream",
                    target: document.querySelector('#camera')
                },
                decoder: {
                    readers: ["code_128_reader"]
                }
            }, function(err) {
                if (err) {
                    console.log(err);
                    return
                }

                Quagga.start();
                Quagga.onDetected((result) => {

                    if (check(result.codeResult.code)) {
                        console.log(result.codeResult.code);
                        VerInfo(result.codeResult.code)
                        Quagga.stop();
                    }
                });
            });

        });
        $("#btn_pausar").click(function(e) {
            Quagga.init({
                inputStream: {
                    name: "Live",
                    type: "LiveStream",
                    target: document.querySelector('#camera')
                },
                decoder: {
                    readers: ["code_128_reader"]
                }
            }, function(err) {
                if (err) {
                    console.log(err);
                    return
                }

                Quagga.stop();

            });

        });

        function check(id) {
            var re = false
            $.ajax({
                url: './api/pedidos.php?id_pedido=' + id,
                type: 'GET',
                cache: false,
                async: false,
                dataType: 'json', // added data type
                success: function(r) {
                    console.log(r);
                    re = r.pedido
                }
            })
            return re
        }


        function VerInfo(id) {
            $.ajax({
                url: './api/pedidos.php?id_pedido=' + id,
                type: 'GET',
                cache: false,
                dataType: 'json', // added data type
                success: function(r) {
                    console.log(r);
                    var result = r.pedido
                    if (result.telefono != null) {

                        var telefono = result.telefono.split(" ")[1]
                        var completo = result.telefono.replace(' ', '');



                        $("#vista_telefono").text(telefono)

                    }
                    $("#vista_id_pedido").text(result.numero)
                    $("#vista_imagen_pedido").attr("src", './imagenes/pedidos/' +
                        result.id_pedido +
                        '/perfil.png' + '?timestamp=' + new Date().getTime());

                    $("#vista_numero").text(result.numero)
                    $("#vista_nombre").text(result.nombre)
                    $("#vista_domicilio").text(result.domicilio)
                    $("#vista_dni").text(result.dni)
                    $("#vista_bultos").text(result.bultos)
                    $("#vista_palets").text(result.palets)


                    var estado = result.estado

                    var color = (estado == "Entregado") ? "#0cca8e" : (estado ===
                        "No entregado") ? "#f1635f" : (estado ===
                        "Pendiente") ? "#ff9041" : "black"
                    var estado_p = document.getElementById("vista_estado1")
                    estado_p.innerHTML = ""

                    var iconElement = document.createElement("i");

                    // Establecer el estilo y la clase del elemento
                    iconElement.style.color = color;
                    iconElement.className = "ml-1 fas fa-circle";
                    estado_p.innerText = estado
                    // Insertar el elemento en el documento
                    estado_p.appendChild(iconElement);

                    $("#vista_fecha_entrega1").text(result
                        .fecha_almacen)
                    $("#vista_fecha_entrega").text(result
                        .fecha_entrega)

                    $("#vista_tipo_entrega").text(result
                        .tipo_entrega)

                    $('.tabla_observaciones').DataTable().settings()[0].ajax.data =
                        function(data) {
                            data.id_pedido_observacion =
                                result.id_pedido; // Establece el valor de fecha_i

                        };
                    $('.tabla_observaciones').DataTable().settings()[1].ajax.data =
                        function(data) {
                            data.id_pedido_observacion =
                                result.id_pedido; // Establece el valor de fecha_i

                        };
                    $('.tabla_observaciones').DataTable().ajax.reload();

                    $("#btn_firmar_pedido").data("id", result.id_pedido)
                    $("#btn_firmar_pedido").data("firma", result.id_firma)

                    $("#modalVisualizar").modal("show")
                }
            });

        }
    });
})(jQuery);
</script>