<div class="content-wrapper">



    <div class="row profile-page satmar-bottom">

        <div class="col-12">

            <div class="card">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/fesehxev.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">Total</p>
                        <span id="total_count"></span>
                    </div>

                </div>

            </div>

        </div>





    </div>



    <div class="row profile-page mb-4">
        <div class="col-12">
            <div class="card">
                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0 ">

                        <div class="row ">
                            <!-- Historial de Acceso -->
                            <div class="col-md-12">
                                <div class="card card-cuenta">

                                    <div class="card-body card-table-body">

                                        <div class="table-responsive">
                                            <table id="tabla_entrgados_pedidos" cellspacing="0"
                                                class="tabla_historial table display nowrap">

                                                <thead>

                                                    <tr>

                                                        <th
                                                            style="padding-left: 32px !important;padding-right: 50px !important;">
                                                            ID</th>

                                                        <th>Nº Pedido</th>

                                                        <th>Nombre</th>

                                                        <th>Domicilio</th>

                                                        <th>DNI</th>

                                                        <th>Móvil</th>

                                                        <th>Estado</th>

                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>



                                                </tbody>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /Historial de Acceso -->
                            <!-- Eliminación de cuenta -->

                            <!-- /Eliminación de cuenta -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>





</div>



<script>
(function($) {

    'use strict';

    $(function() {
        $('.tabla_historial').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en pedidos",
                infoEmpty: "Mostrando 0 a 0 de 0 en pedidos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                },

                {
                    extend: 'excelHtml5',
                    text: '<i class="fa fa-file-excel-o"></i> Excel',
                    titleAttr: 'Export to Excel',
                    title: 'Pedidos',
                    exportOptions: {
                        columns: ':not(:last-child)',
                    }
                },
                {
                    extend: 'csvHtml5',
                    text: '<i class="fa fa-file-text-o"></i> CSV',
                    titleAttr: 'CSV',
                    title: 'Pedidos',
                    exportOptions: {
                        columns: ':not(:last-child)',
                    }
                },
                {
                    extend: 'pdfHtml5',
                    text: '<i class="fa fa-file-pdf-o"></i> PDF',
                    titleAttr: 'PDF',
                    title: 'Pedidos',
                    exportOptions: {
                        columns: ':not(:last-child)',
                    },
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/pedidos.php', // Ruta que devuelve los datos de los transportistas
                method: 'GET',
                dataSrc: function(data) {
                    console.log(data);

                    var pendientes = data.filter(objeto => (objeto.estado == "Entregado"));



                    $("#total_count").text(pendientes.length)



                    return pendientes

                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_transportistas_aceptados').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_pedido",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "numero"
                },
                {
                    "data": "nombre"
                },

                {
                    "data": "domicilio"
                },

                {
                    "data": "dni"
                },
                {
                    "data": "telefono"
                },
                {
                    "data": "estado"
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonObservaciones = document.createElement('button');
                        buttonObservaciones.className =
                            'btn_edit_observaciones p-1 dropdown-item';
                        buttonObservaciones.setAttribute('type', 'button');
                        buttonObservaciones.setAttribute('data-id', data.id_pedido)

                        buttonObservaciones.innerHTML = `
                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Observaciones`;
                        var buttonFirmar = document.createElement('button');
                        buttonFirmar.className =
                            'btn_firmar p-1 dropdown-item';
                        buttonFirmar.setAttribute('type', 'button');
                        buttonFirmar.setAttribute('data-id', data.id_pedido)
                        buttonFirmar.setAttribute('data-firma', data.id_firma)
                        buttonFirmar.innerHTML = `
                    <lord-icon src="./assets/lordicons/sign.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Firmar`;

                        var buttonEnviar = document.createElement('button');
                        buttonEnviar.className = 'btn_ver_info p-1 dropdown-item';
                        buttonEnviar.setAttribute('type', 'button');
                        buttonEnviar.setAttribute('data-id', data.id_pedido)

                        buttonEnviar.innerHTML = `
                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Visualizar`;
                        var buttonVerPresupuesto = document.createElement('button');
                        buttonVerPresupuesto.className =
                            'btn_edit_pedido p-1 dropdown-item';
                        buttonVerPresupuesto.setAttribute('type', 'button');
                        buttonVerPresupuesto.setAttribute('data-id', data
                            .id_pedido)
                        buttonVerPresupuesto.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                `;

                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_pedido p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data.id_pedido)
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;





                        dropdownMenu.appendChild(buttonFirmar);
                        dropdownMenu.appendChild(buttonVerPresupuesto);
                        dropdownMenu.appendChild(buttonObservaciones);
                        dropdownMenu.appendChild(buttonEnviar);
                        dropdownMenu.appendChild(buttonEliminar);
                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]


        });

    });
})(jQuery);
</script>
<?php require_once __VIEWS__ . 'js/pedidos.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/transportistas.template.php'; ?>