<div class="content-wrapper">

    <div class="row">

        <div class="col-6"></div>

        <div class="col-6 text-center">



            <div class="form-group mb-4 d-flex align-items-center">

                <input id="fecha_inicio" class="form-control" type="date" name="fecha_inicio" value="" required>

                <p class="mb-0 mx-3">A</p>

                <input id="fecha_final" class="form-control" type="date" name="fecha_final" value="" required>



            </div>



        </div>

    </div>



    <div class="row profile-page ">

        <div class="col-md-4">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/vhqrwhnv.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">Hoy en ruta</p>
                        <span id="en_ruta_count"></span>
                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-4">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/qfcbmiik.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">Hoy no entregados</p>
                        <span id="hoy_no_entregados_count"></span>
                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-4">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/ymsapbnv.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">Hoy entregados</p>
                        <span id="hoy_entregados_count"></span>
                    </div>

                </div>

            </div>

        </div>

    </div>





    <div class="row profile-page satmar-bottom">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div>
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Pedidos</h5>
                            </div>

                        </div>

                        <div class="mb-4 d-flex" id="grafico_pedidos" style="width:100%!important; height: 300px;">
                        </div>




                        <div>

                            Pedidos entregados hoy:
                            <span id="entregados_hoy_count_2"></span>

                        </div>

                        <div>

                            Pedidos entregados en el período seleccionado:
                            <span id="entregados_count"></span>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



    <div class="row profile-page ">

        <div class="col-md-3">

            <div class="card">

                <div class="sato-border-blue">
                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/zzjjvkam.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">Total</p>
                        <span id="total_count"></span>
                    </div>





                </div>

            </div>

        </div>

        <div class="col-md-3">

            <div class="card">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/qfcbmiik.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">No entregados</p>
                        <span id="no_entregados_count"></span>
                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-3">

            <div class="card">

                <div class="sato-border-blue">


                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/bqzyzccf.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">Pendientes</p>
                        <span id="pendientes_count"></span>
                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-3">

            <div class="card">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/ymsapbnv.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>


                        <p class="mb-2">Activos</p>
                        <span id="activos_count"></span>
                    </div>

                </div>

            </div>

        </div>

    </div>



</div>
<script>
(function($) {
    'use strict';
    $(function() {
        var hoy = moment().format('YYYY-MM-DD');
        var week = moment().subtract(7, 'days').format('YYYY-MM-DD');
        $("#fecha_inicio").val(week)
        $("#fecha_final").val(hoy)
        ActualizarGraficos()
        $("#nav_ham").on("click", function() {


            setTimeout(function() {
                ActualizarGraficos()
            }, 300);

        })

        function ActualizarGraficos() {
            var fecha_inicio = moment($('#fecha_inicio').val(), 'YYYY-MM-DD');
            var fecha_final = moment($('#fecha_final').val(), 'YYYY-MM-DD');
            var fechas = [];
            while (fecha_inicio.isBefore(fecha_final) || fecha_inicio.isSame(fecha_final, 'date')) {
                fechas.push(fecha_inicio.format('YYYY-MM-DD'));
                fecha_inicio.add(1, 'days');
            }
            $("#grafico_pedidos").html("")
            window.morrisObj = NaN;

            fechas = JSON.stringify(fechas);
            $.ajax({
                type: "GET",
                url: "./api/pedidos.php",
                dataType: "json",
                cache: false,
                async: false,
                data: {
                    dias: fechas
                },
                success: function(pedidos) {
                    console.log(pedidos);
                    $("#en_ruta_count").text(pedidos.en_ruta_count)
                    $("#hoy_no_entregados_count").text(pedidos.hoy_no_entregados_count)
                    $("#hoy_entregados_count").text(pedidos.hoy_entregados_count)
                    $("#total_count").text(pedidos.total_count)
                    $("#no_entregados_count").text(pedidos.no_entregados_count)
                    $("#pendientes_count").text(pedidos.pendientes_count)
                    $("#activos_count").text(pedidos.activos_count)
                    $("#entregados_hoy_count_2").text(pedidos.hoy_entregados_count)
                    $("#entregados_count").text(pedidos.entregados_count)
                    var data = []
                    var cantidad_total = 0
                    for (let f of pedidos.dias) {

                        cantidad_total += parseInt(f.cantidad)
                        let d = {
                            dia: f.dia,
                            pedidos: f.cantidad
                        }
                        data.push(d)
                    }

                    // $("#cantidad_recursos").text(cantidad_total)
                    window.morrisObj = new Morris.Area({
                        element: 'grafico_pedidos',
                        data: data,
                        xkey: 'dia',
                        ykeys: ['pedidos'],
                        labels: ['Pedidos'],
                        xLabels: 'day',
                        xLabelAngle: 0,
                        behaveLikeLine: true,
                        resize: true,
                        pointSize: 0,
                        yLabelFormat: function(y) {
                            return y != Math.round(y) ? '' : y;
                        },

                        smooth: true,
                        gridLineColor: '#e0e0e0',
                        lineWidth: 0,
                        xLabelsInterval: 3,
                        hideHover: 'auto',
                        fillOpacity: 1,
                        pointFillColors: [
                            "<?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>"
                        ],
                        lineColors: [
                            "<?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>"
                        ],
                        pointStrokeColors: ['#fff'],
                    });
                }
            })

        }

        $('#fecha_inicio, #fecha_final').on('change', function(event) {
            const momentFecha1 = moment($('#fecha_inicio').val(), 'YYYY-MM-DD');
            const momentFecha2 = moment($('#fecha_final').val(), 'YYYY-MM-DD');
            if (momentFecha1.isBefore(momentFecha2) || momentFecha1.isSame(momentFecha2, 'date')) {

                ActualizarGraficos()
                return false;
            } else {
                event.preventDefault();
                $.toast({
                    heading: 'La fecha de incio debe ser por lo emnos un dia anterior a la fecha final',
                    text: 'Por favor selecciona una fecha válida.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }

        });


    });
})(jQuery);
</script>