<?php require_once __VIEWS__ . 'selects/almacenes.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/baldas.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/columnas.template.php'; ?>

<div class="modal fade" id="modalEditarPedido" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Editar pedido</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Imagen</label>
                                <div class="row">
                                    <div style="display: flex;justify-content: center;align-items: center;"
                                        class="col-sm-4 mb-4 mb-sm-0">
                                        <img class="w-100" style="aspect-ratio: 1/1; object-fit:cover"
                                            id="imagen_previa_editar" src="./assets/images/clientes/user-default.png"
                                            alt="">
                                    </div>
                                    <div class="col-sm-8">
                                        <div class="input-group mb-3">
                                            <input type="text" disabled id="nombre_imagen_editar" class="form-control"
                                                value="Ninguna">
                                            <input type="file" id="input_imagen_editar" class="d-none"
                                                accept="image/png">
                                            <div class="input-group-append">
                                                <button id="btn_cargar_imagen_editar" class=" btn btn-success"
                                                    type="button">+</button>
                                            </div>
                                        </div>
                                        <p class="mb-0">El ratio recomendado para la imagen es
                                            1X1</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">

                            <div class="form-group">

                                <label>Nº de pedido</label>

                                <input type="text" class="form-control" id="numero_editar" placeholder="" required>

                            </div>

                        </div>
                        <div class="col-md-6">

                            <div class="form-group">

                                <label>Nombre</label>

                                <input type="text" class="form-control" id="nombre_editar" placeholder="" required>

                            </div>

                        </div>

                        <div class="col-md-6">

                            <div class="form-group">

                                <label>Domicilio</label>


                                <input type="text" class="form-control" id="domicilio_editar" placeholder="">


                            </div>

                        </div>

                        <div class="col-md-6">

                            <div class="form-group">

                                <label>DNI</label>

                                <input type="text" class="form-control" id="dni_editar" placeholder="">


                            </div>

                        </div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Bultos</label>
                                <input id="bultos_editar" value="0" type="number" class="intl-tel-input form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Pallets</label>
                                <input id="palets_editar" value="0" type="number" class="intl-tel-input form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Teléfono</label>
                                <input id="telefono_editar" type="text" class="intl-tel-input form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Tipo de entrega</label>
                                <select id="tipo_entrega_editar" class="form-control select2" type="text" name="">
                                    <option value="Directa">Directa</option>
                                    <option value="Indirecta">Indirecta</option>

                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Estado</label>
                                <select id="estado_editar" class="form-control select2" type="text" name="">
                                    <option value="Entregado">Entregado</option>
                                    <option value="No entregado">No entregado</option>
                                    <option value="Pendiente">Pendiente</option>

                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">

                                <label for="my-input">Transportista</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_transportista file-upload-browse btn btn-danger"
                                            data-target="select_transportistas_editar" type="button">-</button>
                                    </span>
                                    <select id="select_transportistas_editar"
                                        class="select_transportistas custom-select select2 form-control">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarTransportista">+</button>
                                    </span>
                                </div>


                            </div>
                        </div>
                        <div class="col-md-6">

                            <div class="form-group">

                                <label>Fecha de entrega</label>

                                <input type="date" class="form-control" id="fecha_entrega_editar" placeholder="">

                            </div>

                        </div>

                        <div class="col-md-6">

                            <div class="form-group">

                                <label>Fecha almacén</label>

                                <input type="date" class="form-control" id="fecha_almacen_editar" placeholder="">

                            </div>

                        </div>
                        <div class="col-12">
                            <h4 class="mb-4">Localización</h4>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">

                                <label for="my-input">Almacen</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_almacen file-upload-browse btn btn-danger"
                                            data-target="select_almacenes_editar" type="button">-</button>
                                    </span>
                                    <select id="select_almacenes_editar"
                                        class="select_almacenes custom-select select2 form-control">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarAlmacen">+</button>
                                    </span>
                                </div>


                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">

                                <label for="my-input">Columna</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_columna file-upload-browse btn btn-danger"
                                            data-target="select_columnas_editar" type="button">-</button>
                                    </span>
                                    <select id="select_columnas_editar"
                                        class="select_columnas custom-select select2 form-control">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarColumna">+</button>
                                    </span>
                                </div>


                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">

                                <label for="my-input">Balda</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_balda file-upload-browse btn btn-danger"
                                            data-target="select_baldas_editar" type="button">-</button>
                                    </span>
                                    <select id="select_baldas_editar"
                                        class="select_baldas custom-select select2 form-control">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarBalda">+</button>
                                    </span>
                                </div>


                            </div>
                        </div>







                    </div>

                </div>



            </div>

            <div style="margin-top:15px;" class="modal-footer text-right">



                <button class="btn btn-success btn-fw" id="btn_edit_pedido" type="button">

                    Editar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalAsignarTransportista" role="dialog" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Asignar transportista</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">




                <div class="row">
                    <div class="col-12">
                        <div class="form-group">


                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_transportista file-upload-browse btn btn-danger"
                                        data-target="select_transportistas" type="button">-</button>
                                </span>
                                <select id="select_transportistas2"
                                    class="select_transportistas custom-select select2 form-control">

                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarTransportista">+</button>
                                </span>
                            </div>


                        </div>

                    </div>
                </div>



            </div>

            <div style="padding:26px!important" class=" modal-footer text-right">
                <button id="btn_cambiar_transportista" class="btn btn-success btn-fw" type="button"
                    name="">Guardar</button>


            </div>

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalVisualizar" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Pedido</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="row">
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-12">
                                <p>ID: <span id="vista_id_pedido"></span></p>

                                <hr class="mb-0 mt-2">
                            </div>

                            <div class="col-12">
                                <img id="vista_imagen_pedido"
                                    style="border-radius: .3rem;aspect-ratio:2/1;object-fit:cover;" class="img-fluid"
                                    src="./assets/images/clientes/user-default.png" alt="">
                            </div>

                            <div class="col-12">
                                <hr class="mt-0 mb-2">
                            </div>


                            <div class="col-12">
                                <div id="accordion">
                                    <h5 class="" data-toggle="collapse" data-target="#info" aria-expanded="true"
                                        aria-controls="collapseOne"">Información General<i class=" ml-1 fas
                                        fa-arrow-down">
                                        </i></h5>
                                    <div id="info" class="collapse show" aria-labelledby="headingOne"
                                        data-parent="#accordion">

                                        <p class="mb-1"><small>Fecha de entrega estimada:</small></p>
                                        <p class="mb-2"><strong id="vista_fecha_entrega1"></strong></p>
                                        <p class="mb-1" class=""><small>Estado</small></p>
                                        <p id="vista_estado1">Aceptado<i style="color:#0cca8e;"
                                                class="ml-1 fas fa-circle">
                                            </i></p>
                                    </div>

                                </div>


                            </div>

                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-12">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item"> <a class="active show flex-column align-items-center nav-link"
                                            data-toggle="tab" href="#pedido" role="tab"><span class="hidden-sm-up">
                                                <lord-icon class="sidebar-menu-icon"
                                                    src="https://cdn.lordicon.com/nocovwne.json" trigger="hover"
                                                    colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                                    style="width:40px;height:40px">
                                                </lord-icon>
                                            </span> <span class="hidden-xs-down">Pedido</span></a> </li>
                                    <li class="nav-item"> <a class="flex-column align-items-center nav-link"
                                            data-toggle="tab" href="#cliente" role="tab"><span class="hidden-sm-up">
                                                <lord-icon class="sidebar-menu-icon"
                                                    src="https://cdn.lordicon.com/eszyyflr.json" trigger="hover"
                                                    colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                                    style="width:40px;height:40px">
                                                </lord-icon>
                                            </span> <span class="hidden-xs-down">Cliente</span></a> </li>
                                    <li class="nav-item"> <a class="flex-column align-items-center nav-link"
                                            data-toggle="tab" href="#entrega" role="tab"><span class="hidden-sm-up">
                                                <lord-icon class="sidebar-menu-icon"
                                                    src="https://cdn.lordicon.com/fesehxev.json" trigger="hover"
                                                    colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                                    style="width:40px;height:40px">
                                                </lord-icon>
                                            </span> <span class="hidden-xs-down">Entrega</span></a> </li>
                                    <li class="nav-item"> <a class="flex-column align-items-center nav-link"
                                            data-toggle="tab" id="tab_observaciones" href="#observaciones"
                                            role="tab"><span class="hidden-sm-up">
                                                <lord-icon class="sidebar-menu-icon"
                                                    src="https://cdn.lordicon.com/oilwhjud.json" trigger="hover"
                                                    colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                                    style="width:40px;height:40px">
                                                </lord-icon>
                                            </span> <span class="hidden-xs-down">Observaciones</span></a> </li>
                                </ul>
                                <div class="tab-content tabcontent-border p-3">
                                    <div class="tab-pane active show" id="pedido" role="tabpanel">
                                        <div class="row">
                                            <div class="col-12">
                                                <h4>Datos del pedido</h4>
                                                <p class="mb-1">
                                                    <strong>Nº Pedido </strong><span id="vista_numero"></span>
                                                </p>
                                                <p class="mb-1">
                                                    <strong>Palets: </strong><span id="vista_palets"></span>
                                                </p>
                                                <p class="mb-1">
                                                    <strong>Bultos: </strong><span id="vista_bultos"></span>
                                                </p>



                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="cliente" role="tabpanel">
                                        <div class="row">
                                            <div class="col-12">

                                                <h4>Datos del cliente</h4>
                                                <p class="mb-1">
                                                    <strong>Nombre: </strong><span id="vista_nombre"></span>
                                                </p>
                                                <p class="mb-1">
                                                    <strong>DNI: </strong><span id="vista_dni"></span>
                                                </p>
                                                <p class="mb-1">
                                                    <strong>Teléfono: </strong><span id="vista_telefono"></span>
                                                </p>
                                                <p class="mb-1">
                                                    <strong>Domicilio: </strong><span id="vista_domicilio"></span>
                                                </p>


                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="entrega" role="tabpanel">
                                        <div class="row">
                                            <div class="col-12">

                                                <h4>Datos de la entrega</h4>
                                                <p class="mb-1">
                                                    <strong>Tipo de entrega: </strong><span
                                                        id="vista_tipo_entrega"></span>
                                                </p>
                                                <p class="mb-1">
                                                    <strong>Fecha de entrega: </strong><span
                                                        id="vista_fecha_entrega"></span>
                                                </p>


                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="observaciones" role="tabpanel">
                                        <div class="row">
                                            <div class="col-12">
                                                <table id="tabla_observaciones_2" cellspacing="0"
                                                    class="tabla_observaciones table display nowrap">

                                                    <thead>

                                                        <tr>

                                                            <th
                                                                style="padding-left: 32px !important;padding-right: 50px !important;">
                                                                ID</th>

                                                            <th>Imágen</th>

                                                            <th>Observación</th>



                                                            <th style="text-align:center;">Acciones</th>

                                                        </tr>

                                                    </thead>

                                                    <tbody>



                                                    </tbody>

                                                </table>



                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>


                </div>
            </div>


            <div class="modal-footer text-right">

                <button class="btn btn-success btn_firmar btn-fw" id="btn_firmar_pedido" type="button">Firmar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cerrar</button>

            </div>

        </div>

    </div>

</div>
<div class="modal fade" id="modalFirmar" role="dialog" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar firma</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">




                <div class="row">
                    <div class="col-12 mb-4 ">
                        <div id="canvas_container">
                            <canvas style="border-radius: 0.3rem;background: white;" id="firma"></canvas>
                        </div>


                    </div>
                    <div class=" col-12">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>
                            <input id="nombre_firma" class="form-control" type="text" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Documento de identidad</label>
                            <input id="dni_firma" class="form-control" type="text" name="">
                        </div>
                    </div>
                </div>



            </div>

            <div style="padding:26px!important" class=" modal-footer text-right">
                <button id="btn_firmar" class="btn btn-success btn-fw" type="button" name="">Firmar</button>
                <button id="limpiar" class="btn btn-danger btn-fw" type="button" name="">Borrar</button>

            </div>

        </div>

    </div>

</div>




<div class="modal fade modal-cambiar" id="modalEliminarPedido" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <p class="">¿Estás seguro de que deseas eliminar el pedido definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

            </div>



            <div class="modal-footer text-right">

                <button id="btn_eliminar_pedido" class="btn btn-danger btn-fw" type="button" name="">Confirmar y
                    eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar </button>

            </div>

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEditarObservaciones" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Observaciones</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="row">
                    <div class="col-12 mb-4">
                        <table id="tabla_observaciones" cellspacing="0"
                            class="tabla_observaciones table display nowrap">

                            <thead>

                                <tr>

                                    <th style="padding-left: 32px !important;padding-right: 50px !important;">
                                        ID</th>

                                    <th>Imágen</th>

                                    <th>Observación</th>



                                    <th style="text-align:center;">Acciones</th>

                                </tr>

                            </thead>

                            <tbody>



                            </tbody>

                        </table>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-textarea">Observación</label>
                            <textarea id="observacion" class="form-control" name="" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label>Foto</label>
                            <div id="imagen" class="row">
                                <div style="display: flex;justify-content: center;align-items: center;"
                                    class="col-sm-4 mb-4 mb-sm-0">
                                    <img class="w-100" style="aspect-ratio: 1/1; object-fit:cover" id="imagen_previa"
                                        src="./assets/images/clientes/user-default.png" alt="">
                                </div>
                                <div class="col-sm-8">
                                    <div class="input-group mb-3">
                                        <input type="text" disabled id="nombre_imagen" class="form-control"
                                            value="Ninguna">
                                        <input type="file" id="input_imagen" class="d-none" accept="image/png">
                                        <div class="input-group-append">
                                            <button id="btn_cargar_imagen" class=" btn btn-success"
                                                type="button">+</button>
                                        </div>
                                    </div>
                                    <p class="mb-0">El ratio recomendado para la imagen es 1X1</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>



            <div class="modal-footer text-right">

                <button id="btn_edit_observaciones" class="btn btn-success btn-fw" type="button"
                    name="">Agregar</button>



            </div>

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarObservacion" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <p class="">¿Estás seguro de que deseas eliminar la observacion definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

            </div>



            <div class="modal-footer text-right">

                <button id="btn_eliminar_observacion" class="btn btn-danger btn-fw" type="button" name="">Confirmar
                    y
                    eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar </button>

            </div>

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEditarEstado" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar el estado del alumno</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->

                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Estado</label>
                            <select id="selectEstados" class="form-control select2">
                                <option value="Entregado">Entregado</option>
                                <option value="No entregado">No entregado</option>
                                <option value="Pendiente">Pendiente</option>

                            </select>
                        </div>
                    </div>
                </div>




            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">



                <button id="btn_editar_estado" class="btn btn-success btn-fw" type="button" name="">
                    Editar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalVerArchivo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div id="contenedor_archivo" class="modal-body pb-4">
                <!-- btn -->






            </div>

            <!-- /btn -->


            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalVerCodigo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div id="" class="modal-body pb-4 text-center">
                <!-- btn -->
                <h3>Código del pedido:</h3>
                <canvas class="d-none" id="contenedor_codigo"></canvas>
                <div id="contenedor_img"></div>




            </div>
            <div style="margin-top:15px;" class="modal-footer text-right">



                <button id="btnImprimirCanvas" class="btn btn-primary mt-3">Imprimir código</button>

            </div>
            <!-- /btn -->


            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalConfigurarAlertas" role="dialog" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Enviar email de notificación</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="email" data-nombre="email_notificacion_alertas"
                                    class="valor_personalizacion form-control" id="email_notificacion_alertas"
                                    placeholder=""
                                    value="<?php echo htmlentities($personalizacion['email_notificacion_alertas'], ENT_QUOTES); ?>">

                            </div>

                        </div>

                        <div class=" col-12">

                            <div class="form-group row">

                                <label class="col-12 col-sm-3 col-form-label">Notificar a los</label>

                                <div class="col-12 col-sm-4">

                                    <input type="number" data-nombre="dias_notificacion_alertas"
                                        class="valor_personalizacion form-control" id="dias_notificacion_alertas"
                                        value="<?php echo htmlentities($personalizacion['dias_notificacion_alertas'], ENT_QUOTES); ?>"
                                        placeholder="" required>

                                </div>

                                <div class="col-4 col-form-label">días</div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>



            <div style="margin-top:15px;" class="modal-footer text-right">



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>

            </div>



        </div>

    </div>

</div>
<style>
    #firma {
        background-color: white;
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/intlTelInput.min.js"></script>

<script>
    (function ($) {
        'use strict';
        $(function () {

            var input = document.querySelector("#telefono");

            if (input) {
                window.intlTelInput(input, {
                    utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/utils.js",
                    initialCountry: "es"
                });
                var iti = window.intlTelInputGlobals.getInstance(input);
            }

            var input2 = document.querySelector("#telefono_editar");

            console.log(input2);

            window.intlTelInput(input2, {
                utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/utils.js",
                initialCountry: "es"
            });

            var iti2 = window.intlTelInputGlobals.getInstance(input2);
            $("#input_imagen").change(function () {

                const selectedFile = this.files[0]


                if (selectedFile) {
                    const reader = new FileReader();

                    reader.onload = function (e) {

                        $("#imagen_previa").attr("src", e.target.result);
                    };

                    reader.readAsDataURL(selectedFile);
                    $("#nombre_imagen").val(selectedFile.name)

                }



            })
            $("#input_imagen_editar").change(function () {

                const selectedFile = this.files[0]


                if (selectedFile) {
                    const reader = new FileReader();

                    reader.onload = function (e) {

                        $("#imagen_previa_editar").attr("src", e.target.result);
                    };

                    reader.readAsDataURL(selectedFile);
                    $("#nombre_imagen_editar").val(selectedFile.name)
                    $("#btn_edit_pedido").data("misma", "No")
                }



            })
            $("#btn_cargar_imagen_editar").click(function () {

                console.log("SFDQW");
                $("#input_imagen_editar").click()
            })

            function inicializarFirma(canvasId) {
                // Obtener el elemento canvas existente si hay uno
                var canvas = document.getElementById(canvasId);

                // Limpiar el SignaturePad existente si lo hay
                if (canvas) {
                    var signaturePad = new SignaturePad(canvas);
                    signaturePad.clear();
                    signaturePad.off();
                }
                var contenedorPadre = document.getElementById(canvasId).parentElement;

                // Crear un nuevo SignaturePad
                var nuevoCanvas = document.createElement('canvas');
                nuevoCanvas.id = canvasId;
                nuevoCanvas.width = contenedorPadre.clientWidth;
                console.log(contenedorPadre.clientWidth);
                // Reemplazar el elemento canvas existente con el nuevo
                if (canvas && canvas.parentNode) {
                    canvas.parentNode.replaceChild(nuevoCanvas, canvas);
                }

                var signaturePad = new SignaturePad(nuevoCanvas);
                var isDrawing = false;

                function empezarDibujo(e) {
                    console.log("go");
                    isDrawing = true;
                    signaturePad.on();
                }

                function detenerDibujo(e) {
                    isDrawing = false;
                    signaturePad.off();
                }

                function dibujarFirma(e) {
                    if (isDrawing) {
                        var point = {
                            x: e.clientX,
                            y: e.clientY
                        };
                        signaturePad._strokeUpdate(e);
                    }
                }

                nuevoCanvas.addEventListener('mousedown', empezarDibujo);
                nuevoCanvas.addEventListener('mouseup', detenerDibujo);
                nuevoCanvas.addEventListener('mousemove', dibujarFirma);

                // Devolver el objeto signaturePad para que puedas acceder a él fuera de la función si es necesario
                return {
                    signaturePad: signaturePad,
                    canvas: nuevoCanvas
                };
            }

            // Uso de la función para inicializar la firma en el canvas con ID 'firma'
            var signaturePad2
            $('#modalFirmar').on('shown.bs.modal', function () {
                signaturePad2 = inicializarFirma('firma')
                $("#btn_firmar").prop("disabled", false);
                $("#limpiar").prop("disabled", false);
                $("#dni_firma").val("")
                $("#nombre_firma").val("")

                //var signaturePad = inicializarFirma('firma')
                var canvas = signaturePad2["canvas"]

                var rutaArchivo = "/firmas/" + $("#btn_firmar").data("id") + ".png";
                var ctx = canvas.getContext("2d");
                var id_firma = $("#btn_firmar").data("firma")
                var id_pedido = $("#btn_firmar").data("id")

                console.log(id_firma);
                console.log(id_pedido);
                console.log(canvas);
                $.ajax({
                    url: "./api/pedidos.php?id_pedido=" + id_pedido,
                    type: 'GET',
                    dataType: 'json', // added data type
                    cache: false,
                    async: false,
                    dataType: "json",
                    success: function (data) {
                        var id_transportista = data.transportista.id_transportista
                        var dni = (data.firma.dni != null) ? data.firma
                            .dni : data.transportista.dni
                        var nombre = (data.firma.nombre != null) ? data
                            .firma.nombre : data.transportista.nombre
                        if (id_firma != null) {
                            $("#btn_firmar").prop("disabled", true);
                            var img = new Image();



                            // Cuando la imagen se cargue, dibujarla en el lienzo
                            img.onload = function () {
                                ctx.drawImage(img, 0, 0, canvas.width, canvas
                                    .height);
                            };

                            // Establecer la fuente de la imagen
                            img.src = rutaArchivo + "?timestamp=" + new Date().getTime();
                            $("#dni_firma").val(dni)
                            $("#nombre_firma").val(nombre)
                            console.log(img);
                            $("#limpiar").removeAttr("disabled");
                        } else {
                            $("#dni_firma").val(dni)
                            $("#nombre_firma").val(nombre)
                            $("#limpiar").prop("disabled", true);
                            $("#btn_firmar").removeAttr("disabled");
                        }
                        // Crear una nueva imagen
                        $("#btn_firmar").data("id", id_pedido)
                        $("#btn_firmar").data("firma", id_firma)
                        $("#btn_firmar").data("transportista", id_transportista)
                    }
                });




            });


            var clearButton = document.getElementById('limpiar');
            clearButton.addEventListener('click', function () {


                $("#dni_firma").val("")
                $("#nombre_firma").val("")
                var id_pedido = $("#btn_firmar").data("id")
                var id_firma = $("#btn_firmar").data("firma")
                var url = "../firmas/" + id_pedido + ".png";

                console.log(url);

                $.ajax({
                    type: "DELETE",
                    url: "./api/pedidos.php?id_pedido=" + id_pedido + "&id_firma=" +
                        id_firma,
                    cache: false,
                    async: false,
                    success: function (response) {
                        console.log(response);
                        $('.tabla_historial').DataTable().ajax.reload(null, false);
                        $.toast({
                            heading: 'Firma eliminada.',
                            text: 'Se eliminado la firma correctamente.',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 4
                        })
                        $("#modalFirmar").modal("hide")


                        $('.tabla_pedidos_transportista').DataTable().ajax.reload();
                    }

                })

            });
            var firmarButton = document.getElementById('btn_firmar');
            firmarButton.addEventListener('click', function () {
                // Obtén la firma como una imagen base64

                var signatureData = signaturePad2["signaturePad"].toDataURL();
                console.log(signatureData);
                var nombre_firma = $("#nombre_firma").val()
                var dni_firma = $("#dni_firma").val()
                if (nombre_firma == "" || dni_firma == "") {
                    $.toast({
                        heading: 'Completa todos los campos.',
                        text: 'Por favor ingresa un nombre un un DNI.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    return false
                }

                var id_pedido = $("#btn_firmar").data("id")
                var id_transportista = $("#btn_firmar").data("transportista")
                var fd = new FormData();
                fd.append('firma', signatureData);
                fd.append('id_pedido_firma', id_pedido);
                fd.append('nombre_firma', nombre_firma);
                fd.append('dni_firma', dni_firma);
                $.ajax({
                    url: "./api/pedidos.php",
                    type: 'POST',
                    processData: false, // tell jQuery not to process the data
                    contentType: false, // te/ added data type
                    cache: false,
                    async: false,
                    data: fd,
                    success: function (res) {

                        res = JSON.parse(res);
                        $('.tabla_historial').DataTable().ajax.reload(null, false);

                        $.toast({
                            heading: 'Firma agregada',
                            text: 'Se ha agregado la firma correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });

                        $('.tabla_pedidos_transportista').DataTable().settings()[0].ajax
                            .data =
                            function (data) {
                                data.id_transportista_pedido =
                                    id_transportista; // Establece el valor de fecha_i

                            };

                        $('.tabla_pedidos_transportista').DataTable().ajax.reload();
                        $("#modalFirmar").modal("hide")



                    }
                });
            });

            $("#btn_cargar_imagen").click(function () {

                console.log("SFDQW");
                $("#input_imagen").click()
            })
            $("#btn_edit_observaciones").click(function (e) {
                var imagen = ($('#input_imagen')[0].files[0]) ? $('#input_imagen')[0].files[0] :
                    null;
                var observacion = $('#observacion').val();
                var id_pedido = $(this).data("id");

                var fd = new FormData();
                fd.append('imagen', imagen);
                fd.append('observacion', observacion);
                fd.append('id_pedido', id_pedido);
                $.ajax({
                    url: "./api/pedidos.php",
                    type: 'POST',
                    processData: false, // tell jQuery not to process the data
                    contentType: false, // te/ added data type
                    cache: false,
                    async: false,
                    data: fd,
                    success: function (res) {
                        console.log(res);

                        $('.tabla_observaciones').DataTable().settings()[0].ajax.data =
                            function (data) {
                                data.id_pedido_observacion =
                                    id_pedido; // Establece el valor de fecha_i

                            };
                        $('.tabla_observaciones').DataTable().settings()[1].ajax.data =
                            function (data) {
                                data.id_pedido_observacion =
                                    id_pedido; // Establece el valor de fecha_i

                            };
                        $('.tabla_observaciones').DataTable().ajax.reload();
                        $.toast({
                            heading: 'Observación agregada',
                            text: 'Se ha agregado la observación correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });




                    }
                });

            });

            $("#btn_add_pedido").click(function (event) {

                var numero = $('#numero').val();
                var imagen = ($('#input_imagen')[0].files[0]) ? $('#input_imagen')[0].files[0] : null;
                var nombre = $('#nombre').val()
                var domicilio = $('#domicilio').val()
                var estado = $('#estado').val()
                var dni = $('#dni').val()
                var bultos = $('#bultos').val()
                var palets = $('#palets').val()
                var telefono = ($('#telefono').val() != "") ? "+" + iti
                    .getSelectedCountryData()
                    .dialCode + " " + $("#telefono").val() : ""
                var tipo_entrega = $('#tipo_entrega').val()
                var id_transportista = $('#select_transportistas').val()
                var id_almacen = $('#select_almacenes').val()
                var id_balda = $('#select_baldas').val()
                var id_columna = $('#select_columnas').val()
                var fecha_entrega = (moment($("#fecha_entrega")
                    .val()).format('YYYY-MM-DD') != "Invalid date") ? moment($(
                        "#fecha_entrega")
                        .val()).format('YYYY-MM-DD') : ""


                $("#btn_add_pedido").attr("disabled", true);
                $("#btn_add_pedido").addClass('btn-loading');


                var fecha_almacen = (moment($("#fecha_almacen")
                    .val()).format('YYYY-MM-DD') != "Invalid date") ? moment($(
                        "#fecha_almacen")
                        .val()).format('YYYY-MM-DD') : ""



                var fd = new FormData();
                fd.append('imagen', imagen);
                fd.append('numero', numero);
                fd.append('estado', estado);
                fd.append('nombre', nombre);
                fd.append('domicilio', domicilio);
                fd.append('dni', dni);
                fd.append('bultos', bultos);
                fd.append('palets', palets);
                fd.append('telefono', telefono);
                fd.append('tipo_entrega', tipo_entrega);
                fd.append('id_transportista', id_transportista);
                fd.append('fecha_entrega', fecha_entrega);
                fd.append('id_almacen', id_almacen);
                fd.append('id_balda', id_balda);
                fd.append('id_columna', id_columna);
                fd.append('fecha_almacen', fecha_almacen);
                $.ajax({
                    type: 'POST',
                    url: './api/pedidos.php',
                    cache: false,
                    data: fd,
                    processData: false, // tell jQuery not to process the data
                    contentType: false, // tell jQuery not to set contentType
                    success: function (r) {

                        //console.log(r);


                        $.toast({
                            heading: 'Pedido agregado',
                            text: 'Se ha agregado el pedido correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });

                        $("#btn_add_pedido").attr("disabled", false);
                        $("#btn_add_pedido").removeClass('btn-loading');

                        window.location.href = "./logistica_historial"

                    }

                });

                return false;
            });

            function VerInfo(id) {
                $.ajax({
                    url: './api/pedidos.php?id_pedido=' + id,
                    type: 'GET',
                    cache: false,
                    dataType: 'json', // added data type
                    success: function (r) {
                        console.log(r);
                        var result = r.pedido
                        if (result.telefono != null) {

                            var telefono = result.telefono.split(" ")[1]
                            var completo = result.telefono.replace(' ', '');



                            $("#vista_telefono").text(telefono)

                        }

                        $("#vista_id_pedido").text(result.numero)
                        $("#vista_imagen_pedido").attr("src", './imagenes/pedidos/' +
                            result.id_pedido +
                            '/perfil.png' + '?timestamp=' + new Date().getTime());
                        $("#vista_numero").text(result.numero)
                        $("#vista_nombre").text(result.nombre)
                        $("#vista_domicilio").text(result.domicilio)
                        $("#vista_dni").text(result.dni)
                        $("#vista_bultos").text(result.bultos)
                        $("#vista_palets").text(result.palets)

                        var estado = result.estado

                        var color = (estado == "Entregado") ? "#0cca8e" : (estado ===
                            "No entregado") ? "#f1635f" : (estado ===
                                "Pendiente") ? "#ff9041" : "black"
                        var estado_p = document.getElementById("vista_estado1")
                        estado_p.innerHTML = ""

                        var iconElement = document.createElement("i");

                        // Establecer el estilo y la clase del elemento
                        iconElement.style.color = color;
                        iconElement.className = "ml-1 fas fa-circle";
                        estado_p.innerText = estado
                        // Insertar el elemento en el documento
                        estado_p.appendChild(iconElement);

                        $("#vista_fecha_entrega1").text(result
                            .fecha_almacen)
                        $("#vista_tipo_entrega").text(result
                            .tipo_entrega)

                        $('.tabla_observaciones').DataTable().settings()[0].ajax.data =
                            function (data) {
                                data.id_pedido_observacion =
                                    result.id_pedido; // Establece el valor de fecha_i

                            };
                        $('.tabla_observaciones').DataTable().settings()[1].ajax.data =
                            function (data) {
                                data.id_pedido_observacion =
                                    result.id_pedido; // Establece el valor de fecha_i

                            };
                        $('.tabla_observaciones').DataTable().ajax.reload();
                        $("#btn_firmar_pedido").data("id", id)
                        $("#btn_firmar_pedido").data("firma", result.id_firma)
                        $("#modalVisualizar").modal("show")
                    }
                });

            }

            $(document).on("click", ".btn_ver_info", function (event) {
                var id = $(this).data("id")
                VerInfo(id)


            })

            $(document).on("click", ".btn_ver_codigo", function (event) {
                var id_pedido = $(this).data("id")
                var codigoBarrasCadena = JsBarcode("#contenedor_codigo", id_pedido, {
                    format: "CODE128",
                    displayValue: true,
                    width: 3
                });
                var canvas = document.getElementById('contenedor_codigo');
                var dataUrl = canvas.toDataURL(); // Obtener la imagen del canvas como una URL de datos
                const img = new Image();
                img.src = dataUrl;
                img.id = "codigo_imagen";
                var cont = document.getElementById('contenedor_img');
                cont.appendChild(img);
                $("#modalVerCodigo").modal("show")
            })
            document.getElementById('btnImprimirCanvas').addEventListener('click', function () {
                var imagen = document.getElementById('codigo_imagen');
                if (imagen) {

                }
            });
            $(document).on("click", ".btn_edit_pedido", function (event) {

                $("#btn_edit_pedido").data("id", $(this).data("id"));

                $.ajax({
                    url: './api/pedidos.php?id_pedido=' + $(this).data("id"),
                    type: 'GET',
                    cache: false,
                    dataType: 'json', // added data type
                    success: function (r) {
                        var result = r.pedido
                        if (result.telefono != null) {

                            var telefono = result.telefono.split(" ")[1]
                            var completo = result.telefono.replace(' ', '');

                            iti2.setNumber(completo)

                            $("#telefono_editar").val(telefono)

                        }
                        $("#imagen_previa_editar").attr("src", './imagenes/pedidos/' +
                            result.id_pedido +
                            '/perfil.png' + '?timestamp=' + new Date().getTime());
                        $("#btn_edit_pedido").data("misma", "Si")
                        $("#numero_editar").val(result.numero)
                        $("#nombre_editar").val(result.nombre)
                        $("#domicilio_editar").val(result.domicilio)
                        $("#dni_editar").val(result.dni)
                        $("#bultos_editar").val(result.bultos)
                        $("#palets_editar").val(result.palets)
                        $("#select_transportistas_editar").val((result.id_transportista !=
                            null) ? result.id_transportista : "No").trigger("change")
                        $("#select_baldas_editar").val((result.id_balda != null) ? result
                            .id_balda : "No").trigger("change")
                        $("#select_almacenes_editar").val((result.id_almacen != null) ?
                            result.id_almacen : "No").trigger("change")
                        $("#select_columnas_editar").val((result.id_columna != null) ?
                            result.id_columna : "No").trigger("change")


                        $("#fecha_almacen_editar").val(result
                            .fecha_almacen)


                        $("#fecha_entrega_editar").val(result
                            .fecha_entrega)

                        $("#tipo_entrega_editar").val(result
                            .tipo_entrega).trigger("change")



                        $('#modalEditarPedido').modal('show')
                    }
                });



            })
            $(document).on("click", ".btn_cambiar_transportista", function (event) {

                $("#btn_cambiar_transportista").data("id", $(this).data("id"));

                $.ajax({
                    url: './api/pedidos.php?id_pedido=' + $(this).data("id"),
                    type: 'GET',
                    cache: false,
                    dataType: 'json', // added data type
                    success: function (r) {
                        var result = r.pedido

                        var id_transportista = (result.id_transportista != null) ?
                            result
                                .id_transportista : "No"
                        console.log(id_transportista);
                        $("#select_transportistas2").val(id_transportista).trigger(
                            "change")



                        $('#modalAsignarTransportista').modal('show')
                    }
                });



            })
            $(document).on("click", ".btn_editar_estado", function () {


                $('#btn_editar_estado').data("id", $(this).data("id"))
                $("#selectEstados").val($(this).data("estado")).trigger(
                    "change")

                $("#modalEditarEstado").modal("show");
            });
            $("#btn_editar_estado").click(function () {
                var id_alumno_atributo = $(this).data("id")

                var atributo = "estado"
                var valor = $("#selectEstados").val()
                CambiarAtributo(id_alumno_atributo, valor, atributo)
                $('.tabla_historial').DataTable().ajax.reload(null, false);
                $("#modalEditarEstado").modal("hide");
            })
            $("#btn_cambiar_transportista").click(function () {
                var id_alumno_atributo = $(this).data("id")

                var atributo = "id_transportista"
                var valor = $("#select_transportistas2").val()
                CambiarAtributo(id_alumno_atributo, valor, atributo)
                $('.tabla_historial').DataTable().ajax.reload(null, false);
                $("#modalAsignarTransportista").modal("hide");
            })

            function CambiarAtributo(id_alumno_atributo, valor, atributo) {
                var r = false
                $.ajax({
                    type: 'POST',
                    url: './api/pedidos.php',
                    cache: false,
                    async: false,
                    dataType: 'json',
                    data: {
                        id_pedido_atributo: id_alumno_atributo,
                        valor: valor,
                        atributo: atributo
                    },
                    success: function (result2) {

                        r = result2
                        $.toast({
                            heading: 'Atributo cambiado.',
                            text: 'Se ha cambiado el atributo ' + atributo +
                                ' correctamente.',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 4
                        })
                        return r
                    }
                });
                return r

            }
            $(document).on("click", ".btn_edit_observaciones", function (event) {
                var id = $(this).data("id")
                $("#btn_edit_observaciones").data("id", $(this).data("id"));
                $('.tabla_observaciones').DataTable().settings()[0].ajax.data =
                    function (data) {
                        data.id_pedido_observacion =
                            id; // Establece el valor de fecha_i

                    };
                $('.tabla_observaciones').DataTable().settings()[1].ajax.data = function (data) {
                    data.id_pedido_observacion = id; // Establece el valor de fecha_i

                };
                $('.tabla_observaciones').DataTable().ajax.reload();
                $('#modalEditarObservaciones').modal('show')
            })
            $("#btn_edit_pedido").click(function (event) {


                var misma = $("#btn_edit_pedido").data("misma")
                var imagen = ($('#input_imagen_editar')[0].files[0]) ? $('#input_imagen_editar')[0]
                    .files[0] :
                    null;
                var numero = $('#numero_editar').val();
                var id_pedido = $(this).data("id")
                var nombre = $('#nombre_editar').val()
                var domicilio = $('#domicilio_editar').val()
                var estado = $('#estado_editar').val()
                var dni = $('#dni_editar').val()
                var bultos = $('#bultos_editar').val()
                var palets = $('#palets_editar').val()
                var telefono = ($('#telefono_editar').val() != "") ? "+" + iti2
                    .getSelectedCountryData()
                    .dialCode + " " + $("#telefono_editar").val() : ""
                var tipo_entrega = $('#tipo_entrega_editar').val()
                var id_transportista = $('#select_transportistas_editar').val()
                var id_almacen = $('#select_almacenes_editar').val()
                var id_balda = $('#select_baldas_editar').val()
                var id_columna = $('#select_columnas_editar').val()
                var fecha_entrega = (moment($("#fecha_entrega_editar")
                    .val()).format('YYYY-MM-DD') != "Invalid date") ? moment($(
                        "#fecha_entrega_editar")
                        .val()).format('YYYY-MM-DD') : ""
                var fecha_almacen = (moment($("#fecha_almacen_editar")
                    .val()).format('YYYY-MM-DD') != "Invalid date") ? moment($(
                        "#fecha_almacen_editar")
                        .val()).format('YYYY-MM-DD') : ""


                $("#btn_edit_pedido").attr("disabled", true);
                $("#btn_edit_pedido").addClass('btn-loading');
                console.log(telefono);
                var fd = new FormData();
                fd.append('id_pedido', id_pedido);
                fd.append('imagen', imagen);
                fd.append('misma', misma);
                fd.append('numero', numero);
                fd.append('estado', estado);
                fd.append('nombre', nombre);
                fd.append('domicilio', domicilio);
                fd.append('dni', dni);
                fd.append('bultos', bultos);
                fd.append('palets', palets);
                fd.append('telefono', telefono);
                fd.append('tipo_entrega', tipo_entrega);
                fd.append('id_transportista', id_transportista);
                fd.append('fecha_entrega', fecha_entrega);
                fd.append('fecha_almacen', fecha_almacen);
                fd.append('id_almacen', id_almacen);
                fd.append('id_balda', id_balda);
                fd.append('id_columna', id_columna);
                $.ajax({
                    type: 'POST',
                    url: './api/pedidos.php',
                    cache: false,
                    data: fd,
                    processData: false, // tell jQuery not to process the data
                    contentType: false, // tell jQuery not to set contentType
                    success: function (r) {

                        console.log(r);


                        $('.tabla_historial').DataTable().ajax.reload(null, false);
                        $('#modalEditarPedido').modal('hide');
                        $.toast({
                            heading: 'Pedido editado',
                            text: 'Se ha editado el pedido correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });

                        $("#btn_edit_pedido").attr("disabled", false);
                        $("#btn_edit_pedido").removeClass('btn-loading');

                        $("#modalEditarPedido input").each(function () {
                            $(this).val("")
                        })

                    }

                });

                return false;
            });

            $(document).on("click", ".btn_eliminar_pedido", function (e) {



                $("#btn_eliminar_pedido").data("id", $(this).data("id"))

                $("#modalEliminarPedido").modal('show');




            })
            $(document).on("click", ".btn_eliminar_observacion", function (e) {



                $("#btn_eliminar_observacion").data("id", $(this).data("id"))

                $("#modalEliminarObservacion").modal('show');




            })


            $(document).on("click", ".btn_firmar", function (e) {
                $("#btn_firmar").data("id", $(this).data("id"))
                $("#btn_firmar").data("firma", $(this).data("firma"))
                if (typeof signaturePad2 !== "undefined") {
                    signaturePad2["signaturePad"].clear()
                }

                $("#modalFirmar").modal('show');



            })

            $('#btn_eliminar_observacion').click(function (event) {

                var id_observacion_eliminar = $("#btn_eliminar_observacion").data("id")

                var id = $("#btn_edit_observaciones").data("id")
                $.ajax({
                    type: 'DELETE',
                    url: './api/pedidos.php?id_observacion_eliminar=' +
                        id_observacion_eliminar,
                    cache: false,
                    success: function (result) {
                        $('.tabla_observaciones').DataTable().settings()[0].ajax.data =
                            function (data) {
                                data.id_pedido_observacion =
                                    id; // Establece el valor de fecha_i

                            };
                        $('.tabla_observaciones').DataTable().settings()[1].ajax.data =
                            function (data) {
                                data.id_pedido_observacion =
                                    id; // Establece el valor de fecha_i

                            };
                        $('.tabla_observaciones').DataTable().ajax.reload();
                        $('#tabla_observaciones_3').DataTable().ajax.reload();
                        $.toast({
                            heading: 'Observación eliminada',
                            text: 'Se ha eliminado la observación correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })


                        $('#modalEliminarObservacion').modal('hide');




                    }
                });

                return false;
            });
            $('#btn_eliminar_pedido').click(function (event) {

                var id_pedido_eliminar = $("#btn_eliminar_pedido").data("id")


                $.ajax({
                    type: 'DELETE',
                    url: './api/pedidos.php?id=' + id_pedido_eliminar,
                    cache: false,
                    success: function (result) {

                        $('#modalEliminarPedido').modal('hide');
                        $.toast({
                            heading: 'Pedido eliminado',
                            text: 'Se ha eliminado el pedido correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })


                        $('#modalEliminarPedido').modal('hide');

                        $('.tabla_historial').DataTable().ajax.reload(null, false);


                        $('.tabla_pedidos_transportista').DataTable().ajax.reload();

                    }
                });

                return false;
            });







        });
    })(jQuery);
</script>
<script>
    (function ($) {
        'use strict';
        $(function () {

            $('.tabla_observaciones').DataTable({
                "responsive": true,
                "dom": 'Blfrtip',
                "aLengthMenu": [
                    [10, 25, 50, -1],
                    [10, 25, 50, "Todos"]
                ],
                "iDisplayLength": 10,
                "language": {
                    search: "Buscar",
                    emptyTable: "No hay información",
                    info: "Mostrando _START_ a _END_ de _TOTAL_",
                    infoEmpty: "Mostrando 0 a 0 de 0",
                    infoFiltered: "(Filtrado de _MAX_ total entradas)",
                    infoPostFix: "",
                    thousands: ",",
                    lengthMenu: "Mostrar _MENU_ Entradas",
                    // loadingRecords: "Cargando...",

                    processing: "Cargando...",
                    loadingRecords: "",
                    paginate: {
                        first: "Primero",
                        last: "Ultimo",
                        next: "Siguiente",
                        previous: "Anterior"
                    }
                },
                "stateSave": true,
                "stateSaveCallback": function (settings, data) {
                    localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(
                        data))
                },
                "stateLoadCallback": function (settings) {
                    return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
                },
                "order": [
                    [0, "desc"]
                ],
                "buttons": [


                ],
                "searching": true,
                "ajax": {
                    url: '/api/pedidos.php?id_pedido_observacion=No', // Ruta que devuelve los datos de los transportistas
                    method: 'GET',
                    dataSrc: function (data) {
                        console.log(data);

                        return data

                    } // La propiedad que contiene los datos en la respuesta del servidor
                },

                "initComplete": function () {
                    // Renderizar la tabla una vez que los datos se hayan cargado

                    //$('#tabla_transportistas_aceptados').show();
                },
                "processing": true, // Mostrar el indicador de procesamiento
                "serverSide": false,
                "columns": [{
                    "data": "id_observacion",
                    "render": function (data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "id_observacion",
                    "render": function (data, type, row, meta) {
                        return '<img src="./observaciones/' + data +
                            '.png" alt="Imagen del cliente">';
                    }
                },
                {
                    "data": "observacion"
                },
                {
                    "data": null,
                    "render": function (data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');


                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_observacion p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data.id_observacion)
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;
                        var buttonVerFoto = document.createElement('button');
                        buttonVerFoto.className =
                            'btn_seleccionar_archivo p-1 dropdown-item';
                        buttonVerFoto.setAttribute('type', 'button');
                        buttonVerFoto.setAttribute('data-id', data.id_observacion)
                        buttonVerFoto.innerHTML = `
                    <lord-icon src="./assets/lordicons/photo.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Ver imágen
                `;
                        dropdownMenu.appendChild(buttonVerFoto);
                        dropdownMenu.appendChild(buttonEliminar);
                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
                ]


            });

            $(document).on("click", ".btn_seleccionar_archivo", function () {
                var id = $(this).data("id");
                var url = "observaciones/" + id + ".png"
                var div = document.getElementById("contenedor_archivo")
                div.innerHTML = ""



                var imgElement = document.createElement("img");

                // Establecer los atributos del elemento <img>
                imgElement.id = "archivo_modal";
                imgElement.className = "w-100 img-fluid";
                imgElement.src = url; // Aquí establece la fuente de la imagen que desees
                imgElement.alt = "";

                // Agregar el elemento <img> al documento
                div.appendChild(imgElement);




                $("#modalVerArchivo").modal("show");


            });



            function validarEmail(email) {
                var patron = /^[\w\.-]+@[\w\.-]+\.\w+$/;
                return patron.test(email);
            }

            $(document).on("change", ".valor_personalizacion", function (event) {


                if ($(this).attr('id') === 'email_notificacion_alertas') {
                    var nuevoValor = $(this).val();
                    if (validarEmail(nuevoValor) === false) {
                        $.toast({
                            heading: 'Email inválido',
                            text: 'Por favor ingresa un correo electrónico válido.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                        // Si la función retorna false, evitar el cambio de valor
                        event.preventDefault()
                        return false;
                    }
                }

                var nombre = $(this).data("nombre")
                var valor = (nombre != "automatico_presupuestos" && nombre !=
                    "automatico_facturas") ? $(this).val() : $(
                        "#automatico_presupuestos").prop(
                            "checked")

                $.ajax({
                    type: 'POST',
                    url: './api/personalizacion.php',
                    cache: false,
                    async: false,
                    data: {
                        nombre: nombre,
                        valor: valor
                    },
                    success: function (result2) {
                        console.log(result2);
                        $.toast({
                            heading: 'Valor cambiado.',
                            text: 'Se ha cambiado la configuración correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })
                        if (nombre == "url_logo_superior") {
                            $("img.logo_superior").each(function () {
                                console.log($(this));
                                $(this).attr("src", valor)

                            })
                        }
                    }
                });


            });

            $('#tab_observaciones').on('shown.bs.tab', function (e) {
                console.log("hola");
                $($.fn.dataTable.tables(true)).DataTable()
                    .columns.adjust()
                    .responsive.recalc();
            });



        });
    })(jQuery);
</script>