<style>
/* Aplicar el icono a todos los td que no tengan la clase eliminar_row */

#editable-datatable td:not(.row_eliminar) {

    position: relative;

    /* Necesario para posicionar el pseudo-elemento */

}







#editable-datatable td:not(.row_eliminar)::after {

    content: "\f044";

    /* Código Unicode del icono de editar de Font Awesome */

    font-family: "Font Awesome 5 Free";

    /* Familia de fuente de Font Awesome */

    font-weight: 900;

    /* Peso de la fuente */

    font-size: 15px;

    /* Tamaño del icono */

    color: #0cca8e;

    /* Color del icono */

    margin-left: 5px;

    /* Espacio a la izquierda del icono */

    position: absolute;

    /* Posiciona el icono con respecto al td */

    top: 50%;

    /* Centra verticalmente el icono */

    right: 18px;

    height: 18px !important;

    /* Lo coloca a la derecha del td */

    transform: translateY(-50%);

    /* Ajusta la posición vertical */

}



.form-check-inline .form-check-input {

    margin-left: 25px !important;

}
</style>



<div class="modal fade modal-cambiar" id="modalEliminarFacturaManual" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar factura manual</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar la factura manual definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_factura_manual">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalVerFactura" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_factura" class="modal-body pb-3">

                <!-- btn -->











            </div>



            <!-- /btn -->





            <!-- /modal-body -->

        </div>

    </div>

</div>



<div class="modal fade modal-cambiar" id="modalDescargarFacturae" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Generar factura electrónica</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="form-group">

                    <label for="my-input">Nombre de la factura</label>

                    <input id="nombre_facturae" class="sin_espacios form-control" type="text" name="">

                </div>

                <h4>Opciones de descarga</h4>





                <div style="margin-left: 25px;">

                    <div class="form-check form-check-inline d-flex">

                        <input id="inlineCheckbox1" value="1" class="form-check-input" type="radio" name="firmado" <?php $folderPath = 'assets/firma';

                                                                                                $files = glob($folderPath . '/*');

                                                                                                if (count($files) > 0) {

                                                                                                    echo "checked";

                                                                                                } else {

                                                                                                    echo 'disabled';

                                                                                                } ?>>

                        <label class="p-0 form-check-label" for="inlineCheckbox1" style="margin-left: 15px;">Firmar la

                            factura-e con el certificado

                            de

                            firma digital</label>



                    </div>

                    <div class="form-check form-check-inline d-flex">

                        <input id="inlineCheckbox2" value="0" class="form-check-input" type="radio" name="firmado" <?php $folderPath = 'assets/firma';

                                                                                                $files = glob($folderPath . '/*');

                                                                                                if (count($files) == 0) {

                                                                                                    echo "checked";

                                                                                                } ?>>

                        <label class="p-0 form-check-label" for="inlineCheckbox2">Descargar la factura-e sin la firma

                            digital</label>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">

                <button class="btn btn-success btn-fw" type="button" id="btn_facturae">

                    Descargar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalRectificarFacturaManual" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Rectificar factura manual</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->

                <h5>Toca encima de los valores para editarlos.</h5>

                <div class="row">

                    <div class="col-12">

                        <div class="form-group" style="max-width: 200px;">

                            <label>Número

                                <?php if ($personalizacion["automatico_factura_rectificada"] == true) {

                                    echo "(Automático)";

                                } ?></label>

                            <input type="text" class="input_factura form-control" id="numero_factura_rectificada"
                                placeholder="" value="<?php if ($personalizacion["automatico_factura_rectificada"] == true) {

                                                            if ($personalizacion['orden_expediente_factura_rectificada'] == "1") {

                                                                echo htmlentities($personalizacion['expediente_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                            if ($personalizacion['orden_año_factura_rectificada'] == "1") {

                                                                echo date("Y");

                                                            }

                                                            if ($personalizacion['orden_barra_factura_rectificada'] == "1") {

                                                                echo "/";

                                                            }

                                                            if ($personalizacion['orden_numeracion_factura_rectificada'] == "1") {

                                                                echo htmlentities($personalizacion['numeracion_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                            if ($personalizacion['orden_expediente_factura_rectificada'] == "2") {

                                                                echo htmlentities($personalizacion['expediente_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                            if ($personalizacion['orden_año_factura_rectificada'] == "2") {

                                                                echo date("Y");

                                                            }

                                                            if ($personalizacion['orden_barra_factura_rectificada'] == "2") {

                                                                echo "/";

                                                            }

                                                            if ($personalizacion['orden_numeracion_factura_rectificada'] == "2") {

                                                                echo htmlentities($personalizacion['numeracion_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                            if ($personalizacion['orden_expediente_factura_rectificada'] == "3") {

                                                                echo htmlentities($personalizacion['expediente_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                            if ($personalizacion['orden_año_factura_rectificada'] == "3") {

                                                                echo date("Y");

                                                            }

                                                            if ($personalizacion['orden_barra_factura_rectificada'] == "3") {

                                                                echo "/";

                                                            }

                                                            if ($personalizacion['orden_numeracion_factura_rectificada'] == "3") {

                                                                echo htmlentities($personalizacion['numeracion_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                            if ($personalizacion['orden_expediente_factura_rectificada'] == "4") {

                                                                echo htmlentities($personalizacion['expediente_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                            if ($personalizacion['orden_año_factura_rectificada'] == "4") {

                                                                echo date("Y");

                                                            }

                                                            if ($personalizacion['orden_barra_factura_rectificada'] == "4") {

                                                                echo "/";

                                                            }

                                                            if ($personalizacion['orden_numeracion_factura_rectificada'] == "4") {

                                                                echo htmlentities($personalizacion['numeracion_factura_rectificada'], ENT_QUOTES);

                                                            }

                                                        } ?>" <?php if ($personalizacion["automatico_factura_rectificada"] == true) {

                                                                    echo "disabled";

                                                                } ?>>

                        </div>

                    </div>

                </div>

                <div class="table-responsive" style="overflow: auto!important;">

                    <table class="table display nowrap" id="editable-datatable">

                        <thead>

                            <tr>



                                <th>Cantidad</th>





                                <th>Descripción</th>

                                <th>Precio unitario</th>

                                <th>I.G.I.C/IVA</th>

                                <th>Total</th>

                                <th>Acciones</th>

                            </tr>

                        </thead>



                        <tbody>





                        </tbody>



                    </table>

                </div>















            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button class="btn btn-success btn-fw" type="button" id="btn_rectificar_factura_manual">

                    Rectificar apartados </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<script>
(function($) {



    'use strict';



    $(function() {

        $(document).on("click", ".btn_enviar_factura_manual", function(e) {

            var id_factura_manual_enviar = $(this).data("id")

            EnviarFactura(id_factura_manual_enviar)

            $('.tabla_facturas_manuales').DataTable().ajax.reload(null, false);

        })

        $(document).on("click", ".btn_editar_factura_manual", function(e) {

            var id_factura_manual = $(this).data("id")

            var edit = $(this).data("edit")

            if (edit) {



                window.location.href = `./crear_factura_manual?id_factura=${id_factura_manual}`;

            } else {



                $.toast({

                    heading: 'Pagos asociados.',

                    text: 'Para editar la factura primero elimine los pagos asociados.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

        })



        function EnviarFactura(id) {

            var id_factura_manual_enviar = id

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_factura_manual_enviar: id_factura_manual_enviar



                },

                success: function(result2) {

                    console.log(result2);

                    $.toast({

                        heading: 'Factura enviada',

                        text: 'Se ha enviado la factura correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    });

                }

            });

        }



        $(document).on("click", ".btn_descargar_factura_manual", function(e) {

            var id_factura_manual_descargar = $(this).data("id")

            var url

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_factura_manual_descargar: id_factura_manual_descargar



                },

                success: function(result2) {

                    console.log(result2);



                    url = result2;

                }

            });

            var nombre = url.substring(9, url.length)



            $(this).attr("download", nombre)

            $(this).attr("href", url)

        })

        $(document).on("click", ".btn_eliminar_factura_manual", function() {

            $("#btn_eliminar_factura_manual").data("id", $(this).data("id"))

            $("#modalEliminarFacturaManual").modal("show");

        })

        $('#btn_eliminar_factura_manual').click(function(event) {

            var id_factura_manual_eliminar = $("#btn_eliminar_factura_manual").data("id")



            $.ajax({

                type: 'DELETE',

                url: './api/factura_manual.php?id_factura_manual=' +

                    id_factura_manual_eliminar,

                cache: false,

                async: false,

                success: function(result) {



                    $('#modalEliminarFacturaManual').modal("hide")

                    $.toast({

                        heading: 'Factura manual eliminada',

                        text: 'Se ha eliminado la factura manual correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    $('.tabla_facturas_manuales').DataTable().ajax.reload(null,

                        false);

                }

            });

            return false;

        });





        $(document).on("click", ".btn_ver_factura", function() {

            var id_factura_descargar = $(this).data("id")

            var url

            var div = document.getElementById("contenedor_factura")

            div.innerHTML = ""

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_factura_manual_descargar: id_factura_descargar



                },

                success: function(result2) {



                    url = result2;





                    var iframe = document.createElement('iframe');

                    iframe.setAttribute('id', 'factura_modal');

                    iframe.setAttribute('src', url + '?timestamp=' + new Date()

                        .getTime());

                    iframe.style.width = "100%"

                    iframe.style.height = "70vh"

                    div.appendChild(iframe);





                    $("#modalVerFactura").modal("show");

                }

            });









        });









        $(document).on("click", ".btn_facturae", function() {

            $("#btn_facturae").data("id", $(this).data("id"))

            $("#nombre_facturae").val("Factura-e_" + $(this).data("numero"))

            $("#modalDescargarFacturae").modal("show");

        })



        $('#btn_facturae').click(function(event) {

            var id = $(this).data("id")

            var firmado = $('input[name="firmado"]:checked').val();

            var nombre = $("#nombre_facturae").val()

            console.log(firmado);

            $.ajax({

                type: 'GET',

                url: './api/facturae.php?id=' + id + "&firmado=" + firmado +

                    "&nombre=" +

                    nombre,

                cache: false,

                async: false,

                dataType: "json",

                success: function(result) {

                    console.log(result);

                    if (result.success) {

                        if (result.firmado == '1') {

                            var link = document.createElement('a');

                            link.href = result.url;

                            link.download = nombre + '.xsig';

                            document.body.appendChild(link);

                            link.click();

                            document.body.removeChild(link);

                        } else {

                            var link = document.createElement('a');

                            link.href = result.url;

                            link.download = nombre + '.xml';

                            document.body.appendChild(link);

                            link.click();

                            document.body.removeChild(link);

                        }



                        $('#modalDescargarFacturae').modal("hide")

                    } else {

                        $.toast({

                            heading: "Credenciales incorrectas",

                            text: result.error,

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 5000,

                            stack: 6

                        });

                    }





                }

            });

            return false;

        });



    })

})(jQuery);
</script>



<script>
(function($) {



    'use strict';



    $(function() {





        $(function() {

            $('#editable-datatable').DataTable({



                "dom": 'Blfrtip',

                "aLengthMenu": [

                    [10, 25, 50, -1],

                    [10, 25, 50, "Todos"]

                ],

                "iDisplayLength": 10,

                "language": {

                    search: "Buscar",

                    emptyTable: "No hay información",

                    info: "Mostrando _START_ a _END_ de _TOTAL_",

                    infoEmpty: "Mostrando 0 a 0 de 0",

                    infoFiltered: "(Filtrado de _MAX_)",

                    infoPostFix: "",

                    thousands: ",",

                    lengthMenu: "Mostrar _MENU_",

                    // loadingRecords: "Cargando...",



                    processing: "Cargando...",

                    loadingRecords: "",

                    paginate: {

                        first: "Primero",

                        last: "Ultimo",

                        next: "Siguiente",

                        previous: "Anterior"

                    }

                },

                "order": [

                    [0, "desc"]

                ],

                "buttons": [



                    {

                        extend: 'colvis',

                        text: 'Ocultar Columnas',

                        collectionLayout: 'fixed two-column',

                        className: "form-control"

                    }

                ],

                "ajax": {

                    url: './api/factura_manual.php?id=No', // Ruta que devuelve los datos de los clientes

                    method: 'GET',

                    dataSrc: function(json) {

                        console.log(json);

                        console.log(json.apartados);

                        return json.apartados;

                    } // La propiedad que contiene los datos en la respuesta del servidor

                },

                "serverSide": false,

                "columnDefs": [{

                    "targets": "_all",

                    createdCell: function(td, cellData, rowData, row, col) {

                        console.log(td);

                    }

                }],





                "columns": [{

                        "data": 'cantidad',

                        "name": 'cantidad',

                        "render": function(data, type, row) {

                            const match = data.match(/\d+/);

                            console.log();

                            return match

                        }

                    },

                    {

                        "data": 'descripcion',

                        "className": 'row_eliminar',

                        "name": 'descripcion'

                    },

                    {

                        "data": 'precio_unitario',

                        "name": 'precio_unitario'

                    },

                    {

                        "data": 'igic',

                        "name": 'igic'

                    },

                    {

                        "data": null,

                        "name": 'total',

                        "className": 'row_eliminar',

                        "render": function(data, type, row) {



                            var total = (parseFloat(data.precio_unitario) *

                                parseInt(data

                                    .cantidad)) + (parseFloat(data

                                .precio_unitario) * parseInt(data

                                .cantidad) * (parseFloat(data.igic) / 100))

                            return total.toFixed(2)

                        }

                    },

                    {

                        "data": null,

                        "className": 'row_eliminar',

                        "render": function(data, type, row) {

                            var checkbox = document.createElement("input");

                            checkbox.setAttribute("type", "checkbox");



                            checkbox.setAttribute("id", data

                                .id_apartado_factura_manual);

                            checkbox.classList.add("custom-control-input");

                            checkbox.classList.add("rectificar_apartado");



                            // Crear el elemento de la etiqueta del checkbox

                            var label = document.createElement("label");

                            label.classList.add("custom-control");

                            label.classList.add("custom-checkbox");

                            label.classList.add("d-inline-block");

                            label.classList.add("mb-0");

                            label.appendChild(checkbox);







                            var span = document.createElement("span");

                            span.classList.add("custom-control-label");

                            span.textContent = "Rectificar";

                            span.style.fontSize = "16px"

                            // Agregar el checkbox y el span al label

                            label.appendChild(checkbox);

                            label.appendChild(span);

                            return label.outerHTML

                        }

                    }

                ],

                "select": true,

                "searching": true,

                "initComplete": function() {















                }

            })





        })

        $(document).on('change', '.rectificar_apartado', function() {

            var $row = $(this).closest('tr');





            if ($(this).prop("checked")) {

                $('#editable-datatable').DataTable().row($row).data().id_medida = 1

            } else {

                $('#editable-datatable').DataTable().row($row).data().id_medida = 0

            }



            console.log($('#editable-datatable').DataTable().row($row).data())



        });



        function verificarFormatoCantidad(texto) {

            // Expresión regular para verificar si el texto está compuesto por un número entero o un número entero seguido de un espacio y otro string

            return /^-?\d+$/.test(texto);

        }



        function validarNumeroDecimal(texto) {

            // Expresión regular para validar números decimales

            var regex = /^\d+(\.\d+)?$/;



            // Verificar si el texto coincide con la expresión regular

            return regex.test(texto);

        }

        $(document).on("change", '#editable-datatable tbody tr td:not(.row_eliminar)', function(e) {

            // Obtener el objeto DataTables.Cell para esta celda

            var cell = $('#editable-datatable').DataTable().cell($(this));

            var rowIndex = cell.index()

                .row; // Obtener el índice de la fila de la celda seleccionada

            var rowData = $('#editable-datatable').DataTable().row(rowIndex)

                .data(); // Obtener los datos de la fila

            console.log(rowData);

            // Obtener el valor actual de la celda

            var valorActual = cell.data();



            var texto = $(this).text()

            var columnaIndex = $(this).index(); // Índice de la columna

            var atributo = $('#editable-datatable').DataTable().column(columnaIndex).dataSrc()

            console.log(atributo);

            var cantidad = texto

            var medida = (texto.split(" ")[1] != undefined) ? texto.split(" ")[1] : null

            console.log(medida);

            if (atributo == "cantidad") {

                var s = true

                if (verificarFormatoCantidad(cantidad)) {

                    $.ajax({

                        url: "./api/apartados.php?codigo=" + rowData.codigo,

                        type: 'GET',

                        dataType: 'json', // added data type

                        cache: false,

                        async: false,

                        success: function(res) {



                            if (parseInt(cantidad) > (parseInt(res.stock_disponible) +

                                    parseInt(valorActual))) {

                                $.toast({

                                    heading: 'Stock insuficiente.',

                                    text: 'La cantidad del servicio/producto supera el stock disponible.',

                                    position: 'top-right',

                                    loaderBg: '#ff5c6c',

                                    icon: 'error',

                                    hideAfter: 5000,

                                    stack: 6

                                });



                                $(this).text(valorActual)

                                s = false



                            } else {



                                cell.data(cantidad).draw();

                            }

                        }

                    })

                    if (!s) {

                        return false

                    }

                } else {

                    $(this).text(valorActual)

                    return false

                }





            }

            if (atributo == "precio_unitario" ||

                atributo == "igic") {

                if (validarNumeroDecimal(texto)) {

                    cell.data(texto).draw();

                } else {

                    $(this).text(valorActual)

                    return false

                }





            }



            var row = cell.index().row;

            var table = $('#editable-datatable').DataTable();



            // Obtener los valores de las celdas necesarias en la misma fila

            var cantidad = parseInt(table.cell(row, table.column('cantidad:name').index()).data());

            var precio_unitario = parseFloat(table.cell(row, table.column('precio_unitario:name')

                .index()).data());

            var igic = parseFloat(table.cell(row, table.column('igic:name').index()).data());



            // Calcular el total

            var total = (precio_unitario * cantidad) + (precio_unitario * cantidad * (igic / 100));



            // Actualizar la celda 'total' en la misma fila

            table.cell(row, table.column('total:name').index()).data(total.toFixed(2)).draw();



            console.log(cell.data())





        });













        $(document).on("click", ".btn_rectificar_factura_manual", function(e) {

            var id_factura_manual = $(this).data("id")

            $("#btn_rectificar_factura_manual").data("id", id_factura_manual)

            var edit = $(this).data("edit")

            if (edit) {



                $('#editable-datatable').DataTable().settings()[0].ajax

                    .data =

                    function(data) {

                        data.id = id_factura_manual; // Establece el valor de fecha_i



                    };

                $('#editable-datatable').DataTable().ajax.reload(function() {



                    $('#editable-datatable').editableTableWidget()



                    $("#editable-datatable tbody tr td.row_eliminar").removeAttr(

                        'tabindex');

                    $("#modalRectificarFacturaManual").modal("show");

                });

            } else {



                $.toast({

                    heading: 'Pagos asociados.',

                    text: 'Para rectificar la factura primero elimine los pagos asociados.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }





        })

        $('#btn_rectificar_factura_manual').click(function(event) {

            var id_factura_manual_rectificar = $("#btn_rectificar_factura_manual").data("id")

            var datos = [];

            $('#editable-datatable').DataTable().rows().data().map((row) => {



                console.log(row);

                let descripcion = row.descripcion

                let titulo = row.titulo



                let precio_unitario = parseFloat(row.precio_unitario).toFixed(2)

                let igic = parseFloat(row.igic).toFixed(2)

                let data = {

                    id_apartado_factura_manual: row

                        .id_apartado_factura_manual,

                    descripcion: descripcion,

                    titulo: titulo,

                    cantidad: row.cantidad,

                    igic: igic,

                    precio_unitario: precio_unitario

                }

                if (row.id_medida == 1) {

                    datos.push(data)

                }



            })

            if (datos.length == 0) {

                $.toast({

                    heading: 'Por favor selecciona por lo menos un apartado.',

                    text: 'No se ha seleccionado ningun apartado para rectificar.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false;

            }

            var detallado_rectificar = JSON.stringify(datos);

            var numero_rectificar = $("#numero_factura_rectificada").val()

            console.log(detallado_rectificar);

            $.ajax({

                type: 'POST',

                url: './api/factura_manual.php',

                cache: false,

                async: false,

                dataType: "json",

                data: {

                    id_factura_manual_rectificar: id_factura_manual_rectificar,

                    detallado_rectificar: detallado_rectificar,

                    numero_rectificar: numero_rectificar

                },



                success: function(detalle) {

                    console.log(detalle);

                    $.toast({

                        heading: 'Factura rectificada.',

                        text: 'Se ha rectificado la factura correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    setTimeout(function() {



                            window.location.href =

                                "./historial_facturas_rectificadas"



                        },

                        2000);



                }

            })

        })

    })

})(jQuery);
</script>