<div class="content-wrapper">



    <div class="row profile-page ">




        <div class="col-md-6">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="./assets/lordicons/car_itv.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">I.T.V de próximo vencimiento</p>

                        <span id="itv_proximas_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-6">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="./assets/lordicons/pendiente.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">I.T.V pendientes</p>

                        <span id="itv_pendientes_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>



    <div class="row profile-page">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">



                    <div class="pt-0 ">



                        <div class="row ">


                            <!-- Historial de Acceso -->



                            <div class="col-12">



                                <div class="card card-cuenta">



                                    <div class="card-body card-table-body p-3">


                                        <div class="row mb-3">
                                            <div class="col-md-4">

                                                <button class="btn btn-info" type="button" data-toggle="modal"
                                                    data-target="#modalConfigurar">Configurar</button>
                                            </div>
                                        </div>

                                        <div class="table-responsive">

                                            <table id="tabla_itv" class="table">

                                                <thead>

                                                    <tr>


                                                        <th>Nombre</th>

                                                        <th>Telèfono</th>

                                                        <th>Próximo pago</th>

                                                        <th>Email</th>

                                                        <th>Marca</th>

                                                        <th>Modelo</th>
                                                        <th>Matrìcula</th>

                                                        <th>Fecha de venta</th>
                                                        <th>Envìo habilitado</th>
                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>



                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminaci贸n de cuenta -->



                            <!-- /Eliminaci贸n de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



</div>





<!-- MODALS -->









<script>
(function($) {

    'use strict';

    $(function() {

        var Table = $('#tabla_itv').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en vehiculos",
                infoEmpty: "Mostrando 0 a 0 de 0 en vehiculos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/ventas.php?vendidos=1', // Ruta que devuelve los datos de los apartados
                method: 'GET',
                dataSrc: function(data) {
                    console.log(data);
                    const today = new Date();
                    const countPendientes = data.filter(v => new Date(v.proxima_itv) <
                        today).length;
                    const countProximas = data.filter(v => new Date(v.proxima_itv) >=
                        today).length;

                    // Contar objetos con exposicion "Zona 2"


                    $("#itv_pendientes_count").text(countPendientes)
                    $("#itv_proximas_count").text(countProximas)
                    return data;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_vehiculos').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "nombre_cliente"
                },
                {
                    "data": "telefono"
                },
                {
                    "data": "proxima_itv"
                },
                {
                    "data": "email"
                },
                {
                    "data": "nombre_marca"
                },
                {
                    "data": "nombre_modelo"
                },
                {
                    "data": "matricula"
                },
                {
                    "data": "fecha"
                },
                {
                    "data": null,
                    "render": function(data, type, row, meta) {
                        var ac = (data.envio_vencimiento == 1) ? "Habilitado" :
                            "Deshabilitado"
                        const checkboxContainer = document.createElement("label");
                        checkboxContainer.classList.add("custom-control", "custom-checkbox",
                            "d-inline-block");

                        // Crear el elemento checkbox
                        const checkbox = document.createElement("input");
                        checkbox.type = "checkbox";
                        checkbox.setAttribute("data-id", data.id_vehiculo);
                        checkbox.classList.add("custom-control-input");
                        checkbox.classList.add("activos");
                        checkbox.style.fontSize = "18px"
                        // Opción 1: Usar el atributo "checked"

                        var acc = (data.envio_vencimiento == 1) ? 1 : 0

                        // Opción 2: Usar el método setAttribute
                        if (acc) {
                            checkbox.setAttribute('checked', 1);
                        }
                        // Crear el elemento span para la etiqueta
                        const labelSpan = document.createElement("span");

                        labelSpan.classList.add("custom-control-label");
                        labelSpan.textContent = ac;
                        labelSpan.style.fontSize = "16px"
                        // Agregar el checkbox y el span al contenedor
                        checkboxContainer.appendChild(checkbox);
                        checkboxContainer.appendChild(labelSpan);

                        return checkboxContainer.outerHTML;
                    }
                },
                {
                    "data": "id_vehiculo",
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');



                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_edit_vehiculo p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data);
                        buttonEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;

                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_vehiculo p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data);
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;


                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        });




        $(document).on("click", ".btn_edit_vehiculo", function(e) {
            $("#btn_edit_vehiculo").data("id", $(this).data("id"))

            $.ajax({
                url: "./api/vehiculos.php?id_vehiculo=" + $(this).data("id"),
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(res) {
                    $('#nombre_vehiculo_editar').val(res.nombre)
                    $("#swift_vehiculo_editar").val(res.swift)
                    $("#direccion_vehiculo_editar").val(res.direccion)
                    $("#iban_vehiculo_editar").val(res.iban)
                    $("#beneficiario_vehiculo_editar").val(res.beneficiario)
                    $("#divisa_vehiculo_editar").val(res.divisa)
                }
            });

            $("#modalEditarVehiculo").modal('show');

        })


        $(document).on("change", ".activos", function() {
            var id_vehiculo = $(this).data('id');

            var activo = $(this).prop('checked')
            if (activo) {
                activo = 1
            } else {
                activo = 0
            }
            var span = $(this).siblings("span").first()
            $.ajax({
                type: 'POST',
                url: './api/ventas.php',
                data: {

                    id_vehiculo: id_vehiculo,
                    envio_vencimiento: activo

                },
                async: true,
                cache: false,
                dataType: "json",
                success: function(r) {
                    var sp = (activo == 1) ? "Habilitado" : "Deshabilitado"

                    span.text(sp)

                    $('.tabla_itv').DataTable().ajax.reload(null, false);
                }
            })

        });






    });

})(jQuery);
</script>

<?php require_once __VIEWS__ . 'selects/configuracion_itv.template.php'; ?>