<div class="content-wrapper">

    <div class="row profile-page ">

        <div class="col-md-6">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="./assets/lordicons/car_sell.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Vehículos vendidos</p>

                        <span id="vehiculos_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

        <div class="col-md-6">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="./assets/lordicons/users.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Clientes actuales</p>

                        <span id="clientes_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div class="row profile-page">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0 ">

                        <div class="row ">

                            <!-- Historial de Acceso -->

                            <div class="col-12">

                                <div class="card card-cuenta">

                                    <div class="card-body card-table-body p-3">

                                        <div class="row">

                                            <div class="col-12">

                                                <button data-toggle="modal" data-target="#modalAgregarVenta"
                                                    class="m-0 mb-3 btn btn-sm btn-primary">Agregar</button>

                                            </div>

                                        </div>

                                        <div class="row">

                                            <div class="col-sm-6 col-md-5 col-xl-3">

                                                <div class="form-group">

                                                    <label for="my-input">Fecha de inicio</label>

                                                    <input class="form-control" type="month" id="fecha_i">

                                                </div>

                                            </div>

                                            <div class="col-sm-6 col-md-5 col-xl-3">

                                                <div class="form-group">

                                                    <label for="my-input">Fecha de fin</label>

                                                    <input class="form-control" type="month" id="fecha_f">

                                                </div>

                                            </div>

                                        </div>

                                        <div class="table-responsive">

                                            <table id="tabla_ventas" class="table">

                                                <thead>

                                                    <tr>

                                                        <th
                                                            style="padding-left: 32px !important;padding-right: 50px !important;">

                                                            ID</th>

                                                        <th>Cliente</th>

                                                        <th>Marca</th>

                                                        <th>Modelo</th>

                                                        <th>Forma de pago</th>

                                                        <th>Financiera</th>

                                                        <th>Fecha de matriculacion</th>

                                                        <th>Fecha de venta</th>

                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>

                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminaci贸n de cuenta -->

                            <!-- /Eliminaci贸n de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<!-- MODALS -->

<div class="modal fade" id="modalAgregarVenta" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar venta</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Fecha de venta</label>

                                <input class="form-control w-100" id="fecha_venta" type="date">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Método de pago</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_metodo file-upload-browse btn btn-danger"
                                                data-target="id_metodo_venta" type="button">-</button>

                                        </span>

                                        <select id="id_metodo_venta"
                                            class="select_metodos custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMetodo">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Cliente</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                                data-target="client_id_venta" type="button">-</button>

                                        </span>

                                        <select id="client_id_venta"
                                            class="select_clientes custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarCliente">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Vehículo</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_vehiculo file-upload-browse btn btn-danger"
                                                data-target="id_vehiculo_venta" type="button">-</button>

                                        </span>

                                        <select id="id_vehiculo_venta"
                                            class="select_vehiculos custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarVehiculo">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Financiera</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_financiera file-upload-browse btn btn-danger"
                                                data-target="id_financiera_venta" type="button">-</button>

                                        </span>

                                        <select id="id_financiera_venta"
                                            class="select_financieras custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarFinanciera">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Plazo en meses</label>

                                <input disabled type="number" class="form-control" id="plazo_venta">

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_add_venta" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalEditarVenta" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Editar venta</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Fecha de venta</label>

                                <input class="form-control w-100" id="fecha_venta_editar" type="date">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Método de pago</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_metodo file-upload-browse btn btn-danger"
                                                data-target="id_metodo_venta_editar" type="button">-</button>

                                        </span>

                                        <select id="id_metodo_venta_editar"
                                            class="select_metodos custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMetodo">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Cliente</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                                data-target="client_id_venta_editar" type="button">-</button>

                                        </span>

                                        <select id="client_id_venta_editar"
                                            class="select_clientes custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarCliente">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Vehículo</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_vehiculo file-upload-browse btn btn-danger"
                                                data-target="id_vehiculo_venta_editar" type="button">-</button>

                                        </span>

                                        <select id="id_vehiculo_venta_editar"
                                            class="select_vehiculos custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarVenta">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Financiera</label>

                                <div class="form-group">

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_financiera file-upload-browse btn btn-danger"
                                                data-target="id_financiera_venta_editar" type="button">-</button>

                                        </span>

                                        <select id="id_financiera_venta_editar"
                                            class="select_financieras custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarFinanciera">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Plazo en meses</label>

                                <input disabled type="number" class="form-control" id="plazo_venta_editar">

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_edit_venta" class="btn btn-success btn-fw" type="button">

                    Editar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEliminarVenta" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar venta</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->

                <p class="">¿Estás seguro de que deseas eliminar la venta definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">

                <input type="hidden" id="id_venta_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_venta">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/vehiculos.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/financieras.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/metodos_pago.template.php'; ?>

<script>
(function($) {

    'use strict';

    $(function() {

        var Table = $('#tabla_ventas').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "lengthMenu": [

                [5, 10, 15, -1],

                [5, 10, 15, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en ventas",

                infoEmpty: "Mostrando 0 a 0 de 0 en ventas",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                loadingRecords: "Cargando...",

                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [

                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }

            ],

            "searching": true,

            "ajax": {

                url: '/api/ventas.php', // Ruta que devuelve los datos de los apartados

                method: 'GET',

                dataSrc: function(data) {

                    console.log(data);

                    let idsUnicos = new Set();

                    // Iteramos sobre cada objeto y almacenamos el client_id en el conjunto

                    data.forEach(objeto => {

                        idsUnicos.add(objeto.client_id);

                    });

                    $("#vehiculos_count").text(data.length)

                    $("#clientes_count").text(idsUnicos.size)

                    return data;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },

            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_ventas').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "id_venta",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre_cliente"

                },

                {

                    "data": "nombre_marca"

                },

                {

                    "data": "nombre_modelo"

                },

                {

                    "data": "nombre_metodo"

                },

                {

                    "data": "nombre_financiera"

                },

                {

                    "data": "fecha_matriculacion"

                },

                {

                    "data": "fecha"

                },

                {

                    "data": null,

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var linkVerPerfil = document.createElement('a');

                        linkVerPerfil.className = 'p-1 dropdown-item';

                        linkVerPerfil.href = `./cliente?id=${data.client_id}`;

                        linkVerPerfil.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#00000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Ver Perfil

                `;

                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'btn_edit_venta p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data.id_venta);

                        buttonEditar.innerHTML = `

                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Editar

                `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =

                            'btn_eliminar_venta p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data.id_venta);

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;

                        dropdownMenu.appendChild(linkVerPerfil);

                        dropdownMenu.appendChild(buttonEditar);

                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }

                }

            ]

        });

        $("#fecha_i, #fecha_f").change(function() {

            var fecha_i = new moment($("#fecha_i").val()).format("YYYY-MM-DD")

            var fecha_f = new moment($("#fecha_f").val()).format("YYYY-MM-DD")

            if ($("#fecha_i").val() != "" && $("#fecha_f").val() != "") {

                var nuevaUrl = "/api/ventas.php?fecha_i=" + fecha_i + "&fecha_f=" +

                    fecha_f

                $('#tabla_ventas').DataTable().ajax.url(nuevaUrl).load();

            } else {

                var nuevaUrl = "/api/ventas.php"

                $('#tabla_ventas').DataTable().ajax.url(nuevaUrl).load();

            }

        })

        function validarCampos() {

            var fecha_venta = $("#fecha_venta").val();

            var client_id_venta = $("#client_id_venta").val();

            var id_vehiculo_venta = $("#id_vehiculo_venta").val();

            var id_financiera_venta = $("#id_financiera_venta").val();

            var plazo_venta = $("#plazo_venta").val();

            var res = true

            if (fecha_venta == "") {

                $.toast({

                    heading: 'Campo vacío',

                    text: 'El campo Fecha no puede estar vacío.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                res = false

            }

            if (client_id_venta == "No") {

                $.toast({

                    heading: 'Campo vacío',

                    text: 'Debes seleccionar un cliente.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                res = false

            }

            if (id_vehiculo_venta == "No") {

                $.toast({

                    heading: 'Campo vacío',

                    text: 'Debes seleccionar un vehículo.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                res = false

            }

            if (id_financiera_venta != "No") {

                if (plazo_venta == "") {

                    $.toast({

                        heading: 'Campo vacío',

                        text: 'El campo Plazo no puede estar vacío cuando estas seleccionando una financiera.',

                        position: 'top-right',

                        loaderBg: '#ff5c6c',

                        icon: 'error',

                        hideAfter: 5000,

                        stack: 6

                    });

                    res = false

                }

            }

            return res

        }

        function validarCamposEditar() {

            var fecha_venta = $("#fecha_venta_editar").val();

            var client_id_venta = $("#client_id_venta_editar").val();

            var id_vehiculo_venta = $("#id_vehiculo_venta_editar").val();

            var id_financiera_venta = $("#id_financiera_venta_editar").val();

            var plazo_venta = $("#plazo_venta_editar").val();

            var res = true

            if (fecha_venta == "") {

                $.toast({

                    heading: 'Campo vacío',

                    text: 'El campo Fecha no puede estar vacío.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                res = false

            }

            if (client_id_venta == "No") {

                $.toast({

                    heading: 'Campo vacío',

                    text: 'Debes seleccionar un cliente.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                res = false

            }

            if (id_vehiculo_venta == "No") {

                $.toast({

                    heading: 'Campo vacío',

                    text: 'Debes seleccionar un vehículo.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                res = false

            }

            if (id_financiera_venta != "No") {

                if (plazo_venta == "") {

                    $.toast({

                        heading: 'Campo vacío',

                        text: 'El campo Plazo no puede estar vacío cuando estas seleccionando una financiera.',

                        position: 'top-right',

                        loaderBg: '#ff5c6c',

                        icon: 'error',

                        hideAfter: 5000,

                        stack: 6

                    });

                    res = false

                }

            }

            return res

        }

        $("#btn_add_venta").click(function() {

            $("#btn_add_venta").addClass('btn-loading');

            var fecha_venta = $('#fecha_venta').val()

            var id_metodo_venta = $("#id_metodo_venta").val()

            var client_id_venta = $("#client_id_venta").val()

            var id_vehiculo_venta = $("#id_vehiculo_venta").val()

            var id_financiera_venta = $("#id_financiera_venta").val()

            var plazo_venta = $("#plazo_venta").val()

            if (!validarCampos()) {

                $("#btn_add_venta").removeClass('btn-loading');

                return false

            }

            $.ajax({

                type: 'POST',

                url: './api/ventas.php',

                cache: false,

                dataType: "json",

                cache: false,

                async: false,

                data: {

                    fecha: fecha_venta,

                    id_metodo: id_metodo_venta,

                    client_id: client_id_venta,

                    id_vehiculo: id_vehiculo_venta,

                    id_financiera: id_financiera_venta,

                    plazo: plazo_venta

                },

                success: function(r) {

                    if (r.success) {

                        $('#modalAgregarVenta').modal("hide")

                        $.toast({

                            heading: r.title,

                            text: r.message,

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                    } else {

                        $.toast({

                            heading: r.title,

                            text: r.message,

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 5000,

                            stack: 6

                        });

                    }

                    $('#tabla_ventas').DataTable().ajax.reload(null, false);

                    $("#btn_add_venta").removeClass('btn-loading');

                }

            });

        })

        $(document).on("click", ".btn_edit_venta", function(e) {

            $("#btn_edit_venta").data("id", $(this).data("id"))

            $.ajax({

                url: "./api/ventas.php?id_venta=" + $(this).data("id"),

                type: 'GET',

                cache: false,

                async: false,

                dataType: "json",

                success: function(res) {

                    console.log(res);

                    var fecha_venta = $('#fecha_venta_editar').val(res.fecha)

                    if (res.id_metodo != null) {

                        $("#id_metodo_venta_editar").val(res.id_metodo).trigger(

                            "change")

                    } else {

                        $("#id_metodo_venta_editar").val("No").trigger("change")

                    }

                    if (res.client_id != null) {

                        $("#client_id_venta_editar").val(res.client_id).trigger(

                            "change")

                    } else {

                        $("#client_id_venta_editar").val("No").trigger("change")

                    }

                    if (res.id_vehiculo != null) {

                        $("#id_vehiculo_venta_editar").val(res.id_vehiculo).trigger(

                            "change")

                    } else {

                        $("#id_vehiculo_venta_editar").val("No").trigger("change")

                    }

                    if (res.id_financiera != null) {

                        $("#plazo_venta_editar").val(res.plazo);

                        $("#id_financiera_venta_editar").val(res.id_financiera).trigger(

                            "change");

                    } else {

                        $("#id_financiera_venta_editar").val("No").trigger("change");

                        $('#plazo_venta_editar').val('');

                    }

                    $("#modalEditarVenta").modal('show');

                }

            });

        })

        $("#btn_edit_venta").click(function() {

            $("#btn_edit_venta").removeClass('btn-loading');

            var fecha_venta = $('#fecha_venta_editar').val()

            var id_metodo_venta = $("#id_metodo_venta_editar").val()

            var client_id_venta = $("#client_id_venta_editar").val()

            var id_vehiculo_venta = $("#id_vehiculo_venta_editar").val()

            var id_financiera_venta = $("#id_financiera_venta_editar").val()

            var plazo_venta = $("#plazo_venta_editar").val()

            var id_venta = $("#btn_edit_venta").data("id")

            if (!validarCamposEditar()) {

                $("#btn_edit_venta").removeClass('btn-loading');

                return false

            }

            $.ajax({

                type: 'POST',

                url: './api/ventas.php',

                cache: false,

                async: false,

                dataType: "json",

                data: {

                    fecha: fecha_venta,

                    id_metodo: id_metodo_venta,

                    client_id: client_id_venta,

                    id_vehiculo: id_vehiculo_venta,

                    id_financiera: id_financiera_venta,

                    plazo: plazo_venta,

                    id_venta: id_venta

                },

                success: function(r) {

                    if (r.success) {

                        $('#modalEditarVenta').modal("hide")

                        $.toast({

                            heading: 'Vehículo editado.',

                            text: 'Se ha editado el vehículo correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                    } else {

                        $.toast({

                            heading: r.title,

                            text: r.message,

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 5000,

                            stack: 6

                        });

                    }

                    $('#tabla_ventas').DataTable().ajax.reload(null, false);

                    $("#btn_edit_venta").removeClass('btn-loading');

                }

            });

        })

        $(document).on("click", ".btn_eliminar_venta", function() {

            var target = $(this).data("target");

            if (typeof target === 'undefined') {

                console.log($(this).data("id"));

                $("#id_venta_eliminar").val($(this).data("id"))

            } else {

                if ($("#" + target).val() == "No") {

                    return false;

                } else {

                    $("#id_venta_eliminar").val($("#" + target).val())

                }

            }

            $("#modalEliminarVenta").modal("show");

        })

        $('#btn_eliminar_venta').click(function(event) {

            var id_venta_eliminar = $("#id_venta_eliminar").val()

            console.log(id_venta_eliminar);

            $.ajax({

                type: 'DELETE',

                url: './api/ventas.php?id=' + id_venta_eliminar,

                cache: false,

                success: function(result) {

                    $('#modalEliminarVenta').modal("hide")

                    $.toast({

                        heading: 'Venta eliminada',

                        text: 'Se ha eliminado la venta correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    $('#tabla_ventas').DataTable().ajax.reload(null, false);

                }

            });

            return false;

        });

        $('#id_financiera_venta').on('change', function() {

            console.log("hol");

            let value = $(this).val();

            console.log(value);

            if (value == "No") {

                $('#plazo_venta').prop('disabled', true);

            } else {

                $('#plazo_venta').prop('disabled', false);

            }

        });

        $('#id_financiera_venta_editar').on('change', function() {

            let value = $(this).val();

            console.log(value);

            if (value == "No") {

                $('#plazo_venta_editar').prop('disabled', true);

            } else {

                $('#plazo_venta_editar').prop('disabled', false);

            }

        });

    });

})(jQuery);
</script>