<style>
.custom-switch .custom-control-label::before {
    left: -1rem;
    width: 1.75rem;
    pointer-events: all;
    border-radius: 0.5rem;
}

.btn_edit_evento,
.btn_cancelar_evento,
.btn_eliminar_evento {
    display: none;
}

.custom-switch .custom-control-input:checked~.custom-control-label::after {
    background-color: #fff;
    -webkit-transform: translateX(0.75rem);
    transform: translateX(0.75rem);
}

.custom-switch .custom-control-label::after {
    top: 12px !important;
    left: calc(-1rem + 2px);
    width: calc(1rem - 4px);
    height: calc(1rem - 4px);
    background-color: #adb5bd;
    border-radius: 0.5rem;
    transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out, -webkit-transform .15s ease-in-out;
    transition: transform .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
    transition: transform .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out, -webkit-transform .15s ease-in-out;
}

.custom-control-label::before,
.custom-control-label::after {
    top: 0px !important;
}

p.fechas small {
    color: #aaa;
}

#eventos_list {
    max-height: 80vh;
    overflow-y: auto;
}

#eventos_list::-webkit-scrollbar {
    width: 8px;
}

#eventos_list::-webkit-scrollbar-track {
    background: #f1f1f1;
}

#eventos_list::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 10px;
}

#eventos_list::-webkit-scrollbar-thumb:hover {

    background: #555;
}
</style>
<div class="content-wrapper">



    <div class="row profile-page ">



        <div class="col-md-12 mb-8 p-0">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/wrhxfrid.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">MIS EVENTOS</p>

                        <span id="eventos_count" class="">
                            <?php echo count($Eventos) ?>
                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>










    <div class="row card p-4">

        <!-- Historial de Acceso -->



        <div class="col-md-12 p-0">

            <div class="row">
                <div class="col-md-6">

                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <div class="input-group" style="max-width: 200px;float: right;">
                            <input id="search_evento" class="form-control" type="text" placeholder="Buscar">
                            <div class="input-group-append">
                                <span class="input-group-text" id="my-addon"><i class="fas fa-search"></i></span>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-12">
                    <h4>Filtros</h4>
                </div>
                <div class="d-none col-md-3">
                    <div class="form-group">

                        <label class="custom-control custom-checkbox d-inline-block"
                            style="height: auto;min-height: unset;">
                            <input type="checkbox" class="custom-control-input apartado" id="fechas_check">
                            <span class="custom-control-label">Rango de fechas</span>
                        </label>
                        <input disabled id="filtro_fechas" class="form-control" type="text" name="daterange" />
                    </div>

                </div>
                <style>
                .daterangepicker .drp-calendar {
                    max-width: unset !important;

                }
                </style>
                <div class="col-md-3">
                    <div class="form-group">

                        <label>Categoría</label>



                        <div class="input-group filtro">
                            <span class="input-group-prepend">
                                <button class="btn_eliminar_categoria file-upload-browse btn btn-danger"
                                    data-target="filtro_categoria" type="button">-</button>
                            </span>
                            <select id="filtro_categoria" data-filtro="categoria"
                                class="activo select_categorias custom-select select2 form-control">
                                <option value="All">
                                    Todas
                                </option>
                                <?php
                                foreach ($Categorias as $Categoria)
                                    {
                                    ?>
                                <option value="<?php echo $Categoria['id_categoria']; ?>">
                                    <?php echo $Categoria['nombre']; ?>
                                </option>
                                <?php
                                    }
                                ?>
                                <option value="No">
                                    Ninguna
                                </option>
                            </select>
                            <span class="input-group-append">
                                <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                    data-target="#modalAgregarCategoria">+</button>
                            </span>
                        </div>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="my-input">Estado</label>
                        <div class="filtro">
                            <select id="filtro_estado" data-filtro="estado"
                                class="activo select_filtro form-control custom-select text-center select2" required>
                                <option value="All">
                                    Todos
                                </option>
                                <option value="Activo">
                                    Activo
                                </option>
                                <option value="Pendiente">
                                    Pendiente
                                </option>
                                <option value="Finalizado">
                                    Finalizado
                                </option>
                                <option value="Cancelado">
                                    Cancelado
                                </option>

                            </select>


                        </div>




                    </div>
                </div>


            </div>


            <div id="eventos_list" class="row">
                <?php
                foreach ($Eventos as $Evento)
                    {

                    ?>
                <div class="col-lg-3 mb-3">
                    <div id="evento_<?php echo htmlentities($Evento['id_evento'], ENT_QUOTES); ?>"
                        data-nombre="<?php echo htmlentities($Evento['nombre'], ENT_QUOTES); ?>" class="card evento">
                        <img class="card-img-top img-responsive"
                            src="<?php echo htmlentities($Evento['imagen'], ENT_QUOTES); ?>" alt="Card image cap">
                        <div class="card-body p-3">
                            <h4 class="texto_desplegable card-title d-flex flex-column align-items-start">
                                <span class="mb-1">
                                    <?php echo htmlentities($Evento['nombre'], ENT_QUOTES); ?>
                                </span>


                                <?php
                                    $fechaActual = date('Y-m-d H:i:s');
                                    $fechaInicio = $Evento['fecha_inicio'];
                                    $fechaFin = $Evento['fecha_final'];
                                    $timestampActual = strtotime($fechaActual);
                                    $timestampInicio = strtotime($fechaInicio);
                                    $timestampFin = strtotime($fechaFin);
                                    $estado;

                                    if ($Evento['cancelado'] == 1)
                                        {
                                        $estado = "Cancelado";
                                        ?>
                                <small class="estado">
                                    <span>Cancelado</span>

                                    <i class="text-danger fas fa-ban"></i>
                                </small>
                                <?php
                                        } else
                                        {

                                        if ($timestampInicio <= $timestampActual && $timestampActual <= $timestampFin)
                                            {
                                            $estado = "Activo";
                                            ?>
                                <small class="estado">
                                    <span>Activo</span>

                                    <i class="text-success fas fa-check-circle"></i>
                                </small>
                                <?php
                                            } else
                                            {
                                            if ($timestampActual <= $timestampInicio)
                                                {
                                                $estado = "Pendiente";
                                                ?>
                                <small class="estado">
                                    <span>Pendiente</span>

                                    <i class="text-warning fas fa-clock"></i>
                                </small>
                                <?php
                                                } else
                                                {
                                                $estado = "Finalizado";
                                                ?>
                                <small class="estado">
                                    <span>Finalizado</span>

                                    <i class="text-danger fas fa-times-circle"></i>
                                </small>
                                <?php
                                                }
                                            }
                                        }

                                    ?>

                            </h4>
                            <p class="fechas mb-1">
                                <small>
                                    <?php
                                        echo "Inicio: " . htmlentities($Evento['fecha_inicio'], ENT_QUOTES);
                                        echo "<br/>";
                                        echo "Final: " . htmlentities($Evento['fecha_final'], ENT_QUOTES);

                                        ?>
                                </small>
                            </p>

                            <small class="categoria" data-id="<?php
                                $categoria = $this->Eventos->GetCategoria($Evento['id_categoria']);
                                if ($categoria != null)
                                    {
                                    echo htmlentities($Evento['id_categoria'], ENT_QUOTES);
                                    } else
                                    {
                                    echo "No";
                                    }
                                ?>">Categoría:
                                <?php

                                    if ($categoria != null)
                                        {
                                        echo htmlentities($categoria["nombre"], ENT_QUOTES);
                                        } else
                                        {
                                        echo "Ninguna";
                                        }
                                    ?>
                            </small>
                            <p class="texto_desplegable card-text">

                                <?php echo htmlentities($Evento['descripcion'], ENT_QUOTES); ?>

                            </p>
                            <div class="row">
                                <div class="col-12">
                                    <a data-toggle="tooltip" title="Configurar" data-placement="top" href="./evento?id=<?php echo htmlentities($Evento['id_evento'], ENT_QUOTES); ?>&user_id=<?php
                                            echo $User_Data['user_id']; ?>" class="w-100 btn btn-primary"><i
                                            class="m-0 fas fa-cog"></i></a>
                                </div>
                                <div class="col-6">
                                    <a data-toggle="tooltip" title="Editar" data-placement="top"
                                        data-id="<?php echo htmlentities($Evento['id_evento'], ENT_QUOTES); ?>"
                                        data-nombre="<?php echo htmlentities($Evento['nombre'], ENT_QUOTES); ?>"
                                        data-estado="<?php echo htmlentities($estado, ENT_QUOTES); ?>"
                                        data-cancelado="<?php echo $Evento['cancelado']; ?>" type="button"
                                        class="w-100 btn_edit_evento btn btn-success">
                                        <i class="m-0 fas fa-edit"></i></a>
                                </div>
                            </div>
                            <a data-toggle="tooltip" title="<?php
                                if ($Evento['cancelado'] != 1)
                                    {
                                    echo "Cancelar";
                                    } else
                                    {
                                    echo "Activar";
                                    } ?>" data-placement="top"
                                data-id="<?php echo htmlentities($Evento['id_evento'], ENT_QUOTES); ?>" class="p-1 btn btn_cancelar_evento <?php
                                        if ($Evento['cancelado'] != 1)
                                            {
                                            echo "btn-dark";
                                            } else
                                            {
                                            echo "btn-info";
                                            } ?>" type="button"><i class="m-0 <?php
                                             if ($Evento['cancelado'] != 1)
                                                 {
                                                 echo "fa fa-window-close";
                                                 } else
                                                 {
                                                 echo "fas fa-check-square";
                                                 } ?>"></i></a>
                            <a data-toggle="tooltip" title="Eliminar" data-placement="top"
                                data-id="<?php echo htmlentities($Evento['id_evento'], ENT_QUOTES); ?>"
                                class="p-1 btn btn_eliminar_evento btn-danger" type="button"><i
                                    class="m-0 fas fa-trash"></i></a>

                        </div>
                    </div>
                </div>
                <?php
                    }
                ?>
                <div id="loading" class="w-100 h-100 d-flex justify-content-center align-items-center">
                    <img class="img-fluid" src="./assets/images/oval.svg" alt="">

                </div>
                <style>
                #loading {
                    opacity: 0;
                    position: absolute;
                    background: #b3b3b3;
                    border-radius: 5px;
                    top: 0px;
                    transition: all .3s ease;
                    pointer-events: none;
                }

                #loading.visible {
                    opacity: 1;
                    pointer-events: auto;
                }

                #eventos_list {
                    position: relative;
                }
                </style>
            </div>


        </div>

        <!-- /Historial de Acceso -->

        <!-- Eliminaci贸n de cuenta -->



        <!-- /Eliminaci贸n de cuenta -->

    </div>





</div>



<style>
.evento img {
    aspect-ratio: 3/2;
    object-fit: cover;


}

.evento {
    box-shadow: -1px 2px 11px 0px rgba(0, 0, 0, 0.75);
    -webkit-box-shadow: -1px 2px 11px 0px rgba(0, 0, 0, 0.75);
    -moz-box-shadow: -1px 2px 11px 0px rgba(0, 0, 0, 0.75);
    transition: all .3s ease;
}

.evento:hover {
    transform: scale(1.01);
}
</style>



<!-- MODALS -->

<div class="modal fade" id="modalAgregarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar Evento</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">


                    <div class="form-group">
                        <label>Imagen</label>
                        <div id="imagen_evento" class="row">
                            <div style="display: flex;justify-content: center;align-items: center;"
                                class="col-sm-4 mb-4 mb-sm-0">
                                <img class="w-100" src="./assets/images/event.png" alt="">
                            </div>
                            <div class="col-sm-8">

                                <div class="input-group mb-3">

                                    <input type="text" class="valor_personalizacion form-control"
                                        data-nombre="imagen_evento" value="" disabled>

                                    <div class="input-group-append">
                                        <button data-target="imagen_evento" class="btn_modal_imagenes btn btn-success"
                                            type="button">+</button>
                                    </div>
                                </div>


                                <p class="mb-0">El ratio recomendado para la imagen es 3/2</p>

                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">

                                <label>Categoría</label>



                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_categoria file-upload-browse btn btn-danger"
                                            data-target="categoria_evento" type="button">-</button>
                                    </span>
                                    <select id="categoria_evento"
                                        class="select_categorias custom-select select2 form-control">
                                        <option value="No">
                                            Ninguna
                                        </option>
                                        <?php
                                        foreach ($Categorias as $Categoria)
                                            {
                                            ?>
                                        <option value="<?php echo $Categoria['id_categoria']; ?>">
                                            <?php echo $Categoria['nombre']; ?>
                                        </option>
                                        <?php
                                            }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCategoria">+</button>
                                    </span>
                                </div>

                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Nombre</label>
                                <input type="text" class="form-control" id="nombre_evento" placeholder="">
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Fecha inicio</label>
                                <input type="datetime-local" id="fecha_inicio_evento" class="form-control">
                            </div>

                        </div>
                        <div class="col-md-6">

                            <div class="form-group">
                                <label for="my-input">Fecha final</label>
                                <input type="datetime-local" id="fecha_final_evento" class="form-control">
                            </div>


                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Descripción</label>
                                <textarea style="height: 182px!important;" type="text" class="form-control m-0"
                                    id="descripcion_evento" placeholder=""></textarea>
                            </div>
                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_add_evento" type="button">

                    Añadir</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Editar Evento</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">


                    <div class="form-group">
                        <label>Imagen</label>
                        <div id="imagen_evento_editar" class="row">
                            <div style="display: flex;justify-content: center;align-items: center;"
                                class="col-sm-4 mb-4 mb-sm-0">
                                <img class="w-100" src="./assets/images/event.png" alt="">
                            </div>
                            <div class="col-sm-8">

                                <div class="input-group mb-3">

                                    <input type="text" class="valor_personalizacion form-control"
                                        data-nombre="imagen_evento_editar" value="" disabled>

                                    <div class="input-group-append">
                                        <button data-target="imagen_evento_editar"
                                            class="btn_modal_imagenes btn btn-success" type="button">+</button>
                                    </div>
                                </div>


                                <p class="mb-0">El ratio recomendado para la imagen es 3/2</p>

                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">

                                <label>Categoría</label>



                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_categoria file-upload-browse btn btn-danger"
                                            data-target="categoria_evento_editar" type="button">-</button>
                                    </span>
                                    <select id="categoria_evento_editar"
                                        class="select_categorias custom-select select2 form-control">
                                        <option value="No">
                                            Ninguna
                                        </option>
                                        <?php
                                        foreach ($Categorias as $Categoria)
                                            {
                                            ?>
                                        <option value="<?php echo $Categoria['id_categoria']; ?>">
                                            <?php echo $Categoria['nombre']; ?>
                                        </option>
                                        <?php
                                            }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCategoria">+</button>
                                    </span>
                                </div>

                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Nombre</label>
                                <input type="text" class="form-control" id="nombre_evento_editar" placeholder="">
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Fecha inicio</label>
                                <input type="datetime-local" id="fecha_inicio_evento_editar" class="form-control">
                            </div>

                        </div>
                        <div class="col-md-6">

                            <div class="form-group">
                                <label for="my-input">Fecha final</label>
                                <input type="datetime-local" id="fecha_final_evento_editar" class="form-control">
                            </div>


                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Descripción</label>
                                <textarea style="height: 182px!important;" type="text" class="form-control m-0"
                                    id="descripcion_evento_editar" placeholder=""></textarea>
                            </div>
                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_edit_evento" type="button">

                    Editar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal modal-cambiar fade" id="modalEliminarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar evento</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el evento definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>


            <div class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_evento" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal modal-cambiar fade" id="modalCancelarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Cancelar evento</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas cancelar el evento?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>


            <div class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_cancelar_evento" type="button">

                    Confirmar y cancelar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>



<?php require_once __VIEWS__ . 'selects/categorias.template.php'; ?>
<style>
.btn_eliminar_evento {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    right: 0;
    top: 0;
    border-radius: 0px;
}

.btn_cancelar_evento {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    left: 0;
    top: 0;
    border-radius: 0px;
}

.evento:hover .btn_eliminar_evento,
.evento:hover .btn_cancelar_evento {
    opacity: 1;
}
</style>
<script>
(function($) {

    'use strict';

    $(function() {




        function Verificar() {
            var result = true;
            var fechaInicio = moment(document.getElementById('fecha_inicio_evento').value,
                'YYYY-MM-DD HH:mm:ss');
            var fechaFinal = moment(document.getElementById('fecha_final_evento').value,
                'YYYY-MM-DD HH:mm:ss');



            if ($('#imagen_evento input').val() == "") {
                $.toast({
                    heading: 'Por favor selecciona una imágen.',
                    text: 'No se ha seleccionado ninguna imágen para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#nombre_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de nombre.',
                    text: 'No se ha seleccionado ningun nombre para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_inicio_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de inicio.',
                    text: 'No se ha seleccionado ninguna fecha de inicio para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_final_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de final.',
                    text: 'No se ha seleccionado ninguna fecha de final para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if (fechaInicio.isAfter(fechaFinal)) {
                $.toast({
                    heading: 'La fecha final debe ser posterior a la de inicio.',
                    text: 'Fechas incorrectas.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#descripcion_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de descripción.',
                    text: 'No se ha seleccionado ninguna descripción para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }


            return result;
        }

        function VerificarEdit() {
            var result = true;
            var fechaInicio = moment(document.getElementById('fecha_inicio_evento_editar').value,
                'YYYY-MM-DD HH:mm:ss');
            var fechaFinal = moment(document.getElementById('fecha_final_evento_editar').value,
                'YYYY-MM-DD HH:mm:ss');

            if ($('#imagen_evento_editar input').val() == "") {
                $.toast({
                    heading: 'Por favor selecciona una imágen.',
                    text: 'No se ha seleccionado ninguna imágen para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#nombre_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de nombre.',
                    text: 'No se ha seleccionado ningun nombre para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_inicio_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de inicio.',
                    text: 'No se ha seleccionado ninguna fecha de inicio para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_final_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de final.',
                    text: 'No se ha seleccionado ninguna fecha de final para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if (fechaInicio.isAfter(fechaFinal)) {
                $.toast({
                    heading: 'La fecha final debe ser posterior a la de inicio.',
                    text: 'Fechas incorrectas.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#descripcion_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de descripción.',
                    text: 'No se ha seleccionado ninguna descripción para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }


            return result;
        }
        $(document).on("click", ".btn_eliminar_evento", function() {

            $("#btn_eliminar_evento").data("id", $(this).data("id"))

            $("#modalEliminarEvento").modal('show');
        });

        $(document).on("click", ".btn_cancelar_evento", function() {

            $("#btn_cancelar_evento").data("id", $(this).data("id"))

            $("#modalCancelarEvento").modal('show');
        });

        $(document).on('change', '.activo', function() {

            Filtrar()


        })
        $("#search_evento").change(function(e) {
            Filtrar()

        });

        function Filtrar() {
            var filtros = $('.filtro');
            var search = $("#search_evento").val().toLowerCase()
            $('.evento').each(function() {
                var evento = $(this)
                evento.parent().css("display", "block")


                if (!evento.attr("data-nombre").toLowerCase().includes(search)) {
                    evento.parent().css("display", "none")
                }
                filtros.each(function() {
                    var filtro = $(this)
                    var select = filtro.find(".select2").first()

                    if (filtro.find(".activo").val() != "All") {
                        if (select.attr("data-filtro") == "categoria" && evento.find(
                                "small.categoria").first().attr("data-id") != select
                            .val()) {
                            evento.parent().css("display", "none")
                        }
                        if (select.attr("data-filtro") == "estado" && !evento.find(
                                ".btn_edit_evento").first().attr("data-estado")
                            .toLowerCase()
                            .includes(select
                                .val().toLowerCase())) {

                            evento.parent().css("display", "none")
                        }
                    }
                })



            })
        }

        $('#btn_eliminar_evento').click(function(event) {

            var id_evento_eliminar = $("#btn_eliminar_evento").data("id")


            $.ajax({
                type: 'DELETE',
                url: './api/eventos.php?id=' + id_evento_eliminar,
                cache: false,
                async: false,
                success: function(result) {
                    console.log(result);
                    $("#evento_" + id_evento_eliminar).parent().remove()
                    $("#eventos_count").text($('.evento').length)
                    $('#modalEliminarEvento').modal('hide');
                    $.toast({
                        heading: 'Evento eliminado',
                        text: 'Se ha eliminado el evento correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })





                }
            });

            return false;
        });
        $('#btn_cancelar_evento').click(function(event) {

            var id_evento_cancelar = $("#btn_cancelar_evento").data("id")


            $.ajax({
                type: 'POST',
                url: './api/eventos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    id_evento_cancelar: id_evento_cancelar
                },
                success: function(result) {
                    console.log(result);
                    var e
                    if (result["cancelado"] != 1) {
                        e = "activado"
                        $("#evento_" + id_evento_cancelar).find(".btn_edit_evento")
                            .attr("data-cancelado", "0")
                        if (result["estado"] == "Activo") {
                            $("#evento_" + id_evento_cancelar).find("small.estado span")
                                .text("Activo ")
                            $("#evento_" + id_evento_cancelar).find("small.estado i")
                                .removeClass();
                            $("#evento_" + id_evento_cancelar).find("small.estado i")
                                .addClass('text-success fas fa-check-circle')
                            $("#evento_" + id_evento_cancelar).find(".btn_edit_evento")
                                .attr("data-estado", "Activo")
                        }
                        if (result["estado"] == "Finalizado") {
                            $("#evento_" + id_evento_cancelar).find("small.estado span")
                                .text("Finalizado ")
                            $("#evento_" + id_evento_cancelar).find("small.estado i")
                                .removeClass();
                            $("#evento_" + id_evento_cancelar).find("small.estado i")
                                .addClass('text-danger fas fa-times-circle')
                            $("#evento_" + id_evento_cancelar).find(".btn_edit_evento")
                                .attr("data-estado", "Finalizado")
                        }
                        if (result["estado"] == "Pendiente") {
                            $("#evento_" + id_evento_cancelar).find("small.estado span")
                                .text("Pendiente ")
                            $("#evento_" + id_evento_cancelar).find("small.estado i")
                                .removeClass();
                            $("#evento_" + id_evento_cancelar).find("small.estado i")
                                .addClass('text-warning fas fa-clock estado')
                            $("#evento_" + id_evento_cancelar).find(".btn_edit_evento")
                                .attr("data-estado", "Pendiente")
                        }
                    } else {

                        e = "cancelado"
                        $("#evento_" + id_evento_cancelar).find("small.estado span")
                            .text("Cancelado ")
                        $("#evento_" + id_evento_cancelar).find("small.estado i")
                            .removeClass();
                        $("#evento_" + id_evento_cancelar).find("small.estado i")
                            .addClass('text-danger fas fa-ban')
                        $("#evento_" + id_evento_cancelar).find(".btn_edit_evento")
                            .attr("data-estado", "Cancelado")
                        $("#evento_" + id_evento_cancelar).find(".btn_edit_evento")
                            .attr("data-cancelado", "1")
                    }
                    $('#modalCancelarEvento').modal('hide');
                    $.toast({
                        heading: 'Evento ' + e,
                        text: 'Se ha ' + e + ' el evento correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })





                }
            });

            return false;
        });
        $('#fechas_check').change(function(event) {
            if ($(this).prop("checked")) {
                $('#filtro_fechas').attr("disabled", false)
            } else {
                $('#filtro_fechas').attr("disabled", true)
            }

        })

        function crearElementoEvento(imgevento, nombreevento, descripcionevento, idevento,
            categoria,
            fecha_inicio, fecha_final, cancelado) {
            // Crear el elemento div principal
            var fechaActual = moment();
            var fechaInicio = moment(fecha_inicio, 'YYYY-MM-DD HH:mm:ss');
            var fechaFin = moment(fecha_final, 'YYYY-MM-DD HH:mm:ss');
            var smallElement = document.createElement('small');
            smallElement.className = "estado";

            var iconoElement = document.createElement('i');
            var checkin;
            var actimel;
            if (fechaActual.isSameOrBefore(fechaFin) && fechaActual.isSameOrAfter(
                    fechaInicio)) {
                actimel = "Activo "
                checkin = 'text-success fas fa-check-circle estado'
            } else {
                if (fechaActual.isSameOrBefore(fechaInicio)) {
                    actimel = "Pendiente "
                    checkin = 'text-warning fas fa-clock estado'
                } else {
                    actimel = "Finalizado "
                    checkin = 'text-danger fas fa-times-circle estado'
                }
            }
            actimel = (cancelado != 1) ? actimel : "Cancelado "
            checkin = (cancelado != 1) ? checkin : "text-danger fas fa-ban"
            iconoElement.className = checkin;


            var spanActive = document.createElement('span');
            spanActive.textContent = actimel;

            smallElement.appendChild(spanActive);
            smallElement.appendChild(iconoElement);
            var smallFechas = document.createElement('small');

            smallFechas.innerHTML =
                'Inicio: 2023-07-03 20:46:00 <br>Final: 2023-07-05 20:46:00';

            // Crear el elemento <br>
            var brElement = document.createElement('br');




            // Agregar los elementos al elemento <p>
            var pElement = document.createElement('p');
            pElement.className = 'mb-1 fechas';
            pElement.appendChild(smallFechas);



            var divCol = document.createElement('div');
            divCol.classList.add('col-lg-3', 'mb-3');

            var divEvento = document.createElement('div');
            divEvento.classList.add('card', 'evento');
            divEvento.id = "evento_" + idevento;
            divEvento.setAttribute('data-nombre', nombreevento)
            // Crear la imagen del evento
            var imgEvento = document.createElement('img');
            imgEvento.classList.add('card-img-top', 'img-responsive');
            imgEvento.src = imgevento;
            imgEvento.alt = 'Card image cap';
            divEvento.appendChild(imgEvento);

            // Crear el div para el contenido del evento
            var divCardBody = document.createElement('div');
            divCardBody.classList.add('card-body', 'p-3');
            divEvento.setAttribute('data-nombre', nombreevento)
            divEvento.appendChild(divCardBody);


            // Crear el título del evento
            var h4Titulo = document.createElement('h4');
            h4Titulo.classList.add('card-title', 'texto_desplegable', 'd-flex', 'flex-column',
                'align-items-start');

            var spanNombre = document.createElement('span');
            spanNombre.textContent = nombreevento;
            spanNombre.classList.add('mb-1');
            h4Titulo.appendChild(spanNombre);
            h4Titulo.appendChild(smallElement);
            divCardBody.appendChild(h4Titulo);
            divCardBody.appendChild(pElement);
            // Crear la etiqueta small para la categoría
            var smallCategoria = document.createElement('small');
            smallCategoria.textContent = 'Categoría: ' + categoria.nombre;
            smallCategoria.setAttribute('data-id', categoria.id);
            smallCategoria.className = 'categoria';
            divCardBody.appendChild(smallCategoria);

            // Crear el párrafo de la descripción del evento
            var pDescripcion = document.createElement('p');
            pDescripcion.classList.add('texto_desplegable', 'card-text');
            pDescripcion.textContent = descripcionevento;
            divCardBody.appendChild(pDescripcion);

            // Crear la fila para los botones
            var divBotonesRow = document.createElement('div');
            divBotonesRow.classList.add('row');
            divCardBody.appendChild(divBotonesRow);

            // Crear el botón de edición
            var divBotonCol1 = document.createElement('div');
            divBotonCol1.classList.add('col-6');
            divBotonesRow.appendChild(divBotonCol1);

            var aEditarEvento = document.createElement('a');
            aEditarEvento.href = './evento?id=' + idevento + '&user_id=<?php
                echo $User_Data['user_id']; ?> ';
            aEditarEvento.classList.add('w-100', 'btn', 'btn-primary');
            aEditarEvento.setAttribute('data-toggle', 'tooltip');
            aEditarEvento.setAttribute('title', "Configurar");
            aEditarEvento.setAttribute('data-placement', 'top');

            divBotonCol1.appendChild(aEditarEvento);

            var iEditarEvento = document.createElement('i');
            iEditarEvento.classList.add('m-0', 'fas', 'fa-cog');
            aEditarEvento.appendChild(iEditarEvento);

            // Crear el botón de edición
            var divBotonCol2 = document.createElement('div');
            divBotonCol2.classList.add('col-6');
            divBotonesRow.appendChild(divBotonCol2);

            var aEditarEventoBtn = document.createElement('a');
            aEditarEventoBtn.setAttribute('data-id', idevento);
            aEditarEventoBtn.setAttribute('data-nombre', nombreevento);
            aEditarEventoBtn.setAttribute('data-cancelado', cancelado)
            aEditarEventoBtn.setAttribute('data-estado', actimel)
            aEditarEventoBtn.setAttribute('type', 'button');
            aEditarEventoBtn.classList.add('w-100', 'btn_edit_evento', 'btn', 'btn-success');
            divBotonCol2.appendChild(aEditarEventoBtn);

            var iEditarEventoBtn = document.createElement('i');
            iEditarEventoBtn.classList.add('m-0', 'fas', 'fa-edit');
            aEditarEventoBtn.appendChild(iEditarEventoBtn);
            aEditarEventoBtn.setAttribute('data-toggle', 'tooltip');
            aEditarEventoBtn.setAttribute('title', "Editar");
            aEditarEventoBtn.setAttribute('data-placement', 'top');
            divCol.appendChild(divEvento);

            var aCancelarEventoBtn = document.createElement('a');
            aCancelarEventoBtn.setAttribute('data-id', idevento);

            aCancelarEventoBtn.setAttribute('type', 'button');

            var textoCancelar = (cancelado != 1) ? "Cancelar" : "Activar"
            var btnclaseCancelar = (cancelado != 1) ? "btn-dark" : "btn-info"
            var iClaseCancelar = (cancelado != 1) ? "fa fa-window-close" : "fas fa-check-square"



            aCancelarEventoBtn.classList.add('p-1', 'btn_cancelar_evento', 'btn', btnclaseCancelar);
            var iCancelarEventoBtn = document.createElement('i');
            iCancelarEventoBtn.className = 'm-0 ' + iClaseCancelar;
            aCancelarEventoBtn.appendChild(iCancelarEventoBtn);

            aCancelarEventoBtn.setAttribute('data-toggle', 'tooltip');
            aCancelarEventoBtn.setAttribute('title', textoCancelar);
            aCancelarEventoBtn.setAttribute('data-placement', 'top');
            divEvento.appendChild(aCancelarEventoBtn);

            var aEliminarEventoBtn = document.createElement('a');
            aEliminarEventoBtn.setAttribute('data-id', idevento);

            aEliminarEventoBtn.setAttribute('type', 'button');
            aEliminarEventoBtn.classList.add('p-1', 'btn_eliminar_evento', 'btn', 'btn-danger');
            var iEliminarEventoBtn = document.createElement('i');
            iEliminarEventoBtn.classList.add('m-0', 'fas', 'fa-trash');
            aEliminarEventoBtn.appendChild(iEliminarEventoBtn);
            aEliminarEventoBtn.setAttribute('data-toggle', 'tooltip');
            aEliminarEventoBtn.setAttribute('title', "Eliminar");
            aEliminarEventoBtn.setAttribute('data-placement', 'top');
            divEvento.appendChild(aEliminarEventoBtn);


            var list = document.getElementById("eventos_list")
            list.insertBefore(divCol, list.firstChild);
            $('.btn[data-toggle="tooltip"]').tooltip()
        }


        $(document).on("click", ".btn_edit_evento", function() {
            var id_evento = $(this).data("id")
            var nombre_viejo = $(this).data("nombre")
            var cancelado = $(this).data("cancelado")
            console.log(id_evento);
            $.ajax({
                type: 'GET',
                url: './api/eventos.php?id_evento=' + id_evento,
                cache: false,
                async: false,
                dataType: "json",
                success: function(r) {

                    console.log(r);
                    $("#btn_edit_evento").data("id", id_evento);
                    $("#btn_edit_evento").data("nombre", nombre_viejo);
                    $("#btn_edit_evento").data("cancelado", cancelado);
                    $('#imagen_evento_editar img').attr("src", r.imagen);
                    $('#imagen_evento_editar input').val(r.imagen);
                    var cat = (r.id_categoria != null) ? r.id_categoria :
                        "No"

                    $('#categoria_evento_editar').val(cat).trigger("change")
                    $('#nombre_evento_editar').val(r.nombre)
                    $('#fecha_inicio_evento_editar').val(r.fecha_inicio)
                    $('#fecha_final_evento_editar').val(r.fecha_final)
                    $('#descripcion_evento_editar').html(r.descripcion)

                    $("#modalEditarEvento").modal("show")


                }
            });
        });
        $("#btn_edit_evento").click(function(e) {
            $("#btn_edit_evento").addClass('btn-loading');
            var imagen = $("#imagen_evento_editar input").val()
            var nombre_viejo = $(this).data("nombre")
            var cancelado = $(this).data("cancelado")
            var nombre = $("#nombre_evento_editar").val()
            var fecha_inicio = moment(document.getElementById(
                    'fecha_inicio_evento_editar').value)
                .format(
                    "YYYY-MM-DD HH:mm:ss");
            var fecha_final = moment(document.getElementById(
                    'fecha_final_evento_editar').value)
                .format(
                    "YYYY-MM-DD HH:mm:ss");
            var fechaActual = moment();
            var fechaInicio = moment(document.getElementById(
                    'fecha_inicio_evento_editar').value,
                'YYYY-MM-DD HH:mm:ss');
            var fechaFin = moment(document.getElementById('fecha_final_evento_editar')
                .value,
                'YYYY-MM-DD HH:mm:ss');
            var actimel;
            var checkin;
            if (fechaActual.isSameOrBefore(fechaFin) && fechaActual.isSameOrAfter(
                    fechaInicio)) {
                actimel = "Activo"
                checkin = 'text-success fas fa-check-circle estado'
            } else {
                if (fechaActual.isSameOrBefore(fechaInicio)) {
                    actimel = "Pendiente"
                    checkin = 'text-warning fas fa-clock estado'
                } else {
                    actimel = "Finalizado"
                    checkin = 'text-danger fas fa-times-circle estado'
                }
            }
            actimel = (cancelado != 1) ? actimel : "Cancelado"
            checkin = (cancelado != 1) ? checkin : "text-danger fas fa-ban"


            var descripcion = $("#descripcion_evento_editar").val()
            var id_categoria = ($("#categoria_evento_editar").val() != "No") ? $(
                    "#categoria_evento_editar")
                .val() : ""
            var id_evento = $(this).data("id")
            if (!VerificarEdit()) {
                $("#btn_edit_evento").removeClass('btn-loading');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: './api/eventos.php',
                data: {
                    imagen: imagen,
                    nombre: nombre,
                    fecha_inicio: fecha_inicio,
                    fecha_final: fecha_final,
                    descripcion: descripcion,
                    id_categoria: id_categoria,
                    id_evento: id_evento,
                    nombre_viejo: nombre_viejo

                },
                cache: false,
                async: false,
                dataType: "json",
                success: function(r) {
                    console.log(r);
                    if (r != 0) {
                        $("#evento_" + r.id).attr("data-nombre", r.nombre);
                        $("#evento_" + r.id + " img").attr("src", r.imagen);
                        $("#evento_" + r.id + " h4 span").text(r.nombre)
                        $("#evento_" + r.id + " h4 small.estado span").text(
                            actimel +
                            " ")
                        $("#evento_" + r.id + " h4 small.estado i")
                            .removeClass();
                        $("#evento_" + r.id + " h4 small.estado i")
                            .addClass(checkin);
                        var fechitas = "Inicio: " + r.fecha_inicio +
                            "<br>" +
                            "Final: " +
                            r.fecha_final
                        $("#evento_" + r.id + " p.fechas small").html(
                            fechitas)
                        $("#evento_" + r.id + " small.categoria").text(
                            "Categoría: " + r
                            .categoria)
                        $("#evento_" + r.id + " small.categoria").data("id",
                            r
                            .id_categoria)
                        $("#evento_" + r.id + " p.texto_desplegable").text(r
                            .descripcion)
                        console.log(actimel);
                        $("#evento_" + r.id + " .btn_edit_evento").data(
                            "estado",
                            actimel)
                        $("#evento_" + r.id + " .btn_edit_evento").data(
                            "nombre",
                            r.nombre)
                        $("#evento_" + r.id + " .btn_edit_evento").data(
                            "cancelado",
                            cancelado)
                        $.toast({
                            heading: 'Evento editado',
                            text: 'Se ha editado el evento correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $("#btn_edit_evento").removeClass("btn-loading")
                        $('#modalEditarEvento').modal("hide");
                    } else {
                        $.toast({
                            heading: 'Nombre repetido.',
                            text: 'El nombre del evento ya existe.',
                            position: 'top-right',
                            loaderBg: '#f1635f',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $("#btn_edit_evento").removeClass("btn-loading")
                    }

                }
            })
        })


        $("#btn_add_evento").click(function(e) {
            $("#btn_add_evento").addClass('btn-loading');
            var imagen = $("#imagen_evento input").val()
            var nombre = $("#nombre_evento").val()

            var fecha_inicio = moment(document.getElementById('fecha_inicio_evento')
                .value).format(
                "YYYY-MM-DD HH:mm:ss");
            var fecha_final = moment(document.getElementById('fecha_final_evento')
                .value).format(
                "YYYY-MM-DD HH:mm:ss");

            var descripcion = $("#descripcion_evento").val()
            var id_categoria = ($("#categoria_evento").val() != "No") ? $(
                    "#categoria_evento")
                .val() : ""
            if (!Verificar()) {
                $("#btn_add_evento").removeClass('btn-loading');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: './api/eventos.php',
                data: {
                    imagen: imagen,
                    nombre: nombre,
                    fecha_inicio: fecha_inicio,
                    fecha_final: fecha_final,
                    descripcion: descripcion,
                    id_categoria: id_categoria


                },
                dataType: "json",
                cache: false,
                async: false,
                success: function(r) {
                    console.log(r);
                    if (r != 0) {
                        var categoria = {
                            id: (r.id_categoria != null) ? r
                                .id_categoria : "No",
                            nombre: r.categoria
                        }
                        crearElementoEvento(r.imagen, r.nombre, r
                            .descripcion, r.id,
                            categoria, r.fecha_inicio, r.fecha_final, r
                            .cancelado)
                        $("#eventos_count").text($('.evento').length)
                        $.toast({
                            heading: 'Evento agregado',
                            text: 'Se ha agregado el evento correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })
                        $('#modalAgregarEvento').modal("hide");
                    } else {
                        $.toast({
                            heading: 'Nombre repetido.',
                            text: 'El nombre del evento ya existe.',
                            position: 'top-right',
                            loaderBg: '#f1635f',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });

                    }
                    $("#btn_add_evento").removeClass("btn-loading")




                }
            })

        });






    });

})(jQuery);
</script>