<style>
.custom-switch .custom-control-label::before {
    left: -1rem;
    width: 1.75rem;
    pointer-events: all;
    border-radius: 0.5rem;
}

.custom-switch .custom-control-input:checked~.custom-control-label::after {
    background-color: #fff;
    -webkit-transform: translateX(0.75rem);
    transform: translateX(0.75rem);
}

.custom-switch .custom-control-label::after {
    top: 12px !important;
    left: calc(-1rem + 2px);
    width: calc(1rem - 4px);
    height: calc(1rem - 4px);
    background-color: #adb5bd;
    border-radius: 0.5rem;
    transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out, -webkit-transform .15s ease-in-out;
    transition: transform .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
    transition: transform .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out, -webkit-transform .15s ease-in-out;
}

.custom-control-label::before,
.custom-control-label::after {
    top: 0px !important;
}

p.fechas small {
    color: #212529;
}

#eventos_list {
    max-height: 80vh;
    overflow-y: auto;
}

#eventos_list::-webkit-scrollbar {
    width: 8px;
}

#eventos_list::-webkit-scrollbar-track {
    background: #f1f1f1;
}

#eventos_list::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 10px;
}

#eventos_list::-webkit-scrollbar-thumb:hover {

    background: #555;
}
</style>
<div class="content-wrapper">



    <div class="row profile-page ">



        <div class="col-md-12 mb-8 p-0">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/wrhxfrid.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">EVENTOS</p>

                        <span id="eventos_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>










    <div class="row card p-4">

        <!-- Historial de Acceso -->



        <div class="col-md-12 p-0">

            <div class="row">
                <div class="col-md-6 mb-4">

                    <button data-toggle="modal" data-target="#modalAgregarEvento" class="btn btn-primary">Agregar
                        evento</button>

                </div>




            </div>



            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <table style="min-height:120px;" id="tabla_eventos" cellspacing="0" class="tabla_eventos table">

                            <thead>

                                <tr class="text-center">
                                    <th>
                                        ID</th>

                                    <th>Nombre</th>
                                    <th>Fecha de inicio</th>
                                    <th>Fecha de finalización</th>
                                    <th>Categoría</th>
                                    <th>Estado</th>

                                    <th>Miembros</th>


                                    <th style="text-align:center;">Acciones</th>


                                </tr>
                                <tr class="filters">
                                    <th>
                                        ID</th>

                                    <th>Nombre</th>
                                    <th>Fecha de inicio</th>
                                    <th>Fecha de finalización</th>
                                    <th>Categoría</th>
                                    <th>Estado</th>

                                    <th>Miembros</th>


                                    <th style="text-align:center;">Acciones</th>


                                </tr>
                            </thead>

                            <tbody>



                            </tbody>

                        </table>
                    </div>
                </div>
            </div>

        </div>

        <!-- /Historial de Acceso -->

        <!-- Eliminaci贸n de cuenta -->



        <!-- /Eliminaci贸n de cuenta -->

    </div>





</div>



<style>
.evento img {
    aspect-ratio: 3/2;
    object-fit: cover;


}

.evento {
    box-shadow: -1px 2px 11px 0px rgba(0, 0, 0, 0.75);
    -webkit-box-shadow: -1px 2px 11px 0px rgba(0, 0, 0, 0.75);
    -moz-box-shadow: -1px 2px 11px 0px rgba(0, 0, 0, 0.75);
    transition: all .3s ease;
}

.evento:hover {
    transform: scale(1.01);
}
</style>



<!-- MODALS -->

<div class="modal fade" id="modalAgregarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar Evento</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">




                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">

                                <label>Categoría</label>



                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_categoria file-upload-browse btn btn-danger"
                                            data-target="categoria_evento" type="button">-</button>
                                    </span>
                                    <select id="categoria_evento"
                                        class="select_categorias custom-select select2 form-control">
                                        <option value="No">
                                            Ninguna
                                        </option>
                                        <?php
                                        foreach ($Categorias as $Categoria) {
                                        ?>
                                        <option value="<?php echo $Categoria['id_categoria']; ?>">
                                            <?php echo $Categoria['nombre']; ?>
                                        </option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCategoria">+</button>
                                    </span>
                                </div>

                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Nombre</label>
                                <input type="text" class="form-control" id="nombre_evento" placeholder="">
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Fecha inicio</label>
                                <input type="datetime-local" id="fecha_inicio_evento" class="form-control">
                            </div>

                        </div>
                        <div class="col-md-6">

                            <div class="form-group">
                                <label for="my-input">Fecha final</label>
                                <input type="datetime-local" id="fecha_final_evento" class="form-control">
                            </div>


                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Descripción</label>
                                <textarea style="height: 182px!important;" type="text" class="form-control m-0"
                                    id="descripcion_evento" placeholder=""></textarea>
                            </div>
                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_add_evento" type="button">

                    Añadir</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Editar Evento</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">



                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">

                                <label>Categoría</label>



                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_categoria file-upload-browse btn btn-danger"
                                            data-target="categoria_evento_editar" type="button">-</button>
                                    </span>
                                    <select id="categoria_evento_editar"
                                        class="select_categorias custom-select select2 form-control">
                                        <option value="No">
                                            Ninguna
                                        </option>
                                        <?php
                                        foreach ($Categorias as $Categoria) {
                                        ?>
                                        <option value="<?php echo $Categoria['id_categoria']; ?>">
                                            <?php echo $Categoria['nombre']; ?>
                                        </option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCategoria">+</button>
                                    </span>
                                </div>

                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Nombre</label>
                                <input type="text" class="form-control" id="nombre_evento_editar" placeholder="">
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Fecha inicio</label>
                                <input type="datetime-local" id="fecha_inicio_evento_editar" class="form-control">
                            </div>

                        </div>
                        <div class="col-md-6">

                            <div class="form-group">
                                <label for="my-input">Fecha final</label>
                                <input type="datetime-local" id="fecha_final_evento_editar" class="form-control">
                            </div>


                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Descripción</label>
                                <textarea style="height: 182px!important;" type="text" class="form-control m-0"
                                    id="descripcion_evento_editar" placeholder=""></textarea>
                            </div>
                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_edit_evento" type="button">

                    Editar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal modal-cambiar fade" id="modalEliminarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar evento</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el evento definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>


            <div class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_evento" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal modal-cambiar fade" id="modalCancelarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 id="titulo_cancelar" class="mb-0"></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p id="texto_cancelar" class=""></p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>


            <div class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_cancelar_evento" type="button"></button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalSubirArchivo" role="dialog">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Archivos</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-4">
                <div class="row">
                    <div class="col-12 col-md-6">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>

                            <input id="nombre_archivo" type="text" class="form-control">

                        </div>

                    </div>
                    <div class="col-12 col-md-6">
                        <div class="form-group">
                            <label for="my-input">Archivo</label>
                            <div class="input-group">
                                <input type="file" class="d-none" id="archivo_file" accept=".png, .jpg, .pdf, .docx">
                                <input disabled id="archivo_archivo" type="text" class="form-control"
                                    value="Ningún archivo seleccionado.">
                                <div class="input-group-append">
                                    <label for="archivo_file" class="mb-0 btn btn-success btn-fw" id="btn_subir_archivo"
                                        type="button">

                                        Seleccionar archivo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 text-left mb-2">
                        <button class="btn btn-success btn-fw" id="btn_add_archivo" type="button"">Subir</button>
                    </div>
                </div>

                <div class=" container-lg p-0">
                            <div id="lista_archivos" class="row">

                            </div>





                    </div>



                </div>





                <!-- /modal-body -->

            </div>

        </div>

    </div>
</div>
<div class="modal fade modal-cambiar" id="modalVerArchivo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div id="contenedor_archivo" class="modal-body pb-4">
                <!-- btn -->






            </div>

            <!-- /btn -->


            <!-- /modal-body -->
        </div>
    </div>
</div>

<style>
#iframe_contrato {
    width: 100%;
    height: 100%;
    border: none;
}

#lord_contrato {
    width: 300px;
    height: 300px;

}

#iframe_horario {
    width: 100%;
    height: 100%;
    border: none;
}

#lord_horario {
    width: 300px;
    height: 300px;

}
</style>
<?php require_once __VIEWS__ . 'selects/categorias.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/eventos.template.php'; ?>
<style>
.btn_eliminar_evento {
    cursor: pointer;

}
</style>
<style>
.archivo_lista {
    cursor: pointer;
    transition: all .3s ease;
    position: relative;
    height: 100%;
    width: 100%;
    background: #0000001a;
    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    aspect-ratio: 1/1;
    border-radius: 2% !important;
}

.archivo_lista img {
    object-fit: cover;
    max-height: 200px;
}

.archivo_lista:hover {
    opacity: .5;
    background: #000000;
}

.btn_eliminar_archivo {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    right: 0;
    top: 0;
    border-radius: 10% !important;
}

.archivo_lista:hover .btn_eliminar_archivo {
    opacity: 1;
}

.btn_eliminar_archivo i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #F1635F;
}

.btn_eliminar_archivo:hover i:before {
    color: #F1635F;
}

.btn_seleccionar_archivo {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    left: 0;
    top: 0;
    border-radius: 10% !important;
}

.archivo_lista:hover .btn_seleccionar_archivo {
    opacity: 1;
}

.btn_seleccionar_archivo i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #0cca8e;
}

.btn_seleccionar_archivo:hover i:before {
    color: #0cca8e;
}

.nombre_archivo_div {
    position: absolute;
    font-size: 18px;
    border-radius: 4px;
    transition: all .3s ease;
    opacity: 0;
    color: white;
    background-color: black;
    padding: .5rem;
    cursor: pointer;
}

.col-sm-3:hover .nombre_archivo_div {
    opacity: 1;
}

#lista_archivos {
    max-height: 723px;
    overflow-y: scroll;
}
</style>
<script>
(function($) {

    'use strict';

    $(function() {




        function Verificar() {
            var result = true;
            var fechaInicio = moment(document.getElementById('fecha_inicio_evento').value,
                'YYYY-MM-DD HH:mm:ss');
            var fechaFinal = moment(document.getElementById('fecha_final_evento').value,
                'YYYY-MM-DD HH:mm:ss');




            if ($('#nombre_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de nombre.',
                    text: 'No se ha seleccionado ningun nombre para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_inicio_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de inicio.',
                    text: 'No se ha seleccionado ninguna fecha de inicio para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_final_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de final.',
                    text: 'No se ha seleccionado ninguna fecha de final para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if (fechaInicio.isAfter(fechaFinal)) {
                $.toast({
                    heading: 'La fecha final debe ser posterior a la de inicio.',
                    text: 'Fechas incorrectas.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#descripcion_evento').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de descripción.',
                    text: 'No se ha seleccionado ninguna descripción para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }


            return result;
        }

        function VerificarEdit() {
            var result = true;
            var fechaInicio = moment(document.getElementById('fecha_inicio_evento_editar').value,
                'YYYY-MM-DD HH:mm:ss');
            var fechaFinal = moment(document.getElementById('fecha_final_evento_editar').value,
                'YYYY-MM-DD HH:mm:ss');


            if ($('#nombre_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de nombre.',
                    text: 'No se ha seleccionado ningun nombre para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_inicio_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de inicio.',
                    text: 'No se ha seleccionado ninguna fecha de inicio para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#fecha_final_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de fecha de final.',
                    text: 'No se ha seleccionado ninguna fecha de final para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if (fechaInicio.isAfter(fechaFinal)) {
                $.toast({
                    heading: 'La fecha final debe ser posterior a la de inicio.',
                    text: 'Fechas incorrectas.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }
            if ($('#descripcion_evento_editar').val() == "") {
                $.toast({
                    heading: 'Por favor rellena el campo de descripción.',
                    text: 'No se ha seleccionado ninguna descripción para el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                result = false;
            }


            return result;
        }
        $(document).on("click", ".btn_eliminar_evento", function() {

            $("#btn_eliminar_evento").data("id", $(this).data("id"))

            $("#modalEliminarEvento").modal('show');
        });

        $(document).on("click", ".btn_cancelar_evento", function() {

            $("#btn_cancelar_evento").data("id", $(this).data("id"))



            $("#modalCancelarEvento").modal('show');
        });





        $('#btn_eliminar_evento').click(function(event) {

            var id_evento_eliminar = $("#btn_eliminar_evento").data("id")


            $.ajax({
                type: 'DELETE',
                url: './api/eventos.php?id=' + id_evento_eliminar,
                cache: false,
                async: false,
                success: function(result) {
                    console.log(result);


                    $('#modalEliminarEvento').modal('hide');
                    $('.tabla_eventos').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Evento eliminado',
                        text: 'Se ha eliminado el evento correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })





                }
            });

            return false;
        });
        $('#btn_cancelar_evento').click(function(event) {

            var id_evento_cancelar = $(this).data("id")


            $.ajax({
                type: 'POST',
                url: './api/eventos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    id_evento_cancelar: id_evento_cancelar
                },
                success: function(result) {
                    console.log(result);


                    $('#modalCancelarEvento').modal('hide');
                    $('.tabla_eventos').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Evento cancelado',
                        text: 'Se ha cancelado el evento correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })





                }
            });

            return false;
        });




        $(document).on("click", ".btn_edit_evento", function() {
            var id_evento = $(this).data("id")
            var nombre_viejo = $(this).data("nombre")
            var cancelado = $(this).data("cancelado")
            console.log(id_evento);
            $.ajax({
                type: 'GET',
                url: './api/eventos.php?id_evento=' + id_evento,
                cache: false,
                async: false,
                dataType: "json",
                success: function(r) {

                    console.log(r);
                    $("#btn_edit_evento").data("id", id_evento);
                    $("#btn_edit_evento").data("nombre", nombre_viejo);
                    $("#btn_edit_evento").data("cancelado", cancelado);


                    var cat = (r.id_categoria != null) ? r.id_categoria :
                        "No"

                    $('#categoria_evento_editar').val(cat).trigger("change")
                    $('#nombre_evento_editar').val(r.nombre)
                    $('#fecha_inicio_evento_editar').val(r.fecha_inicio)
                    $('#fecha_final_evento_editar').val(r.fecha_final)
                    $('#descripcion_evento_editar').html(r.descripcion)

                    $("#modalEditarEvento").modal("show")


                }
            });
        });
        $("#btn_edit_evento").click(function(e) {
            $("#btn_edit_evento").addClass('btn-loading');

            var nombre_viejo = $(this).data("nombre")
            var cancelado = $(this).data("cancelado")
            var nombre = $("#nombre_evento_editar").val()
            var fecha_inicio = moment(document.getElementById(
                    'fecha_inicio_evento_editar').value)
                .format(
                    "YYYY-MM-DD HH:mm:ss");
            var fecha_final = moment(document.getElementById(
                    'fecha_final_evento_editar').value)
                .format(
                    "YYYY-MM-DD HH:mm:ss");

            var fechaInicio = moment(document.getElementById(
                    'fecha_inicio_evento_editar').value,
                'YYYY-MM-DD HH:mm:ss');
            var fechaFin = moment(document.getElementById('fecha_final_evento_editar')
                .value,
                'YYYY-MM-DD HH:mm:ss');



            var descripcion = $("#descripcion_evento_editar").val()
            var id_categoria = ($("#categoria_evento_editar").val() != "No") ? $(
                    "#categoria_evento_editar")
                .val() : ""
            var id_evento = $(this).data("id")
            if (!VerificarEdit()) {
                $("#btn_edit_evento").removeClass('btn-loading');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: './api/eventos.php',
                data: {

                    nombre: nombre,
                    fecha_inicio: fecha_inicio,
                    fecha_final: fecha_final,
                    descripcion: descripcion,
                    id_categoria: id_categoria,
                    id_evento: id_evento,
                    nombre_viejo: nombre_viejo

                },
                cache: false,
                async: false,
                dataType: "json",
                success: function(r) {
                    console.log(r);
                    if (r != 0) {
                        $('.tabla_eventos').DataTable().ajax.reload(null, false);
                        $.toast({
                            heading: 'Evento editado',
                            text: 'Se ha editado el evento correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $("#btn_edit_evento").removeClass("btn-loading")
                        $('#modalEditarEvento').modal("hide");
                    } else {
                        $.toast({
                            heading: 'Nombre repetido.',
                            text: 'El nombre del evento ya existe.',
                            position: 'top-right',
                            loaderBg: '#f1635f',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $("#btn_edit_evento").removeClass("btn-loading")
                    }

                }
            })
        })


        $("#btn_add_evento").click(function(e) {
            $("#btn_add_evento").addClass('btn-loading');

            var nombre = $("#nombre_evento").val()

            var fecha_inicio = moment(document.getElementById('fecha_inicio_evento')
                .value).format(
                "YYYY-MM-DD HH:mm:ss");
            var fecha_final = moment(document.getElementById('fecha_final_evento')
                .value).format(
                "YYYY-MM-DD HH:mm:ss");

            var descripcion = $("#descripcion_evento").val()
            var id_categoria = ($("#categoria_evento").val() != "No") ? $(
                    "#categoria_evento")
                .val() : ""
            if (!Verificar()) {
                $("#btn_add_evento").removeClass('btn-loading');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: './api/eventos.php',
                data: {

                    nombre: nombre,
                    fecha_inicio: fecha_inicio,
                    fecha_final: fecha_final,
                    descripcion: descripcion,
                    id_categoria: id_categoria


                },
                dataType: "json",
                cache: false,
                async: false,
                success: function(r) {
                    console.log(r);
                    if (r != 0) {
                        $('.tabla_eventos').DataTable().ajax.reload(null, false);
                        $.toast({
                            heading: 'Evento agregado',
                            text: 'Se ha agregado el evento correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })
                        $('#modalAgregarEvento').modal("hide");
                    } else {
                        $.toast({
                            heading: 'Nombre repetido.',
                            text: 'El nombre del evento ya existe.',
                            position: 'top-right',
                            loaderBg: '#f1635f',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });

                    }
                    $("#btn_add_evento").removeClass("btn-loading")




                }
            })

        });






    });

})(jQuery);
</script>
<script>
(function($) {
    'use strict';
    $(function() {


        $("#tabla_eventos thead .filters th").each(function() {
            var title = $("#tabla_eventos thead tr:eq(0) th").eq($(this).index()).text();
            $("#tabla_eventos thead tr:eq(0) th").eq($(this).index()).addClass("text-center")

            var currentTh = $(this); // Guardar una referencia al elemento actual

            if (title.trim().toLowerCase() === "miembros") {
                $(this).html('');
                $.ajax({
                    type: 'GET',
                    url: './api/user_evento.php',
                    cache: false,
                    async: false,
                    dataType: "json",
                    success: function(r) {
                        console.log(r);
                        var select = $('<select>', {
                            id: 'mySelect',
                            multiple: 'multiple',
                            class: 'selectpicker'
                        });

                        $.each(r, function(index, obj) {
                            $('<option>', {
                                value: obj.user_id,
                                text: obj.user_full_name
                            }).appendTo(select);
                        });

                        select.appendTo(
                            currentTh); // Usar la referencia al elemento actual
                        $('#mySelect').data("style", "form-control")
                        $('#mySelect').selectpicker({
                            noneSelectedText: 'Ningún miembro seleccionado.'
                        });
                        $('.bootstrap-select button').removeClass('btn');
                        select.on("change", function() {
                            var selectedValues = $(this).val() || [];
                            console.log(selectedValues);

                            if (selectedValues.length > 0) {
                                $('#tabla_eventos').DataTable().rows().every(
                                    function() {
                                        var rowData = this
                                            .data(); // Obtener los datos de la fila actual
                                        var miembros = rowData.miembros ||
                                        []; // Obtener los miembros de la fila actual

                                        // Verificar si todos los valores seleccionados están presentes en el arreglo miembros
                                        var allSelectedPresent =
                                            selectedValues.every(function(
                                                selectedValue) {
                                                return miembros.some(
                                                    function(
                                                        miembro) {
                                                        return miembro
                                                            .user_id ===
                                                            selectedValue;
                                                    });
                                            });

                                        // Mostrar u ocultar la fila según el resultado
                                        if (allSelectedPresent) {
                                            this.nodes().to$()
                                                .show(); // Mostrar la fila si todos los valores seleccionados están presentes
                                        } else {
                                            this.nodes().to$()
                                                .hide(); // Ocultar la fila si no todos los valores seleccionados están presentes
                                        }
                                    });

                            } else {
                                $('#tabla_eventos').DataTable().rows().every(
                                    function() {
                                        // Mostrar u ocultar la fila según el resultado

                                        this.nodes().to$()
                                            .show(); // Mostrar la fila si todos los valores seleccionados están presentes

                                    });
                            }
                        });

                    }
                });
            } else if (title.trim().toLowerCase() === "acciones") {
                $(this).html('<label><span><i class="fas fa-filter"></i></span> Filtros</label>');
            } else {
                $(this).html('<input class="form-control" type="text" placeholder="' + title +
                    '" />');
            }

            $(this).addClass("p-2");
        });



        function hideSearchInputs(columns) {

            for (let i = 0; i < columns.length; i++) {
                if (columns[i]) {
                    $(".filters th:eq(" + i + ")").show();
                } else {
                    $(".filters th:eq(" + i + ")").hide();
                }
            }
        }
        var Table = $('#tabla_eventos').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en eventos",
                infoEmpty: "Mostrando 0 a 0 de 0 en eventos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/eventos.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                cache: false,
                dataSrc: function(json) {
                    console.log(json);


                    $("#eventos_count").text(json.length)

                    return json;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },
            "orderCellsTop": true,
            "fixedHeader": true,
            "initComplete": function() {
                var api = this.api();
                hideSearchInputs(api.columns().responsiveHidden().toArray());
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_evento",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "nombre"
                },
                {
                    "data": "fecha_inicio"
                },
                {
                    "data": "fecha_final"
                },

                {
                    "data": "nombre_categoria"
                },

                {
                    "data": "estado"
                },
                {
                    "data": null,
                    "render": function(data, type, row, meta) {
                        var ul = document.createElement('ul');
                        ul.classList.add("h-100", "list-group")
                        //ul.style.overflowY = 'auto';
                        //ul.style.maxHeight = '130px';
                        // Iterar sobre el arreglo de cursos
                        data.miembros.forEach(function(curso) {
                            var li = document.createElement('li');

                            li.textContent = curso.user_full_name;
                            li.classList.add("p-2",
                                "list-group-item", "d-flex",
                                "justify-content-between", "align-items-center")
                            // Establecer el atributo data-id con el id_curso del curso
                            li.setAttribute('data-id', curso.user_id);
                            var div = document.createElement('div');
                            div.className =
                                'd-flex';



                            var link1 = document.createElement('a');
                            link1.setAttribute('data-toggle', 'tooltip');
                            link1.setAttribute('data-placement', 'top');
                            link1.setAttribute('data-url', curso.contrato_lleno);

                            link1.setAttribute('data-user', curso.user_id);
                            link1.setAttribute('data-id', curso.id_user_evento);
                            link1.setAttribute('data-evento', data.id_evento);
                            link1.setAttribute('type', 'button');



                            link1.setAttribute('class', 'p-1 btn ' +
                                "btn-primary mx-2 " +
                                "archivos_usuario");
                            link1.setAttribute('type', 'button');
                            link1.setAttribute('title',
                                "Archivos");


                            var link3 = document.createElement('a');
                            link3.setAttribute('data-toggle', 'tooltip');
                            link3.setAttribute('data-placement', 'top');
                            link3.setAttribute('data-url', curso.contrato_lleno);

                            link3.setAttribute('data-user', curso.user_id);
                            link3.setAttribute('data-id', curso.id_user_evento);
                            link3.setAttribute('data-evento', data.id_evento);
                            link3.setAttribute('type', 'button');


                            var success = (curso.contrato_lleno != null) ?
                                "success" : 'danger'
                            link3.setAttribute('class', 'p-1 btn ' +
                                "btn-" + success + " mr-2 " +
                                "ver_contrato");
                            link3.setAttribute('type', 'button');
                            link3.setAttribute('title',
                                "Contrato");


                            var icon = document.createElement('i');
                            icon.setAttribute('class', 'm-0 fas fa-file');

                            // Agrega el icono como hijo del enlace
                            link3.appendChild(icon);
                            // Agregar el LI al UL
                            var link2 = document.createElement('a');
                            link2.setAttribute('data-toggle', 'tooltip');
                            link2.setAttribute('data-placement', 'top');
                            link2.setAttribute('data-url', (curso.horario_lleno !=
                                    null) ? curso.horario_lleno :
                                '../horarios/default.pdf');

                            link2.setAttribute('data-user', curso.user_id);
                            link2.setAttribute('data-id', curso.id_user_evento);
                            link2.setAttribute('data-evento', data.id_evento);

                            success = (curso.horario_lleno != null) ? "success" :
                                'danger'
                            link2.setAttribute('class', 'p-1 btn ' + "btn-" +
                                success +
                                " ver_horario");
                            link2.setAttribute('type', 'button');
                            link2.setAttribute('title',
                                "Horario");

                            var icon1 = document.createElement('i');
                            icon1.setAttribute('class', 'm-0 fas fa-file-upload');

                            var icon2 = document.createElement('i');
                            icon2.setAttribute('class', 'm-0 fas fa-clock');



                            link2.appendChild(icon2);
                            link1.appendChild(icon1);
                            div.appendChild(link1);
                            div.appendChild(link3);
                            div.appendChild(link2);

                            li.appendChild(div);
                            ul.appendChild(li);

                        });
                        return ul.outerHTML;
                    }
                },
                {
                    "data": "id_evento",
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var linkVerPerfil = document.createElement('a');
                        linkVerPerfil.className = 'p-1 dropdown-item';
                        linkVerPerfil.href = `./evento?id=${data}`;
                        linkVerPerfil.innerHTML = `
                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#00000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Configurar miembros
                `;

                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_edit_evento p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data);
                        buttonEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;
                        var buttonArchivos = document.createElement('button');
                        buttonArchivos.className = 'btn_modal_archivos p-1 dropdown-item';
                        buttonArchivos.setAttribute('type', 'button');
                        buttonArchivos.setAttribute('data-id', data);
                        buttonArchivos.innerHTML = `
                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Archivos
                    
                `;
                        var buttonFotos = document.createElement('button');
                        buttonFotos.className = 'btn_eliminar_evento p-1 dropdown-item';
                        buttonFotos.setAttribute('type', 'button');
                        buttonFotos.setAttribute('data-id', data);
                        buttonFotos.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                    
                `;
                        dropdownMenu.appendChild(buttonFotos);
                        dropdownMenu.appendChild(linkVerPerfil);
                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonArchivos);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        });

        Table
            .columns(':not(:last-child)')
            .eq(0)
            .each(function(colIdx) {
                $("input", $(".filters th")[colIdx]).on("keyup change", function() {
                    Table.column(colIdx).search(this.value).draw();
                });
            });

        Table.on("responsive-resize", function(e, datatable, columns) {
            console.log(columns);
            hideSearchInputs(columns);
        });

    });
})(jQuery);
</script>
<script>
(function($) {

    'use strict';

    $(function() {
        $("#archivo_file").change(function(e) {
            var archivo = $('#archivo_file')[0].files[0];

            $("#archivo_archivo").val(archivo.name)

        });
        $("#btn_add_archivo").click(function() {

            var archivo = $('#archivo_file')[0].files[0];
            var id_evento = $('#btn_subir_archivo').data("id")

            var nombre = $("#nombre_archivo").val();
            if (!archivo) {
                $.toast({
                    heading: 'Ningún archivo seleccionado.',
                    text: 'Por favor, selecciona un archivo para subir.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false
            }

            if (nombre == "") {
                $.toast({
                    heading: 'Ningún nombre seleccionado.',
                    text: 'Por favor, agrega un nombre al archivo para subir.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false
            }
            var extension = archivo.type.split('/').pop();
            console.log(extension);
            if (extension == "jpeg") {
                extension = "jpg"
            }
            if (extension == "vnd.openxmlformats-officedocument.wordprocessingml.document") {
                extension = "docx"
            }
            if (archivo.size > 3000000) {
                $.toast({
                    heading: 'Archivo demasiado pesado.',
                    text: 'El archivo debe pesar menos 3 MB.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false
            }
            var fd = new FormData();
            fd.append('archivo', archivo);
            fd.append('extension', extension);
            fd.append('nombre', nombre);
            fd.append('id_evento_archivo', id_evento);

            var contenedor = document.getElementById('lista_archivos');
            var divElement = document.createElement('div');
            divElement.classList.add('col-sm-3', 'p-2', 'd-flex',
                'justify-content-center', 'align-items-center');

            // Crear un elemento div para la clase "archivo_lista"
            var archivoListaDiv = document.createElement('div');
            archivoListaDiv.classList.add('archivo_lista', 'd-flex',
                'justify-content-center', 'align-items-center');

            var imgElement = document.createElement('img');
            imgElement.classList.add('img-fluid');
            imgElement.setAttribute('alt', '');
            imgElement.setAttribute('src', './assets/images/oval.svg');
            // Agregar elementos al div "archivo_lista"
            archivoListaDiv.appendChild(imgElement);

            divElement.appendChild(archivoListaDiv);
            // Agregar el div "archivo_lista" al div principal

            contenedor.insertAdjacentElement('afterbegin', divElement);


            $.ajax({
                url: './api/eventos.php',
                type: 'POST',
                data: fd,
                async: false,
                cache: false,
                processData: false, // tell jQuery not to process the data
                contentType: false, // tell jQuery not to set contentType
                success: function(result) {
                    console.log(result);
                    if (result == "0") {
                        $.toast({
                            heading: 'Nombre repetido.',
                            text: 'Selecciona otro nombre para el archivo.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                        divElement.remove()
                        return false
                    } else

                    {

                        CargarArchivos(id_evento)
                        $.toast({
                            heading: 'Nuevo archivo subido.',
                            text: 'Se subido el nuevo archivo correctamente.',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 4
                        })
                    }
                }
            });

        });

        function CargarArchivos(id_evento) {
            var contenedor = document.getElementById('lista_archivos');
            contenedor.innerHTML = ""
            $.ajax({
                url: './api/eventos.php?id_evento_archivos=' + id_evento,
                type: 'GET',
                cache: false,
                async: false,
                dataType: 'json', // added data type
                success: function(result) {
                    console.log(result);
                    for (let r of result) {
                        r.url = r.url.slice(1)
                        console.log(r);
                        var divElement = document.createElement('div');
                        divElement.classList.add('col-sm-3', 'p-2', 'd-flex',
                            'justify-content-center', 'align-items-center');

                        // Crear un elemento div para la clase "archivo_lista"
                        var archivoListaDiv = document.createElement('div');
                        archivoListaDiv.classList.add('archivo_lista', 'd-flex',
                            'justify-content-center', 'align-items-center');

                        if (r.extension != "pdf") {
                            // Crear un elemento img
                            var imgElement = document.createElement('img');
                            imgElement.classList.add('img-fluid');
                            imgElement.setAttribute('alt', '');
                            imgElement.setAttribute('src', r.url);
                        } else {
                            var iframe = document.createElement('iframe');

                            iframe.setAttribute('src', r.url);
                            iframe.style.width = "100%";
                            iframe.style.height = "100%";

                        }


                        // Crear un botón para eliminar
                        var btnEliminar = document.createElement('button');
                        btnEliminar.classList.add('p-1', 'btn_eliminar_archivo', 'btn');
                        btnEliminar.setAttribute('data-url', r.url);
                        btnEliminar.setAttribute('data-id', id_evento);
                        btnEliminar.setAttribute('type', 'button');
                        btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';

                        // Crear un botón para seleccionar
                        var btnSeleccionar = document.createElement('button');
                        btnSeleccionar.classList.add('p-1', 'btn_seleccionar_archivo',
                            'btn');
                        btnSeleccionar.setAttribute('data-url', r.url);
                        btnSeleccionar.setAttribute('data-extension', r.extension);
                        btnSeleccionar.setAttribute('type', 'button');
                        btnSeleccionar.innerHTML = '<i class="m-0 fa fa-eye"></i>';




                        var nombre = document.createElement('a');
                        nombre.textContent = r.nombre
                        nombre.setAttribute('data-nombre', r.nombre);
                        nombre.setAttribute('data-url', r.url);
                        nombre.setAttribute('data-extension', r.extension);
                        nombre.classList.add("nombre_archivo_div")
                        nombre.innerHTML += '<i class="ml-2 fa fa-download"></i>';
                        // Agregar elementos al div "archivo_lista"
                        if (r.extension != "pdf") {
                            // Crear un elemento img
                            archivoListaDiv.appendChild(imgElement);

                        } else {
                            archivoListaDiv.appendChild(iframe);

                        }
                        archivoListaDiv.appendChild(btnEliminar);
                        archivoListaDiv.appendChild(btnSeleccionar);

                        // Agregar el div "archivo_lista" al div principal
                        divElement.appendChild(archivoListaDiv);

                        divElement.appendChild(nombre);
                        contenedor.appendChild(divElement);

                    }
                }
            })

        }
        $(document).on("click", ".btn_modal_archivos", function() {


            $('#btn_subir_archivo').data("id", $(this).data("id"))
            CargarArchivos($(this).data("id"))

            $("#modalSubirArchivo").modal("show");
        });

        $(document).on("click", ".btn_seleccionar_archivo", function() {
            var url = $(this).data("url");
            var extension = $(this).data("extension");
            var div = document.getElementById("contenedor_archivo")
            div.innerHTML = ""
            if (extension !== "pdf") {
                // Crear un elemento <img>


                var imgElement = document.createElement("img");

                // Establecer los atributos del elemento <img>
                imgElement.id = "archivo_modal";
                imgElement.className = "w-100 img-fluid";
                imgElement.src = url; // Aquí establece la fuente de la imagen que desees
                imgElement.alt = "";

                // Agregar el elemento <img> al documento
                div.appendChild(imgElement);
            } else {
                var iframe = document.createElement('iframe');
                iframe.setAttribute('id', 'archivo_modal');
                iframe.setAttribute('src', url);
                iframe.style.width = "100%"
                iframe.style.height = "400px"
                div.appendChild(iframe);
            }



            $("#modalVerArchivo").modal("show");


        });
        $(document).on("click", ".nombre_archivo_div", function() {
            var nombre = $(this).data("nombre");
            var url = $(this).data("url");
            var extension = $(this).data("extension");

            $(this).attr("download", nombre)
            $(this).attr("href", url)
        });
        $(document).on("click", ".btn_eliminar_archivo", function() {
            var id = $(this).data("id");
            var url = $(this).data("url");


            $.ajax({
                type: "DELETE",
                url: "./api/eventos.php?url=" + url,
                cache: false,
                async: false,
                success: function(response) {
                    console.log(response);
                    CargarArchivos(id)
                    $.toast({
                        heading: 'Archivo eliminado.',
                        text: 'Se eliminado el archivo correctamente.',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                }

            })
        });
    });
})(jQuery);
</script>
<style>
table.dataTable thead th,
table.dataTable tbody td {

    padding: 0.5rem !important;
}

.dropdown.bootstrap-select.show-tick {
    width: 100% !important;

}

.bootstrap-select .dropdown-menu li a {
    padding: 0.5rem !important;
}

.filters {
    background-color: #269bff;
}

.filters label {
    color: #fff;
}
</style>