<div class="content-wrapper">

    <div class="row profile-page ">

        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/swntouvh.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Ingresos</p>

                        <span id="ingresos_count"></span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/uxtqhmfa.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Tickets totales</p>

                        <span id="compras_count"></span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/kkbyjlau.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Tickets con factura</p>

                        <span id="con_factura_count"></span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/uxtqhmfa.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Tickets sin factura</p>

                        <span id="sin_factura_count"></span>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div class="row profile-page">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0 ">

                        <div class="row ">

                            <!-- Historial de Acceso -->

                            <div class="col-md-12">




                                <div class="row p-3">


                                    <div class="col-12">

                                        <button type="button" id="btn_descargar_excel"
                                            class="btn btn-sm btn-info">Descargar excel</button>

                                        <button type="button" id="btn_crear_facturas"
                                            class="btn btn-sm btn-primary">Crear factura</button>

                                    </div>

                                </div>
                                <div class="row px-3 pb-3">
                                    <div class="col-12">

                                        <p>Elije el orden de la numeración arrastrando los elementos con

                                            el

                                            cursor</p>

                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="custom-control custom-checkbox d-inline-block mb-2">

                                                <input type="checkbox" id="automatico_tickets"
                                                    class="valor_personalizacion custom-control-input apartado h-100"
                                                    data-nombre="automatico_tickets"
                                                    <?php if ($personalizacion["automatico_tickets"] == true) {

                                                                                                                                        echo "checked";

                                                                                                                                    } ?>>

                                                <span style="font-size: 18px;line-height: 24px;"
                                                    class="custom-control-label">Configurar

                                                    la numeración

                                                    automática</span>

                                            </label>
                                        </div>
                                    </div>



                                    <div class="col-12 mb-3">
                                        <?php
// Paso 1: Construir un array de campos con su orden
$campos = [];

$campos[$personalizacion["orden_expediente_tickets"]] = [
    'id' => 'orden_expediente_tickets',
    'label' => 'Expediente:',
    'type' => 'text',
    'input_id' => 'expediente_tickets',
    'value' => $personalizacion['expediente_tickets']
];

$campos[$personalizacion["orden_año_tickets"]] = [
    'id' => 'orden_año_tickets',
    'label' => 'Año:',
    'type' => 'number',
    'input_id' => 'año_tickets',
    'value' => $personalizacion['año_tickets']
];

$campos[$personalizacion["orden_barra_tickets"]] = [
    'id' => 'orden_barra_tickets',
    'label' => '/', // este caso se maneja especial
    'type' => 'label'
];

$campos[$personalizacion["orden_numeracion_tickets"]] = [
    'id' => 'orden_numeracion_tickets',
    'label' => 'Comenzar desde:',
    'type' => 'number',
    'input_id' => 'numeracion_tickets',
    'value' => $personalizacion['numeracion_tickets']
];

// Paso 2: Ordenar por clave (orden)
ksort($campos);
?>

                                        <div id="sortable_tickets" class="form-group mb-0 d-flex align-items-center">
                                            <?php foreach ($campos as $campo): ?>
                                            <?php if ($campo['type'] === 'label'): ?>
                                            <div id="<?= $campo['id'] ?>" class="sort">
                                                <label style="margin-top: 20px;"
                                                    class="mx-2"><?= $campo['label'] ?></label>
                                            </div>
                                            <?php else: ?>
                                            <div class="form-group mb-0 sort" id="<?= $campo['id'] ?>">
                                                <label for="<?= $campo['input_id'] ?>"><?= $campo['label'] ?></label>
                                                <input id="<?= $campo['input_id'] ?>"
                                                    class="valor_personalizacion form-control"
                                                    type="<?= $campo['type'] ?>" data-nombre="<?= $campo['input_id'] ?>"
                                                    value="<?= htmlentities($campo['value'], ENT_QUOTES) ?>">
                                            </div>
                                            <?php endif; ?>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row px-3">

                                    <div class="col-md-4 col-xl-3">

                                        <div class="form-group">

                                            <label for="my-input">Fecha de inicio</label>

                                            <input class="form-control" type="month" id="fecha_i">

                                        </div>



                                    </div>

                                    <div class="col-md-4 col-xl-3">

                                        <div class="form-group">

                                            <label for="my-input">Fecha de fin</label>

                                            <input class="form-control" type="month" id="fecha_f">

                                        </div>



                                    </div>





                                </div>

                                <div class="card card-cuenta">

                                    <div class="card-body card-table-body p-3">

                                        <div class="table-responsive">

                                            <table id="tabla_compras" class="tabla_compras table">

                                                <thead>

                                                    <tr>

                                                        <th>

                                                            Número</th>

                                                        <th>Factura asociada</th>

                                                        <th>Cliente</th>

                                                        <th>Responsable</th>

                                                        <th>Tipo</th>

                                                        <th>Fecha</th>

                                                        <th>Subtotal</th>

                                                        <th>Impuesto</th>

                                                        <th>Total</th>

                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>

                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminaci贸n de cuenta -->

                            <!-- /Eliminaci贸n de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEliminarCompra" role=" dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar compra</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->

                <p class="">¿Estás seguro de que deseas eliminar la compra definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">

                <form id="form_eliminar_trabajador" method="POST" action="">

                    <input type="hidden" id="id_compra_eliminar">

                    <button id="btn_eliminar_compra_2" class="btn btn-danger btn-fw" type="button" name="">

                        Confirmar y eliminar </button>

                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>

                </form>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalVerCompra" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_compra" class="modal-body pb-4">

            </div>

        </div>

    </div>

</div>

<div class="modal fade modal-crearfactura" id="modalCrearFactura" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                Crear factura

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_crearfactura" class="modal-body pb-4">

                <form id="crearfactura-form">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label for="titulo_factura"
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Concepto</label>

                                <input type="text" class="input_factura form-control validable" id="titulo_factura"
                                    name="data[titulo]" data-target="numero_pdf">

                            </div>
                            <div class="form-group">

                                <label for="my-input">Cliente</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                            data-target="cliente_factura" type="button">-</button>

                                    </span>

                                    <select id="cliente_factura" name="data[client_id]"
                                        class="select_clientes custom-select select2 form-control validable">



                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCliente">+</button>

                                    </span>

                                </div>



                            </div>
                            <div class="form-group">

                                <label for="razon_social_factura"
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Razón
                                    social</label>

                                <input type="text" class="input_factura form-control validable"
                                    id="razon_social_factura" name="data[razon_social]" data-target="numero_pdf">

                            </div>

                            <div class="form-group">

                                <label for="cif_nif_factura"
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">CIF/NIF</label>

                                <input type="text" class="input_factura form-control validable" id="cif_nif_factura"
                                    name="data[cif]" data-target="numero_pdf">

                            </div>

                            <div class="form-group">

                                <label for="direccion_factura"
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Dirección</label>

                                <input type="text" class="input_factura form-control validable" id="direccion_factura"
                                    name="data[direccion]" data-target="numero_pdf">

                            </div>

                            <div class="form-group">

                                <label for="email_factura"
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Email</label>

                                <input type="text" class="input_factura form-control validable" id="email_factura"
                                    name="data[email]" data-target="numero_pdf">

                            </div>

                            <div class="form-group">

                                <label for="cp_factura"
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Código
                                    Postal</label>

                                <input type="text" class="input_factura form-control validable" id="cp_factura"
                                    name="data[cp]" data-target="numero_pdf">

                            </div>

                            <div class="form-group">

                                <label for="telefono_factura"
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Teléfono</label>

                                <input type="text" class="input_factura form-control validable" id="telefono_factura"
                                    name="data[telefono]" data-target="numero_pdf">

                            </div>

                            <div class="form-group">

                                <label
                                    style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Número

                                    <?php if ($personalizacion["automatico_facturas"] == true) {

                                        echo "(Automático)";

                                    } ?></label>

                                <input type="text" class="input_factura form-control no_vaciar validable"
                                    id="numero_factura" name="data[numero]" data-target="numero_pdf" value="<?php if ($personalizacion["automatico_facturas"] == true) {

                                                                        if ($personalizacion['orden_expediente_facturas'] == "1") {

                                                                            echo htmlentities($personalizacion['expediente_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_año_facturas'] == "1") {

                                                                            echo htmlentities($personalizacion['año_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_barra_facturas'] == "1") {

                                                                            echo "/";

                                                                        }

                                                                        if ($personalizacion['orden_numeracion_facturas'] == "1") {

                                                                            echo htmlentities($personalizacion['numeracion_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_expediente_facturas'] == "2") {

                                                                            echo htmlentities($personalizacion['expediente_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_año_facturas'] == "2") {

                                                                            echo htmlentities($personalizacion['año_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_barra_facturas'] == "2") {

                                                                            echo "/";

                                                                        }

                                                                        if ($personalizacion['orden_numeracion_facturas'] == "2") {

                                                                            echo htmlentities($personalizacion['numeracion_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_expediente_facturas'] == "3") {

                                                                            echo htmlentities($personalizacion['expediente_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_año_facturas'] == "3") {

                                                                            echo htmlentities($personalizacion['año_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_barra_facturas'] == "3") {

                                                                            echo "/";

                                                                        }

                                                                        if ($personalizacion['orden_numeracion_facturas'] == "3") {

                                                                            echo htmlentities($personalizacion['numeracion_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_expediente_facturas'] == "4") {

                                                                            echo htmlentities($personalizacion['expediente_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_año_facturas'] == "4") {

                                                                            echo htmlentities($personalizacion['año_facturas'], ENT_QUOTES);

                                                                        }

                                                                        if ($personalizacion['orden_barra_facturas'] == "4") {

                                                                            echo "/";

                                                                        }

                                                                        if ($personalizacion['orden_numeracion_facturas'] == "4") {

                                                                            echo htmlentities($personalizacion['numeracion_facturas'], ENT_QUOTES);

                                                                        }

                                                                    } ?>" <?php if ($personalizacion["automatico_facturas"] == true) {

                                                                                echo "readonly";

                                                                            } ?>>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-12">

                            <div class="table-responsive">

                                <table id="tabla_crear_factura" class="tabla_crear_factura table">

                                    <thead>

                                        <tr>

                                            <th style="padding-left: 32px !important;padding-right: 50px !important;">

                                                Número</th>

                                            <th>Cliente</th>

                                            <th>Concepto</th>

                                            <th>Subtotal</th>

                                            <th>Impuesto</th>

                                            <th>Total</th>

                                            <th style="text-align:center;">Acciones</th>

                                        </tr>

                                    </thead>

                                    <tbody>

                                    </tbody>

                                </table>

                            </div>

                        </div>

                    </div>

                </form>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-primary btn-sm" id="crear-factura-btn">Crear factura</button>

            </div>

        </div>

    </div>

</div>
<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>
<script>
(function($) {

    'use strict';

    $(function() {

        $('#expediente_tickets').on('input', function() {

            let inputValue = $(this).val();

            console.log(inputValue);

            if (/^[a-zA-Z]$/.test(inputValue)) {

                // Si es una letra, convierte a mayúsculas

                $(this).val(inputValue.toUpperCase());

            } else {

                // Si no es una letra, vacía el campo

                $(this).val('');

            }

        });

        var initialOrderCaptured = false;

        var orderObject = {};
        var sortable2 = new Sortable(document.getElementById('sortable_tickets'), {

            animation: 150,





            onEnd: function(evt) {



                // Obtiene el orden real de los elementos después de la acción de arrastrar y soltar

                var orderedElements = Array.from(evt.from.children);



                // Construye el objeto de clave-valor

                orderObject = {};

                orderedElements.forEach(function(element, index) {

                    orderObject[element.id] = index +

                        1; // Sumamos 1 para obtener un orden basado en 1 en lugar de 0

                });



                console.log("Objeto de clave-valor:", orderObject);





                $.ajax({

                    type: 'POST',

                    url: './api/personalizacion.php',

                    cache: false,

                    async: false,

                    data: orderObject,

                    success: function(result2) {



                        $.toast({

                            heading: 'Orden cambiado.',

                            text: 'Se ha cambiado el orden correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        })



                    }

                });











            }

        });
        $(document).on("change", ".valor_personalizacion", function() {

            var nombre = $(this).data("nombre")

            var valor = (nombre != "automatico_tickets") ? $(this).val() : $(

                "#" + nombre).prop(

                "checked")





            $.ajax({

                type: 'POST',

                url: './api/personalizacion.php',

                cache: false,

                async: false,

                data: {

                    nombre: nombre,

                    valor: valor

                },

                success: function(result2) {

                    console.log(result2);

                    $.toast({

                        heading: 'Valor cambiado.',

                        text: 'Se ha cambiado la configuración correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })



                }

            });





        });

        $('.tabla_compras').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, -1],

                [10, 25, 50, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en compras",

                infoEmpty: "Mostrando 0 a 0 de 0 en compras",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",

                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [

                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }

            ],

            "searching": true,

            "ajax": {

                url: '/api/compras.php', // Ruta que devuelve los datos de los transportistas

                method: 'GET',

                dataSrc: function(data) {

                    console.log(data);


                    $("#compras_count").text(data.compras.length)
                    $("#ingresos_count").text(data.ingresos + "€")
                    $("#con_factura_count").text(data.con_factura)
                    $("#sin_factura_count").text(data.sin_factura)
                    return data.compras

                } // La propiedad que contiene los datos en la respuesta del servidor

            },

            "initComplete": function() {

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "numero"

                },



                {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        return data.numero_f == null ? "Sin Factura asociada" : data
                            .numero_f;

                    }

                },

                {

                    "data": "nombre_cliente"

                },

                {

                    "data": "nombre_responsable"

                },

                {

                    "data": "tipo"

                },

                {

                    "data": "fecha"

                }, {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        return formatearNumero(parseFloat(data.importe).toFixed(

                            2)) + "€";

                    }

                }, {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        return formatearNumero(parseFloat(data.igic * 100).toFixed(

                            2)) + "%";

                    }

                }, {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        return formatearNumero(parseFloat(data.importe_final).toFixed(

                            2)) + "€";

                    }

                },

                {

                    "data": null,

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonVerPresupuesto = document.createElement('button');

                        buttonVerPresupuesto.className =

                            'btn_ver_compra p-1 dropdown-item';

                        buttonVerPresupuesto.setAttribute('type', 'button');

                        buttonVerPresupuesto.setAttribute('data-id', data.id_compra)

                        buttonVerPresupuesto.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Ver ticket

                `;

                        var buttonImprimirPresupuesto = document.createElement('button');

                        buttonImprimirPresupuesto.className =

                            'btn_imprimir_compra p-1 dropdown-item';

                        buttonImprimirPresupuesto.setAttribute('type', 'button');

                        buttonImprimirPresupuesto.setAttribute('data-id', data.id_compra)

                        buttonImprimirPresupuesto.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Imprimir ticket

                `;

                        var buttonEnviar = document.createElement('button');

                        buttonEnviar.className =

                            'btn_enviar_compra p-1 dropdown-item';

                        buttonEnviar.setAttribute('type', 'button');

                        buttonEnviar.setAttribute('data-id', data.id_compra)

                        buttonEnviar.innerHTML = `

                    <lord-icon src="./assets/lordicons/send.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Enviar ticket`;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =

                            'btn_eliminar_producto p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data.id_compra)

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;

                        dropdownMenu.appendChild(buttonVerPresupuesto);

                        dropdownMenu.appendChild(buttonImprimirPresupuesto);

                        data.client_id != null && dropdownMenu.appendChild(buttonEnviar);

                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }

                }

            ]

        });

        $(document).on("click", ".btn_enviar_compra", function(e) {

            var id_compra_enviar = $(this).data("id")

            EnviarCompra(id_compra_enviar)

        })

        $(document).on("click", ".btn_eliminar_producto", function(e) {

            var id_compra_enviar = $(this).data("id")

            $.ajax({

                type: 'POST',

                url: './api/delete_compra.php?id=' + id_compra_enviar,

                cache: false,

                async: false,

                data: {

                    id_compra_enviar: id_compra_enviar

                },

                success: function(result2) {

                    $.toast({

                        heading: 'Ticket eliminado.',

                        text: 'Se ha eliminado el ticket correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    });

                    setTimeout(() => {

                        window.location.reload();

                    }, 2000);

                }

            });

        })

        function EnviarCompra(id) {

            var id_compra_enviar = id

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_compra_enviar: id_compra_enviar

                },

                success: function(result2) {

                    console.log(result2);

                    $.toast({

                        heading: 'Ticket enviado.',

                        text: 'Se ha enviado el ticket correspondiente a la compra correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    });

                }

            });

        }

        $(document).on("click", ".btn_ver_compra", function() {

            var id_compra_descargar = $(this).data("id")

            var url

            var div = document.getElementById("contenedor_compra")

            div.innerHTML = ""

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_compra_descargar: id_compra_descargar

                },

                success: function(result2) {

                    console.log(result2);

                    url = result2;

                    var iframe = document.createElement('iframe');

                    iframe.setAttribute('id', 'compra_modal');

                    iframe.setAttribute('src', url + '?timestamp=' + new Date()

                        .getTime());

                    iframe.style.width = "100%"

                    iframe.style.height = "70vh"

                    div.appendChild(iframe);

                    $("#modalVerCompra").modal("show");

                }

            });

        });

        $(document).on("click", ".btn_imprimir_compra", function() {

            var id_compra_descargar = $(this).data("id");

            var div = document.getElementById("contenedor_compra");

            div.innerHTML = "";

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_compra_descargar: id_compra_descargar

                },

                success: function(result2) {

                    console.log(result2);

                    var url = window.location.origin + "/" + result2;

                    console.log(url);

                    let pdfFrame = document.getElementById("pdfFrame");

                    if (!pdfFrame) {

                        pdfFrame = document.createElement("iframe");

                        pdfFrame.id = "pdfFrame";

                        pdfFrame.style.display = "none";

                        document.body.appendChild(pdfFrame);

                    }

                    pdfFrame.src = url;

                    pdfFrame.onload = () => {

                        pdfFrame.contentWindow.focus();

                        pdfFrame.contentWindow.print();

                    };

                }

            });

        });

        $('#btn_crear_facturas').click(function(event) {

            var nuevaUrl = "/api/compras.php?crear_factura=1";

            $.ajax({

                type: 'GET',

                url: nuevaUrl,

                cache: false,

                async: false,

                dataType: "json",

                success: function(result) {

                    // Destruir cualquier instancia existente de DataTable en la tabla

                    if ($.fn.dataTable.isDataTable('.tabla_crear_factura')) {

                        $('.tabla_crear_factura').DataTable().destroy();

                    }

                    // Inicializar el DataTable de nuevo con los nuevos datos

                    $('.tabla_crear_factura').DataTable({

                        "responsive": true,

                        "dom": 'Blfrtip',

                        "aLengthMenu": [

                            [10, 25, 50, -1],

                            [10, 25, 50, "Todos"]

                        ],

                        "iDisplayLength": 10,

                        "language": {

                            search: "Buscar",

                            emptyTable: "No hay información",

                            info: "Mostrando _START_ a _END_ de _TOTAL_ en compras",

                            infoEmpty: "Mostrando 0 a 0 de 0 en compras",

                            infoFiltered: "(Filtrado de _MAX_ total entradas)",

                            infoPostFix: "",

                            thousands: ",",

                            lengthMenu: "Mostrar _MENU_ Entradas",

                            processing: "Cargando...",

                            paginate: {

                                first: "Primero",

                                last: "Ultimo",

                                next: "Siguiente",

                                previous: "Anterior"

                            }

                        },

                        "stateSave": true,

                        "stateSaveCallback": function(settings, data) {

                            localStorage.setItem('DataTables_' + settings
                                .sInstance, JSON.stringify(data))

                        },

                        "stateLoadCallback": function(settings) {

                            return JSON.parse(localStorage.getItem(
                                'DataTables_' + settings.sInstance))

                        },

                        "order": [

                            [0, "desc"]

                        ],

                        "buttons": [{

                            extend: 'colvis',

                            text: 'Ocultar Columnas',

                            collectionLayout: 'fixed two-column',

                            className: "form-control"

                        }],

                        "searching": true,

                        "data": result, // Asignamos los datos directamente al DataTable

                        "initComplete": function() {},

                        "processing": true,

                        "serverSide": false,

                        "columns": [{

                                "data": "id_compra",

                                "render": function(data, type, row, meta) {

                                    return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                                        data + '</span>';

                                }

                            },

                            {

                                "data": "nombre_cliente",

                                "render": function(data) {

                                    return data === null ?
                                        "Sin Cliente" : data;

                                }

                            },

                            {

                                "data": "detallado",

                                "render": function(data) {

                                    let detalles = JSON.parse(data);

                                    return detalles.map(item => item
                                        .nombre).join(", ");

                                }

                            },

                            {

                                "data": "importe",

                                "render": function(data) {

                                    return formatearNumero(parseFloat(
                                        data).toFixed(2)) + "€";

                                }

                            },

                            {

                                "data": "igic",

                                "render": function(data) {

                                    return formatearNumero(parseFloat(
                                            data * 100).toFixed(2)) +
                                        "%";

                                }

                            },

                            {

                                "data": "importe_final",

                                "render": function(data) {

                                    return formatearNumero(parseFloat(
                                        data).toFixed(2)) + "€";

                                }

                            },

                            {

                                "data": null,

                                "render": function(data, type, row) {
                                    return `<label class="custom-control custom-checkbox d-inline-block"
                 style="height: auto;min-height: unset;">
                <input type="checkbox" name="data[tickets][]"value="${data.id_compra}" data-id="${data.id_compra}"
                 class="custom-control-input apartado">
                <span class="custom-control-label"style="font-size: 17px;">Seleccionar</span></label>`


                                }

                            }

                        ]

                    });

                    $("#modalCrearFactura").modal("show");

                }

            });

            return false;

        });
        $("#cliente_factura").change(function(e) {
            var id_cliente = $(this).val()

            $.ajax({

                url: "./api/clientes.php?client_id=" + id_cliente,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(res) {
                    console.log(res);

                    $("#razon_social_factura").val(res.nombre).trigger('change');
                    $("#cif_nif_factura").val(res.cif).trigger('change');
                    $("#direccion_factura").val(res.direccion).trigger('change');
                    $("#email_factura").val(res.email).trigger('change');
                    $("#cp_factura").val(res.cp).trigger('change');
                    $("#telefono_factura").val(res.telefono).trigger('change');







                    $("#id_cliente_factura").val(res.client_id)

                }

            });

        });
        $('#crear-factura-btn').click(function(event) {

            $("#crear-factura-btn").attr("disabled", true);

            $("#crear-factura-btn").addClass('btn-loading');

            var nuevaUrl = "/api/compras.php?crear_factura=1";

            var repetido = false


            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalCrearFactura .validable').forEach(
                input => {


                    const evento = new CustomEvent('validar', {
                        bubbles: true,
                        detail: {
                            mensaje: 'Campo requerido'
                        }
                    });

                    // Disparar el evento de validación para cada input
                    input.dispatchEvent(evento);

                    // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                    if (!input.isValid) {
                        repetido = true;
                    }
                });




            if (repetido) {





                return false

            }
            $.ajax({

                type: 'POST',

                url: nuevaUrl,

                cache: false,

                async: false,

                dataType: "json",

                data: $("#crearfactura-form").serialize(),

                success: function(result) {

                    $("#crear-factura-btn").attr("disabled", false);

                    $("#crear-factura-btn").removeClass('btn-loading');

                    if (!result['status']) {

                        $.toast({

                            heading: 'Acción no válida',

                            text: result['msg'],

                            position: 'top-right',

                            loaderBg: '#loaderBg',

                            icon: 'error',

                            hideAfter: 2000,

                            stack: 4

                        });

                    } else {

                        $("#modalCrearFactura").modal("hide");

                        $.toast({

                            heading: 'Acción válida',

                            text: result['msg'],

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 4

                        });

                        setTimeout(() => {

                            window.location.reload();

                        }, 2000);

                    }

                }

            });

            return false;

        });

        $('#btn_descargar_excel').click(function(event) {

            var nuevaUrl = "/api/compras.php"

            $.ajax({

                type: 'GET',

                url: nuevaUrl,

                cache: false,

                async: false,

                dataType: "json",

                success: function(facturas) {

                    console.log(facturas);

                    var facturas_excel = []

                    facturas.forEach(factura => {

                        var concepto = '';

                        var detalles = JSON.parse(factura.detallado);

                        detalles.forEach(element_detalles => {

                            concepto += element_detalles['nombre'] +
                                ',';

                        });

                        concepto = concepto.slice(0, -1);

                        var fac = {

                            numero: factura.id_compra,

                            numero_factura: factura.numero,

                            concepto: concepto,

                            fecha: factura.fecha,

                            tipo: factura.tipo,

                            cliente: factura.nombre_cliente,

                            cif: factura.cif,

                            email: factura.email,

                            base: factura.importe,

                            igic: parseFloat(factura.igic * 100)

                                .toFixed(2),

                            total: parseFloat(factura.importe_final)

                                .toFixed(2)

                        }

                        facturas_excel.push(fac)

                    });

                    var libro = XLSX.utils.book_new();

                    var hoja = XLSX.utils.aoa_to_sheet([]);

                    var estiloNegrita = {

                        font: {

                            bold: true

                        }

                    };

                    var titulo = [

                        [

                            "Informe de compras <?php echo htmlentities($personalizacion['nombre'], ENT_QUOTES); ?>"

                        ]

                    ];

                    XLSX.utils.sheet_add_aoa(hoja, titulo, {

                        origin: "A1"

                    });

                    // Crear y agregar la fila de encabezado

                    var headers = ["Número", "Número de factura", "Concepto", "Fecha",
                        "Método de pago", "Cliente", "CIF/NIF", "Email",

                        "Base", "Impuesto",

                        "Total"

                    ];

                    XLSX.utils.sheet_add_aoa(hoja, [headers], {

                        origin: "A2"

                    });

                    facturas_excel.forEach(function(factura, index) {

                        var fila = [

                            factura.numero,

                            factura.numero_factura,

                            factura.concepto,

                            factura.fecha,

                            factura.tipo,

                            factura.cliente,

                            factura.cif,

                            factura.email,

                            factura.base,

                            factura.igic,

                            factura.total

                        ];

                        // La fila de datos empieza desde la tercera fila (índice 2 en cero-based)

                        XLSX.utils.sheet_add_aoa(hoja, [fila], {

                            origin: "A" + (index + 3)

                        });

                    });

                    var range = XLSX.utils.decode_range(hoja["!ref"]);

                    if (!hoja["!merges"]) hoja["!merges"] = [];

                    hoja["!merges"].push({

                        s: {

                            r: 0,

                            c: 0

                        },

                        e: {

                            r: 0,

                            c: range.e.c

                        }

                    });

                    XLSX.utils.book_append_sheet(libro, hoja, "Informe_compras");

                    const u8 = XLSX.write(libro, {

                        bookType: "xlsx",

                        type: "buffer"

                    });

                    const parts = [u8]; // `Blob` constructor expects this

                    /* create Blob */

                    const blob = new Blob(parts, {

                        type: "application/download"

                    });

                    var enlaceDescarga = document.createElement('a');

                    enlaceDescarga.href = window.URL.createObjectURL(blob);

                    enlaceDescarga.download = "Informe_compras.xlsx";

                    // Agregar el enlace al documento y simular el clic para iniciar la descarga

                    document.body.appendChild(enlaceDescarga);

                    enlaceDescarga.click();

                    // Eliminar el enlace después de la descarga

                    document.body.removeChild(enlaceDescarga);

                }

            });

            return false;

        });



        $("#fecha_i, #fecha_f").change(function() {

            var fecha_i = new moment($("#fecha_i").val()).format("YYYY-MM-DD")

            var fecha_f = new moment($("#fecha_f").val()).format("YYYY-MM-DD")



            if ($("#fecha_i").val() != "" && $("#fecha_f").val() != "") {

                var nuevaUrl = "./api/compras.php?fecha_i=" + fecha_i + "&fecha_f=" +

                    fecha_f

                $('#tabla_compras').DataTable().ajax.url(nuevaUrl).load();

            } else {

                var nuevaUrl = "./api/compras.php"

                $('#tabla_compras').DataTable().ajax.url(nuevaUrl).load();

            }

        })

    })

})(jQuery);
</script>