<div class="content-wrapper">


    <div class="row profile-page ">

        <div class="col-12 mb-8">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/czruzpfg.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Fichajes</p>

                        <span id="fichajes_count" class="">



                        </span>

                    </div>

                </div>

            </div>

        </div>





    </div>





    <div class="row profile-page">

        <div class="col-12">

            <div class="card">



                <div class="" style="padding-bottom: 0px !important;">



                    <div class="pt-0 ">



                        <div class="row ">

                            <!-- Historial de Acceso -->

                            <div class="col-md-12">
                                <div class="row p-3">
                                    <div class="col-12"><button data-toggle="modal" data-target="#modalAgregarFichaje"
                                            class="btn btn-sm btn-success">Añadir fichaje manual</button>
                                    </div>
                                </div>


                                <div class="card card-cuenta">



                                    <div class="card-body p-3 card-table-body">

                                        <div class="row">

                                            <div class="col-md-4 col-xl-3">

                                                <div class="form-group">

                                                    <label for="my-input">Fecha de inicio</label>

                                                    <input class="form-control" type="month" id="fecha_i">

                                                </div>



                                            </div>

                                            <div class="col-md-4 col-xl-3">

                                                <div class="form-group">

                                                    <label for="my-input">Fecha de fin</label>

                                                    <input class="form-control" type="month" id="fecha_f">

                                                </div>



                                            </div>


                                            <div class="col-12 table-responsive">

                                                <table id="tabla_fichajes" class="table tabla_fichajes">

                                                    <thead>

                                                        <tr>

                                                            <th
                                                                style="padding-left: 32px !important;padding-right: 50px !important;">

                                                                ID

                                                            </th>

                                                            <th>Miembro</th>



                                                            <th>Fecha entrada</th>

                                                            <th>En descanso</th>

                                                            <th>Fecha salida</th>

                                                            <th>Estado</th>

                                                            <th>Horas totales</th>

                                                            <th>Observaciones</th>

                                                            <th>Acciones</th>

                                                        </tr>

                                                    </thead>

                                                    <tbody>





                                                    </tbody>

                                                </table>

                                            </div>


                                        </div>


                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminación de cuenta -->



                            <!-- /Eliminación de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



</div>





<!-- MODALS -->

<div class="modal fade" id="modalAgregarFichaje" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar fichaje</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>







            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Miembro</label>

                                <select id="usuario_fichaje"
                                    class="form-control custom-select text-center select2 campo_fichaje"
                                    data-campo="id_miembro" data-requerido="true">

                                    <?php foreach ($Miembros_List as $M) {

                            $U = $this->Users->_GetUserData($M["user_id"]); ?>

                                    <option value="<?php echo htmlentities($M['id_miembro'], ENT_QUOTES); ?>">

                                        <?php echo htmlentities($U['user_full_name'], ENT_QUOTES); ?>

                                    </option>

                                    <?php } ?>

                                </select>

                            </div>

                        </div>

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Entrada</label>

                                <input type="datetime-local" id="entrada_fichaje"
                                    class="form-control campo_fichaje validable" data-campo="fecha_entrada"
                                    data-requerido="true">

                            </div>

                        </div>

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Salida</label>

                                <input type="datetime-local" id="salida_fichaje"
                                    class="form-control campo_fichaje validable" data-campo="fecha_salida"
                                    data-requerido="true">

                            </div>

                        </div>

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Horas de descanso</label>

                                <input type="number" id="horas_descanso_fichaje"
                                    class="form-control campo_fichaje validable" data-campo="horas_descanso"
                                    data-requerido="true">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Observaciones</label>

                                <textarea id="observaciones_fichaje" class="form-control campo_fichaje"
                                    data-campo="observaciones" data-requerido="false"></textarea>

                            </div>

                        </div>

                    </div>

                </div>

            </div>





            <div class="modal-footer text-right">







                <button class="btn btn-success btn-fw" id="btn_agregar_fichaje" type="button">



                    Añadir</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>





            <!-- /modal-body -->



        </div>



    </div>



</div>

<!-- Modal para Editar Fichaje -->

<div class="modal fade" id="modalEditarFichaje" role="dialog" aria-labelledby="modalEditarFichajeTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Editar fichaje</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>



            </div>



            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Miembro</label>

                                <select id="usuario_fichaje_edit"
                                    class="form-control custom-select text-center select2 campo_fichaje"
                                    data-campo="id_miembro" data-requerido="true">

                                    <?php foreach ($Miembros_List as $M) {

                            $U = $this->Users->_GetUserData($M["user_id"]); ?>

                                    <option value="<?php echo htmlentities($M['id_miembro'], ENT_QUOTES); ?>">

                                        <?php echo htmlentities($U['user_full_name'], ENT_QUOTES); ?>

                                    </option>

                                    <?php } ?>

                                    <!-- Opciones se cargarán con JS -->

                                </select>

                            </div>

                        </div>

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Entrada</label>

                                <input type="datetime-local" id="entrada_fichaje_edit"
                                    class="validable form-control campo_fichaje" data-campo="fecha_entrada"
                                    data-requerido="true">

                            </div>

                        </div>

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Salida</label>

                                <input type="datetime-local" id="salida_fichaje_edit"
                                    class="validable form-control campo_fichaje" data-campo="fecha_salida"
                                    data-requerido="true">

                            </div>

                        </div>

                        <div class="col-sm-12">

                            <div class="form-group">

                                <label>Horas de descanso</label>

                                <input type="number" id="horas_descanso_fichaje_edit"
                                    class="validable form-control campo_fichaje" data-campo="horas_descanso"
                                    data-requerido="true">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Observaciones</label>

                                <textarea id="observaciones_fichaje_edit" class="form-control  campo_fichaje"
                                    data-campo="observaciones" data-requerido="false"></textarea>

                            </div>

                        </div>

                    </div>

                </div>

            </div>



            <div class="modal-footer text-right">

                <button class="btn btn-success btn-fw" id="btn_editar_fichaje" type="button">

                    Guardar cambios

                </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar

                </button>

            </div>



        </div>



    </div>



</div>



<div class="modal fade modal-cambiar" id="modalEliminarFichaje" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el fichaje definitivamente?</p>







                <lord-icon src="https://cdn.lordicon.com/dgiidarp.json" trigger="hover"
                    colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                    style="width:80px;height:80px">

                </lord-icon>







            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button id="btn_eliminar_fichaje" class="btn btn-danger btn-fw" type="button" name="">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>



<script>
(function($) {

    'use strict';

    $(function() {

        $("#fecha_i, #fecha_f").change(function() {

            var fecha_i = new moment($("#fecha_i").val()).format("YYYY-MM-DD")

            var fecha_f = new moment($("#fecha_f").val()).format("YYYY-MM-DD")



            if ($("#fecha_i").val() != "" && $("#fecha_f").val() != "") {

                var nuevaUrl = "./api/fichajes.php?fecha_i=" + fecha_i + "&fecha_f=" +

                    fecha_f

                $('#tabla_fichajes').DataTable().ajax.url(nuevaUrl).load();

            } else {

                var nuevaUrl = "./api/fichajes.php"

                $('#tabla_fichajes').DataTable().ajax.url(nuevaUrl).load();

            }

        })

        // Configurar la ubicación del worker (esto elimina la advertencia)

        pdfjsLib.GlobalWorkerOptions.workerSrc =

            "https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.worker.min.js";









        function segundosAHorasYMinutos(segundos) {

            const horas = Math.floor(segundos / 3600); // 3600 segundos en una hora

            const minutos = Math.floor((segundos % 3600) / 60); // El residuo en minutos

            return {

                horas: horas,

                minutos: minutos

            };

        }

        var Table = $('.tabla_fichajes').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, -1],

                [10, 25, 50, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en fichajes",

                infoEmpty: "Mostrando 0 a 0 de 0 en fichajes",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",



                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [



                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }, {

                    extend: 'excel',

                    text: 'Descargar historial',

                    exportOptions: {

                        columns: ':not(:eq(8))', // o usa true para todas: columns: ':visible' si quieres limitarlo

                        modifier: {

                            search: 'applied',

                            order: 'applied'

                        },

                        format: {

                            body: function(data, row, column, node) {

                                // Obtenemos la instancia de la tabla y los datos completos de la fila

                                const table = $('#tabla_fichajes').DataTable();

                                const rowData = table.row(node).data();



                                if (column === 0 && rowData) {

                                    return rowData.id_fichaje || '';

                                }

                                // Para la columna 3 (por ejemplo), usamos un valor del JSON en vez del HTML

                                if (column === 7 && rowData) {

                                    return rowData.observaciones || '';

                                }



                                return data;

                            }

                        }

                    }

                }



            ],

            "searching": true,

            "ajax": {

                url: './api/fichajes.php', // Ruta que devuelve los datos de los clientes

                method: 'GET',

                cache: false,

                dataSrc: function(json) {

                    console.log(json);

                    var res = json.fichajes

                    $("#fichajes_count").text(res.length)



                    return res;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },



            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado



                //$('#tabla_clientes_aceptados').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "id_fichaje",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre"

                },

                {

                    "data": "fecha_entrada"

                },

                {

                    "data": "horas_descanso",

                    "render": function(data, type, row, meta) {

                        var segundos = data; // Ejemplo de 7325 segundos

                        var resultado = segundosAHorasYMinutos(segundos);





                        return `${resultado.horas} hs, ${resultado.minutos} min`;

                    }

                },

                {

                    "data": "fecha_salida"

                },

                {

                    "data": "estado"

                },

                {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        var fechaInicioStr = data.fecha_entrada;

                        var fechaFinStr = data.fecha_salida;

                        if (fechaInicioStr == null || fechaFinStr == null) {

                            return "Fichaje en curso."

                        }



                        // Convierte las fechas en objetos Moment

                        var fechaInicio = moment(fechaInicioStr, 'YYYY-MM-DD HH:mm:ss');

                        var fechaFin = moment(fechaFinStr, 'YYYY-MM-DD HH:mm:ss');



                        // Calcula la diferencia en minutos

                        var diferenciaMinutos = fechaFin.diff(fechaInicio, 'minutes');



                        // Calcula las horas y minutos

                        var horas = Math.floor(diferenciaMinutos / 60);

                        var minutos = diferenciaMinutos % 60;





                        return `${horas} hs, ${minutos} min`;

                    }

                },

                {

                    "data": "observaciones",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';



                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Observaciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-2';









                        var span = document.createElement('span');



                        span.innerHTML = `${data}`;



                        dropdownMenu.appendChild(span);





                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);

                        if (data != null) {

                            return td.outerHTML;

                        } else {

                            return "Sin observaciones."

                        }



                    }

                },

                {

                    "data": "id_fichaje",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonEditar = document.createElement('button');

                        buttonEditar.className =

                            'btn btn_editar_fichaje p-1 dropdown-item';

                        buttonEditar.type = 'button';

                        buttonEditar.setAttribute('data-id', data);

                        buttonEditar.innerHTML = `

                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Editar

                `;







                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className = 'btn_eliminar_fichaje p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;



                        dropdownMenu.appendChild(buttonEditar);
                        <?php 
                        if ($PermisoRol) {

                                                           

                        ?>



                        dropdownMenu.appendChild(buttonEliminar);

                        <?php
                    } 
                    ?>
                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);

                        // Asignar el evento al botón de editar



                        return td.outerHTML;

                    }

                }

            ]



        });

        async function obtenerIP() {
            const res = await fetch("https://api.ipify.org?format=json");
            const data = await res.json();
            return data.ip;
        }

        function getDeviceType() {
            const ua = navigator.userAgent;
            if (/iPhone|iPad|iPod/i.test(ua)) return "iPhone";
            if (/Android/i.test(ua)) return "Android";
            if (/Windows/i.test(ua)) return "Windows PC";
            if (/Macintosh/i.test(ua)) return "Mac";
            return "Navegador web";
        }

        $("#btn_agregar_fichaje").click(async function() {
            let data = {};
            let isValid = true;

            document.querySelectorAll('#modalAgregarFichaje .validable').forEach(input => {
                const evento = new CustomEvent('validar', {
                    bubbles: true,
                    detail: {
                        mensaje: 'Campo requerido'
                    }
                });
                input.dispatchEvent(evento);
                if (!input.isValid) isValid = false;
            });

            $("#modalAgregarFichaje .campo_fichaje").each(function() {
                const campo = $(this).data("campo");
                const valor = $(this).val();
                if (campo === "horas_descanso") {
                    data[campo] = valor ? valor * 3600 : 0;
                } else {
                    data[campo] = valor ? valor.trim() : null;
                }
            });

            if (!isValid) return false;

            const esDespues = moment(data.fecha_salida).isAfter(moment(data.fecha_entrada));
            const duracion = moment(data.fecha_salida).diff(moment(data.fecha_entrada),
                "seconds");
            const diferencia = duracion - data.horas_descanso;

            if (!esDespues || diferencia <= 0) {
                $.toast({
                    heading: "Horario incorrecto",
                    text: !esDespues ?
                        "La hora de salida debe ser después que la hora de entrada" :
                        "El intervalo de horas de trabajo debe ser mayor que las horas de descanso",
                    position: "top-right",
                    loaderBg: "#fd5f56",
                    icon: "error",
                    hideAfter: 4000,
                    stack: 6,
                });
                return false;
            }

            // 🔽 Obtener IP y tipo de dispositivo
            const ip = await obtenerIP();
            const dispositivo = getDeviceType();

            data.ip_entrada = ip;
            data.dispositivo_entrada = dispositivo;
            data.ip_salida = ip;
            data.dispositivo_salida = dispositivo;
            $("#btn_agregar_fichaje").addClass("btn-loading");

            $.ajax({
                url: "./api/fichajes.php",
                type: "POST",
                dataType: "json",
                cache: false,
                async: false,
                data: data,
                success: function(res) {
                    console.log(res);
                    $("#modalAgregarFichaje").modal("hide");
                    Table.ajax.reload(null, false);

                    $.toast({
                        heading: "Fichaje agregado",
                        text: "Se ha agregado el fichaje correctamente",
                        position: "top-right",
                        loaderBg: "#32a852",
                        icon: "success",
                        hideAfter: 2000,
                        stack: 6,
                    });
                },
            });

            $("#btn_agregar_fichaje").removeClass("btn-loading");
        });


        $(document).on("click", '.btn_editar_fichaje', function() {



            var fichajeId = $(this).data('id');

            abrirModalEditarFichaje(fichajeId)



        });

        // Mostrar el modal de edición y cargar los datos

        function abrirModalEditarFichaje(fichajeId) {

            $.ajax({

                url: "./api/fichajes.php",

                type: "GET",

                dataType: "json",

                async: false,

                cache: false,

                data: {

                    id_fichaje: fichajeId

                },

                success: function(res) {

                    console.log(res);



                    var fichaje = res;

                    $("#btn_editar_fichaje").data("id", fichajeId);

                    // Cargar los datos del fichaje en el modal

                    $("#usuario_fichaje_edit").val(fichaje.id_miembro).trigger(

                        "change");

                    $("#entrada_fichaje_edit").val(moment(fichaje.fecha_entrada).format(

                        'YYYY-MM-DDTHH:mm'));

                    $("#salida_fichaje_edit").val(moment(fichaje.fecha_salida).format(

                        'YYYY-MM-DDTHH:mm'));

                    var f = parseFloat(fichaje.horas_descanso / 3600)



                    console.log(f);



                    $("#horas_descanso_fichaje_edit").val(f).trigger(

                        "change"); // Convertir de segundos a horas

                    $("#observaciones_fichaje_edit").val(fichaje.observaciones).trigger(

                        "change");



                    // Mostrar el modal

                    $('#modalEditarFichaje').modal('show');



                }

            });

        }



        // Guardar los cambios del fichaje

        $("#btn_editar_fichaje").click(async function() {

            let data = {};

            let isValid = true;

            let errorMessage = "";

            const idFichaje = $("#btn_editar_fichaje").data("id");



            // Agregar el id_fichaje al objeto de datos

            data.fichaje_id = idFichaje;

            // Recorrer los inputs con clase `campo_fichaje`
            document.querySelectorAll('#modalEditarFichaje .validable').forEach(
                input => {


                    const evento = new CustomEvent('validar', {
                        bubbles: true,
                        detail: {
                            mensaje: 'Campo requerido'
                        }
                    });

                    // Disparar el evento de validación para cada input
                    input.dispatchEvent(evento);

                    // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                    if (!input.isValid) {
                        isValid = false;
                    }
                });



            $("#modalEditarFichaje .campo_fichaje").each(function() {

                const campo = $(this).data("campo");

                const requerido = $(this).data("requerido");

                const valor = $(this).val();



                // Convertir horas a segundos si es necesario

                if (campo === "horas_descanso") {

                    data[campo] = valor ? valor * 3600 :
                        0; // Convertir horas a segundos

                } else {

                    data[campo] = valor ? valor.trim() : null;

                }



            });

            if (!isValid) {

                return false;

            }

            // Mostrar mensaje de error si no pasa la validación





            // Validar horas de entrada y salida

            const esDespues = moment(data.fecha_salida).isAfter(moment(data.fecha_entrada));

            const duracion = moment(data.fecha_salida).diff(moment(data.fecha_entrada),
                "seconds");

            const diferencia = duracion - data.horas_descanso;



            if (!esDespues) {

                $.toast({

                    heading: "Horario incorrecto",

                    text: "La hora de salida debe ser después que la hora de entrada",

                    position: "top-right",

                    loaderBg: "#fd5f56",

                    icon: "error",

                    hideAfter: 4000,

                    stack: 6,

                });

                return false;

            }



            if (diferencia <= 0) {

                $.toast({

                    heading: "Horario incorrecto",

                    text: "El intervalo de horas de trabajo debe ser mayor que las horas de descanso",

                    position: "top-right",

                    loaderBg: "#fd5f56",

                    icon: "error",

                    hideAfter: 4000,

                    stack: 6,

                });

                return false;

            }

            const ip = await obtenerIP();
            const dispositivo = getDeviceType();

            data.ip_entrada = ip;
            data.dispositivo_entrada = dispositivo;
            data.ip_salida = ip;
            data.dispositivo_salida = dispositivo;

            // Botón en estado cargando

            $("#btn_editar_fichaje").addClass("btn-loading");



            // Enviar datos por AJAX para editar el fichaje

            $.ajax({

                url: "./api/fichajes.php",

                type: "POST", // Se usa PUT para editar

                dataType: "json",

                data: data,

                async: false,

                cache: false,

                success: function(res) {

                    console.log(res);



                    $("#modalEditarFichaje").modal("hide");

                    Table.ajax.reload(null,
                        false); // Recargar la tabla si es necesario



                    $.toast({

                        heading: "Fichaje editado",

                        text: "Se ha editado el fichaje correctamente",

                        position: "top-right",

                        loaderBg: "#32a852",

                        icon: "success",

                        hideAfter: 2000,

                        stack: 6,

                    });

                },

                error: function(xhr, status, error) {

                    $.toast({

                        heading: "Error",

                        text: "Hubo un error al editar el fichaje.",

                        position: "top-right",

                        loaderBg: "#fd5f56",

                        icon: "error",

                        hideAfter: 4000,

                        stack: 6,

                    });

                }

            });

            $("#btn_editar_fichaje").removeClass("btn-loading");

        });





        $("#btn_filtro_fecha").click(function() {

            var fecha_i = $("#fecha_i").val()

            var fecha_f = $("#fecha_f").val()

            console.log(fecha_i);

            console.log(fecha_f);

            if (fecha_i == "" ||

                fecha_f == "") {

                $.toast({

                    heading: 'Complete la fecha.',

                    text: 'Por favor ingresa una fecha.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                $("#fecha_i").focus()

                return false;

            }

            Table.settings()[0].ajax.data = function(data) {

                data.fecha_i = fecha_i; // Establece el valor de fecha_i

                data.fecha_f = fecha_f;

            };

            Table.ajax.reload();

        })

        $(document).on("click", ".btn_eliminar_fichaje", function(e) {







            $("#btn_eliminar_fichaje").data("id", $(this).data("id"))



            $("#modalEliminarFichaje").modal('show');









        })

        $(document).on("click", '#btn_eliminar_fichaje', function(event) {



            var id_fichaje_eliminar = $(this).data("id")





            $.ajax({

                type: 'DELETE',

                url: './api/fichajes.php?id_fichaje=' + id_fichaje_eliminar,

                cache: false,

                async: false,

                success: function(result) {





                    $.toast({

                        heading: 'Fichaje eliminado',

                        text: 'Se ha eliminado el fichaje correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })





                    $('#modalEliminarFichaje').modal('hide');



                    Table.ajax.reload(null, false);





                }

            });



            return false;

        });

    });

})(jQuery);
</script>