<div class="content-wrapper">
    <div class="row profile-page ">
        <div class="col-12 mb-3">
            <div class="card satmar-bottom mb-0">
                <div class="sato-border-blue">
                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/sylzqxek.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>
                        <p class="mb-2">Eventos totales</p>
                        <span id="user_count" class=""></span>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="row profile-page mb-3">
        <div class="col-12">
            <div class="card">
                <div class="" style="padding-bottom: 0px !important;">
                    <div class="pt-0 ">
                        <div class="row ">
                            <div class="col-md-12">
                                <div class="row p-3">
                                    <div class="col-12 col-sm-auto pr-sm-0">
                                        <button type="button" data-toggle="modal" data-target="#modalAgregarEvento"
                                            class="btn btn-sm btn-primary">Agregar</button>
                                    </div>

                                </div>
                                <div class="card card-cuenta">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-12">
                                                <h4 class="mb-0">Listado de Eventos</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body card-table-body p-3">
                                        <div class="row p-0">
                                            <div class="col-auto  ">
                                                <div class="form-group">

                                                    <label>Comercial</label>

                                                    <div class="input-group">

                                                        <span class="input-group-prepend">

                                                            <button
                                                                class="btn_eliminar_comercial file-upload-browse btn btn-danger"
                                                                type="button" data-target="filtro_comercial">-</button>

                                                        </span>

                                                        <select name="filtro_comercial" id="filtro_comercial"
                                                            class="select_comerciales validable form-control custom-select text-center select2">





                                                        </select>

                                                        <span class="input-group-append">
                                                            <button class="btn btn-info" type="button"
                                                                data-toggle="modal"
                                                                data-target="#modalAgregarComercial">+</button>

                                                        </span>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <table id="tabla_eventos" style="min-height:120px;" cellspacing="0"
                                            class="table display nowrap">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Evento</th>
                                                    <th>Cliente</th>
                                                    <th>Camión</th>
                                                    <th>Localización</th>
                                                    <th>Días</th>
                                                    <th style="text-align:center;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>


<?php require_once __VIEWS__ . 'selects/eventos2.template.php'; ?>
<!-- MODALS -->




<script>
(function($) {
    'use strict';
    $(function() {


        $("#filtro_comercial").change(function(e) {

            //$('.tabla_clientes').DataTable().ajax.reload(null, false);

            $('#tabla_eventos').DataTable().ajax.reload(null, false);

        });
        var Table = $('#tabla_eventos').DataTable({
            responsive: true,
            dom: 'Blfrtip',
            aLengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            iDisplayLength: 10,
            language: {
                search: "Buscar",
                emptyTable: "No hay eventos",
                info: "Mostrando _START_ a _END_ de _TOTAL_ eventos",
                infoEmpty: "Mostrando 0 a 0 de 0 eventos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                lengthMenu: "Mostrar _MENU_ entradas",
                processing: "Cargando...",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            stateSave: true,
            stateSaveCallback: function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            order: [
                [0, "desc"]
            ],
            buttons: [{
                extend: 'colvis',
                text: 'Ocultar Columnas',
                collectionLayout: 'fixed two-column',
                className: "form-control"
            }],
            ajax: {
                url: '/api/eventos2.php',
                method: 'GET',
                data: function(d) {

                    // Agregar parámetros adicionales a la solicitud aquí

                    d.id_comercial = $("#filtro_comercial").val();




                },
                dataSrc: function(json) {
                    $("#user_count").text(json.length);
                    return json;
                }
            },
            columns: [{
                    data: "id_evento"
                },
                {
                    data: "nombre"
                },
                {
                    data: "nombre_cliente"
                },
                {
                    data: "matricula"
                }, // Opcional: podés hacer un JOIN y mostrar nombre
                {
                    data: "localizacion"
                },
                {
                    data: "dias",
                    render: function(data) {
                        if (!Array.isArray(data) || data.length === 0) return "—";

                        const grupos = agruparFechasConsecutivas(data);

                        return grupos.map(grupo => {
                            const desde = grupo[0];
                            const hasta = grupo[grupo.length - 1];
                            return `${desde} al ${hasta} (${grupo.length} días)`;
                        }).join(", ");
                    }
                },
                {
                    data: null,
                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');



                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'btn_edit_evento p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data.id_evento);

                        buttonEditar.innerHTML = `

                        <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000"
                            style="width:30px;height:30px"></lord-icon>

                        Editar

                        `;


                        var buttonAceptar = document.createElement('button');

                        buttonAceptar.className = 'btn_materiales_evento p-1 dropdown-item';

                        buttonAceptar.setAttribute('type', 'button');

                        buttonAceptar.setAttribute('data-id', data.id_evento);

                        buttonAceptar.innerHTML = `

                    <lord-icon src="./assets/lordicons/parlan.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Materiales

                `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =
                            'btn_eliminar_evento p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data.id_evento);

                        buttonEliminar.innerHTML = `

                        <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000"
                            style="width:30px;height:30px"></lord-icon>

                        Eliminar

                        `;
                        var buttonFotos = document.createElement('button');

                        buttonFotos.className =
                            'btn_modal_archivos_eventos p-1 dropdown-item';

                        buttonFotos.setAttribute('type', 'button');

                        buttonFotos.setAttribute('data-id', data.id_evento);

                        buttonFotos.innerHTML = `

                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Documentos

                `;
                        var buttonPersonal = document.createElement('button');

                        buttonPersonal.className =
                            'btn_personal p-1 dropdown-item';

                        buttonPersonal.setAttribute('type', 'button');

                        buttonPersonal.setAttribute('data-id', data.id_evento);

                        buttonPersonal.innerHTML = `

                    <lord-icon src="./assets/lordicons/users.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Personal

                `;
                        if (data.presupuesto != null) {
                            var buttonPre = document.createElement('button');

                            buttonPre.className =
                                'btn_presupuesto_evento p-1 dropdown-item';

                            buttonPre.setAttribute('type', 'button');

                            buttonPre.setAttribute('data-id', data.id_evento);
                            buttonPre.setAttribute('data-pre', data.presupuesto
                                .id_presupuesto);
                            buttonPre.setAttribute('data-e', data.presupuesto
                                .estado);
                            buttonPre.innerHTML = `

                    <lord-icon src="./assets/lordicons/pre.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                   Ver presupuesto

                `;
                            if (data.presupuesto.estado == "Aceptado") {
                                if (data.factura != null) {
                                    var buttonFac = document.createElement('button');

                                    buttonFac.className =
                                        'btn_factura_evento p-1 dropdown-item';

                                    buttonFac.setAttribute('type', 'button');

                                    buttonFac.setAttribute('data-id', data.id_evento);
                                    buttonFac.setAttribute('data-pre', data.factura
                                        .id_factura_manual_materiales);
                                    buttonFac.setAttribute('data-numero', data.factura
                                        .numero);
                                    buttonFac.innerHTML = `

                                        <lord-icon src="./assets/lordicons/pre.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                                    Ver factura

                                    `;

                                } else {
                                    var buttonFac = document.createElement('a');

                                    buttonFac.className = 'p-1 dropdown-item';

                                    buttonFac.href =
                                        `./crear_factura_manual_materiales?id_presupuesto=${data.presupuesto
                                .id_presupuesto}`;

                                    buttonFac.innerHTML = `

                                    <lord-icon src="./assets/lordicons/pre.json" trigger="hover" colors="primary:#00000,secondary:#000000"
                                        style="width:30px;height:30px"></lord-icon>

                                        Crear factura

                                            `;

                                }
                                dropdownMenu.appendChild(buttonFac);
                            }
                        } else {
                            var buttonPre = document.createElement('a');

                            buttonPre.className = 'p-1 dropdown-item';

                            buttonPre.href =
                                `./crear_presupuesto_materiales?id_evento=${data.id_evento}`;

                            buttonPre.innerHTML = `

            <lord-icon src="./assets/lordicons/pre.json" trigger="hover" colors="primary:#00000,secondary:#000000"
                style="width:30px;height:30px"></lord-icon>

           Crear presupuesto

            `;

                        }
                        dropdownMenu.appendChild(buttonPre);
                        dropdownMenu.appendChild(buttonPersonal);

                        dropdownMenu.appendChild(buttonAceptar);

                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonFotos);
                        dropdownMenu.appendChild(buttonEliminar);

                        //     dropdownMenu.appendChild(buttonCambiarEstado);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }
                }
            ]
        });

        function agruparFechasConsecutivas(fechas) {
            if (!fechas.length) return [];
            fechas.sort();

            const grupos = [];
            let grupoActual = [fechas[0]];

            for (let i = 1; i < fechas.length; i++) {
                const fechaPrev = new Date(fechas[i - 1]);
                const fechaActual = new Date(fechas[i]);

                if ((fechaActual - fechaPrev) === 86400000) {
                    grupoActual.push(fechas[i]);
                } else {
                    grupos.push(grupoActual);
                    grupoActual = [fechas[i]];
                }
            }
            grupos.push(grupoActual);
            return grupos;
        }

    });
})(jQuery);
</script>