<div class="content-wrapper">

    <div class="row profile-page ">

        <div class="col-md-12 mb-8">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/ojhwrqyr.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Equipo</p>

                        <span id="miembros_count">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div class="row profile-page">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0 ">

                        <div class="row ">

                            <!-- Historial de Acceso -->

                            <div class="col-md-12">

                                <button data-toggle="modal" data-target="#modalAgregarMiembro"
                                    class="m-3 btn btn-sm btn-primary">Agregar</button>

                                <div class="card card-cuenta">

                                    <div class="card-body card-table-body p-3">

                                        <table id="tabla_equipo" class="tabla_equipo table display nowrap">

                                            <thead>

                                                <tr>

                                                    <th
                                                        style="padding-left: 32px !important;padding-right: 50px !important;">

                                                        ID</th>

                                                    <th>Nombre</th>

                                                    <th>Email</th>

                                                    <th>Estado</th>

                                                    <th style="text-align:center;">Acciones</th>

                                                </tr>

                                            </thead>

                                            <tbody>

                                            </tbody>

                                        </table>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminación de cuenta -->

                            <!-- /Eliminación de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<!-- MODALS -->

<div class="modal fade" id="modalAgregarMiembro" role="dialog" aria-labelledby="exampleModalCenterTitle">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar miembro al sistema de fichajes</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">
                        <div class="col-sm-4">
                            <label class="custom-control custom-checkbox d-inline-block"
                                style="height: auto;min-height: unset;">
                                <input type="checkbox" id="crear_usuario" class="custom-control-input apartado">
                                <span class="custom-control-label" style="font-size: 17px;">Crear usuario nuevo a partir
                                    de un email</span></label>
                            <div class="form-group">

                                <label>Email</label>

                                <input type="text" class="form-control" id="email_miembro" placeholder="" disabled>

                            </div>
                        </div>
                    </div>

                    <div class="row" id="datos_miembro">

                        <div class="col-sm-4" id="col_miembro">

                            <div class="form-group">

                                <label>Usuario</label>

                                <select id="user_id_miembro"
                                    class="form-control custom-select text-center select2 select_users">

                                    <?php

                                    foreach ($UsuariosDisponibles as $User)

                                        {

                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>

                                    <?php } ?>

                                </select>

                            </div>

                        </div>

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>DNI</label>

                                <input type="text" class="form-control" id="dni_miembro" placeholder="" required>

                            </div>

                        </div>

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>Precio hora</label>

                                <input type="number" class="form-control" id="precio_hora_miembro" placeholder=""
                                    required>

                            </div>

                        </div>

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>Precio horas extra</label>

                                <input type="number" class="form-control" id="precio_horas_extra_miembro" placeholder=""
                                    required>

                            </div>

                        </div>

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>Dirección (Calle Número Ciudad)</label>

                                <input type="text" class="form-control validable" id="direccion_miembro" placeholder=""
                                    required>

                            </div>

                        </div>
                        <div class="col-12">
                            <div class="row">

                                <div class="col-12">

                                    <h5>Marcar como anomalía si cumple las siguientes

                                        condiciones

                                    </h5>

                                </div>

                                <div class="col-sm-12">

                                    <div class="form-group d-flex align-items-end">

                                        <label class="mr-2">Notificar cercania de casa si es inferior a</label>

                                        <input style="max-width:50px;" value="1" type="number" class="form-control"
                                            name="kilometros_casa" id="kilometros_casa">

                                        <label class="ml-2">kilómetros</label>

                                        <label
                                            style="padding-left: 35px; padding-bottom: 0px;padding-top: 5px!important;"
                                            class="custom-control custom-checkbox d-inline-block">

                                            <input type="checkbox" id="check_kilometros_casa"
                                                class="custom-control-input">

                                            <span class="custom-control-label"></span>

                                        </label>

                                    </div>

                                </div>

                                <div class="col-sm-12">

                                    <div class="form-group d-flex align-items-end">

                                        <label class="mr-2">Notificar si empieza el fichaje fuera de</label>

                                        <input style="max-width:50px;" value="1" type="number" class="form-control"
                                            id="kilometros_calle">

                                        <label class="ml-2">kilómetros</label>

                                        <label
                                            style="padding-left: 35px; padding-bottom: 0px;padding-top: 5px!important;"
                                            class="custom-control custom-checkbox d-inline-block">

                                            <input type="checkbox" id="check_kilometros_calle"
                                                class="custom-control-input">

                                            <span class="custom-control-label"></span>

                                        </label>

                                    </div>

                                    <div class="form-group d-flex align-items-end">

                                        <label class="mr-2">de la siguiente dirección (Calle Número Ciudad)</label>

                                        <input style="max-width:250px;" value="" type="text"
                                            class="form-control validable" name="" id="calle_anomalia">

                                    </div>

                                </div>


                            </div>

                        </div>

                    </div>

                    <div class="row mb-4">

                        <div class="col-12">

                            <h5 class="mb-4">Jornada laboral</h5>

                        </div>

                        <div class="col-12 mb-4">

                            <button id="btn_configurar_general" class="mr-2 btn btn-sm btn-primary">Copiar</button>

                            <span class="d-inline-block">Configurar un horario general para

                                todos los

                                días</span>

                        </div>

                        <div id="col_completa" class="col-lg-6">

                            <div class="row">

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general_s">

                                    </div>

                                </div>

                            </div>

                            <div class="row">

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="lunes" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Lunes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="martes" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Martes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="miercoles" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Miércoles</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="jueves" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Jueves</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="viernes" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Viernes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="sabado" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Sábado</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="domingo" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Domingo</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo_s">

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div id="col_parcial" class="col-lg-6">

                            <div class="row">

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general2_s">

                                    </div>

                                </div>

                            </div>

                            <div class="row">

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="lunes2" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Lunes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes2_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="martes2" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Martes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes2_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="miercoles2" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Miércoles</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles2_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="jueves2" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Jueves</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves2_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="viernes2" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Viernes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes2_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="sabado2" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Sábado</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado2_s">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="domingo2" class="custom-control-input habilitar"
                                            checked>

                                        <span class="custom-control-label">Domingo</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo2_e">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo2_s">

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button class="btn btn-success btn-fw" id="btn_agregar_miembro" type="button">

                    Guardar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEliminarMiembro" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->

                <p class="">¿Estás seguro de que deseas eliminar el miembro definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">

                <button id="btn_eliminar_miembro" class="btn btn-danger btn-fw" type="button" name="">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalEditarMiembro" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Editar miembro</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>DNI</label>

                                <input type="text" class="form-control" id="dni_miembro_editar" placeholder="" required>

                            </div>

                        </div>

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>Precio hora</label>

                                <input type="number" class="form-control" id="precio_hora_miembro_editar" placeholder=""
                                    required>

                            </div>

                        </div>

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>Precio horas extra</label>

                                <input type="number" class="form-control" id="precio_horas_extra_miembro_editar"
                                    placeholder="" required>

                            </div>

                        </div>

                        <div class="col-sm-4">

                            <div class="form-group">

                                <label>Dirección (Calle Número Ciudad)</label>

                                <input type="text" class="form-control validable" id="direccion_miembro_editar"
                                    placeholder="" required>

                            </div>

                        </div>
                        <div class="col-12" id="datos_miembro_edit">
                            <div class="row">

                                <div class="col-12">

                                    <h5>Marcar como anomalía si cumple las siguientes

                                        condiciones

                                    </h5>

                                </div>

                                <div class="col-sm-12">

                                    <div class="form-group d-flex align-items-end">

                                        <label class="mr-2">Notificar cercania de casa si es inferior a</label>

                                        <input style="max-width:50px;" value="1" type="number" class="form-control"
                                            id="kilometros_casa_editar">

                                        <label class="ml-2">kilómetros</label>

                                        <label
                                            style="padding-left: 35px; padding-bottom: 0px;padding-top: 5px!important;"
                                            class="custom-control custom-checkbox d-inline-block">

                                            <input type="checkbox" id="check_kilometros_casa_editar"
                                                class="custom-control-input">

                                            <span class="custom-control-label"></span>

                                        </label>

                                    </div>

                                </div>

                                <div class="col-sm-12">

                                    <div class="form-group d-flex align-items-end">

                                        <label class="mr-2">Notificar si empieza el fichaje fuera de</label>

                                        <input style="max-width:50px;" value="1" type="number" class="form-control"
                                            name="kilometros_calle_editar" id="kilometros_calle_editar">

                                        <label class="ml-2">kilómetros</label>

                                        <label
                                            style="padding-left: 35px; padding-bottom: 0px;padding-top: 5px!important;"
                                            class="custom-control custom-checkbox d-inline-block">

                                            <input type="checkbox" id="check_kilometros_calle_editar"
                                                class="custom-control-input">

                                            <span class="custom-control-label"></span>

                                        </label>

                                    </div>

                                    <div class="form-group d-flex align-items-end">

                                        <label class="mr-2">de la siguiente dirección (Calle Número Ciudad)</label>

                                        <input style="max-width:250px;" value="" type="text"
                                            class="form-control validable" name="" id="calle_anomalia_editar">

                                    </div>

                                </div>

                            </div>
                        </div>

                    </div>



                    <div class="row mb-4">

                        <div class="col-12">

                            <h5 class="mb-4">Jornada laboral</h5>

                        </div>

                        <div class="col-12 mb-4">

                            <button id="btn_configurar_general_editar"
                                class="mr-2 btn btn-sm btn-primary">Copiar</button>

                            <span class="d-inline-block">Configurar un horario general para

                                todos los

                                días</span>

                        </div>

                        <div id="col_completa" class="col-lg-6">

                            <div class="row">

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general_s_editar">

                                    </div>

                                </div>

                            </div>

                            <div class="row">

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="lunes_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Lunes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="martes_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Martes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="miercoles_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Miércoles</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="jueves_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Jueves</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="viernes_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Viernes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="sabado_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Sábado</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="domingo_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Domingo</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo_s_editar">

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div id="col_parcial" class="col-lg-6">

                            <div class="row">

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="general2_s_editar">

                                    </div>

                                </div>

                            </div>

                            <div class="row">

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="lunes2_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Lunes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="lunes2_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="martes2_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Martes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="martes2_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="miercoles2_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Miércoles</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="miercoles2_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="jueves2_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Jueves</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="jueves2_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="viernes2_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Viernes</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="viernes2_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="sabado2_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Sábado</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="sabado2_s_editar">

                                    </div>

                                </div>

                                <div class="col-12">

                                    <label class="custom-control custom-checkbox d-inline-block mb-3">

                                        <input type="checkbox" id="domingo2_editar"
                                            class="custom-control-input habilitar_editar" checked>

                                        <span class="custom-control-label">Domingo</span>

                                    </label>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo2_e_editar">

                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">

                                        <input type="time" class="form-control validable" id="domingo2_s_editar">

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button class="btn btn-success btn-fw" id="btn_editar_miembro" type="button">

                    Guardar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<script async
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCWWOfka8SjiT9Duq-FEYJON1zYftnN7LI&libraries=places&callback=AutoComplete">

</script>

<script>
function AutoComplete() {

    var autocomplete;

    var autocomplete_editar;

    var input = document.getElementById('direccion_miembro')

    var input_editar = document.getElementById('direccion_miembro_editar')

    var input2 = document.getElementById('calle_anomalia')

    var input2_editar = document.getElementById('calle_anomalia_editar')

    var options = {

        types: ['address'],

        componentRestrictions: {

            country: ["es", "ar"]

        }

    };

    autocomplete = new google.maps.places.Autocomplete(input, options);

    autocomplete_editar = new google.maps.places.Autocomplete(input_editar, options);

    autocomplete2 = new google.maps.places.Autocomplete(input2, options);

    autocomplete2_editar = new google.maps.places.Autocomplete(input2_editar, options);

}

function validarDireccion(direccion) {

    return new Promise(function(resolve, reject) {

        var geocoder = new google.maps.Geocoder();

        geocoder.geocode({

            'address': direccion

        }, function(results, status) {

            if (status === 'OK') {

                // La dirección es válida

                resolve(true);

            } else {

                // La dirección no es válida

                resolve(false);

            }

        });

    });

}

var inputs = document.querySelectorAll(

    "#direccion_miembro, #direccion_miembro_editar, #calle_anomalia, #calle_anomalia_editar")

for (let input of inputs) {

    input.addEventListener('change', function() {

        var direccion = this.value;

        var self = this; // Capturamos el input actual

        console.log(direccion);

        validarDireccion(direccion)

            .then(function(esValida) {

                if (esValida) {

                    console.log('La dirección es válida.');

                    $.toast({

                        heading: 'La dirección es válida.',

                        text: 'La dirección ingresada corresponde con un domicilio.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                } else {

                    self.value = ""; // Limpiamos el valor del input

                    $.toast({

                        heading: 'La dirección no es válida.',

                        text: 'Por favor selecciona una de las opciones sugeridas.',

                        position: 'top-right',

                        loaderBg: '#ff5c6c',

                        icon: 'error',

                        hideAfter: 5000,

                        stack: 6

                    });

                }

            });

    });

}
</script>

<style>
.pac-container {

    background-color: #FFF;

    z-index: 10000;

    position: fixed;

    display: inline-block;

    float: left;

}
</style>

<script>
(function($) {

    'use strict';

    $(function() {

    });

})(jQuery);
</script>

<script>
(function($) {

    'use strict';

    $(function() {

        $('#crear_usuario').change(function(event) {

            if ($(this).prop("checked")) {

                $('#email_miembro').attr("disabled", false)
                $('#col_miembro').addClass("d-none")

            } else {

                $('#email_miembro').attr("disabled", true)
                $('#col_miembro').removeClass("d-none")
            }

        })

        var Table = $('.tabla_equipo').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, -1],

                [10, 25, 50, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en alumnos",

                infoEmpty: "Mostrando 0 a 0 de 0 en alumnos",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",

                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [

                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                }

            ],

            "searching": true,

            "ajax": {

                url: './api/fichajes.php', // Ruta que devuelve los datos de los clientes

                method: 'GET',

                cache: false,

                dataSrc: function(json) {

                    var res = json.miembros

                    $("#miembros_count").text(res.length)

                    return res;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },

            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "id_miembro",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre"

                },

                {

                    "data": null,

                    "render": function(data, type, row) {
                        if (data.user_id == null) {
                            return data.email;
                        } else {
                            return data.email_u;
                        }

                    }
                },

                {

                    "data": "estado"

                },

                {

                    "data": null,

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'btn_editar_miembro p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data.id_miembro);

                        buttonEditar.setAttribute('data-user_id', data.user_id);

                        buttonEditar.innerHTML = `

                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Editar

                `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className = 'btn_eliminar_miembro p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data.id_miembro);

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;

                        var linkVerPerfil = document.createElement('a');

                        linkVerPerfil.className = 'p-1 dropdown-item';

                        linkVerPerfil.href = `./profile?id=${data.user_id}`;

                        linkVerPerfil.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#00000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Ver Perfil

                `;

                        var linkVerPerfil2 = document.createElement('a');

                        linkVerPerfil2.className = 'p-1 dropdown-item';

                        linkVerPerfil2.href = `./estadisticas?id=${data.id_miembro}`;

                        linkVerPerfil2.innerHTML = `

                    <lord-icon src="./assets/lordicons/user.json" trigger="hover" colors="primary:#00000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Ver estadísticas

                `;

                        dropdownMenu.appendChild(linkVerPerfil);
                        dropdownMenu.appendChild(linkVerPerfil2);

                        dropdownMenu.appendChild(buttonEditar);

                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }

                }

            ]

        });

        $("#general_e").val("08:00")

        $("#general_s").val("12:00")

        $("#general2_e").val("14:00")

        $("#general2_s").val("20:00")

        $("#general_e_editar").val("08:00")

        $("#general_s_editar").val("12:00")

        $("#general2_e_editar").val("14:00")

        $("#general2_s_editar").val("20:00")

        $("#btn_configurar_general").click(function() {

            var entrada = $("#general_e").val()

            var salida = $("#general_s").val()

            var entrada2 = $("#general2_e").val()

            var salida2 = $("#general2_s").val()

            $(".habilitar").each(function() {

                var id = $(this).attr("id");

                if (!id.includes("2")) {

                    $("#" + id + "_e").val(entrada)

                    $("#" + id + "_s").val(salida)

                } else {

                    $("#" + id + "_e").val(entrada2)

                    $("#" + id + "_s").val(salida2)

                }

            });

        })

        $("#btn_configurar_general_editar").click(function() {

            var entrada = $("#general_e_editar").val()

            var salida = $("#general_s_editar").val()

            var entrada2 = $("#general2_e_editar").val()

            var salida2 = $("#general2_s_editar").val()

            $(".habilitar_editar").each(function() {

                var id = $(this).attr("id");

                id = id.replace(new RegExp("_editar", "gi"), '');

                if (!id.includes("2")) {

                    $("#" + id + "_e_editar").val(entrada)

                    $("#" + id + "_s_editar").val(salida)

                } else {

                    $("#" + id + "_e_editar").val(entrada2)

                    $("#" + id + "_s_editar").val(salida2)

                }

            });

        })

        $("#btn_agregar_miembro").click(function() {

            var user_email = ($("#crear_usuario").prop("checked")) ? $("#email_miembro").val() :
                "No"

            var user_id = (!$("#crear_usuario").prop("checked")) ? $("#user_id_miembro").val() :
                "No"

            var dni = $("#dni_miembro").val()

            var precio_hora = $("#precio_hora_miembro").val()

            var precio_horas_extra = $("#precio_horas_extra_miembro").val()

            var direccion = $("#direccion_miembro").val()

            var kilometros_casa = ($("#check_kilometros_casa").prop("checked")) ? $(

                "#kilometros_casa").val() : ""

            var kilometros_calle = ($("#check_kilometros_calle").prop("checked")) ? $(

                "#kilometros_calle").val() : ""

            var calle = $("#calle_anomalia").val()

            var jornada = {}

            var sigue = true
            document.querySelectorAll('#datos_miembro .validable').forEach(input => {

                const evento = new CustomEvent('validar', {
                    bubbles: true,
                    detail: {
                        mensaje: 'Campo requerido'
                    }
                });

                // Disparar el evento de validación para cada input
                input.dispatchEvent(evento);

                // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                if (!input.isValid) {
                    sigue = true;
                }
            });


            $(".habilitar").each(function() {

                var id = $(this).attr("id");

                var checked = $(this).prop("checked");

                var nombre_entrada = id + "_e";

                var nombre_salida = id + "_s";

                if (checked) {

                    if ($("#" + id + "_e").val() == "") {

                        var input = document.getElementById(id + "_e");

                        // Dispara el evento de validación
                        const evento = new CustomEvent('validar', {
                            bubbles: true,
                            detail: {
                                mensaje: 'Campo requerido'
                            }
                        });

                        // Disparar el evento de validación para cada input
                        input.dispatchEvent(evento);

                        sigue = false

                        return false;

                    }

                    if ($("#" + id + "_s").val() == "") {

                        var input = document.getElementById(id + "_s");

                        // Dispara el evento de validación
                        const evento = new CustomEvent('validar', {
                            bubbles: true,
                            detail: {
                                mensaje: 'Campo requerido'
                            }
                        });

                        // Disparar el evento de validación para cada input
                        input.dispatchEvent(evento);

                        sigue = false

                        return false;

                    }

                    jornada[nombre_entrada] = $("#" + id + "_e").val()

                    jornada[nombre_salida] = $("#" + id + "_s").val()

                } else {

                    jornada[nombre_entrada] = ""

                    jornada[nombre_salida] = ""

                }

            });

            if (!sigue) {

                return false

            }

            $("#btn_agregar_miembro").addClass("btn-loading")

            console.log(jornada);

            $.ajax({

                url: "./api/fichajes.php",

                type: 'POST',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                data: {
                    user_email: user_email,
                    user_id: user_id,

                    dni: dni,

                    precio_hora: precio_hora,

                    precio_horas_extra: precio_horas_extra,

                    direccion: direccion,

                    kilometros_casa: kilometros_casa,

                    kilometros_calle: kilometros_calle,

                    calle: calle,

                    jornada: JSON.stringify(jornada)

                },

                success: function(res) {
                    $("#btn_agregar_miembro").removeClass("btn-loading")
                    console.log(res);
                    if (res == 0) {

                        $.toast({

                            heading: 'Error al agregar miembro',

                            text: 'El usuario ya se encuentra agregado al sistema de fichajes',

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 2000,

                            stack: 6

                        });

                        return false;

                    }

                    Table.ajax.reload(null, false);

                    $("#modalAgregarMiembro").modal("hide")

                    $(".select_users").each(function() {

                        $(this).find("option[value='" +

                                user_id + "']").remove()

                            .trigger(

                                "change");

                    })

                    $.toast({

                        heading: 'Usuario agregado al sistema de fichajes',

                        text: 'Se ha agregado el miembro de equipo correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                }

            });

        })

        $(document).on("click", ".btn_eliminar_miembro", function(e) {

            $("#btn_eliminar_miembro").data("id", $(this).data("id"))

            $("#modalEliminarMiembro").modal('show');

        })

        $(document).on("click", '#btn_eliminar_miembro', function(event) {

            var id_miembro_eliminar = $(this).data("id")

            $.ajax({

                type: 'DELETE',

                url: './api/fichajes.php?id_miembro=' + id_miembro_eliminar,

                cache: false,

                async: false,

                success: function(result) {

                    $.toast({

                        heading: 'Miembro eliminado',

                        text: 'Se ha eliminado el usuario del sistema de fichajes correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    $('#modalEliminarMiembro').modal('hide');

                    Table.ajax.reload(null, false);

                }

            });

            return false;

        });

        $(document).on("click", ".btn_editar_miembro", function(event) {

            $("#btn_editar_miembro").data("id", $(this).data("id"));

            $("#btn_editar_miembro").data("user_id", $(this).data("user_id"));

            $.ajax({

                url: './api/fichajes.php?id_miembro=' + $(this).data("id"),

                type: 'GET',

                cache: false,

                async: false,

                dataType: 'json', // added data type

                success: function(miembro) {

                    $('#modalEditarMiembro').modal('show')

                    $("#dni_miembro_editar").val(miembro.dni)

                    $("#precio_hora_miembro_editar").val(miembro.precio_hora)

                    $("#precio_horas_extra_miembro_editar").val(miembro

                        .precio_horas_extra)

                    $("#direccion_miembro_editar").val(miembro.direccion)

                    $("#kilometros_casa_editar").val(miembro.kilometros_casa)

                    $("#kilometros_calle_editar").val(miembro.kilometros_calle)

                    if (miembro.kilometros_casa != null) {

                        document.getElementById("check_kilometros_casa_editar")

                            .setAttribute(

                                'checked', "checked");

                    } else {

                        document.getElementById('check_kilometros_casa_editar')

                            .removeAttribute(

                                "checked");

                    }

                    if (miembro.kilometros_calle != null) {

                        document.getElementById("check_kilometros_calle_editar")

                            .setAttribute(

                                'checked', "checked");

                    } else {

                        document.getElementById('check_kilometros_calle_editar')

                            .removeAttribute(

                                "checked");;

                    }

                    $("#calle_anomalia_editar").val(miembro.calle)

                    console.log(miembro);

                    var entrada = $("#general_e_editar").val()

                    var salida = $("#general_s_editar").val()

                    var entrada2 = $("#general2_e_editar").val()

                    var salida2 = $("#general2_s_editar").val()

                    $(".habilitar_editar").each(function() {

                        var id = $(this).attr("id");

                        id = id.replace(new RegExp("_editar", "gi"), '');

                        if (miembro.jornada[id + "_e"] != null) {

                            $(this).attr('checked', true);

                            if (!id.includes("2")) {

                                $("#" + id + "_e_editar").val(miembro

                                    .jornada[id +

                                        "_e"])

                                $("#" + id + "_s_editar").val(miembro

                                    .jornada[id +

                                        "_s"])

                            } else {

                                $("#" + id + "_e_editar").val(miembro

                                    .jornada[id +

                                        "_e"])

                                $("#" + id + "_s_editar").val(miembro

                                    .jornada[id +

                                        "_s"])

                            }

                        } else {

                            $(this).removeAttr("checked");

                        }

                    });

                }

            });

        })

        $("#btn_editar_miembro").click(function() {

            var id_miembro = $(this).data("id")

            var user_id = $(this).data("user_id")
            var user_email = "No"
            var dni = $("#dni_miembro_editar").val()

            var precio_hora = $("#precio_hora_miembro_editar").val()

            var precio_horas_extra = $("#precio_horas_extra_miembro_editar").val()

            var direccion = $("#direccion_miembro_editar").val()

            var kilometros_casa = ($("#check_kilometros_casa_editar").prop("checked")) ? $(

                "#kilometros_casa_editar").val() : ""

            var kilometros_calle = ($("#check_kilometros_calle_editar").prop("checked")) ? $(

                "#kilometros_calle_editar").val() : ""

            var calle = $("#calle_anomalia_editar").val()

            var jornada = {}

            var sigue = true
            document.querySelectorAll('#datos_miembro_edit .validable').forEach(input => {

                const evento = new CustomEvent('validar', {
                    bubbles: true,
                    detail: {
                        mensaje: 'Campo requerido'
                    }
                });

                // Disparar el evento de validación para cada input
                input.dispatchEvent(evento);

                // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                if (!input.isValid) {
                    sigue = true;
                }
            });
            $(".habilitar_editar").each(function() {

                var id = $(this).attr("id");

                id = id.replace(new RegExp("_editar", "gi"), '');

                var checked = $(this).prop("checked");

                console.log(checked);

                var nombre_entrada = id + "_e";

                var nombre_salida = id + "_s";

                if (checked) {

                    if ($("#" + id + "_e_editar").val() == "") {

                        var input = document.getElementById(id + "_e_editar");

                        // Dispara el evento de validación
                        const evento = new CustomEvent('validar', {
                            bubbles: true,
                            detail: {
                                mensaje: 'Campo requerido'
                            }
                        });

                        // Disparar el evento de validación para cada input
                        input.dispatchEvent(evento);

                        sigue = false

                        return false;

                    }

                    if ($("#" + id + "_s_editar").val() == "") {

                        var input = document.getElementById(id + "_s_editar");

                        // Dispara el evento de validación
                        const evento = new CustomEvent('validar', {
                            bubbles: true,
                            detail: {
                                mensaje: 'Campo requerido'
                            }
                        });

                        // Disparar el evento de validación para cada input
                        input.dispatchEvent(evento);

                        sigue = false

                        return false;

                    }

                    jornada[nombre_entrada] = $("#" + id + "_e_editar").val()

                    jornada[nombre_salida] = $("#" + id + "_s_editar").val()

                } else {

                    jornada[nombre_entrada] = ""

                    jornada[nombre_salida] = ""

                }

            });

            if (!sigue) {

                return false

            }

            console.log(jornada);

            console.log(id_miembro);

            $("#btn_editar_miembro").addClass("btn-loading")

            $.ajax({

                url: "./api/fichajes.php",

                type: 'POST',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                data: {
                    user_email: user_email,
                    user_id: user_id,

                    dni: dni,

                    precio_hora: precio_hora,

                    precio_horas_extra: precio_horas_extra,

                    direccion: direccion,

                    kilometros_casa: kilometros_casa,

                    kilometros_calle: kilometros_calle,

                    calle: calle,

                    jornada: JSON.stringify(jornada),

                    id_miembro: id_miembro

                },

                success: function(res) {

                    console.log(res);

                    $("#btn_editar_miembro").removeClass("btn-loading")

                    Table.ajax.reload(null, false);

                    $("#modalEditarMiembro").modal("hide")

                    $.toast({

                        heading: 'Miembro editado.',

                        text: 'Se ha editado el miembro de equipo correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                }

            });

        })

    });

})(jQuery);
</script>