<div class="content-wrapper">

    <div class="row profile-page ">

        <div class="col-12 mb-8">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/dgiidarp.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Clientes notificados</p>

                        <span id="notificados_count">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div class="row profile-page">

        <div class="col-lg-8 mb-3 mb-sm-3 mb-lg-0">

            <div class="card p-3 p-sm-3 h-100">

                <div class="row">

                    <div class="col-12">

                        <div class="row">

                            <div class="col-xl-6">

                                <div class="form-group">
                                    <label for="my-input">Ciudad</label>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_poblacion file-upload-browse btn btn-danger"
                                                data-target="select_poblaciones" type="button">-</button>
                                        </span>
                                        <select id="select_poblaciones"
                                            class="select_poblaciones custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarPoblacion">+</button>
                                        </span>
                                    </div>
                                </div>

                            </div>

                            <div class="col-xl-6">

                                <div class="form-group ">

                                    <label for="my-input">Sexo</label>

                                    <select id="select_sexo" class="w-100 select custom-select form-control">

                                        <option value="Todos">Todos</option>

                                        <option value="Hombre">Hombre</option>

                                        <option value="Mujer">Mujer</option>

                                        <option value="Otro">Otro</option>

                                    </select>

                                </div>

                            </div>

                            <div class="col-xl-6">

                                <div class="form-group">

                                    <label for="my-input">Grupo</label>

                                    <div class="input-group">

                                        <span class="input-group-prepend">

                                            <button class="btn_eliminar_grupo file-upload-browse btn btn-danger"
                                                data-target="select_grupos2" type="button">-</button>

                                        </span>

                                        <select id="select_grupos2"
                                            class="select_grupos custom-select select2 form-control">

                                        </select>

                                        <span class="input-group-append">

                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarGrupo">+</button>

                                        </span>

                                    </div>

                                </div>

                            </div>

                            <div class="col-xl-6">

                                <div class="form-group ">

                                    <label for="my-input">Estado</label>

                                    <select id="select_activo" class="w-100 select custom-select form-control">

                                        <option selected type="text" value="Todos">Todos</option>

                                        <option type="text" value="Activo">Activo</option>

                                        <option type="text" value="Inactivo">Inactivo</option>

                                    </select>

                                </div>

                            </div>

                            <div class="col-xl-6">

                                <div class="form-group ">

                                    <label class="custom-control custom-checkbox d-inline-block mb-2"
                                        style="height: auto;min-height: unset;">

                                        <input type="checkbox" class="custom-control-input apartado" id="filtro_edad">

                                        <span style="font-size: 14px;" class="custom-control-label">Rango de edad</span>

                                    </label>

                                    <div class="input-group">

                                        <input class="mr-1 form-control" id="edad_minima" type="number" name=""
                                            placeholder="Edad mínima" disabled>

                                        <input class="ml-1 form-control" id="edad_maxima" type="number" name=""
                                            placeholder="Edad máxima" disabled>

                                    </div>

                                </div>

                            </div>

                            <div class="col-xl-6">

                                <div class="form-group ">

                                    <label class="custom-control custom-checkbox d-inline-block mb-2"
                                        style="height: auto;min-height: unset;">

                                        <input type="checkbox" class="custom-control-input apartado" id="filtro_cp">

                                        <span style="font-size: 14px;" class="custom-control-label">Rango de códigos

                                            postales</span>

                                    </label>

                                    <div class="input-group">

                                        <input class="mr-1 form-control" id="cp_minimo" type="number" pattern="^\d{5}$"
                                            title="El código postal debe tener 5 dígitos" name=""
                                            placeholder="CP mínimo" disabled>

                                        <input class="ml-1 form-control" id="cp_maximo" type="number" pattern="^\d{5}$"
                                            title="El código postal debe tener 5 dígitos" name=""
                                            placeholder="CP máximo" disabled>

                                    </div>

                                </div>

                            </div>

                            <div class="col-12 mb-3">
                                <button type="button" class="mr-1 btn btn-success" id="btn_marcar_todos">Habilitar
                                    todos</button>
                                <button type="button" class="btn btn-danger" id="btn_desmarcar_todos">Deshabilitar
                                    todos</button>

                            </div>

                        </div>

                    </div>

                </div>

                <div class="table-responsive">
                    <table id="tabla_emails" cellspacing="0" class="tabla_emails table display nowrap">

                        <thead>

                            <tr>

                                <th>Código</th>
                                <th>Nombre</th>

                                <th>Email</th>
                                <th>Grupos</th>
                                <th>
                                    Enviar

                                </th>

                            </tr>

                        </thead>

                        <tbody>

                        </tbody>

                    </table>

                </div>
                <div class="row d-none">
                    <div class="col-12">
                        <h5>Historial de envíos</h5>
                    </div>
                </div>
                <div class="table-responsive d-none">
                    <table id="tabla_envios" cellspacing="0" class=" table display nowrap">

                        <thead>

                            <tr>

                                <th>Nombre</th>
                                <th>Estado</th>
                                <th>Email</th>

                                <th>
                                    Fecha

                                </th>

                            </tr>

                        </thead>

                        <tbody>

                        </tbody>

                    </table>

                </div>
                <div class="row d-none">
                    <div class="col-12">
                        <h5>Historial de bajas</h5>
                    </div>
                </div>
                <div class="table-responsive d-none">
                    <table id="tabla_bajas" cellspacing="0" class="table display nowrap">

                        <thead>

                            <tr>

                                <th>Nombre</th>

                                <th>
                                    Fecha

                                </th>

                            </tr>

                        </thead>

                        <tbody>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

        <div class="col-lg-4" style="height: fit-content;">

            <div class="card h-100 p-3 justify-content-top">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Insertar email personalizado</label>
                            <div class="form-group">
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_email_custom file-upload-browse btn btn-danger"
                                            data-target="id_email_custom" type="button">-</button>
                                    </span>
                                    <select id="id_email_custom"
                                        class="select_email_custom custom-select select2 form-control">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-primary btn_edit_email_custom"
                                            type="button" data-target="id_email_custom"><i
                                                class="fa fa-edit m-0"></i></button>
                                    </span>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarEmail">+</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <button id="btn_insert_email_custom" class="mb-3 btn btn-info" type="button">Insertar</button>
                    </div>

                    <div class="col-12">

                        <h5 class=" d-flex">Enviado a <span class="ml-1" id="emails_enviados"> 0</span>/<span
                                class="mr-1" id="clientes_agregados">0</span>
                            clientes</h5>
                        <div class="form-group">
                            <label for="my-input">Intervalo de tiempo aleatorio en milisegundos entre los emails
                                enviados</label>
                            <div id="range_02" class="" data-nombre="tiempo_emails"></div>
                        </div>

                        <div class="form-group">

                            <h4>Asunto</h4>

                            <input id="asunto" class="form-control" type="text" name="">

                        </div>

                        <div class="form-group">

                            <h4>Cuerpo</h4>

                            <textarea class="" id="mymce" name="cuerpo_email"></textarea>

                        </div>

                        <div class="form-group">

                            <h4>Adjuntar archivos</h4>

                            <form action="/file-upload" class="dropzone" id="myDropzone2"></form>

                        </div>

                        <button id="btn_enviar_emails" class="btn btn-success" type="button">Comenzar

                            envío</button>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <style>
    #container_bar {

        width: 100%;

        height: 25px;

        position: relative;

    }

    .mce-tinymce.mce-container.mce-panel {

        margin-bottom: 1.5rem;

    }

    .btn_delete_file_d {

        position: absolute;

        top: 0;

        z-index: 100;

        border-radius: 20px;

        font-size: 14px !important;

    }

    .dropzone.dz-clickable {

        overflow-y: auto;

    }

    #enviando_progreso {

        transition: width 0.5s ease;

        /* Agrega la transición para la propiedad 'width' con duración de 0.5 segundos y función de temporización 'ease' */

    }

    .btn_delete_file_d i {

        width: 14px !important;

        cursor: pointer !important;

    }

    .mce-tinymce.mce-container.mce-panel {

        margin-bottom: 0px !important;

    }

    #porcentaje_progreso {

        position: absolute;

        top: 0;

        text-align: center;

        font-weight: 800;

        font-size: 1.1rem;

    }

    .dropzone {

        min-height: 150px;

        background: #fff;

        padding: 10px !important;

        border: 1px solid #ccc;

        border-radius: 4px;

    }
    </style>

</div>

<div class="modal fade modal-cambiar" id="modalEmailsEnviados" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Emails enviados</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0 text-center">

                <!-- btn -->

                <p class="text-center w-100"><span id="emails_enviados2"></span> emails enviados correctamente.</p>

                <lord-icon src="https://cdn.lordicon.com/jshbewmb.json" trigger="hover"
                    colors="primary:#0cca8e,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                    style="width:280px;height:280px">

                </lord-icon>

            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">

                <button class="btn btn-success" data-dismiss="modal" aria-label="Close">

                    Aceptar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<?php require_once __VIEWS__ . 'selects/grupos.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/email_custom.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/poblaciones.template.php'; ?>

<script>
(function($) {

    'use strict';

    $(function() {

        var filteredIds
        var seleccionados = []

        $(document).on("change", ".valor_personalizacion", function() {
            var nombre = $(this).data("nombre")
            var valor = $(this).val()

            $.ajax({
                type: 'POST',
                url: './api/personalizacion.php',
                cache: false,
                async: false,
                data: {
                    nombre: nombre,
                    valor: valor
                },
                success: function(result2) {
                    console.log(result2);
                    $.toast({
                        heading: 'Valor cambiado.',
                        text: 'Se ha cambiado la configuración correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })

                }
            });

        });

        var myDropzone = new Dropzone("#myDropzone2", {
            dictDefaultMessage: "Arrastra y suelta tus archivos aquí o haz clic para seleccionarlos."
        });

        // Evento para manejar cuando se agrega un archivo
        myDropzone.on("addedfile", function(file) {
            var removeButton = Dropzone.createElement(
                '<button class="p-1 btn btn-danger btn-sm btn_delete_file_d"><i class="m-0 fa fa-times-circle"></i></button>'
            );

            // Agrega el botón de eliminación al elemento de la vista previa del archivo
            file.previewElement.appendChild(removeButton);

            // Agrega un evento al botón para manejar la eliminación del archivo
            removeButton.addEventListener("click", function() {
                myDropzone.removeFile(file); // Elimina el archivo
            });
            console.log("Archivo agregado:", file);
            console.log("Archivos actuales:", myDropzone.files);
        });

        // Evento para manejar la eliminación de archivos
        myDropzone.on("removedfile", function(file) {
            console.log("Archivo eliminado:", file);
            console.log("Archivos actuales:", myDropzone.files);
        });

        // Mostrar todos los archivos actualmente en Dropzone

        if ($("#mymce").length > 0) {
            tinymce.init({
                selector: "textarea#mymce",
                theme: "modern",
                height: 250,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",
                language: "es"

            });
        }

        $("#range_02").ionRangeSlider({
            min: 100,
            max: 1000,
            from: <?php echo htmlentities($personalizacion['tiempo_emails'], ENT_QUOTES); ?>,
            onFinish: function(data) {
                // Recuperar el input original
                var input = $("#range_02");
                var nombre = input.data("nombre");
                var valor = data.from;

                $.ajax({
                    type: 'POST',
                    url: './api/personalizacion.php',
                    cache: false,
                    async: false,
                    data: {
                        nombre: nombre,
                        valor: valor
                    },
                    success: function(result2) {
                        console.log(result2);
                        $.toast({
                            heading: 'Valor cambiado.',
                            text: 'Se ha cambiado la configuración correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                    }
                });
            }
        });


        $('#btn_enviar_emails').click(function(e) {

            tinyMCE.triggerSave()
            var msj = $("#mymce").val()
            var asunto = $("#asunto").val()
            if (asunto == "" || msj == "") {

                $.toast({
                    heading: 'Faltan campos',
                    text: 'Rellena el asunto y el cuerpo del mensaje',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return false

            } else {
                enviarEmails()
            }

        })

        function enviarEmails() {
            $('#btn_enviar_emails').addClass("btn-loading");
            $('#btn_enviar_emails').prop("disabled", true);
            tinyMCE.triggerSave()

            var mails_enviar = seleccionados

            if (mails_enviar.length > 0) {

                var totalMails = mails_enviar.length;

                // Inicia el proceso de envío de correos
                enviarCorreo(0, totalMails, mails_enviar);

            } else {
                $.toast({
                    heading: 'Ningún cliente seleccionado.',
                    text: 'Debes seleccionar al menos un cliente para empezar el envío.',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'danger',
                    hideAfter: 4000,
                    stack: 4
                });

                $('#btn_enviar_emails').removeClass("btn-loading");
                $('#btn_enviar_emails').prop("disabled", false);
            }

        }

        function enviarCorreos(mails_enviar) {
            var enviados = document.getElementById("emails_enviados")
            var fd = new FormData();
            var tiempo =
                "<?php echo htmlentities($personalizacion['tiempo_emails'], ENT_QUOTES); ?>"
            // Pausa entre envíos de correo (1 a 5 segundos)
            fd.append('clients_ids[]', mails_enviar);
            fd.append('mensaje_2', $("#mymce").val());
            fd.append('tiempo', tiempo);
            fd.append('asunto_2', $("#asunto").val());
            var archivos = (myDropzone.files.length != 0) ? myDropzone.files :
                null;
            // Asegúrate de agregar cada archivo correctamente al FormData
            if (archivos) {
                for (var i = 0; i < archivos.length; i++) {
                    fd.append('archivos[]', archivos[i]);
                }
            }

            // Enviar correo usando fetch
            fetch('./mailer', {
                    method: 'POST',
                    body: fd
                })
                .then(response => response.json())
                .then(res => {
                    console.log(res);

                })
                .catch(error => {
                    console.log(error);
                    $("#emails_enviados2").text(totalMails)
                    $("#modalEmailsEnviados").modal("show")

                    enviados.innerText = " 0";
                    $('#btn_enviar_emails').removeClass("btn-loading");
                    $('#btn_enviar_emails').prop("disabled", false);
                    $("#btn_desmarcar_todos").click()
                });
        }

        function enviarCorreo(index, totalMails, mails_enviar) {
            var enviados = document.getElementById("emails_enviados")
            if (index < totalMails) {
                var fd = new FormData();
                fd.append('client_id_2', mails_enviar[index]);
                fd.append('mensaje_2', $("#mymce").val());
                fd.append('asunto_2', $("#asunto").val());
                var archivos = (myDropzone.files.length != 0) ? myDropzone.files :
                    null;
                // Asegúrate de agregar cada archivo correctamente al FormData
                if (archivos) {
                    for (var i = 0; i < archivos.length; i++) {
                        fd.append('archivos[]', archivos[i]);
                    }
                }

                // Enviar correo usando fetch
                fetch('./mailer', {
                        method: 'POST',
                        body: fd
                    })
                    .then(response => response.json())
                    .then(res => {
                        console.log(res);
                        index++;

                        enviados.innerText = " " + parseInt(index);
                        var tiempo =
                            "<?php echo htmlentities($personalizacion['tiempo_emails'], ENT_QUOTES); ?>"
                        // Pausa entre envíos de correo (1 a 5 segundos)
                        var timeBetweenEmails = Math.floor(Math.random() * (parseInt(tiempo))) +
                            100; // entre 1000 y 5000 milisegundos
                        setTimeout(function() {
                            // Llamar a la función recursivamente para enviar el siguiente correo
                            enviarCorreo(index, totalMails, mails_enviar);
                        }, timeBetweenEmails);
                    })
                    .catch(error => {
                        console.log(error);

                        // Continuar con el siguiente correo en caso de error
                        enviarCorreo(index + 1, totalMails, mails_enviar);
                    });
            } else {
                // Último correo enviado
                $("#emails_enviados2").text(totalMails)
                $("#modalEmailsEnviados").modal("show")
                /*  
                  $.toast({
                      heading: totalMails + ' emails enviados.',
                      text: 'Se ha enviado el email a los clientes seleccionados',
                      position: 'top-right',
                      loaderBg: '#32a852',
                      icon: 'success',
                      hideAfter: 6000,
                      stack: 4
                  });*/
                enviados.innerText = " 0";
                $('#btn_enviar_emails').removeClass("btn-loading");
                $('#btn_enviar_emails').prop("disabled", false);
                $("#btn_desmarcar_todos").click()

            }
        }

        $("#btn_marcar_todos").click(function() {
            filteredIds.forEach(id => {
                if (!seleccionados.includes(parseInt(id))) {
                    seleccionados.push(parseInt(
                        id)); // Agregamos solo si no está ya en seleccionados
                }
            });
            console.log(seleccionados);
            $('.tabla_emails').DataTable().ajax.reload(null, false);
        });

        // Evento al hacer clic en "Desmarcar todos"
        $("#btn_desmarcar_todos").click(function() {
            seleccionados = seleccionados.filter(id => filteredIds.includes(
                id)); // Eliminamos los IDs de filteredIds
            console.log(seleccionados);
            $('.tabla_emails').DataTable().ajax.reload(null, false);
        });
        $(document).on('change', '.activos', function() {

            const dataId = $(this).data('id'); // Obtenemos el data-id del checkbox

            if ($(this).is(':checked')) {
                // Si está marcado, lo agregamos al arreglo si no existe ya
                if (!seleccionados.includes(dataId)) {
                    seleccionados.push(dataId);
                }
            } else {
                // Si no está marcado, lo eliminamos del arreglo
                seleccionados = seleccionados.filter(id => id !== dataId);
            }

            var mails_enviar = seleccionados
            var totalMails = mails_enviar.length;
            $("#clientes_agregados").text(totalMails)
        });

        $('#tabla_emails').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, 100],
                [10, 25, 50, 100]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en clientes",
                infoEmpty: "Mostrando 0 a 0 de 0 en clientes",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",
                zeroRecords: "Ningún resultado.",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(
                    data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,

            "initComplete": function() {

            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": true,
            "ajax": {
                "url": "./ServerSide/serversideClientes.php",
                // "async": false,
                "data": function(data) {
                    // Agregar parámetros adicionales a la solicitud aquí
                    //data.terminos = "1"

                    data.terminos = "1";
                    data.id_poblacion = $("#select_poblaciones").val();
                    data.id_grupo = $("#select_grupos2").val();

                    data.sexo = $("#select_sexo").val();
                    data.edad_minima = ($("#filtro_edad").prop("checked") && $(
                            "#edad_minima")
                        .val() != "") ? $("#edad_minima").val() : "No"
                    data.edad_maxima = ($("#filtro_edad").prop("checked") && $(
                            "#edad_maxima")
                        .val() != "") ? $("#edad_maxima").val() : "No"

                    data.cp_minimo = ($("#filtro_cp").prop("checked") && $(
                        "#cp_minimo").val() != "") ? $("#cp_minimo").val() : "No"
                    data.cp_maximo = ($("#filtro_cp").prop("checked") && $(
                        "#cp_maximo").val() != "") ? $("#cp_maximo").val() : "No"

                },
                dataSrc: function(json) {

                    $("#notificados_count").text(json.terminosCount)
                    var mails_enviar = seleccionados
                    var totalMails = mails_enviar.length;
                    $("#clientes_agregados").text(totalMails)
                    filteredIds = json.filteredIds
                    console.log(json);
                    return json.data;
                },
                "error": function(xhr, error, thrown) {
                    // Manejo de errores
                    alert('Error en la carga de datos: ' + thrown);
                }
            },
            "columnDefs": [{
                    "orderable": true,
                    "targets": [0, 1, 2]
                } // Disables sorting on the first and third columns (index 0 and 2)
            ],
            "ordering": true,
            "columns": [{
                    "data": "codigo"
                }, {
                    "data": "nombre"
                },
                {
                    "data": "email"
                },
                {
                    "data": "grupos",
                    "render": function(data, type, row) {
                        if (data.includes("null")) {
                            return ""
                        }

                        data = JSON.parse(data);

                        var ul = document.createElement('ul');

                        ul.classList.add("h-100", "list-group")

                        ul.style.overflowY = 'auto';

                        ul.style.maxHeight = '130px';

                        // Iterar sobre el arreglo de grupos

                        data.forEach(function(grupo) {

                            var li = document.createElement('li');

                            li.textContent = grupo.nombre;

                            li.classList.add("p-2",

                                "list-group-item", "d-flex",

                                "justify-content-between", "align-items-center")

                            // Establecer el atributo data-id con el id_grupo del grupo

                            li.setAttribute('data-id', grupo.id_grupo);

                            // Agregar el LI al UL

                            ul.appendChild(li);

                        });

                        return ul.outerHTML;
                    }
                },
                {
                    "data": null,
                    "render": function(data, type, row, meta) {
                        var ac = "Enviar"
                        const checkboxContainer = document.createElement("label");
                        checkboxContainer.classList.add("custom-control", "custom-checkbox",
                            "d-inline-block");

                        // Crear el elemento checkbox
                        const checkbox = document.createElement("input");
                        checkbox.type = "checkbox";
                        checkbox.setAttribute("data-id", data.client_id);
                        checkbox.classList.add("custom-control-input");
                        checkbox.classList.add("activos");
                        checkbox.style.fontSize = "18px"
                        // Opción 1: Usar el atributo "checked"

                        var acc = seleccionados.includes(parseInt(data.client_id)) ? 1 : 0;
                        // Opción 2: Usar el método setAttribute
                        if (acc) {
                            checkbox.setAttribute('checked', 1);
                        }
                        // Crear el elemento span para la etiqueta
                        const labelSpan = document.createElement("span");

                        labelSpan.classList.add("custom-control-label");
                        labelSpan.textContent = ac;
                        labelSpan.style.fontSize = "16px"
                        // Agregar el checkbox y el span al contenedor
                        checkboxContainer.appendChild(checkbox);
                        checkboxContainer.appendChild(labelSpan);

                        return checkboxContainer.outerHTML;
                    }
                }
            ]

        });
        /* $('#tabla_envios').DataTable({
             "responsive": true,
             "dom": 'Blfrtip',
             "aLengthMenu": [
                 [10, 25, 50, 100],
                 [10, 25, 50, 100]
             ],
             "iDisplayLength": 10,
             "language": {
                 search: "Buscar",
                 emptyTable: "No hay información",
                 info: "Mostrando _START_ a _END_ de _TOTAL_ envíos",
                 infoEmpty: "Mostrando 0 a 0 de 0 envíos",
                 infoFiltered: "(Filtrado de _MAX_ total entradas)",
                 infoPostFix: "",
                 thousands: ",",
                 lengthMenu: "Mostrar _MENU_ Entradas",
                 // loadingRecords: "Cargando...",
                 zeroRecords: "Ningún resultado.",

                 processing: "Cargando...",
                 loadingRecords: "",
                 paginate: {
                     first: "Primero",
                     last: "Ultimo",
                     next: "Siguiente",
                     previous: "Anterior"
                 }
             },
             "stateSave": true,
             "stateSaveCallback": function(settings, data) {
                 localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(
                     data))
             },
             "stateLoadCallback": function(settings) {
                 return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
             },
             "order": [
                 [0, "desc"]
             ],
             "buttons": [

                 {
                     extend: 'colvis',
                     text: 'Ocultar Columnas',
                     collectionLayout: 'fixed two-column',
                     className: "form-control"
                 }
             ],
             "searching": true,

             "initComplete": function() {

             },
             "processing": true, // Mostrar el indicador de procesamiento
             "serverSide": false,
             "ajax": {
                 "url": "./api/clientes.php?envios_email=1",
                 // "async": false,

                 dataSrc: function(data) {
                     console.log(data);

                     return data;
                 },
                 "error": function(xhr, error, thrown) {
                     // Manejo de errores
                     alert('Error en la carga de datos: ' + thrown);
                 }
             },
             "columnDefs": [{
                     "orderable": false,
                     "targets": [0, 1, 2]
                 } // Disables sorting on the first and third columns (index 0 and 2)
             ],
             "ordering": false,
             "columns": [{
                     "data": "nombre_cliente"
                 },
                 {
                     "data": "estado"
                 }, {
                     "data": "email_cliente"
                 },
                 {
                     "data": "fecha",
                     "render": function(data, type, row, meta) {
                         var mom = (data != null) ? new moment(data).format(
                                 'DD/MM/YYYY') :
                             ""
                         return mom
                     }
                 }
             ]

         });

         $('#tabla_bajas').DataTable({
             "responsive": true,
             "dom": 'Blfrtip',
             "aLengthMenu": [
                 [10, 25, 50, 100],
                 [10, 25, 50, 100]
             ],
             "iDisplayLength": 10,
             "language": {
                 search: "Buscar",
                 emptyTable: "No hay información",
                 info: "Mostrando _START_ a _END_ de _TOTAL_ envíos",
                 infoEmpty: "Mostrando 0 a 0 de 0 envíos",
                 infoFiltered: "(Filtrado de _MAX_ total entradas)",
                 infoPostFix: "",
                 thousands: ",",
                 lengthMenu: "Mostrar _MENU_ Entradas",
                 // loadingRecords: "Cargando...",
                 zeroRecords: "Ningún resultado.",

                 processing: "Cargando...",
                 loadingRecords: "",
                 paginate: {
                     first: "Primero",
                     last: "Ultimo",
                     next: "Siguiente",
                     previous: "Anterior"
                 }
             },
             "stateSave": true,
             "stateSaveCallback": function(settings, data) {
                 localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(
                     data))
             },
             "stateLoadCallback": function(settings) {
                 return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
             },
             "order": [
                 [0, "desc"]
             ],
             "buttons": [

                 {
                     extend: 'colvis',
                     text: 'Ocultar Columnas',
                     collectionLayout: 'fixed two-column',
                     className: "form-control"
                 }
             ],
             "searching": true,

             "initComplete": function() {

             },
             "processing": true, // Mostrar el indicador de procesamiento
             "serverSide": false,
             "ajax": {
                 "url": "./api/clientes.php?bajas=1",
                 // "async": false,

                 dataSrc: function(data) {
                     console.log(data);

                     return data;
                 },
                 "error": function(xhr, error, thrown) {
                     // Manejo de errores
                     alert('Error en la carga de datos: ' + thrown);
                 }
             },
             "columnDefs": [{
                     "orderable": false,

                 } // Disables sorting on the first and third columns (index 0 and 2)
             ],
             "ordering": false,
             "columns": [{
                     "data": "nombre_cliente"
                 },
                 {
                     "data": "fecha",
                     "render": function(data, type, row, meta) {
                         var mom = (data != null) ? new moment(data).format(
                                 'DD/MM/YYYY') :
                             ""
                         return mom
                     }
                 }
             ]

         });*/

        $("#select_poblaciones,#select_grupos2,#select_sexo,#filtro_marca,#filtro_modelo,#filtro_tipo_cliente,#filtro_tipo_vehiculo,#filtro_combustible")
            .change(function(e) {

                $('.tabla_emails').DataTable().ajax.reload(null, false);

            });

        function toggleInputs(checkbox) {
            // Check which checkbox triggered the event
            if (checkbox === 'filtro_edad') {
                if ($('#filtro_edad').is(':checked')) {
                    $('#edad_minima, #edad_maxima').prop('disabled', false);
                } else {
                    $('#edad_minima, #edad_maxima').prop('disabled', true);
                    $('#edad_minima, #edad_maxima').val("").trigger("change");
                    $('.tabla_emails').DataTable().ajax.reload(null, false);
                }
            }

            if (checkbox === 'filtro_precio') {
                if ($('#filtro_precio').is(':checked')) {
                    $('#precio_minimo, #precio_maximo').prop('disabled', false);
                } else {
                    $('#precio_minimo, #precio_maximo').prop('disabled', true);
                    $('#precio_minimo, #precio_maximo').val("").trigger("change");
                    $('.tabla_emails').DataTable().ajax.reload(null, false);
                }
            }

            if (checkbox === 'filtro_cp') {
                if ($('#filtro_cp').is(':checked')) {
                    $('#cp_minimo, #cp_maximo').prop('disabled', false);
                } else {
                    $('#cp_minimo, #cp_maximo').prop('disabled', true);
                    $('#cp_minimo, #cp_maximo').val("").trigger("change");
                    $('.tabla_emails').DataTable().ajax.reload(null, false);
                }
            }
            if (checkbox === 'filtro_fecha') {
                if ($('#filtro_fecha').is(':checked')) {
                    $('#fecha_minima, #fecha_maxima').prop('disabled', false);
                } else {
                    $('#fecha_minima, #fecha_maxima').prop('disabled', true);
                    $('#fecha_minima, #fecha_maxima').val("").trigger("change");
                    $('.tabla_emails').DataTable().ajax.reload(null, false);
                }
            }
            if (checkbox === 'filtro_fecha_venta') {
                if ($('#filtro_fecha_venta').is(':checked')) {
                    $('#fecha_minima_venta, #fecha_maxima_venta').prop('disabled', false);
                } else {
                    $('#fecha_minima_venta, #fecha_maxima_venta').prop('disabled', true);
                    $('#fecha_minima_venta, #fecha_maxima_venta').val("").trigger("change");
                    $('.tabla_emails').DataTable().ajax.reload(null, false);
                }
            }
        }

        // Add event listeners for each checkbox to pass the respective checkbox ID
        $('#filtro_edad, #filtro_precio, #filtro_cp, #filtro_fecha, #filtro_fecha_venta').change(
            function() {
                toggleInputs($(this).attr("id")); // Pass the ID of the checkbox that was clicked
            });

        $('#edad_minima, #edad_maxima').change(function() {
            const edadMinima = parseFloat($('#edad_minima').val()) || 0;
            const edadMaxima = parseFloat($('#edad_maxima').val()) || 0;
            console.log(edadMinima);
            console.log(edadMaxima);
            if (edadMinima === 0 || edadMaxima === 0) {
                return false
            } else {
                // Verifica si edad_minima es menor que edad_maxima
                if (edadMinima >= edadMaxima) {
                    $.toast({
                        heading: 'Edades incorrectas',
                        text: 'La edad mínima debe ser menor a la máxima.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 2000,
                        stack: 6
                    });
                    return false
                } else {
                    $('.tabla_emails').DataTable().ajax.reload(null, false);
                }
            }
        });

        $('#precio_minimo, #precio_maximo').change(function() {
            const precioMinima = parseFloat($('#precio_minimo').val()) || 0;
            const precioMaxima = parseFloat($('#precio_maximo').val()) || 0;
            console.log(precioMinima);
            console.log(precioMaxima);
            if (precioMinima === 0 || precioMaxima === 0) {
                return false
            } else {
                // Verifica si edad_minima es menor que edad_maxima
                if (precioMinima >= precioMaxima) {
                    $.toast({
                        heading: 'Precios incorrectos',
                        text: 'El precio mínimo debe ser menor al máximo.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 2000,
                        stack: 6
                    });
                    return false
                } else {
                    $('.tabla_emails').DataTable().ajax.reload(null, false);
                }
            }
        });

        $('#cp_minimo, #cp_maximo').on('change', function() {
            // Llama a la función de validación
            validarCodigoPostal(this);
        });

        function validarCodigoPostal(input) {
            var codigoPostal = $(input).val();
            var cpMinimo = $('#cp_minimo').val();
            var cpMaximo = $('#cp_maximo').val();

            // Expresión regular para un código postal de 5 dígitos
            var regex = /^\d{5}$/;

            // Validar el formato del código postal
            if (!regex.test(codigoPostal)) {
                $(input).get(0).setCustomValidity("El código postal debe tener 5 dígitos.");
                $(input).val(''); // Borra el valor del campo si no es válido

                // Muestra el mensaje de error con $.toast
                $.toast({
                    heading: 'Error',
                    text: 'El código postal debe tener 5 dígitos y valores numéricos.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
            } else if (cpMinimo && cpMaximo && parseInt(cpMinimo) > parseInt(cpMaximo)) {
                // Validar que el cp_minimo sea menor que cp_maximo
                $(input).get(0).setCustomValidity(
                    "El código postal mínimo debe ser menor que el máximo.");
                $(input).val(''); // Borra el valor del campo si no es válido

                // Muestra el mensaje de error con $.toast
                $.toast({
                    heading: 'Error',
                    text: 'El código postal mínimo debe ser menor que el máximo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
            } else {
                $(input).get(0).setCustomValidity(""); // Resetea el mensaje de error si es válido
                $('.tabla_emails').DataTable().ajax.reload(null, false);
            }
        }

    });

})(jQuery);
</script>

<script>
(function($) {

    'use strict';

    $(function() {

    });

})(jQuery);
</script>