<style>
::-webkit-scrollbar {
    width: 10px;
}

::-webkit-scrollbar-track {
    background: #f1f1f1;
}

::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 10px;
}

::-webkit-scrollbar-thumb:hover {

    background: #555;
}



#lista_condiciones {
    max-height: 180px;
    overflow-y: scroll;
    overflow-x: hidden;
}

#lista_condiciones p {
    white-space: nowrap;
    /* Evita el salto de línea */
    overflow: hidden;
    /* Oculta el contenido que desborda */
    text-overflow: ellipsis;
    width: 100%;
}


.crear_presupuesto .custom-control-label::before,
.crear_presupuesto .custom-control-label::after {
    top: 0.15rem !important;
}
</style>
<style>
.bootstrap-tagsinput {
    max-height: 34px;
    display: flex;
    overflow-x: auto;
    overflow-y: hidden;
    height: auto !important;
}

.bootstrap-tagsinput::-webkit-scrollbar {

    height: 3px;
}

.bootstrap-tagsinput::-webkit-scrollbar-thumb {
    background-color: #888;
    border-radius: 2px;
}

.bootstrap-tagsinput::-webkit-scrollbar-track {
    background-color: #eee;
}

.bootstrap-tagsinput span.tag {
    text-align: left;
    font-family: "Montserrat", sans-serif;
    word-wrap: break-word;
    cursor: text;
    box-sizing: border-box;
    outline: none;
    padding: 3px 10px;
    line-height: 13px;
    font-weight: 400;
    border-radius: 4px;
    font-size: 75%;
    background-color: #20aee3;
    display: inline-block;
    margin-right: 2px;
    color: white;
}
</style>
<div id="head" class="content-wrapper crear_presupuesto">


    <div class="container-fluid p-0">
        <div class="row">
            <div class="col-xl-3">
                <div class="card p-3 mb-3 ">
                    <h4 class="text-center mb-3">Unidades de obra</h4>
                    <div class="form-group">
                        <div class="w-100 input-group" style="">
                            <input id="search_apartado" class="form-control" type="text"
                                placeholder="Buscar por título o por código de referencia">
                            <div class="input-group-append">
                                <span style="font-size: 12px;" class="input-group-text" id="my-addon"><i
                                        class="fas fa-search"></i></span>
                            </div>
                        </div>

                    </div>
                    <div class="form-group">
                        <div class="w-100 input-group" style="">

                            <div class="input-group-prepend">
                                <span style="font-size: 12px;" class="input-group-text" id="my-addon"><i
                                        class="fas fa-eye"></i></span>
                            </div>
                            <select id="cant_apartados" class="select form-control" name="">
                                <option value="5">5 resultados</option>
                                <option value="10">10 resultados</option>
                                <option value="15">15 resultados</option>
                                <option value="todos">Todos los resultados</option>
                            </select>


                        </div>

                    </div>

                    <div id="apartados" class="mb-2">

                    </div>



                    <button type="button" data-toggle="modal" data-target="#modalAgregarApartado"
                        class="btn btn-sm btn-success">Agregar unidades de obra</button>
                </div>
                <div class="total p-3 mb-3">
                    <h4 id="subtotal" data-total=<?php echo $PresupuestoEditar["importe"]; ?> class="mb-2 text-center">
                        Subtotal: 0€</h4>
                    <p class="mb-2 text-center">Impuestos agregados:</p>
                    <div class="d-flex flex-column align-items-start mb-2">
                        <p class="mb-2">Impuesto:</p>
                        <div class="form-check form-check-inline d-flex m-1">
                            <input value="7" class="form-check-input" type="radio" name="igic" <?php if ($PresupuestoEditar["igic"] == "7.00") {
                                                                                                    echo "checked";
                                                                                                } ?>>
                            <label class="p-0 form-check-label" for="inlineCheckbox1">+7%</label>

                        </div>
                        <div class="form-check form-check-inline d-flex m-1">
                            <input value="21" class="form-check-input" type="radio" name="igic" <?php if ($PresupuestoEditar["igic"] == "21.00") {
                                                                                                    echo "checked";
                                                                                                } ?>>
                            <label class="p-0 form-check-label" for="inlineCheckbox2">+21%</label>
                        </div>
                        <div class="form-check form-check-inline d-flex m-1">
                            <input value=<?php if ($PresupuestoEditar["igic"] != "21.00" && $PresupuestoEditar["igic"] != "7.00") {
                                                echo $PresupuestoEditar["igic"];
                                            } ?> class="form-check-input" type="radio" id="igic" name="igic" <?php if ($PresupuestoEditar["igic"] != "21.00" && $PresupuestoEditar["igic"] != "7.00") {
                                                                                                                    echo "checked";
                                                                                                                } ?>
                                class="form-check-input" type="radio" id="igic" name="igic">

                            <div class="input-group">

                                <input value=<?php if ($PresupuestoEditar["igic"] != "21.00" && $PresupuestoEditar["igic"] != "7.00") {
                                                    echo number_format($PresupuestoEditar["igic"], 2, '.', '');
                                                } ?> class="ml-2 form-control" style="max-width:60px;" type="number"
                                    id="igicotro">
                                <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>

                    </div>



                    <div id="irpfview" style="display:none;" class="align-items-center mb-2">
                        <div class="form-check flex-column p-0 mb-2 d-flex m-1">

                            <p class="mb-2" for="inlineCheckbox1">I.R.P.F:</p>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">-</span>
                                </div>

                                <input value=0 class="form-control" style="max-width:60px;" type="number" id="irpf">
                                <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                    </div>



                    <h4 id="total" data-total=0 class="mb-2 text-center">Total: 0€</h4>
                    <p style="text-transform: uppercase;" id="total_letras" class="mb-0 text-center">Cero Euros</p>
                </div>
                <div class="card p-3 mb-3 ">
                    <h4 class="text-center mb-3">Condiciones disponibles</h4>

                    <ul data-target="condiciones_presupuesto" id="lista_condiciones" class="p-0 mb-3">

                        <?php

                        foreach ($Condiciones_List as $Condicion) {
                        ?>

                        <li id="condicion_<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>"
                            class=" mb-2 d-flex flex-row justify-content-between align-items-center">
                            <p class="mb-0"><?php echo htmlentities($Condicion['titulo'], ENT_QUOTES); ?></p>

                            <div class="d-flex flex-nowrap">

                                <button data-id='<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>'
                                    class="btn_delete_condicion btn btn-sm btn-danger"><i style="font-size:10px;"
                                        class="m-0 fas fa-trash-alt"></i></button>
                                <button data-id='<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>'
                                    class="mx-1 btn_edit_condicion btn btn-sm btn-info"><i style="font-size:10px;"
                                        class="m-0 fas fa-pencil-alt"></i></button>
                                <button data-id='<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>'
                                    class="btn_add_condicion btn btn-sm btn-success"><i style="font-size:10px;"
                                        class="m-0 fas fa-plus"></i></button>
                            </div>

                        </li>
                        <?php } ?>
                    </ul>

                    <button type="button" data-toggle="modal" data-target="#modalAgregarCondicion"
                        class="btn btn-sm btn-success">Agregar condición</button>
                </div>



            </div>
            <div class="col-xl-9">
                <div class="card p-3">
                    <h4 class="mb-3">Agregar unidad de obra al presupuesto</h4>


                    <form id="form-agregar" action="">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Descripción</label>
                                    <textarea class="form-control" id="descripcion_edit" type="text"
                                        class="form-control m-0" name="descripcion_apartado" placeholder=""
                                        style="height: 184px !important;"></textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="custom-control custom-checkbox d-inline-block"
                                        style="height: auto;min-height: unset;">
                                        <input type="checkbox" class="custom-control-input apartado" id="titulo_check">
                                        <span class="custom-control-label">Título</span>
                                    </label>
                                    <input disabled id="titulo_edit" class="form-control" type="text"
                                        name="titulo_apartado">
                                </div>
                                <div class="form-group">
                                    <label>Medida</label>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_medida file-upload-browse btn btn-danger"
                                                data-target="medida_edit" type="button">-</button>
                                        </span>
                                        <select id="medida_edit" name="medida_apartado"
                                            class="select_medidas custom-select select2 form-control">
                                            <option selected value="No">
                                                Ninguna
                                            </option>

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMedida">+</button>
                                        </span>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Precio unitario</label>

                                            <div class="input-group">


                                                <input id="precio_unitario_edit" type="number" class="form-control"
                                                    name="precio_apartado" placeholder="" required step="any">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">€</span>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Cantidad</label>
                                            <input id="cantidad_edit" type="number" class="form-control"
                                                name="cantidad_apartado" placeholder="" required>
                                        </div>
                                    </div>
                                </div>


                            </div>

                            <div class="col-12">
                                <div class="text-right">
                                    <button id="btn_agregar_d" type="submit"
                                        class="btn btn-sm btn-primary">Agregar</button>
                                </div>

                            </div>
                        </div>
                    </form>

                    <hr>
                    <h4 class="mb-3 d-flex align-items-center justify-content-between">Presupuesto <button type="button"
                            id="verPresupuesto" data-toggle="modal" data-target="#modalVerPresupuesto"
                            class="btn btn-sm btn-success">Ver presupuesto</button> </h4>


                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Concepto</label>
                                        <input type="text" class="form-control" id="titulo_presupuesto"
                                            name="titulo_presupuesto" placeholder="" required
                                            value="<?php echo htmlentities($PresupuestoEditar['titulo'], ENT_QUOTES); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Número</label>
                                        <input type="text" class="form-control" name="numero_presupuesto"
                                            id="numero_presupuesto" placeholder=""
                                            value="<?php echo htmlentities($PresupuestoEditar['numero'], ENT_QUOTES); ?>">

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Fechas</label>
                                        <input type="text" class="form-control" id="fechas_presupuesto" placeholder=""
                                            required
                                            value="<?php echo htmlentities($PresupuestoEditar['fechas'], ENT_QUOTES); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Lugar</label>
                                        <input type="text" class="form-control" id="lugar_presupuesto"
                                            name="titulo_presupuesto" placeholder="" required
                                            value="<?php echo htmlentities($PresupuestoEditar['lugar'], ENT_QUOTES); ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <label>Fecha</label>
                                        <input type="datetime-local" class="form-control" name="fecha_presupuesto"
                                            id="fecha_presupuesto"
                                            placeholder="<?php echo htmlentities($PresupuestoEditar['fecha'], ENT_QUOTES); ?>">
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <label>Programar envío</label>


                                        <input type="datetime-local" class="mb-3 form-control"
                                            id="programacion_presupuesto" disabled placeholder="">

                                        <label class="custom-control custom-checkbox d-inline-block mb-0">
                                            <input type="checkbox" id="programado"
                                                class="custom-control-input apartado">
                                            <span class="custom-control-label">Habilitar </span>
                                        </label>

                                    </div>
                                </div>

                            </div>



                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Imágen de cabecera</label>
                                <div id="url_imagen_presupuesto_editar">
                                    <input id="cambiar_img" type="hidden" class="form-control valor_personalizacion"
                                        data-nombre="url_imagen_presupuesto"
                                        value="<?php echo htmlentities($PresupuestoEditar['imagen'], ENT_QUOTES); ?>"
                                        disabled>
                                </div>
                                <div id="url_imagen_presupuesto" class="row">
                                    <div style="background: #80808030;display: flex;justify-content: center;align-items: center;"
                                        class="col-sm-6 mb-3 mb-sm-0">
                                        <img class="w-100"
                                            src="<?php echo htmlentities($PresupuestoEditar['imagen'], ENT_QUOTES); ?>"
                                            alt="">
                                    </div>
                                    <div class="col-sm-6">

                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <button data-target="url_imagen_presupuesto_editar"
                                                    data-toggle="tooltip" data-placement="top"
                                                    class="btn_modal_imagenes btn btn-info"
                                                    data-original-title="Editar imagen por defecto" type="button"><i
                                                        style="font-size: 12px;" class="m-0 fas fa-edit"></i></button>
                                            </div>


                                            <input type="text" class="form-control"
                                                value="<?php echo htmlentities($personalizacion['url_imagen_presupuesto'], ENT_QUOTES); ?>"
                                                disabled>

                                            <div class="input-group-append">
                                                <button data-target="url_imagen_presupuesto" data-toggle="tooltip"
                                                    data-placement="top" class="btn_modal_imagenes btn btn-info"
                                                    data-original-title="Editar imagen del presupuesto" type="button"><i
                                                        style="font-size: 12px;" class="m-0 fas fa-plus"></i></button>
                                            </div>
                                        </div>


                                        <p class="mb-0">El ratio recomendado es 1X2</p>

                                    </div>
                                </div>


                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Cliente</label>
                                        <div class="input-group">
                                            <span class="input-group-prepend">
                                                <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                                    type="button" data-target="cliente_presupuesto">-</button>
                                            </span>
                                            <select name="cliente_presupuesto" id="cliente_presupuesto"
                                                class="select_clientes form-control custom-select text-center select2"
                                                required>


                                            </select>
                                            <span class="input-group-append">
                                                <button id="btn-add-cliente" class="file-upload-browse btn btn-info"
                                                    type="button">+</button>
                                            </span>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="my-input">Destinatarios</label>
                                        <input type="text" class="form-control" id="emails" value="">

                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <a class="mb-2" data-toggle="collapse" href="#collapseExample" role="button"
                                    aria-expanded="false" aria-controls="collapseExample">Notas<i
                                        style="font-size: .8rem;" class="fas fa-chevron-down"></i></a>
                                <div class="mt-3 collapse" id="collapseExample">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="my-input">Interna</label>
                                                <textarea id="nota_interna" name="area"><?php if ($PresupuestoEditar['nota_interna'] != null) {

                                                                                            echo htmlentities($PresupuestoEditar['nota_interna'], ENT_QUOTES);
                                                                                        } ?></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="my-input">Externa</label>
                                                <textarea id="nota_externa" name="area"><?php if ($PresupuestoEditar['nota_externa'] != null) {

                                                                                            echo htmlentities($PresupuestoEditar['nota_externa'], ENT_QUOTES);
                                                                                        } ?></textarea>
                                            </div>
                                        </div>
                                    </div>



                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="row d-none">
                        <div class="col-12">
                            <label class="custom-control custom-checkbox d-inline-block mb-3">
                                <input type="checkbox" id="facturae_enabled" class="custom-control-input apartado">
                                <span class="custom-control-label">Habilitar facturae</span>
                            </label>
                        </div>

                    </div>
                    <div id="facturae" class="d-none row mb-3 ">
                        <div class="col-12">
                            <h4 class="mb-3">Unidades</h4>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Unidad Tramitadora</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_tramitadora">-</button>
                                    </span>
                                    <select name="id_tramitadora" id="id_tramitadora"
                                        class="form-control custom-select text-center select2" required>
                                        <?php
                                        foreach ($Tramitadora as $administracion) {
                                        ?>
                                        <option type="number"
                                            data-overlay="<?php echo implode('-', $administracion) ?> "
                                            value=<?php echo htmlentities($administracion['id'], ENT_QUOTES) ?>>
                                            <?php echo htmlentities($administracion['nombre'], ENT_QUOTES) ?>
                                        </option>
                                        <?php } ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button data-toggle="modal" data-target="#modalcrearUnidad"
                                            class="file-upload-browse btn btn-info" type="button">+</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Unidad Gestora</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_gestor">-</button>
                                    </span>
                                    <select name="id_gestor" id="id_gestor"
                                        class="form-control custom-select text-center select2" required>
                                        <?php
                                        foreach ($Gestora as $administracion) {
                                        ?>
                                        <option type="number"
                                            data-overlay="<?php echo implode('-', $administracion) ?> "
                                            value=<?php echo htmlentities($administracion['id'], ENT_QUOTES) ?>>
                                            <?php echo htmlentities($administracion['nombre'], ENT_QUOTES) ?>
                                        </option>
                                        <?php } ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button data-toggle="modal" data-target="#modalcrearUnidad"
                                            class="file-upload-browse btn btn-info" type="button">+</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Unidad Contable</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_contable">-</button>
                                    </span>
                                    <select name="id_contable" id="id_contable"
                                        class="form-control custom-select text-center select2" required>
                                        <?php
                                        foreach ($Contable as $administracion) {
                                        ?>
                                        <option type="number"
                                            data-overlay="<?php echo implode('-', $administracion) ?> "
                                            value=<?php echo htmlentities($administracion['id'], ENT_QUOTES) ?>>
                                            <?php echo htmlentities($administracion['nombre'], ENT_QUOTES) ?>
                                        </option>
                                        <?php } ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button data-toggle="modal" data-target="#modalcrearUnidad"
                                            class="file-upload-browse btn btn-info" type="button">+</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row mb-3">
                        <div class="col-12">
                            <div style="overflow-x:auto;">
                                <table id="order-listing" class="table">
                                    <thead>
                                        <tr>
                                            <th>Órden</th>
                                            <th>Código</th>
                                            <th>Cantidad</th>
                                            <th>Descripción</th>
                                            <th>Precio unitario</th>
                                            <th>Total</th>
                                            <th style="text-align:center;">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php


$detallado = json_decode($PresupuestoEditar['detallado'], true);
$i = 0;
function formatearNumero($cadena)
{
    // Reemplazar la coma por el punto para asegurar el formato numérico correcto
    $cadena = str_replace(',', '.', $cadena);

    // Separar la parte entera de la decimal
    $partes = explode('.', $cadena);
    $parteEntera = $partes[0];
    $parteDecimal = isset($partes[1]) ? $partes[1] : '';

    // Formatear la parte entera con separadores de miles
    $parteEntera = number_format($parteEntera, 0, '', '.');

    // Unir la parte entera y decimal con el formato deseado
    $numeroFormateado = $parteEntera . ',' . $parteDecimal;

    return $numeroFormateado;
}
foreach ($detallado as $detalle) {
?>
                                        <tr>
                                            <td><?php
            echo $i;
            ?></td>
                                            <td><?php
            echo htmlentities($detalle["codigo"], ENT_QUOTES);
            ?></td>
                                            <td><?php
            echo htmlentities($detalle["cantidad"], ENT_QUOTES);
            ?></td>
                                            <td class="contenido dropdown drop_drop">
                                                <h5 class="mb-0 text-center titulo_a">
                                                    <?php
                echo htmlentities($detalle["titulo"], ENT_QUOTES);
                ?></h5>
                                                <button class="py-2 btn btn-secondary dropdown-toggle w-100"
                                                    type="button" id="dropdownMenuButton_<?php echo $i; ?>"
                                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <p class="mb-0"><?php
            echo htmlentities($detalle["descripcion"], ENT_QUOTES);
            ?></p>
                                                </button>
                                                <div class="dropdown-menu p-3"
                                                    aria-labelledby="dropdownMenuButton_<?php echo $i;?>">
                                                    <p class="mb-0"><?php
                                echo htmlentities($detalle["descripcion"], ENT_QUOTES);
                                ?></p>
                                                </div>

                                            </td>
                                            <td><?php
            echo formatearNumero(htmlentities($detalle["precio_unitario"], ENT_QUOTES)) . "€"
            ?></td>
                                            <td><?php
            echo formatearNumero(sprintf("%.2f", ($detalle["precio_unitario"] * explode(" ", trim($detalle["cantidad"]))[0])));
            ?>€</td>
                                            <td><a type="button" class="mr-2 editar-row btn btn-sm btn-info"
                                                    data-descripcion="<?php echo htmlentities($detalle["descripcion"], ENT_QUOTES) ?>"
                                                    data-titulo="<?php echo htmlentities($detalle["titulo"], ENT_QUOTES) ?>"
                                                    data-medida="<?php
                                                                                                                                                                                                                                                            if (count(explode(' ', trim($detalle['cantidad']))) > 1) {
                                                                                                                                                                                                                                                                echo explode(' ', trim($detalle['cantidad']))[1];
                                                                                                                                                                                                                                                            } else
                                                                                                                                                                                                                                                                echo "Ninguna"; {
                                                                                                                                                                                                                                                            } ?>">Editar</a><a
                                                    type="button" data-id="eliminar"
                                                    class="eliminar-row btn btn-sm btn-danger">Eliminar</a>
                                            </td>
                                        </tr>
                                        <?php
    $i++;
}
?>




                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                    <input type="hidden" value=0 id="total_presupuesto" name="total_presupuesto">
                    <input type="hidden" value="<?php echo $PresupuestoEditar["id_presupuesto"]; ?>"
                        id="id_presupuesto">



                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label>Condiciones Generales</label>
                                <textarea class="form-control" type="text" class="form-control m-0"
                                    id="condiciones_presupuesto" placeholder=""><?php 
                                   
                                      
                                   $arreglo = explode("\\n", $PresupuestoEditar['condiciones']);
                                   $condi = "";
                                   $contador = 0;
                       $total_elementos = count($arreglo);
                                   foreach ($arreglo as $a) {
                                      
                                    if ($contador === $total_elementos - 1) {
                                        $condi .= $a;
                                    } else {
                                        $condi .= $a . "\n";
                                    }
                                    
                                    $contador++;
                                       
                                   }
                                   echo htmlentities($condi, ENT_QUOTES); 
                                                           ?></textarea>
                            </div>
                        </div>
                        <div class="col-12 text-right">
                            <button type="button" data-estado="No enviado" id="btn_guardar"
                                class="btn_guardar btn btn-sm btn-success">Guardar</button>
                            <button type="button" data-estado="Pendiente" id="btn_enviar"
                                class="btn_guardar btn btn-sm btn-success">Guardar
                                y enviar</button>
                        </div>

                    </div>


                </div>
            </div>
        </div>
    </div>









</div>



<div class="modal fade" id="modalAgregarCondicion" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar condición</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">

                    <div class="row">
                        <div class="col-12">

                            <div class="form-group">

                                <label>Título</label>

                                <input id="titulo_condicion" class="form-control" type="text">
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Condición</label>

                                <textarea class="form-control" id="cuerpo_condicion" id="" cols="30"
                                    rows="10"></textarea>
                            </div>

                        </div>




                    </div>


                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_agregar_condicion" type="button">

                    Añadir</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarCondicion" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Editar condición</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">

                    <div class="row">
                        <div class="col-12">

                            <div class="form-group">

                                <label>Título</label>

                                <input id="titulo_condicion_editar" class="form-control" type="text">
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Condición</label>

                                <textarea class="form-control" id="cuerpo_condicion_editar" id="" cols="30"
                                    rows="10"></textarea>
                            </div>

                        </div>




                    </div>


                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_edit_condicion" type="button">

                    Editar</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>

<!-- MODALS -->
<div class="modal fade" id="modalVerPresupuesto" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div style="max-width:800px;" class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>
            <div class="modal-body">
                <div id="presupuesto-pdf-container"
                    style="background:#ffffff;width:100%;display:block;font-family:'Poppins', sans-serif;font-size:13px;"
                    class="table-responsive">
                    <div style="padding: 1.5rem;">
                        <div style="width:100%; margin-bottom: 1rem; ">

                            <img id="img_pdf" style="width: 250px; margin-bottom:1rem;"
                                src="<?php echo htmlentities($personalizacion['url_imagen_presupuesto'], ENT_QUOTES); ?>">


                        </div>


                        <div class="row">

                            <div class="col-md-6">

                                <h4 style="margin-bottom:.2rem;">
                                    <?php echo htmlentities($personalizacion['nombre'], ENT_QUOTES); ?></h4>
                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Dirección:
                                    </strong><?php echo htmlentities($personalizacion['direccion'], ENT_QUOTES); ?></p>
                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Teléfono:
                                    </strong><?php echo htmlentities($personalizacion['telefono'], ENT_QUOTES); ?></p>
                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Fax:
                                    </strong><?php echo htmlentities($personalizacion['fax'], ENT_QUOTES); ?></p>
                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Email:
                                    </strong><?php echo htmlentities($personalizacion['email'], ENT_QUOTES); ?>
                                </p>
                                <p style="margin-bottom:0rem;color:#67757c;"><a
                                        href="<?php echo htmlentities($personalizacion['web'], ENT_QUOTES); ?>"><?php echo htmlentities($personalizacion['web'], ENT_QUOTES); ?></a>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <h4 id="pdf_nombre_cliente" style="margin-bottom:.2rem;">

                                </h4>
                                <p id="pdf_direccion_cliente_view" style="margin-bottom:.2rem;color:#67757c;">
                                    <strong>Dirección: </strong><span id="pdf_direccion_cliente"></span>
                                </p>
                                <p style="margin-bottom:.2rem;color:#67757c;" id="pdf_obra" class="d-none mb-2">
                                    <strong>Obra: </strong><span id="pdf_obra_cliente"></span>
                                </p>
                                <p style="margin-bottom:.2rem;color:#67757c;" id="pdf_sector" class="d-none mb-2">
                                    <strong>Sector: </strong><span id="pdf_sector_cliente"></span>
                                </p>
                                <p style="margin-bottom:.2rem;color:#67757c;" id="pdf_fase" class="d-none mb-2">
                                    <strong>Fase: </strong><span id="pdf_fase_cliente"></span>
                                </p>

                                <p id="pdf_telefono_cliente_view" style="margin-bottom:.2rem;color:#67757c;">
                                    <strong>Teléfono: </strong><span id="pdf_telefono_cliente"></span>
                                </p>

                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Email: </strong><span
                                        id="pdf_email_cliente">
                                </p>
                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>CIF: </strong> <span
                                        id="pdf_cif_cliente"></span></p>
                                <p style="color:#67757c;" class="mb-0"><strong>CP: </strong> <span
                                        id="pdf_cp_cliente"></span></p>
                            </div>
                        </div>

                        <hr>
                        <div class="row">

                            <div class="col-md-6">
                                <p style="color:#67757c;" class="mb-1">
                                    <strong>Concepto: </strong><span id="pdf_titulo"></span>
                                </p>
                                <p style="color:#67757c;" class="mb-1">
                                    <strong>Lugar: </strong><span id="pdf_lugar"></span>
                                </p>
                                <p style="color:#67757c;" class="mb-0">
                                    <strong>Fechas: </strong><span id="pdf_fechas"></span>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <table class="w-100 table-fc table_responsive table-bordered">
                                    <thead>
                                        <tr>
                                            <td class="p-2">Nº presupuesto</td>
                                            <td class="p-2">Fecha</td>

                                        </tr>
                                    </thead>

                                    <tbody>
                                        <tr>
                                            <td id="pdf_numero_presupuesto" class="p-2"></td>
                                            <td id="pdf_fecha_presupuesto" class="p-2"></td>
                                        </tr>

                                    </tbody>


                                </table>
                            </div>

                        </div>
                        <hr>
                        <table class="w-100 table-fc table_responsive table-bordered" style="margin-bottom:1rem;">
                            <thead>
                                <tr>

                                    <th
                                        style="color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;padding-top: 10px;border-bottom: 2px solid <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>;border-spacing: 0px;">
                                        Código</th>

                                    <th
                                        style="color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;padding-top: 10px;border-bottom: 2px solid <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>;border-spacing: 0px;">
                                        Cantidad</th>
                                    <th
                                        style="color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;padding-top: 10px;border-bottom: 2px solid <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>;border-spacing: 0px;">
                                        Descripción</th>
                                    <th
                                        style="color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;padding-top: 10px;border-bottom: 2px solid <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>;border-spacing: 0px;">
                                        Precio unitario</th>

                                    <th
                                        style="color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;padding-top: 10px;border-bottom: 2px solid <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>;border-spacing: 0px;">
                                        Total</th>
                                </tr>

                            </thead>
                            <tbody id="tabla-pdf">

                            </tbody>

                        </table>
                        <hr>
                        <div style="display:block;width:100%;">

                            <p class="mb-2" id="subtotal_pdf" style="display:block;width:100%;text-align:right;"></p>
                            <div id="impuestos_pdf"></div>

                            <p class="mb-0" id="total_pdf" style="display:block;width:100%;text-align:right;"></p>

                        </div>
                        <div class="row" id="pdf_condiciones_view">
                            <div class="col-12 mb-3">
                                <h4 class="mb-2">Condiciones generales</h4>
                                <div id="pdf_condiciones"></div>
                            </div>

                        </div>
                        <div class="row" id="pdf_notas_view">
                            <div class="col-12 mb-3">
                                <h4 class="mb-2">Nota</h4>
                                <p class="mb-0" id="pdf_nota"></p>
                            </div>
                        </div>

                    </div>

                </div>

                <div class="modal-footer text-right">





                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>


            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>


<div class="modal fade" id="modalAgregarClienteNuevo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="nb-0">Agregar Cliente</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">


                    <div class="row">

                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nombre del cliente</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                            data-target="select-seleccionar-cliente" type="button">-</button>
                                    </span>
                                    <select id="select-seleccionar-cliente"
                                        class="select_clientes custom-select select2 form-control">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCliente">+</button>
                                    </span>
                                </div>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>CIF</label>

                                <input type="text" class="form-control" id="input_cif" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Domicilio</label>

                                <input type="dir" class="form-control" id="input_domicilio" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>C.P</label>

                                <input type="number" class="form-control" id="input_cp" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Teléfono</label>

                                <input type="tel" class="form-control" id="input_telefono" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Email</label>

                                <select class="select2 form-control" id="input_email" placeholder="">

                            </div>

                        </div>

                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Tipo</label>

                                <select id="tipo_cliente" class="form-control custom-select text-center">
                                    <option type="text" value="Particular">Particular</option>
                                    <option type="text" value="Empresa">Empresa</option>
                                </select>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Obra</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_obra file-upload-browse btn btn-danger"
                                            data-target="input_obra" type="button">-</button>
                                    </span>
                                    <select id="input_obra" class="select_obras custom-select select2 form-control">
                                        <option value="No">
                                            Ninguna
                                        </option>
                                        <?php
                                        foreach ($Obras as $Obra) {
                                        ?>
                                        <option value="<?php echo $Obra['id_obra']; ?>">
                                            <?php echo $Obra['nombre']; ?>
                                        </option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarObra">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Sector</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_sector file-upload-browse btn btn-danger"
                                            data-target="input_sector" type="button">-</button>
                                    </span>
                                    <select id="input_sector"
                                        class="select_sectores custom-select select2 form-control">
                                        <option value="No">
                                            Ninguno
                                        </option>
                                        <?php
                                        foreach ($Sectores as $Sector) {
                                        ?>
                                        <option value="<?php echo $Sector['id_sector']; ?>">
                                            <?php echo $Sector['nombre']; ?>
                                        </option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarSector">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>

                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Fase</label>



                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_fase file-upload-browse btn btn-danger"
                                            data-target="input_fase" type="button">-</button>
                                    </span>
                                    <select id="input_fase" class="select_fases custom-select select2 form-control">
                                        <option value="No">
                                            Ninguna
                                        </option>
                                        <?php
                                        foreach ($Fases as $Fase) {
                                        ?>
                                        <option value="<?php echo $Fase['id_fase']; ?>">
                                            <?php echo $Fase['nombre']; ?>
                                        </option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarFase">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Responsable</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            data-toggle="modal" data-target="#modalQuitarNombre">-</button>
                                    </span>
                                    <select name="input_usuario" id="input_usuario"
                                        class="form-control custom-select text-center select2">
                                        <?php

                                        foreach ($User_List as $User) {
                                        ?>
                                        <option type="text"
                                            value="<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>">
                                            <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>
                                        </option>
                                        <?php

                                        }
                                        ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarNombre">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <!--
                                 <div class="col-lg-4">

                                     <div class="form-group">

                                         <label>Estado</label>

                                         <select name="estado_cliente" class="form-control custom-select text-center">



                                             <option type="text" value="Pendiente">Pendiente</option>

                                             <option type="text" value="Contradado">Contradado</option>

                                             <option type="text" value="Denegado">Denegado</option>

                                         </select>


                                     </div>

                                 </div>-->
                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-success btn-fw" id="btn-add-cliente2">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>










<!-- Modals unidad tramitadora  -->
<div class="modal fade" id="modalEditarBorrarTramitadora" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">

    <div style="max-width:400px;" class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar Unidad</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class=" d-none form-group">
                            <input readonly type="text" id="edit_role_id" class="w-100 form-control" placeholder="id">
                        </div>
                        <div class="form-group">
                            <input readonly type="text" id="edit_role_code" class="w-100 form-control"
                                placeholder="Codigo Unidad">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input readonly type="text" id="edit_role_name" class="w-100 form-control"
                                placeholder="Nombre">
                        </div>
                    </div>
                    <div class="col-md-6">

                        <div class="form-group">
                            <input readonly type="text" id="edit_role_address" class="w-100 form-control"
                                placeholder="Dirección">
                        </div>
                    </div>
                    <div class="col-md-6">

                        <div class="form-group">
                            <input readonly type="text" id="edit_role_cp" class="w-100 form-control"
                                placeholder="Codigo Postal">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group ">
                            <input readonly type="text" id="edit_role_city" class="w-100 form-control"
                                placeholder="Ciudad">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input readonly type="text" id="edit_role_province" class="w-100 form-control"
                                placeholder="Provincia">
                        </div>
                    </div>
                </div>


            </div>
            <div class="modal-footer pb-3 text-right">
                <button id="btn-delete-unidad-tramitadora" class="btn btn-danger btn-fw" type="submit">
                    Borrar
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade" id="modalcrearUnidad" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div style="max-width:400px;" class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">

                <h4 class="nb-0">Agregar Unidades</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <select name="create_role_tramit" id="create_role_tramite"
                            class="form-control custom-select text-center select2" required>
                            <option value="role_gestor">Unidad Gestora</option>
                            <option value="role_tramitadora">Unidad Tramitadora</option>
                            <option value="role_contable">Unidad Contable</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="text" id="create_role_code" class="form-control w-100"
                                placeholder="Codigo Unidad">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="text" id="create_role_name" class="form-control w-100" placeholder="Nombre">
                        </div>
                    </div>
                    <div class="col-md-6">

                        <div class="form-group">
                            <input type="text" id="create_role_address" class="form-control w-100"
                                placeholder="Dirección">
                        </div>
                    </div>
                    <div class="col-md-6">

                        <div class="form-group">
                            <input type="text" id="create_role_cp" class="form-control w-100"
                                placeholder="Codigo Postal">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group ">
                            <input type="text" id="create_role_city" class="form-control w-100" placeholder="Ciudad">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="text" id="create_role_province" class="form-control w-100"
                                placeholder="Provincia">
                        </div>
                    </div>
                </div>


            </div>
            <div class="modal-footer pb-3 text-right">
                <button id="btn-crear-unidad-tramitadora" class="btn btn-info btn-fw" type="submit">
                    Crear
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<?php require_once __VIEWS__ . 'selects/fases.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/obras.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/sectores.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/apartados.template.php'; ?>
<script>
function Unidades(num) {

    switch (num) {
        case 1:
            return 'Un ';
        case 2:
            return 'Dos ';
        case 3:
            return 'Tres ';
        case 4:
            return 'Cuatro ';
        case 5:
            return 'Cinco ';
        case 6:
            return 'Seis ';
        case 7:
            return 'Siete ';
        case 8:
            return 'Ocho ';
        case 9:
            return 'Nueve ';
    }

    return '';
} //Unidades()

function Decenas(num) {

    decena = Math.floor(num / 10);
    unidad = num - (decena * 10);

    switch (decena) {
        case 1:
            switch (unidad) {
                case 0:
                    return 'Diez ';
                case 1:
                    return 'Once ';
                case 2:
                    return 'Doce ';
                case 3:
                    return 'Trece ';
                case 4:
                    return 'Catorce ';
                case 5:
                    return 'Quince ';
                default:
                    return 'Dieci ' + Unidades(unidad);
            }
            case 2:
                switch (unidad) {
                    case 0:
                        return 'Veinte ';
                    default:
                        return 'Veinti ' + Unidades(unidad);
                }
                case 3:
                    return DecenasY('Treinta ', unidad);
                case 4:
                    return DecenasY('Cuarenta ', unidad);
                case 5:
                    return DecenasY('Cincuenta ', unidad);
                case 6:
                    return DecenasY('Sesenta ', unidad);
                case 7:
                    return DecenasY('Setenta ', unidad);
                case 8:
                    return DecenasY('Ochenta ', unidad);
                case 9:
                    return DecenasY('Noventa ', unidad);
                case 0:
                    return Unidades(unidad);
    }
} //Unidades()

function DecenasY(strSin, numUnidades) {
    if (numUnidades > 0)
        return strSin + 'Y ' + Unidades(numUnidades)

    return strSin;
} //DecenasY()

function Centenas(num) {
    centenas = Math.floor(num / 100);
    decenas = num - (centenas * 100);

    switch (centenas) {
        case 1:
            if (decenas > 0)
                return 'Ciento ' + Decenas(decenas);
            return 'Cien ';
        case 2:
            return 'Doscientos ' + Decenas(decenas);
        case 3:
            return 'Trescientos ' + Decenas(decenas);
        case 4:
            return 'Cuatrocientos ' + Decenas(decenas);
        case 5:
            return 'Quinientos ' + Decenas(decenas);
        case 6:
            return 'Seiscientos ' + Decenas(decenas);
        case 7:
            return 'Setecientos ' + Decenas(decenas);
        case 8:
            return 'Ochocientos ' + Decenas(decenas);
        case 9:
            return 'Novecientos ' + Decenas(decenas);
    }

    return Decenas(decenas);
} //Centenas()

function Seccion(num, divisor, strSingular, strPlural) {
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    letras = '';

    if (cientos > 0)
        if (cientos > 1)
            letras = Centenas(cientos) + '' + strPlural;
        else
            letras = strSingular;

    if (resto > 0)
        letras += '';

    return letras;
} //Seccion()

function Miles(num) {
    divisor = 1000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMiles = Seccion(num, divisor, 'un mil ', 'mil ');
    strCentenas = Centenas(resto);

    if (strMiles == '')
        return strCentenas;

    return strMiles + '' + strCentenas;
} //Miles()

function Millones(num) {
    divisor = 1000000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMillones = Seccion(num, divisor, 'un millon de ', 'millones de ');
    strMiles = Miles(resto);

    if (strMillones == '')
        return strMiles;

    return strMillones + '' + strMiles;
} //Millones()

function NumeroALetras(num) {
    var data = {
        numero: num,
        enteros: Math.floor(num),
        centimos: (((Math.round(num * 100)) - (Math.floor(num) * 100))),
        letrasCentavos: '',
        letrasMonedaPlural: 'Euros ', //'PESOS', 'Dólares', 'Bolívares', 'etcs'
        letrasMonedaSingular: 'Euro ', //'PESO', 'Dólar', 'Bolivar', 'etc'

        letrasMonedaCentavoPlural: 'céntimos ',
        letrasMonedaCentavoSingular: 'céntimo '
    };

    if (data.centimos > 0) {
        data.letrasCentavos = 'con ' + (function() {
            if (data.centimos == 1)
                return Millones(data.centimos) + '' + data.letrasMonedaCentavoSingular;
            else
                return Millones(data.centimos) + '' + data.letrasMonedaCentavoPlural;
        })();
    };

    if (data.enteros == 0)
        return 'cero ' + data.letrasMonedaPlural + '' + data.letrasCentavos;
    if (data.enteros == 1)
        return Millones(data.enteros) + '' + data.letrasMonedaSingular + '' + data.letrasCentavos;
    else
        return Millones(data.enteros) + '' + data.letrasMonedaPlural + '' + data.letrasCentavos;
} //NumeroALetras()

(function($) {

    'use strict';
    $(function() {
        if ($("#nota_externa").length > 0) {
            tinymce.init({
                selector: "textarea#nota_externa",
                theme: "modern",
                height: 200,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }
        if ($("#nota_interna").length > 0) {
            tinymce.init({
                selector: "textarea#nota_interna",
                theme: "modern",
                height: 200,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }
        var Table = $('#order-listing').DataTable({

            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en apartados",
                infoEmpty: "Mostrando 0 a 0 de 0 en apartados",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },

            "buttons": [{
                extend: 'colvis',
                text: 'Ocultar Columnas',
                collectionLayout: 'fixed two-column',
                className: "form-control"
            }],

            // "ordering": false,
            "columns": [{
                    "data": "index"
                }, {
                    "data": "codigo"
                },
                {
                    "data": "cantidad"
                },
                {
                    "data": "descripcion",
                    "className": 'contenido dropdown'
                },
                {
                    "data": "precio_unitario"
                },
                {
                    "data": "total"
                },
                {
                    "data": "acciones"
                }
            ],
            colReorder: true,

            columnDefs: [{
                targets: 0,
                visible: false
            }],
            rowReorder: {
                dataSrc: 'index'
            }
        });

        Table.on('row-reordered', function(e, details, changes) {
            // obtener el nuevo orden de las filas
            console.log(e.target);
            console.log(details);

            console.log(changes);
            Table.draw()
        });

        $('#titulo_check').change(function(event) {
            if ($(this).prop("checked")) {
                $('#titulo_edit').attr("disabled", false)
            } else {
                $('#titulo_edit').attr("disabled", true)
            }

        })



        if ($('#tipo_cliente').val() == "Empresa") {
            $('#irpfview').css("display", "flex")
        } else {
            $('#irpfview').css("display", "none")
        }


        $('#tipo_cliente').change(function(event) {
            if ($(this).val() == "Empresa") {
                $('#irpfview').css("display", "flex")
            } else {
                $('#irpfview').css("display", "none")
            }
            calcularSubtotal()
        })
        calcularSubtotal()
        Table.on('draw', function() {
            calcularSubtotal()

        });


        $("#igicotro").change(function() {

            $("#igic").val($(this).val())

            calcularSubtotal()
        })
        $("input[name=igic]").change(function() {
            calcularSubtotal()
        })
        $("#irpf").change(function() {


            calcularSubtotal()
        })

        function calcularSubtotal() {
            var subtotal = 0.00;

            Table.rows().data().map((row) => {

                var precio = convertirFormato(row["precio_unitario"].replace('€', ''))
                var cantidad = row["cantidad"].split(" ")[0]

                subtotal += parseInt(cantidad) * parseFloat(precio)

            })



            // console.log(subtotal);
            var total = subtotal;

            let por = $("input[name=igic]:checked").val() / 100;

            total = total + parseFloat(subtotal * por);

            // console.log(total);
            if ($('#tipo_cliente').val() == "Empresa") {
                var porcentaje = $('#irpf').val() / 100

                console.log(porcentaje);
                total = total - parseFloat(subtotal * porcentaje)


            }




            document.getElementById('subtotal').innerHTML = "Subtotal: " + formatearNumero(subtotal.toFixed(
                2)) + "€";
            $('#subtotal').data("total", subtotal.toFixed(2))
            document.getElementById('total').innerHTML = "Total: " + formatearNumero(total.toFixed(2)) +
                "€";
            $('#total').data("total", total.toFixed(2))
            document.getElementById('total_presupuesto').value = total.toFixed(2);
            document.getElementById('total_letras').innerHTML = NumeroALetras(total.toFixed(2));

        }
        // Facturae Checkbox
        $("#programado").click(() => {
            const is_checked = $("#programado").is(":checked");
            if (is_checked) {
                $("#programacion_presupuesto").prop('disabled', false);
            } else {
                $("#programacion_presupuesto").prop('disabled', true);
            }

        })



        function UpdatePDF() {
            var tablaPdf = document.getElementById("tabla-pdf")
            tablaPdf.innerHTML = ""
            var datos = [];

            Table.rows().data().map((row) => {

                var codigo = (row["codigo"] != null) ? row["codigo"] : ""
                var inner = document.createRange().createContextualFragment(row["descripcion"])
                var descripcion = document.createElement("div")
                descripcion.className = "drop_drop";
                descripcion.appendChild(inner);
                console.log(descripcion);
                let data = {
                    codigo: codigo,
                    cantidad: row["cantidad"].replace(/\s+/g, ' ').trim(),
                    descripcion: descripcion.innerHTML,
                    precio_unitario: row["precio_unitario"].replace('€', ''),
                    total: row["total"].replace('€', '')
                }
                datos.push(data)


            })
            console.log(datos);
            for (let d of datos) {

                tablaPdf.innerHTML += '<tr><td style="padding:0.5rem;">' + d.codigo +
                    '</td><td style="padding:0.5rem;">' + d.cantidad +
                    '</td><td class="contenido dropdown show" style="padding:0.5rem;">' + d.descripcion +
                    '</td><td style="padding:0.5rem;">' + d.precio_unitario + '€' +
                    '</td><td style="padding:0.5rem;">' + d.total + '€' +
                    '</td style="padding:0.5rem;"></tr>'
            }

            $('#img_pdf').attr("src", $('#url_imagen_presupuesto img').attr("src"))
            $('#pdf_nombre_cliente').text($('#cliente_presupuesto').find(':selected').text())
            $('#pdf_direccion_cliente').text($('#input_domicilio').val())
            if (!isNaN(parseFloat($('#input_obra').val()))) {
                $('#pdf_obra_cliente').text($('#input_obra').find(':selected').text())
                $('#pdf_obra').removeClass("d-none")
            } else {
                $('#pdf_obra').addClass("d-none")
            }
            if (!isNaN(parseFloat($('#input_sector').val()))) {
                $('#pdf_sector_cliente').text($('#input_sector').find(':selected').text())
                $('#pdf_sector').removeClass("d-none")
            } else {
                $('#pdf_sector').addClass("d-none")
            }
            if (!isNaN(parseFloat($('#input_fase').val()))) {
                $('#pdf_fase_cliente').text($('#input_fase').find(':selected').text())
                $('#pdf_fase').removeClass("d-none")
            } else {
                $('#pdf_fase').addClass("d-none")
            }

            $('#pdf_telefono_cliente').text($('#input_telefono').val())
            $('#pdf_email_cliente').text($('#input_email').val())
            $('#pdf_cif_cliente').text($('#input_cif').val())
            $('#pdf_cp_cliente').text($('#input_cp').val())
            $('#pdf_numero_presupuesto').text($('#numero_presupuesto').val())
            $('#pdf_fecha_presupuesto').text(moment($('#fecha_presupuesto').val()).format(
                'YYYY-MM-DD'))

            if ($('#titulo_presupuesto').val() == "") {
                $("#pdf_titulo").parent().css("display", "none")
            } else {
                $("#pdf_titulo").parent().css("display", "block")
            }
            if ($('#lugar_presupuesto').val() == "") {
                $("#pdf_lugar").parent().css("display", "none")
            } else {
                $("#pdf_lugar").parent().css("display", "block")
            }
            if ($('#fechas_presupuesto').val() == "") {
                $("#pdf_fechas").parent().css("display", "none")
            } else {
                $("#pdf_fechas").parent().css("display", "block")
            }




            if ($('#condiciones_presupuesto').val() != "") {
                var lineas = $('#condiciones_presupuesto').val().split("\n");
                var condi = ""
                for (let l of lineas) {
                    condi += '<p style="margin-bottom:.1rem">';
                    condi += l
                    condi += '</p>';
                }
                $('#pdf_condiciones').html(condi)
                $('#pdf_condiciones_view').css("display", "flex")
            } else {
                $('#pdf_condiciones_view').css("display", "none")
            }
            $("#mail").val($('#input_email').val())
            if (tinymce.get('nota_externa').getBody().textContent != "") {
                $('#pdf_nota').text(tinymce.get('nota_externa').getBody().textContent)

                $('#pdf_notas_view').css("display", "flex")
            } else {
                $('#pdf_notas_view').css("display", "none")
            }
            $('#total_pdf').text("Total: " + formatearNumero(parseFloat($('#total').data("total")).toFixed(
                2)) + '€')
            $('#subtotal_pdf').text("Subtotal: " + formatearNumero(parseFloat($('#subtotal').data("total"))
                    .toFixed(2)) +
                '€')


            var impuestos = ''
            impuestos +=
                '<p style="margin-bottom: 0.5rem;display:block;width:100%;text-align:right;">Impuesto: +' +
                formatearNumero(parseFloat($("input[name=igic]:checked").val()).toFixed(2)) + '% = ' +
                formatearNumero(parseFloat($('#subtotal').data("total") *
                    ($("input[name=igic]:checked").val() / 100)).toFixed(2)) +
                '€</p>'
            if ($("#tipo_cliente").val() == "Empresa") {
                impuestos +=
                    '<p style="margin-bottom: 0.5rem;display:block;width:100%;text-align:right;">I.R.P.F -' +
                    formatearNumero(parseFloat($('#irpf').val()).toFixed(2)) + '% = ' + formatearNumero(
                        parseFloat($('#subtotal').data("total") * (
                            $('#irpf').val()) / 100).toFixed(2)) + '€</p>'
            }
            $("#impuestos_pdf").html(impuestos)

            $("#pdf").val($("#presupuesto-pdf-container").html())

        }


        function ValidatePresupuesto() {

            var follow = true;



            if ($('#numero_presupuesto').val() == "") {
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                $.toast({
                    heading: 'Por favor rellena el campo de Nº de presupuesto.',
                    text: 'No se ha agregado el número del presupuesto.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                follow = false;
            }
            return follow;

        }

        $('#emails').tagsinput();

        function EnviarPresupuestoConEmail(id, email) {

            var id_presupuesto_enviar = id
            $.ajax({
                type: 'POST',
                url: './mailer',
                cache: false,
                async: false,
                data: {
                    id_presupuesto_enviar_multiples: id_presupuesto_enviar,
                    email: email
                },
                success: function(result2) {
                    console.log(result2);
                    $.toast({
                        heading: 'Presupuesto enviada a ' + email,
                        text: 'Se ha enviado el presupuesto correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                }
            });
        }

        function EnviarConRetraso(coleccion, id, callback) {
            var index = 0;

            function iteracion() {
                // Llamada a la función EnviarFacturaConEmail al comienzo de cada iteración
                EnviarPresupuestoConEmail(id, coleccion[index]);

                // Realiza tu lógica de iteración aquí
                console.log(coleccion[index]);

                index++;

                if (index < coleccion.length) {
                    setTimeout(iteracion, index === 1 ? 0 :
                        5000); // Espera 5 segundos después de la primera iteración
                } else {
                    // Se ejecuta el código de finalización cuando se completa la iteración
                    if (typeof callback === 'function') {
                        callback();
                    }
                }
            }

            if (coleccion.length > 0) {
                setTimeout(iteracion, 0); // Inicia la primera iteración de inmediato
            } else {
                // Si la colección está vacía, también se ejecuta el código de finalización
                if (typeof callback === 'function') {
                    callback();
                }
            }
        }


        function validarEmail(email) {
            var patron = /^[\w\.-]+@[\w\.-]+\.\w+$/;
            return patron.test(email);
        }
        $('#emails').on('beforeItemAdd', function(event) {
            var nuevoTag = event.item;

            // Realiza tu validación aquí
            if (!validarEmail(nuevoTag)) {
                event.cancel = true; // Cancela la adición del nuevo tag
                $.toast({
                    heading: 'Email inválido',
                    text: 'Por favor ingresa un correo electrónico válido.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
            }
        });

        $(document).on("click", '.btn_guardar', function(event) {

            $(this).attr("disabled", true);
            $(this).addClass("btn-loading");
            if (!ValidatePresupuesto()) {
                $(this).attr("disabled", false);
                $(this).removeClass("btn-loading");
                return false
            }
            var id_presupuesto = "<?php echo $_GET["id"]; ?>"
            var datos = [];
            Table.rows().data().map((row) => {
                var newRow = {};
                for (var key in row) {
                    if (row.hasOwnProperty(key)) {
                        var value = row[key];
                        // Aplicar la operación de reemplazo si el valor es una cadena
                        if (typeof value === 'string') {
                            newRow[key] = value.replace(/\n/g, '');
                        } else {
                            newRow[key] =
                                value; // Mantener el valor sin cambios si no es una cadena
                        }
                    }
                }
                console.log($.parseHTML(newRow["descripcion"].replace(/\n+/g, '').replace(
                    / {3,}/g, '')));
                let codigo = newRow["codigo"]
                let descripcion = $.parseHTML(newRow["descripcion"].replace(/\n+/g, '')
                    .replace(/ {3,}/g, ''))[1].querySelector('p').innerText
                let titulo = $.parseHTML(newRow["descripcion"].replace(/\n+/g, '').replace(
                    / {3,}/g, ''))[0].innerText

                let data = {
                    codigo: codigo,
                    cantidad: newRow["cantidad"].replace(/\s+/g, ' ').trim(),
                    titulo: titulo.replace(/\s+/g, ' ').trim(),
                    descripcion: descripcion.replace(/\s+/g, ' ').trim(),
                    precio_unitario: parseFloat(convertirFormato(newRow[
                            "precio_unitario"]
                        .replace('€', ''))).toFixed(2)
                }
                datos.push(data)
            })
            var fechas_presupuesto = $('#fechas_presupuesto').val()
            var lugar_presupuesto = $('#lugar_presupuesto').val()
            var imagen_presupuesto = $("#url_imagen_presupuesto input").val()
            var fecha_presupuesto = moment($('#fecha_presupuesto').val()).format(
                'YYYY-MM-DD HH:mm:ss')
            var numero_presupuesto = $('#numero_presupuesto').val()

            var cif_presupuesto = ($('#input_cif').val() != "") ? $('#input_cif').val() : "No"
            var cp_presupuesto = ($('#input_cp').val() != "") ? $('#input_cp')
                .val() : "No"
            var direccion_presupuesto = ($('#input_domicilio').val() != "") ? $('#input_domicilio')
                .val() : "No"
            var telefono_presupuesto = ($('#input_telefono').val() != "") ? $('#input_telefono')
                .val() : "No"
            var email_presupuesto = ($('#input_email').val() != "") ? $('#input_email').val() : "No"
            var tipo_presupuesto = $('#tipo_cliente').val()
            var usuario_presupuesto = parseFloat($('#input_usuario').val())
            var id_obra_presupuesto = $('#input_obra').val()
            var id_sector_presupuesto = $('#input_sector').val()
            var id_fase_presupuesto = $('#input_fase').val()
            var total_presupuesto = (Math.round(parseFloat($("#subtotal").data("total")) * 100) /
                100).toFixed(2)
            var importe_final = (Math.round(parseFloat($("#total").data("total")) * 100) / 100)
                .toFixed(2)
            var detalle_presupuesto = JSON.stringify(datos)
            var titulo_presupuesto = $('#titulo_presupuesto').val()
            var cliente_presupuesto = $('#cliente_presupuesto').find(':selected').val()
            var id_tramitadora = $('#id_tramitadora').find(':selected').val()
            var id_gestor = $('#id_gestor').find(':selected').val()
            var id_contable = $('#id_contable').find(':selected').val()
            var condiciones_presupuesto = ($('#condiciones_presupuesto').val() != "") ? $(
                '#condiciones_presupuesto').val().replace(/(\r\n|\n|\r)/g, "\\n") : "No"
            var igic = $("input[name=igic]:checked").val();
            var irpf = "No"
            if ($('#tipo_cliente').val() == "Empresa") {
                irpf = $('#irpf').val()
            }
            var nota_interna = tinymce.get('nota_interna').getBody().textContent
            var nota_externa = (tinymce.get('nota_externa').getBody().textContent != "") ? tinymce
                .get('nota_externa').getBody().textContent : "No"
            const is_checked = $("#facturae_enabled").is(":checked");

            var programacion_presupuesto = $("#programado").is(":checked") ? moment($(
                '#programacion_presupuesto').val()).format(
                'YYYY-MM-DD HH:mm') : "No"
            console.log(condiciones_presupuesto)
            var estado_presupuesto = $(this).data("estado")
            $.ajax({
                type: 'POST',
                url: './api/presupuestos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    estado: estado_presupuesto,
                    fecha: fecha_presupuesto,
                    cif: cif_presupuesto,
                    cp: cp_presupuesto,
                    domicilio: direccion_presupuesto,
                    telefono: telefono_presupuesto,
                    email: email_presupuesto,
                    tipo: tipo_presupuesto,
                    id_usuario: usuario_presupuesto,
                    id_obra: id_obra_presupuesto,
                    id_sector: id_sector_presupuesto,
                    id_fase: id_fase_presupuesto,
                    importe_final: importe_final,
                    importe: total_presupuesto,
                    detallado: detalle_presupuesto,
                    titulo: titulo_presupuesto,
                    id_cliente: cliente_presupuesto,
                    condiciones: condiciones_presupuesto,
                    numero: numero_presupuesto,
                    igic: igic,
                    irpf: irpf,
                    id_contable: is_checked ? id_contable : "No",
                    id_gestor: is_checked ? id_gestor : "No",
                    id_tramitadora: is_checked ? id_tramitadora : "No",
                    nota_interna: nota_interna,
                    nota_externa: nota_externa,
                    programado: programacion_presupuesto,
                    imagen: imagen_presupuesto,
                    fechas: fechas_presupuesto,
                    lugar: lugar_presupuesto,
                    id_presupuesto: id_presupuesto
                },

                success: function(id) {

                    console.log(id)
                    if (estado_presupuesto == "Pendiente") {
                        var tagsInput = $('#emails').tagsinput('items');

                        EnviarPresupuesto(id)

                        $.toast({
                            heading: 'Presupuesto guardado y enviado.',
                            text: 'Se ha guardado el presupuesto correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        EnviarConRetraso(tagsInput, id, function() {

                            setTimeout(function() {

                                window.location.href =
                                    "./cliente?id=" +
                                    cliente_presupuesto +
                                    "&enviadostab=1"
                            }, 2000);
                        });

                    } else {
                        $.toast({
                            heading: 'Presupuesto guardado.',
                            text: 'Se ha guardado el presupuesto correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        setTimeout(function() {

                                window.location.href =
                                    "./historial_presupuestos"



                            },
                            2000);
                    }



                }
            });

            return false;
        })



        function EnviarPresupuesto(id) {
            var id_presupuesto_enviar = id
            $.ajax({
                type: 'POST',
                url: './mailer',
                cache: false,
                async: false,
                data: {
                    id_presupuesto_enviar: id_presupuesto_enviar

                },
                success: function(result2) {
                    console.log(result2);
                }
            });
        }




        var formulario = document.getElementById('form-agregar');
        formulario
            .addEventListener("submit", handleSubmit);
        var btnVerPresupuesto = document.getElementById("verPresupuesto");
        var tablaPdf = document.getElementById("tabla-pdf")

        btnVerPresupuesto.addEventListener('click', function() {
            UpdatePDF()




        })



        function handleSubmit(e) {
            e.preventDefault();
            var des = $("#descripcion_edit").val()
            var tit = $("#titulo_edit").val()
            var prec = $("#precio_unitario_edit").val()
            var cant = $("#cantidad_edit").val()

            if (des == "" || (tit == "" && $('#titulo_check').prop("checked")) || prec == "" || cant ==
                "") {
                $.toast({
                    heading: 'Por favor rellena todos los campos de la unidad de obra.',
                    text: 'No se ha rellenado algunos campos.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false
            }
            const formData = new FormData(e.target);
            const formProps = Object.fromEntries(formData);
            var descripcion_apartado = formProps.descripcion_apartado;

            var titulo_apartado = ($('#titulo_check').prop("checked")) ? $('#titulo_edit').val() : null
            var h5Titulo = document.createElement("h5");
            h5Titulo.className = "mb-0 text-center titulo_a";
            h5Titulo.textContent = titulo_apartado;
            var id_medida = $('#medida_edit').val()

            var nombre_medida = ($('#medida_edit').val() != "No") ? $(
                '#medida_edit').find(':selected').text() : ""
            var id_medida = $("#medida_edit").val()
            var td = document.createElement("td");
            td.className = "drop_drop";
            var ids = $('.contenido.dropdown .dropdown-toggle').map(function() {
                return parseInt(this.id.split("_")[1]);
            }).get();
            var maxNumber = Math.max(...ids);
            var id = Table.rows().count()
            console.log(ids);
            id = (maxNumber == id || maxNumber == '-Infinity') ? id : maxNumber + 1

            console.log(maxNumber);

            // Crear el botón del dropdown
            var button = document.createElement("button");
            button.className = "p-0 btn dropdown-toggle w-100";
            button.type = "button";
            button.id = "dropdownMenuButton_" + id;
            button.setAttribute("data-toggle", "dropdown");
            button.setAttribute("aria-haspopup", "true");
            button.setAttribute("aria-expanded", "false");

            // Crear el párrafo dentro del botón
            var p = document.createElement("p");
            p.className = "mb-0";
            p.textContent = descripcion_apartado;

            // Agregar el párrafo al botón
            button.innerHTML = p.outerHTML

            // Agregar el botón al <td>


            td.appendChild(h5Titulo);
            td.appendChild(button);

            // Crear el div de la lista del dropdown
            var dropdownMenu = document.createElement("div");
            dropdownMenu.className = "dropdown-menu p-3 w-100";
            dropdownMenu.setAttribute("aria-labelledby", "dropdownMenuButton_" + id);

            dropdownMenu.appendChild(p);
            // Agregar el div de la lista del dropdown al <td>
            td.className = "drop_drop";
            td.appendChild(dropdownMenu);

            var cantidad = formProps.cantidad_apartado;

            var precio_apartado = formatearNumero(parseFloat(formProps.precio_apartado).toFixed(2));

            var total = formatearNumero(parseFloat(formProps.precio_apartado * formProps
                .cantidad_apartado).toFixed(2))


            var codigo = $("#btn_agregar_d").data("codigo")
            var editarButton = document.createElement('a');
            editarButton.setAttribute('type',
                'button');
            editarButton.setAttribute('class',
                'mr-2 editar-row btn btn-sm btn-info');
            editarButton.textContent =
                'Editar';
            editarButton.setAttribute('data-descripcion',
                descripcion_apartado);
            editarButton.setAttribute('data-codigo',
                codigo);
            editarButton.setAttribute('data-titulo',
                titulo_apartado);
            editarButton.setAttribute('data-medida', id_medida);
            // Crear el elemento de eliminar
            var eliminarButton = document.createElement('a');
            eliminarButton.setAttribute('type',
                'button');
            eliminarButton.setAttribute('data-id', 'eliminar');
            eliminarButton
                .setAttribute('class', 'eliminar-row btn btn-sm btn-danger');
            eliminarButton
                .textContent = 'Eliminar';

            // Agregar los elementos al documento
            var buttons = document.createElement(
                "div"); // Reemplaza 'container' con el ID del elemento contenedor deseado
            buttons.appendChild(editarButton);
            buttons.appendChild(eliminarButton);

            console.log(codigo);
            Table.row.add({
                index: id,
                codigo: codigo,
                cantidad: cantidad + " " + nombre_medida,
                descripcion: td.innerHTML,
                precio_unitario: precio_apartado + "€",
                total: total + "€",
                acciones: buttons.outerHTML
            }).draw();

            //$("#dropdownMenuButton_" + id).parent("td").addClass("contenido dropdown")

        };
        Table.on('click', '.editar-row', function() {

            var fila = Table.row($(this).closest('tr'));
            var rowData = Table.row(fila).data();
            var rowIndex = Table.row(fila).index()
            var codigo = $(this).data('codigo')
            var cantidad = rowData["cantidad"].split(" ")[0]
            var id_medida = $(this).data('medida')
            var descripcion = $(this).data('descripcion')
            var titulo = $(this).data('titulo')
            var precio_unitario = fila.data()["precio_unitario"].replace('€', '')
            console.log(precio_unitario);
            $('#medida_apartado_editar').val(id_medida).trigger("change")
            document.getElementById('cantidad_apartado_editar').value = parseInt(
                cantidad)
            document.getElementById('codigo_apartado_editar').value = codigo
            document.getElementById('titulo_apartado_editar').value =
                titulo
            document.getElementById('descripcion_apartado_editar').value =
                descripcion
            document.getElementById('precio_apartado_editar').value =
                convertirFormato(precio_unitario)
            $("#medida_apartado_editar").val(id_medida).trigger("change")


            $("#btn_edit_apartado").data("index", rowIndex)
            $('#modalEditarApartado').modal("show")

        });

        Table.on('click', '.eliminar-row', function() {

            Table.row($(this).parents('tr'))
                .remove()
                .draw();



        });







    });


})(jQuery);
</script>




<script>
onload = function() {



    var inputCif = document.getElementById("input_cif")
    var inputDomicilio = document.getElementById("input_domicilio")
    var inputCP = document.getElementById("input_cp")

    var inputTelefono = document.getElementById("input_telefono")
    $("#fecha_presupuesto").val(moment().format('YYYY-MM-DD HH:mm:ss'))
    $("#programacion_presupuesto").val(moment().format('YYYY-MM-DD HH:mm:ss'))


    function updateInputs(id) {
        if (id != "No") {
            $.ajax({
                type: "GET",
                url: "./api/clientes.php?client_id=" + id,
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)


                    inputCif.value = res.cif;
                    inputDomicilio.value = res.direccion;
                    inputCP.value = res.cp;
                    var data = []
                    if (res.emails != null) {
                        for (let e of res.emails.split(',')) {
                            data.push({
                                id: e,
                                text: e,
                                selected: false
                            });

                        }
                        data.push({
                            id: res.email,
                            text: res.email,
                            selected: true
                        });
                    } else {
                        data.push({
                            id: res.email,
                            text: res.email,
                            selected: true
                        });
                    }
                    $('#input_email').empty()
                    $('#input_email').select2({
                        data: data
                    }).trigger("change");



                    inputTelefono.value = res.telefono;


                }

            })
        } else {
            var data = []
            data.push({
                id: "No",
                text: "Ninguno",
                selected: true
            });
            $('#input_email').empty()
            $('#input_email').select2({
                data: data
            }).trigger("change");
            inputCif.value = "";
            inputDomicilio.value = "";
            inputCP.value = "";

            inputTelefono.value = "";


        }

    }
    updateInputs($('#cliente_presupuesto').find(':selected').val())


    $('#btn-add-cliente').click(function() {


        //  $('#select-seleccionar-cliente').val($('#cliente_presupuesto').find(':selected').val());
        //    $('#select-seleccionar-cliente').trigger('change');

        $('#modalAgregarClienteNuevo').modal('show');


    })

    $('#cliente_presupuesto').change(function() {


        $('#modalAgregarClienteNuevo').modal('show');

        setTimeout(function() {
            $('#select-seleccionar-cliente').val($('#cliente_presupuesto').val())
            $('#select-seleccionar-cliente').trigger('change');
        }, 200);



    })




    $('#select-seleccionar-cliente').on("change", function(e) {

        if ($('#modalAgregarClienteNuevo').hasClass('show')) {

            updateInputs($('#select-seleccionar-cliente').find(':selected').val())
        }


    })



    $('#btn-add-cliente2').click(function() {


        $('#cliente_presupuesto').val($('#select-seleccionar-cliente').val())
        $('#cliente_presupuesto').trigger('change');


        $('#modalAgregarClienteNuevo').modal('hide');






    })

}
</script>






<script>
(function($) {

    'use strict';
    $(function() {

        $(document).on("change", "#cambiar_img", function() {
            $("#url_imagen_presupuesto img").attr("src", $(this).val()).trigger(
                "change");
            $("#url_imagen_presupuesto input").val($(this).val());
        })


        $(document).on("change", ".valor_personalizacion", function() {
            var nombre = $(this).data("nombre")
            var valor = $(this).val()
            $.ajax({
                type: 'POST',
                url: './api/personalizacion.php',
                cache: false,
                async: false,
                data: {
                    nombre: nombre,
                    valor: valor
                },
                success: function(result2) {
                    console.log(result2);
                    $.toast({
                        heading: 'Valor cambiado.',
                        text: 'Se ha cambiado la configuración correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    if (nombre == "url_logo_superior") {
                        $("img.logo_superior").each(function() {
                            console.log($(this));
                            $(this).attr("src", valor)

                        })
                    }
                }
            });


        });

    })
})(jQuery);
</script>
<script>
(function($) {
    'use strict';

    $(window).on('load', function() {

        function FillCondicion(id_condicion, target) {
            $.ajax({
                url: "./api/condiciones.php?id_condicion=" + id_condicion,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                success: function(res) {
                    if ($("#" + target).val() == "") {
                        $("#" + target).val(res.condicion)
                    } else {
                        $("#" + target).val($("#" + target).val() +
                            "\n" + res
                            .condicion)
                    }
                }
            });

        }

        function DeleteCondicion(id_condicion) {
            $.ajax({
                url: "./api/condiciones.php?id=" + id_condicion,
                type: 'DELETE',
                async: false, // added data type
                cache: false,
                success: function(res) {

                }
            });

        }

        $(document).on("click", ".btn_add_condicion", function() {
            FillCondicion($(this).data("id"), $("#lista_condiciones").data("target"));
        })

        $(document).on("click", ".btn_delete_condicion", function() {
            var id_condicion = $(this).data("id")
            DeleteCondicion(id_condicion);
            $("#condicion_" + id_condicion).remove();
        })
        $(document).on("click", ".btn_edit_condicion", function() {
            var id_condicion = $(this).data("id")
            $.ajax({
                url: "./api/condiciones.php?id_condicion=" + id_condicion,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                success: function(res) {
                    $("#titulo_condicion_editar").val(res.titulo)
                    $("#cuerpo_condicion_editar").val(res.condicion)
                    $("#btn_edit_condicion").data("id", id_condicion)
                    $("#modalEditarCondicion").modal("show")
                }
            });
        })


        $("#btn_agregar_condicion").click(function() {
            $("#btn_agregar_condicion").addClass("btn-loading")

            var titulo = $("#titulo_condicion").val()
            var condicion = $("#cuerpo_condicion").val()

            $.ajax({
                type: 'POST',
                url: './api/condiciones.php',
                data: {
                    titulo: titulo,
                    condicion: condicion

                },
                cache: false,
                success: function(response) {

                    $.toast({
                        heading: 'Condición agregada',
                        text: 'Se ha agregado la condición correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    var r = JSON.parse(response);
                    console.log(r)
                    var id = "condicion_" + r.id
                    var target = $("#lista_condiciones").data("target")
                    var li = document.createElement("li");
                    li.classList.add("d-flex")
                    li.classList.add("flex-row")
                    li.classList.add("mb-2")
                    li.classList.add("justify-content-between")
                    li.classList.add("align-items-center")
                    li.id = id
                    var p = document.createElement("p");
                    var div = document.createElement("div");
                    div.className = "d-flex flex-nowrap"
                    p.classList.add("mb-0")
                    var icono = document.createElement("i");
                    icono.style.fontSize = "10px";
                    icono.className = "m-0 fas fa-plus";
                    var button = document.createElement("button");
                    button.classList.add("btn_add_condicion")
                    button.classList.add("btn-sm")
                    button.classList.add("btn")
                    button.classList.add("btn-success")
                    button.setAttribute("data-id", r.id)
                    button.setAttribute("data-target", target)
                    button.append(icono)

                    var icono1 = document.createElement("i");
                    icono1.style.fontSize = "10px";
                    icono1.className = "m-0 fas fa-pencil-alt";
                    var button1 = document.createElement("button");
                    button1.classList.add("btn_edit_condicion")
                    button1.classList.add("mx-1")
                    button1.classList.add("btn-sm")
                    button1.classList.add("btn")
                    button1.classList.add("btn-info")
                    button1.setAttribute("data-id", r.id)
                    button1.append(icono1)

                    var icono2 = document.createElement("i");
                    icono2.style.fontSize = "10px";
                    icono2.className = "m-0 fas fa-trash-alt";
                    var button2 = document.createElement("button");
                    button2.classList.add("btn_delete_condicion")
                    button2.classList.add("btn-sm")
                    button2.classList.add("btn")
                    button2.classList.add("btn-danger")
                    button2.setAttribute("data-id", r.id)
                    button2.append(icono2)
                    p.innerText = r.titulo

                    /*  button.addEventListener('click', function() {
                          FillCondicion(r.id)
                      });*/



                    var lista = document.getElementById("lista_condiciones");

                    div.append(button2)
                    div.append(button1)
                    div.append(button)
                    lista.append(li)
                    li.append(p)
                    li.append(div)



                    $("#btn_agregar_condicion").removeClass("btn-loading")
                    $('#modalAgregarCondicion').modal("hide");
                }
            })

        })
        $("#btn_edit_condicion").click(function() {
            $("#btn_edit_condicion").addClass("btn-loading")
            var id_condicion = $(this).data("id")
            var titulo = $("#titulo_condicion_editar").val()
            var condicion = $("#cuerpo_condicion_editar").val()

            $.ajax({
                type: 'POST',
                url: './api/condiciones.php',
                async: false,
                cache: false,
                dataType: "json",
                data: {
                    titulo: titulo,
                    id_condicion: id_condicion,
                    condicion: condicion

                },
                success: function(r) {
                    console.log(r);
                    $.toast({
                        heading: 'Condición editada',
                        text: 'Se ha editado la condición correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $("#condicion_" + id_condicion + " p").text(r.titulo);

                    $("#btn_edit_condicion").removeClass("btn-loading")
                    $('#modalEditarCondicion').modal("hide");
                }
            })

        })
    });
})(jQuery);
</script>
<script>
(function($) {
    'use strict';

    $(window).on('load', function() {


    });
})(jQuery);
</script>