<?php $personalizacion = json_decode(file_get_contents('personalizacion.json'), true); ?>
<style>
.titulo_a,
.descripcion_a {
    max-width: 250px !important;
    overflow: hidden !important;
    word-wrap: break-word !important;
    display: -webkit-box !important;
    -webkit-line-clamp: 14 !important;
    -webkit-box-orient: vertical !important;
    white-space: pre-wrap !important;

}
</style>
<div class="content-wrapper">


    <div class="row profile-page">
        <div class="col-md-4">
            <div class="card p-3 mb-3 mb-sm-3">
                <h4 class="text-center mb-3">Unidades de obra</h4>
                <div class="form-group">
                    <div class="w-100 input-group" style="">
                        <input id="search_apartado" class="form-control" type="text"
                            placeholder="Buscar por título o por código de referencia">
                        <div class="input-group-append">
                            <span style="font-size: 12px;" class="input-group-text" id="my-addon"><i
                                    class="fas fa-search"></i></span>
                        </div>
                    </div>

                </div>
                <div class="form-group">
                    <div class="w-100 input-group" style="">

                        <div class="input-group-prepend">
                            <span style="font-size: 12px;" class="input-group-text" id="my-addon"><i
                                    class="fas fa-eye"></i></span>
                        </div>
                        <select id="cant_apartados" class="select form-control" name="">
                            <option value="5">5 resultados</option>
                            <option value="10">10 resultados</option>
                            <option value="15">15 resultados</option>
                            <option value="todos">Todos los resultados</option>
                        </select>


                    </div>

                </div>

                <div id="apartados" class="mb-2">

                </div>



                <button type="button" data-toggle="modal" data-target="#modalAgregarApartado"
                    class="btn btn-sm btn-success">Agregar unidades de obra</button>
            </div>
            <div class="card p-3 mb-3">
                <div class="row">
                    <div class="col-12 mb-3">
                        <h4>Información de la factura</h4>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Concepto</label>

                            <input id="titulo_factura" data-target="pdf_titulo" type="text"
                                class="form-control input_factura"
                                value="<?php echo htmlentities($FacturaManual['titulo'], ENT_QUOTES); ?>">
                        </div>

                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label
                                style="max-width: 100%;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;">Número</label>
                            <input type="text" class="input_factura form-control" id="numero_factura" placeholder=""
                                data-target="numero_pdf"
                                value="<?php echo htmlentities($FacturaManual['numero'], ENT_QUOTES); ?>">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Fecha</label>
                            <input id="fecha_factura" data-target="fecha_pdf" type="date"
                                class="form-control input_factura" value="<?php 
                                echo date("Y-m-d", strtotime($FacturaManual['fecha']));?>">

                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label for="my-input">Fecha de vencimiento</label>
                            <input id="fecha_vencimiento_factura" data-target="fecha_vencimiento_pdf"
                                class="input_factura form-control" type="date" value="<?php 
                                echo date("Y-m-d", strtotime($FacturaManual['fecha_vencimiento']));
                                 ?>">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Programar envío</label>


                            <input type="datetime-local" class="mb-3 form-control" id="programacion_factura" <?php

if ($FacturaManual['programado'] == null) {
    echo "disabled";
}
?> placeholder="" value="<?php

echo htmlentities($FacturaManual['programado'], ENT_QUOTES);

?>">

                            <label class="custom-control custom-checkbox d-inline-block mb-0">
                                <input type="checkbox" id="programado" class="mb-0 custom-control-input apartado" value="<?php

if ($FacturaManual['programado'] != null) {
    echo "checked";
}
?>">
                                <span class="custom-control-label">Habilitar </span>
                            </label>

                        </div>



                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Fechas</label>
                            <input type="text" class="input_factura form-control" id="fechas_factura"
                                data-target="pdf_fechas" placeholder="" required
                                value="<?php echo htmlentities($FacturaManual['fechas'], ENT_QUOTES); ?>">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Lugar</label>
                            <input type="text" class="input_factura form-control" id="lugar_factura"
                                data-target="pdf_lugar" placeholder="" required
                                value="<?php echo htmlentities($FacturaManual['lugar'], ENT_QUOTES); ?>">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label>Imágen de cabecera</label>
                            <div id="url_imagen_factura_editar">
                                <input id="cambiar_img" type="hidden" class="form-control valor_personalizacion"
                                    data-nombre="url_imagen_factura"
                                    value="<?php echo htmlentities($FacturaManual['imagen'], ENT_QUOTES); ?>" disabled>
                            </div>
                            <div id="url_imagen_factura" class="row">
                                <div style="background: #80808030;display: flex;justify-content: center;align-items: center;"
                                    class="col-xl-6 mb-3 mb-sm-0">
                                    <img class="w-100"
                                        src="<?php echo htmlentities($FacturaManual['imagen'], ENT_QUOTES); ?>" alt="">
                                </div>
                                <div class="col-xl-6">

                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <button data-target="url_imagen_factura_editar" data-toggle="tooltip"
                                                data-placement="top" class="btn_modal_imagenes btn btn-info"
                                                data-original-title="Editar imagen por defecto" type="button"><i
                                                    style="font-size: 12px;" class="m-0 fas fa-edit"></i></button>
                                        </div>


                                        <input type="text" class="form-control"
                                            value="<?php echo htmlentities($FacturaManual['imagen'], ENT_QUOTES); ?>"
                                            disabled>

                                        <div class="input-group-append">
                                            <button data-target="url_imagen_factura" data-toggle="tooltip"
                                                data-placement="top" class="btn_modal_imagenes btn btn-info"
                                                data-original-title="Editar imagen del presupuesto" type="button"><i
                                                    style="font-size: 12px;" class="m-0 fas fa-plus"></i></button>
                                        </div>
                                    </div>


                                    <p class="mb-0">El ratio recomendado es 1X2</p>

                                </div>
                            </div>


                        </div>
                    </div>


                    <div class="col-12 mb-3">
                        <h4>Información del cliente</h4>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Cliente</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                        data-target="cliente_factura" type="button">-</button>
                                </span>
                                <select id="cliente_factura" class="select_clientes custom-select select2 form-control">

                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarCliente">+</button>
                                </span>
                            </div>

                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Seleccionar proyecto</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_proyecto file-upload-browse btn btn-danger"
                                        data-target="select_proyectos" type="button">-</button>
                                </span>
                                <select id="select_proyectos"
                                    class="select_proyectos custom-select select2 form-control">

                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarProyecto">+</button>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Nombre</label>
                            <input id="nombre_factura" data-target="nombre_pdf" type="text"
                                class="form-control input_factura"
                                value="<?php echo htmlentities($FacturaManual['nombre'], ENT_QUOTES); ?>">
                        </div>
                    </div>

                    <div class=" col-xl-6">
                        <div class="form-group">
                            <label>Dirección</label>
                            <input id="direccion_factura" data-target="direccion_pdf" type="text"
                                class="form-control input_factura"
                                value="<?php echo htmlentities($FacturaManual['direccion'], ENT_QUOTES); ?>">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Teléfono</label>
                            <input id="telefono_factura" data-target="telefono_pdf" type="text"
                                class="form-control input_factura"
                                value="<?php echo htmlentities($FacturaManual['telefono'], ENT_QUOTES); ?>">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Email</label>
                            <select data-target="email_pdf" class="form-control select2 input_factura"
                                id="email_factura" target="email_pdf"></select>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>CIF</label>
                            <input id="cif_factura" data-target="cif_pdf" type="text" class="form-control input_factura"
                                value="<?php echo htmlentities($FacturaManual['cif'], ENT_QUOTES); ?>">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group mb-0 mb-xl-3">
                            <label>CP</label>
                            <input id="cp_factura" data-target="cp_pdf" type="text" class="form-control input_factura"
                                value="<?php echo htmlentities($FacturaManual['cp'], ENT_QUOTES); ?>">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group mb-0 mb-xl-3">

                            <label>Tipo</label>

                            <select id="tipo_cliente_factura" name="tipo_cliente"
                                class="form-control custom-select text-center">



                                <option <?php
                                        if ($FacturaManual['irpf'] == null) {
                                            echo "selected";
                                        } ?> type="text" value="Particular">Particular</option>

                                <option <?php
                                        if ($FacturaManual['irpf'] != null) {
                                            echo "selected";
                                        } ?> type="text" value="Empresa">Empresa</option>





                            </select>


                        </div>
                    </div>


                </div>

            </div>

            <div class="total card p-3 mb-3">
                <h4 id="subtotal" data-total=0 class="mb-2 text-center">Subtotal: 0,00€</h4>
                <p class="mb-2 text-center">Impuestos agregados:</p>
                <div class="d-flex flex-column align-items-start mb-2">
                    <p class="mb-2">Impuesto:</p>
                    <div class="form-check form-check-inline d-flex m-1">
                        <input value="7" class="form-check-input" type="radio" name="igic" <?php if ($FacturaManual["igic"] == "7.00") {
                                                                                                echo "checked";
                                                                                            } ?>>
                        <label class="p-0 form-check-label" for="inlineCheckbox1">+7%</label>

                    </div>
                    <div class="form-check form-check-inline d-flex m-1">
                        <input value="21" class="form-check-input" type="radio" name="igic">
                        <label class="p-0 form-check-label" for="inlineCheckbox2">+21%</label>
                    </div>
                    <div class="form-check form-check-inline d-flex m-1">
                        <input value=0 class="form-check-input" type="radio" id="igic" name="igic" <?php if ($FacturaManual["igic"] == "21.00") {
                                                                                                echo "checked";
                                                                                            } ?>>

                        <div class="input-group">

                            <input value="<?php if ($FacturaManual["igic"] != "21.00" && $FacturaManual["igic"] != "7.00") {
                                                                                                        echo $FacturaManual["igic"];
                                                                                                    } ?>"
                                class="ml-2 form-control" style="max-width:60px;" type="number" id="igicotro" <?php if ($FacturaManual["igic"] != "21.00" && $FacturaManual["igic"] != "7.00") {
                                                                                                        echo "checked";
                                                                                                    } ?>>
                            <div class="input-group-append">
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                    </div>

                </div>



                <div id="irpfview" style="<?php if ($FacturaManual["irpf"] != NULL) {
                                                echo "display:flex";
                                            } else {
                                                echo "display:none";
                                            } ?>" class="align-items-center mb-2">
                    <div class="form-check flex-column p-0 mb-2 d-flex m-1">

                        <p class="mb-2" for="inlineCheckbox1">I.R.P.F:</p>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">-</span>
                            </div>

                            <input value="<?php if ($FacturaManual["irpf"] != NULL) {
                                                echo number_format($FacturaManual["irpf"], 2, '.', '');
                                            } else {
                                                echo "0";
                                            } ?>" class="form-control" style="max-width:60px;" type="number" id="irpf">
                            <div class="input-group-append">
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                    </div>
                </div>



                <h4 id="total" data-total=0 class="mb-2 text-center">Total: 0,00€</h4>
                <p style="text-transform: uppercase;" id="total_letras" class="mb-0 text-center">Cero Euros</p>
            </div>
            <div class="card p-3 mb-3 mb-sm-3">
                <p class="text-center title mb-3">Impuestos adicionales</p>

                <ul data-target="impuesto_factura" id="lista_impuestos" class="p-0 mb-3">

                    <?php

                    foreach ($Impuestos_List as $Impuesto) {
                    ?>

                    <li id="impuesto_<?php echo htmlentities($Impuesto['id_impuesto'], ENT_QUOTES); ?>"
                        class=" mb-2 d-flex flex-row justify-content-between align-items-center">
                        <p class="mb-0"><?php echo htmlentities($Impuesto['titulo'], ENT_QUOTES); ?></p>

                        <div class="d-flex flex-nowrap">

                            <button data-id='<?php echo htmlentities($Impuesto['id_impuesto'], ENT_QUOTES); ?>'
                                class="btn_delete_impuesto btn btn-sm btn-danger"><i style="font-size:10px;"
                                    class="m-0 fas fa-trash-alt"></i></button>
                            <button data-id='<?php echo htmlentities($Impuesto['id_impuesto'], ENT_QUOTES); ?>'
                                class="mx-1 btn_edit_impuesto btn btn-sm btn-info"><i style="font-size:10px;"
                                    class="m-0 fas fa-pencil-alt"></i></button>
                            <button data-id='<?php echo htmlentities($Impuesto['id_impuesto'], ENT_QUOTES); ?>'
                                class="btn_add_impuesto btn btn-sm btn-success"><i style="font-size:10px;"
                                    class="m-0 fas fa-plus"></i></button>
                        </div>

                    </li>
                    <?php } ?>
                </ul>

                <button type="button" data-toggle="modal" data-target="#modalAgregarImpuesto"
                    class="btn btn-sm btn-success">Agregar impuesto</button>
            </div>
            <div class="card p-3 mb-3 mb-sm-3">
                <p class="text-center title mb-3">Condiciones disponibles</p>

                <ul data-target="condiciones_factura" id="lista_condiciones" class="p-0 mb-3">

                    <?php

                    foreach ($Condiciones_List as $Condicion) {
                    ?>

                    <li id="condicion_<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>"
                        class=" mb-2 d-flex flex-row justify-content-between align-items-center">
                        <p class="mb-0"><?php echo htmlentities($Condicion['titulo'], ENT_QUOTES); ?></p>

                        <div class="d-flex flex-nowrap">

                            <button data-id='<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>'
                                class="btn_delete_condicion btn btn-sm btn-danger"><i style="font-size:10px;"
                                    class="m-0 fas fa-trash-alt"></i></button>
                            <button data-id='<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>'
                                class="mx-1 btn_edit_condicion btn btn-sm btn-info"><i style="font-size:10px;"
                                    class="m-0 fas fa-pencil-alt"></i></button>
                            <button data-id='<?php echo htmlentities($Condicion['id_condicion'], ENT_QUOTES); ?>'
                                class="btn_add_condicion btn btn-sm btn-success"><i style="font-size:10px;"
                                    class="m-0 fas fa-plus"></i></button>
                        </div>

                    </li>
                    <?php } ?>
                </ul>

                <button type="button" data-toggle="modal" data-target="#modalAgregarCondicion"
                    class="btn btn-sm btn-success">Agregar condición</button>
            </div>
            <div class="card p-3">
                <div class="row">
                    <div class="col-12 mb-3">
                        <div class="form-group">
                            <h5 for="">Bancos (máximo permitido por factura: 1)</h5>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_banco file-upload-browse btn btn-danger"
                                        data-target="select_bancos" type="button">-</button>
                                </span>
                                <select id="select_bancos" class="select_bancos custom-select select2 form-control">

                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarBanco">+</button>
                                </span>
                            </div>
                        </div>
                        <button type="button" id="btn_agregar_banco"
                            class="w-100 btn btn-sm btn-success">Agregar</button>
                    </div>
                    <div class="col-12">
                        <ul id="lista_bancos">
                            <ul id="lista_bancos">
                                <?php if ($BancosFactura["banco_1"] != null) { ?>
                                <li><span data-id="<?php echo $BancosFactura["banco_1"]["id_banco"]; ?>"
                                        class="bancos float-left"><?php echo $BancosFactura["banco_1"]["nombre"]; ?></span>
                                    <a type="button" class="btn_quitar_banco float-right" style="cursor: pointer;"
                                        data-id="<?php echo $BancosFactura["banco_1"]["id_banco"]; ?>">
                                        <i class="ti-close"></i></a>
                                </li>


                                <?php
                            }
                            ?>
                                <?php if ($BancosFactura["banco_2"] != null) { ?>
                                <li><span data-id="<?php echo $BancosFactura["banco_2"]["id_banco"]; ?>"
                                        class="bancos float-left"><?php echo $BancosFactura["banco_2"]["nombre"]; ?></span>
                                    <a type="button" class="btn_quitar_banco float-right" style="cursor: pointer;"
                                        data-id="<?php echo $BancosFactura["banco_2"]["id_banco"]; ?>">
                                        <i class="ti-close"></i></a>
                                </li>
                                <?php
                            }
                            ?>
                                <?php if ($BancosFactura["banco_3"] != null) { ?>
                                <li><span data-id="<?php echo $BancosFactura["banco_3"]["id_banco"]; ?>"
                                        class="bancos float-left"><?php echo $BancosFactura["banco_3"]["nombre"]; ?></span>
                                    <a type="button" class="btn_quitar_banco float-right" style="cursor: pointer;"
                                        data-id="<?php echo $BancosFactura["banco_3"]["id_banco"]; ?>">
                                        <i class="ti-close"></i></a>
                                </li>
                                <?php
                            }
                            ?>

                            </ul>
                        </ul>
                    </div>
                </div>

            </div>

        </div>

        <div class="col-md-8">
            <div class="card p-3 mb-3">
                <div class="row">
                    <div class="col-12">
                        <h4 class="mb-3">Agregar unidad de obra a la factura</h4>
                    </div>

                    <div class="col-12">
                        <label class="custom-control custom-checkbox d-inline-block mb-3">
                            <input type="checkbox" id="facturae_enabled" class="custom-control-input apartado">
                            <span class="custom-control-label">Habilitar facturae</span>
                        </label>
                    </div>


                    <div class="col-xl-6">

                        <div class="form-group">
                            <label>Descripción</label>
                            <textarea class="form-control" id="descripcion_edit" type="text" class="form-control m-0"
                                name="descripcion_apartado" placeholder="" style="height: 184px !important;"></textarea>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label class="custom-control custom-checkbox d-inline-block"
                                style="height: auto;min-height: unset;">
                                <input type="checkbox" class="custom-control-input apartado" id="titulo_check">
                                <span class="custom-control-label">Título</span>
                            </label>
                            <input disabled id="titulo_edit" class="form-control" type="text" name="titulo_apartado">
                        </div>
                        <div class="form-group">
                            <label>Medida</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_medida file-upload-browse btn btn-danger"
                                        data-target="medida_edit" type="button">-</button>
                                </span>
                                <select id="medida_edit" name="medida_apartado"
                                    class="select_medidas custom-select select2 form-control">
                                    <option selected value="No">
                                        Ninguna
                                    </option>

                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarMedida">+</button>
                                </span>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label>Cantidad</label>
                                    <input id="cantidad_edit" type="number" class="form-control"
                                        name="cantidad_apartado" placeholder="">
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label>Precio unitario</label>




                                    <input id="precio_unitario_edit" type="number" class="form-control"
                                        name="precio_unitario_apartado">


                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="text-right">
                            <button disabled type="button" id="btn_agregar_detallado"
                                class="btn btn-sm btn-primary">Agregar</button>
                        </div>

                    </div>
                </div>

                <div id="facturae" class="d-none row mb-3 mb-sm-3">
                    <div class="col-12">
                        <h4 class="mb-3">Unidades</h4>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Unidad Tramitadora</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="file-upload-browse btn btn-danger" type="button"
                                        id="btn_eliminar_tramitadora">-</button>
                                </span>
                                <select name="id_tramitadora" id="id_tramitadora"
                                    class="form-control custom-select text-center select2" required>
                                    <?php
                                    foreach ($Tramitadora as $administracion) {
                                    ?>
                                    <option type="number" data-overlay="<?php echo implode('-', $administracion) ?> "
                                        value=<?php echo htmlentities($administracion['id'], ENT_QUOTES) ?>>
                                        <?php echo htmlentities($administracion['nombre'], ENT_QUOTES) ?>
                                    </option>
                                    <?php } ?>
                                </select>
                                <span class="input-group-append">
                                    <button data-toggle="modal" data-target="#modalcrearUnidad"
                                        class="file-upload-browse btn btn-info" type="button">+</button>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Unidad Gestora</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="file-upload-browse btn btn-danger" type="button"
                                        id="btn_eliminar_gestor">-</button>
                                </span>
                                <select name="id_gestor" id="id_gestor"
                                    class="form-control custom-select text-center select2" required>
                                    <?php
                                    foreach ($Gestora as $administracion) {
                                    ?>
                                    <option type="number" data-overlay="<?php echo implode('-', $administracion) ?> "
                                        value=<?php echo htmlentities($administracion['id'], ENT_QUOTES) ?>>
                                        <?php echo htmlentities($administracion['nombre'], ENT_QUOTES) ?>
                                    </option>
                                    <?php } ?>
                                </select>
                                <span class="input-group-append">
                                    <button data-toggle="modal" data-target="#modalcrearUnidad"
                                        class="file-upload-browse btn btn-info" type="button">+</button>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <label>Unidad Contable</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="file-upload-browse btn btn-danger" type="button"
                                        id="btn_eliminar_contable">-</button>
                                </span>
                                <select name="id_contable" id="id_contable"
                                    class="form-control custom-select text-center select2" required>
                                    <?php
                                    foreach ($Contable as $administracion) {
                                    ?>
                                    <option type="number" data-overlay="<?php echo implode('-', $administracion) ?> "
                                        value=<?php echo htmlentities($administracion['id'], ENT_QUOTES) ?>>
                                        <?php echo htmlentities($administracion['nombre'], ENT_QUOTES) ?>
                                    </option>
                                    <?php } ?>
                                </select>
                                <span class="input-group-append">
                                    <button data-toggle="modal" data-target="#modalcrearUnidad"
                                        class="file-upload-browse btn btn-info" type="button">+</button>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card p-3 m-auto">

                <div class="">



                    <div class="">



                        <div class="row ">

                            <!-- Historial de Acceso -->




                            <div class="col-12">

                                <html>
                                <div
                                    style="background:#ffffff;width:100%;display:block;font-family:'Poppins', sans-serif;font-size:11px;">
                                    <div>
                                        <div style="width:100%; margin-bottom: 1rem; height:80px;">
                                            <img id="imagen_pdf" style="object-fit:contain;height: 100%;"
                                                src="<?php echo htmlentities($personalizacion['url_imagen_factura'], ENT_QUOTES); ?>">
                                        </div>




                                        <div class="row">

                                            <div class="col-xl-6">

                                                <h4 style="margin-bottom:.2rem;">
                                                    <?php echo htmlentities($personalizacion['nombre'], ENT_QUOTES); ?>
                                                </h4>
                                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Dirección:
                                                    </strong><?php echo htmlentities($personalizacion['direccion'], ENT_QUOTES); ?>
                                                </p>
                                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Teléfono:
                                                    </strong><?php echo htmlentities($personalizacion['telefono'], ENT_QUOTES); ?>
                                                </p>
                                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Fax:
                                                    </strong><?php echo htmlentities($personalizacion['fax'], ENT_QUOTES); ?>
                                                </p>
                                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Email:
                                                    </strong><?php echo htmlentities($personalizacion['email'], ENT_QUOTES); ?>
                                                </p>
                                                <p style="margin-bottom:0rem;color:#67757c;"><a
                                                        href="<?php echo htmlentities($personalizacion['web'], ENT_QUOTES); ?>"><?php echo htmlentities($personalizacion['web'], ENT_QUOTES); ?></a>
                                                </p>
                                            </div>
                                            <div class="col-xl-6">
                                                <h4 id="nombre_pdf" style="margin-bottom:.2rem;">

                                                </h4>
                                                <p id="pdf_codigo_view" style="margin-bottom:.2rem;color:#67757c;">
                                                    <strong>Código: </strong><span id="codigo_pdf"></span>
                                                </p>
                                                <p id="pdf_direccion_cliente_view"
                                                    style="margin-bottom:.2rem;color:#67757c;">
                                                    <strong>Dirección: </strong><span id="direccion_pdf"></span>
                                                </p>

                                                <p id="pdf_telefono_cliente_view"
                                                    style="margin-bottom:.2rem;color:#67757c;">
                                                    <strong>Teléfono: </strong><span id="telefono_pdf"></span>
                                                </p>

                                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>Email:
                                                    </strong><span id="email_pdf">
                                                </p>
                                                <p style="margin-bottom:.2rem;color:#67757c;"><strong>CIF: </strong>
                                                    <span id="cif_pdf"></span>
                                                </p>
                                                <p style="color:#67757c;" class="mb-0"><strong>CP: </strong> <span
                                                        id="cp_pdf"></span></p>
                                            </div>
                                        </div>

                                        <hr>
                                        <div class="row">

                                            <div class="col-xl-6">
                                                <p style="color:#67757c;" class="mb-1">
                                                    <strong>Concepto: </strong><span id="pdf_titulo"></span>
                                                </p>
                                                <p style="color:#67757c;" class="mb-1">
                                                    <strong>Lugar: </strong><span id="pdf_lugar"></span>
                                                </p>
                                                <p style="color:#67757c;" class="mb-0">
                                                    <strong>Fechas: </strong><span id="pdf_fechas"></span>
                                                </p>
                                            </div>
                                            <div class="col-xl-6">
                                                <table class="w-100 table-fc table_responsive table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <td class="p-2">Nº factura</td>
                                                            <td class="p-2">Fecha</td>
                                                            <td class="p-2">Fecha de vencimiento</td>

                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        <tr style="display:table-row!important;">
                                                            <td class="p-2"><span id="numero_pdf"></span></td>
                                                            <td class="p-2"><span id="fecha_pdf"></span></td>
                                                            <td class="p-2"><span id="fecha_vencimiento_pdf"></span>
                                                            </td>
                                                        </tr>

                                                    </tbody>


                                                </table>
                                            </div>

                                        </div>
                                        <hr>

                                        <div class="table-responsive">

                                            <table id="tabla_enviados" cellspacing="0" class="table display nowrap">

                                                <thead>

                                                    <tr>
                                                        <th>Órden</th>
                                                        <th>Código</th>
                                                        <th>Descripción</th>

                                                        <th>Cantidad</th>

                                                        <th>Precio unitario</th>



                                                        <th>Total</th>

                                                        <th>Acciones</th>




                                                    </tr>

                                                </thead>

                                                <tbody>

                                                    <?php
                                                   
                                                   function formatearNumero($cadena)
                                                   {
                                                       // Reemplazar la coma por el punto para asegurar el formato numérico correcto
                                                       $cadena = str_replace(',', '.', $cadena);

                                                       // Separar la parte entera de la decimal
                                                       $partes = explode('.', $cadena);
                                                       $parteEntera = $partes[0];
                                                       $parteDecimal = isset($partes[1]) ? $partes[1] : '';

                                                       // Formatear la parte entera con separadores de miles
                                                       $parteEntera = number_format($parteEntera, 0, '', '.');

                                                       // Unir la parte entera y decimal con el formato deseado
                                                       $numeroFormateado = $parteEntera . ',' . $parteDecimal;

                                                       return $numeroFormateado;
                                                   }
$i = 0;
                                                   foreach ($ApartadosFacturaManual as $Apartado) {
                                                       ?>
                                                    <tr>
                                                        <td><?php
                                                                   echo $i;
                                                                   ?></td>
                                                        <td><?php
                                                                   echo htmlentities($Apartado["codigo"], ENT_QUOTES);
                                                                   ?></td>
                                                        <td>
                                                            <div>
                                                                <h5 class="mb-2 text-center titulo_a"><?php
                                                              if ($Apartado["titulo"] != null) {
                                                               echo htmlentities($Apartado["titulo"], ENT_QUOTES);
                                                              }
                                                           ?></h5>
                                                                <p class="mb-2 descripcion_a"><?php
                                                             echo htmlentities($Apartado["descripcion"], ENT_QUOTES);
                                                             ?></p>
                                                            </div>


                                                        </td>

                                                        <td><?php
                                                                   echo htmlentities($Apartado["cantidad"], ENT_QUOTES);
                                                                   ?></td>
                                                        <td><?php
   
                                                                   echo formatearNumero(sprintf("%.2f", htmlentities($Apartado["precio_unitario"], ENT_QUOTES)));
                                                                   ?> €</td>
                                                        <td><?php
   
   
   
                                                                   echo formatearNumero(sprintf("%.2f", ($Apartado["precio_unitario"] * explode(" ", trim($Apartado["cantidad"]))[0])));
                                                                   ?> €</td>
                                                        <td>

                                                            <a type="button"
                                                                class="mr-2 editar-row btn btn-sm btn-outline-info"
                                                                data-descripcion="<?php echo htmlentities($Apartado["descripcion"], ENT_QUOTES) ?>"
                                                                data-titulo="<?php echo htmlentities($Apartado["titulo"], ENT_QUOTES) ?>"
                                                                data-codigo="<?php echo htmlentities($Apartado["codigo"], ENT_QUOTES) ?>"
                                                                data-medida="<?php
                                                                                                                                                                                                                                                                                                                   if (count(explode(' ', trim($Apartado['cantidad']))) > 1) {
                                                                                                                                                                                                                                                                                                                       echo explode(' ', trim($Apartado['cantidad']))[1];
                                                                                                                                                                                                                                                                                                                   } else
                                                                                                                                                                                                                                                                                                                       echo "No"; {
                                                                                                                                                                                                                                                                                                                   } ?>"
                                                                data-cantidad="<?php
                                                                                                                                                                                                                                                                                                                                           echo explode(' ', trim($Apartado['cantidad']))[1]
                                                                                                                                                                                                                                                                                                                                           ?>">Editar</a><a
                                                                type="button" data-id="eliminar"
                                                                class="eliminar-row btn btn-sm btn-outline-danger">Eliminar</a>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                    $i++;
                                                   }
                                               
                                               ?>







                                                </tbody>

                                            </table>

                                        </div>

                                        <hr style="margin-bottom:1rem">
                                        <div class="mb-3" style="display:block;width:100%;">
                                            <p style="display:block;width:100%;text-align:right;">Subtotal:
                                                <span id="subtotal_pdf"></span> €
                                            </p>
                                            <p style="display:block;width:100%;text-align:right;">Impuesto: +
                                                <span id="igic_pdf"></span> % =
                                                <span id="igic_monto_pdf"></span> €
                                            </p>
                                            <p style="display:block;width:100%;text-align:right;">I.R.P.F: -
                                                <span id="irpf_pdf"></span> % =
                                                <span id="irpf_monto_pdf"></span> €
                                            </p>

                                            <p class="mb-2" style="display:block;width:100%;text-align:right;">

                                                Total: <span id="total_pdf"></span> €</p>
                                        </div>

                                        <div class="mb-3" style="display:block;width:100%;">
                                            <table id="tabla_bancos">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2">Datos bancarios:</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="banco_1" style="display:none;">
                                                    <tr>
                                                        <th colspan="2">Banco 1</th>
                                                    </tr>
                                                    <tr>
                                                        <td>Banco</td>
                                                        <td id="nombre_banco_1"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Nombre del beneficiario</td>
                                                        <td id="beneficiario_banco_1"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>IBAN</td>
                                                        <td id="iban_banco_1"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>SWIFT/BIC</td>
                                                        <td id="swift_banco_1"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>DIVISA</td>
                                                        <td id="divisa_banco_1"></td>
                                                    </tr>
                                                </tbody>
                                                <tbody id="banco_2" style="display:none;">
                                                    <tr>
                                                        <th colspan="2">Banco 2</th>
                                                    </tr>
                                                    <tr>
                                                        <td>Banco</td>
                                                        <td id="nombre_banco_2"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Nombre del beneficiario</td>
                                                        <td id="beneficiario_banco_2"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>IBAN</td>
                                                        <td id="iban_banco_2"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>SWIFT/BIC</td>
                                                        <td id="swift_banco_2"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>DIVISA</td>
                                                        <td id="divisa_banco_2"></td>
                                                    </tr>
                                                </tbody>
                                                <tbody id="banco_3" style="display:none;">
                                                    <tr>
                                                        <th colspan="2">Banco 3</th>
                                                    </tr>
                                                    <tr>
                                                        <td>Banco</td>
                                                        <td id="nombre_banco_3"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Nombre del beneficiario</td>
                                                        <td id="beneficiario_banco_3"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>IBAN</td>
                                                        <td id="iban_banco_3"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>SWIFT/BIC</td>
                                                        <td id="swift_banco_3"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>DIVISA</td>
                                                        <td id="divisa_banco_3"></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <style>
                                            /* Estilos opcionales para mejorar la apariencia */
                                            #tabla_bancos {
                                                width: 100%;
                                                border-collapse: collapse;
                                                margin-bottom: 20px;
                                            }

                                            #tabla_bancos th,
                                            #tabla_bancos td {
                                                border: 1px solid #dddddd;
                                                text-align: left;
                                                padding: 8px;
                                                width: 50%;
                                            }

                                            #tabla_bancos th {
                                                background-color: #f2f2f2;
                                            }
                                            </style>
                                        </div>




                                    </div>
                                </div>

                                </html>


                                <input type="hidden" value=0 id="total_factura">
                                <input type="hidden" id="id_cliente_factura">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label>Condiciones Generales</label>
                                            <textarea class="form-control" type="text" class="form-control m-0"
                                                id="condiciones_factura" placeholder=""><?php
                                   
                                      
                                   $arreglo = explode("\\n", $FacturaManual['condiciones']);
                                   $condi = "";
                                   $contador = 0;
$total_elementos = count($arreglo);
                                   foreach ($arreglo as $a) {
                                      
                                    if ($contador === $total_elementos - 1) {
                                        $condi .= $a;
                                    } else {
                                        $condi .= $a . "\n";
                                    }
                                    
                                    $contador++;
                                       
                                   }
                                   echo htmlentities($condi, ENT_QUOTES); 
                                                           ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label>Impuestos adicionales</label>
                                            <textarea class="form-control" type="text" class="form-control m-0"
                                                id="impuesto_factura" placeholder=""><?php
                                   
                                      
                                   $arreglo = explode("\\n", $FacturaManual['impuesto']);
                                   $condi = "";
                                   $contador = 0;
$total_elementos = count($arreglo);
                                   foreach ($arreglo as $a) {
                                    if ($contador === $total_elementos - 1) {
                                        $condi .= $a;
                                    } else {
                                        $condi .= $a . "\n";
                                    }
                                    
                                    $contador++;
                                       
                                   }
                                   echo htmlentities($condi, ENT_QUOTES); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-12 text-right">
                                        <button type="button" data-estado="No enviada" id="btn_guardar"
                                            class="btn_guardar btn btn-sm btn-success">Guardar</button>
                                        <button type="button" data-estado="Pendiente" id="btn_enviar"
                                            class="btn_guardar btn btn-sm btn-success">Guardar
                                            y enviar</button>
                                    </div>
                                </div>



                            </div>



                            <!-- /Historial de Acceso -->

                            <!-- Eliminación de cuenta -->



                            <!-- /Eliminación de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



</div>

<div class="modal fade" id="modalAgregarCondicion" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar condición</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">

                    <div class="row">
                        <div class="col-12">

                            <div class="form-group">

                                <label>Título</label>

                                <input id="titulo_condicion" class="form-control" type="text">
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Condición</label>

                                <textarea class="form-control" id="cuerpo_condicion" id="" cols="30"
                                    rows="10"></textarea>
                            </div>

                        </div>




                    </div>


                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_agregar_condicion" type="button">

                    Añadir</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalAgregarImpuesto" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar impuesto</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">

                    <div class="row">
                        <div class="col-12">

                            <div class="form-group">

                                <label>Título</label>

                                <input id="titulo_impuesto" class="form-control" type="text">
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Condición</label>

                                <textarea class="form-control" id="cuerpo_impuesto" id="" cols="30"
                                    rows="10"></textarea>
                            </div>

                        </div>




                    </div>


                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_agregar_impuesto" type="button">

                    Añadir</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarImpuesto" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Editar impuesto</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">

                    <div class="row">
                        <div class="col-12">

                            <div class="form-group">

                                <label>Título</label>

                                <input id="titulo_impuesto_editar" class="form-control" type="text">
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Condición</label>

                                <textarea class="form-control" id="cuerpo_impuesto_editar" id="" cols="30"
                                    rows="10"></textarea>
                            </div>

                        </div>




                    </div>


                </div>



            </div>

            <div class="modal-footer text-right">



                <button data-toggle="impuestos_factura" class="btn btn-info btn-fw" id="btn_edit_impuesto"
                    type="button">

                    Editar</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<!-- Modals unidad tramitadora  -->
<div class="modal fade" id="modalEditarBorrarTramitadora" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">

    <div style="max-width:400px;" class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar Unidad</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <div class="modal-body">
                <div class="row">
                    <div class="col-xl-6">
                        <div class=" d-none form-group">
                            <input readonly type="text" id="edit_role_id" class="w-100 form-control" placeholder="id">
                        </div>
                        <div class="form-group">
                            <input readonly type="text" id="edit_role_code" class="w-100 form-control"
                                placeholder="Codigo Unidad">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <input readonly type="text" id="edit_role_name" class="w-100 form-control"
                                placeholder="Nombre">
                        </div>
                    </div>
                    <div class="col-xl-6">

                        <div class="form-group">
                            <input readonly type="text" id="edit_role_address" class="w-100 form-control"
                                placeholder="Dirección">
                        </div>
                    </div>
                    <div class="col-xl-6">

                        <div class="form-group">
                            <input readonly type="text" id="edit_role_cp" class="w-100 form-control"
                                placeholder="Codigo Postal">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group ">
                            <input readonly type="text" id="edit_role_city" class="w-100 form-control"
                                placeholder="Ciudad">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <input readonly type="text" id="edit_role_province" class="w-100 form-control"
                                placeholder="Provincia">
                        </div>
                    </div>
                </div>


            </div>
            <div class="modal-footer pb-3 text-right">
                <button id="btn-delete-unidad-tramitadora" class="btn btn-danger btn-fw" type="submit">
                    Borrar
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade" id="modalcrearUnidad" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div style="max-width:400px;" class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">

                <h4 class="nb-0">Agregar Unidades</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <select name="create_role_tramit" id="create_role_tramite"
                            class="form-control custom-select text-center select2" required>
                            <option value="role_gestor">Unidad Gestora</option>
                            <option value="role_tramitadora">Unidad Tramitadora</option>
                            <option value="role_contable">Unidad Contable</option>
                        </select>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <input type="text" id="create_role_code" class="form-control w-100"
                                placeholder="Codigo Unidad">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <input type="text" id="create_role_name" class="form-control w-100" placeholder="Nombre">
                        </div>
                    </div>
                    <div class="col-xl-6">

                        <div class="form-group">
                            <input type="text" id="create_role_address" class="form-control w-100"
                                placeholder="Dirección">
                        </div>
                    </div>
                    <div class="col-xl-6">

                        <div class="form-group">
                            <input type="text" id="create_role_cp" class="form-control w-100"
                                placeholder="Codigo Postal">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group ">
                            <input type="text" id="create_role_city" class="form-control w-100" placeholder="Ciudad">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="form-group">
                            <input type="text" id="create_role_province" class="form-control w-100"
                                placeholder="Provincia">
                        </div>
                    </div>
                </div>


            </div>
            <div class="modal-footer pb-3 text-right">
                <button id="btn-crear-unidad-tramitadora" class="btn btn-info btn-fw" type="submit">
                    Crear
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>


<div class="modal fade" id="modalEditarCondicion" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Editar condición</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">

                    <div class="row">
                        <div class="col-12">

                            <div class="form-group">

                                <label>Título</label>

                                <input id="titulo_condicion_editar" class="form-control" type="text">
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Condición</label>

                                <textarea class="form-control" id="cuerpo_condicion_editar" id="" cols="30"
                                    rows="10"></textarea>
                            </div>

                        </div>




                    </div>


                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_edit_condicion" type="button">

                    Editar</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>


<style>
.img_lista {
    cursor: pointer;
    transition: all .3s ease;
    position: relative;
    height: 100%;
    width: 100%;
    background: #0000001a;
    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    aspect-ratio: 10/6;
}

.img_lista img {
    object-fit: cover;
}

.img_lista:hover {
    opacity: .5;
    background: #000000;
}

.btn_eliminar_imagen {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    right: 0;
    top: 0;
    border-radius: 0px;
}

.img_lista:hover .btn_eliminar_imagen {
    opacity: 1;
}

.btn_eliminar_imagen i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #F1635F;
}

.btn_eliminar_imagen:hover i:before {
    color: #F1635F;
}

.btn_seleccionar_imagen {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    left: 0;
    top: 0;
    border-radius: 0px;
}

.img_lista:hover .btn_seleccionar_imagen {
    opacity: 1;
}

.btn_seleccionar_imagen i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #0cca8e;
}

.btn_seleccionar_imagen:hover i:before {
    color: #0cca8e;
}

#lista_condiciones,
#lista_impuestos {
    max-height: 180px;
    overflow-y: scroll;
    overflow-x: hidden;
}

#lista_condiciones p,
#lista_impuestos p {
    white-space: nowrap;
    /* Evita el salto de línea */
    overflow: hidden;
    /* Oculta el contenido que desborda */
    text-overflow: ellipsis;
    width: 100%;
}
</style>


<?php require_once __VIEWS__ . 'selects/bancos.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/proyectos.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/apartados.template.php'; ?>
<script>
function Unidades(num) {

    switch (num) {
        case 1:
            return 'Un ';
        case 2:
            return 'Dos ';
        case 3:
            return 'Tres ';
        case 4:
            return 'Cuatro ';
        case 5:
            return 'Cinco ';
        case 6:
            return 'Seis ';
        case 7:
            return 'Siete ';
        case 8:
            return 'Ocho ';
        case 9:
            return 'Nueve ';
    }

    return '';
} //Unidades()

function Decenas(num) {

    decena = Math.floor(num / 10);
    unidad = num - (decena * 10);

    switch (decena) {
        case 1:
            switch (unidad) {
                case 0:
                    return 'Diez ';
                case 1:
                    return 'Once ';
                case 2:
                    return 'Doce ';
                case 3:
                    return 'Trece ';
                case 4:
                    return 'Catorce ';
                case 5:
                    return 'Quince ';
                default:
                    return 'Dieci ' + Unidades(unidad);
            }
            case 2:
                switch (unidad) {
                    case 0:
                        return 'Veinte ';
                    default:
                        return 'Veinti ' + Unidades(unidad);
                }
                case 3:
                    return DecenasY('Treinta ', unidad);
                case 4:
                    return DecenasY('Cuarenta ', unidad);
                case 5:
                    return DecenasY('Cincuenta ', unidad);
                case 6:
                    return DecenasY('Sesenta ', unidad);
                case 7:
                    return DecenasY('Setenta ', unidad);
                case 8:
                    return DecenasY('Ochenta ', unidad);
                case 9:
                    return DecenasY('Noventa ', unidad);
                case 0:
                    return Unidades(unidad);
    }
} //Unidades()

function DecenasY(strSin, numUnidades) {
    if (numUnidades > 0)
        return strSin + 'Y ' + Unidades(numUnidades)

    return strSin;
} //DecenasY()

function Centenas(num) {
    centenas = Math.floor(num / 100);
    decenas = num - (centenas * 100);

    switch (centenas) {
        case 1:
            if (decenas > 0)
                return 'Ciento ' + Decenas(decenas);
            return 'Cien ';
        case 2:
            return 'Doscientos ' + Decenas(decenas);
        case 3:
            return 'Trescientos ' + Decenas(decenas);
        case 4:
            return 'Cuatrocientos ' + Decenas(decenas);
        case 5:
            return 'Quinientos ' + Decenas(decenas);
        case 6:
            return 'Seiscientos ' + Decenas(decenas);
        case 7:
            return 'Setecientos ' + Decenas(decenas);
        case 8:
            return 'Ochocientos ' + Decenas(decenas);
        case 9:
            return 'Novecientos ' + Decenas(decenas);
    }

    return Decenas(decenas);
} //Centenas()

function Seccion(num, divisor, strSingular, strPlural) {
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    letras = '';

    if (cientos > 0)
        if (cientos > 1)
            letras = Centenas(cientos) + '' + strPlural;
        else
            letras = strSingular;

    if (resto > 0)
        letras += '';

    return letras;
} //Seccion()

function Miles(num) {
    divisor = 1000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMiles = Seccion(num, divisor, 'un mil ', 'mil ');
    strCentenas = Centenas(resto);

    if (strMiles == '')
        return strCentenas;

    return strMiles + '' + strCentenas;
} //Miles()

function Millones(num) {
    divisor = 1000000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMillones = Seccion(num, divisor, 'un millon de ', 'millones de ');
    strMiles = Miles(resto);

    if (strMillones == '')
        return strMiles;

    return strMillones + '' + strMiles;
} //Millones()

function NumeroALetras(num) {
    var data = {
        numero: num,
        enteros: Math.floor(num),
        centimos: (((Math.round(num * 100)) - (Math.floor(num) * 100))),
        letrasCentavos: '',
        letrasMonedaPlural: 'Euros ', //'PESOS', 'Dólares', 'Bolívares', 'etcs'
        letrasMonedaSingular: 'Euro ', //'PESO', 'Dólar', 'Bolivar', 'etc'

        letrasMonedaCentavoPlural: 'céntimos ',
        letrasMonedaCentavoSingular: 'céntimo '
    };

    if (data.centimos > 0) {
        data.letrasCentavos = 'con ' + (function() {
            if (data.centimos == 1)
                return Millones(data.centimos) + '' + data.letrasMonedaCentavoSingular;
            else
                return Millones(data.centimos) + '' + data.letrasMonedaCentavoPlural;
        })();
    };

    if (data.enteros == 0)
        return 'cero ' + data.letrasMonedaPlural + '' + data.letrasCentavos;
    if (data.enteros == 1)
        return Millones(data.enteros) + '' + data.letrasMonedaSingular + '' + data.letrasCentavos;
    else
        return Millones(data.enteros) + '' + data.letrasMonedaPlural + '' + data.letrasCentavos;
} //NumeroALetras()

(function($) {
    'use strict';

    $(window).on('load', function() {

        var Table = $('#tabla_enviados').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en apartados",
                infoEmpty: "Mostrando 0 a 0 de 0 en apartados",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },

            "buttons": [{
                extend: 'colvis',
                text: 'Ocultar Columnas',
                collectionLayout: 'fixed two-column',
                className: "form-control"
            }],

            // "ordering": false,
            "columns": [{
                    "data": "index"
                }, {
                    "data": "codigo"
                },
                {
                    "data": "descripcion",
                    "className": 'contenido dropdown'
                },
                {
                    "data": "cantidad"
                },
                {
                    "data": "precio_unitario"
                },
                {
                    "data": "total"
                },
                {
                    "data": "acciones"
                }
            ],
            colReorder: true,

            columnDefs: [{
                targets: 0,
                visible: false
            }],
            rowReorder: {
                selector: 'td:nth-child(2)',
                dataSrc: 'index'
            }
        });
        Table.on('row-reordered', function(e, details, changes) {
            // obtener el nuevo orden de las filas
            console.log(e.target);
            console.log(details);

            console.log(changes);
            Table.draw()
        });
        $('#titulo_check').change(function(event) {
            if ($(this).prop("checked")) {
                $('#titulo_edit').attr("disabled", false)
            } else {
                $('#titulo_edit').attr("disabled", true)
            }

        })

        $(document).on("change", ".input_factura", function() {
            var target = $(this).data("target")
            var id = $(this).attr('id')
            var typeOfThis = $(this).prop('type')
            var val = $(this).val()
            console.log(val);
            if (val == "" && typeOfThis != "date") {
                $("#" + target).parent().css("display", "none")
            } else {
                $("#" + target).parent().css("display", "block")
            }
            if (target == "fecha_pdf" || target == "numero_pdf" || target ==
                "fecha_vencimiento_pdf") {


                if (val != "") {

                    $("#th_" + target).css("display", "table-cell")
                    $("#td_" + target).css("display", "table-cell")
                } else {
                    $("#th_" + target).css("display", "none")
                    $("#td_" + target).css("display", "none")

                }




            }
            if (typeOfThis == "date") {

                if (target == "fecha_pdf") {
                    var fecha = $('#fecha_factura').val()
                    var fechas = fecha.split("T");
                    console.log(fechas);
                    if (fechas[0] != "Invalid date") {
                        $('#fecha_pdf').text(fechas[0])
                    }
                } else {

                    var fecha = $('#fecha_vencimiento_factura').val()
                    var fechas = fecha.split("T");
                    console.log(fechas);
                    if (fechas[0] != "Invalid date") {
                        $('#fecha_vencimiento_pdf').text(fechas[0])
                    }
                }


            }
            if (id == "imagen_factura") {

                $("#" + target).attr("src", "./image.php?id=" + $(this).val());
            } else {
                $("#" + target).text($(this).val())
            }
        });
        <?php
            if (isset($_GET["id_presupuesto"])) {
            ?>

        $('#cliente_factura').val("<?php echo htmlentities($Presupuesto['id_cliente'], ENT_QUOTES);?>")
            .trigger("change")
        <?php
            }
            ?>
        $("#cliente_factura").change(function(e) {

            LoadClienteData()
        });
        $(".input_factura").each(function() {
            $(this).trigger("change")

        })

        function LoadClienteData() {
            var id_cliente = $("#cliente_factura").val()
            $.ajax({
                url: "./api/clientes.php?client_id=" + id_cliente,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                success: function(res) {
                    $("#nombre_factura").val(res.nombre).trigger('change');
                    res.codigo != null ? $("#codigo_pdf").text(res.codigo) :
                        $("#codigo_pdf").text("")
                    res.cif != null ? $("#cif_factura").val(res.cif).trigger('change') : $(
                        "#cif_factura").val("").trigger('change');
                    res.cp != null ? $("#cp_factura").val(res.cp).trigger('change') : $(
                        "#cp_factura").val("").trigger('change');
                    res.telefono != null ? $("#telefono_factura").val(res.telefono).trigger(
                        'change') : $("#telefono_factura").val("").trigger('change');
                    res.direccion != null ? $("#direccion_factura").val(res.direccion)
                        .trigger(
                            'change') : $("#direccion_factura").val("");


                    var data = []
                    if (res.emails != null) {
                        for (let e of res.emails.split(',')) {
                            data.push({
                                id: e,
                                text: e,
                                selected: false
                            });

                        }
                        data.push({
                            id: res.email,
                            text: res.email,
                            selected: true
                        });
                    } else {
                        data.push({
                            id: res.email,
                            text: res.email,
                            selected: true
                        });
                    }
                    $('#email_factura').empty()
                    $('#email_factura').select2({
                        data: data
                    }).trigger("change");



                    $("#id_cliente_factura").val(res.client_id)
                }
            });
        }


        function ValidateFactura() {

            var follow = true;



            if ($('#fecha_factura').val() == "") {
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                $.toast({
                    heading: 'Por favor rellena el campo de fecha.',
                    text: 'No se ha seleccionado ninguna fecha para el factura.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                follow = false;
            }

            if ($('#numero_factura').val() == "") {
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                $.toast({
                    heading: 'Por favor rellena el campo de Nº de factura.',
                    text: 'No se ha agregado el número del factura.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                follow = false;
            }
            return follow;

        }




        function EnviarFacturaManual(id) {
            var id_factura_manual_enviar = id
            $.ajax({
                type: 'POST',
                url: './mailer',
                cache: false,
                async: false,
                data: {
                    id_factura_manual_enviar: id_factura_manual_enviar

                },
                success: function(result2) {
                    console.log(result2);
                    $.toast({
                        heading: 'Factura enviada.',
                        text: 'Se ha enviado la factura correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });
        }
        $(document).on("click", '.btn_guardar', function(event) {

            $(this).attr("disabled", true);
            $(this).addClass("btn-loading");
            if (!ValidateFactura()) {
                $(this).attr("disabled", false);
                $(this).removeClass("btn-loading");
                return false
            }
            var id_factura_manual = "<?php echo $_GET["id"]; ?>"
            var id_proyecto = $('#select_proyectos').val()
            var nombre = $('#nombre_factura').val()
            var fecha = moment($('#fecha_factura').val()).format(
                'YYYY-MM-DD HH:mm:ss')
            var fecha_vencimiento = moment($('#fecha_vencimiento_factura').val()).format(
                'YYYY-MM-DD HH:mm:ss')
            var numero = $('#numero_factura').val()
            var estado = $(this).data("estado")
            var cif = $('#cif_factura').val()
            var cp = $('#cp_factura').val()
            var direccion = $('#direccion_factura').val()
            var telefono = $('#telefono_factura').val()
            var email = $('#email_factura').val()
            var condiciones = ($('#condiciones_factura').val() != "") ? $(
                '#condiciones_factura').val().replace(/(\r\n|\n|\r)/g, "\\n") : "No"
            var impuesto = ($('#impuesto_factura').val() != "") ? $(
                '#impuesto_factura').val().replace(/(\r\n|\n|\r)/g, "\\n") : "No"


            var importe = parseFloat($("#subtotal").data("total")).toFixed(2)


            var titulo = $('#titulo_factura').val()
            var client_id = $('#cliente_factura').val()

            var id_banco = ($(".bancos").length == 1 || $(".bancos").length == 2 || $(".bancos")
                    .length ==
                    3) ? $(".bancos")[0].getAttribute("data-id") :
                "No"
            var id_banco_2 = ($(".bancos").length == 2 || $(".bancos").length == 3) ? $(".bancos")[
                    1].getAttribute("data-id") :
                "No"
            var id_banco_3 = ($(".bancos").length == 3) ? $(".bancos")[2].getAttribute("data-id") :
                "No"

            if (estado == "Pendiente") {
                var fecha_envio = moment().format('YYYY-MM-DD HH:mm:ss')
            } else {
                var fecha_envio = null
            }

            var igic = parseFloat($("input[name=igic]:checked").val()).toFixed(2);
            var irpf = null
            if ($('#tipo_cliente_factura').val() == "Empresa") {
                irpf = parseFloat($('#irpf').val()).toFixed(2);
            }
            var tipo = $("#tipo_cliente_factura").val();
            var imagen = $("#url_imagen_factura input").val();
            var id_tramitadora = $('#id_tramitadora').find(':selected').val()
            var id_gestor = $('#id_gestor').find(':selected').val()
            var id_contable = $('#id_contable').find(':selected').val()
            var fechas = $('#fechas_factura').val()
            var lugar = $('#lugar_factura').val()
            const is_checked = $("#facturae_enabled").is(":checked");
            var programacion = $("#programado").is(":checked") ? moment($(
                '#programacion_factura').val()).format(
                'YYYY-MM-DD HH:mm:ss') : "No"
            $.ajax({
                type: 'POST',
                url: './api/factura_manual.php',
                cache: false,
                async: false,
                dataType: 'json',
                data: {
                    imagen: imagen,
                    tipo: tipo,
                    nombre: nombre,
                    fecha: fecha,
                    numero: numero,
                    estado: estado,
                    cif: cif,
                    cp: cp,
                    direccion: direccion,
                    telefono: telefono,
                    email: email,
                    importe: importe,
                    titulo: titulo,
                    client_id: client_id,
                    igic: igic,
                    irpf: irpf,
                    fecha_envio: fecha_envio,
                    fecha_vencimiento: fecha_vencimiento,
                    id_contable: is_checked ? id_contable : "No",
                    id_gestor: is_checked ? id_gestor : "No",
                    id_tramitadora: is_checked ? id_tramitadora : "No",
                    programado: programacion,
                    id_banco: id_banco,
                    id_banco_2: id_banco_2,
                    id_banco_3: id_banco_3,
                    condiciones: condiciones,
                    impuesto: impuesto,
                    fechas: fechas,
                    lugar: lugar,
                    id_proyecto: id_proyecto,
                    id_factura_manual_editar: id_factura_manual
                },

                success: function(factura) {
                    console.log(factura);
                    var datos = [];
                    $('#tabla_enviados').DataTable().rows().data().map((row) => {
                        var newRow = {};
                        for (var key in row) {
                            if (row.hasOwnProperty(key)) {
                                var value = row[key];
                                // Aplicar la operación de reemplazo si el valor es una cadena
                                if (typeof value === 'string') {
                                    newRow[key] = value.replace(/\n/g, '');
                                } else {
                                    newRow[key] =
                                        value; // Mantener el valor sin cambios si no es una cadena
                                }
                            }
                        }
                        let codigo = newRow["codigo"]
                        let descripcion = $.parseHTML(newRow["descripcion"])[1]
                            .innerText
                        let titulo = $.parseHTML(newRow["descripcion"])[0]
                            .innerText
                        let precio_unitario = parseFloat(convertirFormato(row[
                                "precio_unitario"]
                            .replace('€', ''))).toFixed(2)

                        let data = {
                            codigo: codigo,
                            descripcion: descripcion,
                            titulo: titulo,
                            cantidad: row["cantidad"],
                            precio_unitario: precio_unitario
                        }
                        datos.push(data)


                    })
                    console.log(datos);
                    var detallado = JSON.stringify(datos);

                    console.log(detallado);

                    $.ajax({
                        type: 'POST',
                        url: './api/factura_manual.php',
                        cache: false,
                        async: false,

                        data: {
                            id: factura.id,
                            detallado: detallado

                        },

                        success: function(detalle) {
                            console.log(detalle);
                            $.toast({
                                heading: 'Factura guardada.',
                                text: 'Se ha guardada el factura correctamente',
                                position: 'top-right',
                                loaderBg: '#32a852',
                                icon: 'success',
                                hideAfter: 2000,
                                stack: 6
                            })

                            if (estado == "Pendiente") {
                                EnviarFacturaManual(factura.id)

                            }
                            setTimeout(function() {

                                    window.location.href =
                                        "./historial_facturas_manuales"

                                },
                                2000);
                        }
                    })

                }
            });
        })

        $("#btn_agregar_detallado").click(function(e) {
            var des = $("#descripcion_edit").val()
            var tit = $("#titulo_edit").val()
            var prec = $("#precio_unitario_edit").val()
            var cant = $("#cantidad_edit").val()

            if (des == "" || (tit == "" && $('#titulo_check').prop("checked")) || prec == "" ||
                cant ==
                "") {
                $.toast({
                    heading: 'Por favor rellena todos los campos de la unidad de obra.',
                    text: 'No se ha rellenado algunos campos.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false
            }
            var titulo_apartado = ($('#titulo_check').prop("checked")) ? $('#titulo_edit')
                .val() :
                null
            var h5Titulo = document.createElement("h5");
            h5Titulo.className = "mb-2 text-center titulo_a";
            h5Titulo.textContent = titulo_apartado;
            var ids = $('.contenido.dropdown .dropdown-toggle').map(function() {
                return parseInt(this.id.split("_")[1]);
            }).get();
            var maxNumber = Math.max(...ids);
            var id = Table.rows().count()
            console.log(ids);
            id = (maxNumber == id || maxNumber == '-Infinity') ? id : maxNumber + 1

            var descripcion_apartado = $("#descripcion_edit").val();
            var pDescripcion = document.createElement("p");
            pDescripcion.className = "mb-2 descripcion_a";
            pDescripcion.textContent = descripcion_apartado;

            var divDescripcion = document.createElement("div");
            divDescripcion.appendChild(h5Titulo)
            divDescripcion.appendChild(pDescripcion)

            var cantidad_apartado = parseInt($("#cantidad_edit").val());

            var total = formatearNumero(parseFloat($("#precio_unitario_edit").val() * $(
                "#cantidad_edit").val()).toFixed(2))


            var precio_unitario_apartado = formatearNumero(parseFloat($("#precio_unitario_edit")
                .val()).toFixed(2))
            var nombre_medida = ($('#medida_edit').val() != "No") ? $(
                '#medida_edit').find(':selected').text() : ""
            var id_medida = $("#medida_edit").val()
            var div = document.createElement("div")
            var buttonEditar = document.createElement("a")
            var buttonEliminar = document.createElement("a")
            var apartado_id = $(this).data("id")
            div.setAttribute('class', 'd-flex flex-row align-items-center');


            if (!$(this).data("id")) {
                $.toast({
                    heading: 'Selecciona un apartado de la lista.',
                    text: 'Ningún apartado seleccionado.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false

            }
            if (descripcion_apartado == "" || $("#cantidad_edit").val() == "" || $(
                    "#precio_unitario_edit").val() == "") {
                $.toast({
                    heading: 'Rellena todos los campos del formulario.',
                    text: 'Faltan datos.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false

            }
            var codigo = $("#btn_agregar_detallado").data("codigo")
            buttonEditar.type = "button"
            buttonEliminar.type = "button"
            buttonEditar.classList.add("mr-2", "btn", "btn-sm", "btn-info", "editar-row")
            buttonEliminar.classList.add("btn", "btn-sm", "btn-danger", "eliminar-row")
            buttonEditar.innerText = "Editar"
            buttonEditar.setAttribute("data-id", apartado_id)

            buttonEditar.setAttribute("data-titulo", titulo_apartado)
            buttonEditar.setAttribute("data-descripcion", descripcion_apartado)
            buttonEditar.setAttribute("data-medida", id_medida)
            buttonEditar.setAttribute("data-cantidad", cantidad_apartado)
            buttonEditar.setAttribute("data-codigo", codigo)
            buttonEliminar.innerText = "Eliminar"
            div.append(buttonEditar)
            div.append(buttonEliminar)




            Table.row.add({
                index: id,
                codigo: codigo,
                descripcion: divDescripcion.innerHTML,
                cantidad: cantidad_apartado + " " + nombre_medida,
                precio_unitario: precio_unitario_apartado + " €",

                total: total + " €",
                acciones: div.outerHTML
            }).draw();
            Table.responsive.recalc();
        });

        Table.on('click', '.eliminar-row', function() {
            var $row = $(this).closest('tr');
            if ($row.hasClass("child")) {
                var $row1 = $(this).closest('tr').prev();
                Table.row($row1).remove()
                    .draw();
            }
            Table.row($row).remove()
                .draw();




        });
        Table.on('click', '.editar-row', function() {

            var $row = $(this).closest('tr');
            if ($row.hasClass("child")) {
                $row = $(this).closest('tr').prev();
            }

            var rowData = Table.row($row).data();
            var rowIndex = Table.row($row).index()
            var cantidad = rowData["cantidad"].split(" ")[0]
            var nombre_medida = rowData["cantidad"].split(" ")[1]

            if (typeof nombre_medida === 'undefined') {
                nombre_medida = "Ninguna"
            }
            if (nombre_medida == "") {
                nombre_medida = rowData["cantidad"].replace(/\s/g, '')
            }
            console.log(nombre_medida);
            var opcion = ($('#medida_apartado_editar').find('option:contains(' + nombre_medida +
                ')').length != 0) ? $('#medida_apartado_editar').find('option:contains(' +
                nombre_medida + ')').val() : "No";
            console.log(opcion);
            // Obtén el valor de la opción encontrada


            // Setea el valor en el Select2
            $('#medida_apartado_editar').val(opcion).trigger('change');

            var codigo = $(this).data('codigo')
            var id_medida = $(this).data('medida')
            var descripcion = $(this).data('descripcion')
            var titulo = $(this).data('titulo')
            var precio_unitario = rowData["precio_unitario"].replace('€', '')
            console.log(precio_unitario);
            document.getElementById('titulo_apartado_editar').value = titulo
            document.getElementById('cantidad_apartado_editar').value = parseInt(cantidad)
            document.getElementById('descripcion_apartado_editar').value = descripcion
            document.getElementById('precio_apartado_editar').value = parseFloat(convertirFormato(
                precio_unitario)).toFixed(2)

            document.getElementById('codigo_apartado_editar').value = codigo
            $('#btn_edit_apartado').data("index", rowIndex)
            $('#modalEditarApartado').modal("show")

        });


        if ($('#tipo_cliente_factura').val() == "Empresa") {
            $('#irpfview').css("display", "flex")
        } else {
            $('#irpfview').css("display", "none")
        }


        $('#tipo_cliente_factura').change(function(event) {
            if ($(this).val() == "Empresa") {
                $('#irpfview').css("display", "flex")
            } else {
                $('#irpfview').css("display", "none")
            }
            calcularSubtotal()
        })

        Table.on('draw', function() {
            calcularSubtotal()

        });


        $("#igicotro").change(function() {

            $("#igic").val($(this).val())

            calcularSubtotal()
        })
        $("input[name=igic]").change(function() {
            calcularSubtotal()
        })
        $("#irpf").change(function() {


            calcularSubtotal()
        })

        function calcularSubtotal() {
            var subtotal = 0.00;

            Table.rows().data().map((row) => {

                var precio = parseFloat(convertirFormato(row["precio_unitario"].replace('€', '')))


                subtotal += (parseInt(row["cantidad"]) * precio)



            })



            // console.log(subtotal);
            var total = subtotal;

            let por = $("input[name=igic]:checked").val() / 100;

            total = total + parseFloat(subtotal * por)


            $('#igic_pdf').text((por * 100).toFixed(2))
            $('#igic_monto_pdf').text(formatearNumero(parseFloat(subtotal * por).toFixed(2)))
            // console.log(total);
            if ($('#tipo_cliente_factura').val() == "Empresa") {
                var porcentaje = $('#irpf').val() / 100

                console.log(porcentaje);
                total = total - (parseFloat(subtotal * porcentaje));
                $('#irpf_pdf').text(parseFloat(porcentaje * 100).toFixed(2))
                $('#irpf_monto_pdf').text(formatearNumero(parseFloat(subtotal * porcentaje)
                    .toFixed(2)))
            }




            document.getElementById('subtotal').innerHTML = "Subtotal: " + formatearNumero(parseFloat(
                subtotal).toFixed(2)) + "€";
            $('#subtotal').data("total", subtotal)
            $('#subtotal_pdf').text(formatearNumero(parseFloat(subtotal).toFixed(2)))
            document.getElementById('total').innerHTML = "Total: " + formatearNumero(parseFloat(total)
                    .toFixed(2)) +
                "€";
            $('#total').data("total", parseFloat(total).toFixed(2))
            $('#total_pdf').text(formatearNumero(parseFloat(total).toFixed(2)))
            console.log(total);

            document.getElementById('total_factura').value = formatearNumero(parseFloat(total).toFixed(2))
            document.getElementById('total_letras').innerHTML = NumeroALetras(parseFloat(total).toFixed(2));

        }

        calcularSubtotal();




        LoadClienteData()





    });
})(jQuery);
</script>
<script>
// Obtener la fecha de hoy
var fechaHoy = new Date();
var dia = fechaHoy.getDate();
var mes = fechaHoy.getMonth() + 1;
var anio = fechaHoy.getFullYear();

// Formatear la fecha de hoy como "YYYY-MM-DD"
var fechaHoyFormateada = anio + "-" + (mes < 10 ? '0' + mes : mes) + "-" + (dia < 10 ? '0' + dia : dia);

// Establecer el valor del primer input
document.getElementById("fecha_factura").value = fechaHoyFormateada;

// Sumar una semana a la fecha de hoy
var fechaEnUnaSemana = new Date(fechaHoy);
fechaEnUnaSemana.setDate(fechaEnUnaSemana.getDate() + 7);

// Formatear la fecha en una semana como "YYYY-MM-DD"
var diaSemana = fechaEnUnaSemana.getDate();
var mesSemana = fechaEnUnaSemana.getMonth() + 1;
var anioSemana = fechaEnUnaSemana.getFullYear();
var fechaEnUnaSemanaFormateada = anioSemana + "-" + (mesSemana < 10 ? '0' + mesSemana : mesSemana) + "-" + (diaSemana <
    10 ? '0' + diaSemana : diaSemana);

// Establecer el valor del segundo input
document.getElementById("fecha_vencimiento_factura").value = fechaEnUnaSemanaFormateada;
</script>
<script>
(function($) {

    'use strict';
    $(function() {


        $(document).on("change", "#cambiar_img", function() {


            $("#url_imagen_factura img").attr("src", $(this).val()).trigger("change");
            $("#imagen_pdf").attr("src", $(this).val()).trigger("change");
            $("#url_imagen_factura input").val($(this).val());
        })
        $(document).on("change", "#url_imagen_factura img", function() {


            $("#url_imagen_factura input").val($(this).attr("src"));
            $("#imagen_pdf").attr("src", $(this).attr("src")).trigger(
                "change");
        })

        $(document).on("change", ".valor_personalizacion", function() {
            var nombre = $(this).data("nombre")
            var valor = $(this).val()
            $.ajax({
                type: 'POST',
                url: './api/personalizacion.php',
                cache: false,
                async: false,
                data: {
                    nombre: nombre,
                    valor: valor
                },
                success: function(result2) {

                    $.toast({
                        heading: 'Valor cambiado.',
                        text: 'Se ha cambiado la configuración correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    if (nombre == "url_logo_superior") {
                        $("img.logo_superior").each(function() {
                            console.log($(this));
                            $(this).attr("src", valor)

                        })
                    }
                }
            });


        });

        $("#facturae_enabled").click(() => {
            const is_checked = $("#facturae_enabled").is(":checked");
            if (is_checked) {
                $("#facturae").removeClass("d-none");
            } else {
                $("#facturae").addClass("d-none");
            }
        })
        $('#btn-delete-unidad-tramitadora').click(() => {
            const id = $("#edit_role_id").val();
            $.ajax({
                type: "DELETE",
                url: "./api/administraciones.php?id=" + id,
                cache: false,
                success: function(response) {
                    $("#id_tramitadora option[value=" + id + "]").remove()
                    $("#id_gestor option[value=" + id + "]").remove()
                    $("#id_contable option[value=" + id + "]").remove()
                }

            })
            $('#modalEditarBorrarTramitadora').modal("hide")
        });

        $('#btn-crear-unidad-tramitadora').click(() => {
            const generated_data = [];
            generated_data.push({
                "role": $("#create_role_tramite").val(),
                "codigo": $("#create_role_code").val(),
                "nombre": $("#create_role_name").val(),
                "direccion": $("#create_role_address").val(),
                "cp": $("#create_role_cp").val(),
                "ciudad": $("#create_role_city").val(),
                "provincia": $("#create_role_province").val(),
            });
            $.ajax({
                type: 'POST',
                url: './api/administraciones.php',
                data: {
                    data: generated_data[0]
                },
                cache: false,
                success: function(response) {
                    if ($("#create_role_tramite").val() === 'role_gestor') {
                        $("#id_gestor").append($('<option>', {
                            value: response,
                            text: $("#create_role_name").val()
                        }));
                    }
                    if ($("#create_role_tramite").val() === 'role_tramitadora') {
                        $("#id_tramitadora").append($('<option>', {
                            value: response,
                            text: $("#create_role_name").val()
                        }));
                    }
                    if ($("#create_role_tramite").val() === 'role_contable') {
                        $("#id_contable").append($('<option>', {
                            value: response,
                            text: $("#create_role_name").val()
                        }));
                    }
                    $('#modalcrearUnidad').modal("hide")
                }
            });
        })




        $(document).on("click", "#btn_eliminar_tramitadora", function(e) {
            const datas = $("#id_tramitadora").find('option:selected', this).attr(
                'data-overlay');
            const array_datas = datas.split('-');
            console.log(array_datas);
            const id = array_datas[0];
            const code = array_datas[1];
            const name = array_datas[2];
            const address = array_datas[3];
            const cp = array_datas[4];
            const city = array_datas[5];
            const province = array_datas[6];
            $("#edit_role_id").val(id)
            $("#edit_role_code").val(code)
            $("#edit_role_name").val(name)
            $("#edit_role_city").val(city)
            $("#edit_role_address").val(address)
            $("#edit_role_province").val(province)
            $("#edit_role_cp").val(cp)
            $('#modalEditarBorrarTramitadora').modal("show")
        })
        $(document).on("click", "#btn_eliminar_gestor", function(e) {
            const datas = $("#id_gestor").find('option:selected', this).attr('data-overlay');
            const array_datas = datas.split('-');
            const id = array_datas[0];
            const code = array_datas[1];
            const name = array_datas[2];
            const address = array_datas[3];
            const cp = array_datas[4];
            const city = array_datas[5];
            const province = array_datas[6];
            $("#edit_role_id").val(id)
            $("#edit_role_code").val(code)
            $("#edit_role_name").val(name)
            $("#edit_role_city").val(city)
            $("#edit_role_address").val(address)
            $("#edit_role_province").val(province)
            $("#edit_role_cp").val(cp)
            $('#modalEditarBorrarTramitadora').modal("show")
        })
        $(document).on("click", "#btn_eliminar_contable", function(e) {
            const datas = $("#id_contable").find('option:selected', this).attr('data-overlay');
            const array_datas = datas.split('-');
            const id = array_datas[0];
            const code = array_datas[1];
            const name = array_datas[2];
            const address = array_datas[3];
            const cp = array_datas[4];
            const city = array_datas[5];
            const province = array_datas[6];
            $("#edit_role_id").val(id)
            $("#edit_role_code").val(code)
            $("#edit_role_name").val(name)
            $("#edit_role_city").val(city)
            $("#edit_role_address").val(address)
            $("#edit_role_province").val(province)
            $("#edit_role_cp").val(cp)
            $('#modalEditarBorrarTramitadora').modal("show")
        })



        $("#programacion_factura").val(moment().format('YYYY-MM-DD HH:mm'))
        $("#programado").click(() => {
            const is_checked = $("#programado").is(":checked");
            if (is_checked) {
                $("#programacion_factura").prop('disabled', false);
            } else {
                $("#programacion_factura").prop('disabled', true);
            }

        })

        $("#btn_agregar_banco").click(function(e) {
            var id_banco = $("#select_bancos").val()

            if ($(".bancos").length >= 1) {
                $.toast({
                    heading: 'Cantidad máxima de bancos sobrepasada.',
                    text: 'Solo puedes agregar 1 banco.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            var rep = false
            $(".bancos").each(function() {
                if ($(this).data("id") == id_banco) {
                    $.toast({
                        heading: 'Banco repetido.',
                        text: 'Selecciona un banco que no este en la lista.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    rep = true;
                }

            })
            if (rep) {
                return false
            }


            if (id_banco == "No") {
                return false
            } else {
                var nombre = $("#select_bancos").select2("data")[0].text;
                var ul = document.getElementById("lista_bancos")
                var liElement = document.createElement('li');

                // Crea el elemento <span> dentro del <li>
                var spanElement = document.createElement('span');
                spanElement.setAttribute('data-id', id_banco);
                spanElement.setAttribute('class', 'bancos float-left');
                spanElement.textContent = nombre;

                // Crea el elemento <a> dentro del <li>
                var aElement = document.createElement('a');
                aElement.setAttribute('type', 'button');
                aElement.setAttribute('class', 'btn_quitar_banco float-right');
                aElement.setAttribute('style', 'cursor: pointer;');
                aElement.setAttribute('data-id', id_banco);

                // Crea el elemento <i> dentro del <a>
                var iElement = document.createElement('i');
                iElement.setAttribute('class', 'ti-close');

                // Agrega el <span> como hijo del <li>
                liElement.appendChild(spanElement);

                // Agrega el <a> como hijo del <li>
                liElement.appendChild(aElement);

                // Agrega el <i> como hijo del <a>
                aElement.appendChild(iElement);

                // Agrega el <li> al cuerpo del documento
                ul.appendChild(liElement);

                updatePDFbancos(id_banco)
            }



        });

        function updatePDFbancos(id_banco) {
            $.ajax({
                url: "./api/bancos.php?id_banco=" + id_banco,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(res) {
                    console.log($(".bancos").length);
                    if ($(".bancos").length == 1) {
                        $("#banco_1").css("display", "table-row-group");
                        $("#banco_2").css("display", "none");
                        $("#banco_3").css("display", "none");
                        $('#nombre_banco_1').text(res.nombre)
                        $("#beneficiario_banco_1").text(res.beneficiario)
                        $("#iban_banco_1").text(res.iban)
                        $("#swift_banco_1").text(res.swift)
                        $("#divisa_banco_1").text(res.divisa)

                    }
                    if ($(".bancos").length == 2) {
                        $("#banco_1").css("display", "table-row-group");
                        $("#banco_2").css("display", "table-row-group");
                        $("#banco_3").css("display", "none");
                        $('#nombre_banco_2').text(res.nombre)
                        $("#beneficiario_banco_2").text(res.beneficiario)
                        $("#iban_banco_2").text(res.iban)
                        $("#swift_banco_2").text(res.swift)
                        $("#divisa_banco_2").text(res.divisa)


                    }
                    if ($(".bancos").length == 3) {
                        $("#banco_1").css("display", "table-row-group");
                        $("#banco_2").css("display", "table-row-group");
                        $("#banco_3").css("display", "table-row-group");
                        $('#nombre_banco_3').text(res.nombre)
                        $("#beneficiario_banco_3").text(res.beneficiario)
                        $("#iban_banco_3").text(res.iban)
                        $("#swift_banco_3").text(res.swift)
                        $("#divisa_banco_3").text(res.divisa)


                    }

                }
            });
        }

        $(document).on("click", ".btn_quitar_banco", function() {
            var id_banco = $(this).data("id")
            $(this).closest('li').remove();
            updatePDFbancos(id_banco)
        })
    })
})(jQuery);
</script>
<script>
(function($) {
    'use strict';

    $(window).on('load', function() {
        function FillCondicion(id_condicion, target) {
            $.ajax({
                url: "./api/condiciones.php?id_condicion=" + id_condicion,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                success: function(res) {
                    if ($("#" + target).val() == "") {
                        $("#" + target).val(res.condicion)
                    } else {
                        $("#" + target).val($("#" + target).val() +
                            "\n" + res
                            .condicion)
                    }
                }
            });

        }

        function DeleteCondicion(id_condicion) {
            $.ajax({
                url: "./api/condiciones.php?id=" + id_condicion,
                type: 'DELETE',
                async: false, // added data type
                cache: false,
                success: function(res) {

                }
            });

        }

        $(document).on("click", ".btn_add_condicion", function() {
            FillCondicion($(this).data("id"), $("#lista_condiciones").data("target"));
        })

        $(document).on("click", ".btn_delete_condicion", function() {
            var id_condicion = $(this).data("id")
            DeleteCondicion(id_condicion);
            $("#condicion_" + id_condicion).remove();
        })
        $(document).on("click", ".btn_edit_condicion", function() {
            var id_condicion = $(this).data("id")
            $.ajax({
                url: "./api/condiciones.php?id_condicion=" + id_condicion,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                success: function(res) {
                    $("#titulo_condicion_editar").val(res.titulo)
                    $("#cuerpo_condicion_editar").val(res.condicion)
                    $("#btn_edit_condicion").data("id", id_condicion)
                    $("#modalEditarCondicion").modal("show")
                }
            });
        })


        $("#btn_agregar_condicion").click(function() {
            $("#btn_agregar_condicion").addClass("btn-loading")

            var titulo = $("#titulo_condicion").val()
            var condicion = $("#cuerpo_condicion").val()

            $.ajax({
                type: 'POST',
                url: './api/condiciones.php',
                data: {
                    titulo: titulo,
                    condicion: condicion

                },
                cache: false,
                success: function(response) {

                    $.toast({
                        heading: 'Condición agregada',
                        text: 'Se ha agregado la condición correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    var r = JSON.parse(response);
                    console.log(r)
                    var id = "condicion_" + r.id
                    var target = $("#lista_condiciones").data("target")
                    var li = document.createElement("li");
                    li.classList.add("d-flex")
                    li.classList.add("flex-row")
                    li.classList.add("mb-2")
                    li.classList.add("justify-content-between")
                    li.classList.add("align-items-center")
                    li.id = id
                    var p = document.createElement("p");
                    var div = document.createElement("div");
                    div.className = "d-flex flex-nowrap"
                    p.classList.add("mb-0")
                    var icono = document.createElement("i");
                    icono.style.fontSize = "10px";
                    icono.className = "m-0 fas fa-plus";
                    var button = document.createElement("button");
                    button.classList.add("btn_add_condicion")
                    button.classList.add("btn-sm")
                    button.classList.add("btn")
                    button.classList.add("btn-success")
                    button.setAttribute("data-id", r.id)
                    button.setAttribute("data-target", target)
                    button.append(icono)

                    var icono1 = document.createElement("i");
                    icono1.style.fontSize = "10px";
                    icono1.className = "m-0 fas fa-pencil-alt";
                    var button1 = document.createElement("button");
                    button1.classList.add("btn_edit_condicion")
                    button1.classList.add("mx-1")
                    button1.classList.add("btn-sm")
                    button1.classList.add("btn")
                    button1.classList.add("btn-info")
                    button1.setAttribute("data-id", r.id)
                    button1.append(icono1)

                    var icono2 = document.createElement("i");
                    icono2.style.fontSize = "10px";
                    icono2.className = "m-0 fas fa-trash-alt";
                    var button2 = document.createElement("button");
                    button2.classList.add("btn_delete_condicion")
                    button2.classList.add("btn-sm")
                    button2.classList.add("btn")
                    button2.classList.add("btn-danger")
                    button2.setAttribute("data-id", r.id)
                    button2.append(icono2)
                    p.innerText = r.titulo

                    /*  button.addEventListener('click', function() {
                          FillCondicion(r.id)
                      });*/



                    var lista = document.getElementById("lista_condiciones");

                    div.append(button2)
                    div.append(button1)
                    div.append(button)
                    lista.append(li)
                    li.append(p)
                    li.append(div)



                    $("#btn_agregar_condicion").removeClass("btn-loading")
                    $('#modalAgregarCondicion').modal("hide");
                }
            })

        })
        $("#btn_edit_condicion").click(function() {
            $("#btn_edit_condicion").addClass("btn-loading")
            var id_condicion = $(this).data("id")
            var titulo = $("#titulo_condicion_editar").val()
            var condicion = $("#cuerpo_condicion_editar").val()

            $.ajax({
                type: 'POST',
                url: './api/condiciones.php',
                async: false,
                cache: false,
                dataType: "json",
                data: {
                    titulo: titulo,
                    id_condicion: id_condicion,
                    condicion: condicion

                },
                success: function(r) {
                    console.log(r);
                    $.toast({
                        heading: 'Condición editada',
                        text: 'Se ha editado la condición correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $("#condicion_" + id_condicion + " p").text(r.titulo);

                    $("#btn_edit_condicion").removeClass("btn-loading")
                    $('#modalEditarCondicion').modal("hide");
                }
            })

        })
    });
})(jQuery);
</script>
<script>
(function($) {
    'use strict';

    $(window).on('load', function() {
        function FillImpuesto(id_impuesto, target) {
            $.ajax({
                url: "./api/impuestos.php?id_impuesto=" + id_impuesto,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                success: function(res) {
                    if ($("#" + target).val() == "") {
                        $("#" + target).val(res.impuesto)
                    } else {
                        $("#" + target).val($("#" + target)
                            .val() + "\n" + res
                            .impuesto)
                    }
                }
            });

        }

        function DeleteImpuesto(id_impuesto) {
            $.ajax({
                url: "./api/impuestos.php?id=" + id_impuesto,
                type: 'DELETE',
                async: false, // added data type
                cache: false,
                success: function(res) {

                }
            });

        }

        $(document).on("click", ".btn_add_impuesto", function() {
            var target = $("#lista_impuestos").data("target")
            FillImpuesto($(this).data("id"), target);
        })

        $(document).on("click", ".btn_delete_impuesto", function() {
            var id_impuesto = $(this).data("id")
            DeleteImpuesto(id_impuesto);
            $("#impuesto_" + id_impuesto).remove();
        })
        $(document).on("click", ".btn_edit_impuesto", function() {
            var id_impuesto = $(this).data("id")
            $.ajax({
                url: "./api/impuestos.php?id_impuesto=" + id_impuesto,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                success: function(res) {
                    $("#titulo_impuesto_editar").val(res.titulo)
                    $("#cuerpo_impuesto_editar").val(res.impuesto)
                    $("#btn_edit_impuesto").data("id", id_impuesto)
                    $("#modalEditarImpuesto").modal("show")
                }
            });
        })


        $("#btn_agregar_impuesto").click(function() {
            $("#btn_agregar_impuesto").addClass("btn-loading")

            var target = $("#lista_impuestos").data("target")
            var titulo = $("#titulo_impuesto").val()
            var impuesto = $("#cuerpo_impuesto").val()

            $.ajax({
                type: 'POST',
                url: './api/impuestos.php',
                data: {
                    titulo: titulo,
                    impuesto: impuesto

                },
                cache: false,
                success: function(response) {
                    $.toast({
                        heading: 'Impuesto agregado',
                        text: 'Se ha agregado el impuesto correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    var r = JSON.parse(response);
                    console.log(r)

                    var id = "impuesto_" + r.id

                    var li = document.createElement("li");
                    li.classList.add("d-flex")
                    li.classList.add("flex-row")
                    li.classList.add("mb-2")
                    li.classList.add("justify-content-between")
                    li.classList.add("align-items-center")
                    li.id = id
                    var p = document.createElement("p");
                    var div = document.createElement("div");
                    div.className = "d-flex flex-nowrap"
                    p.classList.add("mb-0")
                    var icono = document.createElement("i");
                    icono.style.fontSize = "10px";
                    icono.className = "m-0 fas fa-plus";
                    var button = document.createElement("button");
                    button.classList.add("btn_add_impuesto")
                    button.classList.add("btn-sm")
                    button.classList.add("btn")
                    button.classList.add("btn-success")
                    button.setAttribute("data-id", r.id)
                    button.setAttribute("data-target", target)
                    button.append(icono)

                    var icono1 = document.createElement("i");
                    icono1.style.fontSize = "10px";
                    icono1.className = "m-0 fas fa-pencil-alt";
                    var button1 = document.createElement("button");
                    button1.classList.add("btn_edit_impuesto")
                    button1.classList.add("mx-1")
                    button1.classList.add("btn-sm")
                    button1.classList.add("btn")
                    button1.classList.add("btn-info")
                    button1.setAttribute("data-id", r.id)
                    button1.append(icono1)

                    var icono2 = document.createElement("i");
                    icono2.style.fontSize = "10px";
                    icono2.className = "m-0 fas fa-trash-alt";
                    var button2 = document.createElement("button");
                    button2.classList.add("btn_delete_impuesto")
                    button2.classList.add("btn-sm")
                    button2.classList.add("btn")
                    button2.classList.add("btn-danger")
                    button2.setAttribute("data-id", r.id)
                    button2.append(icono2)
                    p.innerText = r.titulo

                    /*  button.addEventListener('click', function() {
                          FillImpuesto(r.id)
                      });*/



                    var lista = document.getElementById("lista_impuestos");

                    div.append(button2)
                    div.append(button1)
                    div.append(button)
                    lista.append(li)
                    li.append(p)
                    li.append(div)



                    $("#btn_agregar_impuesto").removeClass("btn-loading")
                    $('#modalAgregarImpuesto').modal("hide");
                }
            })

        })
        $("#btn_edit_impuesto").click(function() {
            $("#btn_edit_impuesto").addClass("btn-loading")
            var id_impuesto = $(this).data("id")
            var titulo = $("#titulo_impuesto_editar").val()
            var impuesto = $("#cuerpo_impuesto_editar").val()

            $.ajax({
                type: 'POST',
                url: './api/impuestos.php',
                async: false,
                cache: false,
                dataType: "json",
                data: {
                    titulo: titulo,
                    id_impuesto: id_impuesto,
                    impuesto: impuesto

                },
                success: function(r) {
                    console.log(r);
                    $.toast({
                        heading: 'Impuesto editado',
                        text: 'Se ha editado el impuesto correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $("#impuesto_" + id_impuesto + " p").text(r.titulo);

                    $("#btn_edit_impuesto").removeClass("btn-loading")
                    $('#modalEditarImpuesto').modal("hide");
                }
            })

        })
    });
})(jQuery);
</script>