<div id="head" class="content-wrapper crear_presupuesto">
         <div id="prueba">

         </div>
         <div class="container-fluid p-0">
             <div class="row">
                 <div class="col-xl-3">
                     <div class="card p-4 mb-4">
                         <p class="text-center title mb-4">Apartados disponibles</p>

                         <ul class="p-0 mb-3">

                             <?php
                    
                    foreach ($Apartados as $Apartado) {
                            ?>

                             <li>
                                 <div class="">
                                     <label class="custom-control custom-checkbox d-inline-block mb-3">
                                         <input type="checkbox" class="custom-control-input apartado"
                                             data-id=<?php echo htmlentities($Apartado['apartado_id'], ENT_QUOTES); ?>
                                             data-cantidad=<?php echo htmlentities($Apartado['cantidad'], ENT_QUOTES); ?>
                                             data-descripcion=<?php echo htmlentities($Apartado['descripcion'], ENT_QUOTES); ?>
                                             data-precio=<?php echo htmlentities($Apartado['precio_unitario'], ENT_QUOTES); ?>>
                                         <span
                                             class="custom-control-label"><?php echo htmlentities($Apartado['titulo'], ENT_QUOTES); ?></span>
                                     </label>
                                 </div>

                             </li>
                             <?php }?>
                         </ul>
                         <button type="button" data-toggle="modal" data-target="#modalAgregarApartado"
                             class="btn btn-sm btn-outline-primary">Agregar apartados</button>
                     </div>
                     <div class="total p-3">
                         <h4 id="total" data-total=0 class="mb-2 text-center">Total: 0€</h4>
                         <p style="text-transform: uppercase;" id="total_letras" class="mb-0 text-center">Cero Euros</p>
                     </div>

                 </div>
                 <div class="col-xl-9">
                     <div class="card p-4">
                         <h4 class="mb-4">Agregar o editar apartado del presupuesto</h4>
                         <form id="form-agregar" action="">
                             <div class="row">
                                 <div class="col-md-8">
                                     <div class="form-group">
                                         <label>Descripción</label>
                                         <textarea id="descripcion_edit" type="text" class="form-control m-0"
                                             name="descripcion_apartado" placeholder="" required></textarea>
                                     </div>
                                 </div>
                                 <div class="col-md-4">
                                     <div class="form-group">
                                         <label>Cantidad</label>
                                         <input id="cantidad_edit" type="number" class="form-control"
                                             name="cantidad_apartado" placeholder="" required>
                                     </div>
                                     <div class="form-group">
                                         <label>Precio unitario</label>

                                         <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">€</span>
                                            </div>
                                          
                                            <input id="precio_unitario_edit" type="number" class="form-control"
                                             name="precio_apartado" placeholder="" required>
                                             <div class="input-group-append">
                                                <span class="input-group-text">0.00</span>
                                            </div>
                                        </div>
                                        
                                     </div>
                                 </div>

                                 <div class="col-12">
                                     <div class="form-group text-right">
                                         <button type="submit" class="btn btn-sm btn-outline-primary">Agregar</button>
                                     </div>

                                 </div>
                             </div>
                         </form>

                         <hr>
                         <h4 class="mb-4 d-flex align-items-center justify-content-between">Presupuesto <a class=""
                                 id="verPresupuesto" data-toggle="modal" data-target="#modalVerPresupuesto" class=""
                                 href="">

                                 <lord-icon class="sidebar-menu-icon" src="https://cdn.lordicon.com/tyounuzx.json"
                                     trigger="hover"
                                     colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES);?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES);?>"
                                     style="width:50px;height:50px">
                                 </lord-icon>
                             </a> </h4>

                         <form id="form_agregar_presupuesto" enctype="multipart/form-data" action="POST">
                             <div class="row mb-3">
                                 <div class="col-md-6">
                                     <div class="form-group">
                                         <label>Título</label>
                                         <input type="text" class="form-control" id="titulo_presupuesto"
                                             name="titulo_presupuesto" placeholder="" required  value="<?php echo htmlentities($Presupuesto['titulo'], ENT_QUOTES); ?>">
                                     </div>
                                     <div class="row">
                                         <div class="col-6">
                                             <div class="form-group">
                                                 <label>Fecha</label>
                                                 <input type="date" class="form-control" name="fecha_presupuesto"
                                                     id="fecha_presupuesto" placeholder="" required value="<?php echo htmlentities($Presupuesto['fecha'], ENT_QUOTES); ?>">
                                             </div>
                                         </div>
                                         <div class="col-6">
                                             <div class="form-group">
                                                 <label>Nº de presupuesto</label>
                                                 <input type="number" class="form-control" name="numero_presupuesto"
                                                     id="numero_presupuesto" placeholder="" required  value="<?php echo htmlentities($Presupuesto['numero'], ENT_QUOTES); ?>">
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                                 <div class="col-md-6">
                                     <div class="form-group">
                                         <label>Cliente</label>
                                         <div class="input-group">
                                             <span class="input-group-prepend">
                                                 <button class="file-upload-browse btn btn-danger" type="button"
                                                    id="btn_eliminar_cliente">-</button>
                                             </span>
                                             <select name="cliente_presupuesto" id="cliente_presupuesto"
                                                 class="form-control custom-select text-center select2" required>

                                                 <?php                  
                                                foreach ($Clientes_List as $Cliente) {                                                   
                                                ?>
                                                 <option type="number"
                                                     value=<?php echo htmlentities($Cliente['client_id'], ENT_QUOTES)?>>
                                                     <?php echo htmlentities($Cliente['nombre'], ENT_QUOTES)?></option>

                                                 <?php }?>


                                             </select>
                                             <span class="input-group-append">
                                                 <button id="btn-add-cliente" class="file-upload-browse btn btn-info"
                                                     type="button">+</button>
                                             </span>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                             <div class="row mb-3">
                                 <div class="col-12">
                                     <div class="table-responsive">
                                         <table id="order-listing" class="table">
                                             <thead>
                                                 <tr>
                                                     <th
                                                         style="padding-left: 32px !important;padding-right: 50px !important;">
                                                         Cantidad </th>
                                                     <th>Descripción</th>
                                                     <th>Precio unitario</th>
                                                     <th>Total</th>
                                                     <th style="text-align:center;">Acciones</th>
                                                 </tr>
                                             </thead>
                                             <tbody>
                                             <?php

foreach(json_decode($Presupuesto["detallado"], true) as $d){

?>
<tr role="row" class="odd">
    <td> <?php echo htmlentities($d['cantidad'], ENT_QUOTES);?></td>
    <td><?php echo htmlentities($d['descripcion'], ENT_QUOTES);?></td>
    <td><?php echo htmlentities($d['precio_unitario'], ENT_QUOTES);?></td>
    <td><?php echo htmlentities(($d['precio_unitario']*$d['cantidad']), ENT_QUOTES);?></td>
    <td>
    <a type="button" data-id="13" class="mr-2 editar-row btn btn-sm btn-outline-info">Editar</a><a type="button" data-id="eliminar" class="eliminar-row btn btn-sm btn-outline-danger">Eliminar</a></td></tr>
<?php
}
?>


                                             </tbody>
                                         </table>
                                     </div>
                                 </div>
                             </div>

                            
                             <input type="hidden" value=0 id="total_presupuesto" name="total_presupuesto">
                            
                            
                            
                            
                           
                             

                            
                             <input type="hidden" id="estado_presupuesto" name="estado_presupuesto" value="No enviado">
                             <input id="mail" type="hidden" name="mail">
                             <input id="pdf" type="hidden" name="pdf">


                             <div class="row">
                                 <div class="col-12">
                                     <div class="form-group">
                                         <label>Condiciones Generales</label>
                                         <textarea type="text" class="form-control m-0" name="condiciones_presupuesto"
                                             id="condiciones_presupuesto" placeholder="" required value="<?php echo htmlentities($Presupuesto['condiciones'], ENT_QUOTES); ?>"></textarea>
                                     </div>
                                 </div>
                                 <div class="col-12 text-right">
                                     <button type="button" id="button-guardar"
                                         class="btn btn-sm btn-success">Guardar</button>
                                     <button type="button" id="button-enviar" class="btn btn-sm btn-success">Guardar
                                         y enviar</button>
                                 </div>
                             </div>
                         </form>

                     </div>
                 </div>
             </div>
         </div>









     </div>





     <!-- MODALS -->
     <div class="modal fade" id="modalVerPresupuesto" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">



                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>
                 <div class="modal-body">
                     <div id="presupuesto-pdf-container"
                         style="padding: 1.5rem;background:#ffffff;width:100%;display:block;font-family:'Poppins', sans-serif;font-size:11px;"
                         class="table-responsive">
                         <div class="row">
                             <div class="col-12" style="height:130px;">
                                 <img style="width: 250px;margin-top: 25px;" src="https://kitdigital.billregulator.com/image.php?id=3t14EW0FxQIQeBHljzfscZg7g">
                             </div>
                         </div>
                         <div class="row">
                             <div class="col-8">
                                 <h4 class="mb-4">Carpintería y gestión integral de proyectos Ignacio López Veloso</h4>
                                 <p style="color:#67757c;" class="mb-2"><strong>Taller: </strong>C/ Eufemiano Fuentes N
                                     15, Miller Bajo</p>
                                 <p style="color:#67757c;" class="mb-2"><strong>Teléfono: </strong>928 420 700</p>
                                 <p style="color:#67757c;" class="mb-2"><strong>Fax: </strong>928 420 821</p>
                                 <p style="color:#67757c;" class="mb-2"><strong>Email: </strong>info@proyectosilv.com
                                 </p>
                                 <p style="color:#67757c;" class="mb-0"><a href="">www.proyectosilv.com</a></p>
                             </div>
                             <div class="col-4">
                                 <h2
                                     style="font-weight:500;color:#c7825c;line-height: 36px;font-size: 24px;margin-bottom: 1rem;">
                                     PRESUPUESTO</h2>
                                 <p class="mb-2">Nº Presupuesto: <span id="pdf_numero_presupuesto"></span></p>
                                 <p>Fecha: <span id="pdf_fecha_presupuesto"></span></p>
                             </div>
                         </div>
                         <hr>
                         <div class="row">
                             <div class="col-8">

                                 <p class="mb-2" style="color:#67757c;"><strong>Cliente: </strong><span
                                         id="pdf_nombre_cliente"></span></p>
                                 <p class="mb-2" style="color:#67757c;"><strong>Dirección: </strong><span
                                         id="pdf_direccion_cliente"></span></p>
                                 <p class="mb-2" style="color:#67757c;"><strong>Obra: </strong><span
                                         id="pdf_obra_cliente"></span></p>
                                         <p class="mb-2" style="color:#67757c;"><strong>Sector: </strong><span
                                         id="pdf_sector_cliente"></span></p>
                                         <p class="mb-2" style="color:#67757c;"><strong>Fase: </strong><span
                                         id="pdf_fase_cliente"></span></p>

                                 <p class="mb-2" style="color:#67757c;"><strong>Teléfono: </strong><span
                                         id="pdf_telefono_cliente"></span></p>
                                 <p class="mb-2" style="color:#67757c;"><strong>Fax: </strong>928 420 700</p>
                                 <p class="mb-2" style="color:#67757c;"><strong>Email: </strong><span
                                         id="pdf_email_cliente"></p>

                             </div>
                             <div class="col-4">

                                 <p style="color:#67757c;" class="mb-2"><strong>CIF: </strong> <span
                                         id="pdf_cif_cliente"></span></p>
                                 <p style="color:#67757c;" class="mb-2"><strong>CP: </strong> <span
                                         id="pdf_cp_cliente"></span></p>
                             </div>
                         </div>
                         <hr>
                         <table class="table-fc" cellpadding="0" cellspacing="0"
                             style="border-bottom: 5px solid #c7825c;margin-top:15px;width:100%;margin-bottom:1rem;">
                             <thead>
                                 <th
                                     style="width: 25%;color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;border-bottom: 5px solid #c7825c;border-spacing: 0px;">
                                     Descripción</th>
                                 <th
                                     style="width: 25%;color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;border-bottom: 5px solid #c7825c;border-spacing: 0px;">
                                     Precio unitario</th>
                                 <th
                                     style="width: 25%;color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;border-bottom: 5px solid #c7825c;border-spacing: 0px;">
                                     Cantidad</th>
                                 <th
                                     style="width: 25%;color:#67757c;font-weight: 600;font-size: 14px;padding-bottom: 10px;border-bottom: 5px solid #c7825c;border-spacing: 0px;">
                                     Total</th>
                             </thead>
                             <tbody id="tabla-pdf">

                             </tbody>

                         </table>
                         <hr>

                         <h4 class="mb-4">Condiciones generales</h4>
                        <p style="color:#67757c;" class="mb-2" id="pdf_condiciones"></p>
                     </div>

                     <div class="modal-footer text-right">



                         <button id="btn-guardar-pdf" class="btn btn-info btn-fw" type="submit">

                             Descargar PDF</button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>





                     </div>


                 </div>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>


     <div class="modal fade" id="modalAgregarCliente" role="dialog" aria-labelledby="exampleModalCenterTitle"
         aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="nb-0">Agregar Cliente</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>



                 <div class="modal-body pb-0">

                     <div class="container-fluid p-0">


                         <div class="row">

                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Nombre del cliente</label>

                                     <div class="input-group">
                                         <span class="input-group-prepend">
                                             <button class="file-upload-browse btn btn-danger" type="button"
                                                 id="btn_eliminar">-</button>
                                         </span>
                                         <select id="select-seleccionar-cliente"
                                             class="form-control custom-select text-center select2">

                                             <?php                  

                                                    foreach ($Clientes_List as $Cliente) {                                               
                                                        
                                                    ?>
                                             <option type="text"
                                                 data-cp="<?php echo htmlentities($Cliente['cp'], ENT_QUOTES); ?>"
                                                 data-cif="<?php echo htmlentities($Cliente['cif'], ENT_QUOTES); ?>"
                                                 data-email="<?php echo htmlentities($Cliente['email'], ENT_QUOTES); ?>"
                                                 data-direccion="<?php echo htmlentities($Cliente['direccion'], ENT_QUOTES); ?>"
                                                 data-telefono="<?php echo htmlentities($Cliente['telefono'], ENT_QUOTES); ?>"
                                                 value=<?php echo htmlentities($Cliente['client_id'], ENT_QUOTES); ?>>
                                                 <?php echo htmlentities($Cliente['nombre'], ENT_QUOTES); ?>
                                             </option>

                                             <?php
                                                    } 
                                                        
                                                ?>
                                         </select>
                                         <span class="input-group-append">
                                             <button class="file-upload-browse btn btn-info" type="button"
                                                 data-toggle="modal" data-target="#modalAgregarClienteNuevo">+</button>
                                         </span>
                                     </div>

                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>CIF</label>

                                     <input type="number" class="form-control" id="input_cif" placeholder="">



                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Domicilio</label>

                                     <input type="dir" class="form-control" id="input_domicilio" placeholder="">

                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>C.P</label>

                                     <input type="number" class="form-control" id="input_cp" placeholder="">

                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Teléfono</label>

                                     <input type="tel" class="form-control" id="input_telefono" placeholder="">



                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Email</label>

                                     <input type="mail" class="form-control" id="input_email" placeholder="">

                                 </div>

                             </div>
                             <!--
                                 <div class="col-lg-4">

                                     <div class="form-group">

                                         <label>Nombre del proyecto</label>

                                         <input type="text" class="form-control" name="nombre_proyecto" placeholder="">

                                     </div>

                                 </div>
                                 <div class="col-lg-4">

                                     <div class="form-group">

                                         <label>Presupuesto(Número)</label>

                                         <input type="number" class="form-control" name="nombre_material"
                                             placeholder="">

                                     </div>

                                 </div>-->

                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Tipo</label>

                                     <select id="tipo_cliente" name="tipo_cliente"
                                         class="form-control custom-select text-center">



                                         <option type="text" value="Particular">Particular</option>

                                         <option type="text" value="Empresa">Empresa</option>



                                     </select>


                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Obra</label>

                                     <div class="input-group">
                                         <span class="input-group-prepend">
                                             <button class="file-upload-browse btn btn-danger" type="button"
                                                 id="btn_eliminar_obra">-</button>
                                         </span>
                                         <select id="input_obra" name="nombre_cliente"
                                             class="form-control custom-select text-center select2">


                                         </select>
                                         <span class="input-group-append">
                                             <button class="file-upload-browse btn btn-info" type="button"
                                                 data-toggle="modal" data-target="#modalAgregarObra">+</button>
                                         </span>
                                     </div>

                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Sector</label>

                                     <div class="input-group">
                                         <span class="input-group-prepend">
                                             <button class="file-upload-browse btn btn-danger" type="button"
                                             id="btn_eliminar_sector">-</button>
                                         </span>
                                         <select id="input_sector" name="nombre_sector"
                                             class="form-control custom-select text-center select2">

                                         </select>
                                         <span class="input-group-append">
                                             <button class="file-upload-browse btn btn-info" type="button"
                                                 data-toggle="modal" data-target="#modalAgregarSector">+</button>
                                         </span>
                                     </div>

                                 </div>

                             </div>
                             <!--
                                 <div class="col-lg-4">

                                     <div class="form-group">

                                         <label>Importe</label>

                                         <input type="number" class="form-control" name="importe" placeholder="">

                                     </div>

                                 </div>
                                 <div class="col-lg-4">

                                     <div class="form-group">

                                         <label>Oferta</label>

                                         <input type="text" class="form-control" name="oferta_cliente" placeholder="">

                                     </div>

                                 </div> -->
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Fase</label>

                                     <div class="input-group">
                                         <span class="input-group-prepend">
                                             <button class="file-upload-browse btn btn-danger" type="button"
                                             id="btn_eliminar_fase">-</button>
                                         </span>
                                         <select id="input_fase" name="input_fase"
                                             class="form-control custom-select text-center select2">

                                         </select>
                                         <span class="input-group-append">
                                             <button class="file-upload-browse btn btn-info" type="button"
                                                 data-toggle="modal" data-target="#modalAgregarFase">+</button>
                                         </span>
                                     </div>

                                 </div>

                             </div>
                             <div class="col-lg-4">

                                 <div class="form-group">

                                     <label>Responsable</label>

                                     <div class="input-group">
                                         <span class="input-group-prepend">
                                             <button class="file-upload-browse btn btn-danger" type="button"
                                                 data-toggle="modal" data-target="#modalQuitarNombre">-</button>
                                         </span>
                                         <select name="input_usuario" id="input_usuario"
                                             class="form-control custom-select text-center select2">
                                             <?php

                                                 foreach($User_List as $User){
                                                 ?>
                                             <option type="text"
                                                 value="<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>">
                                                 <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>
                                             </option>
                                             <?php

                                                  }
                                                    ?>
                                         </select>
                                         <span class="input-group-append">
                                             <button class="file-upload-browse btn btn-info" type="button"
                                                 data-toggle="modal" data-target="#modalAgregarNombre">+</button>
                                         </span>
                                     </div>

                                 </div>

                             </div>
                             <!--
                                 <div class="col-lg-4">

                                     <div class="form-group">

                                         <label>Estado</label>

                                         <select name="estado_cliente" class="form-control custom-select text-center">



                                             <option type="text" value="Pendiente">Pendiente</option>

                                             <option type="text" value="Contradado">Contradado</option>

                                             <option type="text" value="Denegado">Denegado</option>

                                         </select>


                                     </div>

                                 </div>-->
                         </div>

                     </div>



                 </div>

                 <div class="modal-footer text-right">



                     <button class="btn btn-success btn-fw" id="btn-add-cliente2">

                         Agregar</button>

                     <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                         Cancelar </button>





                 </div>



                 <!-- /modal-body -->

             </div>

         </div>

     </div>
     <div class="modal fade modal-cambiar" id="modalEliminarObra" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered" role="document">
             <div class="modal-content">
                 <div class="modal-header border-none">
                     <h4 class="mb-0">Eliminar</h4>
                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <i class="ti-close"></i>
                     </button>
                 </div>
                 <div class="modal-body pb-0">
                     <!-- btn -->



                     <p class="">¿Estás seguro de que deseas eliminar la obra definitivamente?</p>

                     <lottie-player autoplay src="assets/lottiefiles/warning.json"
                         style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





                 </div>

                 <!-- /btn -->

                 <div class="modal-footer text-right">
                     <form id="form_eliminar_obra" method="POST" action="">

                         <input type="hidden" id="id_obra_eliminar" name="id_obra_eliminar"data-name="">
                         <button class="btn btn-danger btn-fw" type="submit" name="">
                             Confirmar y eliminar </button>
                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                             Cancelar </button>

                     </form>
                 </div>
                 <!-- /modal-body -->
             </div>
         </div>
     </div>
     <div class="modal fade modal-cambiar" id="modalEliminarSector" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered" role="document">
             <div class="modal-content">
                 <div class="modal-header border-none">
                     <h4 class="mb-0">Eliminar</h4>
                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <i class="ti-close"></i>
                     </button>
                 </div>
                 <div class="modal-body pb-0">
                     <!-- btn -->



                     <p class="">¿Estás seguro de que deseas eliminar el sector definitivamente?</p>

                     <lottie-player autoplay src="assets/lottiefiles/warning.json"
                         style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





                 </div>

                 <!-- /btn -->

                 <div class="modal-footer text-right">
                     <form id="form_eliminar_sector" method="POST" action="">

                         <input data-name="" type="hidden" id="id_sector_eliminar" name="id_sector_eliminar">
                         <button class="btn btn-danger btn-fw" type="submit" name="">
                             Confirmar y eliminar </button>
                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                             Cancelar </button>

                     </form>
                 </div>
                 <!-- /modal-body -->
             </div>
         </div>
     </div>
     <div class="modal fade modal-cambiar" id="modalEliminarFase" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered" role="document">
             <div class="modal-content">
                 <div class="modal-header border-none">
                     <h4 class="mb-0">Eliminar</h4>
                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <i class="ti-close"></i>
                     </button>
                 </div>
                 <div class="modal-body pb-0">
                     <!-- btn -->



                     <p class="">¿Estás seguro de que deseas eliminar la fase definitivamente?</p>

                     <lottie-player autoplay src="assets/lottiefiles/warning.json"
                         style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





                 </div>

                 <!-- /btn -->

                 <div class="modal-footer text-right">
                     <form id="form_eliminar_fase" method="POST" action="">

                         <input type="hidden" id="id_fase_eliminar"data-name="" name="id_fase_eliminar">
                         <button class="btn btn-danger btn-fw" type="submit" name="">
                             Confirmar y eliminar </button>
                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                             Cancelar </button>

                     </form>
                 </div>
                 <!-- /modal-body -->
             </div>
         </div>
     </div>
     <div class="modal fade modal-cambiar" id="modalEliminarCliente" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered" role="document">
             <div class="modal-content">
                 <div class="modal-header border-none">
                     <h4 class="mb-0">Eliminar cliente</h4>
                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <i class="ti-close"></i>
                     </button>
                 </div>
                 <div class="modal-body pb-0">
                     <!-- btn -->



                     <p class="">¿Estás seguro de que deseas eliminar el cliente definitivamente?</p>

                     <lottie-player autoplay src="assets/lottiefiles/warning.json"
                         style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





                 </div>

                 <!-- /btn -->

                 <div class="modal-footer text-right">
                     <form id="form_eliminar_cliente" method="POST" action="">

                         <input type="hidden" id="id_cliente_eliminar"data-name="" name="id_cliente_eliminar">
                         <button class="btn btn-danger btn-fw" type="submit" id="btn_eliminar_cliente_2">
                             Confirmar y eliminar </button>
                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                             Cancelar </button>

                     </form>
                 </div>
                 <!-- /modal-body -->
             </div>
         </div>
     </div>
     <div class="modal fade" id="modalAgregarApartado" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered modal" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="mb-0"> Agregar Apartado</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>

                 <form id="form-agregar-apartado" method="POST" action="">

                     <div class="modal-body pb-0">

                         <div class="container-fluid p-0">

                             <div class="row">

                                 <div class="col-12">

                                     <div class="form-group">

                                         <label>Título</label>

                                         <input type="text" class="form-control" name="titulo_apartado" placeholder="">

                                     </div>

                                 </div>



                             </div>
                             <div class="row">
                                 <div class="col-md-12">
                                     <div class="form-group">
                                         <label>Descripción</label>
                                         <textarea type="text" class="form-control m-0" name="descripcion_apartado"
                                             placeholder=""></textarea>
                                     </div>
                                 </div>
                                 <div class="col-md-12">
                                     <div class="form-group">
                                         <label>Cantidad</label>
                                         <input type="number" class="form-control" name="cantidad_apartado"
                                             placeholder="">
                                     </div>
                                     <div class="form-group">
                                         <label>Precio unitario</label>

                                         <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">€</span>
                                            </div>
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">0.00</span>
                                            </div>
                                            <input type="number" class="form-control" name="precio_apartado"
                                             placeholder="">
                                        </div>
                                        
                                     </div>
                                 </div>


                             </div>

                         </div>



                     </div>

                     <div class="modal-footer text-right">



                         <button class="btn btn-info btn-fw" id="btn_add_apartado" type="button">

                             Añadir</button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>





                     </div>

                 </form>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>
     <div class="modal fade" id="modalEditarApartado" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle3" aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="mb-0"> Editar apartados del presupuesto</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>

                 <form id="form_editar_apartado" method="POST" action="">

                     <div class="modal-body pb-0">

                         <div class="container-lg p-0">

                             
                             <div class="row">
                                 <div class="col-md-12">
                                     <div class="form-group">
                                         <label>Descripción</label>
                                         <textarea type="text" class="form-control m-0"
                                             name="descripcion_apartado_editar"id="descripcion_apartado_editar" placeholder=""></textarea>
                                     </div>
                                 </div>
                                 <div class="col-md-12">
                                     <div class="form-group">
                                         <label>Cantidad</label>
                                         <input type="number" class="form-control" name="cantidad_apartado_editar"id="cantidad_apartado_editar"
                                             placeholder="">
                                     </div>
                                     <div class="form-group">
                                         <label>Precio unitario</label>

                                             <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">€</span>
                                            </div>
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">0.00</span>
                                            </div>
                                            <input type="number" class="form-control" name="precio_apartado_editar"id="precio_apartado_editar"/>
                                        </div>
                                     </div>
                                 </div>


                             </div>

                         </div>



                     </div>

                     <div class="modal-footer text-right">

<input id="id_apartado_editar" type="hidden" name="id_apartado_editar">

                         <button class="btn btn-info btn-fw" id="btn_editar_apartado" type="button">

                             Editar</button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>





                     </div>

                 </form>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>

     <div class="modal modal-cambiar fade" id="modalEliminarApartado" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="nb-0"> Eliminar material</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>

                 <div class="modal-body pb-0">

                     <!-- btn -->







                     <p class="">¿Estás seguro de que deseas eliminar el apartado definitivamente?</p>



                     <lottie-player autoplay src="assets/lottiefiles/warning.json"
                         style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











                 </div>



                 <!-- /btn -->


                 <div class="modal-footer text-right">

                     <form method="GET" action="">





                         <button class="btn btn-danger btn-fw" id="delete_material" type="submit"
                             name="delete_material">

                             Confirmar y eliminar </button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>



                     </form>

                 </div>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>
     <div class="modal fade" id="modalAgregarObra" role="dialog" aria-labelledby="exampleModalCenterTitle"
         aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="mb-0"> Agregar Obra</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>


                 <form id="form-agregar-obra" method="POST" action="">

                     <div class="modal-body pb-0">

                         <div class="container p-0">

                             <div class="row">

                                 <div class="col-12">
                                     <input class="w-100"required name="nombre_obra" id="nombre_obra" type="text">
                                 </div>

                             </div>

                         </div>



                     </div>

                     <div class="modal-footer text-right">

                         <input type="hidden" id="cliente_obra_id" name="cliente_obra_id" value="22">

                         <button class="btn btn-danger btn-fw" id="add_material" type="submit">

                             Agregar</button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>





                     </div>

                 </form>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>
     <div class="modal fade" id="modalAgregarSector" role="dialog" aria-labelledby="exampleModalCenterTitle"
         aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="mb-0"> Agregar sector</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>


                 <form id="form-agregar-sector" method="POST" action="">

                     <div class="modal-body pb-0">

                         <div class="container p-0">

                             <div class="row">

                                 <div class="col-12">
                                     <input class="w-100" name="nombre_sector" id="nombre_sector"required type="text">
                                 </div>

                             </div>

                         </div>



                     </div>

                     <div class="modal-footer text-right">

                         <input type="hidden" id="cliente_sector_id" name="cliente_sector_id">

                         <button class="btn btn-danger btn-fw" type="submit">

                             Agregar</button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>





                     </div>

                 </form>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>


     <div class="modal fade" id="modalAgregarFase" role="dialog" aria-labelledby="exampleModalCenterTitle"
         aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="mb-0"> Agregar fase</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>


                 <form id="form-agregar-fase" method="POST" action="">

                     <div class="modal-body pb-0">

                         <div class="container p-0">

                             <div class="row">

                                 <div class="col-12">
                                     <input class="w-100" name="nombre_fase" id="nombre_fase" type="text"required>
                                 </div>

                             </div>

                         </div>



                     </div>

                     <div class="modal-footer text-right">

                         <input type="hidden" id="cliente_fase_id" name="cliente_fase_id">

                         <button class="btn btn-danger btn-fw" type="submit">

                             Agregar</button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>





                     </div>

                 </form>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>
     <div class="modal fade" id="modalAgregarClienteNuevo" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

         <div class="modal-dialog modal-dialog-centered" role="document">

             <div class="modal-content">

                 <div class="modal-header border-none">

                     <h4 class="mb-0">Agregar Cliente</h4>

                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                         <i class="ti-close"></i>

                     </button>

                 </div>

                 <form id="form-agregar-cliente-nuevo" method="POST" action="">

                     <div class="modal-body pb-0">

                         <div class="container p-0">

                             <div class="row">

                                 <div class="col-6">

                                     <div class="form-group">

                                         <label>Nombre del cliente</label>

                                         <input type="text" class="form-control" id="nombre_cliente_agregar"name="nombre_cliente_agregar" placeholder=""
                                             required>

                                     </div>

                                 </div>

                                 <div class="col-6">

                                     <div class="form-group">

                                         <label>CIF</label>


                                         <input type="number" class="form-control" id="cif_cliente_agregar"name="cif_cliente_agregar" placeholder=""
                                             >


                                     </div>

                                 </div>

                                 <div class="col-6">

                                     <div class="form-group">

                                         <label>Direccion</label>

                                         <input type="text" class="form-control" id="direccion_cliente_agregar"name="direccion_cliente_agregar"
                                             placeholder="">


                                     </div>

                                 </div>

                                 <div class="col-6">

                                     <div class="form-group">

                                         <label>C.P</label>

                                         <input type="number" class="form-control" id="cp_cliente_agregar"name="cp_cliente_agregar" placeholder=""
                                             >

                                     </div>

                                 </div>
                                 <div class="col-6">

                                     <div class="form-group">

                                         <label>E-mail</label>

                                         <input type="email" class="form-control" id="email_cliente_agregar"name="email_cliente_agregar" placeholder=""
                                             required>


                                     </div>

                                 </div>

                                 <div class="col-6">

                                     <div class="form-group">

                                         <label>Teléfono</label>

                                         <input type="tel" class="form-control" id="tel_cliente_agregar"name="tel_cliente_agregar" placeholder=""
                                             >

                                     </div>


                                 </div>


                             </div>

                         </div>



                     </div>

                     <div style="margin-top:15px;" class="modal-footer text-right">

                         <button class="btn btn-success btn-fw" id="btn_agregar_cliente_nuevo" type="button" name="add_cliente">

                             Agregar</button>

                         <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                             Cancelar </button>





                     </div>

                 </form>

                 <!-- /modal-body -->

             </div>

         </div>

     </div>




     <script>
function Unidades(num) {

    switch (num) {
        case 1:
            return 'Un ';
        case 2:
            return 'Dos ';
        case 3:
            return 'Tres ';
        case 4:
            return 'Cuatro ';
        case 5:
            return 'Cinco ';
        case 6:
            return 'Seis ';
        case 7:
            return 'Siete ';
        case 8:
            return 'Ocho ';
        case 9:
            return 'Nueve ';
    }

    return '';
} //Unidades()

function Decenas(num) {

    decena = Math.floor(num / 10);
    unidad = num - (decena * 10);

    switch (decena) {
        case 1:
            switch (unidad) {
                case 0:
                    return 'Diez ';
                case 1:
                    return 'Once ';
                case 2:
                    return 'Doce ';
                case 3:
                    return 'Trece ';
                case 4:
                    return 'Catorce ';
                case 5:
                    return 'Quince ';
                default:
                    return 'Dieci ' + Unidades(unidad);
            }
            case 2:
                switch (unidad) {
                    case 0:
                        return 'Veinte ';
                    default:
                        return 'Veinti ' + Unidades(unidad);
                }
                case 3:
                    return DecenasY('Treinta ', unidad);
                case 4:
                    return DecenasY('Cuarenta ', unidad);
                case 5:
                    return DecenasY('Cincuenta ', unidad);
                case 6:
                    return DecenasY('Sesenta ', unidad);
                case 7:
                    return DecenasY('Setenta ', unidad);
                case 8:
                    return DecenasY('Ochenta ', unidad);
                case 9:
                    return DecenasY('Noventa ', unidad);
                case 0:
                    return Unidades(unidad);
    }
} //Unidades()

function DecenasY(strSin, numUnidades) {
    if (numUnidades > 0)
        return strSin + 'Y ' + Unidades(numUnidades)

    return strSin;
} //DecenasY()

function Centenas(num) {
    centenas = Math.floor(num / 100);
    decenas = num - (centenas * 100);

    switch (centenas) {
        case 1:
            if (decenas > 0)
                return 'Ciento ' + Decenas(decenas);
            return 'Cien ';
        case 2:
            return 'Doscientos ' + Decenas(decenas);
        case 3:
            return 'Trescientos ' + Decenas(decenas);
        case 4:
            return 'Cuatrocientos ' + Decenas(decenas);
        case 5:
            return 'Quinientos ' + Decenas(decenas);
        case 6:
            return 'Seiscientos ' + Decenas(decenas);
        case 7:
            return 'Setecientos ' + Decenas(decenas);
        case 8:
            return 'Ochocientos ' + Decenas(decenas);
        case 9:
            return 'Novecientos ' + Decenas(decenas);
    }

    return Decenas(decenas);
} //Centenas()

function Seccion(num, divisor, strSingular, strPlural) {
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    letras = '';

    if (cientos > 0)
        if (cientos > 1)
            letras = Centenas(cientos) + '' + strPlural;
        else
            letras = strSingular;

    if (resto > 0)
        letras += '';

    return letras;
} //Seccion()

function Miles(num) {
    divisor = 1000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMiles = Seccion(num, divisor, 'un mil ', 'mil ');
    strCentenas = Centenas(resto);

    if (strMiles == '')
        return strCentenas;

    return strMiles + '' + strCentenas;
} //Miles()

function Millones(num) {
    divisor = 1000000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMillones = Seccion(num, divisor, 'un millon de ', 'millones de ');
    strMiles = Miles(resto);

    if (strMillones == '')
        return strMiles;

    return strMillones + '' + strMiles;
} //Millones()

function NumeroALetras(num) {
    var data = {
        numero: num,
        enteros: Math.floor(num),
        centavos: (((Math.round(num * 100)) - (Math.floor(num) * 100))),
        letrasCentavos: '',
        letrasMonedaPlural: 'Euros ', //'PESOS', 'Dólares', 'Bolívares', 'etcs'
        letrasMonedaSingular: 'Euro ', //'PESO', 'Dólar', 'Bolivar', 'etc'

        letrasMonedaCentavoPlural: 'centavos ',
        letrasMonedaCentavoSingular: 'centavo '
    };

    if (data.centavos > 0) {
        data.letrasCentavos = 'con ' + (function() {
            if (data.centavos == 1)
                return Millones(data.centavos) + '' + data.letrasMonedaCentavoSingular;
            else
                return Millones(data.centavos) + '' + data.letrasMonedaCentavoPlural;
        })();
    };

    if (data.enteros == 0)
        return 'cero ' + data.letrasMonedaPlural + '' + data.letrasCentavos;
    if (data.enteros == 1)
        return Millones(data.enteros) + '' + data.letrasMonedaSingular + '' + data.letrasCentavos;
    else
        return Millones(data.enteros) + '' + data.letrasMonedaPlural + '' + data.letrasCentavos;
} //NumeroALetras()

(function($) {

    'use strict';

    $(function() {

        var Table = $('#order-listing').DataTable({

            "aLengthMenu": [

                [5, 10, 15, -1],

                [5, 10, 15, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en apartados",

                infoEmpty: "Mostrando 0 to 0 of 0 en apartados",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                loadingRecords: "Cargando...",

                processing: "Procesando...",



                zeroRecords: "Sin resultados encontrados",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "order": [

                [0, "desc"]

            ]

        });

        var checks = document.getElementsByClassName("apartado");
        var buttons = '<a type="button" class="mr-2 editar-row btn btn-sm btn-outline-info">Editar</a><a type="button" data-id="eliminar" class="eliminar-row btn btn-sm btn-outline-danger">Eliminar</a>';

        for (let check of checks) {

            check.addEventListener('change', function(e) {


                if (event.target.checked) {

                    $.ajax({
                        url: "./api/apartados.php?apartado_id=" + e.target.getAttribute(
                            'data-id'),
                        type: 'GET',
                        dataType: 'json', // added data type
                        cache: false,
                        success: function(res) {
                            $("#descripcion_edit").val(res.descripcion)
                            $("#cantidad_edit").val(res.cantidad)
                            $("#precio_unitario_edit").val(res.precio_unitario)
                            buttons = '<a type="button"data-id='+res.apartado_id+' class="mr-2 editar-row btn btn-sm btn-outline-info">Editar</a><a type="button" data-id="eliminar" class="eliminar-row btn btn-sm btn-outline-danger">Eliminar</a>'

                        }
                    });

                    for (let c of checks) {
                        c.checked = false;
                    }
                    event.target.checked = true;

                }



            });

        }









        Table.on('draw', function() {
            var total = 0;

            Table.rows().data().map((row) => {
                total += (parseInt(row[0]) * parseInt(row[2]))

            })
            document.getElementById('total').innerHTML = "Total: " + total + "€";
            document.getElementById('total_presupuesto').value = total;
            document.getElementById('total_letras').innerHTML = NumeroALetras(total);

        });

        $("#btn_add_apartado").click(function() {
            $("#btn_add_apartado").addClass("btn-loading")
           
            $('#form-agregar-apartado').submit()

        })

        $('#form-agregar-apartado').submit(function(event) {
            $.ajax({
                type: 'POST',
                url: './crear_presupuesto',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    $.toast({
                        heading: 'Apartado agregado',
                        text: 'Se ha agregado el apartado correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        $("#btn_add_apartado").removeClass("btn-loading")
                        $('#modalAgregarApartado').modal("hide")
                        window.location.reload();
                    }, 2000);
                }
            });

            return false;

        })




        $("#button-guardar").click(function() {
            $("#button-guardar").addClass('btn-loading');

            $('#estado_presupuesto').val('No enviado')
            $('#form_agregar_presupuesto').submit()
        })

        $("#button-enviar").click(function() {
            $("#button-enviar").addClass('btn-loading');
            var tablaPdf = document.getElementById("tabla-pdf")
            $('#estado_presupuesto').val('Pendiente')

            var datos = [];
            Table.rows().data().map((row) => {
                let data = {
                    cantidad: row[0],
                    descripcion: row[1],
                    precio_unitario: row[2],
                    total: row[3]
                }
                datos.push(data)


            })


            for (let d of datos) {
                console.log(datos);
                tablaPdf.innerHTML += '<tr><td style="padding:0.5rem;">' + d.descripcion +
                    '</td><td style="padding:0.5rem;">' + d.precio_unitario + '€' + 
                    '</td><td>' + d
                    .cantidad + '</td><td style="padding:0.5rem;">' + d.total + '€' + 
                    '</td style="padding:0.5rem;"></tr>'
            }


            $('#pdf_nombre_cliente').text($('#cliente_presupuesto').find(':selected').text())
            $('#pdf_direccion_cliente').text($('#input_domicilio').val())
            if (!isNaN(parseInt($('#input_obra').val()))) {
                $('#pdf_obra_cliente').text($('#input_obra').find(':selected').text())
            }
            if (!isNaN(parseInt($('#input_sector').val()))) {
                $('#pdf_sector_cliente').text($('#input_sector').find(':selected').text())
            }
            if (!isNaN(parseInt($('#input_fase').val()))) {
                $('#pdf_fase_cliente').text($('#input_fase').find(':selected').text())
            }

            $('#pdf_telefono_cliente').text($('#input_telefono').val())
            $('#pdf_email_cliente').text($('#input_email').val())
            $('#pdf_cif_cliente').text($('#input_cif').val())
            $('#pdf_cp_cliente').text($('#input_cp').val())
            $('#pdf_numero_presupuesto').text($('#numero_presupuesto').val())
            $('#pdf_fecha_presupuesto').text($('#fecha_presupuesto').val())
            $('#pdf_condiciones').text($('#condiciones_presupuesto').val())



            $("#mail").val($('#input_email').val())
            $("#pdf").val($("#presupuesto-pdf-container").html())
          
            $('#form_agregar_presupuesto').submit()




        })

        $('#form_agregar_presupuesto').submit(function(event) {

            var datos = [];
            Table.rows().data().map((row) => {
                let data = {
                    cantidad: row[0],
                    descripcion: row[1],
                    precio_unitario: row[2]
                }
                datos.push(data)


            })




            var fecha_presupuesto = $('#fecha_presupuesto').val()
            var numero_presupuesto = parseInt($('#numero_presupuesto').val())
            var estado_presupuesto = $('#estado_presupuesto').val()
            var cif_presupuesto = parseInt($('#input_cif').val())
            var cp_presupuesto = parseInt($('#input_cp').val())
            var direccion_presupuesto = $('#input_domicilio').val()
            var telefono_presupuesto = $('#input_telefono').val()
            var email_presupuesto = $('#input_email').val()
            var tipo_presupuesto = $('#tipo_cliente').val()
            var usuario_presupuesto = parseInt($('#input_usuario').val())
            var id_obra_presupuesto = ""
            var id_sector_presupuesto = ""
            var id_fase_presupuesto = ""
            var mail = $('#mail').val()
            var pdf = $('#pdf').val()
            var total_presupuesto = parseInt($("#total_presupuesto").val())
            var detalle_presupuesto = JSON.stringify(datos)
            var titulo_presupuesto = $('#titulo_presupuesto').val()
            var cliente_presupuesto = $('#cliente_presupuesto').find(':selected').val()
            var condiciones_presupuesto = $('#condiciones_presupuesto').val()
            if (!isNaN(parseInt($('#input_obra').val()))) {


                id_obra_presupuesto = parseInt($('#input_obra').val())


            }
            if (!isNaN(parseInt($('#input_sector').val()))) {




                id_sector_presupuesto = parseInt($('#input_sector').val())

            }
            if (!isNaN(parseInt($('#input_fase').val()))) {

                id_fase_presupuesto = parseInt($('#input_fase').val())


            } 
         var follow = true;
         if($('#input_telefono').val() == ""){
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                        $.toast({
                            heading: 'Por favor rellena el campo teléfono del cliente.',
                            text: 'No se ha añadido un número de teléfono al cliente.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
               follow = false;
            }
            
         if($('#input_domicilio').val() == ""){
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                        $.toast({
                            heading: 'Por favor rellena el campo domicilio del cliente.',
                            text: 'No se ha añadido ningún domicilio al cliente.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
               follow = false;
            }
         if($('#input_cp').val() == ""){
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                        $.toast({
                            heading: 'Por favor rellena el campo CP del cliente.',
                            text: 'No se ha añadido un código postal al cliente.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
               follow = false;
            }
         if($('#input_cif').val() == ""){
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                        $.toast({
                            heading: 'Por favor rellena el campo CIF del cliente.',
                            text: 'No se ha añadido un número de CIF al cliente.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
               follow=false;
            }
            if($('#fecha_presupuesto').val() == ""){
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                        $.toast({
                            heading: 'Por favor rellena el campo de fecha.',
                            text: 'No se ha seleccionado ninguna fecha para el presupuesto.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
               follow=false;
            }
            if($('#titulo_presupuesto').val() == ""){
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                        $.toast({
                            heading: 'Por favor rellena el campo de título.',
                            text: 'No se ha seleccionado ningun título para el presupuesto.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
               follow=false;
            }
            if($('#numero_presupuesto').val() == ""){
                $("#button-enviar").removeClass('btn-loading');
                $("#button-guardar").removeClass('btn-loading');
                        $.toast({
                            heading: 'Por favor rellena el campo de Nº de presupuesto.',
                            text: 'No se ha agregado el número del presupuesto.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                follow=false;
            }
            if(!follow){
                return false;
            }

            var e = ""
                if($('#estado_presupuesto').val()=="Pendiente"){
                e = "y enviado."
                }



            $.ajax({
                type: 'POST',
                url: './editar_presupuesto?id='+event.target.getAttribute('data-id'),
                cache: false,
                data: {
                    estado_presupuesto: estado_presupuesto,
                    fecha_presupuesto: fecha_presupuesto,
                    cif_presupuesto: cif_presupuesto,
                    cp_presupuesto: cp_presupuesto,
                    direccion_presupuesto: direccion_presupuesto,
                    telefono_presupuesto: telefono_presupuesto,
                    email_presupuesto: email_presupuesto,
                    tipo_presupuesto: tipo_presupuesto,
                    usuario_presupuesto: usuario_presupuesto,
                    id_obra_presupuesto: id_obra_presupuesto,
                    id_sector_presupuesto: id_sector_presupuesto,
                    id_fase_presupuesto: id_fase_presupuesto,
                    mail: mail,
                    pdf: pdf,
                    total_presupuesto: total_presupuesto,
                    detalle_presupuesto: detalle_presupuesto,
                    titulo_presupuesto: titulo_presupuesto,
                    cliente_presupuesto: cliente_presupuesto,
                    condiciones_presupuesto: condiciones_presupuesto,
                    numero_presupuesto: numero_presupuesto
                },

                success: function(result) {
                    console.log(result);
                    $.toast({
                        heading: 'Presupuesto editado '+e,
                        text: 'Se ha editado el presupuesto correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                }
            });

            return false;
        });











        var formulario = document.getElementById('form-agregar');




        formulario.addEventListener("submit", handleSubmit);



      
        var btnVerPresupuesto = document.getElementById("verPresupuesto");
        var tablaPdf = document.getElementById("tabla-pdf")

        btnVerPresupuesto.addEventListener('click', function() {
            var datos = [];
            Table.rows().data().map((row) => {
                let data = {
                    cantidad: row[0],
                    descripcion: row[1],
                    precio_unitario: row[2],
                    total: row[3]
                }
                datos.push(data)


            })


            for (let d of datos) {
                console.log(datos);
                tablaPdf.innerHTML += '<tr><td style="padding:0.5rem;">' + d.descripcion +
                    '</td><td style="padding:0.5rem;">' + d.precio_unitario + '€'+
                    '</td><td>' + d
                    .cantidad + '</td><td style="padding:0.5rem;">' + d.total + '€'+
                    '</td style="padding:0.5rem;"></tr>'
            }


            $('#pdf_nombre_cliente').text($('#cliente_presupuesto').find(':selected').text())
            $('#pdf_direccion_cliente').text($('#input_domicilio').val())
            if (!isNaN(parseInt($('#input_obra').val()))) {
                $('#pdf_obra_cliente').text($('#input_obra').find(':selected').text())
            }
            if (!isNaN(parseInt($('#input_sector').val()))) {
                $('#pdf_sector_cliente').text($('#input_sector').find(':selected').text())
            }
            if (!isNaN(parseInt($('#input_fase').val()))) {
                $('#pdf_fase_cliente').text($('#input_fase').find(':selected').text())
            }

            $('#pdf_telefono_cliente').text($('#input_telefono').val())
            $('#pdf_email_cliente').text($('#input_email').val())
            $('#pdf_cif_cliente').text($('#input_cif').val())
            $('#pdf_cp_cliente').text($('#input_cp').val())
            $('#pdf_numero_presupuesto').text($('#numero_presupuesto').val())
            $('#pdf_fecha_presupuesto').text($('#fecha_presupuesto').val())
            $('#pdf_condiciones').text($('#condiciones_presupuesto').val())

        })



        function handleSubmit(e) {
            e.preventDefault();
            const formData = new FormData(e.target);
            const formProps = Object.fromEntries(formData);
            console.log(formProps);
            Table.row.add([formProps.cantidad_apartado,
                formProps.descripcion_apartado,
                formProps.precio_apartado,
            (formProps.precio_apartado * formProps.cantidad_apartado),
                buttons,
            ]).draw();

        }

        Table.on('click', '.eliminar-row', function() {
            let id = $(this).data('id')
            for (let check of checks) {
                if (check.getAttribute('data-id') == id) {
                    check.checked = false;
                }
            }
            Table.row($(this).parents('tr'))
                .remove()
                .draw();
        });

        Table.on('click', '.editar-row', function() {

           
            
            let id = $(this).data('id')
            for (let check of checks) {
                if (check.getAttribute('data-id') == id) {
                    check.checked = false;
                }
            }
            var cantidad = Table.row($(this).parents('tr')).data()[0]
            var descripcion = Table.row($(this).parents('tr')).data()[1]
            var precio_unitario = Table.row($(this).parents('tr')).data()[2]

            document.getElementById('cantidad_apartado_editar').value = parseInt(cantidad)
            document.getElementById('descripcion_apartado_editar').value = descripcion
            document.getElementById('precio_apartado_editar').value = parseInt(precio_unitario)
            console.log(precio_unitario);
            $('#id_apartado_editar').val(id)
            $('#modalEditarApartado').modal("show")
           
                
        });

        


        $(document).on("click", "#btn_editar_apartado", function(e) {
console.log(Table.row($('.editar-row[data-id="'+$('#id_apartado_editar').val() +'"] ')));
            $('#modalEditarApartado').modal("hide")
            Table.row($('.editar-row[data-id="'+$('#id_apartado_editar').val() +'"] ').parents('tr'))
                .remove()
                .draw();
                Table.row.add([document.getElementById('cantidad_apartado_editar').value,
                document.getElementById('descripcion_apartado_editar').value,
                document.getElementById('precio_apartado_editar').value,
                (document.getElementById('cantidad_apartado_editar').value * document.getElementById('precio_apartado_editar').value),
                buttons
            ]).draw();
return false;


})



        $('#order-listing').each(function() {

            var datatable = $(this);

            // SEARCH - Add the placeholder for Search and Turn this into in-line form control

            var search_input = datatable.closest('.dataTables_wrapper').find(

                'div[id$=_filter] input');

            search_input.attr('placeholder', 'Search');

            search_input.removeClass('form-control-sm');

            // LENGTH - Inline-Form control

            var length_sel = datatable.closest('.dataTables_wrapper').find(

                'div[id$=_length] select');

            length_sel.removeClass('form-control-sm');

        });

    });


})(jQuery);




     </script>

     <script type="text/javascript">
$(document).ready(function($) {

    $(document).on('click', '#btn-guardar-pdf', function(event) {
        event.preventDefault();


        //credit : https://ekoopmans.github.io/html2pdf.js

        var element = document.getElementById('presupuesto-pdf-container');

        //easy
        //html2pdf().from(element).save();

        //custom file name
        //html2pdf().set({filename: 'code_with_mark_'+js.AutoCode()+'.pdf'}).from(element).save();


        //more custom settings
        //more custom settings
        var opt = {
            margin: 0,

            image: {
                type: 'jpeg',
                quality: 0.98
            },
            filename: 'presupuesto.pdf',
            html2canvas: {
                scale: 3
            },
            jsPDF: {
                unit: 'in',
                format: 'letter',
                orientation: 'portrait'
            }
        };
        html2pdf().set(opt).from(element).toPdf().output('datauristring').save()

        /*
        .then(function(pdfBase64){
            
            const file = new File(
                    [pdfBase64],
                    "presupuesto.pdf",
                    {type: 'application/pdf'}
                ); 
                const formData = new FormData();        
                formData.append("file", file);

                $.ajax({
        					url : './crear_presupuesto',
        					type : "POST",
        					data : formData,
        					// both 'contentType' and 'processData' parameters are
        					// required so that all data are correctly transferred
        					contentType : false,
        					processData : false
        				}).done(function(response){
        					console.log(response);
        				})
                
               
               
               

        })
                // New Promise-based usage:
                
         */


    });



});
     </script>


     <script>
onload = function() {



    var inputCif = document.getElementById("input_cif")
    var inputDomicilio = document.getElementById("input_domicilio")
    var inputCP = document.getElementById("input_cp")
    var inputEmail = document.getElementById("input_email")
    var inputTelefono = document.getElementById("input_telefono")



    function updateSelects() {
        
        $("#input_fase").empty()
        $("#input_sector").empty()
        $("#input_obra").empty()


        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/obras.php",
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)
               // console.log(res);
                for (let r of res) {
                    //console.log(r)
                    if (r.id_cliente == $('#cliente_presupuesto').find(':selected').val()) {
                        /*
                                            $("#input_obra").append("<option value='" + r.id_obra + "'>" + r.nombre +
                                                "</option>")

                                            $("#input_obra").select2()*/
                        let newOption
                        newOption = new Option(r.nombre, r.id_obra, false, false);
                        $("#input_obra").append(newOption).trigger('change');

                    }
                }



            }

        })
        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/sectores.php",
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)
               // console.log(res);
                for (let r of res) {

                    if (r.id_cliente == $('#cliente_presupuesto').find(':selected').val()) {

                        let newOption
                        newOption = new Option(r.nombre, r.id_sector, false, false);
                        $("#input_sector").append(newOption).trigger('change');

                    }
                }



            }

        })
        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/fases.php",
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)
             //   console.log(res);
                for (let r of res) {

                    if (r.id_cliente == $('#cliente_presupuesto').find(':selected').val()) {

                        let newOption
                        newOption = new Option(r.nombre, r.id_fase, false, false);
                        $("#input_fase").append(newOption).trigger('change');

                    }
                }



            }

        })
    }
    
    updateSelects()

    function updateInputs(id) {
        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/clientes.php?client_id=" + id,
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)


                inputCif.value = res.cif;
                inputDomicilio.value = res.direccion;
                inputCP.value = res.cp;
                inputEmail.value = res.email;
                inputTelefono.value = res.telefono;
               

            }

        })
    }
    updateInputs($('#cliente_presupuesto').find(':selected').val())


    $('#btn-add-cliente').click(function() {


        $('#select-seleccionar-cliente').val($('#cliente_presupuesto').find(':selected').val());
        $('#select-seleccionar-cliente').trigger('change');

        $('#modalAgregarCliente').modal('show');


    })

    $('#cliente_presupuesto').change(function() {
        

        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/clientes.php?client_id=" + $(
                '#cliente_presupuesto').find(':selected').val(),
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)


                inputCif.value = res.cif;
                inputDomicilio.value = res.direccion;
                inputCP.value = res.cp;
                inputEmail.value = res.email;
                inputTelefono.value = res.telefono;


            }

        })


    })




    $('#select-seleccionar-cliente').on("change", function(e) {
        
        updateSelects();
        $('#cliente_presupuesto').val($('#select-seleccionar-cliente').val())
        $('#cliente_presupuesto').trigger('change');
        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/clientes.php?client_id=" + $(
                '#select-seleccionar-cliente').find(':selected').val(),
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)


                inputCif.value = res.cif;
                inputDomicilio.value = res.direccion;
                inputCP.value = res.cp;
                inputEmail.value = res.email;
                inputTelefono.value = res.telefono;

            }

        })


    })



    $('#btn-add-cliente2').click(function() {





        $('#modalAgregarCliente').modal('hide');






    })

}
     </script>


     <script>
(function($) {

    function updateSelectObra(selected = "none") {
        $("#input_obra").empty()

        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/obras.php",
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)

                for (let r of res) {
                    //console.log(r)
                    if (r.id_cliente == $('#cliente_presupuesto').find(':selected').val()) {
                        /*
                                            $("#input_obra").append("<option value='" + r.id_obra + "'>" + r.nombre +
                                                "</option>")

                                            $("#input_obra").select2()*/
                        let newOption
                        newOption = new Option(r.nombre, r.id_obra, false, false);
                        $("#input_obra").append(newOption).trigger('change');

                    }
                }
                if (selected != "none") {
                    $("#input_obra").val(res[res.length - 1].id_obra).trigger('change');
                }

            }

        })
    }

    function updateSelectSector(selected = "none") {

        $("#input_sector").empty()
        $.ajax({
            type: "GET",
            url: "https://kitdigital.billregulator.com/api/sectores.php",
            cache: false,
            success: function(response) {

                var res = JSON.parse(response)

                for (let r of res) {

                    if (r.id_cliente == $('#cliente_presupuesto').find(':selected').val()) {

                        let newOption
                        newOption = new Option(r.nombre, r.id_sector, false, false);
                        $("#input_sector").append(newOption).trigger('change');

                    }
                }

                if (selected != "none") {
                    $("#input_sector").val(res[res.length - 1].id_sector).trigger('change');
                }
            }

        })

    }
    function updateSelectFase(selected = "none") {

        $("#input_fase").empty()


$.ajax({
    type: "GET",
    url: "https://kitdigital.billregulator.com/api/fases.php",
    cache: false,
    success: function(response) {

        var res = JSON.parse(response)

        for (let r of res) {

            if (r.id_cliente == $('#cliente_presupuesto').find(':selected').val()) {

                let newOption
                newOption = new Option(r.nombre, r.id_fase, false, false);
                $("#input_fase").append(newOption).trigger('change');

            }
        }
        if (selected != "none") {
            $("#input_fase").val(res[res.length - 1].id_fase).trigger('change');
        }

    }

})
    }

    function updateSelects() {
        updateSelectObra()
updateSelectSector()
updateSelectFase()

    
    }





    $('#form-agregar-obra').submit(function(event) {
        // event.preventDefault();

        $('#cliente_obra_id').val($('#select-seleccionar-cliente').find(':selected').val())

        $.ajax({
            type: 'POST',
            url: './crear_presupuesto',
            data: $(this).serialize(),
            cache: false,
            success: function(result) {

                $('#modalAgregarObra').modal('hide');
                $.toast({
                    heading: 'Obra del cliente ' + $('#select-seleccionar-cliente')
                        .find(':selected').text() + ' agregada.',
                    text: 'Se ha agregado la obra correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                updateSelectObra(1)
            }
        });

        return false;
    });

    $('#form-agregar-sector').submit(function(event) {
        event.preventDefault();

        $('#cliente_sector_id').val($('#select-seleccionar-cliente').find(':selected').val())

        $.ajax({
            type: 'POST',
            url: './crear_presupuesto',
            data: $(this).serialize(),
            cache: false,
            success: function(result) {

                $('#modalAgregarSector').modal('hide');
                $.toast({
                    heading: 'Sector del cliente ' + $('#select-seleccionar-cliente')
                        .find(':selected').text() + ' agregado.',
                    text: 'Se ha agregado el sector correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                updateSelectSector(1)
            }
        });

        return false;
    });

    $('#form-agregar-fase').submit(function(event) {
        event.preventDefault();

        $('#cliente_fase_id').val($('#select-seleccionar-cliente').find(':selected').val())

        $.ajax({
            type: 'POST',
            url: './crear_presupuesto',
            data: $(this).serialize(),
            cache: false,
            success: function(result) {

                $('#modalAgregarFase').modal('hide');
                $.toast({
                    heading: 'Fase del cliente ' + $('#select-seleccionar-cliente')
                        .find(':selected').text() + ' agregado.',
                    text: 'Se ha agregado la fase correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                updateSelectFase(1)

            }
        });

        return false;
    });
    $(document).on("click", "#btn_eliminar_obra", function(e) {



        $("#id_obra_eliminar").val($("#input_obra").val())
        $("#id_obra_eliminar").data('name',$("#input_obra").find(':selected').text())
        
        console.log();
        $("#modalEliminarObra").modal('show');

        return false;


    })
    $(document).on("click", "#btn_eliminar_sector", function(e) {



$("#id_sector_eliminar").val($("#input_sector").val())
$("#id_sector_eliminar").data('name',$("#input_sector").find(':selected').text())
$("#modalEliminarSector").modal('show');

return false;


})
$(document).on("click", "#btn_eliminar_fase", function(e) {



$("#id_fase_eliminar").val($("#input_fase").val())
$("#id_fase_eliminar").data('name',$("#input_fase").find(':selected').text())
$("#modalEliminarFase").modal('show');

return false;


})
    $('#form_eliminar_obra').submit(function(event) {
        event.preventDefault();
console.log(event.target);


        $.ajax({
            type: 'POST',
            url: './crear_presupuesto',
            data: $(this).serialize(),
            cache: false,
            success: function(result) {
                console.log(result);
                $('#modalEliminarObra').modal('hide');
                $.toast({
                    heading: 'Obra '+$("#id_obra_eliminar").data('name')+' eliminada',
                    text: 'Se ha eliminado la obra '+$("#id_obra_eliminar").data('name')+' correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                updateSelectObra()

            }
        });

        return false;
    });
    $('#form_eliminar_sector').submit(function(event) {
        event.preventDefault();



        $.ajax({
            type: 'POST',
            url: './crear_presupuesto',
            data: $(this).serialize(),
            cache: false,
            success: function(result) {
                console.log(result);
                $('#modalEliminarSector').modal('hide');
                $.toast({
                    heading: 'Sector '+$("#id_sector_eliminar").data('name')+' eliminado',
                    text: 'Se ha eliminado el sector '+$("#id_sector_eliminar").data('name')+' correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                updateSelectSector()

            }
        });

        return false;
    });
    $('#form_eliminar_fase').submit(function(event) {
        event.preventDefault();



        $.ajax({
            type: 'POST',
            url: './crear_presupuesto',
            data: $(this).serialize(),
            cache: false,
            success: function(result) {
                console.log(result);
                $('#modalEliminarFase').modal('hide');
                $.toast({
                    heading: 'Fase '+$("#id_fase_eliminar").data('name')+' eliminada',
                    text: 'Se ha eliminado la fase '+$("#id_fase_eliminar").data('name')+' correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                updateSelectFase()

            }
        });

        return false;
    });

    $(document).on("click", "#btn_eliminar_cliente", function(e) {



$("#id_cliente_eliminar").val($('#cliente_presupuesto').find(':selected').val())

$("#modalEliminarCliente").modal('show');

return false;


})

    $('#form_eliminar_cliente').submit(function(event) {
        event.preventDefault();

        $("#btn_eliminar_cliente_2").addClass('btn-loading');

        $.ajax({
            type: 'POST',
            url: './crear_presupuesto',
            data: $(this).serialize(),
            cache: false,
            success: function(result) {
                console.log(result);
               
                $.toast({
                    heading: 'Cliente '+$("#cliente_presupuesto").find(':selected').text()+' eliminado',
                    text: 'Se ha eliminado el cliente '+$("#cliente_presupuesto").find(':selected').text()+' correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                setTimeout(function() {

                    $("#btn_eliminar_cliente_2").removeClass('btn-loading');
                    $('#modalEliminarCliente').modal('hide');

                        window.location.reload();
                    }, 2000);

            }
        });

        return false;
    });






    $("#btn_agregar_cliente_nuevo").on("click", function() {
            $.ajax({
                url: "./api/clientes.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                success: function(clientes) {
                    let repetido = false;
                    for (let c of clientes) {
                        if (c.email == $("#email_cliente_agregar").val()) {
                            repetido = true;
                        }
                    }

                    if (!repetido) {
                        $("#form-agregar-cliente-nuevo").submit()
                    } else {
                        $("#btn_agregar_cliente_nuevo").removeClass('btn-loading');
                        $.toast({
                            heading: 'Cuenta de correo electrónico existente',
                            text: 'La cuenta de correo electrónico que has ingresado ya corresponde a un cliente existente',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                    }
                }
            })
        });






    $("#form-agregar-cliente-nuevo").submit(function(event) {
event.preventDefault();
$("#btn_agregar_cliente_nuevo").addClass('btn-loading');


$.ajax({
    type: 'POST',
    url: './crear_presupuesto',
    data: $(this).serialize(),
    success: function(result) {
       console.log(result);
    
        $.toast({
            heading: 'Potencial cliente agregado',
            text: 'Se ha agregado el cliente correctamente',
            position: 'top-right',
            loaderBg: '#32a852',
            icon: 'success',
            hideAfter: 2000,
            stack: 6
        });
        setTimeout(function() {
            $("#btn_agregar_cliente_nuevo").removeClass('btn-loading');
            $('#modalAgregarClienteNuevo').modal('hide');
            window.location.reload();
        }, 2000);
       
    }
});

return false;
});


    
})(jQuery);
     </script>