<style>
td.long_text span {
    max-width: 250px !important;
    overflow: hidden !important;
    word-wrap: break-word !important;
    display: -webkit-box !important;
    -webkit-line-clamp: 14 !important;
    -webkit-box-orient: vertical !important;
    white-space: pre-wrap !important;
}
</style>


<div class="content-wrapper">

    <div class="row profile-page ">
        <div class="col-md-12 mb-8">
            <div class="card satmar-bottom">
                <div class="sato-border-blue">

                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/aupbspxw.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>
                        <p class="mb-2">Docentes</p>
                        <span id="docentes_count"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row ">
        <div class="col-12">
            <div class="card p-4">
                <div class="row">
                    <div class="col-12">
                        <button data-toggle="modal" data-target="#modalAgregarDocente"
                            class="btn btn-sm btn-primary">Agregar</button>
                    </div>
                </div>

            </div>

        </div>



        <!-- Historial de Acceso -->
        <div class="col-md-12">
            <div class="card card-cuenta">


                <div class="card-body card-table-body p-3 p-sm-4">

                    <table id="tabla_docentes" style="min-height:120px;" cellspacing="0"
                        class="tabla_docentes table display nowrap">
                        <thead>
                            <tr>
                                <th style="padding-left: 32px !important;padding-right: 50px !important;">
                                    ID</th>
                                <th>Nombre</th>
                                <th>DNI</th>
                                <th>Email</th>
                                <th>Fecha de alta</th>
                                <th>Fecha de baja</th>

                                <th style="text-align:center;">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
        <!-- /Historial de Acceso -->
        <!-- Eliminación de cuenta -->

        <!-- /Eliminación de cuenta -->
    </div>
</div>


<div class="modal fade modal-cambiar" id="modalAgregarDocente" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar docente</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>
                            <input id="nombre_docente" class="form-control" type="text" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">DNI</label>
                            <input id="dni_docente" class="form-control" type="text" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Email</label>
                            <input id="email_docente" class="form-control" type="text" name="">
                        </div>

                        <div class="form-group">
                            <label for="my-input">Fecha de alta</label>
                            <input id="fecha_alta_docente" class="form-control" type="date" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Fecha de baja</label>
                            <input id="fecha_baja_docente" class="form-control" type="date" name="">
                        </div>
                    </div>
                </div>









            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">



                <button id="btn_agregar_docente" class="btn btn-success btn-fw" type="button" name="">
                    Agregar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalEditarDocente" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar docente</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>
                            <input id="nombre_docente_editar" class="form-control" type="text" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">DNI</label>
                            <input id="dni_docente_editar" class="form-control" type="text" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Email</label>
                            <input id="email_docente_editar" class="form-control" type="text" name="">
                        </div>

                        <div class="form-group">
                            <label for="my-input">Fecha de alta</label>
                            <input id="fecha_alta_docente_editar" class="form-control" type="date" name="">
                        </div>
                        <div class="form-group">
                            <label for="my-input">Fecha de baja</label>
                            <input id="fecha_baja_docente_editar" class="form-control" type="date" name="">
                        </div>
                    </div>
                </div>







            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">



                <button id="btn_editar_docente" class="btn btn-success btn-fw" type="button" name="">
                    Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar</button>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal modal-cambiar fade" id="modalEliminarDocente" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar docente</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el docente definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div style="margin-top:15px;" class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_docente" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<!-- MODALS -->
<div class="modal fade" id="modalSubirArchivo" role="dialog">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Archivos</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-4">
                <div class="row">
                    <div class="col-12 col-md-6">
                        <div class="form-group">
                            <label for="my-input">Nombre</label>

                            <input id="nombre_archivo" type="text" class="form-control">

                        </div>

                    </div>
                    <div class="col-12 col-md-6">
                        <div class="form-group">
                            <label for="my-input">Archivo</label>
                            <div class="input-group">
                                <input type="file" class="d-none" id="archivo_file" accept=".png, .jpg, .pdf">
                                <input disabled id="archivo_archivo" type="text" class="form-control"
                                    value="Ningún archivo seleccionado.">
                                <div class="input-group-append">
                                    <label for="archivo_file" class="mb-0 btn btn-success btn-fw" id="btn_subir_archivo"
                                        type="button">

                                        Seleccionar archivo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 text-left mb-2">
                        <button class="btn btn-success btn-fw" id="btn_add_archivo" type="button"">Subir</button>
                    </div>
                </div>

                <div class=" container-lg p-0">
                            <div id="lista_archivos" class="row">

                            </div>





                    </div>



                </div>





                <!-- /modal-body -->

            </div>

        </div>

    </div>
</div>
<div class="modal fade modal-cambiar" id="modalVerArchivo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div id="contenedor_archivo" class="modal-body pb-4">
                <!-- btn -->






            </div>

            <!-- /btn -->


            <!-- /modal-body -->
        </div>
    </div>
</div>
<style>
.archivo_lista {
    cursor: pointer;
    transition: all .3s ease;
    position: relative;
    height: 100%;
    width: 100%;
    background: #0000001a;
    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
    aspect-ratio: 1/1;
    border-radius: 2% !important;
}

.archivo_lista img {
    object-fit: cover;
    max-height: 200px;
}

.archivo_lista:hover {
    opacity: .5;
    background: #000000;
}

.btn_eliminar_archivo {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    right: 0;
    top: 0;
    border-radius: 10% !important;
}

.archivo_lista:hover .btn_eliminar_archivo {
    opacity: 1;
}

.btn_eliminar_archivo i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #F1635F;
}

.btn_eliminar_archivo:hover i:before {
    color: #F1635F;
}

.btn_seleccionar_archivo {
    cursor: pointer;
    transition: all .3s ease;
    opacity: 0;
    position: absolute;
    left: 0;
    top: 0;
    border-radius: 10% !important;
}

.archivo_lista:hover .btn_seleccionar_archivo {
    opacity: 1;
}

.btn_seleccionar_archivo i:before {
    transition: all .3s ease;
    font-size: 1.1rem;
    color: #0cca8e;
}

.btn_seleccionar_archivo:hover i:before {
    color: #0cca8e;
}

.nombre_archivo_div {
    position: absolute;
    font-size: 18px;
    border-radius: 4px;
    transition: all .3s ease;
    opacity: 0;
    color: white;
    background-color: black;
    padding: .5rem;
    cursor: pointer;
}

.col-sm-3:hover .nombre_archivo_div {
    opacity: 1;
}

#lista_archivos {
    max-height: 723px;
    overflow-y: scroll;
}
</style>




<?php require_once __VIEWS__ . 'selects/sectores.template.php'; ?>
<script>
function handleInvalidInput(input) {

    input.value = ""
    $.toast({
        heading: 'Por favor ingresa un monto válido.',
        text: 'El monto debe ser un número decimal mayor que 0.',
        position: 'top-right',
        loaderBg: '#ff5c6c',
        icon: 'error',
        hideAfter: 5000,
        stack: 6
    });
    input.focus()



}
</script>

<script>
(function($) {

    'use strict';

    $(function() {

        var Table = $('#tabla_docentes').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en usuarios",
                infoEmpty: "Mostrando 0 a 0 de 0 en usuarios",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/docentes.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                dataSrc: function(json) {
                    var data = json
                    $("#docentes_count").text(data.length)
                    console.log(data);
                    return data;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {

            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_docente",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "nombre"
                },
                {
                    "data": "dni"
                },
                {
                    "data": "email"
                },
                {
                    "data": "fecha_alta"
                },
                {
                    "data": "fecha_baja"
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var buttonAnexo = document.createElement('button');
                        buttonAnexo.className = 'btn_descargar_anexo p-1 dropdown-item';
                        buttonAnexo.setAttribute('type', 'button');
                        buttonAnexo.setAttribute('data-id', data.id_docente);

                        buttonAnexo.innerHTML = `
                    <lord-icon src="./assets/lordicons/download.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Descargar anexo
                    
                `;
                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_editar_docente p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data.id_docente);
                        buttonEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;
                        var buttonFotos = document.createElement('button');
                        buttonFotos.className = 'btn_modal_archivos p-1 dropdown-item';
                        buttonFotos.setAttribute('type', 'button');
                        buttonFotos.setAttribute('data-id', data.id_docente);
                        buttonFotos.innerHTML = `
                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Archivos
                    
                `;
                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_docente p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data.id_docente);
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;

                        dropdownMenu.appendChild(buttonFotos);
                        dropdownMenu.appendChild(buttonAnexo);
                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        });





        $("#btn_agregar_docente").click(function() {

            var nombre = $("#nombre_docente").val()
            var dni = $("#dni_docente").val()
            var email = $("#email_docente").val()
            var fecha_alta = moment($('#fecha_alta_docente').val()).format('YYYY-MM-DD')
            var fecha_baja = moment($('#fecha_baja_docente').val()).format('YYYY-MM-DD')
            if (nombre == "") {
                $.toast({
                    heading: 'Por favor ingresa un nombre.',
                    text: 'No se ha ingresado ningun nombre al docente.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#nombre").focus()
                return false;
            }
            if (fecha_alta == "Invalid date" || fecha_baja == "Invalid date") {
                $.toast({
                    heading: 'Por favor ingresa las fechas.',
                    text: 'No se ha ingresado ninguna fecha al docente.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $
                return false;
            }
            $("#btn_agregar_docente").attr("disabled", true);
            $("#btn_agregar_docente").addClass("btn-loading");


            $.ajax({
                type: 'POST',
                url: './api/docentes.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre,
                    dni: dni,
                    email: email,
                    fecha_alta: fecha_alta,
                    fecha_baja: fecha_baja
                },
                success: function(r) {
                    console.log(r);
                    $.toast({
                        heading: 'Docente creado',
                        text: 'Se ha creado el docente correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                    Table.ajax.reload(null, false);
                    $("#btn_agregar_docente").attr("disabled", false);
                    $("#btn_agregar_docente").removeClass("btn-loading");
                    $("#modalAgregarDocente").modal("hide")
                }

            });
        })
        $("#btn_editar_docente").click(function() {

            var nombre = $("#nombre_docente_editar").val()
            var dni = $("#dni_docente_editar").val()
            var email = $("#email_docente_editar").val()
            var fecha_alta = moment($('#fecha_alta_docente_editar').val()).format(
                'YYYY-MM-DD HH:mm:ss')
            var fecha_baja = moment($('#fecha_baja_docente_editar').val()).format(
                'YYYY-MM-DD HH:mm:ss')
            var id_docente = $("#btn_editar_docente").data("id")
            if (nombre == "") {
                $.toast({
                    heading: 'Por favor ingresa un nombre.',
                    text: 'No se ha ingresado ningun nombre al docente.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#nombre_editar").focus()
                return false;
            }

            $("#btn_editar_docente").attr("disabled", true);
            $("#btn_editar_docente").addClass("btn-loading");



            $.ajax({
                type: 'POST',
                url: './api/docentes.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre,
                    dni: dni,
                    email: email,
                    fecha_alta: fecha_alta,
                    fecha_baja: fecha_baja,
                    id_docente: id_docente
                },
                success: function(r) {
                    console.log(r);
                    $.toast({
                        heading: 'Docente editado',
                        text: 'Se ha editado el docente correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                    Table.ajax.reload(null, false);
                    $("#btn_editar_docente").attr("disabled", false);
                    $("#btn_editar_docente").removeClass("btn-loading");
                    $("#modalEditarDocente").modal("hide")
                }

            });
        })

        $(document).on("click", ".btn_editar_docente", function(event) {
            var id = $(this).data("id")
            $("#btn_editar_docente").data("id", id);

            $.ajax({
                url: './api/docentes.php?id_docente=' + id,
                type: 'GET',
                async: false,
                cache: false,
                dataType: 'json', // added data type
                success: function(result) {
                    console.log(result);







                    $("#nombre_docente_editar").val(result.nombre)
                    $("#dni_docente_editar").val(result.dni)
                    $("#email_docente_editar").val(result.email)
                    $("#fecha_alta_docente_editar").val(result.fecha_alta)
                    $("#fecha_baja_docente_editar").val(result.fecha_baja)
                    $('#modalEditarDocente').modal('show')
                }
            });



        })


        $(document).on("click", ".btn_eliminar_docente", function(event) {
            var id = $(this).data("id")
            $("#btn_eliminar_docente").data("id", id);
            $("#modalEliminarDocente").modal("show")
        })

        $('#btn_eliminar_docente').click(function(event) {

            var id_docente_eliminar = $("#btn_eliminar_docente").data("id")


            $.ajax({
                type: 'DELETE',
                url: './api/docentes.php?id=' + id_docente_eliminar,
                async: false,
                cache: false,
                success: function(result) {


                    $.toast({
                        heading: 'Docente eliminado',
                        text: 'Se ha eliminado el docente correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })


                    $('#modalEliminarDocente').modal('hide');

                    Table.ajax.reload(null, false);


                }
            });

            return false;
        });
    });

})(jQuery);
</script>


<script>
$("#archivo_file").change(function(e) {
    var archivo = $('#archivo_file')[0].files[0];

    $("#archivo_archivo").val(archivo.name)

});
$("#btn_add_archivo").click(function() {

    var archivo = $('#archivo_file')[0].files[0];
    var id_alumno = $('#btn_subir_archivo').data("id")

    var nombre = $("#nombre_archivo").val();
    if (!archivo) {
        $.toast({
            heading: 'Ningún archivo seleccionado.',
            text: 'Por favor, selecciona un archivo para subir.',
            position: 'top-right',
            loaderBg: '#ff5c6c',
            icon: 'error',
            hideAfter: 5000,
            stack: 6
        });
        return false
    }

    if (nombre == "") {
        $.toast({
            heading: 'Ningún nombre seleccionado.',
            text: 'Por favor, agrega un nombre al archivo para subir.',
            position: 'top-right',
            loaderBg: '#ff5c6c',
            icon: 'error',
            hideAfter: 5000,
            stack: 6
        });
        return false
    }
    var extension = archivo.type.split('/').pop();
    if (extension == "jpeg") {
        extension = "jpg"
    }

    if (archivo.size > 3000000) {
        $.toast({
            heading: 'Archivo demasiado pesado.',
            text: 'El archivo debe pesar menos 3 MB.',
            position: 'top-right',
            loaderBg: '#ff5c6c',
            icon: 'error',
            hideAfter: 5000,
            stack: 6
        });
        return false
    }
    var fd = new FormData();
    fd.append('archivo', archivo);
    fd.append('extension', extension);
    fd.append('nombre', nombre);
    fd.append('id_docente_archivo', id_alumno);

    var contenedor = document.getElementById('lista_archivos');
    var divElement = document.createElement('div');
    divElement.classList.add('col-sm-3', 'p-2', 'd-flex',
        'justify-content-center', 'align-items-center');

    // Crear un elemento div para la clase "archivo_lista"
    var archivoListaDiv = document.createElement('div');
    archivoListaDiv.classList.add('archivo_lista', 'd-flex',
        'justify-content-center', 'align-items-center');

    var imgElement = document.createElement('img');
    imgElement.classList.add('img-fluid');
    imgElement.setAttribute('alt', '');
    imgElement.setAttribute('src', './assets/images/oval.svg');
    // Agregar elementos al div "archivo_lista"
    archivoListaDiv.appendChild(imgElement);

    divElement.appendChild(archivoListaDiv);
    // Agregar el div "archivo_lista" al div principal

    contenedor.insertAdjacentElement('afterbegin', divElement);


    $.ajax({
        url: './api/docentes.php',
        type: 'POST',
        data: fd,
        async: false,
        cache: false,
        processData: false, // tell jQuery not to process the data
        contentType: false, // tell jQuery not to set contentType
        success: function(result) {
            console.log(result);
            if (result == "0") {
                $.toast({
                    heading: 'Nombre repetido.',
                    text: 'Selecciona otro nombre para el archivo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                divElement.remove()
                return false
            } else

            {

                CargarArchivos(id_alumno)
                $.toast({
                    heading: 'Nuevo archivo subido.',
                    text: 'Se subido el nuevo archivo correctamente.',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 4
                })
            }
        }
    });

});

function CargarArchivos(id_alumno) {
    var contenedor = document.getElementById('lista_archivos');
    contenedor.innerHTML = ""
    $.ajax({
        url: './api/docentes.php?id_docente_archivos=' + id_alumno,
        type: 'GET',
        cache: false,
        async: false,
        dataType: 'json', // added data type
        success: function(result) {
            console.log(result);
            for (let r of result) {
                r.url = r.url.slice(1)
                console.log(r);
                var divElement = document.createElement('div');
                divElement.classList.add('col-sm-3', 'p-2', 'd-flex',
                    'justify-content-center', 'align-items-center');

                // Crear un elemento div para la clase "archivo_lista"
                var archivoListaDiv = document.createElement('div');
                archivoListaDiv.classList.add('archivo_lista', 'd-flex',
                    'justify-content-center', 'align-items-center');

                if (r.extension != "pdf") {
                    // Crear un elemento img
                    var imgElement = document.createElement('img');
                    imgElement.classList.add('img-fluid');
                    imgElement.setAttribute('alt', '');
                    imgElement.setAttribute('src', r.url);
                } else {
                    var iframe = document.createElement('iframe');

                    iframe.setAttribute('src', r.url);
                    iframe.style.width = "100%";
                    iframe.style.height = "100%";

                }


                // Crear un botón para eliminar
                var btnEliminar = document.createElement('button');
                btnEliminar.classList.add('p-1', 'btn_eliminar_archivo', 'btn');
                btnEliminar.setAttribute('data-url', r.url);
                btnEliminar.setAttribute('data-id', id_alumno);
                btnEliminar.setAttribute('type', 'button');
                btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';

                // Crear un botón para seleccionar
                var btnSeleccionar = document.createElement('button');
                btnSeleccionar.classList.add('p-1', 'btn_seleccionar_archivo',
                    'btn');
                btnSeleccionar.setAttribute('data-url', r.url);
                btnSeleccionar.setAttribute('data-extension', r.extension);
                btnSeleccionar.setAttribute('type', 'button');
                btnSeleccionar.innerHTML = '<i class="m-0 fa fa-eye"></i>';




                var nombre = document.createElement('a');
                nombre.textContent = r.nombre
                nombre.setAttribute('data-nombre', r.nombre);
                nombre.setAttribute('data-url', r.url);
                nombre.setAttribute('data-extension', r.extension);
                nombre.classList.add("nombre_archivo_div")
                nombre.innerHTML += '<i class="ml-2 fa fa-download"></i>';
                // Agregar elementos al div "archivo_lista"
                if (r.extension != "pdf") {
                    // Crear un elemento img
                    archivoListaDiv.appendChild(imgElement);

                } else {
                    archivoListaDiv.appendChild(iframe);

                }
                archivoListaDiv.appendChild(btnEliminar);
                archivoListaDiv.appendChild(btnSeleccionar);

                // Agregar el div "archivo_lista" al div principal
                divElement.appendChild(archivoListaDiv);

                divElement.appendChild(nombre);
                contenedor.appendChild(divElement);

            }
        }
    })

}
$(document).on("click", ".btn_modal_archivos", function() {


    $('#btn_subir_archivo').data("id", $(this).data("id"))
    CargarArchivos($(this).data("id"))

    $("#modalSubirArchivo").modal("show");
});

$(document).on("click", ".btn_seleccionar_archivo", function() {
    var url = $(this).data("url");
    var extension = $(this).data("extension");
    var div = document.getElementById("contenedor_archivo")
    div.innerHTML = ""
    if (extension !== "pdf") {
        // Crear un elemento <img>


        var imgElement = document.createElement("img");

        // Establecer los atributos del elemento <img>
        imgElement.id = "archivo_modal";
        imgElement.className = "w-100 img-fluid";
        imgElement.src = url; // Aquí establece la fuente de la imagen que desees
        imgElement.alt = "";

        // Agregar el elemento <img> al documento
        div.appendChild(imgElement);
    } else {
        var iframe = document.createElement('iframe');
        iframe.setAttribute('id', 'archivo_modal');
        iframe.setAttribute('src', url);
        iframe.style.width = "100%"
        iframe.style.height = "400px"
        div.appendChild(iframe);
    }



    $("#modalVerArchivo").modal("show");


});
$(document).on("click", ".nombre_archivo_div", function() {
    var nombre = $(this).data("nombre");
    var url = $(this).data("url");
    var extension = $(this).data("extension");

    $(this).attr("download", nombre)
    $(this).attr("href", url)
});
$(document).on("click", ".btn_eliminar_archivo", function() {
    var id = $(this).data("id");
    var url = $(this).data("url");


    $.ajax({
        type: "DELETE",
        url: "./api/docentes.php?url=" + url,
        cache: false,
        async: false,
        success: function(response) {
            console.log(response);
            CargarArchivos(id)
            $.toast({
                heading: 'Archivo eliminado.',
                text: 'Se eliminado el archivo correctamente.',
                position: 'top-right',
                loaderBg: '#32a852',
                icon: 'success',
                hideAfter: 2000,
                stack: 4
            })
        }

    })
});
</script>