<style>
.subvenciones_list ul {
    list-style: none;
}
</style>

<div class="content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-3 px-xl-0">
                <div class="card p-3 p-sm-4 mb-3 mb-sm-4 subvenciones_list">
                    <h4 class="text-center title mb-4">Subvenciones</h4>

                    <ul id="lista_subvenciones" class="p-0 mb-3">
                        <?php
                    foreach($Subvenciones_List as $Subvencion){
                    ?>
                        <li>
                            <div class="">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input subvencion"
                                        data-id=<?php echo htmlentities($Subvencion['id_subvencion'], ENT_QUOTES)?>>
                                    <span
                                        class="custom-control-label"><?php echo htmlentities($Subvencion['titulo'], ENT_QUOTES);?></span>
                                </label>
                            </div>

                        </li>
                        <?php
                    }
                    ?>

                    </ul>
                    <a href="./subvenciones?crear=1" class="btn btn-sm btn-outline-primary">Agregar subvención</a>
                </div>
                <div class="card p-4 mb-3 mb-sm-4">
                    <p class="text-center title mb-4">Condiciones disponibles</p>

                    <ul class="p-0">

                        <?php
                    
                    foreach ($Condiciones_List as $Condicion) {
                            ?>

                        <li class=" mb-2 d-flex flex-row justify-content-between align-items-center">
                            <p class="mb-0"><?php echo htmlentities($Condicion['titulo'], ENT_QUOTES); ?></p>
                            <button data-condicion='<?php echo htmlentities($Condicion['condicion'], ENT_QUOTES); ?>'
                                class="btn_add_condicion btn btn-sm btn-success">+</button>
                        </li>
                        <?php }?>
                    </ul>

                </div>


            </div>
            <div class="col-xl-9 pl-xl-4 pr-xl-0">
                <div class="card p-3 p-sm-4 subvenciones_list">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Cliente</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_cliente">-</button>
                                    </span>
                                    <select id="cliente_subvencion"
                                        class="form-control custom-select text-center select2" required>

                                        <?php                  
                                                foreach ($Clientes_List as $Cliente) {                                                   
                                                ?>
                                        <option type="number"
                                            value=<?php echo htmlentities($Cliente['client_id'], ENT_QUOTES)?>>
                                            <?php echo htmlentities($Cliente['nombre'], ENT_QUOTES)?></option>

                                        <?php }?>


                                    </select>
                                    <span class="input-group-append">
                                        <button id="btn-add-cliente" data-toggle="modal"
                                            data-target="#modalAgregarClienteSubvencion"
                                            class="file-upload-browse btn btn-info" type="button">+</button>
                                    </span>
                                </div>
                            </div>

                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_subvencion">Título</label>
                                <input id="titulo_subvencion" class="form-control" type="text" name="">
                            </div>
                        </div>

                        <div class="col-12">
                            <label class="mb-4">Imágen de cabecera</label>
                        </div>

                        <div class="col-sm-4 mb-4 mb-sm-0">
                            <img id="img_logo_portada" class="w-100"
                                src=<?php echo WEBSITE_URL . "image.php?id=BEzwaVhMLsEYFSpFeIjHpOoJ7";?> alt="">
                        </div>
                        <div class="col-sm-8">
                            <form id="form_editar_logo" method="POST" enctype="multipart/form-data">
                                <div class="input-group mb-4">

                                    <input id="input_mostrar_logo" type="text" class="form-control" placeholder=""
                                        aria-label=""
                                        value=<?php echo WEBSITE_URL . "image.php?id=BEzwaVhMLsEYFSpFeIjHpOoJ7";?>
                                        disabled="">
                                    <input type="file" class="d-none" id="logo_portada" name="logo_portada">
                                    <div class="input-group-append">
                                        <label for="logo_portada" class="btn btn-success"
                                            type="button">Seleccionar</label>
                                    </div>
                                </div>
                            </form>

                            <p class="mb-0">Las medidas recomendadas:512px x 68px</p>

                        </div>

                        <div class="col-12 my-4">
                            <div class="form-group">
                                <label for="mymce">Email</label>
                                <textarea class="h-100 mb-4" id="mymce"></textarea>
                            </div>
                        </div>
                        <div class="col-12 mb-4">
                            <div class="form-group">
                                <label>Condiciones Generales</label>
                                <textarea class="form-control" type="text" class="form-control m-0"
                                    name="condiciones_presupuesto" id="condiciones_presupuesto" placeholder=""
                                    required></textarea>
                            </div>
                        </div>
                        <div class="col-12 mb-4 text-right">

                            <button type="button" id="button_agregar" class="btn btn-sm btn-primary">Agregar</button>
                        </div>
                        <div class="col-12 mb-4">
                            <div class="table-responsive">
                                <table id="order-listing2" cellspacing="0" class="w-100 table display nowrap">
                                    <thead>
                                        <tr>

                                            <th>Cliente</th>
                                            <th>Subvención</th>
                                            <th>Correo</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="col-12 text-right">
                            <input type="hidden" id="id_subvencion">
                            <button type="button" id="button_guardar" class="btn btn-sm btn-success">Guardar</button>
                            <button type="button" id="button_enviar" class="btn btn-sm btn-success">Guardar
                                y enviar</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>
<div class="modal fade" id="modalVerSubvencion" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width:600px!important;" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Subvencion a enviar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pt-0 pb-4">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <div class="" id="pdf_subvencion" style="">
                                <div
                                    style="background-color:white; padding:1rem;max-width: 500px; min-width:360px; width:100%;margin: 0 auto;">
                                    <img id="img_portada_mail"
                                        style="width:100%; margin-left: auto; margin-right: auto; margin-bottom:.5rem"
                                        src="" alt="">

                                    <div>
                                        <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Nombre
                                            comercial: <span id="nombre_cliente_pdf"></span></p>
                                        <p style="color:black;font-family: Poppins; margin-bottom:.5rem">CIF: <span
                                                id="cif_cliente_pdf"></span></p>
                                        <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Domicilio:
                                            <span id="domicilio_cliente_pdf"></span>
                                        </p>
                                        <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Tipo: <span
                                                id="tipo_cliente_pdf"></span>
                                        </p>
                                        <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Número de
                                            empleados: <span id="empleados_pdf"></span></p>
                                        <p style="color:black;font-family: Poppins; margin-bottom:.5rem">CP: <span
                                                id="cp_cliente_pdf"></span></p>
                                        <p id="fase_pdf" style="color:black;font-family: Poppins; margin-bottom:.5rem">
                                            Fase: <span id="fase_cliente_pdf"></span></p>
                                        <p id="sector_pdf"
                                            style="color:black;font-family: Poppins; margin-bottom:.5rem">Sector: <span
                                                id="sector_cliente_pdf"></span></p>
                                        <p id="zona_pdf" style="color:black;font-family: Poppins; margin-bottom:.5rem">
                                            Zona: <span id="zona_cliente_pdf"></span></p>

                                        <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Importe: <span
                                                id="importe_pdf"></span>
                                        </p>

                                    </div>


                                    <h2 style="color:black;font-family: Poppins; text-align: center; margin-bottom:.5rem"
                                        id="titulo_subvencion_pdf">
                                        Titulo</h2>

                                    <div style="color:black;font-family: Poppins; margin-bottom:1.5rem"
                                        id="descripcion_subvencion_pdf">
                                        Descripcion
                                    </div>
                                    <ul
                                        style="list-style: none;margin: 0px;margin-bottom:1rem;padding: 1rem; text-align: center;">

                                        <li style="padding: .5rem;display: inline;" class="redes-soci">
                                            <a style="font-family: Poppins;"
                                                href="<?php echo htmlentities($personalizacion['url_facebook'], ENT_QUOTES);?>"
                                                target="_blank" class="imgiconos"><img
                                                    src=<?php echo WEBSITE_URL ."/assets/mail/fb.png";?> alt=""
                                                    class="imgiconos"><span class="capa-traslucida"></span></a>
                                        </li>
                                        <li style="padding: .5rem;display: inline;" class="redes-soci">
                                            <a style="font-family: Poppins;"
                                                href="<?php echo htmlentities($personalizacion['url_linkedin'], ENT_QUOTES);?>"
                                                target="_blank" class="imgiconos"><img
                                                    src=<?php echo WEBSITE_URL ."assets/mail/lin.png";?> alt=""
                                                    class="imgiconos"><span class="capa-traslucida"></span></a>
                                        </li>
                                        <li style="padding: .5rem;display: inline;" class="redes-soci">
                                            <a style="font-family: Poppins;"
                                                href="<?php echo htmlentities($personalizacion['url_twitter'], ENT_QUOTES);?>"
                                                target="_blank" class="imgiconos"><img
                                                    src=<?php echo WEBSITE_URL ."assets/mail/tw.png";?> alt=""
                                                    class="imgiconos"><span class="capa-traslucida"></span></a>
                                        </li>
                                        <li style="padding: .5rem;display: inline;" class="redes-soci">
                                            <a style="font-family: Poppins;"
                                                href="<?php echo htmlentities($personalizacion['url_youtube'], ENT_QUOTES);?>"
                                                target="_blank" class="imgiconos"><img
                                                    src=<?php echo WEBSITE_URL ."assets/mail/you.png";?> alt=""
                                                    class="imgiconos"><span class="capa-traslucida"></span></a>
                                        </li>
                                    </ul>
                                    <div style="color:black;font-family: Poppins; margin-bottom:1.5rem"
                                        id="condiciones_pdf">
                                        Condiciones
                                    </div>

                                </div>


                            </div>
                        </div>

                    </div>

                </div>



            </div>





            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalEditarSubvencion" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="nb-0">Editar subvención a enviar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">


                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_subvencion_editar">Título</label>
                                <input id="titulo_subvencion_editar" class="form-control" type="text" name="">
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="mb-4">Imágen de cabecera</label>
                        </div>

                        <div class="col-sm-4 mb-4 mb-sm-0">
                            <img class="w-100 mb-0" id="img_logo_portada_editar" class="w-100"
                                src=<?php echo WEBSITE_URL . "image.php?id=BEzwaVhMLsEYFSpFeIjHpOoJ7";?> alt="">
                        </div>
                        <div class="col-sm-8">
                            <form id="form_editar" method="POST" enctype="multipart/form-data">
                                <div class="input-group mb-4">

                                    <input id="input_mostrar_logo_editar" type="text" class="form-control"
                                        placeholder="" aria-label=""
                                        value=<?php echo WEBSITE_URL . "image.php?id=BEzwaVhMLsEYFSpFeIjHpOoJ7";?>
                                        disabled="">
                                    <input type="file" class="d-none" id="logo_portada_editar"
                                        name="logo_portada_editar">
                                    <div class="input-group-append">
                                        <label for="logo_portada_editar" class="mb-0 btn btn-success"
                                            type="button">Seleccionar</label>
                                    </div>
                                </div>
                            </form>

                            <p class="mb-0">Las medidas recomendadas:512px x 68px</p>

                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Condiciones Generales</label>
                                <textarea class="form-control" type="text" class="form-control m-0"
                                    name="condiciones_presupuesto_editar" id="condiciones_presupuesto_editar"
                                    placeholder="" required></textarea>
                            </div>
                        </div>

                        <div class="col-12 mt-4">
                            <div class="form-group">
                                <label for="mymce_editar">Email</label>
                                <textarea class="h-100 mb-4" id="mymce_editar"></textarea>
                            </div>
                        </div>

                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nombre del cliente</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar">-</button>
                                    </span>
                                    <select id="select_cliente_editar"
                                        class="form-control custom-select text-center select2">

                                        <?php                  

                                                    foreach ($Clientes_List as $Cliente) {                                               
                                                        
                                                    ?>
                                        <option type="text"
                                            value=<?php echo htmlentities($Cliente['client_id'], ENT_QUOTES); ?>>
                                            <?php echo htmlentities($Cliente['nombre'], ENT_QUOTES); ?>
                                        </option>

                                        <?php
                                                    } 
                                                        
                                                ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarClienteNuevo">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>CIF</label>

                                <input type="text" class="form-control" id="input_cif_editar" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Domicilio</label>

                                <input type="dir" class="form-control" id="input_domicilio_editar" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>C.P</label>

                                <input type="number" class="form-control" id="input_cp_editar" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Teléfono</label>

                                <input type="tel" class="form-control" id="input_telefono_editar" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="mail" class="form-control" id="input_email_editar" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nombre comercial (Autónomo/SL) </label>

                                <input type="mail" class="form-control" id="input_nombre_editar" placeholder="">

                            </div>

                        </div>




                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Sector</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_sector_editar">-</button>
                                    </span>
                                    <select id="input_sector_editar" name="nombre_sector"
                                        class="form-control custom-select text-center select2">
                                        <?php

                                            foreach($Sectores as $Sector){
                                            ?>
                                        <option type="text"
                                            value="<?php echo htmlentities($Sector['id_sector'], ENT_QUOTES); ?>">
                                            <?php echo htmlentities($Sector['nombre'], ENT_QUOTES); ?>
                                        </option>
                                        <?php

                                            }
                                            ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarSector">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Tipo</label>

                                <select id="tipo_cliente_editar" name="tipo_cliente"
                                    class="form-control custom-select text-center">



                                    <option type="text" value="Particular" selected="selected">Particular</option>

                                    <option type="text" value="Empresa">Empresa</option>



                                </select>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nº de empleados </label>

                                <input type="mail" class="form-control" id="input_empleados_editar" placeholder=""
                                    value=0>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Fase</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_fase_editar">-</button>
                                    </span>
                                    <select id="input_fase_editar" name="input_fase"
                                        class="form-control custom-select text-center select2">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarFase">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Importe</label>

                                <input type="number" class="form-control" id="input_importe_editar" placeholder=""
                                    value=0>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Enlace a enviar</label>

                                <select id="tipo_enlace_editar" name="" class="form-control custom-select text-center">



                                    <option type="text" value="autonomo">Autónomo</option>

                                    <option type="text" value="sociedad">Sociedad</option>
                                    <option type="text" value="generico">Genérico</option>


                                </select>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Responsable</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            data-toggle="modal" data-target="#modalQuitarNombre">-</button>
                                    </span>
                                    <select name="input_usuario" id="input_usuario_editar"
                                        class="form-control custom-select text-center select2">
                                        <?php

                                                 foreach($User_List as $User){
                                                 ?>
                                        <option type="text"
                                            value="<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>">
                                            <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>
                                        </option>
                                        <?php

                                                  }
                                                    ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarNombre">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Zona</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_zona_editar">-</button>
                                    </span>
                                    <select id="input_zona_editar"
                                        class="form-control custom-select text-center select2">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarZona">+</button>
                                    </span>
                                </div>


                            </div>

                        </div>
                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">


                <input type="hidden" id="id_subvencion_editar">
                <input type="hidden" id="row_index">
                <button class="btn btn-success btn-fw" id="btn_editar_datos">

                    Editar</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalAgregarClienteSubvencion" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="nb-0">Agregar Cliente</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">


                    <div class="row">

                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nombre del cliente</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar">-</button>
                                    </span>
                                    <select id="select_cliente" class="form-control custom-select text-center select2">

                                        <?php                  

                                                    foreach ($Clientes_List as $Cliente) {                                               
                                                        
                                                    ?>
                                        <option type="text"
                                            value=<?php echo htmlentities($Cliente['client_id'], ENT_QUOTES); ?>>
                                            <?php echo htmlentities($Cliente['nombre'], ENT_QUOTES); ?>
                                        </option>

                                        <?php
                                                    } 
                                                        
                                                ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarClienteNuevo">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>CIF</label>

                                <input type="text" class="form-control" id="input_cif" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Domicilio</label>

                                <input type="dir" class="form-control" id="input_domicilio" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>C.P</label>

                                <input type="number" class="form-control" id="input_cp" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Teléfono</label>

                                <input type="tel" class="form-control" id="input_telefono" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="mail" class="form-control" id="input_email" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nombre comercial (Autónomo/SL) </label>

                                <input type="mail" class="form-control" id="input_nombre" placeholder="">

                            </div>

                        </div>




                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Sector</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_sector">-</button>
                                    </span>
                                    <select id="input_sector" name="nombre_sector"
                                        class="form-control custom-select text-center select2">
                                        <?php

                                            foreach($Sectores as $Sector){
                                            ?>
                                        <option type="text"
                                            value="<?php echo htmlentities($Sector['id_sector'], ENT_QUOTES); ?>">
                                            <?php echo htmlentities($Sector['nombre'], ENT_QUOTES); ?>
                                        </option>
                                        <?php

                                            }
                                            ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarSector">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Tipo</label>

                                <select id="tipo_cliente" name="tipo_cliente"
                                    class="form-control custom-select text-center">



                                    <option type="text" value="Particular" selected="selected">Particular</option>

                                    <option type="text" value="Empresa">Empresa</option>



                                </select>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nº de empleados </label>

                                <input type="mail" class="form-control" id="input_empleados" placeholder="" value=0>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Fase</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_fase">-</button>
                                    </span>
                                    <select id="input_fase" name="input_fase"
                                        class="form-control custom-select text-center select2">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarFase">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Importe</label>

                                <input type="number" class="form-control" id="input_importe" placeholder="" value=0>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Enlace a enviar</label>

                                <select id="tipo_enlace" name="" class="form-control custom-select text-center">



                                    <option type="text" value="autonomo">Autónomo</option>

                                    <option type="text" value="sociedad">Sociedad</option>
                                    <option type="text" value="generico">Genérico</option>

                                </select>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Responsable</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            data-toggle="modal" data-target="#modalQuitarNombre">-</button>
                                    </span>
                                    <select name="input_usuario" id="input_usuario"
                                        class="form-control custom-select text-center select2">
                                        <?php

                                                 foreach($User_List as $User){
                                                 ?>
                                        <option type="text"
                                            value="<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>">
                                            <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>
                                        </option>
                                        <?php

                                                  }
                                                    ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarNombre">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Zona</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_zona">-</button>
                                    </span>
                                    <select id="input_zona" class="form-control custom-select text-center select2">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarZona">+</button>
                                    </span>
                                </div>


                            </div>

                        </div>
                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-success btn-fw" id="btn_agregar_datos">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalAgregarSector" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar sector</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <form id="form-agregar-sector" method="POST" action="">

                <div class="modal-body pb-0">

                    <div class="container p-0">

                        <div class="row">

                            <div class="col-12">
                                <input class="form-control w-100" name="nombre_sector" id="nombre_sector" required
                                    type="text">
                            </div>

                        </div>

                    </div>



                </div>

                <div class="modal-footer text-right">

                    <input type="hidden" id="cliente_sector_id" name="cliente_sector_id">

                    <button class="btn btn-danger btn-fw" type="submit">

                        Agregar</button>

                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>

            </form>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalAgregarFase" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar fase</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <form id="form-agregar-fase" method="POST" action="">

                <div class="modal-body pb-0">

                    <div class="container p-0">

                        <div class="row">

                            <div class="col-12">
                                <input class="w-100 form-control" name="nombre_fase" id="nombre_fase" type="text"
                                    required>
                            </div>

                        </div>

                    </div>



                </div>

                <div class="modal-footer text-right">

                    <input type="hidden" id="cliente_fase_id" name="cliente_fase_id">

                    <button class="btn btn-danger btn-fw" type="submit">

                        Agregar</button>

                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>

            </form>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarZona" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la zona definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">
                <form id="form_eliminar_zona" method="POST" action="">

                    <input type="hidden" id="id_zona_eliminar" name="id_zona_eliminar" data-name="">
                    <button class="btn btn-danger btn-fw" type="submit" name="">
                        Confirmar y eliminar </button>
                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                        Cancelar </button>

                </form>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarZona" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar zona</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <form id="form-agregar-zona" method="POST" action="">

                <div class="modal-body pb-0">

                    <div class="container p-0">

                        <div class="row">

                            <div class="col-12">
                                <input class="w-100 form-control" name="nombre_zona" id="nombre_zona" type="text"
                                    required>
                            </div>

                        </div>

                    </div>



                </div>

                <div class="modal-footer text-right">

                    <input type="hidden" id="cliente_zona_id" name="cliente_zona_id">

                    <button class="btn btn-danger btn-fw" type="submit">

                        Agregar</button>

                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>

            </form>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarFase" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la fase definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">
                <form id="form_eliminar_fase" method="POST" action="">

                    <input type="hidden" id="id_fase_eliminar" data-name="" name="id_fase_eliminar">
                    <button class="btn btn-danger btn-fw" type="submit" name="">
                        Confirmar y eliminar </button>
                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                        Cancelar </button>

                </form>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalEliminarSector" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el sector definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">
                <form id="form_eliminar_sector" method="POST" action="">

                    <input data-name="" type="hidden" id="id_sector_eliminar" name="id_sector_eliminar">
                    <button class="btn btn-danger btn-fw" type="submit" name="">
                        Confirmar y eliminar </button>
                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                        Cancelar </button>

                </form>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>


<script>
(function($) {
    'use strict';
    $(function() {
        $('#order-listing').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en clientes",
                infoEmpty: "Mostrando 0 to 0 of 0 en clientes",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [
                'colvis'
            ]

        });
        var Table = $('#order-listing2').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en subvenciones a enviar",
                infoEmpty: "Mostrando 0 to 0 of 0 en subvenciones a enviar",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [
                'colvis'
            ]

        });


        $('.dataTables_filter input').attr('placeholder', 'Buscar');
        $('.dataTables_filter input').addClass('form-control');
        // LENGTH - Inline-Form control



        $('.dataTables_length select').addClass('form-control');

        $('.dt-button span:nth-child(1)').text("Ocultar columnas");

        if ($("#mymce").length > 0) {
            tinymce.init({
                selector: "#mymce",
                theme: "modern",
                height: 300,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }

        if ($("#mymce_editar").length > 0) {
            tinymce.init({
                selector: "#mymce_editar",
                theme: "modern",
                height: 300,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }



        var checks = document.getElementsByClassName("subvencion");


        for (let check of checks) {

            check.addEventListener('change', function(e) {


                if (event.target.checked) {


                    $.ajax({
                        url: "./api/subvenciones.php?id_subvencion=" + e.target
                            .getAttribute(
                                'data-id'),
                        type: 'GET',
                        dataType: 'json', // added data type
                        cache: false,
                        success: function(res) {

                            var nombre = $("#input_nombre").val()
                            var url_generico_subvencion = res.url_generico
                            var url_autonomo_subvencion = res.url_autonomo
                            var url_sociedad_subvencion = res.url_sociedad
                            var cuerpo = res.email_marketing
                            var tipo_enlace = $("#tipo_enlace").val()

                            cuerpo = cuerpo.replace(/%nombre%/g, nombre);
                            if (tipo_enlace == "generico") {
                                cuerpo = cuerpo.replace(/%url%/g,
                                    url_generico_subvencion);
                            }
                            if (tipo_enlace == "autonomo") {
                                cuerpo = cuerpo.replace(/%url%/g,
                                    url_autonomo_subvencion);
                            }
                            if (tipo_enlace == "sociedad") {
                                cuerpo = cuerpo.replace(/%url%/g,
                                    url_sociedad_subvencion);
                            }
                            var id = res.id_subvencion;
                            $('#titulo_subvencion').val(res.titulo)
                            $(tinymce.get('mymce').getBody()).html(cuerpo)

                        }



                    })



                }
                for (let c of checks) {
                    c.checked = false;
                }
                event.target.checked = true;
                $("#id_subvencion").val(event.target.getAttribute('data-id'))
            })



        }

        $("#btn_editar_datos").click(function() {

            var email_marketing = $(tinymce.get('mymce_editar').getBody()).html()
            var titulo_subvencion = $('#titulo_subvencion_editar').val()


            var input_cif = $('#input_cif_editar').val()
            var input_domicilio = $('#input_domicilio_editar').val()
            var input_cp = $('#input_cp_editar').val()
            var input_telefono = $('#input_telefono_editar').val()
            var input_email = $('#input_email_editar').val()
            var input_nombre = $('#input_nombre_editar').val()
            var tipo_cliente = $('#tipo_cliente_editar').val()
            var input_empleados = $('#input_empleados_editar').val()
            var input_importe = $('#input_importe_editar').val()
            var tipo_enlace = $('#tipo_enlace_editar').val()
            var input_usuario = $('#input_usuario_editar').val()

            var fase = $("#input_fase_editar").val()
            var sector = $("#input_sector_editar").val()
            var zona = $("#input_zona_editar").val()

            var nombre_fase = $("#input_fase_editar").find(':selected').text()
            var nombre_sector = $("#input_sector_editar").find(':selected').text()
            var nombre_zona = $("#input_zona_editar").find(':selected').text()
            var url_portada = $("#input_mostrar_logo_editar").val()
            var condiciones = $("#condiciones_presupuesto_editar").val()
            if (nombre_fase == "") {
                nombre_fase = null
            }
            if (nombre_sector == "") {
                nombre_sector = null
            }
            if (nombre_zona == "") {
                nombre_zona = null
            }


            var cliente = $("#select_cliente_editar").val()
            var subvencion = $("#id_subvencion").val()
            var caja = document.createElement("div");
            var button_editar = document.createElement("button");
            button_editar.innerText = "Editar"
            button_editar.classList.add("mr-2")
            button_editar.classList.add("editar-row")
            button_editar.classList.add("btn")
            button_editar.classList.add("btn-sm")
            button_editar.classList.add("btn-outline-info")
            button_editar.setAttribute("data-condiciones", condiciones);
            button_editar.setAttribute("data-emailmarketing", $(tinymce.get('mymce_editar')
                    .getBody())
                .html());
            button_editar.setAttribute("data-portada", url_portada);
            button_editar.setAttribute("data-cif", input_cif);
            button_editar.setAttribute("data-domicilio", input_domicilio);
            button_editar.setAttribute("data-cp", input_cp);
            button_editar.setAttribute("data-telefono", input_telefono);
            button_editar.setAttribute("data-email", input_email);
            button_editar.setAttribute("data-nombre", input_nombre);
            button_editar.setAttribute("data-tipo", tipo_cliente);
            button_editar.setAttribute("data-empleados", input_empleados);
            button_editar.setAttribute("data-importe", input_importe);
            button_editar.setAttribute("data-enlace", tipo_enlace);
            button_editar.setAttribute("data-usuario", input_usuario);
            button_editar.setAttribute("data-fase", fase);
            button_editar.setAttribute("data-sector", sector);
            button_editar.setAttribute("data-zona", zona);
            button_editar.setAttribute("data-cliente", cliente);
            button_editar.setAttribute("data-subvencion", subvencion);
            button_editar.setAttribute("data-titulo", $('#titulo_subvencion_editar').val());

            var button_ver = document.createElement("button");
            button_ver.innerText = "Ver"
            button_ver.classList.add("mr-2")
            button_ver.classList.add("btn_ver")
            button_ver.classList.add("btn")
            button_ver.classList.add("btn-sm")
            button_ver.classList.add("btn-outline-success")
            button_ver.setAttribute("data-condiciones", condiciones);
            button_ver.setAttribute("data-emailmarketing", $(tinymce.get('mymce_editar').getBody())
                .html());
            button_ver.setAttribute("data-portada", url_portada);
            button_ver.setAttribute("data-cif", input_cif);
            button_ver.setAttribute("data-domicilio", input_domicilio);
            button_ver.setAttribute("data-cp", input_cp);
            button_ver.setAttribute("data-telefono", input_telefono);
            button_ver.setAttribute("data-email", input_email);
            button_ver.setAttribute("data-nombre", input_nombre);
            button_ver.setAttribute("data-tipo", tipo_cliente);
            button_ver.setAttribute("data-empleados", input_empleados);
            button_ver.setAttribute("data-importe", input_importe);
            button_ver.setAttribute("data-enlace", tipo_enlace);
            button_ver.setAttribute("data-usuario", input_usuario);
            button_ver.setAttribute("data-fase", fase);
            button_ver.setAttribute("data-sector", sector);
            button_ver.setAttribute("data-zona", zona);
            button_ver.setAttribute("data-cliente", cliente);
            button_ver.setAttribute("data-subvencion", subvencion);
            button_ver.setAttribute("data-titulo", $('#titulo_subvencion_editar').val());
            button_ver.setAttribute("data-toggle", "modal");
            button_ver.setAttribute("data-target", "#modalVerSubvencion");

            var button_eliminar = document.createElement("button");
            button_eliminar.innerText = "Eliminar"
            button_eliminar.classList.add("mr-2")
            button_eliminar.classList.add("eliminar-row")
            button_eliminar.classList.add("btn")
            button_eliminar.classList.add("btn-sm")
            button_eliminar.classList.add("btn-outline-danger")

            caja.appendChild(button_editar);
            caja.appendChild(button_ver);
            caja.appendChild(button_eliminar);

            Table.row($("#row_index").val())
                .remove()
                .draw();


            Table.row.add([

                input_nombre,
                titulo_subvencion,
                input_email,
                caja.innerHTML
            ]).draw();
            $("#modalEditarSubvencion").modal("hide");

        })
        Table.on('click', '.eliminar-row', function() {





        });

        $(document).on("click", ".btn_add_condicion", function(e) {

            $("#condiciones_presupuesto").val($("#condiciones_presupuesto").val() + "\n" + $(this)
                .data(
                    "condicion"))



        })
        $('#button_agregar').click(function() {
            var email_marketing = $(tinymce.get('mymce').getBody()).html()
            var titulo_subvencion = $('#titulo_subvencion').val()


            var input_cif = $('#input_cif').val()
            var input_domicilio = $('#input_domicilio').val()
            var input_cp = $('#input_cp').val()
            var input_telefono = $('#input_telefono').val()
            var input_email = $('#input_email').val()
            var input_nombre = $('#input_nombre').val()
            var tipo_cliente = $('#tipo_cliente').val()
            var input_empleados = $('#input_empleados').val()
            var input_importe = $('#input_importe').val()
            var tipo_enlace = $('#tipo_enlace').val()
            var input_usuario = $('#input_usuario').val()

            var fase = $("#input_fase").val()
            var sector = $("#input_sector").val()
            var zona = $("#input_zona").val()

            var nombre_fase = $("#input_fase").find(':selected').text()
            var nombre_sector = $("#input_sector").find(':selected').text()
            var nombre_zona = $("#input_zona").find(':selected').text()
            var url_portada = $("#input_mostrar_logo").val()
            var condiciones = $("#condiciones_presupuesto").val()

            if (nombre_fase == "") {
                nombre_fase = null
            }
            if (nombre_sector == "") {
                nombre_sector = null
            }
            if (nombre_zona == "") {
                nombre_zona = null
            }


            var cliente = $("#select_cliente").val()
            var subvencion = $("#id_subvencion").val()
            var caja = document.createElement("div");
            var button_editar = document.createElement("button");
            button_editar.innerText = "Editar"
            button_editar.classList.add("mr-2")
            button_editar.classList.add("editar-row")
            button_editar.classList.add("btn")
            button_editar.classList.add("btn-sm")
            button_editar.classList.add("btn-outline-info")
            button_editar.setAttribute("data-condiciones", condiciones);
            button_editar.setAttribute("data-emailmarketing", $(tinymce.get('mymce').getBody())
                .html());
            button_editar.setAttribute("data-portada", url_portada);
            button_editar.setAttribute("data-cif", input_cif);
            button_editar.setAttribute("data-domicilio", input_domicilio);
            button_editar.setAttribute("data-cp", input_cp);
            button_editar.setAttribute("data-telefono", input_telefono);
            button_editar.setAttribute("data-email", input_email);
            button_editar.setAttribute("data-nombre", input_nombre);
            button_editar.setAttribute("data-tipo", tipo_cliente);
            button_editar.setAttribute("data-empleados", input_empleados);
            button_editar.setAttribute("data-importe", input_importe);
            button_editar.setAttribute("data-enlace", tipo_enlace);
            button_editar.setAttribute("data-usuario", input_usuario);
            button_editar.setAttribute("data-fase", fase);
            button_editar.setAttribute("data-sector", sector);
            button_editar.setAttribute("data-zona", zona);
            button_editar.setAttribute("data-cliente", cliente);
            button_editar.setAttribute("data-subvencion", subvencion);
            button_editar.setAttribute("data-titulo", $('#titulo_subvencion').val());

            var button_ver = document.createElement("button");
            button_ver.innerText = "Ver"
            button_ver.classList.add("mr-2")
            button_ver.classList.add("btn_ver")
            button_ver.classList.add("btn")
            button_ver.classList.add("btn-sm")
            button_ver.classList.add("btn-outline-success")
            button_ver.setAttribute("data-condiciones", condiciones);
            button_ver.setAttribute("data-emailmarketing", $(tinymce.get('mymce').getBody())
                .html());
            button_ver.setAttribute("data-portada", url_portada);
            button_ver.setAttribute("data-cif", input_cif);
            button_ver.setAttribute("data-domicilio", input_domicilio);
            button_ver.setAttribute("data-cp", input_cp);
            button_ver.setAttribute("data-telefono", input_telefono);
            button_ver.setAttribute("data-email", input_email);
            button_ver.setAttribute("data-nombre", input_nombre);
            button_ver.setAttribute("data-tipo", tipo_cliente);
            button_ver.setAttribute("data-empleados", input_empleados);
            button_ver.setAttribute("data-importe", input_importe);
            button_ver.setAttribute("data-enlace", tipo_enlace);
            button_ver.setAttribute("data-usuario", input_usuario);
            button_ver.setAttribute("data-fase", fase);
            button_ver.setAttribute("data-sector", sector);
            button_ver.setAttribute("data-zona", zona);
            button_ver.setAttribute("data-cliente", cliente);
            button_ver.setAttribute("data-subvencion", subvencion);
            button_ver.setAttribute("data-titulo", $('#titulo_subvencion').val());
            button_ver.setAttribute("data-toggle", "modal");
            button_ver.setAttribute("data-target", "#modalVerSubvencion");

            var button_eliminar = document.createElement("button");
            button_eliminar.innerText = "Eliminar"
            button_eliminar.classList.add("mr-2")
            button_eliminar.classList.add("eliminar-row")
            button_eliminar.classList.add("btn")
            button_eliminar.classList.add("btn-sm")
            button_eliminar.classList.add("btn-outline-danger")

            caja.appendChild(button_editar);
            caja.appendChild(button_ver);
            caja.appendChild(button_eliminar);
            Table.row.add([

                input_nombre,
                titulo_subvencion,
                input_email,
                caja.innerHTML
            ]).draw();

        })

        $(document).on("click", ".editar-row", function() {


            var cif = $(this).data("cif")
            var domicilio = $(this).data("domicilio")
            var cp = $(this).data("cp")
            var telefono = $(this).data("telefono")
            var email = $(this).data("email")
            var nombre = $(this).data("nombre")
            var tipo = $(this).data("tipo")
            var empleados = $(this).data("empleados")
            var importe = $(this).data("importe")
            var enlace = $(this).data("enlace")
            var usuario = $(this).data("usuario")
            var fase = $(this).data("nombrefase")
            var sector = $(this).data("nombresector")
            var zona = $(this).data("nombrezona")
            var id_cliente = $(this).data("cliente")
            var id_subvencion = $(this).data("subvencion")
            var email_marketing = $(this).data("emailmarketing")
            var titulo = $(this).data("titulo")
            var portada = $(this).data("portada")
            var condiciones = $(this).data("condiciones")
            $('#id_subvencion_editar').val(id_subvencion)
            $('#condiciones_presupuesto_editar').val(condiciones)
            $('#input_mostrar_logo_editar').val(portada)
            $('#img_logo_portada_editar').attr("src", portada)
            $('#titulo_subvencion_editar').val(titulo)
            $(tinymce.get('mymce_editar').getBody()).html(email_marketing)
            $('#select_cliente_editar').val(id_cliente)

            $("#modalEditarSubvencion").modal("show");




            $('#row_index').val(Table.row($(this).parents('tr')).index())

            //Table.row($(this).parents('tr')).remove().draw();


        })

        $(document).on("click", ".btn_ver", function() {
            var cif = $(this).data("cif")
            var domicilio = $(this).data("domicilio")
            var cp = $(this).data("cp")
            var telefono = $(this).data("telefono")
            var email = $(this).data("email")
            var nombre = $(this).data("nombre")
            var tipo = $(this).data("tipo")
            var empleados = $(this).data("empleados")
            var importe = $(this).data("importe")
            var enlace = $(this).data("enlace")
            var usuario = $(this).data("usuario")
            var fase = $(this).data("nombrefase")
            var sector = $(this).data("nombresector")
            var zona = $(this).data("nombrezona")
            var id_cliente = $(this).data("cliente")
            var id_subvencion = $(this).data("subvencion")
            var email_marketing = $(this).data("emailmarketing")
            var portada = $(this).data("portada")
            var titulo = $(this).data("titulo")
            var condiciones = $(this).data("condiciones")

            if (fase == null) {
                $("#fase_pdf").css("display", "none");

            } else {
                $("#fase_pdf").css("display", "block");
                $("#fase_cliente_pdf").text(fase)
            }
            if (sector == null) {
                $("#sector_pdf").css("display", "none");

            } else {
                $("#sector_pdf").css("display", "block");
                $("#sector_cliente_pdf").text(sector)
            }
            if (zona == null) {
                $("#zona_pdf").css("display", "none");

            } else {
                $("#zona_pdf").css("display", "block");
                $("#zona_cliente_pdf").text(zona)
            }


            $('#condiciones_pdf').text(condiciones)
            $('#img_portada_mail').attr("src", portada)
            $('#nombre_cliente_pdf').text(nombre)
            $('#cif_cliente_pdf').text(cif)
            $('#domicilio_cliente_pdf').text(domicilio)
            $('#tipo_cliente_pdf').text(tipo)
            $('#empleados_pdf').text(empleados)
            $('#cp_cliente_pdf').text(cp)
            $('#titulo_subvencion_pdf').text(titulo)
            $('#descripcion_subvencion_pdf').html(email_marketing)
            $('#importe_pdf').text(importe + "€")
        })

        function updateDatosEditar() {
            var id_cliente = $('#select_cliente_editar').val();

            $("#input_fase_editar").empty()
            $("#input_sector_editar").empty()
            $("#input_zona_editar").empty()

            $.ajax({
                type: "GET",
                url: "./api/zonas.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    // console.log(res);
                    for (let r of res) {
                        //console.log(r)
                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_zona, false, false);
                            $("#input_zona_editar").append(newOption).trigger('change');

                        }
                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/sectores.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    // console.log(res);
                    for (let r of res) {



                        let newOption
                        newOption = new Option(r.nombre, r.id_sector, false, false);
                        $("#input_sector_editar").append(newOption).trigger('change');


                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/fases.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    //   console.log(res);
                    for (let r of res) {

                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_fase, false, false);
                            $("#input_fase_editar").append(newOption).trigger('change');

                        }
                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/clientes.php?client_id=" +
                    id_cliente,
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    //   console.log(res);

                    $('#input_cif_editar').val(res.cif)
                    $('#input_domicilio_editar').val(res.direccion)
                    $('#input_cp_editar').val(res.cp)
                    $('#input_telefono_editar').val(res.telefono)
                    $('#input_email_editar').val(res.email)
                    $('#input_nombre_editar').val(res.nombre)




                }

            })


        }

        function updateDatos() {
            var id_cliente = $('#select_cliente').val();

            $("#input_fase").empty()
            $("#input_sector").empty()
            $("#input_zona").empty()

            $.ajax({
                type: "GET",
                url: "./api/zonas.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    // console.log(res);
                    for (let r of res) {
                        //console.log(r)
                        if (r.id_cliente == $('#select_cliente').find(':selected').val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_zona, false, false);
                            $("#input_zona").append(newOption).trigger('change');

                        }
                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/sectores.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    // console.log(res);
                    for (let r of res) {



                        let newOption
                        newOption = new Option(r.nombre, r.id_sector, false, false);
                        $("#input_sector").append(newOption).trigger('change');


                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/fases.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    //   console.log(res);
                    for (let r of res) {

                        if (r.id_cliente == $('#select_cliente').find(':selected').val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_fase, false, false);
                            $("#input_fase").append(newOption).trigger('change');

                        }
                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/clientes.php?client_id=" +
                    id_cliente,
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    //   console.log(res);

                    $('#input_cif').val(res.cif)
                    $('#input_domicilio').val(res.direccion)
                    $('#input_cp').val(res.cp)
                    $('#input_telefono').val(res.telefono)
                    $('#input_email').val(res.email)
                    $('#input_nombre').val(res.nombre)




                }

            })


        }

        updateDatos()
        updateDatosEditar()

        $("#button_guardar").click(function() {
            var buttons = $(".editar-row");
            $("#button_guardar").addClass(
                'btn-loading');
            $("#button_guardar").attr("disabled", true);
            for (let b of buttons) {
                var cif = b.getAttribute("data-cif")
                var domicilio = b.getAttribute("data-domicilio")
                var cp = b.getAttribute("data-cp")
                var telefono = b.getAttribute("data-telefono")
                var email = b.getAttribute("data-email")
                var nombre = b.getAttribute("data-nombre")
                var tipo = b.getAttribute("data-tipo")
                var empleados = b.getAttribute("data-empleados")
                var importe = b.getAttribute("data-importe")
                var enlace = b.getAttribute("data-enlace")
                var usuario = b.getAttribute("data-usuario")
                var fase = b.getAttribute("data-fase")
                var sector = b.getAttribute("data-sector")
                var zona = b.getAttribute("data-zona")
                var titulo = b.getAttribute("data-titulo")
                var id_cliente = b.getAttribute("data-cliente")
                var id_subvencion = b.getAttribute("data-subvencion")
                var email_marketing = b.getAttribute("data-emailmarketing")
                var url_portada = b.getAttribute("data-portada")
                var condiciones = b.getAttribute("data-condiciones")
                if (isNaN(parseInt(fase))) {
                    fase = "";
                }
                if (isNaN(parseInt(zona))) {
                    zona = "";
                }
                if (isNaN(parseInt(sector))) {
                    sector = "";
                }


                $.ajax({
                    type: 'POST',
                    url: './crear_subvenciones',
                    cache: false,
                    data: {


                        email: email,
                        id_cliente: id_cliente,
                        id_subvencion: id_subvencion,
                        cif: cif,
                        domicilio: domicilio,
                        cp: cp,
                        telefono: telefono,
                        nombre: nombre,
                        tipo: tipo,
                        empleados: empleados,
                        importe: importe,
                        enlace: enlace,
                        usuario: usuario,
                        fase: fase,
                        sector: sector,
                        zona: zona,
                        email_marketing: email_marketing,
                        titulo: titulo,
                        url_portada: url_portada,
                        condiciones: condiciones

                    },
                    success: function(result2) {

                        $("#button_guardar").attr("disabled", false);

                    }
                })

            }
            $.toast({
                heading: 'Subvenciones guardadas',
                text: 'Se han guardado las subvenciones correctamente',
                position: 'top-right',
                loaderBg: '#32a852',
                icon: 'success',
                hideAfter: 2000,
                stack: 6
            });
            setTimeout(function() {
                $("#button_guardar").removeClass(
                    'btn-loading');

                window.location.href = "./subvenciones_enviadas";

            }, 2000);
        })
        $("#button_enviar").click(function() {

            var buttons = $(".editar-row");
            $("#button_enviar").addClass(
                'btn-loading');
            $("#button_enviar").attr("disabled", true);
            for (let b of buttons) {
                var cif = b.getAttribute("data-cif")
                var domicilio = b.getAttribute("data-domicilio")
                var cp = b.getAttribute("data-cp")
                var telefono = b.getAttribute("data-telefono")
                var email = b.getAttribute("data-email")
                var nombre = b.getAttribute("data-nombre")
                var tipo = b.getAttribute("data-tipo")
                var empleados = b.getAttribute("data-empleados")
                var importe = b.getAttribute("data-importe")
                var enlace = b.getAttribute("data-enlace")
                var usuario = b.getAttribute("data-usuario")
                var fase = b.getAttribute("data-nombrefase")
                var sector = b.getAttribute("data-nombresector")
                var zona = b.getAttribute("data-nombrezona")
                var fecha_envio = moment().format('YYYY-MM-DD HH:mm:ss');
                var id_cliente = b.getAttribute("data-cliente")
                var id_subvencion = b.getAttribute("data-subvencion")
                var email_marketing = b.getAttribute("data-emailmarketing")
                var titulo = b.getAttribute("data-titulo")
                var url_portada = b.getAttribute("data-portada")
                var id_zona = b.getAttribute("data-zona")
                var id_fase = b.getAttribute("data-fase")
                var id_sector = b.getAttribute("data-sector")
                var condiciones = b.getAttribute("data-condiciones")

                if (isNaN(parseInt(id_fase))) {
                    id_fase = "";
                }
                if (isNaN(parseInt(id_zona))) {
                    id_zona = "";
                }
                if (isNaN(parseInt(id_sector))) {
                    id_sector = "";
                }

                if (fase == null) {
                    $("#fase_pdf").css("display", "none");

                } else {
                    $("#fase_pdf").css("display", "block");
                    $("#fase_cliente_pdf").text(fase)
                }
                if (sector == null) {
                    $("#sector_pdf").css("display", "none");

                } else {
                    $("#sector_pdf").css("display", "block");
                    $("#sector_cliente_pdf").text(sector)
                }
                if (zona == null) {
                    $("#zona_pdf").css("display", "none");

                } else {
                    $("#zona_pdf").css("display", "block");
                    $("#zona_cliente_pdf").text(zona)
                }


                $('#img_portada_mail').attr("src", url_portada)

                $('#condiciones_pdf').text(condiciones)
                $('#nombre_cliente_pdf').text(nombre)
                $('#cif_cliente_pdf').text(cif)
                $('#domicilio_cliente_pdf').text(domicilio)
                $('#tipo_cliente_pdf').text(tipo)
                $('#empleados_pdf').text(empleados)
                $('#cp_cliente_pdf').text(cp)
                $('#titulo_subvencion_pdf').text(titulo)
                $('#descripcion_subvencion_pdf').html(email_marketing)
                $('#importe_pdf').text(importe + "€")

                var pdf = $('#pdf_subvencion')[0].outerHTML

                $.ajax({
                    type: 'POST',
                    url: './crear_subvenciones',
                    cache: false,
                    async: false,
                    data: {


                        email: email,
                        id_cliente: id_cliente,
                        id_subvencion: id_subvencion,
                        cif: cif,
                        domicilio: domicilio,
                        cp: cp,
                        telefono: telefono,
                        nombre: nombre,
                        tipo: tipo,
                        empleados: empleados,
                        importe: importe,
                        enlace: enlace,
                        usuario: usuario,
                        fase: id_fase,
                        sector: id_sector,
                        zona: id_zona,
                        email_marketing: email_marketing,
                        fecha_envio: fecha_envio,
                        titulo: titulo,
                        url_portada: url_portada,
                        condiciones: condiciones
                    },
                    success: function(result2) {

                        $.ajax({
                            type: 'POST',
                            url: './mailer',
                            cache: false,
                            async: false,
                            data: {


                                email: email,
                                subvencion: pdf


                            },

                            success: function(result2) {

                                console.log(result2);

                            }
                        });


                    }
                });


            }
            $.toast({
                heading: 'Subvenciones enviadas',
                text: 'Se han enviado las subvenciones correctamente',
                position: 'top-right',
                loaderBg: '#32a852',
                icon: 'success',
                hideAfter: 2000,
                stack: 6
            });
            setTimeout(function() {
                $("#button_enviar").removeClass(
                    'btn-loading');
                $("#button_enviar").attr("disabled", false);
                window.location.href = "./subvenciones_enviadas";

            }, 2000);
        })

        $("#cliente_subvencion").on("change", function() {

            $("#select_cliente").val($("#cliente_subvencion").find(':selected').val())
            $('#select_cliente').trigger('change');
            $("#modalAgregarClienteSubvencion").modal("show");
        })
        $("#select_cliente").on("change", function() {
            updateDatos()
        })
        $("#select_cliente_editar").on("change", function() {
            updateDatosEditar()
        })



        function updateSelectZona(selected = "none") {
            $("#input_zona").empty()
            $("#input_zona_editar").empty()
            $.ajax({
                type: "GET",
                url: "./api/zonas.php",
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)

                    for (let r of res) {
                        //console.log(r)
                        if (r.id_cliente == $('#select_cliente').find(':selected').val()) {


                            let newOption
                            newOption = new Option(r.nombre, r.id_zona, false, false);
                            $("#input_zona").append(newOption).trigger('change');


                        }
                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {


                            let newOption
                            newOption = new Option(r.nombre, r.id_zona, false, false);
                            $("#input_zona_editar").append(newOption).trigger('change');


                        }
                    }
                    if (selected != "none") {
                        $("#input_zona").val(res[res.length - 1].id_zona).trigger('change');
                        $("#input_zona_editar").val(res[res.length - 1].id_zona).trigger(
                            'change');
                    }

                }

            })
        }

        function updateSelectSector(selected = "none") {

            $("#input_sector").empty()
            $("#input_sector_editar").empty()
            $.ajax({
                type: "GET",
                url: "./api/sectores.php",
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    console.log(res);
                    for (let r of res) {



                        let newOption
                        let newOption2
                        newOption = new Option(r.nombre, r.id_sector, false, false);
                        newOption2 = new Option(r.nombre, r.id_sector, false, false);
                        $("#input_sector").append(newOption).trigger('change');
                        $("#input_sector_editar").append(newOption2).trigger('change');

                    }

                    if (selected != "none") {
                        $("#input_sector").val(res[res.length - 1].id_sector).trigger('change');
                        $("#input_sector_editar").val(res[res.length - 1].id_sector).trigger(
                            'change');
                    }
                }

            })

        }

        function updateSelectFase(selected = "none") {

            $("#input_fase").empty()
            $("#input_fase_editar").empty()

            $.ajax({
                type: "GET",
                url: "./api/fases.php",
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)

                    for (let r of res) {

                        if (r.id_cliente == $('#select_cliente').find(':selected').val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_fase, false, false);
                            $("#input_fase").append(newOption).trigger('change');

                        }
                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_fase, false, false);
                            $("#input_fase_editar").append(newOption).trigger('change');

                        }
                    }
                    if (selected != "none") {
                        $("#input_fase").val(res[res.length - 1].id_fase).trigger('change');
                        $("#input_fase_editar").val(res[res.length - 1].id_fase).trigger(
                            'change');
                    }

                }

            })
        }







        $('#form-agregar-zona').submit(function(event) {
            // event.preventDefault();

            $('#cliente_zona_id').val($('#select_cliente').find(':selected').val())

            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {

                    $('#modalAgregarZona').modal('hide');
                    $.toast({
                        heading: 'Zona del cliente ' + $(
                                '#select_cliente')
                            .find(':selected').text() + ' agregada.',
                        text: 'Se ha agregado la zona correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectZona(1)
                }
            });

            return false;
        });

        $('#form-agregar-sector').submit(function(event) {
            event.preventDefault();

            $('#cliente_sector_id').val($('#select_cliente').find(':selected').val())

            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalAgregarSector').modal('hide');
                    $.toast({
                        heading: 'Sector del cliente ' + $(
                                '#select_cliente')
                            .find(':selected').text() + ' agregado.',
                        text: 'Se ha agregado el sector correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectSector(1)
                }
            });

            return false;
        });

        $('#form-agregar-fase').submit(function(event) {
            event.preventDefault();

            $('#cliente_fase_id').val($('#select_cliente').find(':selected').val())

            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {

                    $('#modalAgregarFase').modal('hide');
                    $.toast({
                        heading: 'Fase del cliente ' + $(
                                '#select_cliente')
                            .find(':selected').text() + ' agregado.',
                        text: 'Se ha agregado la fase correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectFase(1)

                }
            });

            return false;
        });
        $(document).on("click", "#btn_eliminar_zona", function(e) {



            $("#id_zona_eliminar").val($("#input_zona").val())
            $("#id_zona_eliminar").data('name', $("#input_zona").find(':selected').text())

            console.log();
            $("#modalEliminarZona").modal('show');

            return false;


        })
        $(document).on("click", "#btn_eliminar_sector", function(e) {



            $("#id_sector_eliminar").val($("#input_sector").val())
            $("#id_sector_eliminar").data('name', $("#input_sector").find(':selected').text())
            $("#modalEliminarSector").modal('show');

            return false;


        })
        $(document).on("click", "#btn_eliminar_fase", function(e) {



            $("#id_fase_eliminar").val($("#input_fase").val())
            $("#id_fase_eliminar").data('name', $("#input_fase").find(':selected').text())
            $("#modalEliminarFase").modal('show');

            return false;


        })
        $(document).on("click", "#btn_eliminar_zona_editar", function(e) {



            $("#id_zona_eliminar").val($("#input_zona_editar").val())
            $("#id_zona_eliminar").data('name', $("#input_zona_editar").find(':selected').text())

            console.log();
            $("#modalEliminarZona").modal('show');

            return false;


        })
        $(document).on("click", "#btn_eliminar_sector_editar", function(e) {



            $("#id_sector_eliminar").val($("#input_sector_editar").val())
            $("#id_sector_eliminar").data('name', $("#input_sector_editar").find(':selected')
                .text())
            $("#modalEliminarSector").modal('show');

            return false;


        })
        $(document).on("click", "#btn_eliminar_fase_editar", function(e) {



            $("#id_fase_eliminar").val($("#input_fase_editar").val())
            $("#id_fase_eliminar").data('name', $("#input_fase_editar").find(':selected').text())
            $("#modalEliminarFase").modal('show');

            return false;


        })
        $('#form_eliminar_zona').submit(function(event) {
            event.preventDefault();
            console.log(event.target);


            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalEliminarZona').modal('hide');
                    $.toast({
                        heading: 'Zona ' + $("#id_zona_eliminar").data('name') +
                            ' eliminada',
                        text: 'Se ha eliminado la zona ' + $(
                            "#id_zona_eliminar").data(
                            'name') + ' correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectZona()

                }
            });

            return false;
        });
        $('#form_eliminar_sector').submit(function(event) {
            event.preventDefault();



            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalEliminarSector').modal('hide');
                    $.toast({
                        heading: 'Sector ' + $("#id_sector_eliminar").data(
                                'name') +
                            ' eliminado',
                        text: 'Se ha eliminado el sector ' + $(
                            "#id_sector_eliminar").data(
                            'name') + ' correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectSector()

                }
            });

            return false;
        });
        $('#form_eliminar_fase').submit(function(event) {
            event.preventDefault();



            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalEliminarFase').modal('hide');
                    $.toast({
                        heading: 'Fase ' + $("#id_fase_eliminar").data('name') +
                            ' eliminada',
                        text: 'Se ha eliminado la fase ' + $(
                            "#id_fase_eliminar").data(
                            'name') + ' correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectFase()

                }
            });

            return false;
        });
        $("#tipo_enlace_editar").change(function() {
            $.ajax({
                url: "./api/subvenciones.php?id_subvencion=" + $("#id_subvencion_editar")
                    .val(),
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                success: function(res) {

                    var nombre = $("#input_nombre_editar").val()
                    var url_generico_subvencion = res.url_generico
                    var url_autonomo_subvencion = res.url_autonomo
                    var url_sociedad_subvencion = res.url_sociedad
                    var cuerpo = $(tinymce.get('mymce_editar').getBody()).html()
                    var tipo_enlace = $("#tipo_enlace_editar").val()

                    if (tipo_enlace == "generico") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_generico_subvencion);
                        cuerpo = cuerpo.replace(url_autonomo_subvencion,
                            url_generico_subvencion);
                        cuerpo = cuerpo.replace(url_sociedad_subvencion,
                            url_generico_subvencion);
                    }
                    if (tipo_enlace == "autonomo") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_autonomo_subvencion);
                        cuerpo = cuerpo.replace(url_generico_subvencion,
                            url_autonomo_subvencion);
                        cuerpo = cuerpo.replace(url_sociedad_subvencion,
                            url_autonomo_subvencion);
                    }
                    if (tipo_enlace == "sociedad") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_sociedad_subvencion);
                        cuerpo = cuerpo.replace(url_autonomo_subvencion,
                            url_sociedad_subvencion);
                        cuerpo = cuerpo.replace(url_generico_subvencion,
                            url_sociedad_subvencion);
                    }


                    $(tinymce.get('mymce_editar').getBody()).html(cuerpo)

                }



            })




        })

        $("#btn_agregar_datos").click(function() {
            $.ajax({
                url: "./api/subvenciones.php?id_subvencion=" + $("#id_subvencion").val(),
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                success: function(res) {

                    var nombre = $("#input_nombre").val()
                    var url_generico_subvencion = res.url_generico
                    var url_autonomo_subvencion = res.url_autonomo
                    var url_sociedad_subvencion = res.url_sociedad
                    var cuerpo = $(tinymce.get('mymce').getBody()).html()
                    var tipo_enlace = $("#tipo_enlace").val()
                    console.log(cuerpo);
                    //cuerpo = cuerpo.replace(/%nombre%/g, nombre);
                    if (tipo_enlace == "generico") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_generico_subvencion);
                        cuerpo = cuerpo.replace(url_autonomo_subvencion,
                            url_generico_subvencion);
                        cuerpo = cuerpo.replace(url_sociedad_subvencion,
                            url_generico_subvencion);
                    }
                    if (tipo_enlace == "autonomo") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_autonomo_subvencion);
                        cuerpo = cuerpo.replace(url_generico_subvencion,
                            url_autonomo_subvencion);
                        cuerpo = cuerpo.replace(url_sociedad_subvencion,
                            url_autonomo_subvencion);
                    }
                    if (tipo_enlace == "sociedad") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_sociedad_subvencion);
                        cuerpo = cuerpo.replace(url_autonomo_subvencion,
                            url_sociedad_subvencion);
                        cuerpo = cuerpo.replace(url_generico_subvencion,
                            url_sociedad_subvencion);
                    }

                    var id = res.id_subvencion;
                    $('#titulo_subvencion').val(res.titulo)
                    $(tinymce.get('mymce').getBody()).html(cuerpo)
                    $('#modalAgregarClienteSubvencion').modal('hide');
                }



            })





        })


        $("#logo_portada").on("change", function() {

            var fd = new FormData();
            var imagen_portada = $('#logo_portada')[0].files[0];

            fd.append('imagen_portada', imagen_portada);
            console.log(fd);
            $.ajax({
                url: './crear_subvenciones',
                type: 'POST',
                data: fd,
                processData: false, // tell jQuery not to process the data
                contentType: false, // tell jQuery not to set contentType
                success: function(result) {

                    var url = result
                    $("#img_logo_portada").attr('src', url)
                    $("#input_mostrar_logo").val(url)
                    $.toast({
                        heading: 'Nueva imágen subida',
                        text: 'Se subido la nueva imágen correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                }
            });

        })

        $("#logo_portada_editar").on("change", function() {

            var fd = new FormData();
            var imagen_portada = $('#logo_portada_editar')[0].files[0];

            fd.append('imagen_portada', imagen_portada);
            console.log(fd);
            $.ajax({
                url: './crear_subvenciones',
                type: 'POST',
                data: fd,
                processData: false, // tell jQuery not to process the data
                contentType: false, // tell jQuery not to set contentType
                success: function(result) {

                    var url = result
                    $("#img_logo_portada_editar").attr('src', url)
                    $("#input_mostrar_logo_editar").val(url)
                    $.toast({
                        heading: 'Nueva imágen subida',
                        text: 'Se subido la nueva imágen correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                }
            });

        })


    })
})(jQuery);
</script>