<style>
#img-container {
    position: relative;
    width: 100%;
    cursor: pointer;
}

/* La imagen */
#img-container img {
    width: 100%;
    height: 200px;
    object-fit: cover;
}

/* La capa superpuesta */
.overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: #ffffff85;
    opacity: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: opacity 0.5s;
}

/* El texto dentro de la capa superpuesta */
.overlay-text {
    color: black;
    font-size: 20px;
    font-weight: 800;
}

/* Al hacer hover, mostrar la capa superpuesta */
#img-container:hover .overlay {
    opacity: 1;
}

.lottie_modal {
    overflow: hidden;
}

lottie-player {
    background: transparent;
    border-radius: 0px;
    transition: all .3s ease-in-out;
    cursor: pointer;
}

input[name="lottie_modal"]:checked+lottie-player {
    background: #f2f5f8;
    border-radius: 5px;
}
</style>


<div class="content-wrapper">
    <div class="row profile-page">
        <div class="col-12">
            <div class="card p-3 p-sm-4">
                <div class="" style="padding-bottom: 0px !important;">





                    <div class="row">
                        <div class="col-12 mb-3">
                            <h3 class="mb-3">
                                Crear formulario
                            </h3>
                            <div class="form-group">
                                <label for="my-input">Nombre del formulario</label>
                                <input id="nombre_formulario" class="form-control" type="text" name="">
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <p class="">A continuación, elije los campos que contendrá el formulario:
                            </p>
                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="portada">
                                    <span style="font-size: 18px;" class="custom-control-label">Portada:</span>
                                </label>
                                <div id="img-container" onclick="document.getElementById('imagenInput').click();">
                                    <input type="file" id="imagenInput" accept="image/*" style="display: none;">
                                    <img id="portada" class="w-100" src="./assets/images/portada.jpg" alt="">
                                    <div class="overlay">
                                        <span class="overlay-text">Cambiar</span>
                                    </div>
                                </div>

                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="info_1">
                                    <span style="font-size: 18px;" class=" custom-control-label">Información
                                        principal.</span>
                                </label>
                                <textarea id="info_1" name="area"></textarea>
                            </div>

                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="nombre">
                                    <span style="font-size: 18px;" class=" custom-control-label">Nombre</span>
                                </label>
                                <input id="nombre" class="form-control" type="text" name="" value="Ingresa tu nombre">
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="apellidos">
                                    <span style="font-size: 18px;" class=" custom-control-label">Apellidos</span>
                                </label>
                                <input id="apellidos" class="form-control" type="text" name=""
                                    value="Ingresa tus apellidos">
                            </div>

                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="dni">
                                    <span style="font-size: 18px;" class=" custom-control-label">Documento de
                                        identidad</span>
                                </label>
                                <input id="dni" class="form-control" type="text" name="" value="Ingresa tu DNI sin .">
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="telefono">
                                    <span style="font-size: 18px;" class=" custom-control-label">Teléfono</span>
                                </label>
                                <input id="telefono" class="form-control" type="text" name=""
                                    value="Ingresa tu teléfono de contacto">
                            </div>

                        </div>
                    </div>


                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="email">
                                    <span style="font-size: 18px;" class=" custom-control-label">Email</span>
                                </label>
                                <input id="email" class="form-control" type="text" name=""
                                    value="Ingresa tu cuenta de correo electrónico.">
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="pais">
                                    <span style="font-size: 18px;" class=" custom-control-label">País</span>
                                </label>
                                <input id="pais" class="form-control" type="text" name=""
                                    value="Ingresa tu país de residencia.">
                            </div>

                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="ciudad">
                                    <span style="font-size: 18px;" class=" custom-control-label">Ciudad</span>
                                </label>
                                <input id="ciudad" class="form-control" type="text" name=""
                                    value="Ingresa tu ciudad de residencia.">
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="direccion">
                                    <span style="font-size: 18px;" class=" custom-control-label">Dirección</span>
                                </label>
                                <input id="direccion" class="form-control" type="text" name=""
                                    value="Ingresa tu dirección de residencia.">
                            </div>

                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="info_2">
                                    <span style="font-size: 18px;" class=" custom-control-label">Información
                                        secundaria.</span>
                                </label>
                                <textarea id="info_2" name="area"></textarea>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="info_3">
                                    <span style="font-size: 18px;" class=" custom-control-label">Información
                                        terciaria.</span>
                                </label>
                                <textarea id="info_3" name="area"></textarea>
                            </div>

                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="autorizacion">
                                    <span style="font-size: 18px;" class=" custom-control-label">Autorización para
                                        envíos de información.</span>
                                </label>
                                <td class="td-tablet">

                                    <div class="form-check form-check-inline d-flex">
                                        <input value="Si" class="mail form-check-input" type="radio" id="autorizacion"
                                            name="autorizacion" checked>
                                        <label class="form-check-label">Si</label>

                                    </div>
                                    <div class="form-check form-check-inline d-flex">
                                        <input value="No" class="mail form-check-input" type="radio" id="autorizacion"
                                            name="autorizacion" checked="">
                                        <label class="form-check-label">No</label>
                                    </div>


                                </td>
                            </div>
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="texto_modal">
                                    <span style="font-size: 18px;" class=" custom-control-label">Texto de confirmación
                                        de
                                        envío del formulario.</span>
                                </label>
                                <textarea id="texto_modal"
                                    class="form-control">Formulario enviado exitosamente!</textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="info_4">
                                    <span style="font-size: 18px;" class=" custom-control-label">Información
                                        adicional.</span>
                                </label>
                                <textarea id="info_4" name="area"></textarea>
                            </div>

                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox d-inline-block mb-3">
                                    <input type="checkbox" class="custom-control-input incluir" checked
                                        data-elemento="lottie_modal">
                                    <span style="font-size: 18px;" class=" custom-control-label">Lottiefile de
                                        confirmación de
                                        envío del formulario.</span>
                                </label>
                                <div class="row">
                                    <div class="col-md-3 text-center lottie_modal">
                                        <input type="radio" name="lottie_modal" value="ok_1" checked>
                                        <lottie-player autoplay src="assets/lottiefiles/ok_1.json" style="width: 100%;">
                                        </lottie-player>
                                    </div>
                                    <div class="col-md-3 text-center lottie_modal">
                                        <input type="radio" name="lottie_modal" value="ok_2">
                                        <lottie-player autoplay src="assets/lottiefiles/ok_2.json" style="width: 100%;">
                                        </lottie-player>
                                    </div>
                                    <div class="col-md-3 text-center lottie_modal">
                                        <input type="radio" name="lottie_modal" value="ok_3">
                                        <lottie-player autoplay src="assets/lottiefiles/ok_3.json" style="width: 100%;">
                                        </lottie-player>
                                    </div>
                                    <div class="col-md-3 text-center lottie_modal">
                                        <input type="radio" name="lottie_modal" value="ok_4">
                                        <lottie-player autoplay src="assets/lottiefiles/ok_4.json" style="width: 100%;">
                                        </lottie-player>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-right">

                            <button type="button" id="btn_guardar"
                                class="btn_guardar btn btn-sm btn-success">Guardar</button>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

</div>


<!-- MODALS -->



<script>
(function($) {

    'use strict';

    $(function() {
        if ($("#info_1").length > 0) {
            tinymce.init({
                selector: "textarea#info_1",
                theme: "modern",
                height: 200,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }
        if ($("#info_2").length > 0) {
            tinymce.init({
                selector: "textarea#info_2",
                theme: "modern",
                height: 200,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }
        if ($("#info_3").length > 0) {
            tinymce.init({
                selector: "textarea#info_3",
                theme: "modern",
                height: 200,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }
        if ($("#info_4").length > 0) {
            tinymce.init({
                selector: "textarea#info_4",
                theme: "modern",
                height: 200,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }

        $(document).on("change", ".incluir", function() {
            var elemento = $(this).data("elemento")

            if (elemento == "portada") {
                if ($(this).prop("checked")) {

                    $("#img-container").css("pointer-events", "auto");
                } else {
                    $("#img-container").css("pointer-events", "none");
                }
                return false;
            }
            if (elemento == "info_1" || elemento == "info_2" || elemento == "info_3" || elemento ==
                "info_4") {
                if ($(this).prop("checked")) {

                    tinymce.get(elemento).getBody().setAttribute('contenteditable', true);
                } else {
                    tinymce.get(elemento).getBody().setAttribute('contenteditable', false);
                }
                return false;
            }


            if ($(this).prop("checked")) {

                $("#" + elemento).removeAttr('disabled');
            } else {
                $("#" + elemento).attr('disabled', 'disabled');
            }
            return false;
        })



    });

})(jQuery);
</script>
<script>
document.getElementById('imagenInput').addEventListener('change', function(event) {
    const selectedFile = event.target.files[0];
    const portadaImg = document.getElementById('portada');

    const reader = new FileReader();
    reader.onload = function() {
        portadaImg.src = reader.result;
    };
    reader.readAsDataURL(selectedFile);
});
</script>

<script>
(function($) {

    'use strict';

    $(function() {

        $("#btn_guardar").click(function() {

            const checkboxes = document.querySelectorAll('input[type="checkbox"].incluir');
            const checks = {};
            // Itera a través de los elementos checkbox
            checkboxes.forEach(checkbox => {
                // Obtiene el valor del atributo data-elemento
                const elemento = checkbox.getAttribute('data-elemento');
                // Asigna true si el checkbox está marcado, de lo contrario asigna false
                checks[elemento] = checkbox.checked;
            });

            // El objeto "valores" ahora contiene los valores correspondientes


            var portada = (checks["portada"]) ? $('#imagenInput')[0]
                .files[0] : null
            var info_1 = (checks["info_1"]) ? tinymce.get('info_1').getContent({
                    format: 'html'
                }) :
                null
            var nombre = (checks["nombre"]) ? $('#nombre').val() : null
            var nombre_formulario = $('#nombre_formulario').val()
            var apellidos = (checks["apellidos"]) ? $('#apellidos').val() : null
            var dni = (checks["dni"]) ? $('#dni').val() : null
            var telefono = (checks["telefono"]) ? $('#telefono').val() : null
            var email = (checks["email"]) ? $('#email').val() : null
            var pais = (checks["pais"]) ? $('#pais').val() : null
            var ciudad = (checks["ciudad"]) ? $('#ciudad').val() : null
            var direccion = (checks["direccion"]) ? $('#direccion').val() : null
            var info_2 = (checks["info_2"]) ? tinymce.get('info_2').getContent({
                    format: 'html'
                }) :
                null
            var info_3 = (checks["info_3"]) ? tinymce.get('info_3').getContent({
                    format: 'html'
                }) :
                null
            var autorizacion = (checks["autorizacion"]) ? document.querySelector(
                'input[name="autorizacion"]:checked').value : null

            var info_4 = (checks["info_4"]) ? tinymce.get('info_4').getContent({
                    format: 'html'
                }) :
                null
            var texto_modal = (checks["texto_modal"]) ? $('#texto_modal').val() : null
            var lottie_modal = (checks["lottie_modal"]) ? document.querySelector(
                'input[name="lottie_modal"]:checked').value : null
            autorizacion = (autorizacion == "Si") ? true : false

            console.log("portada: " + portada)
            console.log("info_1: " + info_1)
            console.log("nombre: " + nombre)
            console.log("apellidos: " + apellidos)
            console.log("dni: " + dni)
            console.log("telefono: " + telefono)
            console.log("email: " + email)
            console.log("pais: " + pais)
            console.log("ciudad: " + ciudad)
            console.log("direccion: " + direccion)
            console.log("info_2: " + info_2)
            console.log("info_3: " + info_3)
            console.log("autorizacion: " + autorizacion)
            console.log("info_4: " + info_4)
            console.log("texto_modal: " + texto_modal)
            console.log("lottie_modal: " + lottie_modal)
            if (nombre_formulario == "") {
                $.toast({
                    heading: 'Por favor ingresa un nombre.',
                    text: 'No se ha asignado ningún nombre al formulario.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $('#nombre_formulario').focus()
                return false;
            }
            if (portada === undefined) {
                $.toast({
                    heading: 'Por favor selecciona una portada.',
                    text: 'No se ha subido ninguna imágen de portada.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                var checkboxElement = $('input[type="checkbox"][data-elemento="portada"]');
                if (checkboxElement.length > 0) {
                    // Establece el foco en el elemento checkbox
                    checkboxElement.focus();
                }
                return false;
            }

            if (info_1 == "") {
                $.toast({
                    heading: 'Por favor ingresa una información principal.',
                    text: 'No se ha ingresado ninguna información.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                var tinymceEditor = tinymce.get('info_1');
                if (tinymceEditor) {
                    // Establece el foco en el editor
                    tinymceEditor.focus();
                }
                return false;
            }
            if (info_2 == "") {
                $.toast({
                    heading: 'Por favor ingresa una información secundaria.',
                    text: 'No se ha ingresado ninguna información.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                var tinymceEditor2 = tinymce.get('info_2');
                if (tinymceEditor2) {
                    // Establece el foco en el editor
                    tinymceEditor2.focus();
                }

                return false;
            }
            if (info_3 == "") {
                $.toast({
                    heading: 'Por favor ingresa una información terciaria.',
                    text: 'No se ha ingresado ninguna información.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                var tinymceEditor3 = tinymce.get('info_3');
                if (tinymceEditor3) {
                    // Establece el foco en el editor
                    tinymceEditor3.focus();
                }

                return false;
            }
            if (info_4 == "") {
                $.toast({
                    heading: 'Por favor ingresa una información adicional.',
                    text: 'No se ha ingresado ninguna información.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                var tinymceEditor4 = tinymce.get('info_4');
                if (tinymceEditor4) {
                    // Establece el foco en el editor
                    tinymceEditor4.focus();
                }

                return false;
            }
            var fd = new FormData();
            fd.append('portada', portada);
            fd.append('nombre_formulario', nombre_formulario);
            fd.append('info_1', info_1);
            fd.append('nombre', nombre);
            fd.append('apellidos', apellidos);
            fd.append('dni', dni);
            fd.append('telefono', telefono);
            fd.append('email', email);
            fd.append('pais', pais);
            fd.append('ciudad', ciudad);
            fd.append('direccion', direccion);
            fd.append('info_2', info_2);
            fd.append('info_3', info_3);
            fd.append('autorizacion', autorizacion);
            fd.append('info_4', info_4);
            fd.append('texto_modal', texto_modal);
            fd.append('lottie_modal', lottie_modal);
            $("#btn_guardar").attr("disabled", true);
            $("#btn_guardar").addClass("btn-loading");
            $.ajax({
                type: 'POST',
                url: './api/formularios.php',
                cache: false,
                data: fd,
                processData: false, // tell jQuery not to process the data
                contentType: false, // tell jQuery not to set contentType
                success: function(r) {
                    $.toast({
                        heading: 'Formulario creado',
                        text: 'Se ha creado el formulario correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                    var jsonObject = JSON.parse(r);
                    $("#btn_guardar").attr("disabled", false);
                    $("#btn_guardar").removeClass("btn-loading");


                    setTimeout(function() {
                            window.location.href = "./formulario?id=" + jsonObject
                                .id
                        },
                        2000);


                }

            });




        })


        $(document).on('click', 'lottie-player', function() {

            // Encuentra el elemento input inmediatamente detrás de lottie-player y marca (check) el input
            $(this).prev('input[name="lottie_modal"]').prop('checked', true);
        });

    });

})(jQuery);
</script>