<link rel="stylesheet" href="libraries/calendar/dist/fullcalendar.css" />
<style>
.delete_proyecto {

    position: absolute;

    z-index: 999;

    right: 0;

    top: 0;

    color: white;

    background-color: transparent;

    border: none;

    font-size: 1.6rem;

    padding: 0 0.3em;

}



.add_proyecto {

    position: absolute;

    z-index: 999;

    left: 0;

    top: 0;

    color: white;

    background-color: transparent;

    border: none;

    font-size: 1.6rem;

    padding: 0 0.3em;

}
</style>

<div class="content-wrapper">



    <div class="row profile-page mb-3">

        <div class="col-md-12 mb-8">

            <div class="card ">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/oddigoor.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Empleados totales</p>

                        <span class="">

                            <?php echo count($Empleados); ?>

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>





    <div class="row profile-page">

        <div class="col-12">





            <div class="row">

                <div class="col-12 mb-3">

                    <div class="card">

                        <div class="card-body p-3">

                            <div class="row">



                                <div class="col-md-6">

                                    <div class="row">

                                        <div class="col-4">

                                            <label class="custom-control custom-checkbox d-inline-block mb-3">

                                                <input type="checkbox" id="filtrar"
                                                    class="mb-0 custom-control-input apartado">

                                                <span class="custom-control-label">Filtrar por rango de fechas</span>

                                            </label>

                                        </div>

                                        <div class="col-4">

                                            <div class="form-group">



                                                <input class="form-control" id="fecha_i_filtro" type="date" disabled>

                                            </div>



                                        </div>



                                        <div class="col-4">

                                            <div class="form-group">



                                                <input id="fecha_f_filtro" type="date" class="form-control" disabled>

                                            </div>

                                        </div>





                                    </div>

                                    <div class="form-group">

                                        <h5 style="line-height: 1;">Seleccionar proyecto</h5>

                                        <div class="input-group">

                                            <span class="input-group-prepend">

                                                <button class="btn_eliminar_proyecto file-upload-browse btn btn-danger"
                                                    data-target="select_proyectos2" type="button">-</button>

                                            </span>

                                            <select id="select_proyectos2"
                                                class="select_proyectos custom-select select2 form-control">



                                            </select>

                                            <span class="input-group-append">

                                                <button class="file-upload-browse btn btn-info" type="button"
                                                    data-toggle="modal" data-target="#modalAgregarProyecto">+</button>

                                            </span>

                                        </div>

                                    </div>

                                    <div class="row">

                                        <div class="col-md-6">

                                            <h5 style="line-height: 1;" class="mb-3"><span
                                                    id="nombre_proyecto_header"></span>

                                            </h5>



                                            <p style="line-height: 1;" class="mb-2"><strong>Número de integrantes:

                                                </strong><span id="integrantes_proyecto_header"></span>

                                            </p>

                                            <p style="line-height: 1;" class="mb-2"><strong>Días totales trabajados:

                                                </strong><span id="horas_proyecto_header"></span>

                                            </p>

                                            <p style="line-height: 1;" class="mb-2"><strong>Coste de sueldos:

                                                </strong><span id="coste_proyecto_header"></span>

                                            </p>

                                            <p style="line-height: 1;" class="mb-2"><strong>Gastos adicionales:

                                                </strong><span id="gastos_proyecto_header"></span>

                                            </p>

                                            <p style="line-height: 1;" class="mb-2"><strong>Ingresos: </strong><span
                                                    id="ganancias_proyecto_header"></span>

                                            </p>

                                            <p style="line-height: 1;" class="mb-2"><strong>Costo total: </strong><span
                                                    id="total_proyecto_header"></span>

                                            </p>

                                            <p style="line-height: 1;" class="mb-0"><strong>Ganancia total:

                                                </strong><span id="gananciatotal_proyecto_header"></span>

                                            </p>

                                        </div>

                                        <div class="col-md-6">

                                            <div
                                                class="mb-2 d-flex flex-row justify-content-between align-items-center">

                                                <h5 style="line-height: 1;" class="mb-0"><span>Gastos adicionales</span>

                                                </h5>

                                                <a id="agregar_gasto" type="button"
                                                    style="padding-bottom: 2px !important;"
                                                    class="px-2 py-0 btn btn-sm btn-success"><i style="font-size:10px;"
                                                        class="m-0 fas fa-plus"></i></a>

                                            </div>



                                            <ul class="p-0" id="lista_gastos">





                                            </ul>



                                        </div>

                                    </div>



                                </div>





                                <div class="col-md-3 d-flex flex-column justify-content-start align-items-center">

                                    <h4 style="line-height: 1;" class="mb-3"><strong>Días: </strong></h4>

                                    <canvas style="max-width: 260px;max-height:260px;aspect-ratio:1/1"
                                        id="grafico_dias"></canvas>



                                </div>

                                <div class="col-md-3 d-flex flex-column justify-content-start align-items-center">

                                    <h4 style="line-height: 1;" class="mb-3"><strong>Costes/ganancias: </strong></h4>

                                    <canvas style="max-width: 260px;max-height:260px;aspect-ratio:1/1"
                                        id="grafico_cobrado"></canvas>



                                </div>

                            </div>

                        </div>

                    </div>

                </div>

                <script>
                (function($) {



                    'use strict';



                    $(function() {









                    });



                })(jQuery);
                </script>





                <div class="col-lg-3 col-xl-2">



                    <div id="lista_empleados" class="card">

                        <div class="h-100 w-100" id="capa_lista"
                            style="background-color:#ffffffd4;position:absolute;z-index:100;">

                        </div>

                        <div class="card-body p-3">

                            <div class="form-group mb-2">

                                <h4 class="mb-1">Empleados</h4>

                                <div id="calendar-events" style=" max-height:300px">



                                    <?php

                                                                foreach ($Empleados as $Empleado)

                                                                    {

                                                                    ?>

                                    <div class="calendar-events w-100" data-tipo="empleado" style=""
                                        data-id="<?php echo htmlentities($Empleado['id_empleado'], ENT_QUOTES); ?>">

                                        <i class="fas fa-user"></i>

                                        <?php echo htmlentities($Empleado['nombre'], ENT_QUOTES); ?>



                                    </div>

                                    <?php

                                                                    }

                                                                ?>

                                </div>



                            </div>



                            <div class="form-group mb-0">

                                <h4 class="mb-1">Grupos de trabajo</h4>

                                <div id="calendar-events2" class="mb-0" style="overflow-y: scroll; max-height:300px">



                                    <?php

                                                                foreach ($Grupos as $Grupo)

                                                                    {

                                                                    ?>

                                    <div class="calendar-events  w-100" data-tipo="grupo" style=""
                                        data-id="<?php echo htmlentities($Grupo['id_grupo2'], ENT_QUOTES); ?>">

                                        <i class="fas fa-users"></i>

                                        <?php echo htmlentities($Grupo['nombre'], ENT_QUOTES); ?>



                                    </div>

                                    <?php

                                                                    }

                                                                ?>

                                </div>

                            </div>







                        </div>

                    </div>

                </div>

                <div class="col-lg-9 col-xl-10">

                    <div class="card">

                        <div class="card-body b-l p-3 calender-sidebar">

                            <div id="calendar"></div>

                        </div>

                    </div>



                </div>

            </div>



        </div>

    </div>





</div>

<div class="modal fade" id="modalAsignarHorario" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Asignar un horario</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-6">

                            <div class="form-group">

                                <label for="my-input">Horario de entrada</label>

                                <input class="form-control" id="fecha_i_horario" type="time">

                            </div>



                        </div>



                        <div class="col-6">

                            <div class="form-group">

                                <label for="my-input">Horario de salida</label>

                                <input id="fecha_f_horario" type="time" class="form-control">

                            </div>

                        </div>





                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_add_horario" class="btn btn-success btn-fw" type="button">



                    Asignar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>

<div class="modal fade" id="modalEditarHorario" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Editar horario</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>



            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row mb-3">

                        <div class="col-6">

                            <div class="form-group">

                                <label for="my-input">Horario de entrada</label>

                                <input class="form-control" id="fecha_i_horario_editar" type="time">

                            </div>

                        </div>

                        <div class="col-6">

                            <div class="form-group">

                                <label for="my-input">Horario de salida</label>

                                <input id="fecha_f_horario_editar" type="time" class="form-control">

                            </div>

                        </div>

                        <div class="col-12 text-left mb-2">

                            <button id="btn_edit_horario" class="btn btn-success btn-fw" type="button">

                                Editar</button>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-12">

                            <h4 class="mb-3">Archivos</h4>

                            <div class="row">

                                <div class="col-12 col-md-6">

                                    <div class="form-group">

                                        <label for="my-input">Nombre</label>



                                        <input id="nombre_archivo" type="text" class="form-control">



                                    </div>



                                </div>

                                <div class="col-12 col-md-6">

                                    <div class="form-group">

                                        <label for="my-input">Archivo</label>

                                        <div class="input-group">

                                            <input type="file" class="d-none" id="archivo_file"
                                                accept=".png, .jpg, .pdf">

                                            <input disabled id="archivo_archivo" type="text" class="form-control"
                                                value="Ningún archivo seleccionado.">

                                            <div class="input-group-append">

                                                <label for="archivo_file" class="mb-0 btn btn-success btn-fw"
                                                    id="btn_subir_archivo" type="button">



                                                    Seleccionar archivo</label>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                                <div class="col-12 text-left mb-2">

                                    <button class="btn btn-success btn-fw" id="btn_add_archivo"
                                        type="button">Subir</button>

                                </div>

                            </div>

                            <div id="lista_archivos" class="row">



                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>

            </div>

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarGasto" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar gasto adicional</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Concepto</label>

                                <input class="form-control w-100" id="concepto_gasto" type="text">

                            </div>



                        </div>

                        <div class="col-12">



                            <div class="form-group">

                                <label for="my-input">Fecha</label>

                                <input class="form-control w-100" id="fecha_gasto" type="date">

                            </div>







                        </div>



                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Importe</label>

                                <input id="importe_gasto" type="number" class="form-control" step="any">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Observaciones</label>

                                <textarea id="observaciones_gasto" type="text" class="form-control m-0"
                                    style="height: 184px !important;"></textarea>

                            </div>

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_add_gasto" class="btn btn-success btn-fw" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>

<div class="modal fade" id="modalEditarGasto" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Editar gasto adicional</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Concepto</label>

                                <input class="form-control w-100" id="concepto_gasto_editar" type="text">

                            </div>



                        </div>

                        <div class="col-12">



                            <div class="form-group">

                                <label for="my-input">Fecha</label>

                                <input class="form-control w-100" id="fecha_gasto_editar" type="date">

                            </div>







                        </div>



                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Importe</label>

                                <input id="importe_gasto_editar" type="number" class="form-control" step="any">

                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Observaciones</label>

                                <textarea id="observaciones_gasto_editar" type="text" class="form-control m-0"
                                    style="height: 184px !important;"></textarea>

                            </div>

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_edit_gasto" class="btn btn-success btn-fw" type="button">



                    Editar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>

<div class="modal fade modal-cambiar" id="modalEliminarGasto" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar gasto</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el gasto adicional definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_gasto">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalVerArchivo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_archivo" class="modal-body">

                <!-- btn -->











            </div>



            <!-- /btn -->





            <!-- /modal-body -->

        </div>

    </div>

</div>

<style>
.btn_del_trabajador {

    cursor: pointer;

}



.calendar-events {

    cursor: grabbing;

}





#calendar .fc-header-toolbar .fc-button-group .fc-button.fc-state-active {

    background-color:

        <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);

    ?> !important;

}



#calendar .fc-header-toolbar .fc-center {

    vertical-align: middle;

}



#calendar .fc-header-toolbar .fc-button-group button {

    padding: 0.5rem;

    font-size: 16px !important;

    line-height: .3;

    margin-left: 0;

    margin-right: 0rem;

}



#calendar .fc-header-toolbar .fc-today-button,

#calendar .fc-header-toolbar .fc-customButton-button {

    padding: 0.5rem;

    font-size: 16px !important;

    line-height: .3;

    margin-left: 0;

    margin-right: 1rem;

}



#calendar .fc-header-toolbar {



    padding: 0 !important;



    margin-bottom: 1rem !important;

}



#calendar .fc-header-toolbar .fc-button-group .fc-button.fc-state-active {

    background-color:

        <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);

    ?> !important;

}



#calendar .fc-header-toolbar .fc-button-group .fc-button.fc-next-button,

#calendar .fc-header-toolbar .fc-button-group .fc-button.fc-prev-button {



    background-color: transparent !important;

    opacity: 1;

}



#calendar .fc-header-toolbar .fc-button-group .fc-button {

    background-color:

        <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);

    ?> !important;

    opacity: .8;

}



#calendar .fc-header-toolbar .fc-button-group .fc-button.fc-state-active {

    background-color:

        <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);

    ?> !important;

    opacity: 1;

}



#calendar .fc-header-toolbar .fc-today-button {

    background-color:

        <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);

    ?> !important;



}



#calendar .fc-time {

    font-size: 12px !important;



}



#calendar td.fc-day-top {



    padding-bottom: 0px !important;

}



#calendar .fc-header-toolbar .fc-button-group .fc-button.fc-next-button,

#calendar .fc-header-toolbar .fc-button-group .fc-button.fc-prev-button {

    color:

        <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);

    ?> !important;

}



.btn_del_trabajador i {

    transition: all .2s ease;



}



.btn_del_trabajador i {

    transition: all .2s ease;

}



.btn_del_trabajador:hover i {

    transform: scale(1.1);

}
</style>



<!-- MODALS -->





















<style>
.asColorPicker-trigger {

    padding: 0px;

    width: 34px;

    height: 34px;

    border: none;

}



.asColorPicker-trigger span {

    width: 34px;

    height: 34px;

}



.marg-btn-modal {

    margin-bottom: 3rem;

}



.td-id {

    padding-left: 32px !important;

    padding-right: 50px;

}



.button-red {

    padding-bottom: 5px !important;

}



.button-blue {



    padding-bottom: 5px !important;

}



th {

    padding-right: 28px !important;

    padding-left: 28px !important;

}



.td-tablet {

    padding-right: 28px !important;

    padding-left: 29px !important;

}



.p-cuenta-left-title {

    font-size: 24px;

    margin-bottom: 0;

}



.p-cuenta-left-email {

    font-size: 20px;

    margin-bottom: 0;

}



.p-cuenta-left-email img {

    width: 20px;

    height: 20px;

}



.p-cuenta-left-email a {

    color: #fff;

}



.fc button {

    font-size: 1.2em !important;



}



.p-cuenta-img {

    width: 100px;

    height: 100px;

    border-radius: 50%;



    background: transparent;

    padding: 2px !important;

    cursor: pointer;

}



.btn_eliminar_horario {

    transition: all 0.3s ease;

}



.btn_eliminar_horario:hover {

    transform: scale(1.3);

    color: #f1635f !important;

}



.p-cuenta-img-bg {

    display: none !important;

    width: 100px;

    height: 100px;

    border-radius: 50%;

    position: absolute;

    background: rgba(255, 93, 177, 0);

    background: -moz-linear-gradient(top, rgba(255, 93, 177, 0) 0%, rgba(0, 0, 0, 0) 50%, black 51%);

    background: -webkit-gradient(left top, left bottom, color-stop(0%, rgba(255, 93, 177, 0)), color-stop(50%, rgba(0, 0, 0, 0)), color-stop(51%, black));

    background: -webkit-linear-gradient(top, rgba(255, 93, 177, 0) 0%, rgba(0, 0, 0, 0) 50%, black 51%);

    background: -o-linear-gradient(top, rgba(255, 93, 177, 0) 0%, rgba(0, 0, 0, 0) 50%, black 51%);

    background: -ms-linear-gradient(top, rgba(255, 93, 177, 0) 0%, rgba(0, 0, 0, 0) 50%, black 51%);

    background: -webkit-gradient(linear, left top, left bottom, from(rgba(255, 93, 177, 0)), color-stop(50%, rgba(0, 0, 0, 0)), color-stop(51%, black));

    background: linear-gradient(to bottom, rgba(255, 93, 177, 0) 0%, rgba(0, 0, 0, 0) 50%, black 51%);

    content: '';

    left: 0;

    position: absolute;

    right: 0;

    top: 100%;

    -webkit-transition: top .13s ease-out;

    -o-transition: top .13s ease-out;

    transition: top .13s ease-out;

    z-index: 1;

    color: #fff;

    display: block;

    margin-right: auto;

    margin-left: auto;

    top: 0;

    cursor: pointer;

    opacity: .6;

}



.p-cuenta-img-cambiar {

    display: none;

    color: #fff;

    position: absolute;

    bottom: 30px;

    font-size: 11pt;

    margin-right: auto;

    margin-left: auto;

    right: 0;

    left: 0;

    z-index: 2;

    cursor: pointer;

}



.p-cuenta-img-content:hover .p-cuenta-img-bg {

    display: block !important;

}







.p-cuenta-img-content:hover .p-cuenta-img-cambiar {

    display: block !important;

}



#calendar .fc-header-toolbar .fc-customButton-button {

    box-shadow: none;

    padding: 1px 12px;

    border-radius: 2px;

    margin-right: 4px;

    font-size: .9375rem;

    font-weight: 400;

    line-height: 1.33;

    border: none;

    background: #269bff;

    color: #fff;

    text-shadow: none;

    -webkit-transition-duration: .3s;

    -moz-transition-duration: .3s;

    -o-transition-duration: .3s;

    transition-duration: .3s;

}
</style>



<style>
.archivo_lista {

    cursor: pointer;

    transition: all .3s ease;

    position: relative;

    height: 100%;

    width: 100%;

    background: #0000001a;

    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    aspect-ratio: 1/1;

    border-radius: 2% !important;

}



.archivo_lista img {

    object-fit: cover;

    max-height: 200px;

}



.archivo_lista:hover {

    opacity: .5;

    background: #000000;

}



.btn_eliminar_archivo {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    right: 0;

    top: 0;

    border-radius: 10% !important;

}



.archivo_lista:hover .btn_eliminar_archivo {

    opacity: 1;

}



.btn_eliminar_archivo i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #F1635F;

}



.btn_eliminar_archivo:hover i:before {

    color: #F1635F;

}



.btn_seleccionar_archivo {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    left: 0;

    top: 0;

    border-radius: 10% !important;

}



.archivo_lista:hover .btn_seleccionar_archivo {

    opacity: 1;

}



.btn_seleccionar_archivo i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #0cca8e;

}



.btn_seleccionar_archivo:hover i:before {

    color: #0cca8e;

}



.nombre_archivo_div {

    position: absolute;

    font-size: 18px;

    border-radius: 4px;

    transition: all .3s ease;

    opacity: 0;

    color: white;

    background-color: black;

    padding: .5rem;

    cursor: pointer;

}



.col-sm-3:hover .nombre_archivo_div {

    opacity: 1;

}



#lista_archivos {

    max-height: 723px;

    overflow-y: scroll;

}
</style>

<?php require_once __VIEWS__ . 'selects/proyectos.template.php'; ?>



<?php require_once __VIEWS__ . 'selects/empleados.template.php'; ?>



<script>
(function($) {



    'use strict';



    $(function() {



        $(document).on("click", ".fc-customButton-button", function() {



            var id_proyecto = $('#select_proyectos2').val()



            $.ajax({

                url: "./api/calendario.php?id_proyecto=" + id_proyecto,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(dat) {

                    const cd = dat



                    descargarArchivo(cd, "Informe " + "Informe de proyectos")

                    // console.log(descargarArchivo(c, "archivo_descargado"));

                }

            })

        });



        function obtenerMeses(datos) {

            // Objeto para almacenar los objetos agrupados por mes

            var meses = {};



            // Recorrer los datos para agruparlos por mes

            datos.forEach(function(objeto) {

                var fecha = new Date(objeto["Fecha de inicio"]);

                var mes = fecha.toLocaleString('default', {

                    month: 'long'

                }); // Obtener el nombre del mes



                // Si el mes aún no está en el objeto meses, crear un arreglo vacío para ese mes

                if (!meses[mes]) {

                    meses[mes] = [];

                }



                // Agregar el objeto al arreglo correspondiente al mes

                meses[mes].push(objeto);

            });



            return meses;

        }



        function descargarArchivo(datos, nombreArchivo) {

            // Crear un nuevo libro de Excel



            var libro = XLSX.utils.book_new();



            for (let dato of datos) {

                var copiaArray = [...dato.horarios_asignados];

                for (var objeto of copiaArray) {





                    objeto["Fecha de inicio"] = objeto.fecha_i;

                    objeto["Fecha de fin"] = objeto.fecha_f;



                    if (objeto.grupo === null) {

                        objeto.Grupo = "Ninguno";

                    } else {

                        objeto.Grupo = objeto.grupo.nombre;

                        // console.log(JSON.parse(objeto.Empleados));

                        var emple = ""

                        for (var emp of objeto.grupo.empleados) {



                            emple += emp.nombre

                            emple += "/"



                        }

                        objeto.Empleados = emple

                    }

                    if (objeto.empleado === null) {

                        objeto.Empleado = "Ninguno";

                    } else {

                        objeto.Empleado = objeto.empleado.nombre;

                        objeto.Empleados = objeto.empleado.nombre

                    }

                    delete objeto.fecha_i;

                    delete objeto.fecha_f;

                    delete objeto.id_proyecto;

                    delete objeto.id_proyecto_empleado;

                    delete objeto.id_empleado;

                    delete objeto.id_grupo2;

                    delete objeto.empleado;

                    delete objeto.grupo;

                }







                const reorganizedData = reorganizeData(copiaArray);

                console.log(reorganizedData);

                var hoja = XLSX.utils.aoa_to_sheet([]);

                // Llenar la hoja con los datos de copiaArray

                // Crear y agregar la fila de título

                var titulo = [

                    [dato.nombre]

                ];

                XLSX.utils.sheet_add_aoa(hoja, titulo, {

                    origin: "A1"

                });



                // Crear y agregar la fila de encabezado

                var headers = ["Año", "Mes", "Día", "Horario entrada", "Horario salida", "Grupo",

                    "Empleados", "Gastos", "Ganancias"

                ];

                XLSX.utils.sheet_add_aoa(hoja, [headers], {

                    origin: "A2"

                });



                // Inicializar la fila de datos en la tercera fila

                var currentRow = 3;



                for (var year in reorganizedData) {

                    if (reorganizedData.hasOwnProperty(year)) {

                        var yearData = reorganizedData[year];

                        var yearStartRow = currentRow;



                        for (var month in yearData) {

                            if (yearData.hasOwnProperty(month)) {

                                var monthData = yearData[month];

                                var monthStartRow = currentRow;



                                // Añadir los datos de cada mes

                                for (var i = 0; i < monthData.length; i++) {

                                    var objeto = monthData[i];

                                    var row = [year, month];

                                    for (var key in objeto) {

                                        if (objeto.hasOwnProperty(key)) {

                                            row.push(objeto[key]);

                                        }

                                    }

                                    row.push(''); // Añadir columna "Gastos" vacía

                                    row.push('');

                                    XLSX.utils.sheet_add_aoa(hoja, [row], {

                                        origin: `A${currentRow}`

                                    });

                                    currentRow++;

                                }



                                // Fusionar las celdas del mes

                                if (!hoja["!merges"]) hoja["!merges"] = [];

                                hoja["!merges"].push({

                                    s: {

                                        r: monthStartRow - 1,

                                        c: 1

                                    },

                                    e: {

                                        r: currentRow - 2,

                                        c: 1

                                    }

                                });

                            }

                        }



                        // Fusionar las celdas del año

                        if (!hoja["!merges"]) hoja["!merges"] = [];

                        hoja["!merges"].push({

                            s: {

                                r: yearStartRow - 1,

                                c: 0

                            },

                            e: {

                                r: currentRow - 2,

                                c: 0

                            }

                        });

                    }

                }

                var finalRow = Array(headers.length - 2).fill(

                    ''); // Rellenar con celdas vacías menos dos para "Gastos" y "Ganancias"

                finalRow.push(parseFloat(dato.coste_total + dato.gastos_adicionales).toFixed(2));

                finalRow.push(parseFloat(dato.total_cobrado).toFixed(2));

                XLSX.utils.sheet_add_aoa(hoja, [finalRow], {

                    origin: `A${currentRow}`

                });

                console.log("qe onda");

                // Calcular el rango de las columnas para la fusión del título

                var range = XLSX.utils.decode_range(hoja["!ref"]);

                var endCol = String.fromCharCode(65 + range.e.c); // 65 es el código ASCII de 'A'



                // Fusionar la primera fila para el título

                if (!hoja["!merges"]) hoja["!merges"] = [];

                hoja["!merges"].push({

                    s: {

                        r: 0,

                        c: 0

                    },

                    e: {

                        r: 0,

                        c: range.e.c

                    }

                });



                // Añadir la hoja al libro

                XLSX.utils.book_append_sheet(libro, hoja, dato.nombre);

            }



            // Crear un archivo Excel en formato Base64

            const u8 = XLSX.write(libro, {

                bookType: "xlsx",

                type: "buffer"

            });

            const parts = [u8]; // `Blob` constructor expects this

            /* create Blob */

            const blob = new Blob(parts, {

                type: "application/download"

            });

            var enlaceDescarga = document.createElement('a');

            enlaceDescarga.href = window.URL.createObjectURL(blob);

            enlaceDescarga.download = nombreArchivo + ".xlsx";



            // Agregar el enlace al documento y simular el clic para iniciar la descarga

            document.body.appendChild(enlaceDescarga);

            enlaceDescarga.click();



            // Eliminar el enlace después de la descarga

            document.body.removeChild(enlaceDescarga);

        }



        function reorganizeData(data) {

            const result = {};

            const monthNames = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto",

                "Septiembre", "Octubre", "Noviembre", "Diciembre"

            ];

            const dayNames = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];

            data.forEach(item => {

                const startDate = new Date(item['Fecha de inicio']);

                const endDate = new Date(item['Fecha de fin']);

                const year = startDate.getFullYear();

                const month = monthNames[startDate

                    .getMonth()]; // getMonth() returns 0 for January, 1 for February, etc.



                const dayName = dayNames[startDate.getDay()];

                const dayNumber = startDate.getDate();

                const day = `${dayName} ${dayNumber}`;



                if (!result[year]) {

                    result[year] = {};

                }



                if (!result[year][month]) {

                    result[year][month] = [];

                }



                // Create new item with formatted time and renamed keys

                const newItem = {

                    "Día": day,

                    "Horario entrada": startDate.toTimeString().slice(0, 5), // HH:MM

                    "Horario salida": endDate.toTimeString().slice(0, 5), // HH:MM

                    "Grupo": item["Grupo"],

                    "Empleados": item["Empleados"]

                };



                result[year][month].push(newItem);

            })



            for (const year in result) {

                if (result.hasOwnProperty(year)) {

                    for (const month in result[year]) {

                        if (result[year].hasOwnProperty(month)) {

                            result[year][month].sort((a, b) => {

                                const dayA = new Date(`${a["Día"].split(" ")[1]} ${month} ${year}`);

                                const dayB = new Date(`${b["Día"].split(" ")[1]} ${month} ${year}`);

                                return dayA - dayB;

                            });

                        }

                    }

                }

            }

            return result;

        }



        // Función para convertir una cadena Base64 en un objeto Blob



    });







})(jQuery);
</script>

<script src="libraries/moment/moment.js"></script>

<script src="libraries/calendar/jquery-ui.min.js"></script>



<script src='libraries/calendar/dist/fullcalendar.min.js'></script>

<script src="libraries/calendar/dist/locale-all.js"></script>





<script>
! function($) {

    "use strict";











    var CalendarApp = function() {

        this.$body = $("body")

        this.$calendar = $('#calendar'),

            this.$event = $('div.calendar-events'),

            this.$categoryForm = $('#add-new-event form'),

            this.$extEvents = $('#calendar-events'),

            this.$modal = $('#modalAsignarProyecto'),

            this.$saveCategoryBtn = $('.save-category'),

            this.$calendarObj = null



    };



    function renderEvent(id) {

        //$('#calendar').fullCalendar('removeEvents', "1");



        $.ajax({

            url: "./api/calendario.php?id_proyecto_empleado=" + id,

            type: 'GET',

            dataType: 'json', // added data type

            cache: false,

            async: false,

            success: function(c) {



                $('#calendar').fullCalendar('removeEvents', id);

                var color = c.proyecto.color

                var nombre = c.proyecto.nombre



                let data = {

                    id: c.id_proyecto_empleado,

                    title: nombre,

                    start: c.fecha_i,

                    end: c.fecha_f,

                    className: 'horario',

                    id_empleado: c.id_empleado,

                    id_proyecto: c.id_proyecto,

                    id_grupo2: c.id_grupo2,

                    id_proyecto_empleado: c.id_proyecto_empleado,

                    empleado: c.empleado,

                    grupo2: c.grupo,

                    color: color

                }

                $('#calendar').fullCalendar('renderEvent', data, true);

                DisplayGraficos()

            }

        })

    }



    function getComplementaryColors(color) {

        // Convertimos el color hexadecimal a RGB

        const r = parseInt(color.slice(1, 3), 16);

        const g = parseInt(color.slice(3, 5), 16);

        const b = parseInt(color.slice(5), 16);



        // Obtenemos el color complementario restando cada componente RGB de 255

        const complementary1 =

            `#${(255 - r).toString(16).padStart(2, '0')}${(255 - g).toString(16).padStart(2, '0')}${(255 - b).toString(16).padStart(2, '0')}`;

        const complementary2 =

            `#${(255 - g).toString(16).padStart(2, '0')}${(255 - b).toString(16).padStart(2, '0')}${(255 - r).toString(16).padStart(2, '0')}`;



        return [complementary1, complementary2];

    }



    //console.log(Chart.controllers.doughnut.overrides.plugins.legend)







    var newLegendClickHandler = function(e, legendItem, legend) {

        //console.log(legendItem);

        console.log(legend.legendItems);

        var index2 = legendItem.index;



        var ci = legend.chart;



        if (ci.isDatasetVisible(0, index2)) {

            //console.log(ci.hide(0, index2));

            ci.hide(0, index2);

            legend.legendItems[index2].hidden = true;

        } else {

            // console.log(ci.show(0, index2));

            ci.show(0, index2);

            legend.legendItems[index2].hidden = false;

        }



        var datasets = legend.legendItems;

        var allVisible = datasets.every(dataset => !dataset.hidden);



        console.log(allVisible);



        if (!allVisible) {

            // Calcular la suma total de todos los valores (incluyendo ocultos)

            var total = legend.legendItems.reduce((acc, dataset) => {

                if (!dataset.hidden) {

                    acc += dataset.data.reduce((sum, value) => sum + value, 0);

                }

                return acc;

            }, 0);



            // Agregar un nuevo dataset llamado "total"

            ci.data.datasets.push({

                label: 'Total',

                data: [total],

                backgroundColor: 'rgba(200, 200, 200, 0.6)'

            });



            ci.update();

        }



    };



    $(document).on("click", ".editar_gasto ", function() {



        $("#btn_edit_gasto").data("id", $(this).data("id"))

        $("#btn_edit_gasto").data("proyecto", $(this).data("proyecto"))

        $.ajax({

            type: "GET",

            url: "./api/proyectos.php?id_gasto_proyecto=" + $(this).data("id"),

            cache: false,

            async: false,

            dataType: "json",

            success: function(response) {

                console.log(response);

                $('#concepto_gasto_editar').val(response.concepto)

                $('#fecha_gasto_editar').val(response.fecha)

                $("#importe_gasto_editar").val(response.importe)

                $("#observaciones_gasto_editar").val(response.observaciones)

                $("#modalEditarGasto").modal("show")

            }

        })





    })

    $(document).on("click", ".eliminar_gasto ", function() {



        $("#btn_eliminar_gasto").data("id", $(this).data("id"))

        $("#modalEliminarGasto").modal("show")







    })

    $('#btn_eliminar_gasto').click(function(event) {

        var id_gasto_proyecto = $("#btn_eliminar_gasto").data("id")

        $.ajax({

            type: 'DELETE',

            url: './api/proyectos.php?id_gasto_proyecto=' + id_gasto_proyecto,

            cache: false,

            async: false,

            success: function(result) {



                $('#modalEliminarGasto').modal("hide")

                $.toast({

                    heading: 'Gasto eliminado',

                    text: 'Se ha eliminado el gasto correctamente',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })

                DisplayGraficos()



            }

        });

        return false;

    });

    $("#btn_edit_gasto").click(function() {

        var id_gasto_proyecto = $("#btn_edit_gasto").data("id")

        var id_proyecto = $("#btn_edit_gasto").data("proyecto")

        var concepto = $('#concepto_gasto_editar').val()

        var fecha = moment($('#fecha_gasto_editar').val()).format(

            'YYYY-MM-DD')

        var importe = $("#importe_gasto_editar").val()

        var observaciones = $("#observaciones_gasto_editar").val()





        if (concepto == "") {



            $.toast({

                heading: 'Por favor selecciona un concepto.',

                text: 'No se ha asignado un concepto al gasto adicional.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }

        if (importe == "") {



            $.toast({

                heading: 'Por favor selecciona un importe.',

                text: 'No se ha asignado un importe al gasto adicional.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }

        if (fecha == "") {



            $.toast({

                heading: 'Por favor selecciona una fecha.',

                text: 'No se ha asignado una fecha al gasto adicional.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }





        $.ajax({

            type: 'POST',

            url: './api/proyectos.php',

            cache: false,

            async: false,

            dataType: "json",

            data: {

                concepto: concepto,

                fecha: fecha,

                importe: importe,

                observaciones: observaciones,

                observaciones: observaciones,

                id_proyecto: id_proyecto,

                id_gasto_proyecto: id_gasto_proyecto

            },

            success: function(r) {

                console.log(r);

                $('#modalEditarGasto').modal("hide")



                $.toast({

                    heading: 'Gasto editado.',

                    text: 'Se ha editado el gasto adicional correctamente.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                });

                $("#modalEditarGasto input").each(function() {

                    $(this).val("")

                })

                DisplayGraficos()



            }

        });

    })



    $("#btn_add_gasto").click(function() {



        var concepto = $('#concepto_gasto').val()

        var fecha = moment($('#fecha_gasto').val()).format(

            'YYYY-MM-DD')

        var importe = $("#importe_gasto").val()

        var observaciones = $("#observaciones_gasto").val()

        var id_proyecto = $("#select_proyectos2").val()



        if (concepto == "") {



            $.toast({

                heading: 'Por favor selecciona un concepto.',

                text: 'No se ha asignado un concepto al gasto adicional.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }

        if (importe == "") {



            $.toast({

                heading: 'Por favor selecciona un importe.',

                text: 'No se ha asignado un importe al gasto adicional.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }

        if (fecha == "") {



            $.toast({

                heading: 'Por favor selecciona una fecha.',

                text: 'No se ha asignado una fecha al gasto adicional.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }





        $.ajax({

            type: 'POST',

            url: './api/proyectos.php',

            cache: false,

            async: false,

            dataType: "json",

            data: {

                concepto: concepto,

                fecha: fecha,

                importe: importe,

                observaciones: observaciones,

                id_proyecto: id_proyecto

            },

            success: function(r) {

                console.log(r);

                $('#modalAgregarGasto').modal("hide")



                $.toast({

                    heading: 'Gasto agregado.',

                    text: 'Se ha agregado el gasto adicional correctamente.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                });

                $("#modalAgregarGasto input").each(function() {

                    $(this).val("")

                })

                DisplayGraficos()



            }

        });

    })

    $("#agregar_gasto").click(function(e) {

        if ($("#select_proyectos2").val() == "No") {

            $.toast({

                heading: 'Por favor selecciona un proyecto.',

                text: 'No se ha seleccionado ningún proyecto para agregar el gasto.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }

        $("#modalAgregarGasto").modal("show")

    });



    function DisplayGraficos() {

        var id_proyecto = $("#select_proyectos2").val();

        var is_checked = $("#filtrar").is(":checked");



        var fecha_i = "No";

        var fecha_f = "No";

        if (is_checked) {

            fecha_i = $("#fecha_i_filtro").val();

            fecha_f = $("#fecha_f_filtro").val();

        }



        var canvasElement = document.getElementById('grafico_cobrado');

        var donutChart = Chart.getChart(canvasElement);

        var canvasElement2 = document.getElementById('grafico_dias');

        var donutChart2 = Chart.getChart(canvasElement2);



        if (donutChart) {

            donutChart.destroy();

        }

        if (donutChart2) {

            donutChart2.destroy();

        }



        var url = (fecha_i != "No" && fecha_f != "No") ? "?id_proyecto=" + id_proyecto + "&fecha_i=" + fecha_i +

            "&fecha_f=" + fecha_f : "?id_proyecto=" + id_proyecto;



        $.ajax({

            url: "./api/calendario.php" + url,

            type: 'GET',

            dataType: 'json',

            cache: false,

            async: false,

            success: function(proyectos) {

                console.log(proyectos);

                if (!Array.isArray(proyectos)) {

                    proyectos = [proyectos];

                }



                var total_cobrado = 0;

                var coste_total = 0;

                var cantidadEmpleadosSet = new Set();

                var diasTrabajadosTotal = 0;

                var nombreProyectos = [];

                var gastosAdicionalesTotal = 0;

                var tiempoTotalMinutos = 0;

                document.getElementById('lista_gastos').innerHTML = ""

                proyectos.forEach(function(proyecto) {

                    total_cobrado += parseFloat(proyecto.total_cobrado);

                    coste_total += parseFloat(proyecto.coste_total);

                    gastosAdicionalesTotal += parseFloat(proyecto.gastos_adicionales);

                    tiempoTotalMinutos += proyecto.tiempo_total;

                    diasTrabajadosTotal += proyecto.horarios_asignados.length;

                    nombreProyectos.push(proyecto.nombre);



                    proyecto.horarios_asignados.forEach(function(horario) {

                        if (horario.id_empleado != null) {

                            cantidadEmpleadosSet.add(horario.id_empleado);

                        } else {

                            horario.grupo.empleados.forEach(function(empleado) {

                                cantidadEmpleadosSet.add(empleado.id_empleado);

                            });

                        }

                    });



                    proyecto.gastos_proyecto.forEach(function(gasto) {

                        var liElement = document.createElement('li');

                        liElement.className =

                            'd-flex flex-row justify-content-between align-items-center mb-2';



                        // Crear el elemento <span>

                        var spanElement = document.createElement('span');

                        spanElement.style.lineHeight = '1';

                        spanElement.textContent = gasto.concepto + ": " + formatearNumero(

                                parseFloat(

                                    gasto.importe).toFixed(2)) +

                            "€";



                        // Añadir el <span> al <li>

                        liElement.appendChild(spanElement);



                        // Crear el contenedor <div>

                        var divElement = document.createElement('div');

                        divElement.className =

                            'd-flex flex-row justify-content-center align-items-center';



                        // Crear el botón de editar

                        var editButton = document.createElement('a');

                        editButton.type = 'button';

                        editButton.className =

                            'px-2 py-0 mr-1 editar_gasto btn btn-sm btn-info';

                        editButton.style.paddingBottom = '2px';



                        // Crear el icono de editar

                        var editIcon = document.createElement('i');

                        editIcon.style.fontSize = '10px';

                        editIcon.className = 'm-0 fas fa-pencil-alt';



                        // Añadir el icono al botón de editar

                        editButton.appendChild(editIcon);

                        editButton.setAttribute("data-id", gasto.id_gasto_proyecto)

                        editButton.setAttribute("data-proyecto", gasto.id_proyecto)

                        editButton.style.cssText += 'padding-bottom: 2px !important;';

                        // Crear el botón de eliminar

                        var deleteButton = document.createElement('a');

                        deleteButton.type = 'button';

                        deleteButton.className =

                            'px-2 py-0 eliminar_gasto btn btn-sm btn-danger';

                        deleteButton.style.paddingBottom = '2px';

                        deleteButton.setAttribute("data-id", gasto.id_gasto_proyecto)

                        deleteButton.style.cssText += 'padding-bottom: 2px !important;';

                        // Crear el icono de eliminar

                        var deleteIcon = document.createElement('i');

                        deleteIcon.style.fontSize = '10px';

                        deleteIcon.className = 'm-0 fas fa-trash-alt';





                        // Añadir el icono al botón de eliminar

                        deleteButton.appendChild(deleteIcon);



                        // Añadir los botones al <div>

                        divElement.appendChild(editButton);

                        divElement.appendChild(deleteButton);



                        // Añadir el <div> al <li>

                        liElement.appendChild(divElement);



                        // Añadir el <li> al contenedor deseado en el DOM

                        // Por ejemplo, si quieres añadirlo a un <ul> con id="myList":

                        document.getElementById('lista_gastos').appendChild(liElement);

                    });



                });



                var cantidadEmpleados = cantidadEmpleadosSet.size;

                var tiempo_total = convertirMinutosAHorasYMinutos(tiempoTotalMinutos);

                var [complementary1, complementary2] = getComplementaryColors(proyectos[0].color);



                var diastotales = (fecha_i != "No" && fecha_f != "No") ? Math.floor((new Date(fecha_f) -

                    new Date(fecha_i)) / (1000 * 60 * 60 * 24)) : 0;



                $("#nombre_proyecto_header").text((nombreProyectos.length == 1) ? nombreProyectos[0] :

                    "Todos los proyectos");

                $("#horas_proyecto_header").text(diasTrabajadosTotal + " días.");

                $("#coste_proyecto_header").text(formatearNumero(coste_total.toFixed(2)) + "€");

                $("#integrantes_proyecto_header").text(cantidadEmpleados);

                $("#gastos_proyecto_header").text(formatearNumero(gastosAdicionalesTotal.toFixed(2)) + "€");

                $("#ganancias_proyecto_header").text(formatearNumero(total_cobrado.toFixed(2)) + "€");

                $("#total_proyecto_header").text(formatearNumero((coste_total + gastosAdicionalesTotal)

                    .toFixed(2)) + "€");

                $("#gananciatotal_proyecto_header").text(formatearNumero((total_cobrado - (coste_total +

                    gastosAdicionalesTotal)).toFixed(2)) + "€");



                var costeTotal2 = coste_total + gastosAdicionalesTotal;

                var gananciaTotal = total_cobrado - costeTotal2;

                var ganancia = (gananciaTotal > 0) ? gananciaTotal : 0;



                var data = {

                    labels: ['Ganancias total', 'Costo total'],

                    datasets: [{

                        data: ganancia == 0 && coste_total == 0 ? [1] : [ganancia, costeTotal2],

                        backgroundColor: ganancia == 0 && coste_total == 0 ? [

                            'rgba(200, 200, 200, 0.6)'

                        ] : [proyectos[0].color, complementary2]

                    }]

                };



                var data2 = {

                    labels: ['Días trabajados', 'Días no trabajados'],

                    datasets: [{

                        data: diasTrabajadosTotal == 0 && diastotales == 0 ? [1] : [

                            diasTrabajadosTotal, (diastotales > 0) ? diastotales -

                            diasTrabajadosTotal : 0

                        ],

                        backgroundColor: diasTrabajadosTotal == 0 && diastotales == 0 ? [

                            'rgba(200, 200, 200, 0.6)'

                        ] : [proyectos[0].color, complementary2]

                    }]

                };



                var options = {

                    plugins: {

                        tooltip: {

                            callbacks: {

                                label: function(context) {

                                    const dataset = context.dataset;

                                    const value = dataset.data[context.dataIndex];

                                    const total = dataset.data.reduce((acc, val) => acc + val);

                                    const percentage = Math.floor(((value / total) * 100) + 0.5);

                                    return `${formatearNumero(parseFloat(value).toFixed(2))}€ (${percentage}%)`;

                                },

                                title: function(context) {

                                    const label = context[0].label;

                                    return label + ":";

                                }

                            }

                        },

                        legend: {

                            fullSize: false,

                            position: 'bottom',

                            labels: {

                                usePointStyle: true,

                                pointStyle: "circle",

                                lineHeight: 1

                            }

                        }

                    }

                };



                var options2 = {

                    plugins: {

                        tooltip: {

                            callbacks: {

                                label: function(context) {

                                    const dataset = context.dataset;

                                    const value = dataset.data[context.dataIndex];

                                    const total = dataset.data.reduce((acc, val) => acc + val);

                                    const percentage = Math.floor(((value / total) * 100) + 0.5);

                                    return dataset.data[0] != 0 ? `${value} (${percentage}%)` :

                                        `${value}`;

                                },

                                title: function(context) {

                                    const label = context[0].label;

                                    return label + ":";

                                }

                            }

                        },

                        legend: {

                            position: 'bottom',

                            labels: {

                                usePointStyle: true,

                                pointStyle: "circle",

                                lineHeight: 1

                            }

                        }

                    }

                };



                var donutChart = new Chart(document.getElementById('grafico_cobrado'), {

                    type: 'doughnut',

                    data: data,

                    options: options

                });



                var donutChart2 = new Chart(document.getElementById('grafico_dias'), {

                    type: 'doughnut',

                    data: data2,

                    options: options2

                });



            }

        });

    }







    $("#select_proyectos2").on("change", function() {



        $('#calendar').fullCalendar('removeEvents');

        var proyectos

        var id_proyecto = $('#select_proyectos2').val()



        $.ajax({

            url: "./api/calendario.php?id_proyecto=" + id_proyecto,

            type: 'GET',

            dataType: 'json', // added data type

            cache: false,

            async: false,

            success: function(c) {

                proyectos = c

                console.log(proyectos);



            }

        })

        var eventos = []

        if (proyectos.length == 1) {

            var color = proyectos[0].color

            $(".calendar-events i").css("color", color);



            $("#capa_lista").fadeOut();

        } else {

            $(".calendar-events i").css("color", "black");

            $("#capa_lista").fadeIn();

        }



        for (let proyecto of proyectos) {

            var nombre = proyecto.nombre

            if (proyectos.length > 1) {

                var color = proyecto.color

            }

            for (let evento of proyecto.horarios_asignados) {

                let data = {

                    id: evento.id_proyecto_empleado,

                    title: nombre,

                    start: evento.fecha_i,

                    end: evento.fecha_f,

                    className: 'horario',

                    id_empleado: evento.id_empleado,

                    id_proyecto: evento.id_proyecto,

                    id_grupo2: evento.id_grupo2,

                    id_proyecto_empleado: evento.id_proyecto_empleado,

                    empleado: evento.empleado,

                    proyecto: evento.proyecto,

                    grupo2: evento.grupo,

                    color: color

                }

                $('#calendar').fullCalendar('renderEvent', data, true);



            }

        }



        DisplayGraficos()

    });

    $(document).on("click", ".btn_eliminar_horario", function(e) {

        e.stopPropagation();

        var id = $(this).data("id")

        $.ajax({

            type: "DELETE",

            url: "./api/calendario.php?id=" + id,

            cache: false,

            async: false,

            dataType: "json",

            success: function(result) {

                console.log(result);

                $('#calendar').fullCalendar('removeEvents', id);

                $.toast({

                    heading: 'Horario eliminado',

                    text: 'Se ha eliminado el horario del calendario correctamente',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })

                DisplayGraficos()





            }

        });



    })





    /* on drop */

    $("#filtrar").click(() => {

        const is_checked = $("#filtrar").is(":checked");

        if (is_checked) {

            $("#fecha_i_filtro").prop('disabled', false);

            $("#fecha_f_filtro").prop('disabled', false);

        } else {

            $("#fecha_i_filtro").prop('disabled', true);

            $("#fecha_f_filtro").prop('disabled', true);

        }

        DisplayGraficos()

    })

    $("#fecha_i_filtro, #fecha_f_filtro").change(() => {



        DisplayGraficos()

    })

    $("#btn_add_horario").click(function() {

        var id_empleado = $(this).data("id_empleado");

        var id_grupo2 = $(this).data("id_grupo2");

        var id_proyecto = $(this).data("id_proyecto");

        var dia = $(this).data("dia");

        var fecha_i = dia + " " + $("#fecha_i_horario").val() + ":00"

        var fecha_f = dia + " " + $("#fecha_f_horario").val() + ":00"

        console.log(fecha_i);

        console.log(fecha_f);

        $.ajax({

            type: 'POST',

            url: './api/calendario.php',

            cache: false,

            async: false,

            dataType: "json",

            data: {

                id_empleado: id_empleado,

                id_grupo2: id_grupo2,

                id_proyecto: id_proyecto,

                fecha_i: fecha_i,

                fecha_f: fecha_f

            },

            success: function(result) {

                console.log(result);

                $("#modalAsignarHorario").modal("hide")

                $.toast({

                    heading: 'Horario asignado',

                    text: 'Se ha asignado un horario correctamente',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })



                renderEvent(result.id_proyecto_empleado)







            }

        });



    })

    $("#btn_edit_horario").click(function() {

        var id_proyecto_empleado = $(this).data("id");

        var id_empleado = $(this).data("id_empleado");

        var id_grupo2 = $(this).data("id_grupo2");

        var id_proyecto = $(this).data("id_proyecto");

        var dia = $(this).data("dia");

        var fecha_i = dia + " " + $("#fecha_i_horario_editar").val() + ":00"

        var fecha_f = dia + " " + $("#fecha_f_horario_editar").val() + ":00"

        console.log(fecha_i);

        console.log(fecha_f);

        $.ajax({

            type: 'POST',

            url: './api/calendario.php',

            cache: false,

            async: false,

            dataType: "json",

            data: {

                id_proyecto_empleado: id_proyecto_empleado,

                id_empleado: id_empleado,

                id_grupo2: id_grupo2,

                id_proyecto: id_proyecto,

                fecha_i: fecha_i,

                fecha_f: fecha_f

            },

            success: function(result) {

                console.log(result);

                $('#calendar').fullCalendar('removeEvents', id_proyecto_empleado);

                $("#modalEditarHorario").modal("hide")

                $.toast({

                    heading: 'Horario editado',

                    text: 'Se ha editado un horario correctamente',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })



                renderEvent(id_proyecto_empleado)







            }

        });



    })

    $("#archivo_file").change(function(e) {

        var archivo = $('#archivo_file')[0].files[0];



        $("#archivo_archivo").val(archivo.name)



    });

    $("#btn_add_archivo").click(function() {



        var archivo = $('#archivo_file')[0].files[0];

        var id_proyecto_empleado = $('#btn_subir_archivo').data("id")



        var nombre = $("#nombre_archivo").val();

        if (!archivo) {

            $.toast({

                heading: 'Ningún archivo seleccionado.',

                text: 'Por favor, selecciona un archivo para subir.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }



        if (nombre == "") {

            $.toast({

                heading: 'Ningún nombre seleccionado.',

                text: 'Por favor, agrega un nombre al archivo para subir.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }

        var extension = archivo.type.split('/').pop();

        if (extension == "jpeg") {

            extension = "jpg"

        }



        if (archivo.size > 3000000) {

            $.toast({

                heading: 'Archivo demasiado pesado.',

                text: 'El archivo debe pesar menos 3 MB.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 5000,

                stack: 6

            });

            return false

        }

        var fd = new FormData();

        fd.append('archivo', archivo);

        fd.append('extension', extension);

        fd.append('nombre', nombre);

        fd.append('id_proyecto_empleado_archivo', id_proyecto_empleado);



        var contenedor = document.getElementById('lista_archivos');

        var divElement = document.createElement('div');

        divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

            'justify-content-center', 'align-items-center');



        // Crear un elemento div para la clase "archivo_lista"

        var archivoListaDiv = document.createElement('div');

        archivoListaDiv.classList.add('archivo_lista', 'd-flex',

            'justify-content-center', 'align-items-center');



        var imgElement = document.createElement('img');

        imgElement.classList.add('img-fluid');

        imgElement.setAttribute('alt', '');

        imgElement.setAttribute('src', './assets/images/oval.svg');

        // Agregar elementos al div "archivo_lista"

        archivoListaDiv.appendChild(imgElement);



        divElement.appendChild(archivoListaDiv);

        // Agregar el div "archivo_lista" al div principal



        contenedor.insertAdjacentElement('afterbegin', divElement);





        $.ajax({

            url: './api/calendario.php',

            type: 'POST',

            data: fd,

            async: false,

            cache: false,

            processData: false, // tell jQuery not to process the data

            contentType: false, // tell jQuery not to set contentType

            success: function(result) {

                console.log(result);

                if (result == "0") {

                    $.toast({

                        heading: 'Nombre repetido.',

                        text: 'Selecciona otro nombre para el archivo.',

                        position: 'top-right',

                        loaderBg: '#ff5c6c',

                        icon: 'error',

                        hideAfter: 5000,

                        stack: 6

                    });

                    divElement.remove()

                    return false

                } else



                {



                    CargarArchivos(id_proyecto_empleado)

                    $.toast({

                        heading: 'Nuevo archivo subido.',

                        text: 'Se subido el nuevo archivo correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    })

                }

            }

        });



    });

    $(document).on("click", ".btn_seleccionar_archivo", function() {

        var url = $(this).data("url");

        var extension = $(this).data("extension");

        var div = document.getElementById("contenedor_archivo")

        div.innerHTML = ""

        if (extension !== "pdf") {

            // Crear un elemento <img>





            var imgElement = document.createElement("img");



            // Establecer los atributos del elemento <img>

            imgElement.id = "archivo_modal";

            imgElement.className = "w-100 img-fluid";

            imgElement.src = url; // Aquí establece la fuente de la imagen que desees

            imgElement.alt = "";



            // Agregar el elemento <img> al documento

            div.appendChild(imgElement);

        } else {

            var iframe = document.createElement('iframe');

            iframe.setAttribute('id', 'archivo_modal');

            iframe.setAttribute('src', url);

            iframe.style.width = "100%"

            iframe.style.height = "400px"

            div.appendChild(iframe);

        }







        $("#modalVerArchivo").modal("show");





    });

    $(document).on("click", ".nombre_archivo_div", function() {

        var nombre = $(this).data("nombre");

        var url = $(this).data("url");

        var extension = $(this).data("extension");



        $(this).attr("download", nombre)

        $(this).attr("href", url)

    });

    $(document).on("click", ".btn_eliminar_archivo", function() {

        var id = $(this).data("id");

        var url = $(this).data("url");





        $.ajax({

            type: "DELETE",

            url: "./api/calendario.php?url=" + url,

            cache: false,

            async: false,

            success: function(response) {

                console.log(response);

                CargarArchivos(id)

                $.toast({

                    heading: 'Archivo eliminado.',

                    text: 'Se eliminado el archivo correctamente.',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 4

                })

            }



        })

    });



    function CargarArchivos(id_proyecto_empleado) {

        var contenedor = document.getElementById('lista_archivos');

        contenedor.innerHTML = ""

        $.ajax({

            url: './api/calendario.php?id_proyecto_empleado_archivos=' +

                id_proyecto_empleado,

            type: 'GET',

            cache: false,

            async: false,

            dataType: 'json', // added data type

            success: function(result) {

                console.log(result);

                for (let r of result) {

                    r.url = r.url.slice(1)

                    console.log(r);

                    var divElement = document.createElement('div');

                    divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

                        'justify-content-center', 'align-items-center');



                    // Crear un elemento div para la clase "archivo_lista"

                    var archivoListaDiv = document.createElement('div');

                    archivoListaDiv.classList.add('archivo_lista', 'd-flex',

                        'justify-content-center', 'align-items-center');



                    if (r.extension != "pdf") {

                        // Crear un elemento img

                        var imgElement = document.createElement('img');

                        imgElement.classList.add('img-fluid');

                        imgElement.setAttribute('alt', '');

                        imgElement.setAttribute('src', r.url);

                    } else {

                        var iframe = document.createElement('iframe');



                        iframe.setAttribute('src', r.url);

                        iframe.style.width = "100%";

                        iframe.style.height = "100%";



                    }





                    // Crear un botón para eliminar

                    var btnEliminar = document.createElement('button');

                    btnEliminar.classList.add('p-1', 'btn_eliminar_archivo', 'btn');

                    btnEliminar.setAttribute('data-url', r.url);

                    btnEliminar.setAttribute('data-id', id_proyecto_empleado);

                    btnEliminar.setAttribute('type', 'button');

                    btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';



                    // Crear un botón para seleccionar

                    var btnSeleccionar = document.createElement('button');

                    btnSeleccionar.classList.add('p-1', 'btn_seleccionar_archivo',

                        'btn');

                    btnSeleccionar.setAttribute('data-url', r.url);

                    btnSeleccionar.setAttribute('data-extension', r.extension);

                    btnSeleccionar.setAttribute('type', 'button');

                    btnSeleccionar.innerHTML = '<i class="m-0 fa fa-eye"></i>';









                    var nombre = document.createElement('a');

                    nombre.textContent = r.nombre

                    nombre.setAttribute('data-nombre', r.nombre);

                    nombre.setAttribute('data-url', r.url);

                    nombre.setAttribute('data-extension', r.extension);

                    nombre.classList.add("nombre_archivo_div")

                    nombre.innerHTML += '<i class="ml-2 fa fa-download"></i>';

                    // Agregar elementos al div "archivo_lista"

                    if (r.extension != "pdf") {

                        // Crear un elemento img

                        archivoListaDiv.appendChild(imgElement);



                    } else {

                        archivoListaDiv.appendChild(iframe);



                    }

                    archivoListaDiv.appendChild(btnEliminar);

                    archivoListaDiv.appendChild(btnSeleccionar);



                    // Agregar el div "archivo_lista" al div principal

                    divElement.appendChild(archivoListaDiv);



                    divElement.appendChild(nombre);

                    contenedor.appendChild(divElement);



                }

            }

        })



    }

    CalendarApp.prototype.onDrop = function(eventObj, date) {

            var $this = this;

            // retrieve the dropped element's stored Event Object

            var originalEventObject = eventObj.data('eventObject');

            var $categoryClass = eventObj.attr('data-class');



            // console.log(eventObj.attr('data-id'));

            // we need to copy it, so that multiple events don't have a reference to the same object

            var copiedEventObject = $.extend({}, originalEventObject);

            // assign it the date that was reported

            copiedEventObject.start = date.add(moment.duration(8, 'hours'));



            copiedEventObject.end = copiedEventObject.start.clone()

            copiedEventObject.end.add(moment.duration(11, 'hours'));





            copiedEventObject.id = eventObj.attr('data-id');

            if ($categoryClass)

                copiedEventObject['className'] = [$categoryClass];

            // render the event on the calendar



            var id_empleado = (eventObj.attr('data-tipo') == "empleado") ? eventObj.attr('data-id') : ""

            var id_grupo2 = (eventObj.attr('data-tipo') == "grupo") ? eventObj.attr('data-id') : ""

            var id_proyecto = $("#select_proyectos2").val()



            $("#fecha_i_horario").val("06:00")

            $("#fecha_f_horario").val("18:00")

            var dia = copiedEventObject.start.format('YYYY-MM-DD')

            $("#btn_add_horario").data("dia", dia);



            $("#btn_add_horario").data("id_empleado", id_empleado);



            $("#btn_add_horario").data("id_grupo2", id_grupo2);



            $("#btn_add_horario").data("id_proyecto", id_proyecto);

            $("#modalAsignarHorario").modal("show")











        },

        /* on click on event */

        CalendarApp.prototype.onEventClick = function(calEvent, jsEvent, view) {



            var $this = this;

            console.log(jsEvent.target);

            if (jsEvent.target.classList.contains("fas")) {

                return

            }

            $("#fecha_i_horario_editar").val(calEvent.start.format('HH:mm'))

            $("#fecha_f_horario_editar").val(calEvent.end.format('HH:mm'))

            var dia = calEvent.start.format('YYYY-MM-DD')

            $("#btn_edit_horario").data("dia", dia);

            $("#btn_edit_horario").data("id", calEvent._id)

            $("#btn_edit_horario").data("id_empleado", calEvent.id_empleado)

            $("#btn_edit_horario").data("id_grupo2", calEvent.id_grupo2)

            $("#btn_edit_horario").data("id_proyecto", calEvent.id_proyecto)



            $('#btn_subir_archivo').data("id", calEvent._id)

            CargarArchivos(calEvent._id)

            $("#modalEditarHorario").modal("show")



        },

        CalendarApp.prototype.enableDrag = function() {

            //init events

            $(this.$event).each(function() {



                // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)

                // it doesn't need to have a start or end

                var eventObject = {

                    title: $.trim($(this).text()) // use the element's text as the event title

                };

                // store the Event Object in the DOM element so we can get to it later

                $(this).data('eventObject', eventObject);

                // make the event draggable using jQuery UI

                $(this).draggable({

                    zIndex: 999,

                    revert: true, // will cause the event to go back to its

                    revertDuration: 0 //  original position after the drag

                });

            });

        }



    function convertirMinutosAHorasYMinutos(minutos) {

        var horas = Math.floor(minutos / 60);

        var minutosRestantes = minutos % 60;

        return {

            horas: horas,

            minutos: minutosRestantes

        };

    }





    /* Initializing */

    CalendarApp.prototype.init = function() {

            this.enableDrag();

            /*  Initialize the calendar  */

            var proyectos

            var id_proyecto = $('#select_proyectos2').val()



            $.ajax({

                url: "./api/calendario.php?id_proyecto=" + id_proyecto,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(c) {

                    proyectos = c





                }

            })

            /*

                        var empleadosSet = new Set();



                        // Recorrer los horarios asignados y agregar los IDs de los empleados al conjunto

                        proyecto.horarios_asignados.forEach(function(horario) {

                            if (horario.id_empleado != null) {

                                if (!empleadosSet.has(horario.id_empleado)) {

                                    empleadosSet.add(horario.id_empleado);

                                }

                            } else {





                                horario.grupo.empleados.forEach(function(empleado) {

                                    if (!empleadosSet.has(empleado.id_empleado)) {

                                        empleadosSet.add(empleado.id_empleado);

                                    }





                                })







                            }

                        });

            */





            var date = new Date();

            var d = date.getDate();

            var m = date.getMonth();

            var y = date.getFullYear();

            var form = '';

            var today = new Date($.now());

            var eventos = []

            if (proyectos.length == 1) {

                var color = proyectos[0].color

                $(".calendar-events i").css("color", color);

                $("#capa_lista").fadeOut();

            } else {

                $(".calendar-events i").css("color", "black");

                $("#capa_lista").fadeIn();

            }



            for (let proyecto of proyectos) {

                var nombre = proyecto.nombre

                if (proyectos.length > 1) {

                    var color = proyecto.color

                }

                for (let evento of proyecto.horarios_asignados) {

                    let data = {

                        id: evento.id_proyecto_empleado,

                        title: nombre,

                        start: evento.fecha_i,

                        end: evento.fecha_f,

                        className: 'horario',

                        id_empleado: evento.id_empleado,

                        id_proyecto: evento.id_proyecto,

                        id_grupo2: evento.id_grupo2,

                        id_proyecto_empleado: evento.id_proyecto_empleado,

                        empleado: evento.empleado,

                        proyecto: evento.proyecto,

                        grupo2: evento.grupo,

                        color: color

                    }

                    eventos.push(data)

                }

            }



            DisplayGraficos()

            var $this = this;

            $this.$calendarObj = $this.$calendar.fullCalendar({

                slotDuration: '00:30:00',

                /* If we want to split day time each 15minutes */

                minTime: '00:00:00',

                maxTime: '24:00:00',

                defaultView: 'month',

                handleWindowResize: true,

                locale: "es",

                header: {

                    left: 'prev,next today customButton',

                    center: 'title',

                    right: 'month,agendaWeek,agendaDay'

                },

                events: eventos,

                editable: true,

                droppable: true, // this allows things to be dropped onto the calendar !!!

                eventLimit: true, // allow "more" link when too many events

                selectable: true,

                views: {

                    day: {

                        // Personaliza el formato de las etiquetas de hora en la vista del día

                        slotLabelFormat: 'H:mm' // Utiliza 'H' para representar las horas en formato de 24 horas (16:00)

                    }

                },





                customButtons: {

                    customButton: {

                        text: 'Excel'

                    }

                },

                drop: function(date) {

                    $this.onDrop($(this), date);

                },

                eventRender: function(event, element) {



                    $(element).find(".fc-time").text(event.start.format('HH:mm') + ' - ' + event.end.format(

                        'HH:mm'));

                    $(element).find(".fc-title").remove();

                    $(element).addClass("p-1");

                    $(element).find(".fc-content").append(`<a data-id="${event.id}" class="btn_eliminar_horario text-white position-absolute" type="button" style="right:0; top:0; width: 11px ;font-size: 11px;">

                    <i class="fas fa-times" style="width: 11px;"></i></a>`);





                },

                eventResize: function(info) {



                    $.ajax({

                        type: 'POST',

                        url: './api/calendario.php',

                        async: false,

                        cache: false,

                        data: {

                            id_proyecto_empleado: info.id_proyecto_empleado,

                            fecha_i: info.start.format('YYYY-MM-DD HH:mm:ss'),

                            fecha_f: info.end.format('YYYY-MM-DD HH:mm:ss'),

                            id_proyecto: info.id_proyecto,

                            id_grupo2: info.id_grupo2,

                            id_empleado: info.id_empleado



                        },

                        success: function(result) {



                            $('#calendar').fullCalendar('removeEvents', info

                                .id_proyecto_empleado);

                            $.toast({

                                heading: 'Horario ajustado',

                                text: 'Se ha ajustado el horario correctamente',

                                position: 'top-right',

                                loaderBg: '#32a852',

                                icon: 'success',

                                hideAfter: 2000,

                                stack: 6

                            });

                            renderEvent(info.id_proyecto_empleado)

                        }

                    });

                },

                eventAfterRender: function(event, element, view) {



                    element.css("background-color", event.color)

                    element.attr("data_pe", event.id_proyecto_empleado)

                    element.attr("data_e", event.id_empleado)

                    element.attr("data_p", event.id_proyecto)

                    element.attr("id", event._id)







                    if (event.id_empleado != null) {

                        element.append(

                            '<p style="font-size: 12px;" class="mb-0">Empleado: ' + event.empleado

                            .nombre +

                            '</p>')

                    }



                    if (event.grupo2 != null) {

                        var ul = document.createElement('ul');

                        element.append(

                            '<p style="font-size: 12px;" class="mb-1"> Grupo: ' + event.grupo2.nombre +

                            '</p>')

                        element.append(

                            '<p style="font-size: 12px;" class="mb-0"> Miembros:</p>')

                        for (let e of event.grupo2.empleados) {

                            var li = document.createElement('li');

                            li.innerText = e.nombre

                            ul.append(li)

                        }

                        element.append(ul)

                    }







                },



                eventClick: function(calEvent, jsEvent, view) {

                    $this.onEventClick(calEvent, jsEvent, view);

                },



                dayClick: function(date, jsEvent, view) {



                    $('#calendar').fullCalendar('changeView', 'agendaDay', date);



                },



                eventDrop: function(event, delta, revertFunc, jsEvent, ui, view, el) {







                    var fecha_i = event.start.format('YYYY-MM-DD HH:mm:ss');

                    var fecha_f = event.end.format('YYYY-MM-DD HH:mm:ss');



                    var id_proyecto_empleado = event.id_proyecto_empleado;



                    $.ajax({

                        type: 'POST',

                        url: './api/calendario.php',

                        async: false,

                        cache: false,

                        data: {

                            id_proyecto_empleado: id_proyecto_empleado,

                            fecha_i: fecha_i,

                            fecha_f: fecha_f,

                            id_proyecto: event.id_proyecto,

                            id_grupo2: event.id_grupo2,

                            id_empleado: event.id_empleado



                        },

                        success: function(result) {



                            $('#calendar').fullCalendar('removeEvents', id_proyecto_empleado);

                            $.toast({

                                heading: 'Día cambiado',

                                text: 'Se ha cambiado le fecha correctamente',

                                position: 'top-right',

                                loaderBg: '#32a852',

                                icon: 'success',

                                hideAfter: 2000,

                                stack: 6

                            });

                            renderEvent(id_proyecto_empleado)

                        }

                    });



                }



            });



            //on new event



        },



        //init CalendarApp

        $.CalendarApp = new CalendarApp, $.CalendarApp.Constructor = CalendarApp



}(window.jQuery),



//initializing CalendarApp

function($) {

    "use strict";





    $(window).on('load', function() {



        $.CalendarApp.init()





    })











}(window.jQuery);
</script>

<script>
// Obtener la fecha de hoy

var fechaHoy = new Date();

var dia = fechaHoy.getDate();

var mes = fechaHoy.getMonth() + 1;

var anio = fechaHoy.getFullYear();



// Formatear la fecha de hoy como "YYYY-MM-DD"

var fechaHoyFormateada = anio + "-" + (mes < 10 ? '0' + mes : mes) + "-" + (dia < 10 ? '0' + dia : dia);



// Establecer el valor del primer input

document.getElementById("fecha_i_filtro").value = fechaHoyFormateada;



// Sumar una semana a la fecha de hoy

var fechaEnUnaSemana = new Date(fechaHoy);

fechaEnUnaSemana.setDate(fechaEnUnaSemana.getDate() + 7);



// Formatear la fecha en una semana como "YYYY-MM-DD"

var diaSemana = fechaEnUnaSemana.getDate();

var mesSemana = fechaEnUnaSemana.getMonth() + 1;

var anioSemana = fechaEnUnaSemana.getFullYear();

var fechaEnUnaSemanaFormateada = anioSemana + "-" + (mesSemana < 10 ? '0' + mesSemana : mesSemana) + "-" + (diaSemana <

    10 ? '0' + diaSemana : diaSemana);



// Establecer el valor del segundo input

document.getElementById("fecha_f_filtro").value = fechaEnUnaSemanaFormateada;
</script>





<script>
(function($) {

    'use strict';

    $(function() {





    });

})(jQuery);
</script>