<style>
.input-group:has(.select_dinamico) .select2-container {


    max-width: calc(100% - 119.73px) !important;
}

.input-group:has(.select_dinamico) {

    border: 0px !important;

}

.input-group:has(.select_dinamico) .select2-selection__clear {

    margin-right: 0px !important;

}
</style>
<!-- Modal de confirmación -->
<div class="modal fade" id="modalConfirm" tabindex="-1" aria-labelledby="modalConfirmLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalConfirmLabel">Confirmación</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="modalConfirmMessage">
                ¿Estás seguro de que deseas continuar?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="confirmActionButton">Confirmar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de entrada de texto -->
<div class="modal fade" id="modalInput" tabindex="-1" aria-labelledby="modalInputLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalInputLabel">Ingresar Nombre</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="text" class="form-control" id="modalInputField" placeholder="Escribe un nombre">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="inputActionButton">Guardar</button>
            </div>
        </div>
    </div>
</div>

<script>
(function($) {

    'use strict';


    $(function() {

        function reloadSelectOptions($select, selectedId = null) {
            $.ajax({
                url: './api/select_dinamico.php?table=' + $select.data('tabla'),
                method: 'GET',
                cache: false,
                success: function(data) {
                    $select.html('');
                    $select.append(
                        '<option selected value="No">Ninguna opción seleccionada</option>');
                    if (data.items && data.items.length > 0) {
                        data.items.forEach(function(option) {
                            let isSelected = selectedId && option.id == selectedId ?
                                'selected' : '';
                            $select.append('<option value="' + option.id + '" ' +
                                isSelected + '>' + option.nombre + '</option>');
                        });
                    }
                    $select.trigger("change");
                    const evento = new CustomEvent('opciones_cargadas', {
                        detail: {
                            select: $select.attr('id'),
                            valor: $select.val()
                        }
                    });
                    document.dispatchEvent(evento);
                },
                error: function(xhr, status, error) {
                    alert('Error al cargar las opciones: ' + error);
                }
            });
        }






        $('.select_dinamico').each(function() {

            // Inicializar select2 una sola vez

            $(this).select2({

                width: '100%', // Ajustar el ancho al 100%

                placeholder: 'Selecciona una opción'



            });



            // Recargar las opciones dinámicas

            reloadSelectOptions($(this));

        });





        $('.agregar_elemento_select').on('click', function() {
            var $select = $('#' + $(this).data('select'));

            // Mostrar el modal de entrada
            $('#modalInput').modal('show');
            $('#modalInputField').val('').focus();

            $('#inputActionButton').off('click').on('click', function() {
                var value = $('#modalInputField').val();
                if (value) {
                    $.ajax({
                        url: './api/select_dinamico.php?table=' + $select.data(
                            'tabla'),
                        method: 'POST',
                        cache: false,
                        data: {
                            nombre: value
                        },
                        success: function(response) {
                            reloadSelectOptions($select, response.id);
                            $('#modalInput').modal('hide');
                            alert('Elemento agregado');
                        },
                        error: function(xhr, status, error) {
                            alert('Error al agregar el elemento: ' + error);
                        }
                    });
                } else {
                    alert('Por favor, ingresa un nombre válido.');
                }
            });
        });




        $('.eliminar_elemento_select').on('click', function() {
            var $select = $('#' + $(this).data('select'));
            var id = $select.val();

            if (!id) {
                alert('Selecciona una opción para eliminar.');
                return;
            }

            $('#modalConfirmMessage').text('¿Estás seguro de que deseas eliminar esta opción?');
            $('#modalConfirm').modal('show');

            $('#confirmActionButton').off('click').on('click', function() {
                $.ajax({
                    url: './api/select_dinamico.php?table=' + $select.data('tabla'),
                    method: 'DELETE',
                    cache: false,
                    data: {
                        id: id
                    },
                    success: function(response) {
                        reloadSelectOptions($select);
                        $('#modalConfirm').modal('hide');
                        alert('Elemento eliminado');
                    },
                    error: function(xhr, status, error) {
                        alert('Error al eliminar el elemento: ' + error);
                    }
                });
            });
        });

        // Editar un elemento
        $('.editar_elemento_select').on('click', function() {
            var $select = $('#' + $(this).data('select'));
            var id = $select.val();
            var nombreActual = $select.find('option:selected').text();

            if (!id) {
                alert('Selecciona una opción para editar.');
                return;
            }

            // Mostrar el modal de edición
            $('#modalInputField').val(nombreActual);
            $('#modalInput').modal('show');

            $('#inputActionButton').off('click').on('click', function() {
                var newValue = $('#modalInputField').val();
                if (newValue) {
                    $.ajax({
                        url: './api/select_dinamico.php?table=' + $select.data(
                            'tabla'),
                        method: 'PUT',
                        cache: false,
                        data: {
                            id: id,
                            nombre: newValue
                        },
                        success: function(response) {
                            reloadSelectOptions($select, id);
                            $('#modalInput').modal('hide');
                            alert('Elemento actualizado');
                        },
                        error: function(xhr, status, error) {
                            alert('Error al actualizar el elemento: ' + error);
                        }
                    });
                } else {
                    alert('Por favor, ingresa un nombre válido.');
                }
            });
        });




    });

})(jQuery);
</script>