<div class="content-wrapper">
    <div class="row profile-page ">

        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/hbzjlsuh.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Miembros totales</p>

                        <span id="usuarios_totales" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/wvpcnsph.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Miembros de vacaciones</p>

                        <span id="usuarios_con_vacaciones_hoy" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/bqwuskcm.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Miembros activos</p>

                        <span id="usuarios_sin_vacaciones_hoy" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-3">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/cetdawbe.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Vacaciones pendientes</p>

                        <span id="vacaciones_pendientes" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>
    <div class="row profile-page">
        <div class="col-lg-3 col-xl-2">


            <div class="card card-cuenta mb-3">

                <div class="card-header mb-0">

                    <div class="row">

                        <div class="col-12">
                            <h4 class="mb-0 text-center text-sm-left">Miembros</h4>
                        </div>

                    </div>

                </div>

                <div class="card-body card-table-body p-3">


                    <ul style="list-style: none; padding: 0; margin: 0;">
                        <?php foreach ($User_List as $User) { ?>
                        <li class="d-flex justify-content-between align-items-center mb-2">
                            <div class="d-flex align-items-center">
                                <img src="<?php echo htmlentities($User['user_avatar'], ENT_QUOTES); ?>" alt="Avatar"
                                    class="rounded-circle mr-2" width="20" height="20">
                                <span
                                    style="font-size: 11px;"><?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?></span>
                            </div>
                            <div class="d-flex align-items-center">
                                <input type="color" name="color" data-id=<?php echo $User['user_id']; ?> value="<?php 
                            if($User['color'] == null){
                               echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);
                            }else{
                                echo htmlentities($User['color'], ENT_QUOTES);
                            } ?>" class="colores_user form-control form-control-color"
                                    style="width: 25px !important;padding: 0px !important;cursor: pointer;height: 25px ! Important;"
                                    id="exampleColorInput">
                                <button data-id=<?php echo $User['user_id']; ?>
                                    class="btn btn_localizacion text-black btn-outline-success py-1 px-2 border-0"
                                    style="top: 0rem; right: 27px;" data-toggle="tooltip" data-title="Localización"><i
                                        class="fa fa-map-marker m-0"></i></button>
                            </div>
                        </li>
                        <?php } ?>

                    </ul>




                </div>

            </div>
            <div class="card card-cuenta">

                <div class="card-header mb-0">

                    <div class="row">

                        <div class="col-12">
                            <h4 class="mb-0 text-center text-sm-left">Feriados</h4>
                        </div>

                    </div>

                </div>

                <div class="card-body card-table-body p-3">


                    <ul style="list-style: none; padding: 0; margin: 0;">

                        <li class="d-flex justify-content-between align-items-center mb-2">
                            <div class="d-flex align-items-center">

                                <span style="font-size: 11px;">Nacionales</span>
                            </div>
                            <div class="d-flex align-items-center">
                                <input type="color" name="color" data-nombre="color_nacionales" value="<?php 
                           
                                echo htmlentities($personalizacion['color_nacionales'], ENT_QUOTES);?>"
                                    class="form-control form-control-color valor_personalizacion"
                                    style="width: 25px !important;padding: 0px !important;cursor: pointer;height: 25px ! Important;"
                                    id="exampleColorInput">

                            </div>
                        </li>
                        <li class="d-flex justify-content-between align-items-center mb-2">
                            <div class="d-flex align-items-center">

                                <span style="font-size: 11px;">Autonómicos</span>
                            </div>
                            <div class="d-flex align-items-center">
                                <input type="color" name="color" data-nombre="color_autonomicos" value="<?php 
                           
                                echo htmlentities($personalizacion['color_autonomicos'], ENT_QUOTES);?>"
                                    class="form-control form-control-color valor_personalizacion"
                                    style="width: 25px !important;padding: 0px !important;cursor: pointer;height: 25px ! Important;"
                                    id="exampleColorInput">

                            </div>
                        </li>
                        <li class="d-flex justify-content-between align-items-center mb-2">
                            <div class="d-flex align-items-center">

                                <span style="font-size: 11px;">Locales</span>
                            </div>
                            <div class="d-flex align-items-center">
                                <input type="color" data-nombre="color_locales" name="color" value="<?php 
                           
                                echo htmlentities($personalizacion['color_locales'], ENT_QUOTES);?>"
                                    class="form-control form-control-color valor_personalizacion"
                                    style="width: 25px !important;padding: 0px !important;cursor: pointer;height: 25px ! Important;"
                                    id="exampleColorInput">

                            </div>
                        </li>

                    </ul>




                </div>

            </div>


        </div>
        <div class="col-lg-9 col-xl-10">




            <div class="card card-cuenta">

                <div style="" class="card-header mb-0">

                    <div class="row">

                        <div class="col-12">
                            <h4 class="mb-0 text-center text-sm-left">Control de vacaciones de usuarios</h4>
                        </div>

                    </div>

                </div>

                <div style="" class="card-body card-table-body p-3">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="form-group mb-3">
                                <label for="titulo_evento">Miembro</label>
                                <select id="user_id_filtro"
                                    class="form-control custom-select text-center select2 select_users">

                                    <option type="number" value="No">

                                        Todos

                                    </option>

                                    <?php

                                    foreach ($User_List as $User)

                                        {



                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>



                                    <?php } ?>





                                </select>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-group mb-3">
                                <label for="titulo_evento">Estado</label>
                                <select id="estado_filtro" class="form-control custom-select text-center select2">
                                    <option type="text" value="No">

                                        Todos

                                    </option>
                                    <option type="text" value="Aceptado">

                                        Aceptado

                                    </option>

                                    <option type="text" value="Pendiente">

                                        Pendiente

                                    </option>
                                    <option type="text" value="Rechazado">

                                        Rechazado

                                    </option>






                                </select>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-group mb-3">
                                <label for="titulo_evento">Provincia</label>
                                <select id="provincia_filtro"
                                    class="form-control custom-select text-center select2 select_users">

                                    <option type="text" value="No">

                                        Ninguna

                                    </option>

                                    <?php

                                    foreach ($Provincias as $P)

                                        {



                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($P['id_provincia'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($P['nombre'], ENT_QUOTES); ?>

                                    </option>



                                    <?php } ?>





                                </select>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-group mb-3">
                                <label for="titulo_evento">Localidad</label>
                                <select id="localidad_filtro"
                                    class="form-control custom-select text-center select2 select_users">

                                    <option type="text" value="No">

                                        Ninguna

                                    </option>

                                    <?php

                                    foreach ($Localidades as $P)

                                        {



                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($P['id_localidad'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($P['nombre'], ENT_QUOTES); ?>

                                    </option>



                                    <?php } ?>





                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div id="calendar2"></div>
                        </div>
                    </div>






                </div>

            </div>

        </div>



    </div>
</div>





<!-- MODALS -->



<div class="modal fade" id="modalCrearEvento" role="dialog" aria-labelledby="modalCrearEventoLabel">
    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar vacaciones</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>

            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_evento">Miembro</label>
                                <select id="user_id_vacacion"
                                    class="form-control custom-select text-center select2 select_users">



                                    <?php

                                    foreach ($User_List as $User)

                                        {



                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>



                                    <?php } ?>





                                </select>
                            </div>

                            <div class="form-group">
                                <label for="fecha_i_vacacion">Fecha de inicio</label>
                                <input class="form-control" id="fecha_i_vacacion" type="date">
                            </div>

                            <div class="form-group">
                                <label for="fecha_f_vacacion">Fecha de fin</label>
                                <input class="form-control" id="fecha_f_vacacion" type="date">
                            </div>

                            <div class="form-group">
                                <label for="titulo_evento">Estado</label>
                                <select id="estado_vacacion" class="form-control custom-select text-center select2">
                                    <option type="text" value="Aceptado">

                                        Aceptado

                                    </option>

                                    <option type="text" value="Pendiente">

                                        Pendiente

                                    </option>
                                    <option type="text" value="Rechazado">

                                        Rechazado

                                    </option>






                                </select>
                            </div>
                            <div class="form-group">

                                <label>Observaciones</label>

                                <textarea id="observaciones_vacacion" class="form-control"></textarea>

                            </div>

                        </div>
                    </div>
                </div>
            </div>


            <div class="modal-footer text-right">
                <button id="btn_add_evento" class="btn btn-success btn-fw" type="button">Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal para editar evento -->
<div class="modal fade" id="modalEditarEvento" role="dialog" aria-labelledby="modalEditarEventoLabel">
    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar período</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>

            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_evento">Miembro</label>
                                <select id="user_id_vacacion_editar"
                                    class="form-control custom-select text-center select2 select_users">



                                    <?php

                                    foreach ($User_List as $User)

                                        {



                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>



                                    <?php } ?>





                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Fecha de inicio</label>
                                <input type="date" id="fecha_i_vacacion_editar" class="form-control">
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Fecha de fin</label>
                                <input type="date" id="fecha_f_vacacion_editar" class="form-control">
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_evento">Estado</label>
                                <select id="estado_vacacion_editar"
                                    class="form-control custom-select text-center select2">
                                    <option type="text" value="Aceptado">

                                        Aceptado

                                    </option>

                                    <option type="text" value="Pendiente">

                                        Pendiente

                                    </option>
                                    <option type="text" value="Rechazado">

                                        Rechazado

                                    </option>






                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">

                                <label>Observaciones</label>

                                <textarea id="observaciones_vacacion_editar" class="form-control"></textarea>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer text-right">
                <button id="btn_guardar_evento" class="btn btn-success btn-fw" type="button">
                    Guardar cambios
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar
                </button>
            </div>

        </div>
    </div>
</div>

<div class="modal fade modal-cambiar" id="modalEliminarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar período</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el período definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button id="btn_eliminar_evento" class="btn btn-danger btn-fw" type="button" name="">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>



<div class="modal fade modal-cambiar" id="modalVerEvento" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">

            <div class="modal-header border-none">
                <h4 class="mb-0">Información del período</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>

            <div class="modal-body pb-0">

                <div class="form-group">
                    <label><strong>Usuario:</strong></label>
                    <p id="verUsuario" class="mb-0"></p>
                </div>

                <div class="form-group">
                    <label><strong>Fecha de inicio:</strong></label>
                    <p id="verFechaInicio" class="mb-0"></p>
                </div>

                <div class="form-group">
                    <label><strong>Fecha de fin:</strong></label>
                    <p id="verFechaFin" class="mb-0"></p>
                </div>

                <div class="form-group">
                    <label><strong>Estado:</strong></label>
                    <p id="verEstado" class="mb-0"></p>
                </div>

                <div class="form-group mb-0">
                    <label><strong>Observaciones:</strong></label>
                    <p id="verObservaciones" class="mb-0"></p>
                </div>


            </div>

            <div class="modal-footer text-right">
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar
                </button>
            </div>

        </div>
    </div>
</div>

<div class="modal fade modal-cambiar" id="modalLocalizacion" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">

            <div class="modal-header border-none">
                <h4 class="mb-0">Cambiar la localización del usuario</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>

            <div class="modal-body pb-0">
                <div class="form-group">
                    <label for="titulo_evento">Provincia</label>
                    <select id="id_provincia_usuario"
                        class="form-control custom-select text-center select2 select_users">

                        <option type="text" value="No">

                            Ninguna

                        </option>

                        <?php

                                    foreach ($Provincias as $P)

                                        {



                                        ?>

                        <option type="number" value=<?php echo $P['id_provincia']; ?>>

                            <?php echo htmlentities($P['nombre'], ENT_QUOTES); ?>

                        </option>



                        <?php } ?>





                    </select>
                </div>
                <div class="form-group">
                    <label for="titulo_evento">Localidad</label>
                    <select id="id_localidad_usuario"
                        class="form-control custom-select text-center select2 select_users">

                        <option type="text" value="No">

                            Ninguna

                        </option>

                        <?php

                                    foreach ($Localidades as $P)

                                        {



                                        ?>

                        <option type="number" value=<?php echo $P['id_localidad']; ?>>

                            <?php echo htmlentities($P['nombre'], ENT_QUOTES); ?>

                        </option>



                        <?php } ?>





                    </select>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_guardar_localizacion" class="btn btn-success btn-fw" type="button">
                    Guardar cambios
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar
                </button>
            </div>

        </div>



    </div>
</div>
</div>
<style>
.fc table,
body .fc {
    font-size: .8rem !important;
}

.btn_fc {
    font-size: .6rem !important;
}

#calendar2 {
    height: auto !important;
    max-height: none !important;
    overflow: visible !important;
}

.fc-scroller-harness,
.fc-scroller {
    overflow: visible !important;
    max-height: none !important;
}

.fc-theme-standard th {
    padding-left: 0 !important;
    padding-right: 0 !important;
}

.fc-col-header-cell-cushion {
    text-transform: uppercase;

}

.fc-h-event .fc-event-main {
    padding: .5rem !important;

}

.fc-toolbar-title {
    text-transform: uppercase;
    font-size: 20px;
}

button.fc-button {
    line-height: 1 !important;
}

.fc-daygrid-day-frame {
    cursor: pointer !important;
}

@media (max-width: 567px) {
    .fc-header-toolbar {
        display: flex !important;
        flex-direction: column !important;
    }

    .fc-toolbar-title {

        margin-top: 20px !important;
        margin-bottom: 20px !important;
    }

}
</style>
<script>
window.onload = function() {



    $('.btn_localizacion').tooltip()
    $(document).on("click", ".btn_localizacion", function() {

        var id = $(this).data("id")
        $("#btn_guardar_localizacion").data("id", id)
        $.ajax({

            url: './api/users.php?user_id=' + id,

            type: 'GET',

            cache: false,



            dataType: 'json', // added data type

            success: function(vacacion) {

                console.log(vacacion);
                $("#id_provincia_usuario").data("id_localidad", vacacion.id_localidad)
                $("#id_provincia_usuario").val((vacacion.id_provincia != null) ? vacacion
                    .id_provincia : "No").trigger("change")






                $('#modalLocalizacion').modal('show');

            }

        });
    })
    $("#btn_guardar_localizacion").click(function(e) {
        var id_provincia = $("#id_provincia_usuario").val()
        var id_localidad = $("#id_localidad_usuario").val()
        var user_id = $("#btn_guardar_localizacion").data("id")
        $.ajax({
            url: './api/users.php',
            method: 'POST',
            data: {
                id_provincia: id_provincia,
                id_localidad: id_localidad,
                user_id: user_id
            },
            dataType: 'json',
            success: function(response) {
                console.log(response);

                $.toast({
                    heading: "Localización cambiada",
                    text: "La localización del usuario se ha cambiado correctamente.",
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                $('#modalLocalizacion').modal('hide');

            },
            error: function(xhr, status, error) {
                console.error("Error en la petición AJAX:", error);
                alert("Ocurrió un error al guardar los cambios.");

            }
        });

    });

    const calendarEl = document.getElementById('calendar2');

    let defaultView = window.innerWidth < 768 ? 'listWeek' : 'dayGridMonth';
    if (!calendarEl || typeof FullCalendar === 'undefined') {
        console.error("FullCalendar no está definido o no se encontró el div #calendar");
        return;
    }

    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        locale: 'es',
        contentHeight: 'auto',
        height: 'auto',
        expandRows: true, // especialmente importante en 'timeGridWeek'
        dayMaxEventRows: true,
        dayHeaderFormat: {
            weekday: 'long'
        }, // Configura el idioma a español
        editable: true, // sigue siendo true globalmente
        eventStartEditable: true, // permite moverlos por defecto
        eventDurationEditable: true, // permite redimensionarlos por defecto
        eventAllow: function(dropInfo, draggedEvent) {
            // Solo permite mover/redimensionar si el tipo es "eventos"
            return draggedEvent.extendedProps.tipo === "eventos";
        },
        dayHeaderContent: function(arg) {
            const diasCortos = ['DOM', 'LUN', 'MAR', 'MIÉ', 'JUE', 'VIE', 'SÁB'];
            return window.innerWidth < 768 ?
                diasCortos[arg.date.getDay()] :
                arg.text; // Usa el texto completo por defecto
        },
        buttonText: {
            prev: 'Anterior', // Texto del botón "prev"
            next: 'Siguiente', // Texto del botón "next"
            today: 'Hoy', // Texto del botón "today"
            dayGridMonth: 'Mes', // Texto del botón "prev"
            dayGridWeek: 'Semana', // Texto del botón "next"
            dayGridDay: 'Hoy' // Texto del botón "today"
        },
        titleFormat: { // Formato personalizado del título
            month: 'long', // Nombre completo del mes (ej. "Mayo")
            year: 'numeric', // Año completo (ej. "2025")
        }, // muestra nombres completos

        headerToolbar: { // Custom toolbar configuration
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,dayGridWeek,dayGridDay',
        },
        editable: true, // Permite mover y redimensionar eventos
        eventResizableFromStart: true,
        events: function(fetchInfo, successCallback, failureCallback) {
            const userId = document.getElementById('user_id_filtro')?.value || 'No';
            const estado = document.getElementById('estado_filtro')?.value || 'No';
            const provincia = document.getElementById('provincia_filtro')?.value || 'No';
            const localidad = document.getElementById('localidad_filtro')?.value || 'No';
            const url = new URL('/api/vacaciones.php', window.location.origin);


            url.searchParams.set('user_id', userId);
            url.searchParams.set('estado', estado);
            url.searchParams.set('id_provincia', provincia);
            url.searchParams.set('id_localidad', localidad);
            url.searchParams.set('_', new Date().getTime()); // Evita cache

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    console.log(data);
                    const todosLosEventos = [...data.eventos, ...(data.feriados || [])];


                    successCallback(todosLosEventos);

                    //successCallback(data.eventos); // Asume que `eventos` viene como array de eventos

                    // Mostrar totales
                    document.getElementById('usuarios_totales').textContent = data.resumen
                        .usuarios_totales;
                    document.getElementById('usuarios_con_vacaciones_hoy').textContent = data
                        .resumen.usuarios_con_vacaciones_hoy;
                    document.getElementById('usuarios_sin_vacaciones_hoy').textContent = data
                        .resumen.usuarios_sin_vacaciones_hoy;
                    document.getElementById('vacaciones_pendientes').textContent = data.resumen
                        .vacaciones_pendientes;
                })
                .catch(error => {
                    console.error('Error al cargar eventos:', error);
                    failureCallback(error);
                });
        },
        eventContent: function(arg) {
            const event = arg.event;
            if (event._def.extendedProps.tipo === "eventos") {
                const today = new Date();
                today.setHours(0, 0, 0, 0);

                let start = new Date(event.start);
                let end = new Date(event.end);

                start.setHours(0, 0, 0, 0);
                end.setHours(0, 0, 0, 0);

                // FullCalendar treats end as exclusive, so subtract 1 day if it ends at midnight
                if (event.allDay || event.endStr.includes('T00:00')) {
                    end.setDate(end.getDate() - 1);
                }

                function formatDate(date) {
                    return date.toISOString().split('T')[0]; // 'YYYY-MM-DD'
                }

                // Paso 1: Expandir todos los días feriados a un array de strings 'YYYY-MM-DD'
                const feriados = new Set(); // Usamos Set para comparación eficiente

                (event.extendedProps.feriados || []).forEach(f => {
                    let startF = new Date(f.fecha_i);
                    let endF = new Date(f.fecha_f);
                    feriados.add(formatDate(startF));

                });

                console.log(feriados);


                let diasTotal = 0;
                let diasDisfrutados = 0;
                let diasRestantes = 0;


                today.setHours(0, 0, 0, 0);

                for (let d = new Date(start); d <= end; d.setDate(d.getDate() + 1)) {
                    const fecha = new Date(d);
                    fecha.setHours(0, 0, 0, 0);

                    const fechaStr = formatDate(fecha);

                    if (!feriados.has(fechaStr)) {
                        diasTotal++;

                        if (fecha < today) {
                            diasDisfrutados++;
                        } else {
                            diasRestantes++;
                        }
                    }
                }


                const contenido = `
            <div class="fc-event-title" style="margin-top: 12px;"><strong>${event.extendedProps.usuario}</strong></div>
            <div class="fc-event-subtitle">Estado: ${event.extendedProps.estado}</div>
            <div class="fc-event-subtitle">Días disfrutados: ${diasDisfrutados}</div>
            <div class="fc-event-subtitle">Días restantes: ${diasRestantes}</div>
            <div class="fc-event-subtitle">Feriados: ${event.extendedProps.feriados.length}</div>`;


                const deleteButton = document.createElement('button');
                deleteButton.innerHTML = '<i class="fa fa-trash m-0"></i>';
                deleteButton.className =
                    'btn btn_fc text-white btn-outline-danger py-1 px-2 position-absolute border-0';
                deleteButton.style.top = '0rem';
                deleteButton.style.right = '0rem';
                deleteButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    $('#btn_eliminar_evento').data("id", event.id);
                    $('#modalEliminarEvento').modal('show');
                });

                const seeButton = document.createElement('button');
                seeButton.innerHTML = '<i class="fa fa-eye m-0"></i>';
                seeButton.className =
                    'btn btn_fc text-white btn-outline-info py-1 px-2 position-absolute border-0';
                seeButton.style.top = '0rem';
                seeButton.style.right = '27px';
                seeButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    $.ajax({
                        url: './api/vacaciones.php?id_vacacion=' + event.id,
                        type: 'GET',
                        cache: false,
                        dataType: 'json',
                        success: function(vacacion) {
                            $("#verUsuario").text(vacacion.extendedProps.usuario);
                            $("#verFechaInicio").text(vacacion.start);
                            $("#verFechaFin").text(vacacion.end);
                            $("#verEstado").text(vacacion.extendedProps.estado);
                            $("#verObservaciones").text(vacacion.extendedProps
                                .observaciones);
                            $('#modalVerEvento').modal('show');
                        }
                    });
                });

                const container = document.createElement('div');
                const texto = document.createElement('div');
                texto.innerHTML = contenido;
                container.appendChild(texto);
                container.appendChild(deleteButton);
                container.appendChild(seeButton);

                return {
                    domNodes: [container]
                };
            } else {
                const contenido = `
            <div class="fc-event-title"><strong>Feriado ${event.extendedProps.tipo2}</strong></div>
            <div class="fc-event-subtitle"></div><span>${event.extendedProps.descripcion}</span>`;
                const container = document.createElement('div');
                const texto = document.createElement('div');
                texto.innerHTML = contenido;
                container.appendChild(texto);
                return {
                    domNodes: [container]
                };
            }
        },
        eventDidMount: function(info) {





        },
        eventDrop: function(info) {
            const id_vacacion = info.event.id;
            const fecha_i = info.event.startStr;
            const fecha_f = new Date(info.event.end);
            fecha_f.setDate(fecha_f.getDate() - 1);
            const fechaFinFormateada = fecha_f.toISOString().split('T')[0];


            const data = {
                id_vacacion: id_vacacion,
                fecha_i: fecha_i,
                fecha_f: fechaFinFormateada,
                user_id: info.event.extendedProps.user_id,
                estado: info.event.extendedProps.estado,
                observaciones: info.event.extendedProps.observaciones
            };

            $.ajax({
                url: './api/vacaciones.php',
                method: 'POST',
                data: data,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $.toast({
                            heading: response.title,
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });

                        calendar.refetchEvents();
                    } else {
                        $.toast({
                            heading: 'Error',
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#ff5e5e',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        // Revertir cambio si fallo
                        info.revert();
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error en la petición AJAX:", error);
                    alert("Ocurrió un error al guardar los cambios.");
                    info.revert(); // Revertir si hay error
                }
            });
        },
        dateClick: function(info) {
            const fecha = info.dateStr;
            document.getElementById('fecha_i_vacacion').value = fecha;
            document.getElementById('fecha_f_vacacion').value = fecha;
            $('#modalCrearEvento').modal('show');
        },

        eventResize: function(info) {
            const id_vacacion = info.event.id;
            const fecha_i = info.event.startStr;

            // Restar 1 día a la fecha de fin
            const fecha_f = new Date(info.event.end);
            fecha_f.setDate(fecha_f.getDate() - 1);
            const fechaFinFormateada = fecha_f.toISOString().split('T')[0];

            const data = {
                id_vacacion: id_vacacion,
                fecha_i: fecha_i,
                fecha_f: fechaFinFormateada,
                user_id: info.event.extendedProps.user_id,
                estado: info.event.extendedProps.estado,
                observaciones: info.event.extendedProps.observaciones
            };

            $.ajax({
                url: './api/vacaciones.php',
                method: 'POST',
                data: data,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $.toast({
                            heading: response.title,
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        calendar.refetchEvents();
                    } else {
                        $.toast({
                            heading: 'Error',
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#ff5e5e',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        info.revert();
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error en la petición AJAX:", error);
                    alert("Ocurrió un error al guardar los cambios.");
                    info.revert();
                }
            });
        },
        eventClick: function(info) {
            const tipo = info.event.extendedProps.tipo;
            if (tipo !== "eventos") {
                // No hacer nada si no es del tipo adecuado
                return;
            }


            abrirModalEditarEvento(info.event);
        }
    });
    calendar.render();


    $(document).on("change", ".valor_personalizacion", function() {

        var nombre = $(this).data("nombre")

        var valor = (nombre != "automatico_presupuestos" && nombre !=

            "automatico_facturas") ? $(this).val() : $(

            "#" + nombre).prop(

            "checked")





        $.ajax({

            type: 'POST',

            url: './api/personalizacion.php',

            cache: false,

            async: false,

            data: {

                nombre: nombre,

                valor: valor

            },

            success: function(result2) {

                console.log(result2);

                $.toast({

                    heading: 'Valor cambiado.',

                    text: 'Se ha cambiado la configuración correctamente',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })

                calendar.refetchEvents();

            }

        });





    });


    $('#user_id_filtro, #estado_filtro, #localidad_filtro').on('change', function() {
        calendar.refetchEvents();
    });

    function getData(id_provincia, id = null) {

        var r

        $.ajax({

            url: "./api/users.php?id_provincia=" + id_provincia,

            type: 'GET',

            dataType: 'json', // added data type

            cache: false,

            async: false,

            dataType: "json",

            success: function(data) {

                data = data.map(function(item) {

                    return {

                        id: item.id_localidad,

                        text: item.nombre,

                        selected: (item.id_localidad == id) ? true : false

                    };

                })

                data.push({

                    id: 'No',

                    text: 'Ninguna',

                    selected: (id == "No") ? true : false

                });

                r = data

            }

        });

        return r

    }
    $('#provincia_filtro').on('change', function() {
        var id_provincia = $(this).val();
        var localidades = getData(id_provincia);

        $('#localidad_filtro').empty()

        $('#localidad_filtro').select2({

            data: getData(id_provincia)

        }).trigger("change");


        calendar.refetchEvents();
    });
    $('#id_provincia_usuario').on('change', function() {
        var id_provincia = $(this).val();
        var id_localidad = $(this).data("id_localidad") || "No";
        var localidades = getData(id_provincia);

        $('#id_localidad_usuario').empty()

        $('#id_localidad_usuario').select2({

            data: getData(id_provincia, id_localidad)

        }).trigger("change");


        calendar.refetchEvents();
    });
    let eventoSeleccionado = null;

    $('.colores_user').on('change', function() {
        const userId = $(this).data('id');
        const color = $(this).val();

        $.ajax({
            url: 'api/citas.php',
            type: 'POST',
            data: {
                user_id: userId,
                color: color
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $.toast({
                        heading: response.title,
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    calendar.refetchEvents();
                } else {
                    $.toast({
                        heading: 'Error',
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#ff5e5e',
                        icon: 'error',
                        hideAfter: 2000,
                        stack: 6
                    });
                    // Revertir cambio si fallo
                    calendar.refetchEvents();
                }
            },
            error: function(xhr, status, error) {
                console.error("Error en la petición AJAX:", error);
                alert("Ocurrió un error al guardar los cambios.");

            }
        });
    });
    $('#btn_eliminar_evento').click(function() {
        var id = $(this).data("id");
        $.ajax({

            type: 'DELETE',

            url: './api/vacaciones.php?id_vacacion=' + id,

            cache: false,

            async: false,

            success: function(result) {





                $.toast({

                    heading: 'Período eliminado',

                    text: 'Se ha eliminado el período del sistema correctamente',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })




                $('#modalEliminarEvento').modal('hide');

                calendar.refetchEvents();



            }

        });

    })

    function abrirModalEditarEvento(evento) {
        eventoSeleccionado = evento;

        $.ajax({

            url: './api/vacaciones.php?id_vacacion=' + evento.id,

            type: 'GET',

            cache: false,



            dataType: 'json', // added data type

            success: function(vacacion) {

                console.log(vacacion);



                document.getElementById('fecha_i_vacacion_editar').value = vacacion.start;
                document.getElementById('fecha_f_vacacion_editar').value = vacacion.end;
                $('#user_id_vacacion_editar').val(vacacion.extendedProps
                    .user_id).trigger('change'); // Cambia el valor del select2
                $('#estado_vacacion_editar').val(vacacion.extendedProps
                    .estado).trigger('change'); // Cambia el valor del select2
                $('#observaciones_vacacion_editar').val(vacacion.extendedProps
                    .observaciones).trigger('change');

                $('#btn_guardar_evento').data("id", evento.id);
                $('#modalEditarEvento').modal('show');

            }

        });

    }

    document.getElementById('btn_guardar_evento').addEventListener('click', function() {
        if (!eventoSeleccionado) return;


        const fecha_i = $('#fecha_i_vacacion_editar').val();
        const fecha_f = $('#fecha_f_vacacion_editar').val();
        const user_id = $('#user_id_vacacion_editar').val();
        const estado = $('#estado_vacacion_editar').val()
        const id_vacacion = $('#btn_guardar_evento').data("id"); // Solo si es update
        const observaciones = $('#observaciones_vacacion_editar').val()

        const data = {
            observaciones: observaciones,
            fecha_i: fecha_i,
            fecha_f: fecha_f,
            user_id: user_id,
            estado: estado,
            id_vacacion: id_vacacion
        };

        // Agregar id_vacacion si existe (para update)
        /*
            if (id_vacacion) {
                data.id_vacacion = id_vacacion;
            }
        */
        $.ajax({
            url: './api/vacaciones.php',
            method: 'POST',
            cache: false,
            data: data,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $.toast({

                        heading: response.title,

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })
                    calendar.refetchEvents();
                    $('#modalEditarEvento').modal('hide');




                    // Aquí podrías limpiar el formulario, cerrar un modal, etc.
                } else {
                    $.toast({

                        heading: 'Error',

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#ff5e5e',

                        icon: 'error',

                        hideAfter: 2000,

                        stack: 6

                    });

                }
            },
            error: function(xhr, status, error) {
                console.error("Error en la petición AJAX:", error);
                alert("Ocurrió un error al enviar los datos.");
            }
        });
    });

    document.getElementById('btn_add_evento').addEventListener('click', function() {

        const fecha_i = $('#fecha_i_vacacion').val();
        const fecha_f = $('#fecha_f_vacacion').val();
        const user_id = $('#user_id_vacacion').val();
        const estado = $('#estado_vacacion').val();
        // const id_vacacion = $('#id_vacacion').val(); // Solo si es update
        const observaciones = $('#observaciones_vacacion').val()
        const data = {
            observaciones: observaciones,
            fecha_i: fecha_i,
            fecha_f: fecha_f,
            user_id: user_id,
            estado: estado
        };

        // Agregar id_vacacion si existe (para update)
        /*
            if (id_vacacion) {
                data.id_vacacion = id_vacacion;
            }
        */
        $.ajax({
            url: './api/vacaciones.php',
            method: 'POST',
            cache: false,
            data: data,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $.toast({

                        heading: response.title,

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })
                    calendar.refetchEvents();
                    $('#modalCrearEvento').modal('hide');




                    // Aquí podrías limpiar el formulario, cerrar un modal, etc.
                } else {
                    $.toast({

                        heading: 'Error',

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#ff5e5e',

                        icon: 'error',

                        hideAfter: 2000,

                        stack: 6

                    });

                }
            },
            error: function(xhr, status, error) {
                console.error("Error en la petición AJAX:", error);
                alert("Ocurrió un error al enviar los datos.");
            }
        });
    });




};
</script>