<div class="content-wrapper">
    <div class="row profile-page ">

        <div class="col-md-4">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/sylzqxek.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Citas totales</p>

                        <span id="citas_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-4">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/kamzpmlj.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Citas hoy</p>

                        <span id="hoy_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-4">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">

                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/cetdawbe.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Citas pendientes</p>

                        <span id="futuras_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>
    <div class="row profile-page">
        <div class="col-lg-3 col-xl-2">
            <div class="card card-cuenta">

                <div class="card-header mb-0">

                    <div class="row">

                        <div class="col-12">
                            <h4 class="mb-0 text-center text-sm-left" style="line-height: .9;">Miembros</h4>


                        </div>

                    </div>

                </div>

                <div class="card-body card-table-body p-3">


                    <ul style="list-style: none; padding: 0; margin: 0;">
                        <?php foreach ($User_List as $User) { ?>
                        <li class="d-flex justify-content-between align-items-center mb-2">
                            <div class="d-flex align-items-center">
                                <img src="<?php echo htmlentities($User['user_avatar'], ENT_QUOTES); ?>" alt="Avatar"
                                    class="rounded-circle mr-2" width="40" height="40">
                                <span><?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?></span>
                            </div>
                            <input type="color" name="color" data-id=<?php echo $User['user_id']; ?> value="<?php 
                            if($User['color'] == null){
                               echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES);
                            }else{
                                echo htmlentities($User['color'], ENT_QUOTES);
                            } ?>" class="colores_user form-control form-control-color"
                                style="width: 40px !important;padding: 4px !important;cursor:pointer;"
                                id="exampleColorInput">

                        </li>
                        <?php } ?>

                    </ul>




                </div>

            </div>
        </div>

        <div class="col-lg-9 col-xl-10">



            <div class="card card-cuenta">

                <div class="card-header mb-0">

                    <div class="row">

                        <div class="col-12 d-flex justify-content-start align-items-center">
                            <h4 class="mb-0 text-center text-sm-left" style="line-height: .9;">Calendario de citas</h4>

                            <i class="ml-2 fas fa-cog " style="cursor: pointer;font-size: 18px;" data-toggle="modal"
                                data-target="#modalConfiguracion" title="Configuración"></i>
                        </div>

                    </div>

                </div>

                <div class="card-body card-table-body p-3">


                    <div id="calendar2"></div>




                </div>

            </div>

        </div>



    </div>
</div>





<!-- MODALS -->



<div class="modal fade" id="modalCrearEvento" role="dialog" aria-labelledby="modalCrearEventoLabel">
    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar cita</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>

            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_evento">Miembro</label>
                                <select id="user_id_cita"
                                    class="form-control custom-select text-center select2 select_users">



                                    <?php

                                    foreach ($User_List as $User)

                                        {



                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>



                                    <?php } ?>





                                </select>
                            </div>

                            <div class="form-group">

                                <label>Servicio</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_servicio file-upload-browse btn btn-danger"
                                            data-target="id_servicio_cita" type="button">-</button>

                                    </span>

                                    <select id="id_servicio_cita"
                                        class="select_servicios custom-select select2 form-control validable">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarServicio">+</button>

                                    </span>

                                </div>

                            </div>
                            <div class="form-group">

                                <label>Cliente</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                            data-target="client_id_cita" type="button">-</button>

                                    </span>

                                    <select id="client_id_cita"
                                        class="select_clientes custom-select select2 form-control validable">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCliente">+</button>

                                    </span>

                                </div>

                            </div>

                            <div class="form-group">
                                <label for="fecha_i_cita">Fecha de inicio</label>
                                <input class="form-control validable" id="fecha_i_cita" type="time">
                            </div>

                            <div class="form-group">
                                <label for="fecha_f_cita">Fecha de fin</label>
                                <input class="form-control validable" id="fecha_f_cita" type="time">
                            </div>

                            <div class="form-group">
                                <label for="titulo_evento">Estado</label>
                                <select id="estado_cita" class="form-control custom-select text-center select2">
                                    <option type="text" value="Aceptado">

                                        Aceptado

                                    </option>

                                    <option type="text" value="Pendiente">

                                        Pendiente

                                    </option>
                                    <option type="text" value="Rechazado">

                                        Rechazado

                                    </option>






                                </select>
                            </div>
                            <div class="form-group toggleable-form-group">

                                <label class="custom-control custom-checkbox d-inline-block"
                                    style="height: auto;min-height: unset;display: block !important;">

                                    <input type="checkbox" class="custom-control-input apartado toggle-input-checkbox"
                                        data-toggle="tiempo_cita">

                                    <span style="font-size: 14px;" class="custom-control-label">Avisar con antelación de
                                        la cita con SMS</span>

                                </label>


                                <div class="input-group">

                                    <input type="number" id="tiempo_cita" class="form-control toggle-input-target"
                                        disabled>

                                    <span class="input-group-append">

                                        <span class="input-group-text">
                                            Horas
                                        </span>

                                    </span>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="modal-footer text-right">
                <button id="btn_add_evento" class="btn btn-success btn-fw" type="button">Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal para editar evento -->
<div class="modal fade" id="modalEditarEvento" role="dialog" aria-labelledby="modalEditarEventoLabel">
    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar cita</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>

            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_evento">Miembro</label>
                                <select id="user_id_cita_editar"
                                    class="form-control custom-select text-center select2 select_users">



                                    <?php

                                    foreach ($User_List as $User)

                                        {



                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>



                                    <?php } ?>





                                </select>
                            </div>

                            <div class="form-group">

                                <label>Servicio</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_servicio file-upload-browse btn btn-danger"
                                            data-target="id_servicio_cita_editar" type="button">-</button>

                                    </span>

                                    <select id="id_servicio_cita_editar"
                                        class="select_servicios custom-select select2 form-control validable">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarServicio">+</button>

                                    </span>

                                </div>

                            </div>
                            <div class="form-group">

                                <label>Cliente</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                            data-target="client_id_cita_editar" type="button">-</button>

                                    </span>

                                    <select id="client_id_cita_editar"
                                        class="select_clientes custom-select select2 form-control validable">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarCliente">+</button>

                                    </span>

                                </div>

                            </div>

                            <div class="form-group">
                                <label for="fecha_i_cita">Fecha de inicio</label>
                                <input class="form-control validable" id="fecha_i_cita_editar" type="time">
                            </div>

                            <div class="form-group">
                                <label for="fecha_f_cita">Fecha de fin</label>
                                <input class="form-control validable" id="fecha_f_cita_editar" type="time">
                            </div>

                            <div class="form-group">
                                <label for="titulo_evento">Estado</label>
                                <select id="estado_cita_editar" class="form-control custom-select text-center select2">
                                    <option type="text" value="Aceptado">

                                        Aceptado

                                    </option>

                                    <option type="text" value="Pendiente">

                                        Pendiente

                                    </option>
                                    <option type="text" value="Rechazado">

                                        Rechazado

                                    </option>






                                </select>
                            </div>
                            <div class="form-group toggleable-form-group">

                                <label class="custom-control custom-checkbox d-inline-block"
                                    style="height: auto;min-height: unset;display: block !important;">

                                    <input type="checkbox" class="custom-control-input apartado toggle-input-checkbox"
                                        data-toggle="tiempo_cita_editar">

                                    <span style="font-size: 14px;" class="custom-control-label">Avisar con antelación de
                                        la cita con SMS</span>

                                </label>


                                <div class="input-group">

                                    <input type="number" id="tiempo_cita_editar"
                                        class="form-control toggle-input-target" disabled>

                                    <span class="input-group-append">

                                        <span class="input-group-text">
                                            Horas
                                        </span>

                                    </span>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer text-right">
                <button id="btn_guardar_evento" class="btn btn-success btn-fw" type="button">
                    Guardar cambios
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar
                </button>
            </div>

        </div>
    </div>
</div>

<div class="modal fade modal-cambiar" id="modalEliminarEvento" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar período</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el período definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button id="btn_eliminar_evento" class="btn btn-danger btn-fw" type="button" name="">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>


<div class="modal fade" id="modalConfiguracion" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Envío de notificaciones</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <form method="POST" action="">

                <div class="modal-body pb-0">

                    <div class="container p-0">

                        <div class="row">



                            <div class="col-12">

                                <div class="row">
                                    <div class="col-12">
                                        <h4 class="mb-2">SMS</h4>
                                    </div>
                                    <div class="col-12 mb-1">
                                        <h5 class="mb-2">Tags</h5>
                                        <div style=" " class="mb-0 row">
                                            <div class="col-4 pr-0">
                                                <button
                                                    class="w-100 p-2 btn btn-success btn-fw mb-2 mr-2 tag_button_cita"
                                                    type="button" data-tag="nombre">
                                                    %nombre%</button>
                                            </div>
                                            <div class="col-4">
                                                <button
                                                    class="w-100 p-2 btn btn-success btn-fw mb-2 mr-2 tag_button_cita"
                                                    type="button" data-tag="nombreyapellido">
                                                    %nombreyapellido%</button>
                                            </div>
                                            <div class="col-4 pl-0">
                                                <button
                                                    class="w-100 p-2 btn btn-success btn-fw mb-2 mr-2 tag_button_cita"
                                                    type="button" data-tag="fechadehoy">
                                                    %fechadehoy%</button>
                                            </div>
                                            <div class="col-4 pr-0">
                                                <button
                                                    class="w-100 p-2 btn btn-success btn-fw mb-2 mr-2 tag_button_cita"
                                                    type="button" data-tag="fechainicio">
                                                    %fechainicio%</button>
                                            </div>
                                            <div class="col-4">
                                                <button
                                                    class="w-100 p-2 btn btn-success btn-fw mb-2 mr-2 tag_button_cita"
                                                    type="button" data-tag="fechafin">
                                                    %fechafin%</button>
                                            </div>
                                            <div class="col-4 pl-0">
                                                <button
                                                    class="w-100 p-2 btn btn-success btn-fw mb-2 mr-2 tag_button_cita"
                                                    type="button" data-tag="horainicio">
                                                    %horainicio%</button>
                                            </div>
                                            <div class="col-4 pr-0">
                                                <button
                                                    class="w-100 p-2 btn btn-success btn-fw mb-2 mr-2 tag_button_cita"
                                                    type="button" data-tag="horafin">
                                                    %horafin%</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 mb-0">
                                        <div class="form-group mb-0">
                                            <h5>Cuerpo</h5>
                                            <textarea id="cuerpo_cita" class="form-control valor_personalizacion"
                                                data-nombre="mensaje_cita_sms"><?php echo html_entity_decode($personalizacion['mensaje_cita_sms']); ?></textarea>
                                        </div>
                                    </div>

                                </div>

                            </div>










                        </div>

                    </div>



                </div>

                <div class="modal-footer text-right">



                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>

            </form>
            <!-- /modal-body -->

        </div>

    </div>

</div>

<?php require_once __VIEWS__ . 'selects/servicios.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/subcategorias.template.php'; ?>
<style>
#calendar2 {
    height: auto !important;
    max-height: none !important;
    overflow: visible !important;
}

/* Estilo del botón */
textarea#cuerpo_cita {
    height: 100% !important;
    min-height: 110px !important;
}

.fc-scroller-harness,
.fc-scroller {
    overflow: visible !important;
    max-height: none !important;
}

.fc-theme-standard th {
    padding-left: 0 !important;
    padding-right: 0 !important;
}

.fc-col-header-cell-cushion {
    text-transform: uppercase;

}

.fc-h-event .fc-event-main {}

.fc-toolbar-title {
    text-transform: uppercase;
    font-size: 20px;
}

button.fc-button {
    line-height: 1 !important;
}

.fc-daygrid-day-frame {
    cursor: pointer !important;
}

.fc .fc-toolbar.fc-header-toolbar {
    margin-bottom: 1em;
}

.fc-daygrid-day-events {
    width: 100%;
    max-width: 100%;
    transition: all 0.6s ease !important;
}

.fc-daygrid-day-events:hover {

    width: 250px;
    max-width: unset;
    z-index: 1000;
}

.fc-event-start {

    padding: 5px;
}

@media (max-width: 567px) {
    .fc-header-toolbar {
        display: flex !important;
        flex-direction: column !important;
    }

    .fc-toolbar-title {

        margin-top: 15px !important;
        margin-bottom: 15px !important;
    }

}
</style>
<script>
window.onload = function() {





    const calendarEl = document.getElementById('calendar2');

    let defaultView = window.innerWidth < 768 ? 'listWeek' : 'dayGridMonth';
    if (!calendarEl || typeof FullCalendar === 'undefined') {
        console.error("FullCalendar no está definido o no se encontró el div #calendar");
        return;
    }

    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        locale: 'es',
        contentHeight: 'auto',
        height: 'auto',
        allDaySlot: false,
        expandRows: true, // especialmente importante en 'timeGridWeek'
        dayMaxEventRows: true,
        slotLabelFormat: {
            hour: '2-digit',
            minute: '2-digit',
            hour12: false
        },
        slotDuration: '00:30:00', // Intervalo de 30 minutos
        slotLabelInterval: '00:30:00',
        dayHeaderFormat: {
            weekday: 'long'
        }, // Configura el idioma a español

        views: {
            timeGridWeek: {
                dayHeaderFormat: {
                    weekday: 'short',
                    day: 'numeric',
                    month: 'long'
                }
            },
            timeGridDay: {
                dayHeaderFormat: {
                    weekday: 'short',
                    day: 'numeric',
                    month: 'long'
                }
            }
            // No ponemos nada para dayGridMonth para que quede con el formato por defecto
        },
        dayHeaderContent: function(arg) {
            const diasCortos = ['DOM', 'LUN', 'MAR', 'MIÉ', 'JUE', 'VIE', 'SÁB'];
            return window.innerWidth < 768 ?
                diasCortos[arg.date.getDay()] :
                arg.text; // Usa el texto completo por defecto
        },
        buttonText: {
            prev: 'Anterior', // Texto del botón "prev"
            next: 'Siguiente', // Texto del botón "next"
            today: 'Hoy', // Texto del botón "today"
            dayGridMonth: 'Mes', // Texto del botón "prev"
            timeGridWeek: 'Semana', // Texto del botón "next"
            timeGridDay: 'Hoy' // Texto del botón "today"
        },
        titleFormat: { // Formato personalizado del título
            month: 'long', // Nombre completo del mes (ej. "Mayo")
            year: 'numeric', // Año completo (ej. "2025")
        }, // muestra nombres completos

        headerToolbar: { // Custom toolbar configuration
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay',
        },
        editable: true, // Permite mover y redimensionar eventos
        eventResizableFromStart: true,
        events: function(fetchInfo, successCallback, failureCallback) {
            fetch('api/citas.php?action=obtenerEventos&_=' + new Date().getTime())
                .then(response => response.json())
                .then(data => {
                    // Pasamos los eventos al calendario
                    successCallback(data.eventos);


                    // Extraemos y mostramos los totales
                    const totalCitas = data.totales.total;
                    const totalHoy = data.totales.hoy;
                    const totalFuturas = data.totales.futuras;

                    document.getElementById('citas_count').textContent = totalCitas;
                    document.getElementById('hoy_count').textContent = totalHoy;
                    document.getElementById('futuras_count').textContent = totalFuturas;
                })
                .catch(error => {
                    console.error('Error al cargar eventos:', error);
                    failureCallback(error);
                });

        },

        eventContent: function(arg) {
            const event = arg.event;

            const start = new Date(event.start);
            const end = new Date(event.end);

            // Formatear la hora (por ejemplo: 09:00 - 11:30)
            const horaInicio = start.toLocaleTimeString('es-ES', {
                hour: '2-digit',
                minute: '2-digit'
            });
            const horaFin = end.toLocaleTimeString('es-ES', {
                hour: '2-digit',
                minute: '2-digit'
            });
            const horario = `${horaInicio} - ${horaFin}`;

            let estado2 = event._def.extendedProps.estado;

            // Mostrar la información dentro del evento
            const contenido = `
        <div class="fc-event-title">${event.extendedProps.servicio}</div>
        <div class="fc-event-subtitle">Horario: ${horario}</div>
        <div class="fc-event-subtitle">Estado: ${estado2}</div>
        <div class="fc-event-subtitle">Cliente: ${event.extendedProps.cliente}</div>
        <div class="fc-event-subtitle">Miembro: ${event.extendedProps.usuario}</div>
    `;

            // Crear el botón de eliminar
            const deleteButton = document.createElement('button');
            deleteButton.innerHTML = '<i class="fa fa-trash m-0"></i>';
            deleteButton.className =
                'btn text-white btn-outline-danger py-1 px-2 position-absolute border-0';
            deleteButton.style.top = '0rem';
            deleteButton.style.right = '0rem';
            deleteButton.addEventListener('click', function(e) {
                e.stopPropagation();
                $('#btn_eliminar_evento').data("id", event.id);
                $('#modalEliminarEvento').modal('show');
            });


            const container = document.createElement('div');
            container.style.backgroundColor = event.extendedProps.color;
            const texto = document.createElement('div');
            texto.innerHTML = contenido;
            container.appendChild(texto);
            container.appendChild(deleteButton);

            return {
                domNodes: [container]
            };
        },
        eventDidMount: function(info) {
            const color = info.event.extendedProps.color || '#007aff';

            // Esto cambia el fondo del evento completo
            info.el.style.backgroundColor = color;
            info.el.style.borderColor = color;
            info.el.style.color = 'white'; // texto blanco para contraste
        },
        eventDrop: function(info) {



            const id_cita = info.event.id;
            const fecha_i = moment(info.event.startStr).format('YYYY-MM-DD HH:mm:ss');
            const fecha_f = moment(info.event.end).format('YYYY-MM-DD HH:mm:ss');



            const data = {
                id_cita: id_cita,
                fecha_i: fecha_i,
                fecha_f: fecha_f,
                tiempo: info.event.extendedProps.tiempo,
                client_id: info.event.extendedProps.client_id,
                id_servicio: info.event.extendedProps.id_servicio,
                user_id: info.event.extendedProps.user_id,
                estado: info.event.extendedProps.estado
            };

            $.ajax({
                url: './api/citas.php',
                method: 'POST',
                data: data,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $.toast({
                            heading: response.title,
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                    } else {
                        $.toast({
                            heading: 'Error',
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#ff5e5e',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        // Revertir cambio si fallo
                        info.revert();
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error en la petición AJAX:", error);
                    alert("Ocurrió un error al guardar los cambios.");
                    info.revert(); // Revertir si hay error
                }
            });
        },
        dateClick: function(info) {
            const fecha = info.dateStr.split('T')[0]; // Extrae solo la parte de la fecha
            console.log(fecha);

            $("#btn_add_evento").data("fecha", fecha);

            //document.getElementById('fecha_i_cita').value = fecha;
            //document.getElementById('fecha_f_cita').value = fecha;
            $('#modalCrearEvento').modal('show');
        },

        eventResize: function(info) {
            const id_cita = info.event.id;
            const fecha_i = moment(info.event.startStr).format('YYYY-MM-DD HH:mm:ss');
            const fecha_f = moment(info.event.end).format('YYYY-MM-DD HH:mm:ss');



            const data = {
                id_cita: id_cita,
                fecha_i: fecha_i,
                fecha_f: fecha_f,
                tiempo: info.event.extendedProps.tiempo,
                client_id: info.event.extendedProps.client_id,
                id_servicio: info.event.extendedProps.id_servicio,
                user_id: info.event.extendedProps.user_id,
                estado: info.event.extendedProps.estado
            };

            $.ajax({
                url: './api/citas.php',
                method: 'POST',
                data: data,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $.toast({
                            heading: response.title,
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                    } else {
                        $.toast({
                            heading: 'Error',
                            text: response.message,
                            position: 'top-right',
                            loaderBg: '#ff5e5e',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        info.revert();
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error en la petición AJAX:", error);
                    alert("Ocurrió un error al guardar los cambios.");
                    info.revert();
                }
            });
        },
        eventClick: function(info) {



            abrirModalEditarEvento(info.event);
        }
    });
    calendar.render();


    let eventoSeleccionado = null;
    $('.colores_user').on('change', function() {
        const userId = $(this).data('id');
        const color = $(this).val();

        $.ajax({
            url: 'api/citas.php',
            type: 'POST',
            data: {
                user_id: userId,
                color: color
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $.toast({
                        heading: response.title,
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    calendar.refetchEvents();
                } else {
                    $.toast({
                        heading: 'Error',
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#ff5e5e',
                        icon: 'error',
                        hideAfter: 2000,
                        stack: 6
                    });
                    // Revertir cambio si fallo
                    calendar.refetchEvents();
                }
            },
            error: function(xhr, status, error) {
                console.error("Error en la petición AJAX:", error);
                alert("Ocurrió un error al guardar los cambios.");

            }
        });
    });

    $('#btn_eliminar_evento').click(function() {
        var id = $(this).data("id");
        $.ajax({

            type: 'DELETE',

            url: './api/citas.php?id_cita=' + id,

            cache: false,

            async: false,

            success: function(result) {





                $.toast({

                    heading: 'Cita eliminada',

                    text: 'Se ha eliminado la cita del sistema correctamente',

                    position: 'top-right',

                    loaderBg: '#32a852',

                    icon: 'success',

                    hideAfter: 2000,

                    stack: 6

                })




                $('#modalEliminarEvento').modal('hide');

                calendar.refetchEvents();



            }

        });

    })

    function abrirModalEditarEvento(evento) {
        eventoSeleccionado = evento;
        const fecha = moment(evento.start).format('YYYY-MM-DD');
        console.log(fecha);

        $("#btn_guardar_evento").data("fecha", fecha);
        $.ajax({

            url: './api/citas.php?id_cita=' + evento.id,

            type: 'GET',

            cache: false,



            dataType: 'json', // added data type

            success: function(vacacion) {

                console.log(vacacion);
                $("#client_id_cita_editar").data("edit", vacacion.extendedProps.client_id).trigger(
                    "change")
                $("#id_servicio_cita_editar").data("edit", vacacion.extendedProps.id_servicio).trigger(
                    "change")


                document.getElementById('fecha_i_cita_editar').value = moment(vacacion.start)
                    .format('HH:mm:ss');
                document.getElementById('fecha_f_cita_editar').value = moment(vacacion.end).format(
                    'HH:mm:ss');
                $('#user_id_cita_editar').val(vacacion.extendedProps
                    .user_id).trigger('change'); // Cambia el valor del select2
                $('#estado_cita_editar').val(vacacion.extendedProps
                    .estado).trigger('change'); // Cambia el valor del select2
                $('#btn_guardar_evento').data("id", evento.id);
                const checkbox = $('input[type="checkbox"][data-toggle="tiempo_cita_editar"]');

                if (vacacion.extendedProps.tiempo != null) {
                    $("#tiempo_cita_editar").val(vacacion.extendedProps.tiempo);

                    checkbox.prop('checked', true);
                    $('#tiempo_cita_editar').prop('disabled', false);
                } else {
                    $("#tiempo_cita_editar").val('');
                    checkbox.prop('checked', false);
                    $('#tiempo_cita_editar').prop('disabled', true);
                }


                $('#modalEditarEvento').modal('show');


            }

        });

    }

    document.getElementById('btn_guardar_evento').addEventListener('click', function() {
        if (!eventoSeleccionado) return;
        var repetido = false


        // Recorrer todos los inputs .verificable dentro del modal
        document.querySelectorAll('#modalEditarEvento .validable').forEach(input => {


            const evento = new CustomEvent('validar', {
                bubbles: true,
                detail: {
                    mensaje: 'Campo requerido'
                }
            });

            // Disparar el evento de validación para cada input
            input.dispatchEvent(evento);

            // Si alguno de los inputs no es válido, marcamos todosValidos como falso
            if (!input.isValid) {
                repetido = true;
            }
        });




        if (repetido) {



            return false;

        }

        const id_servicio = $('#id_servicio_cita_editar').val();
        const client_id = $('#client_id_cita_editar').val();
        const fecha_i = moment($("#btn_guardar_evento").data("fecha") + " " + $('#fecha_i_cita_editar')
                .val())
            .format(
                'YYYY-MM-DD HH:mm:ss');
        const fecha_f = moment($("#btn_guardar_evento").data("fecha") + " " + $('#fecha_f_cita_editar')
                .val())
            .format(
                'YYYY-MM-DD HH:mm:ss');
        const user_id = $('#user_id_cita_editar').val();
        const estado = $('#estado_cita_editar').val();
        const $input = $('#tiempo_cita_editar');
        const tiempo = ($input.val() === '' || $input.prop('disabled')) ? 'No' : $input.val();

        const id_cita = $('#btn_guardar_evento').data("id"); // Solo si es update

        const data = {
            id_servicio: id_servicio,
            client_id: client_id,
            fecha_i: fecha_i,
            fecha_f: fecha_f,
            user_id: user_id,
            estado: estado,
            tiempo: tiempo,
            id_cita: id_cita
        };

        // Agregar id_vacacion si existe (para update)
        /*
            if (id_vacacion) {
                data.id_vacacion = id_vacacion;
            }
        */
        $.ajax({
            url: './api/citas.php',
            method: 'POST',
            cache: false,
            data: data,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $.toast({

                        heading: response.title,

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })
                    calendar.refetchEvents();
                    $('#modalEditarEvento').modal('hide');




                    // Aquí podrías limpiar el formulario, cerrar un modal, etc.
                } else {
                    $.toast({

                        heading: 'Error',

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#ff5e5e',

                        icon: 'error',

                        hideAfter: 2000,

                        stack: 6

                    });

                }
            },
            error: function(xhr, status, error) {
                console.error("Error en la petición AJAX:", error);
                alert("Ocurrió un error al enviar los datos.");
            }
        });
    });

    document.getElementById('btn_add_evento').addEventListener('click', function() {


        var repetido = false


        // Recorrer todos los inputs .verificable dentro del modal
        document.querySelectorAll('#modalCrearEvento .validable').forEach(input => {


            const evento = new CustomEvent('validar', {
                bubbles: true,
                detail: {
                    mensaje: 'Campo requerido'
                }
            });

            // Disparar el evento de validación para cada input
            input.dispatchEvent(evento);

            // Si alguno de los inputs no es válido, marcamos todosValidos como falso
            if (!input.isValid) {
                repetido = true;
            }
        });




        if (repetido) {



            return false;

        }

        const id_servicio = $('#id_servicio_cita').val();
        const client_id = $('#client_id_cita').val();
        const fecha_i = moment($("#btn_add_evento").data("fecha") + " " + $('#fecha_i_cita').val()).format(
            'YYYY-MM-DD HH:mm:ss');
        const fecha_f = moment($("#btn_add_evento").data("fecha") + " " + $('#fecha_f_cita').val()).format(
            'YYYY-MM-DD HH:mm:ss');
        const user_id = $('#user_id_cita').val();
        const estado = $('#estado_cita').val();
        // const id_vacacion = $('#id_vacacion').val(); // Solo si es update
        const $input = $('#tiempo_cita');
        const tiempo = ($input.val() === '' || $input.prop('disabled')) ? 'No' : $input.val();
        const data = {
            id_servicio: id_servicio,
            client_id: client_id,
            fecha_i: fecha_i,
            fecha_f: fecha_f,
            user_id: user_id,
            tiempo: tiempo,
            estado: estado
        };

        // Agregar id_vacacion si existe (para update)
        /*
            if (id_vacacion) {
                data.id_vacacion = id_vacacion;
            }
        */
        $.ajax({
            url: './api/citas.php',
            method: 'POST',
            cache: false,
            data: data,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $.toast({

                        heading: response.title,

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })
                    calendar.refetchEvents();
                    $('#modalCrearEvento').modal('hide');




                    // Aquí podrías limpiar el formulario, cerrar un modal, etc.
                } else {
                    $.toast({

                        heading: 'Error',

                        text: response.message,

                        position: 'top-right',

                        loaderBg: '#ff5e5e',

                        icon: 'error',

                        hideAfter: 2000,

                        stack: 6

                    });

                }
            },
            error: function(xhr, status, error) {
                console.error("Error en la petición AJAX:", error);
                alert("Ocurrió un error al enviar los datos.");
            }
        });
    });




};
</script>


<script>
(function($) {

    'use strict';

    $(function() {

        const textarea = document.getElementById("cuerpo_cita");

        let oldValue = textarea.value;

        textarea.addEventListener("input", function() {
            if (this.value.length > 200) {
                this.value = oldValue; // Restaurar el valor anterior
                $.toast({
                    heading: 'Mensaje muy largo',
                    text: 'El mensaje puede tener 200 caracteres como máximo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return false
            } else {
                oldValue = this.value; // Guardar el nuevo valor válido
            }

        });

        function insertCustomText(tag) {
            $('#cuerpo_cita').val($('#cuerpo_cita').val() + '%' + tag + '%');
        }


        $(document).on("click", ".tag_button_cita", function() {
            var tag = $(this).data("tag")
            insertCustomText(tag)
        });

        $(document).on("change", ".valor_personalizacion", function() {
            var nombre = $(this).data("nombre")
            var valor = $(this).val()

            $.ajax({
                type: 'POST',
                url: './api/personalizacion.php',
                cache: false,
                async: false,
                data: {
                    nombre: nombre,
                    valor: valor
                },
                success: function(result2) {
                    console.log(result2);
                    $.toast({
                        heading: 'Valor cambiado.',
                        text: 'Se ha cambiado la configuración correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })

                }
            });


        });
    });

})(jQuery);
</script>