<style>
.custom-control-label::before,
.custom-control-label::after {
    top: 0rem !important;
}

.round {
    line-height: 48px;
    color: #ffffff;
    width: 50px;
    height: 50px;
    display: flex;
    justify-content: center;
    align-items: center;
    font-weight: 400;
    text-align: center;
    border-radius: 100%;
    background: #20aee3;
}
</style>
<div class="content-wrapper">



    <div class="row profile-page ">



        <div class="col-md-6 mb-8">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/qfabemmy.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">ARTÍCULOS</p>

                        <span id="articulos_count"></span>

                    </div>

                </div>

            </div>

        </div>
        <div class="col-md-6 mb-8">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/ldmqkrgd.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">KITS</p>

                        <span id="kits_count"></span>

                    </div>

                </div>

            </div>

        </div>
    </div>



    <div class="row profile-page mb-3 mb-sm-4">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">



                    <div class="pt-0 ">



                        <div class="row ">

                            <!-- Historial de Acceso -->



                            <div class="col-md-12">




                                <div class="card card-cuenta">




                                    <div class="card-body card-table-body">
                                        <h4 class="mb-3 mb-sm-4">Artículos</h4>

                                        <button data-toggle="modal" data-target="#modalAgregarArticulo"
                                            class="mb-3 mb-sm-4 btn btn-sm btn-primary">Agregar</button>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="my-input">Filtrar por ubicación</label>

                                                    <select id="filtro_ubicacion"
                                                        class="select_ubicaciones filtros form-control custom-select text-center select2">


                                                    </select>





                                                </div>
                                            </div>
                                        </div>

                                        <div class="table-responsive">

                                            <table id="tabla_articulos"
                                                class="tabla_articulos table stripe row-border order-column">

                                                <thead>

                                                    <tr>

                                                        <th
                                                            style="padding-left: 32px !important;padding-right: 50px !important;">
                                                            ID</th>

                                                        <th>Nombre</th>

                                                        <th>Descripción</th>

                                                        <th>Ubicación</th>

                                                        <th>Stock</th>

                                                        <th>Precio unitario</th>

                                                        <th>Activo/Bloqueado</th>





                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>




                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminaci贸n de cuenta -->



                            <!-- /Eliminaci贸n de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>
    <div class="row profile-page">

        <div class="col-12">

            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">



                    <div class="pt-0 ">



                        <div class="row ">

                            <!-- Historial de Acceso -->



                            <div class="col-md-12">




                                <div class="card card-cuenta">




                                    <div class="card-body card-table-body">
                                        <h4 class="mb-3 mb-sm-4">Kits</h4>

                                        <button id="btn_kits" data-toggle="modal" data-target="#modalAgregarKit"
                                            class="mb-3 mb-sm-4 btn btn-sm btn-primary">Agregar</button>

                                        <div class="table-responsive">

                                            <table id="tabla_kits"
                                                class="tabla_articulos table stripe row-border order-column">

                                                <thead>

                                                    <tr>

                                                        <th
                                                            style="padding-left: 32px !important;padding-right: 50px !important;">
                                                            ID</th>

                                                        <th>Nombre</th>

                                                        <th>Descuento</th>


                                                        <th>Artículos</th>




                                                        <th style="text-align:center;">Acciones</th>

                                                    </tr>

                                                </thead>

                                                <tbody>







                                                </tbody>

                                            </table>



                                        </div>

                                    </div>

                                </div>

                                <!-- /Historial de Acceso -->

                                <!-- Eliminaci贸n de cuenta -->



                                <!-- /Eliminaci贸n de cuenta -->

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>



    </div>





    <!-- MODALS -->
    <div id="modalAgregarKit" class="modal fade" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header border-none">

                    <h4 class="mb-0"> Agregar kit</h4>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                        <i class="ti-close"></i>

                    </button>

                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="nombre_kit">Nombre</label>
                        <input id="nombre_kit" class="form-control" type="text">
                    </div>
                    <div class="form-group">
                        <label for="descuento_kit">Descuento</label>
                        <div class="input-group">
                            <input type="number" value=0.00 class="form-control" id="descuento_kit" step="any">
                            <div class="input-group-append">
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="my-input">Artículos:</label>
                        <div class="table-responsive">
                            <table id="articulos_modal" class="tabla_articulos table stripe row-border order-column">

                                <thead>

                                    <tr>



                                        <th>Nombre</th>



                                        <th>Stock</th>

                                        <th>Precio unitario</th>

                                        <th>Seleccionar</th>

                                    </tr>

                                </thead>

                                <tbody>






                                </tbody>

                            </table>

                        </div>
                    </div>
                    <div class="form-group">
                        <label>Cantidad</label>
                        <div class="input-group">

                            <input type="number" value=1 class="form-control" id="cantidad_articulos" min="0">
                            <div class="input-group-append">
                                <button id="button_add_articulo_kit" class="btn btn-sm btn-success">Agregar artículos al
                                    kit</button>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <h4>Artículos:</h4>
                        <div class="table-responsive">
                            <table id="tabla_articulos_kit" class="table stylish-table">
                                <thead>
                                    <tr>
                                        <th style="width:90px;">Producto</th>
                                        <th>Descripción</th>
                                        <th>Cantidad</th>
                                        <th>Precio</th>
                                        <th>Eliminar</th>
                                    </tr>
                                </thead>
                                <tbody>


                                </tbody>
                            </table>

                        </div>
                        <!-- <ul class="list-unstyled p-0 mb-3" id="articulos_kit">


                        </ul>-->

                        <p style="font-weight: 800;" class="mb-2">Descuento <span id="descuento_total">0.00</span>%: -
                            <span id="descuento_total_valor">0.00</span>€
                        </p>
                        <p style="font-size: 18px;font-weight: 800;" class="mb-2">Total: <span
                                id="total_kit">0.00</span>€
                        </p>
                    </div>
                </div>
                <div class="modal-footer px-4 pb-4 pt-0 text-right">
                    <button class="btn btn-info btn-fw" id="btn_add_kit" type="button">
                        Añadir</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalEditarCampos" aria-hidden="true">

        <div class="modal-dialog modal-dialog-centered" role="document">

            <div class="modal-content">

                <div class="modal-header border-none">

                    <h4 class="mb-0"> Editar campos</h4>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                        <i class="ti-close"></i>

                    </button>

                </div>



                <div class="modal-body pb-0">

                    <div class="container-fluid p-0">

                        <div class="row">

                            <div class="col-12">
                                <div class="form-group">
                                    <label for="campo_1">Campo 1</label>
                                    <textarea id="campo_1" class="form-control" type="text" name=""></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="campo_2">Campo 2</label>
                                    <textarea id="campo_2" class="form-control" type="text" name=""></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="campo_3">Campo 3</label>
                                    <textarea id="campo_3" class="form-control" type="text" name=""></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="campo_4">Campo 4</label>
                                    <textarea id="campo_4" class="form-control" type="text" name=""></textarea>
                                </div>

                            </div>



                        </div>
                    </div>
                </div>

                <div class="modal-footer text-right">


                    <input id="id_campos_editar" type="hidden" name="" value="">
                    <button class="btn btn-info btn-fw" id="btn_editar_campos" type="button">

                        Editar</button>







                </div>



                <!-- /modal-body -->

            </div>

        </div>

    </div>







    <div class="modal fade" id="modalEditarArticulo" aria-hidden="true">

        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

            <div class="modal-content">

                <div class="modal-header border-none">

                    <h4 class="mb-0"> Editar artículo</h4>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                        <i class="ti-close"></i>

                    </button>

                </div>



                <div class="modal-body pb-0">

                    <div class="container-fluid p-0">


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">

                                    <label>Título</label>

                                    <input type="text" class="valor_atributo form-control" id="titulo_editar"
                                        name="titulo">

                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Stock</label>
                                            <input type="number" value=0 class="valor_atributo form-control"
                                                id="stock_editar" name="stock">
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Código</label>
                                            <input type="text" class="valor_atributo form-control" id="codigo_editar"
                                                name="codigo">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Precio unitario</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">€</span>
                                                </div>
                                                <input type="number" class="valor_atributo form-control"
                                                    id="precio_unitario_editar" value=0.00 name="precio_unitario"
                                                    step="any">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">0.00</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Costo</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">€</span>
                                                </div>
                                                <input type="number" class="valor_atributo form-control"
                                                    id="precio_coste_editar" name="precio_coste" value=0.00 step="any">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">0.00</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="">Familia</label>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_familia file-upload-browse btn btn-danger"
                                                data-target="select_familias_editar" type="button">-</button>
                                        </span>
                                        <select id="select_familias_editar" data-target="select_subfamilias_editar"
                                            class="valor_atributo select_familias custom-select select2 form-control"
                                            name="id_familia">


                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarFamilia">+</button>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="my-input">Subfamilia</label>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_subfamilia file-upload-browse btn btn-danger"
                                                data-target="select_subfamilias_editar" type="button">-</button>
                                        </span>
                                        <select id="select_subfamilias_editar"
                                            class="valor_atributo select_subfamilias custom-select select2 form-control"
                                            data-target="select_familias_editar" name="id_subfamilia">


                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarSubfamilia">+</button>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>I.G.I.C</label>
                                    <div class="input-group">
                                        <select id="igic_editar" name="igic"
                                            class="valor_atributo form-control custom-select text-center">



                                            <option type="number" value="7.00">7.00</option>

                                            <option type="number" value="3.00">3.00</option>



                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">


                                <div class="form-group">
                                    <label>Referencia de proveedor</label>
                                    <div class="input-group">

                                        <input type="text" class="valor_atributo form-control"
                                            id="codigo_proveedor_editar" name="codigo_proveedor">

                                    </div>

                                </div>




                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Descuento</label>
                                            <div class="input-group">
                                                <input type="number" value=0.00 class="valor_atributo form-control"
                                                    id="descuento_editar" name="descuento" step="any">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>EAN</label>
                                            <div class="input-group">

                                                <input type="text" class="valor_atributo form-control" id="ean_editar"
                                                    name="ean" step="any">

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Uds./caja</label>

                                    <input type="number" value=0 class="valor_atributo form-control"
                                        id="uds_caja_editar" name="uds_caja">


                                </div>

                                <div class="form-group">
                                    <label class="">Marca</label>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_marca file-upload-browse btn btn-danger"
                                                data-target="select_marcas_editar" type="button">-</button>
                                        </span>
                                        <select id="select_marcas_editar"
                                            class="valor_atributo select_marcas custom-select select2 form-control"
                                            name="id_marca">


                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMarca">+</button>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="my-input">Ubicación</label>
                                    <div class="input-group mb-3 mb-md-0">
                                        <span class="input-group-prepend">
                                            <button data-target="select_ubicaciones_editar"
                                                class="file-upload-browse btn btn-danger btn_eliminar_ubicacion"
                                                type="button">-</button>
                                        </span>
                                        <select id="select_ubicaciones_editar"
                                            class="valor_atributo select_ubicaciones form-control custom-select text-center select2"
                                            name="id_ubicacion">



                                        </select>
                                        <span class="input-group-append">
                                            <button data-toggle="modal" data-target="#modalAgregarUbicacion"
                                                class="file-upload-browse btn btn-info" type="button">+</button>
                                        </span>



                                    </div>
                                </div>


                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label>Descripción</label>
                                    <textarea type="text" class="valor_atributo form-control m-0"
                                        id="descripcion_editar" name="descripcion"></textarea>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>

                <div class="modal-footer text-right">


                    <input id="id_articulo_editar" type="hidden" name="id_articulo" value="">
                    <button class="btn btn-info btn-fw" id="btn_editar_articulo" type="button">

                        Editar</button>







                </div>



                <!-- /modal-body -->

            </div>

        </div>

    </div>

    <div class="modal fade modal-cambiar" id="modalEliminarArticulo" role="dialog"
        aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header border-none">
                    <h4 class="mb-0">Eliminar articulo</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body pb-0">
                    <!-- btn -->


                    <input type="hidden" id="id_articulo_eliminar">
                    <p class="">¿Estás seguro de que deseas eliminar el articulo definitivamente?</p>

                    <lottie-player autoplay src="assets/lottiefiles/warning.json"
                        style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





                </div>

                <!-- /btn -->

                <div class="modal-footer text-right">



                    <button class="btn btn-success btn-fw" id="btn_eliminar_articulo" type="button">
                        Confirmar y eliminar </button>



                </div>
                <!-- /modal-body -->
            </div>
        </div>
    </div>

    <div id="modalEditarKit" class="modal" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header border-none">

                    <h4 class="mb-0">Editar kit</h4>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                        <i class="ti-close"></i>

                    </button>

                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="nombre_kit_editar">Nombre</label>
                        <input id="nombre_kit_editar" class="form-control" type="text">
                    </div>
                    <div class="form-group">
                        <label for="descuento_kit_editar">Descuento</label>
                        <div class="input-group">
                            <input type="number" value=0.00 class="form-control" id="descuento_kit_editar" step="any">
                            <div class="input-group-append">
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="my-input">Artículos:</label>
                        <div class="table-responsive">
                            <table id="articulos_modal_editar"
                                class="tabla_articulos table stripe row-border order-column">

                                <thead>

                                    <tr>



                                        <th>Nombre</th>



                                        <th>Stock</th>

                                        <th>Precio unitario</th>

                                        <th>Seleccionar</th>

                                    </tr>

                                </thead>



                                </tbody>

                            </table>

                        </div>
                    </div>
                    <div class="form-group">
                        <label>Cantidad</label>
                        <div class="input-group">

                            <input type="number" value=1 class="form-control" id="cantidad_articulos_editar" min="0">
                            <div class="input-group-append">
                                <button id="button_add_articulo_kit_editar" class="btn btn-sm btn-success">Agregar
                                    artículos
                                    al kit
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">

                        <h4>Artículos:</h4>
                        <div class="table-responsive">
                            <table id="tabla_articulos_kit_editar" class="table stylish-table">
                                <thead>
                                    <tr>
                                        <th style="width:90px;">Producto</th>
                                        <th>Descripción</th>
                                        <th>Cantidad</th>
                                        <th>Precio</th>
                                        <th>Eliminar</th>
                                    </tr>
                                </thead>
                                <tbody>


                                </tbody>
                            </table>

                        </div>

                        <p style="font-weight: 800;" class="mb-2">Descuento <span
                                id="descuento_total_editar">0.00</span>%:
                            - <span id="descuento_total_valor_editar">0.00</span>€</p>
                        <p style="font-size: 18px;font-weight: 800;" class="mb-2">Total: <span
                                id="total_kit_editar">0.00</span>€</p>
                    </div>
                </div>
                <div class="modal-footer px-4 pb-4 pt-0 text-right">
                    <input type="hidden" id="id_kit_editar">
                    <button class="btn btn-info btn-fw" id="btn_edit_kit" type="button">
                        Editar</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade modal-cambiar" id="modalEliminarKit" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header border-none">
                    <h4 class="mb-0">Eliminar kit</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body pb-0">
                    <!-- btn -->



                    <p class="">¿Estás seguro de que deseas eliminar el kit definitivamente?</p>

                    <lottie-player autoplay src="assets/lottiefiles/warning.json"
                        style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





                </div>

                <!-- /btn -->

                <div class="modal-footer text-right">


                    <input type="hidden" id="id_kit_eliminar" name="id_kit_eliminar" data-name="">
                    <button id="btn_eliminar_kit" class="btn btn-danger btn-fw" type="button" name="">
                        Confirmar y eliminar </button>



                </div>
                <!-- /modal-body -->
            </div>
        </div>
    </div>

    <?php require_once __VIEWS__ . 'selects/articulos.template.php'; ?>

    <script>
    $(document).on("change", ".activos", function() {
        var id_articulo = $(this).data('id');

        var activo = $(this).prop('checked')
        if (activo) {
            activo = 1
        } else {
            activo = 0
        }
        $.ajax({
            type: 'POST',
            url: './api/articulos.php',
            data: {

                id_articulo: id_articulo,
                activo: activo

            },
            cache: false,
            success: function(response) {

                var r = JSON.parse(response);
                console.log(r);
                $('.tabla_articulos').DataTable().ajax.reload(null, false);
            }
        })

    });

    $(document).on("click", ".editar_campos", function() {
        $("#id_campos_editar").val($(this).data('id'))
        $.ajax({
            type: 'GET',
            async: false,
            cache: false,
            url: './api/articulos.php?id_articulo=' + $(this).data('id'),
            dataType: "json",
            success: function(r) {

                console.log(r);


                $("#campo_1").val(r.campo_1)


                $("#campo_2").val(r.campo_2)


                $("#campo_3").val(r.campo_3)

                $("#campo_4").val(r.campo_4)


                $('#modalEditarCampos').modal("show");
            }
        });

    })
    $('#btn_editar_campos').click(function(event) {
        $('#btn_editar_campos').addClass("btn-loading")
        var id_campos_editar = $("#id_campos_editar").val()
        var campo_1 = $("#campo_1").val()
        var campo_2 = $("#campo_2").val()
        var campo_3 = $("#campo_3").val()
        var campo_4 = $("#campo_4").val()


        $.ajax({
            type: 'POST',
            url: './api/articulos.php',
            cache: false,
            data: {
                id_campos_editar: id_campos_editar,
                campo_1: campo_1,
                campo_2: campo_2,
                campo_3: campo_3,
                campo_4: campo_4

            },
            success: function(result) {

                $.toast({
                    heading: 'Campos del artículo editados',
                    text: 'Se han editado los campos correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });

                $('#btn_editar_campos').removeClass("btn-loading")
                $('#modalEditarCampos').modal("hide");
                $('.tabla_articulos').DataTable().ajax.reload(null, false);
            }
        });
        return false;
    });

    $(document).on("click", ".editar_articulo", function() {
        $("#id_articulo_editar").val($(this).data('id'))
        $.ajax({
            type: 'GET',
            url: './api/articulos.php?id_articulo=' + $(this).data('id'),
            cache: false,
            async: false,
            dataType: "json",
            success: function(r) {

                console.log(r);


                // Recorrer todos los inputs dentro del modal
                $("#modalEditarArticulo .valor_atributo").each(function() {
                    // Obtener el ID y el valor de cada input
                    var name = $(this).attr("name");

                    var valor
                    if ($(this).is("select")) {
                        console.log(name);
                        valor = (r[name] != null) ? (r[name]) : "No"
                        $(`#modalEditarArticulo select[name='${name}']`).val(valor).trigger(
                            'change')

                    } else {

                        valor = (r[name] != null) ? (r[name]) : ""
                        $(`#modalEditarArticulo :input[name='${name}']`).val(valor)

                    }




                });


                $('#modalEditarArticulo').modal("show");

            }
        });

    })


    $('#btn_editar_articulo').click(function(event) {
        $('#btn_editar_articulo').addClass("btn-loading")



        var datos = {};
        datos["id_articulo"] = $("#id_articulo_editar").val()
        // Recorrer todos los inputs dentro del modal
        $("#modalEditarArticulo .valor_atributo").each(function() {
            // Obtener el ID y el valor de cada input
            var name = $(this).attr("name");
            var valor = $(this).val();

            // Almacenar en el objeto datos
            datos[name] = valor;
        });
        console.log(datos);

        if (datos.titulo == "") {
            $('#btn_editar_articulo').removeClass('btn-loading');
            $.toast({
                heading: 'Por favor rellena el título del artículo.',
                text: 'No se ha añadido un título al artículo.',
                position: 'top-right',
                loaderBg: '#ff5c6c',
                icon: 'error',
                hideAfter: 5000,
                stack: 6
            });
            return false;
        }
        if (datos.descripcion == "") {
            $('#btn_editar_articulo').removeClass('btn-loading');
            $.toast({
                heading: 'Por favor rellena la descripción del artículo.',
                text: 'No se ha añadido una descripción al artículo.',
                position: 'top-right',
                loaderBg: '#ff5c6c',
                icon: 'error',
                hideAfter: 5000,
                stack: 6
            });
            return false;
        }


        $.ajax({
            type: 'POST',
            url: './api/articulos.php',
            data: datos,
            async: false,
            cache: false,
            dataType: "json",
            success: function(result) {
                console.log(result);
                $.toast({
                    heading: 'Artículo editado',
                    text: 'Se ha editado el articulo ' + datos.titulo + ' correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
                $('.tabla_articulos').DataTable().ajax.reload(null, false);
                $('#btn_editar_articulo').removeClass("btn-loading")
                $('#modalEditarArticulo').modal("hide");


            }
        });
        return false;
    });

    $(document).on("click", ".btn_eliminar_kit", function(e) {



        $("#btn_eliminar_kit").data("id", $(this).data("id"))

        $("#modalEliminarKit").modal('show');




    })


    $('#btn_eliminar_kit').click(function(event) {

        var id_kit = $("#btn_eliminar_kit").data("id")


        $.ajax({
            type: 'DELETE',
            url: './api/kits.php?id_kit=' + id_kit,
            cache: false,
            async: false,
            success: function(result) {


                $.toast({
                    heading: 'Kit eliminado',
                    text: 'Se ha eliminado el kit correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                })


                $('#modalEliminarKit').modal('hide');

                $('.tabla_articulos').DataTable().ajax.reload(null, false);


            }
        });


    });
    </script>
    <script>
    (function($) {

        'use strict';

        $(function() {

            $(document).on("click", ".eliminar_articulo", function() {
                $("#id_articulo_eliminar").val($(this).data('id'))
                $('#modalEliminarArticulo').modal("show");
            })
            $("#btn_eliminar_articulo").click(function() {
                var id = $("#id_articulo_eliminar").val()

                $("#btn_eliminar_articulo").addClass("btn-loading")

                $.ajax({
                    type: 'DELETE',
                    url: './api/articulos.php?id_articulo=' + id,
                    cache: false,
                    success: function(response) {
                        $.toast({
                            heading: 'Artículo eliminado',
                            text: 'Se ha eliminado el artículo correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $('.tabla_articulos').DataTable().ajax.reload(null, false);
                        $("#btn_eliminar_articulo").removeClass("btn-loading")
                        $('#modalEliminarArticulo').modal("hide")

                    }
                })
            })
        });



    })(jQuery);
    </script>

    <script>
    $(document).ready(function() {
        var Table2 = $('#tabla_articulos').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos",
                infoEmpty: "Mostrando 0 a 0 de 0 en artículos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/articulos.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                cache: false,
                dataSrc: function(res) {
                    console.log(res);
                    var id_ubicacion = $("#filtro_ubicacion").val()
                    $("#articulos_count").text(res.length)
                    var p = []
                    if (id_ubicacion != "No") {
                        res.forEach(element => {

                            if (id_ubicacion == element.id_ubicacion) {
                                p.push(element)
                            }
                        });
                        return p;
                    } else {
                        return res;
                    }
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_articulo",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "titulo"
                },
                {
                    "data": "descripcion"
                },
                {
                    "data": "nombre_ubicacion"
                },
                {
                    "data": "stock"
                },
                {
                    "data": "precio_unitario",
                    "render": function(data, type, row, meta) {
                        return data + ' €';
                    }
                },
                {
                    "data": null,
                    "render": function(data, type, row, meta) {
                        var ac = (data.activo == 1) ? "Activo" : "Bloqueado"
                        const checkboxContainer = document.createElement("label");
                        checkboxContainer.classList.add("custom-control", "custom-checkbox",
                            "d-inline-block");

                        // Crear el elemento checkbox
                        const checkbox = document.createElement("input");
                        checkbox.type = "checkbox";
                        checkbox.setAttribute("data-id", data.id_articulo);
                        checkbox.classList.add("custom-control-input");
                        checkbox.classList.add("activos");
                        // Opción 1: Usar el atributo "checked"

                        var acc = (data.activo == 1) ? 1 : 0

                        // Opción 2: Usar el método setAttribute
                        if (acc) {
                            checkbox.setAttribute('checked', 1);
                        }
                        // Crear el elemento span para la etiqueta
                        const labelSpan = document.createElement("span");

                        labelSpan.classList.add("custom-control-label");
                        labelSpan.textContent = ac;

                        // Agregar el checkbox y el span al contenedor
                        checkboxContainer.appendChild(checkbox);
                        checkboxContainer.appendChild(labelSpan);

                        return checkboxContainer.outerHTML;
                    }
                },
                {
                    "data": "id_articulo",
                    "render": function(data, type, row) {



                        // Crear el contenido
                        const divDropdown = document.createElement("div");
                        divDropdown.classList.add("dropdown", "d-block", "user-dropdown");

                        const anchorDropdown = document.createElement("a");
                        anchorDropdown.classList.add("dropdown-toggle", "d-flex",
                            "align-items-center");

                        anchorDropdown.href = "#";
                        anchorDropdown.setAttribute("data-toggle", "dropdown");
                        anchorDropdown.setAttribute("aria-expanded", "false");
                        anchorDropdown.textContent = "Acciones";

                        const divDropdownMenu = document.createElement("div");
                        divDropdownMenu.classList.add("dropdown-menu",
                            "dropdown-menu-right",
                            "navbar-dropdown", "p-0");


                        const buttonEditar = document.createElement("button");
                        buttonEditar.type = "button";
                        buttonEditar.classList.add("editar_articulo", "p-1",
                            "dropdown-item");
                        buttonEditar.setAttribute("data-id", data);
                        buttonEditar.innerHTML = `
        <lord-icon src="https://cdn.lordicon.com/wloilxuq.json" trigger="hover"
            colors="primary:#000000,secondary:#000000"
            style="width:30px;height:30px"></lord-icon>Editar
    `;

                        const buttonEditarCampos = document.createElement("button");
                        buttonEditarCampos.type = "button";
                        buttonEditarCampos.classList.add("editar_campos", "p-1",
                            "dropdown-item");
                        buttonEditarCampos.setAttribute("data-id", data);
                        buttonEditarCampos.innerHTML = `
        <lord-icon src="https://cdn.lordicon.com/afzktxmo.json" trigger="hover"
            colors="primary:#000000,secondary:#000000"
            style="width:30px;height:30px"></lord-icon>Campos
    `;

                        const buttonEliminar = document.createElement("button");
                        buttonEliminar.type = "button";
                        buttonEliminar.classList.add("eliminar_articulo", "p-1",
                            "dropdown-item");
                        buttonEliminar.setAttribute("data-id", data);
                        buttonEliminar.innerHTML = `
        <lord-icon src="https://cdn.lordicon.com/ymoqjpau.json" trigger="hover"
            colors="primary:#000000,secondary:#000000"
            style="width:30px;height:30px"></lord-icon>Eliminar
    `;

                        // Construir la estructura
                        divDropdownMenu.appendChild(buttonEditar);
                        divDropdownMenu.appendChild(buttonEditarCampos);
                        divDropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(anchorDropdown);
                        divDropdown.appendChild(divDropdownMenu);

                        const tdElement = document.createElement("td");
                        tdElement.classList.add("table-dropdown");
                        tdElement.style.textAlign = "center";
                        tdElement.appendChild(divDropdown);



                        return tdElement.outerHTML;
                    }
                }
            ]

        });


        var Tsa = $('#tabla_kits').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en kits",
                infoEmpty: "Mostrando 0 a 0 de 0 en kits",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/kits.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                cache: false,
                dataSrc: function(res) {
                    console.log(res);
                    $("#kits_count").text(res.length)
                    return res;

                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_kit",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "nombre"
                },
                {
                    "data": "descuento",
                    "render": function(data, type, row, meta) {
                        return data + ' %';
                    }
                },
                {
                    "data": "articulos",
                    "render": function(data, type, row, meta) {

                        var articulosKit = data
                        var td = document.createElement("td");
                        td.classList.add("table-dropdown");
                        td.style.textAlign = "center";

                        var divDropdown = document.createElement("div");
                        divDropdown.classList.add("dropdown", "d-block", "user-dropdown");

                        var aDropdown = document.createElement("a");
                        aDropdown.classList.add("dropdown-toggle", "d-flex",
                            "align-items-center");

                        aDropdown.href = "#";
                        aDropdown.setAttribute("data-toggle", "dropdown");
                        aDropdown.setAttribute("aria-expanded", "false");
                        aDropdown.textContent = "Ver artículos";

                        var divDropdownMenu = document.createElement("div");
                        divDropdownMenu.classList.add("dropdown-menu",
                            "dropdown-menu-right",
                            "navbar-dropdown", "p-0");


                        var ulList = document.createElement("ul");
                        ulList.style.listStyleType = "none";
                        ulList.classList.add("m-0", "p-2");

                        // Recorrer los datos de los artículos y agregarlos a la lista
                        articulosKit.forEach((articulo) => {
                            const li = document.createElement("li");

                            li.textContent =
                                `${articulo.nombre_articulo} X ${articulo.cantidad} unidades.`;
                            if (articulo.id_articulo != null) {
                                ulList.appendChild(li);
                            }
                        });

                        // Agregar los elementos HTML al contenedor
                        divDropdownMenu.appendChild(ulList);
                        divDropdown.appendChild(aDropdown);
                        divDropdown.appendChild(divDropdownMenu);
                        td.appendChild(divDropdown);
                        return td.outerHTML;
                    }
                },
                {
                    "data": "id_kit",
                    "render": function(data, type, row) {

                        var tdElement = document.createElement("td");
                        tdElement.classList.add("table-dropdown");
                        tdElement.style.textAlign = "center";


                        // Crear el elemento <div> con la clase "dropdown d-block user-dropdown"
                        var divElement = document.createElement("div");
                        divElement.classList.add("dropdown", "d-block", "user-dropdown");

                        // Crear el elemento <a> con las clases y atributos correspondientes
                        var aElement = document.createElement("a");
                        aElement.classList.add("dropdown-toggle", "d-flex",
                            "align-items-center");

                        aElement.href = "#";
                        aElement.setAttribute("data-toggle", "dropdown");
                        aElement.setAttribute("aria-expanded", "false");
                        aElement.innerText = "Acciones";

                        // Crear el menú desplegable y agregar los botones al menú
                        var dropdownMenu = document.createElement("div");
                        dropdownMenu.classList.add("dropdown-menu", "dropdown-menu-right",
                            "navbar-dropdown", "p-0");


                        // Crear botón de "Editar"

                        var editarButton = document.createElement("button");
                        editarButton.type = "button";
                        editarButton.classList.add("editar_kit", "p-1", "dropdown-item");
                        editarButton.setAttribute("data-id", data);
                        editarButton.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;

                        var eliminarButton = document.createElement("button");
                        eliminarButton.type = "button";
                        eliminarButton.classList.add("btn_eliminar_kit", "p-1",
                            "dropdown-item");
                        eliminarButton.setAttribute("data-id", data);
                        eliminarButton.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                    
                `;


                        // Agregar los botones al menú desplegable
                        dropdownMenu.appendChild(editarButton);

                        dropdownMenu.appendChild(eliminarButton);
                        // Agregar elementos al DOM

                        divElement.appendChild(aElement);
                        divElement.appendChild(dropdownMenu);
                        tdElement.appendChild(divElement);

                        return tdElement.outerHTML;
                    }
                }
            ]

        });


        var TableModalEditar = $('#articulos_modal_editar').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos",
                infoEmpty: "Mostrando 0 a 0 de 0 en artículos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/articulos.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                cache: false,
                dataSrc: function(res) {
                    console.log(res);

                    return res;

                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "titulo"
                },
                {
                    "data": "stock"
                },
                {
                    "data": "precio_unitario",
                    "render": function(data, type, row, meta) {
                        return data + ' €';
                    }
                },
                {
                    "data": null,
                    "render": function(data, type, row) {

                        const tdElement = document.createElement("td");
                        tdElement.classList.add("td-tablet");

                        // Crea el elemento <div> con la clase "custom-control custom-radio mb-2"
                        const divElement = document.createElement("div");
                        divElement.classList.add("custom-control", "custom-radio", "mb-2");

                        // Crea el elemento <input> con los atributos correspondientes
                        const inputElement = document.createElement("input");
                        inputElement.type = "radio";
                        var idd = "articulo_" + data.id_articulo + "_editar";
                        inputElement.id = idd
                        inputElement.dataset.id = data.id_articulo;
                        inputElement.dataset.stock = data.stock;
                        inputElement.name = "articuloagregareditar";
                        inputElement.classList.add("custom-control-input",
                            "checkbox_apartado");

                        // Crea el elemento <label> con la clase "custom-control-label" y el atributo "for" vinculado al ID del input
                        const labelElement = document.createElement("label");
                        labelElement.classList.add("custom-control-label");
                        labelElement.setAttribute("for", idd);

                        // Agrega el input y el label al div
                        divElement.appendChild(inputElement);
                        divElement.appendChild(labelElement);

                        // Agrega el div al td
                        tdElement.appendChild(divElement);

                        // Obtiene el contenedor donde se agregará el contenido generado



                        return tdElement.outerHTML;
                    }
                }
            ]


        });

        var Tab9 = $('#articulos_modal').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos",
                infoEmpty: "Mostrando 0 a 0 de 0 en artículos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/articulos.php', // Ruta que devuelve los datos de los clientes
                method: 'GET',
                cache: false,
                dataSrc: function(res) {
                    console.log(res);

                    return res;

                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "titulo"
                },
                {
                    "data": "stock"
                },
                {
                    "data": "precio_unitario",
                    "render": function(data, type, row, meta) {
                        return data + ' €';
                    }
                },
                {
                    "data": null,
                    "render": function(data, type, row) {

                        const tdElement = document.createElement("td");
                        tdElement.classList.add("td-tablet");

                        // Crea el elemento <div> con la clase "custom-control custom-radio mb-2"
                        const divElement = document.createElement("div");
                        divElement.classList.add("custom-control", "custom-radio", "mb-2");

                        // Crea el elemento <input> con los atributos correspondientes
                        const inputElement = document.createElement("input");
                        inputElement.type = "radio";
                        var idd = "articulo_" + data.id_articulo;
                        inputElement.id = idd
                        inputElement.dataset.id = data.id_articulo;
                        inputElement.dataset.stock = data.stock;
                        inputElement.name = "articuloagregar";
                        inputElement.classList.add("custom-control-input",
                            "checkbox_apartado");

                        // Crea el elemento <label> con la clase "custom-control-label" y el atributo "for" vinculado al ID del input
                        const labelElement = document.createElement("label");
                        labelElement.classList.add("custom-control-label");
                        labelElement.setAttribute("for", idd);

                        // Agrega el input y el label al div
                        divElement.appendChild(inputElement);
                        divElement.appendChild(labelElement);

                        // Agrega el div al td
                        tdElement.appendChild(divElement);

                        // Obtiene el contenedor donde se agregará el contenido generado



                        return tdElement.outerHTML;
                    }
                }
            ]

        });
        var TableKit = $('#tabla_articulos_kit').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos",
                infoEmpty: "Mostrando 0 a 0 de 0 en artículos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();
            }

        });
        var TableKitEditar = $('#tabla_articulos_kit_editar').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos",
                infoEmpty: "Mostrando 0 a 0 de 0 en artículos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_clientes_aceptados').show();
            }

        });
        $('#modalAgregarKit').on('shown.bs.modal', function(e) {

            $($.fn.dataTable.tables(true)).DataTable()
                .columns.adjust()
                .responsive.recalc();
        });
        $('#modalEditarKit').on('shown.bs.modal', function(e) {

            $($.fn.dataTable.tables(true)).DataTable()
                .columns.adjust()
                .responsive.recalc();
        });
        $("#filtro_ubicacion").change(function(e) {

            $('.tabla_articulos').DataTable().ajax.reload(null, false);

        });
        $(document).on('click', '.articulo_kit_editar', function() {
            // Obtener la fila asociada al botón clicado
            var fila = $(this).closest('tr');

            // Eliminar la fila de la DataTable
            TableKitEditar.row(fila).remove().draw();
            CalcularTotalEditar()
        });
        $(document).on('click', '.articulo_kit', function() {
            // Obtener la fila asociada al botón clicado
            var fila = $(this).closest('tr');

            // Eliminar la fila de la DataTable
            TableKit.row(fila).remove().draw();
            CalcularTotal()
        });
        $("#button_add_articulo_kit").click(function() {
            if ($('input[name="articuloagregar"]:checked').val() == undefined) {
                $.toast({
                    heading: 'Por favor seleciona un artículo.',
                    text: 'No se ha seleccionado ningún artículo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            var id_articulo = $('input[name="articuloagregar"]:checked').data("id");

            var cantidad = $("#cantidad_articulos").val()
            if (cantidad <= 0) {
                $.toast({
                    heading: 'Por favor seleciona una cantidad válida.',
                    text: 'La cantidad de artículos debe ser mayor que 0.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }

            var repetido = false;
            $(".articulo_kit").each(function() {
                if ($(this).data("id") == id_articulo) {
                    repetido = true
                    $.toast({
                        heading: 'Artículo ya agregado al kit.',
                        text: 'Selecciona un artículo que no este en el kit.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });

                }
            })
            if (repetido) {
                return false;
            }
            var a = document.createElement('button');

            a.className = 'btn btn-danger p-2';
            a.type = "button"
            a.innerText = "Eliminar"

            $.ajax({
                url: "./api/articulos.php?id_articulo=" + id_articulo,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                success: function(res) {

                    var precio = formatearNumero(parseFloat(res.precio_unitario *
                        cantidad).toFixed(2))

                    a.classList.add("articulo_kit")
                    a.setAttribute("data-id", res.id_articulo)
                    a.setAttribute("data-cantidad", cantidad)
                    a.setAttribute("data-total", precio)
                    // lista.append(li)
                    //li.append(a)

                    var spanElement1 = document.createElement("span");

                    // Añadir la clase "round" al elemento <span>
                    spanElement1.classList.add("round");
                    spanElement1.classList.add("bg-success");

                    // Crear el elemento <i> con la clase "ti-shopping-cart"
                    var iElement = document.createElement("i");
                    iElement.className = "fas fa-box-open";

                    // Añadir el elemento <i> como hijo del elemento <span>
                    spanElement1.appendChild(iElement);

                    // Añadir el elemento <span> al documento (puedes ajustar el lugar donde lo quieres añadir)
                    var tdElement = document.createElement('td');

                    // Crea un elemento <h6>
                    var h6Element = document.createElement('h6');
                    var aElement = document.createElement("a");

                    // Configurar el atributo href (puedes asignar la URL que desees)
                    aElement.href = "#";

                    // Añadir la clase "link" al elemento <a>
                    aElement.classList.add("link");

                    // Establecer el texto del enlace
                    aElement.textContent = res.titulo;

                    // Crear el elemento <small>
                    var smallElement = document.createElement("small");

                    // Añadir la clase "text-muted" al elemento <small>
                    smallElement.classList.add("text-muted");

                    // Establecer el texto del elemento <small>
                    smallElement.textContent = "Código de referencia: " + res.codigo;
                    h6Element.appendChild(aElement)
                    // Añadir el elemento <small> como hijo del elemento <a>
                    tdElement.appendChild(h6Element);

                    tdElement.appendChild(smallElement);

                    var h5Element1 = document.createElement("h5");

                    // Establecer el texto del primer elemento <h5>
                    h5Element1.textContent = cantidad;

                    // Crear el segundo elemento <h5>
                    var h5Element2 = document.createElement("h5");

                    // Establecer el texto del segundo elemento <h5>
                    h5Element2.textContent = precio + "€";


                    var nuevaFilaData = [spanElement1.outerHTML, tdElement.outerHTML,
                        h5Element1.outerHTML, h5Element2.outerHTML, a.outerHTML
                    ];

                    // Agregar la nueva fila a la DataTable
                    TableKit.row.add(nuevaFilaData).draw();
                    CalcularTotal()
                }
            });


        })
        $("#descuento_kit").change(function() {
            CalcularTotal()
        })

        function CalcularTotal() {

            var descuento = $("#descuento_kit").val() / 100
            if ($("#descuento_kit").val() > 100) {

                $.toast({
                    heading: 'No puedes poner un descuento mayor que 100%.',
                    text: 'Seleciona un descuento menor.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            var total = 0
            $(".articulo_kit").each(function() {
                total += parseFloat($(this).data("total"))
            })
            var restar = parseFloat(total * descuento)

            total = parseFloat(total - restar)

            $("#descuento_total").text(formatearNumero(parseFloat($("#descuento_kit").val()).toFixed(2)))
            $("#descuento_total_valor").text(formatearNumero(parseFloat(restar).toFixed(2)))
            $("#total_kit").text(formatearNumero(parseFloat(total).toFixed(2)))

        }


        $("#btn_add_kit").click(function() {
            $("#btn_add_kit").addClass("btn-loading")

            var articulos = [];
            var data;
            var descuento = $("#descuento_kit").val()
            var nombre = $("#nombre_kit").val()

            $(".articulo_kit").each(function() {
                data = {
                    id: $(this).data("id"),
                    cantidad: $(this).data("cantidad")
                };
                articulos.push(data);
            })


            if (articulos.length == 0) {
                $.toast({
                    heading: 'No hay artículos en el kit.',
                    text: 'Por favor selecciona al menos un artículo para agregar al kit.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#btn_add_kit").removeClass("btn-loading")
                return false
            }

            if (nombre == "") {

                $.toast({
                    heading: 'Falta un nombre para el kit.',
                    text: 'Por favor ingresa un nombre para el kit.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#btn_add_kit").removeClass("btn-loading")
                return false
            }


            $.ajax({
                type: 'POST',
                url: './api/kits.php',
                async: false,
                cache: false,
                data: {
                    articulos: articulos,
                    nombre: nombre,
                    descuento: descuento

                },
                success: function(result) {
                    console.log(result);
                    $.toast({
                        heading: 'Kit ' + nombre + ' agregado',
                        text: 'Se ha agregado el kit correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    var lista = document.getElementById("tabla_articulos_kit")
                    lista.innerHTML = ""
                    $('#modalAgregarKit input').val("")
                    $("#btn_add_kit").removeClass("btn-loading")
                    $('#modalAgregarKit').modal("hide")
                    $('.tabla_articulos').DataTable().ajax.reload(null, false);




                }
            });


        })

        $(document).on("click", ".editar_kit", function() {

            var id_kit = $(this).data("id")
            TableKitEditar.clear().draw()
            $("#id_kit_editar").val(id_kit)
            $.ajax({
                type: 'GET',
                url: './api/kits.php?id_kit=' + id_kit,
                cache: false,
                async: false,
                success: function(response) {
                    var res = JSON.parse(response);
                    console.log(res);
                    $('#nombre_kit_editar').val(res.nombre)
                    $('#descuento_kit_editar').val(res.descuento)
                    var a = document.createElement('button');
                    for (let art of res.articulos) {
                        a.className = 'btn btn-danger p-2';
                        a.type = "button"
                        a.innerText = "Eliminar"
                        var cantidad = art.cantidad
                        var precio = formatearNumero(parseFloat(art
                            .precio_unitario *
                            cantidad).toFixed(2))

                        a.classList.add("articulo_kit_editar")
                        a.setAttribute("data-id", art.id_articulo)
                        a.setAttribute("data-cantidad", cantidad)
                        a.setAttribute("data-total", precio)
                        // lista.append(li)
                        //li.append(a)

                        var spanElement1 = document.createElement(
                            "span");

                        // Añadir la clase "round" al elemento <span>
                        spanElement1.classList.add("round");
                        spanElement1.classList.add("bg-success");

                        // Crear el elemento <i> con la clase "ti-shopping-cart"
                        var iElement = document.createElement("i");
                        iElement.className = "fas fa-box-open";

                        // Añadir el elemento <i> como hijo del elemento <span>
                        spanElement1.appendChild(iElement);

                        // Añadir el elemento <span> al documento (puedes ajustar el lugar donde lo quieres añadir)
                        var tdElement = document.createElement('td');

                        // Crea un elemento <h6>
                        var h6Element = document.createElement('h6');
                        var aElement = document.createElement("a");

                        // Configurar el atributo href (puedes asignar la URL que desees)
                        aElement.href = "#";

                        // Añadir la clase "link" al elemento <a>
                        aElement.classList.add("link");

                        // Establecer el texto del enlace
                        aElement.textContent = art.nombre_articulo;

                        // Crear el elemento <small>
                        var smallElement = document.createElement(
                            "small");

                        // Añadir la clase "text-muted" al elemento <small>
                        smallElement.classList.add("text-muted");

                        // Establecer el texto del elemento <small>
                        smallElement.textContent =
                            "Código de referencia: " + art.codigo;
                        h6Element.appendChild(aElement)
                        // Añadir el elemento <small> como hijo del elemento <a>
                        tdElement.appendChild(h6Element);

                        tdElement.appendChild(smallElement);

                        var h5Element1 = document.createElement("h5");

                        // Establecer el texto del primer elemento <h5>
                        h5Element1.textContent = cantidad;

                        // Crear el segundo elemento <h5>
                        var h5Element2 = document.createElement("h5");

                        // Establecer el texto del segundo elemento <h5>
                        h5Element2.textContent = precio + "€";


                        var nuevaFilaData = [spanElement1.outerHTML,
                            tdElement.outerHTML,
                            h5Element1.outerHTML, h5Element2
                            .outerHTML, a.outerHTML
                        ];

                        // Agregar la nueva fila a la DataTable
                        TableKitEditar.row.add(nuevaFilaData).draw();
                    }
                    CalcularTotalEditar()

                    $('#modalEditarKit').modal("show")

                }
            })







        })


        $("#btn_edit_kit").click(function() {
            $("#btn_edit_kit").addClass("btn-loading")
            var id_kit_editar = $("#id_kit_editar").val()
            var articulos_editar = [];
            var data;
            var descuento_editar = $("#descuento_kit_editar").val()
            var nombre_editar = $("#nombre_kit_editar").val()

            $(".articulo_kit_editar").each(function() {
                data = {
                    id: $(this).data("id"),
                    cantidad: $(this).data("cantidad")
                };
                articulos_editar.push(data);
            })


            if (articulos_editar.length == 0) {
                $.toast({
                    heading: 'No hay artículos en el kit.',
                    text: 'Por favor selecciona al menos un artículo para agregar al kit.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#btn_edit_kit").removeClass("btn-loading")
                return false
            }

            if (nombre_editar == "") {

                $.toast({
                    heading: 'Falta un nombre para el kit.',
                    text: 'Por favor ingresa un nombre para el kit.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $("#btn_edit_kit").removeClass("btn-loading")
                return false
            }


            $.ajax({
                type: 'POST',
                url: './api/kits.php',
                async: false,
                cache: false,
                data: {
                    id_kit_editar: id_kit_editar,
                    articulos_editar: articulos_editar,
                    nombre_editar: nombre_editar,
                    descuento_editar: descuento_editar

                },
                success: function(result) {
                    console.log(result);
                    $.toast({
                        heading: 'Kit ' + nombre_editar + ' editado',
                        text: 'Se ha editado el kit correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });

                    $("#btn_edit_kit").removeClass("btn-loading")
                    $('#modalEditarKit').modal("hide")
                    $('.tabla_articulos').DataTable().ajax.reload(null, false);




                }
            });


        })

        $("#button_add_articulo_kit_editar").click(function() {
            if ($('input[name="articuloagregareditar"]:checked').val() == undefined) {
                $.toast({
                    heading: 'Por favor seleciona un artículo.',
                    text: 'No se ha seleccionado ningún artículo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            var id_articulo_editar = $('input[name="articuloagregareditar"]:checked').data("id");

            var cantidad_editar = $("#cantidad_articulos_editar").val()
            if (cantidad_editar <= 0) {
                $.toast({
                    heading: 'Por favor seleciona una cantidad válida.',
                    text: 'La cantidad de artículos debe ser mayor que 0.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }

            var repetido = false;
            $(".articulo_kit_editar").each(function() {
                if ($(this).data("id") == id_articulo_editar) {
                    repetido = true
                    $.toast({
                        heading: 'Artículo ya agregado al kit.',
                        text: 'Selecciona un artículo que no este en el kit.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });

                }
            })
            if (repetido) {
                return false;
            }

            $.ajax({
                url: "./api/articulos.php?id_articulo=" + id_articulo_editar,
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                success: function(res) {
                    var a = document.createElement('button');
                    a.className = 'btn btn-danger p-2';
                    a.type = "button"
                    a.innerText = "Eliminar"

                    var precio = formatearNumero(parseFloat(res
                        .precio_unitario *
                        cantidad_editar).toFixed(2))

                    a.classList.add("articulo_kit_editar")
                    a.setAttribute("data-id", res.id_articulo)
                    a.setAttribute("data-cantidad", cantidad_editar)
                    a.setAttribute("data-total", precio)
                    // lista.append(li)
                    //li.append(a)

                    var spanElement1 = document.createElement(
                        "span");

                    // Añadir la clase "round" al elemento <span>
                    spanElement1.classList.add("round");
                    spanElement1.classList.add("bg-success");

                    // Crear el elemento <i> con la clase "ti-shopping-cart"
                    var iElement = document.createElement("i");
                    iElement.className = "fas fa-box-open";

                    // Añadir el elemento <i> como hijo del elemento <span>
                    spanElement1.appendChild(iElement);

                    // Añadir el elemento <span> al documento (puedes ajustar el lugar donde lo quieres añadir)
                    var tdElement = document.createElement('td');

                    // Crea un elemento <h6>
                    var h6Element = document.createElement('h6');
                    var aElement = document.createElement("a");

                    // Configurar el atributo href (puedes asignar la URL que desees)
                    aElement.href = "#";

                    // Añadir la clase "link" al elemento <a>
                    aElement.classList.add("link");

                    // Establecer el texto del enlace
                    aElement.textContent = res.titulo;

                    // Crear el elemento <small>
                    var smallElement = document.createElement(
                        "small");

                    // Añadir la clase "text-muted" al elemento <small>
                    smallElement.classList.add("text-muted");

                    // Establecer el texto del elemento <small>
                    smallElement.textContent =
                        "Código de referencia: " + res.codigo;
                    h6Element.appendChild(aElement)
                    // Añadir el elemento <small> como hijo del elemento <a>
                    tdElement.appendChild(h6Element);

                    tdElement.appendChild(smallElement);

                    var h5Element1 = document.createElement("h5");

                    // Establecer el texto del primer elemento <h5>
                    h5Element1.textContent = cantidad_editar;

                    // Crear el segundo elemento <h5>
                    var h5Element2 = document.createElement("h5");

                    // Establecer el texto del segundo elemento <h5>
                    h5Element2.textContent = precio + "€";


                    var nuevaFilaData = [spanElement1.outerHTML,
                        tdElement.outerHTML,
                        h5Element1.outerHTML, h5Element2
                        .outerHTML, a.outerHTML
                    ];

                    // Agregar la nueva fila a la DataTable
                    TableKitEditar.row.add(nuevaFilaData).draw();
                    CalcularTotalEditar()
                }
            });


        })
        $("#descuento_kit_editar").change(function() {
            CalcularTotalEditar()
        })

        function CalcularTotalEditar() {
            var descuento = $("#descuento_kit_editar").val() / 100
            if ($("#descuento_kit_editar").val() > 100) {

                $.toast({
                    heading: 'No puedes poner un descuento mayor que 100%.',
                    text: 'Seleciona un descuento menor.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            var total = 0
            $(".articulo_kit_editar").each(function() {
                total += parseFloat($(this).data("total"))
            })
            var restar = parseFloat(total * descuento)

            total = parseFloat(total - restar)

            $("#descuento_total_editar").text(formatearNumero(parseFloat($("#descuento_kit_editar").val())
                .toFixed(
                    2)))
            $("#descuento_total_valor_editar").text(formatearNumero(parseFloat(restar).toFixed(2)))
            $("#total_kit_editar").text(formatearNumero(parseFloat(total).toFixed(2)))

        }








    })
    </script>