<div class="content-wrapper">



    <div class="row profile-page ">



        <div class="col-md-12 mb-8">

            <div class="card satmar-bottom mb-3">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/boagnaty.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Apartados en carpetas</p>

                        <span id="apartados_count" class="">

                        </span>

                    </div>

                </div>

            </div>

        </div>

    </div>



    <div class="row profile-page mb-3">
        <div class="col-12">
            <div class="card card-cuenta">
                <div class="card-header">
                    <div class="row">
                        <div class="col-12">
                            <h4 class="mb-0">Historial de apartados</h4>
                        </div>
                    </div>
                </div>


                <div class="card-body card-table-body">
                    <button data-toggle="modal" data-target="#modalAgregarApartado"
                        class="mb-3 btn btn-sm btn-primary">Agregar</button>
                    <div class="table-responsive">

                        <table id="tabla_apartadoscarpetas" class="tabla_apartadoscarpetas table">

                            <thead>

                                <tr>
                                    <th style="text-align:center;">
                                        Nombre</th>
                                    <th style="text-align:center;">Acciones</th>
                                </tr>

                            </thead>

                            <tbody>



                            </tbody>

                        </table>



                    </div>

                </div>
            </div>
        </div>
    </div>

</div>


<?php require_once __VIEWS__ . 'selects/apartados_carpetas.template.php'; ?>


<!-- MODALS -->

<script>
(function($) {

    'use strict';

    $(function() {



        $('#tabla_apartadoscarpetas').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos/servicios",
                infoEmpty: "Mostrando 0 a 0 de 0 en apartados",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [{
                extend: 'colvis',
                text: 'Ocultar Columnas',
                collectionLayout: 'fixed two-column',
                className: "form-control"
            }],
            "searching": true,
            "ajax": {
                url: '/api/apartados_carpetas.php', // Ruta que devuelve los datos de los apartados
                method: 'GET',
                dataSrc: function(data) {
                    console.log(data);
                    $("#apartados_count").text(data.length)
                    return data;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#order-listing').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "nombre"
                },
                {
                    "data": "id",
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');



                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_editar_apartado p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data);
                        buttonEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;

                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_apartado p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data);
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;


                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]
        });

        function extractNumber(cadena) {
            // Expresión regular para encontrar la primera parte numérica de la cadena
            const regex = /\d+/;

            // Usar match para encontrar la primera coincidencia
            const match = cadena.match(regex);

            if (match) {
                // Convertir la coincidencia a un número
                return parseInt(match[0], 10); // Utiliza parseFloat si necesitas un número decimal
            } else {
                // Devolver null si no se encuentra ningún número
                return null;
            }
        }
    });

})(jQuery);
</script>