<div class="content-wrapper">







    <div class="row profile-page ">







        <div class="col-md-12 mb-8">



            <div class="card satmar-bottom mb-3">



                <div class="sato-border-blue">







                    <div class="text-center soli-ad">



                        <lord-icon src="https://cdn.lordicon.com/boagnaty.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">



                        </lord-icon>



                        <p class="mb-2">Artículos/servicios</p>



                        <span id="apartados_count" class="">



                        </span>



                    </div>



                </div>



            </div>



        </div>



    </div>







    <div class="row profile-page mb-3">


        <div class="col-12">


            <div class="card card-cuenta">

                <div class="card-header">

                    <div class="row">

                        <div class="col-12">

                            <h4 class="mb-0">Historial de ingresos</h4>

                        </div>

                    </div>

                </div>







                <div class="card-body card-table-body">
                    <div class="row">
                        <div class="col-12 col-sm-auto">
                            <button data-toggle="modal" data-target="#modalAgregarApartado"
                                class="mb-3 btn btn-sm btn-primary w-100">Agregar</button>
                        </div>
                    </div>
                    <div class="form-group m-0">
                        <label for="my-input">Importar artículos</label>
                        <div class="row mb-3">

                            <div class="col-12 col-sm-auto pr-sm-0">
                                <a href="./assets/imports/import_apartados.xlsx" download="import_apartados.xlsx"
                                    class="w-100 mb-3 mb-sm-0 btn btn-sm btn-primary" id="">Descargar xlsx

                                    base</a>
                            </div>
                            <div class="col-12 col-sm-auto pr-sm-0">
                                <input type="file" id="input_archivo" accept=".xlsx"
                                    class="w-100 mb-3 mb-sm-0 py-1 mx-0 btn btn-sm btn-secondary"
                                    style="line-height: 18px;height: 32px!important;border: 0px;" />


                            </div>
                            <div class="col-12 col-sm-auto pr-sm-0">

                                <button class="w-100 mb-3 mb-sm-0 btn btn-sm btn-success" id="button_archivo">Procesar

                                    archivo</button>
                            </div>
                            <div class="col-12 col-sm-auto pr-sm-0 d-flex align-items-center justify-content-center">


                                <i class="ml-0 ml-sm-1 ti-help-alt help-sign" data-toggle="tooltip" data-placement="top"
                                    title="Los apartados con código repetidos se actualizarán y los codigos faltantes seran tomados como apartados nuevos"
                                    data-original-title="asdfa"></i>

                            </div>
                        </div>
                    </div>




                    <div class="table-responsive">



                        <table id="tabla_apartados" class="tabla_apartados table">



                            <thead>



                                <tr>

                                    <th style="padding-left: 32px !important;padding-right: 50px !important;">

                                        Código</th>

                                    <th>Título</th>

                                    <th>Fecha de ingreso</th>

                                    <th>Stock inicial</th>

                                    <th>Stock disponible</th>

                                    <th>Descripción</th>

                                    <th>Cantidad</th>

                                    <th>Precio unitario</th>

                                    <th>IVA/I.G.I.C</th>

                                    <th>Total</th>

                                    <th style="text-align:center;">Acciones</th>

                                </tr>



                            </thead>



                            <tbody>







                            </tbody>



                        </table>







                    </div>



                </div>



            </div>



        </div>



    </div>



    <div class="row profile-page">


        <div class="col-12">


            <div class="card card-cuenta">

                <div class="card-header">

                    <div class="row">

                        <div class="col-12">

                            <h4 class="mb-0">Historial de ventas</h4>

                        </div>

                    </div>

                </div>





                <div class="card-body card-table-body">



                    <div class="table-responsive">



                        <table id="tabla_ventas" class="tabla_ventas table">



                            <thead>



                                <tr>

                                    <th style="padding-left: 32px !important;padding-right: 50px !important;">

                                        Código</th>
                                    <th>Cliente</th>
                                    <th>Nº de albaran</th>
                                    <th>Nº de factura</th>

                                    <th>Fecha de venta</th>

                                    <th>Stock descontado</th>

                                    <th>Descripción</th>

                                    <th style="text-align:center;">Acciones</th>

                                </tr>



                            </thead>



                            <tbody>







                            </tbody>



                        </table>







                    </div>



                </div>



            </div>



        </div>



    </div>



</div>











<!-- MODALS -->











<?php require_once __VIEWS__ . 'js/facturas.template.php'; ?>



<?php require_once __VIEWS__ . 'selects/apartados.template.php'; ?>

<script>
(function($) {



    'use strict';



    $(function() {




        $('[data-toggle="tooltip"]').tooltip()


        $('#tabla_apartados').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "lengthMenu": [

                [5, 10, 15, -1],

                [5, 10, 15, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos/servicios",

                infoEmpty: "Mostrando 0 a 0 de 0 en apartados",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                loadingRecords: "Cargando...",

                processing: "Procesando...",



                zeroRecords: "Sin resultados encontrados",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [{

                extend: 'colvis',

                text: 'Ocultar Columnas',

                collectionLayout: 'fixed two-column',

                className: "form-control"

            }],

            "searching": true,

            "ajax": {

                url: './api/apartados.php', // Ruta que devuelve los datos de los apartados

                method: 'GET',

                dataSrc: function(data) {

                    console.log(data);

                    $("#apartados_count").text(data.length)

                    return data;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },



            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado



                //$('#order-listing').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "codigo",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "titulo"

                },

                {

                    "data": "fecha"

                },

                {

                    "data": "stock"

                },

                {

                    "data": "stock_disponible"

                },

                {

                    "data": "descripcion"

                }, {

                    "data": null,



                    "render": function(data, type, row) {

                        var nombre = (data.nombre_medida != null) ? data.nombre_medida : " "

                        return data.cantidad + " " + nombre;

                    }

                }, {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        return formatearNumero(parseFloat(data.precio_unitario).toFixed(

                            2)) + " €";

                    }

                }, {

                    "data": null,

                    "render": function(data, type, row, meta) {



                        var r = (data.porcentaje != null) ? data.porcentaje : 0.00





                        return formatearNumero(parseFloat(r).toFixed(2)) + "%";

                    }

                }, {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        var p = parseFloat(data.precio_unitario * data.cantidad)

                        p = p + parseFloat(p * (data.porcentaje / 100))







                        return formatearNumero(p.toFixed(2)) + " €";

                    }

                },

                {

                    "data": "apartado_id",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');







                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'btn_editar_apartado p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data);

                        buttonEditar.innerHTML = `

                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Editar

                    

                `;



                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =

                            'btn_eliminar_apartado p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;





                        dropdownMenu.appendChild(buttonEditar);

                        dropdownMenu.appendChild(buttonEliminar);



                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);



                        return td.outerHTML;

                    }

                }

            ]



        });







        $('#tabla_ventas').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "lengthMenu": [

                [5, 10, 15, -1],

                [5, 10, 15, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en artículos/servicios",

                infoEmpty: "Mostrando 0 a 0 de 0 en apartados",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                loadingRecords: "Cargando...",

                processing: "Procesando...",



                zeroRecords: "Sin resultados encontrados",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [{

                extend: 'colvis',

                text: 'Ocultar Columnas',

                collectionLayout: 'fixed two-column',

                className: "form-control"

            }],

            "searching": true,

            "ajax": {

                url: './api/apartados.php?apartados_factura=1', // Ruta que devuelve los datos de los apartados

                method: 'GET',

                dataSrc: function(data) {

                    console.log(data);



                    return data;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },



            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado



                //$('#order-listing').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "codigo",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre_cliente"

                },

                {

                    "data": "numero_albaran_asociado"

                },

                {

                    "data": "numero"

                },

                {

                    "data": "fecha"

                },

                {

                    "data": null,

                    "render": function(data, type, row, meta) {

                        var cantidad = extractNumber(data.cantidad)

                        var cantidad_rectificada = extractNumber(data.cantidad_final)

                        var string

                        if (cantidad != cantidad_rectificada) {

                            string = cantidad_rectificada + " (Rectificada)"



                        } else {

                            string = cantidad



                        }

                        return string;

                    }

                },

                {

                    "data": "descripcion"

                },

                {

                    "data": "id_factura_manual",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');







                        var buttonVerFactura = document.createElement('button');

                        buttonVerFactura.className =

                            'btn_ver_factura p-1 dropdown-item';

                        buttonVerFactura.setAttribute('type', 'button');

                        buttonVerFactura.setAttribute('data-id', data)

                        buttonVerFactura.innerHTML = `

                    <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Ver factura

                `;





                        dropdownMenu.appendChild(buttonVerFactura);





                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);



                        return td.outerHTML;

                    }

                }

            ]



        });



        function extractNumber(cadena) {

            // Expresión regular para encontrar la primera parte numérica de la cadena

            const regex = /\d+/;



            // Usar match para encontrar la primera coincidencia

            const match = cadena.match(regex);



            if (match) {

                // Convertir la coincidencia a un número

                return parseInt(match[0], 10); // Utiliza parseFloat si necesitas un número decimal

            } else {

                // Devolver null si no se encuentra ningún número

                return null;

            }

        }

    });



})(jQuery);
</script>




<script>
window.addEventListener('DOMContentLoaded', (event) => {



    document.getElementById('button_archivo').addEventListener('click', function() {

        const archivoInput = document.getElementById('input_archivo');

        const archivo = archivoInput.files[0];



        if (archivo) {

            const lector = new FileReader();



            lector.onload = function(e) {

                const contenido = e.target.result;

                const libro = XLSX.read(contenido, {

                    type: 'binary'

                });



                const hojaNombre = libro.SheetNames[0];

                const hoja = libro.Sheets[hojaNombre];


                const datos = XLSX.utils.sheet_to_json(hoja, {
                    defval: ""
                });

                console.log(datos); // Muestra el array de objetos


                const camposRequeridos = ['titulo', 'descripcion', 'precio_unitario',
                    'cantidad'
                ];

                // Verificación
                const filasInvalidas = datos.filter((item, index) => {
                    // Verifica campos vacíos
                    const tieneVacios = camposRequeridos.some(campo => item[campo] ===
                        null || item[campo] === "");

                    // Verifica tipos de datos
                    const cantidadValida = Number.isInteger(Number(item.cantidad));
                    const precioUnitarioValido = !isNaN(parseFloat(item.precio_unitario));
                    const precioCosteValido = item.precio_coste === undefined || item
                        .precio_coste === "" || !isNaN(parseFloat(item.precio_coste));

                    return (
                        tieneVacios ||
                        !cantidadValida ||
                        !precioUnitarioValido ||
                        !precioCosteValido
                    );
                });

                if (filasInvalidas.length > 0) {
                    $.toast({
                        heading: 'Error en archivo',
                        text: 'Hay filas con datos faltantes o tipos de datos incorrectos.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 6
                    });
                    return;
                }



                $("#button_archivo").addClass("btn-loading");







                // Enviar todos los datos en una única solicitud POST

                var fd = new FormData();

                fd.append('import_apartados', JSON.stringify(datos));


                $.ajax({

                    type: 'POST',

                    url: './api/apartados.php',

                    cache: false,

                    data: fd,

                    processData: false, // tell jQuery not to process the data

                    contentType: false, // tell jQuery not to set contentType

                    success: function(response) {

                        console.log(response);

                        response = JSON.parse(response);



                        $('.tabla_apartados').DataTable().ajax.reload(null, false);

                        $("#button_archivo").removeClass("btn-loading");

                        document.getElementById('input_archivo').value = "";

                        $.toast({

                            heading: 'Clientes agregados',

                            text: 'Se han agregado los apartados correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                    },

                    error: function(xhr, status, error) {
                        console.log("XHR:", xhr);


                        $("#button_archivo").removeClass("btn-loading");

                        let mensaje = 'Ocurrió un error al agregar los apartados.';

                        try {
                            const respuesta = JSON.parse(xhr.responseText);
                            if (respuesta.message) {
                                mensaje = respuesta.message;

                                // Si hay códigos duplicados, los mostramos también
                                if (respuesta.codigos_duplicados) {
                                    mensaje += ': ' + respuesta.codigos_duplicados.join(
                                        ', ');
                                }
                            }
                        } catch (e) {
                            console.warn('No se pudo parsear el JSON del error');
                        }

                        $.toast({
                            heading: 'Error',
                            text: mensaje,
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 6000,
                            stack: 6
                        });
                    }


                });

            };



            lector.readAsBinaryString(archivo);

        } else {

            $.toast({

                heading: 'Archivo faltante.',

                text: 'Por favor, seleccione un archivo.',

                position: 'top-right',

                loaderBg: '#ff5c6c',

                icon: 'error',

                hideAfter: 2000,

                stack: 6

            });

        }

    });





});
</script>