<div class="content-wrapper">



    <div class="row profile-page ">

        <div class="col-md-12 mb-8">

            <div class="card satmar-bottom">

                <div class="sato-border-blue">



                    <div class="text-center soli-ad">

                        <lord-icon src="https://cdn.lordicon.com/bqzyzccf.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">

                        </lord-icon>

                        <p class="mb-2">Notificaciones de anomalías</p>

                        <span id="anomalias_count" class="">



                        </span>

                    </div>

                </div>

            </div>

        </div>



    </div>





    <div class="row profile-page">

        <div class="col-12">

            <div class="card">



                <div class="" style="padding-bottom: 0px !important;">



                    <div class="pt-0 ">



                        <div class="row ">

                            <!-- Historial de Acceso -->

                            <div class="col-md-12">





                                <div class="card card-cuenta">



                                    <div class="card-body p-3 p-sm-4 card-table-body">



                                        <table id="tabla_anomalias" cellspacing="0"
                                            class="table display nowrap tabla_anomalias">

                                            <thead>

                                                <tr>

                                                    <th
                                                        style="padding-left: 32px !important;padding-right: 50px !important;">

                                                        ID</th>

                                                    <th>Miembro</th>



                                                    <th
                                                        style="padding-right: 60px !important;padding-left: 60px !important;">

                                                        Fecha</th>
                                                    <th>Localización</th>
                                                    <th>Anomalía</th>



                                                    <th style="text-align:center;">Acciones</th>

                                                </tr>

                                            </thead>

                                            <tbody>





                                            </tbody>

                                        </table>



                                    </div>

                                </div>

                            </div>

                            <!-- /Historial de Acceso -->

                            <!-- Eliminación de cuenta -->



                            <!-- /Eliminación de cuenta -->

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



</div>



<div class="modal fade modal-cambiar" id="modalEliminarAnomalia" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar la anomalía definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_anomalia" type="button" name="">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<!-- MODALS -->

<div class="modal fade" id="modalAgregarJustificacion" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Justificación</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">



                            <textarea class="form-control" id="justificacion" cols="30" rows="60" required></textarea>

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">



                <input type="hidden" id="id_justificacion_anomalia">



                <button id="btn_justificar" class="btn btn-danger btn-fw" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>





<script>
(function($) {

    'use strict';

    $(function() {

        var Table = $('.tabla_anomalias').DataTable({

            "responsive": true,

            "dom": 'Blfrtip',

            "aLengthMenu": [

                [10, 25, 50, -1],

                [10, 25, 50, "Todos"]

            ],

            "iDisplayLength": 10,

            "language": {

                search: "Buscar",

                emptyTable: "No hay información",

                info: "Mostrando _START_ a _END_ de _TOTAL_ en anomalías",

                infoEmpty: "Mostrando 0 a 0 de 0 en anomalías",

                infoFiltered: "(Filtrado de _MAX_ total entradas)",

                infoPostFix: "",

                thousands: ",",

                lengthMenu: "Mostrar _MENU_ Entradas",

                // loadingRecords: "Cargando...",



                processing: "Cargando...",

                loadingRecords: "",

                paginate: {

                    first: "Primero",

                    last: "Ultimo",

                    next: "Siguiente",

                    previous: "Anterior"

                }

            },

            "stateSave": true,

            "stateSaveCallback": function(settings, data) {

                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))

            },

            "stateLoadCallback": function(settings) {

                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))

            },

            "order": [

                [0, "desc"]

            ],

            "buttons": [



                {

                    extend: 'colvis',

                    text: 'Ocultar Columnas',

                    collectionLayout: 'fixed two-column',

                    className: "form-control"

                },



                {

                    extend: 'excel',

                    text: 'Excel',

                    exportOptions: {

                        columns: ':visible:not(:eq(4))' // Excluir la columna con índice 2

                    }

                }

            ],

            "searching": true,

            "ajax": {

                url: './api/anomalias.php', // Ruta que devuelve los datos de los clientes

                method: 'GET',

                cache: false,

                dataSrc: function(json) {

                    console.log(json);

                    var res = json

                    $("#anomalias_count").text(res.length)



                    return res;

                } // La propiedad que contiene los datos en la respuesta del servidor

            },



            "initComplete": function() {

                // Renderizar la tabla una vez que los datos se hayan cargado



                //$('#tabla_clientes_aceptados').show();

            },

            "processing": true, // Mostrar el indicador de procesamiento

            "serverSide": false,

            "columns": [{

                    "data": "id_anomalia",

                    "render": function(data, type, row, meta) {

                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +

                            data + '</span>';

                    }

                },

                {

                    "data": "nombre"

                },

                {

                    "data": "fecha"

                },

                {

                    "data": "localizacion"

                },

                {

                    "data": "anomalia"

                },

                {

                    "data": "id_anomalia",

                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';



                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';



                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';



                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');









                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =

                            'btn_eliminar_anomalia p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data);

                        buttonEliminar.innerHTML = `

                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Eliminar

                `;





                        dropdownMenu.appendChild(buttonEliminar);



                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);



                        td.appendChild(divDropdown);



                        return td.outerHTML;

                    }

                }

            ]



        });







        $(document).on("click", ".btn_eliminar_anomalia", function(e) {



            $("#btn_eliminar_anomalia").data("id", $(this).data("id"))





            $('#modalEliminarAnomalia').modal("show")



        })





        $('#btn_eliminar_anomalia').click(function() {

            $(this).addClass("btn-loading")

            var id_anomalia_eliminar = $('#btn_eliminar_anomalia').data("id")

            $.ajax({

                type: "DELETE",

                url: "./api/anomalias.php?id=" + id_anomalia_eliminar,

                cache: false,

                async: false,

                dataType: "json",

                success: function(response) {

                    console.log(response);

                    $('#btn_eliminar_anomalia').removeClass("btn-loading")

                    $('#modalEliminarAnomalia').modal('hide');

                    $('.tabla_anomalias').DataTable().ajax.reload(null,

                        false);

                }



            })



        })

    });

})(jQuery);
</script>