<div class="modal fade show" id="miModal" tabindex="-1" role="dialog" aria-labelledby="miModalLabel" aria-hidden="true"
    data-bs-backdrop="static" data-bs-keyboard="false">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header">

                <h4 class="modal-title" id="miModalLabel">Validar fichaje</h4>

            </div>

            <div class="modal-body">

                <div class="row">

                    <div class="col-12">

                        <h5 class="">Datos del fichaje</h5>

                        <p>Nombre: <span id="nombre_fichaje"></span></p>

                        <p>Fecha de entrada: <span id="fecha_i_fichaje"></span></p>

                        <p>Fecha de salida: <span id="fecha_f_fichaje"></span></p>

                        <p>Horas de descanso: <span id="horas_fichaje"></span></p>

                    </div>

                </div>

                <div class="col-12  text-center">

                    <h5 class="">¿Esta seguro que desea <span id="texto2_fichaje">aceptar</span> el fichaje?</h5>



                    <lottie-player autoplay src="./assets/lordicons/aceptar.json"
                        style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

                </div>



            </div>

            <div class="modal-footer">

                <!-- Botón de Aceptar para cerrar el modal -->

                <button type="button" id="btn_aceptar_fichaje" class="btn btn-success">Aceptar</button>

                <button href="./home?logout" id="btn_cancelar_fichaje" class="btn btn-danger">Cancelar</button>

            </div>

        </div>

    </div>

</div>



<style>
.sidebar,

.top_bar {

    display: none !important;

}
</style>



<script>
// Abre el modal automáticamente cuando la página carga



// Abre el modal automáticamente cuando la página carga

$(document).ready(function() {



    function formatearHorasYMinutos(segundos) {

        const horas = Math.floor(segundos / 3600);

        const minutos = Math.floor((segundos % 3600) / 60);

        return `${horas}h ${minutos}m`;

    }
    var estado
    $.ajax({

        url: "./api/fichajes.php",

        type: "GET",

        dataType: "json",

        async: false,

        cache: false,

        data: {

            id_fichaje: "<?php echo $_GET['id']; ?>"

        },

        success: function(res) {

            console.log(res);



            $("#nombre_fichaje").text(res.nombre_miembro)

            $("#fecha_i_fichaje").text(res.fecha_entrada)

            $("#fecha_f_fichaje").text(res.fecha_salida)

            $("#horas_fichaje").text(formatearHorasYMinutos(res.horas_descanso))

            if (res.estado == 'Pendiente de eliminación') {

                $("#miModalLabel").text("Eliminar fichaje")
                $("#texto2_fichaje").text("eliminar")
                $("#btn_aceptar_fichaje").text("Eliminar")
            }
            estado = res.estado


            $('#miModal').modal('show');

        }

    });

    // Acción del botón Aceptar

    $('#btn_aceptar_fichaje').on('click', function() {

        // Datos que se enviarán en la solicitud AJAX

        var data = {

            fichaje_id: "<?php echo $_GET['id']; ?>", // Aquí deberías agregar el ID del fichaje o cualquier otro dato que necesites enviar

            estado: 'Aceptado' // Este es un ejemplo de parámetro de acción

        };
        if (estado == 'Pendiente de eliminación') {
            $.ajax({

                type: 'DELETE',

                url: './api/fichajes.php?id_fi=' + "<?php echo $_GET['id']; ?>",

                cache: false,

                async: false,

                success: function(result) {





                    $.toast({

                        heading: 'Fichaje eliminado',

                        text: 'Se ha eliminado el fichaje correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })



                    $("#miModal").modal("hide");

                    window.location.href = "./login"





                }

            });
        } else {
            $.ajax({

                url: "./api/fichajes.php", // Ruta de tu API

                type: "POST", // Método de la solicitud

                dataType: "json", // Tipo de respuesta esperada

                cache: false, // No cachear la respuesta

                async: true, // Solicitud asíncrona

                data: data, // Los datos que envías en la solicitud

                success: function(res) {

                    console.log(res);

                    // Aquí puedes manejar la respuesta que te devuelva la API

                    // Si la respuesta es exitosa, puedes proceder con las siguientes acciones:



                    // Cerrar el modal

                    $("#miModal").modal("hide");

                    window.location.href = "./login"

                    // Redirigir a la página de inicio (home)



                },

                error: function(xhr, status, error) {

                    console.log("Error en la solicitud AJAX:", error);

                    // Puedes manejar el error aquí si es necesario

                }

            });
        }




    });



    $('#btn_cancelar_fichaje').on('click', function() {

        // Datos que se enviarán en la solicitud AJAX

        var data = {

            fichaje_id: "<?php echo $_GET['id']; ?>", // Aquí deberías agregar el ID del fichaje o cualquier otro dato que necesites enviar

            estado: 'Cancelado' // Este es un ejemplo de parámetro de acción

        };



        $.ajax({

            url: "./api/fichajes.php", // Ruta de tu API

            type: "POST", // Método de la solicitud

            dataType: "json", // Tipo de respuesta esperada

            cache: false, // No cachear la respuesta

            async: true, // Solicitud asíncrona

            data: data, // Los datos que envías en la solicitud

            success: function(res) {

                console.log(res);

                // Aquí puedes manejar la respuesta que te devuelva la API

                // Si la respuesta es exitosa, puedes proceder con las siguientes acciones:



                // Cerrar el modal

                $("#miModal").modal("hide");

                window.location.href = "./login"

                // Redirigir a la página de inicio (home)



            },

            error: function(xhr, status, error) {

                console.log("Error en la solicitud AJAX:", error);

                // Puedes manejar el error aquí si es necesario

            }

        });

    });



    // Acción del botón Cancelar



});
</script>