<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) {

    exit();

}

//Login System Configuration

if (!defined('LOGIN_ERROR_LIMIT')) {

    define('LOGIN_ERROR_LIMIT', 3);

}

//Maximum Number of Failed Login Attempts

if (!defined('LOGIN_ERROR_TIME')) {

    define('LOGIN_ERROR_TIME', 30);

}

//Time for Count the Limit of Failed Logins Attempts (In Minutes!)

//Set the Cookie Domain for Work with All Subdomains

//ini_set('session.cookie_domain', substr($_SERVER['SERVER_NAME'], strpos($_SERVER['SERVER_NAME'], '.')));

//Include the Facebook Model

require_once __MODELS__ . 'facebook.model.php';

require_once __MODELS__ . 'folders.model.php';

//Include the Google Model

require_once __MODELS__ . 'google.model.php';

//Include the Mailer Model

require_once __MODELS__ . 'mailer.model.php';

//Include the Browser Detection Library

require_once __LIBRARIES__ . 'browser.php';

//Include the Image Upload Library

require_once __LIBRARIES__ . 'image_upload.php';

class _UsersModel

{

    private $DBLink;

    private $Mailer;

    private $Browser;

    private $Upload;

    private $Facebook;

    public $FacebookURL;

    private $Google;

    public $GoogleURL;

    public function __construct(&$DBLink)

    {

        //Continue if DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {

            trigger_error('No MySQL connection!', E_USER_ERROR);

        }

        //Start the Session

        if (!isset($_SESSION)) {

            session_start();

        }

    }

    public function _IsLogged()

    {

        if (isset($_SESSION['logged']) && $_SESSION['logged'] === true) {

            return true;

        } else {

            return false;

        }

    }

    public function _FBLoginURL()

    {

        //If the Facebook Model Exists

        if (class_exists('_FacebookModel')) {

            //Initiate the Facebook Model

            $this->Facebook = new _FacebookModel($this->DBLink);

            //Get the Facebook Login URL

            $this->FacebookURL = $this->Facebook->_LoginURL();

        }

        return $this->FacebookURL;

    }

    public function _GGLoginURL()

    {

        //If the Google Model Exists

        if (class_exists('_GoogleModel')) {

            //Initiate the Google Model

            $this->Google = new _GoogleModel($this->DBLink);

            //Get the Google Login URL

            $this->GoogleURL = $this->Google->_LoginURL();

            return $this->GoogleURL;

        }

    }

    public function _Login()

    {

        //If the Facebook Model Exists

        if (class_exists('_FacebookModel')) {

            //Initiate the Facebook Model

            $this->Facebook = new _FacebookModel($this->DBLink);

            //Get the Facebook Login URL

            $this->FacebookURL = $this->Facebook->_LoginURL();

        }

        //If the Google Model Exists

        if (class_exists('_GoogleModel')) {

            //Initiate the Google Model

            $this->Google = new _GoogleModel($this->DBLink);

            //Get the Google Login URL

            $this->GoogleURL = $this->Google->_LoginURL();

        }

        //E-Mail Login

        if ((isset($_POST['email']) && !empty($_POST['email'])) && (isset($_POST['password']) && !empty($_POST['password']))) {

            $Email = mysqli_real_escape_string($this->DBLink, $_POST['email']);

            $Password = mysqli_real_escape_string($this->DBLink, $_POST['password']);

            //If the Client Reaches the Limit of Failed Logins

            if ($this->_LoginAttempts(LOGIN_ERROR_TIME) >= LOGIN_ERROR_LIMIT) {

                return -1;

            }

            //If the Email is Invalid

            if (empty($Email) || strlen($Email) > 150 || !filter_var($Email, FILTER_VALIDATE_EMAIL)) {

                return -2;

            }

            //If the Password is Invalid

            if (empty($Password) || $this->_CheckPassword($Password) !== true || strlen($Password) < 8 || strlen($Password) > 256) {

                return -3;

            }

            $Password = $this->_HashPassword($Email, $Password);

            //Search any User with the same Email and Password

            $Query = mysqli_query($this->DBLink, "SELECT `user_id`, `user_role`, `user_email`, `user_avatar`, `user_full_name` FROM `users`

				WHERE (`user_email` = '{$Email}');");

            //Sucessfull Login

            if ($Query && mysqli_num_rows($Query) == 1) {

                //Get the User Data

                $Result = mysqli_fetch_assoc($Query);

                //Check for Banned User

                if ($Result['user_role'] == -1) {

                    header('Location: ./login?baneado');

                    exit();

                }

                //Check for Unverified User

                if ($Result['user_role'] == 0) {

                    return -5;

                }

               // $Result['user_full_name'] = explode(' ', $Result['user_full_name']);

                //Make the Web Session

                $_SESSION['logged'] = true;

                $_SESSION['id'] = htmlentities($Result['user_id'], ENT_QUOTES);

                $_SESSION['role'] = htmlentities($Result['user_role'], ENT_QUOTES);

                $_SESSION['avatar'] = htmlentities($Result['user_avatar'], ENT_QUOTES);

                $_SESSION['email'] = htmlentities($Result['user_email'], ENT_QUOTES);

                $_SESSION['name'] = htmlentities($Result['user_full_name'], ENT_QUOTES);

                //Add the Successfull Login Log

                $this->_LoginLog($Result['user_id'], 1);

                //Get the Current Time

                $Time = time();

                //Update the Last Connection for this User

                mysqli_query($this->DBLink, "UPDATE `users` SET `user_last_seen` = '{$Time}' WHERE (`user_id` = '{$Result['user_id']}');");

                //Valid Login

                return true;

                //Bad Email or Password

            } else {

                //Search any User with the same Email

                $Query = mysqli_query($this->DBLink, "SELECT `user_id` FROM `users` WHERE (`user_email` = '{$Email}');");

                //Sucessfull Search

                if ($Query && mysqli_num_rows($Query) == 1) {

                    //Get the User ID

                    $Result = mysqli_fetch_assoc($Query);

                    //Add the Bad Login Log

                    $this->_LoginLog($Result['user_id'], 0);

                    //User Don't Exists

                } else {

                    //Add the Bad Login Log

                    $this->_LoginLog(0, 0);

                }

                //Buscar correo sin contraseña, supone registro con red social

                $Query = mysqli_query($this->DBLink, "SELECT `user_id` FROM `users` WHERE (`user_email` = '{$Email}' AND `user_password` = '');");

                //Sucessfull Search

                if ($Query && mysqli_num_rows($Query) == 1) {

                    return -11;

                }

                return -6;

            }

            //Facebook Login

        } else if ($this->Facebook instanceof _FacebookModel && (isset($_GET['code']) && !empty($_GET['code'])) && (isset($_GET['state']) && !empty($_GET['state']))) {

            //Get the Results about the Facebook Login

            $FBLogin = $this->Facebook->_LoginCallback();

            //Bad Facebook Login

            if (!is_array($FBLogin)) {

                return -7;

            }

            //Add this User to the Database (The Rank is User and the Origin is Facebook)

            $this->_Register($FBLogin['first_name'], $FBLogin['last_name'], $FBLogin['email'], '', 'https://graph.facebook.com/' . $FBLogin['id'] . '/picture?type=normal', 0, 1, 1);

            //Search any User with this Email

            $Query = mysqli_query($this->DBLink, "SELECT `user_id`, `user_role`, `user_email`, `user_avatar`, `user_full_name` FROM `users`

				WHERE (`user_email` = '{$FBLogin['email']}');");

            //Sucessfull Login

            if ($Query && mysqli_num_rows($Query) == 1) {

                $Result = mysqli_fetch_assoc($Query);

               // $Result['user_full_name'] = explode(' ', $Result['user_full_name']);

                //Add the Successfull Login Log

                $this->_LoginLog($Result['user_id'], 1);

                //Make the Web Session

                $_SESSION['logged'] = true;

                $_SESSION['id'] = htmlentities($Result['user_id'], ENT_QUOTES);

                $_SESSION['role'] = htmlentities($Result['user_role'], ENT_QUOTES);

                $_SESSION['avatar'] = htmlentities($Result['user_avatar'], ENT_QUOTES);

                $_SESSION['email'] = htmlentities($Result['user_email'], ENT_QUOTES);

                $_SESSION['name'] = htmlentities($Result['user_full_name'], ENT_QUOTES);

                return true;

                //Bad Email

            } else {

                return -8;

            }

            //Google Login

        } else if ($this->Google instanceof _GoogleModel && isset($_GET['code']) && !empty($_GET['code'])) {

            //Get the Results about the Google Login

            $GGLogin = $this->Google->_LoginCallback();

            //Bad Google Login

            if (!is_object($GGLogin)) {

                return -9;

            }

            //Add this User to the Database (The Rank is User and the Origin is Google)

            $Result = $this->_Register($GGLogin['givenName'], $GGLogin['familyName'], $GGLogin['email'], '', $GGLogin['picture'], 0, 1, 2);

            //Search any User with this Email

            $Query = mysqli_query($this->DBLink, "SELECT `user_id`, `user_role`, `user_email`, `user_avatar`, `user_full_name`, `user_verification_status` FROM `users`

				WHERE (`user_email` = '{$GGLogin['email']}');");

            //Sucessfull Login

            if ($Query && mysqli_num_rows($Query) == 1) {

                $Result = mysqli_fetch_assoc($Query);

                //$Result['user_full_name'] = explode(' ', $Result['user_full_name']);

                if ($Result['user_role'] == -1) {

                    header('Location: ./login?baneado');

                    exit();

                }

                //Si no está verificado

                if ($Result['user_verification_status'] != 1) {

                    $this->_LoginLog($Result['user_id'], 0);

                    header('Location: ./login?verify=none');

                    exit();

                }

                //Add the Successfull Login Log

                $this->_LoginLog($Result['user_id'], 1);

                //Make the Web Session

                $_SESSION['logged'] = true;

                $_SESSION['id'] = htmlentities($Result['user_id'], ENT_QUOTES);

                $_SESSION['role'] = htmlentities($Result['user_role'], ENT_QUOTES);

                $_SESSION['avatar'] = htmlentities($Result['user_avatar'], ENT_QUOTES);

                $_SESSION['email'] = htmlentities($Result['user_email'], ENT_QUOTES);

                $_SESSION['name'] = htmlentities($Result['user_full_name'], ENT_QUOTES);

                return true;

            } else {

                return -10;

            }

        }

    }
    
    //[*]ADDED REFERRALS POINTS FOR REFERRER USER

    public function _Register($FirstName, $LastName, $Email, $Password, $Avatar = '', $Referrer = 0, $Role = 0, $Origin = 0)

    { //Origin Values: 0 = E-Mail, 1 = Facebook, 2 = Google

        $FirstName = mysqli_real_escape_string($this->DBLink, $FirstName);

        $LastName = mysqli_real_escape_string($this->DBLink, $LastName);

        $Email = mysqli_real_escape_string($this->DBLink, $Email);

        $Password = mysqli_real_escape_string($this->DBLink, $Password);

        $Avatar = mysqli_real_escape_string($this->DBLink, $Avatar);

        $Referrer = mysqli_real_escape_string($this->DBLink, $Referrer);

        $Role = 7;

        $Origin = mysqli_real_escape_string($this->DBLink, $Origin);

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $rol = $personalizacion['rol'];

        //Don't have the Neededs Constants

        if (!defined('RANKS_LIST') || !is_array(RANKS_LIST) || empty(RANKS_LIST)) {

            return -1;

        }

        //If the First Name is Invalid

        //If the E-Mail is Invalid

        if (empty($Email) || strlen($Email) > 150 || !filter_var($Email, FILTER_VALIDATE_EMAIL)) {

            return -4;

        }

        //If the Password is Invalid

        if ($Origin == 0 && (empty($Password) || strlen($Password) < 8 || strlen($Password) > 256)) {

            return -5;

        }

        //If the Avatar is Invalid

        if (!empty($Avatar) && filter_var($Avatar, FILTER_VALIDATE_URL) == false) {

            return -6;

        }

        //If the Referrer is Invalid

        if ($Referrer != 0 && (!is_numeric($Referrer) || $this->_GetUserData($Referrer) < 0)) {

            return -7;

        }

        //If the Role is Invalid

        if (!is_numeric($Role) || $Role < min(array_keys(RANKS_LIST)) || $Role > max(array_keys(RANKS_LIST))) {

            return -8;

        }

        //If the Origin is Invalid

        if (!is_numeric($Origin) || $Origin < 0 || $Origin > 2) {

            return -9;

        }

        //Check if the Avatar is Empty

        if (empty($Avatar)) {

            //Set the Default Avatar

            $Avatar = DEFAULT_AVATAR;

        }

        //Search any User with this Email

        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`user_id`) AS `total` FROM `users` WHERE (`user_email` = '{$Email}');")) {

            $Result = mysqli_fetch_assoc($Query);

            //If the User Already Exists

            if ($Result['total'] > 0) {

                return -10;

            }

            //Can't Know if the User Exists

        } else {

            return -11;

        }

        //If is Login by E-Mail

        if ($Origin == 0) {

            $Password = $this->_HashPassword($Email, $Password);

        }

        $FullName = $FirstName . ' ' . $LastName;

        //Set the Error Counters

        $i = 0;

        $x = 0;

        do {

            //Generate the Referrer Code for this User

            $Code = $this->_RandomString(45, '123456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ');

            //Search this Referrer Code

            $Query = mysqli_query($this->DBLink, "SELECT * FROM `users` WHERE (`user_code` = '{$Code}');");

            //Check for DataBase Query Error

            if ($Query === false) {

                //Plus 1 to the Query Error Counter

                $x++;

                continue;

            }

            //Plus 1 to the Error Counter

            $i++;

        } while (mysqli_num_rows($Query) > 0 && ($i <= 3 || $x <= 3));

        //Error Generating the Referrer Code

        if ($i > 3 || $x > 3) {

            return -12;

        }

        //Stop the DataBase Auto-Commit

        mysqli_autocommit($this->DBLink, true);

        //Get the Current TimeStamp

        $Time = time();

        //Add the User to the Database

        if (!mysqli_query($this->DBLink, "INSERT INTO `users` (`user_role`, `user_origin`, `user_email`, `user_password`, `user_full_name`, `user_avatar`, `user_code`, `user_last_seen`, `user_first_seen`, `id_rol`) VALUES ('{$Role}', '{$Origin}', '{$Email}', '{$Password}', '{$FullName}', '{$Avatar}', '{$Code}', '0', '{$Time}','{$rol}');")) {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);

            return -18;

        }

        //Get the User ID

        $UserID = mysqli_insert_id($this->DBLink);

        $EmailUser = $Email;

        $Newsletter = file_get_contents(__ROOT__ . '/emails/confirmacion_de_cuenta.html');

        //Correo para todos los Administradores

        if ($QueryAdmin = mysqli_query($this->DBLink, "SELECT user_full_name, user_email FROM `users` WHERE notificado = 1")) {

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($QueryAdmin)) {

                //Check for Newsletter Reading Error

                if ($Newsletter == false) {

                    //Revert the DataBase Queries

                    mysqli_rollback($this->DBLink);

                    //Start the DataBase Auto-Commit

                    mysqli_autocommit($this->DBLink, true);

                    return -20;

                }

                $Keywords = array();

                $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

                $Keywords[] = array('%user_name%', htmlentities($Result['user_full_name'], ENT_QUOTES));

                $Keywords[] = array('%correo%', htmlentities($EmailUser, ENT_QUOTES));

                $Keywords[] = array('%imagen%', htmlentities($personalizacion['imagen_email'], ENT_QUOTES));

                $Keywords[] = array('%cabecera%', htmlentities($personalizacion['cabecera_email'], ENT_QUOTES));

                $Keywords[] = array('%cuerpo%', htmlentities($personalizacion['texto_email'], ENT_QUOTES));

                $Keywords[] = array('%asunto%', htmlentities($personalizacion['asunto_email'], ENT_QUOTES));

                //Declare the Mailer Model

                if (!($this->Mailer instanceof _MailerModel)) {

                    $this->Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

                }

                //Set the Message Keywords

                $this->Mailer->_SetKeywords($Keywords);

                //Send the E-Mail to the User

                $Email = $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, trim($Result['user_email']), "Email marketing", $Newsletter, APP_NAME);

                /*

                //Check for Invalid E-Mail

                if ($Email !== true) {

                //Revert the DataBase Queries

                mysqli_rollback($this->DBLink);

                //Start the DataBase Auto-Commit

                mysqli_autocommit($this->DBLink, true);

                return -21;

                }

                 */

                //Send the DataBase Commit

                if (!mysqli_commit($this->DBLink)) {

                    //Revert the DataBase Queries

                    mysqli_rollback($this->DBLink);

                    //Start the DataBase Auto-Commit

                    mysqli_autocommit($this->DBLink, true);

                    return -22;

                }

                //Start the DataBase Auto-Commit

                mysqli_autocommit($this->DBLink, true);

            }

        }

        return $UserID;

    }

    public function _ChangeRole($UserID, $Role)

    {

        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);

        $Role = mysqli_real_escape_string($this->DBLink, $Role);

        //Don't have the Neededs Constants

        if (!defined('RANKS_LIST') || !is_array(RANKS_LIST) || empty(RANKS_LIST)) {

            return -1;

        }

        //Invalid User ID

        if (!is_numeric($UserID)) {

            return -2;

        }

        $UserData = $this->_GetUserData($UserID);

        //$UserData['user_id']

        //$UserData['user_role']

        //$UserData['user_origin']

        //$UserData['user_referrer']

        //$UserData['user_referrals']

        //$UserData['user_email']

        //$UserData['user_password']

        //$UserData['user_full_name']

        //$UserData['user_purchases']

        //$UserData['user_tokens']

        //$UserData['user_blocked_tokens']

        //$UserData['user_bonus_tokens']

        //$UserData['user_bonus_blocked_tokens']

        //$UserData['user_oneups']

        //$UserData['user_bonuses']

        //$UserData['user_address']

        //$UserData['user_avatar']

        //$UserData['user_code']

        //$UserData['user_verification_status']

        //$UserData['user_last_seen']

        //$UserData['user_first_seen']

        //Invalid User ID or User doesn't Exist

        if (!is_array($UserData)) {

            return -3;

        }

        //Check for Invalid User Role

        if (!is_numeric($Role) || $Role < min(array_keys(RANKS_LIST)) || $Role > max(array_keys(RANKS_LIST))) {

            return -4;

        }

        //User Already have this Role

        if ($UserData['user_role'] == $Role) {

            return true;

        }

        //Update this User Role

        if (!mysqli_query($this->DBLink, "UPDATE `users` SET `user_role` = '{$Role}' WHERE (`user_id` = '{$UserID}');")) {

            //DataBase Query Error

            return -5;

        }

        return true;

    }

    public function _ChangeAvatar($UserID, $Avatar)

    {

        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);

        //Invalid User ID

        if (!is_numeric($UserID)) {

            return -1;

        }

        $UserData = $this->_GetUserData($UserID);

        //$UserData['user_id']

        //$UserData['user_role']

        //$UserData['user_origin']

        //$UserData['user_referrer']

        //$UserData['user_referrals']

        //$UserData['user_email']

        //$UserData['user_password']

        //$UserData['user_full_name']

        //$UserData['user_purchases']

        //$UserData['user_tokens']

        //$UserData['user_blocked_tokens']

        //$UserData['user_bonus_tokens']

        //$UserData['user_bonus_blocked_tokens']

        //$UserData['user_oneups']

        //$UserData['user_bonuses']

        //$UserData['user_address']

        //$UserData['user_avatar']

        //$UserData['user_code']

        //$UserData['user_verification_status']

        //$UserData['user_last_seen']

        //$UserData['user_first_seen']

        //Invalid User ID or User doesn't Exist

        if (!is_array($UserData)) {

            return -2;

        }

        //Check for Valid Avatar

        if (!is_array($Avatar) || !isset($Avatar['tmp_name']) || empty($Avatar['tmp_name'])) {

            return -4;

        }

        //Declare the Image Upload Library

        if (!($this->Upload instanceof _ImageUpload)) {

            $this->Upload = new _ImageUpload($this->DBLink);

        }

        $Avatar = $this->Upload->_SaveImage($Avatar);

        //Check for Address Proof Upload Error

        if ($Avatar < 0) {

            return -5;

        }

        $Avatar = mysqli_real_escape_string($this->DBLink, WEBSITE_URL . 'image.php?id=' . $Avatar);

        //Update this User Avatar

        if (!mysqli_query($this->DBLink, "UPDATE `users` SET `user_avatar` = '{$Avatar}' WHERE (`user_id` = '{$UserID}');")) {

            //DataBase Query Error

            return -6;

        }

        //Change the Avatar in the Session

        $_SESSION['avatar'] = htmlentities($Avatar, ENT_QUOTES);

        return true;

    }

    public function _RestoreAvatar()

    {

        $this->Google = new _GoogleModel($this->DBLink);

        $GGLogin = $this->Google->_LoginCallback();

        $Avatar = $GGLogin['picture'];

        //Update this User Avatar

        if (!mysqli_query($this->DBLink, "UPDATE `users` SET `user_avatar` = '{$Avatar}' WHERE (`user_id` = '{$_SESSION['id']}');")) {

            //DataBase Query Error

            return -6;

        }

        //Change the Avatar in the Session

        $_SESSION['avatar'] = htmlentities($Avatar, ENT_QUOTES);

        return true;

    }

    public function _GetUserData2()

    {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `users`;")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            return $Clientes[0];

        }

    }

    public function _GetUserData($ID = 0)

    {

        $ID = mysqli_real_escape_string($this->DBLink, $ID);

        //Check if have a User E-Mail

        if (filter_var($ID, FILTER_VALIDATE_EMAIL)) {

            $Query = mysqli_query($this->DBLink, "SELECT * FROM `users` WHERE (`user_email` = '{$ID}');");

            //Check if have a User ID

        } else if (is_numeric($ID) && $ID >= 0 && $ID < 1000000) {

            //Get the Actual User Data

            if ($ID == 0) {

                $Query = mysqli_query($this->DBLink, "SELECT * FROM `users` WHERE (`user_id` = '{$_SESSION['id']}');");

                //Get the User Data for this ID

            } else {

                $Query = mysqli_query($this->DBLink, "SELECT * FROM `users` WHERE (`user_id` = '{$ID}');");

            }

            //Check if have a Referrer Code

        } else if (is_string($ID) && strlen($ID) == 45 && preg_match('/[a-z0-9]/i', $ID)) {

            $Query = mysqli_query($this->DBLink, "SELECT * FROM `users` WHERE (`user_code` = '{$ID}');");

            //Invalid User ID

        } else {

            return -1;

        }

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) == 1) {

            $Result = mysqli_fetch_assoc($Query);

            //$Result['user_id']

            //$Result['user_role']

            //$Result['user_origin']

            //$Result['user_referrer']

            //$Result['user_referrals']

            //$Result['user_email']

            //$Result['user_password']

            //$Result['user_full_name']

            //$Result['user_purchases']

            //$Result['user_tokens']

            //$Result['user_blocked_tokens']

            //$Result['user_bonus_tokens']

            //$Result['user_bonus_blocked_tokens']

            //$Result['user_oneups']

            //$Result['user_bonuses']

            //$Result['user_address']

            //$Result['user_avatar']

            //$Result['user_code']

            //$Result['user_verification_status']

            //$Result['user_last_seen']

            //$Result['user_first_seen']

            return $Result;

            //Bad Query

        } else {

            return -2;

        }

    }

    public function _GetUserName($ID = 0)

    {

        $ID = mysqli_real_escape_string($this->DBLink, $ID);

        //Invalid User ID

        if (!is_numeric($ID) || $ID < 0 || $ID > 1000000) {

            return -1;

        }

        if ($ID === 0) {

            $Query = mysqli_query($this->DBLink, "SELECT `user_email` AS `email` FROM `users` WHERE (`user_id` = '{$_SESSION['id']}');");

        } else {

            $Query = mysqli_query($this->DBLink, "SELECT `user_email` AS `email` FROM `users` WHERE (`user_id` = '{$ID}');");

        }

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) == 1) {

            $Result = mysqli_fetch_assoc($Query);

            return $Result['email'];

        }

        return -2;

    }

    public function _GetUsersCount()

    {

        //Count the Users on the DataBase

        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`user_id`) AS `total` FROM `users` WHERE user_verification_status = 1;")) {

            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists

            if (isset($Result['total'])) {

                return $Result['total'];

            } else {

                return -1;

            }

            //DataBase Query Error

        } else {

            return -2;

        }

    }

    public function _GetUsersCountPending()

    {

        //Count the Users on the DataBase

        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`user_id`) AS `total` FROM `users` WHERE user_verification_status = 0;")) {

            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists

            if (isset($Result['total'])) {

                return $Result['total'];

            } else {

                return -1;

            }

            //DataBase Query Error

        } else {

            return -2;

        }

    }

    #####################################################################

    ##    Function Description:

    ##        Get the List with All Users on the DataBase

    ##    Return:

    ##        Array = The Users List in a 2D Array

    ##        -1 = Can't Get the Users List

    #####################################################################

    public function _GetUsersList()

    {

        //Sucessfull Query

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `users` WHERE user_verification_status = 1;")) {

            $Result = array();

            while ($User = mysqli_fetch_assoc($Query)) {

                $Result[] = $User;

                //$Result['user_id']

                //$Result['user_role']

                //$Result['user_origin']

                //$Result['user_referrer']

                //$Result['user_referrals']

                //$Result['user_email']

                //$Result['user_password']

                //$Result['user_full_name']

                //$Result['user_purchases']

                //$Result['user_tokens']

                //$Result['user_blocked_tokens']

                //$Result['user_bonus_tokens']

                //$Result['user_bonus_blocked_tokens']

                //$Result['user_oneups']

                //$Result['user_bonuses']

                //$Result['user_address']

                //$Result['user_avatar']

                //$Result['user_code']

                //$Result['user_verification_status']

                //$Result['user_last_seen']

                //$Result['user_first_seen']

            }

            return $Result;

        }

        //Can't Get the Users List

        return -1;

    }

    public function GetUsuariosConRol($id)

    {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `users`WHERE (`id_rol` = '{$id}');")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            if (!empty($Clientes)) {

                return $Clientes;

            } else {

                return null;

            }

        }

    }

    public function _GetUsersListPending()

    {

        //Sucessfull Query

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `users` WHERE user_verification_status = 0;")) {

            $Result = array();

            while ($User = mysqli_fetch_assoc($Query)) {

                $Result[] = $User;

                //$Result['user_id']

                //$Result['user_role']

                //$Result['user_origin']

                //$Result['user_referrer']

                //$Result['user_referrals']

                //$Result['user_email']

                //$Result['user_password']

                //$Result['user_full_name']

                //$Result['user_purchases']

                //$Result['user_tokens']

                //$Result['user_blocked_tokens']

                //$Result['user_bonus_tokens']

                //$Result['user_bonus_blocked_tokens']

                //$Result['user_oneups']

                //$Result['user_bonuses']

                //$Result['user_address']

                //$Result['user_avatar']

                //$Result['user_code']

                //$Result['user_verification_status']

                //$Result['user_last_seen']

                //$Result['user_first_seen']

            }

            return $Result;

        }

        //Can't Get the Users List

        return -1;

    }

    public function _LoginAttempts($Minutes = 30)

    {

        //If the Minutes Variable is Invalid

        if (!is_numeric($Minutes) || $Minutes > 1440) {

            return -1;

        }

        //Pass from Minutes to Seconds

        $Minutes = $Minutes * 60;

        //Get the Current Timestamp

        $Time = time();

        //Count the Bad Logins Attempts in the Last Minutes for the Current Visitor

        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`login_ip`) AS `attempts` FROM `logins` WHERE (`login_ip` = '{$_SERVER['REMOTE_ADDR']}' AND `login_success` = 0 AND `login_date` >= ({$Time} - {$Minutes}));")) {

            //Get the Count Results

            $Result = mysqli_fetch_assoc($Query);

            //Return the Ammount of Bad Logins Attempts)

            return $Result['attempts'];

            //Can't Know if the User Exists

        } else {

            return -2;

        }

    }

    public function _LoginList($UserID = 0)

    {

        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);

        //If the User ID is Invalid

        if ($UserID != 0 && $this->_GetUserData($UserID) < 0) {

            return -1;

        }

        //Search this User Logins on the DataBase

        if ($UserID == 0) {

            $Query = mysqli_query($this->DBLink, "SELECT * FROM `logins` WHERE (`login_user` = '{$_SESSION['id']}') ORDER BY `login_date` DESC LIMIT 20;");

        } else {

            $Query = mysqli_query($this->DBLink, "SELECT * FROM `logins` WHERE (`login_user` = '{$UserID}') ORDER BY `login_date` DESC LIMIT 20;");

        }

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1) {

            $Result = array();

            while ($Login = mysqli_fetch_assoc($Query)) {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

            }

            return $Result;

        }

        //Can't Get the Users List

        return -2;

    }

    public function _LoginSuccess($UserID = 0)

    {

        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);

        //If the User ID is Invalid

        if ($UserID != 0 && $this->_GetUserData($UserID) < 0) {

            return -1;

        }

        //Search this User Logins on the DataBase

        if ($UserID == 0) {

            $Query = mysqli_query($this->DBLink, "SELECT * FROM `logins` WHERE (`login_user` = '{$_SESSION['id']}' and login_success= '1')   LIMIT 20;");

        } else {

            $Query = mysqli_query($this->DBLink, "SELECT * FROM `logins` WHERE (`login_user` = '{$UserID}' and login_success= '1') LIMIT 20;");

        }

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1) {

            $Result = array();

            while ($Login = mysqli_fetch_assoc($Query)) {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

            }

            return $Result;

        }

        //Can't Get the Users List

        return [];

    }

    public function _LoginLog($UserID, $Success)

    {

        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);

        $Success = mysqli_real_escape_string($this->DBLink, $Success);

        //If the User ID is Invalid

        if ($UserID != 0 && $this->_GetUserData($UserID) < 0) {

            return -1;

        }

        //If the Sucess Flag is Invalid

        if (!is_numeric($Success) || $Success < 0 || $Success > 1) {

            return -2;

        }

        //Get the Client User-Agent

        if (isset($_SERVER['HTTP_USER_AGENT'])) {

            $UserAgent = mysqli_real_escape_string($this->DBLink, $_SERVER['HTTP_USER_AGENT']);

        } else {

            $UserAgent = '';

        }

        //Get the Current TimeStamp

        $Time = time();

        //Have a User ID

        if ($UserID != 0) {

            //Add the Login Attempt to the Database

            if (!mysqli_query($this->DBLink, "INSERT INTO `logins` (`login_user`, `login_ip`, `login_agent`, `login_success`, `login_date`) VALUES ('{$UserID}', '{$_SERVER['REMOTE_ADDR']}', '{$UserAgent}', '{$Success}', '{$Time}');")) {

                return -3;

            }

            //Don't Have a User ID

        } else {

            //Add the Login Attempt to the Database

            if (!mysqli_query($this->DBLink, "INSERT INTO `logins` (`login_ip`, `login_agent`, `login_success`, `login_date`) VALUES ('{$_SERVER['REMOTE_ADDR']}', '{$UserAgent}', '{$Success}', '{$Time}');")) {

                return -4;

            }

        }

        return true;

    }

    public function _Logout()

    {

        session_destroy();

        return true;

    }

    public function AddLogin($login_user, $login_ip, $login_agent, $login_success, $login_date)

    {

        $login_user = mysqli_real_escape_string($this->DBLink, $login_user);

        $login_ip = mysqli_real_escape_string($this->DBLink, $login_ip);

        $login_agent = mysqli_real_escape_string($this->DBLink, $login_agent);

        $login_success = mysqli_real_escape_string($this->DBLink, $login_success);

        $date = mysqli_real_escape_string($this->DBLink, $login_date);

        $login_date = strtotime($date);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `logins` (`login_user`, `login_ip`, `login_agent`, `login_success`, `login_date`)

			VALUES ('{$login_user}', '{$login_ip}', '{$login_agent}', '{$login_success}','{$login_date}');");

        if ($sql) {

            return 1;

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function _DeleteUser($UserID)

    {

        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);

        $this->Folders = new _FoldersModel($this->DBLink);

        //Disable the Foreign Key Checks

        if (!mysqli_query($this->DBLink, "SET foreign_key_checks = 0;")) {

            return -1;

        }

        if ($QueryFolder = mysqli_query($this->DBLink, "SELECT folder_id FROM `folders` WHERE folder_user = '{$UserID}'")) {

            //Loop around the Folders

            while ($Result = mysqli_fetch_assoc($QueryFolder)) {

                //Eliminar carpetas del usuario

                $this->Folders->DeleteFolder($Result['folder_id']);

            }

        }

        if ($QueryFile = mysqli_query($this->DBLink, "SELECT file_id FROM `files` WHERE  file_user = '{$UserID}'")) {

            //Loop around the Files

            while ($Result = mysqli_fetch_assoc($QueryFile)) {

                //Eliminar archivos del usuario

                $this->Folders->DeleteFiles($Result['file_id']);

            }

        }

        //Update the supervisor

        if (!mysqli_query($this->DBLink, "UPDATE `users` SET `user_supervisor` = NULL WHERE (`user_supervisor` = '{$UserID}');")) {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);

            return -2;

        }

        //Delete the Bad Logins Logs for this User

        if (!mysqli_query($this->DBLink, "DELETE FROM `logins` WHERE (`login_user` = '{$UserID}');")) {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);

            //DataBase Query Error

            return -3;

        }

        //Delete the Bad favorites for this User

        if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_user` = '{$UserID}');")) {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);

            //DataBase Query Error

            return -3;

        }

        if (!mysqli_query($this->DBLink, "DELETE FROM `users` WHERE (`user_id` = '{$UserID}');")) {

            //Can't Delete this User

            return -4;

        }

        //Enable the Foreign Key Checks

        if (!mysqli_query($this->DBLink, "SET foreign_key_checks = 1;")) {

            return -5;

        }

        //Start the DataBase Auto-Commit

        mysqli_autocommit($this->DBLink, true);

        return true;

    }

    private function _RandomString($Length = 10, $Chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ')

    {

        $Result = '';

        for ($i = 0; $i < $Length; $i++) {

            $Result .= $Chars[rand(0, strlen($Chars) - 1)];

        }

        return $Result;

    }

    public function CreateMiembroEquipo($dni, $precio_hora, $horas_totales, $user_id, $email, $precio_horas_extra, $direccion, $telefono)

    {

        $dni = mysqli_real_escape_string($this->DBLink, $dni);

        $precio_hora = mysqli_real_escape_string($this->DBLink, $precio_hora);

        $horas_totales = mysqli_real_escape_string($this->DBLink, $horas_totales);

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);

        $email = mysqli_real_escape_string($this->DBLink, $email);

        $precio_horas_extra = mysqli_real_escape_string($this->DBLink, $precio_horas_extra);

        $direccion = mysqli_real_escape_string($this->DBLink, $direccion);

        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `miembro_equipo` (`dni`,`precio_hora`,`horas_totales`,`user_id`,`email`,`precio_horas_extra`,`direccion`,`telefono` )

			VALUES ( '{$dni}','{$precio_hora}','{$horas_totales}','{$user_id}','{$email}','{$precio_horas_extra}','{$direccion}','{$telefono}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function VerificarUsuario($id)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `users` SET `verificado` = 1 WHERE (`user_id` = '{$id}');");

        if ($sql) {

            echo "Apartado ac correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function JustificarAnomalia($id, $justificacion)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $justificacion = mysqli_real_escape_string($this->DBLink, $justificacion);

        $sql = mysqli_query($this->DBLink, "UPDATE `anomalia` SET `justificacion` = '{$justificacion}' WHERE (`id_anomalia` = '{$id}');");

        if ($sql) {

            echo "Apartado ac correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function EditarHoras($id, $horas)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $horas = mysqli_real_escape_string($this->DBLink, $horas);

        $sql = mysqli_query($this->DBLink, "UPDATE `miembro_equipo` SET `horas_totales` = '{$horas}' WHERE (`id_miembro` = '{$id}');");

        if ($sql) {

            echo "Apartado ac correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function ConfigurarAnomalias($id, $kilometros_casa, $kilometros_calle, $calle_anomalia)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $kilometros_casa = mysqli_real_escape_string($this->DBLink, $kilometros_casa);

        $kilometros_calle = mysqli_real_escape_string($this->DBLink, $kilometros_calle);

        $calle_anomalia = mysqli_real_escape_string($this->DBLink, $calle_anomalia);

        $sql = mysqli_query($this->DBLink, "UPDATE `miembro_equipo` SET `kilometros_casa`= '{$kilometros_casa}',`kilometros_calle`='{$kilometros_calle}',`calle` ='{$calle_anomalia}' WHERE (`id_miembro` = '{$id}');");

        if ($sql) {

            echo "Apartado ac correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function PausarFichaje($id, $ultima_salida)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $ultima_salida = mysqli_real_escape_string($this->DBLink, $ultima_salida);

        $sql = mysqli_query($this->DBLink, "UPDATE `fichajes` SET `estado` = 'En pausa',`ultima_salida` = '{$ultima_salida}'  WHERE (`id_fichaje` = '{$id}');");

        if ($sql) {

            echo "Apartado ac correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function ReanudarFichaje($id, $ultima_entrada, $horas_descanso)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $ultima_entrada = mysqli_real_escape_string($this->DBLink, $ultima_entrada);

        $horas_descanso = mysqli_real_escape_string($this->DBLink, $horas_descanso);

        $sql = mysqli_query($this->DBLink, "UPDATE `fichajes` SET `estado` = 'En curso',`ultima_entrada` = '{$ultima_entrada}' ,`horas_descanso` = '{$horas_descanso}' WHERE (`id_fichaje` = '{$id}');");

        if ($sql) {

            echo "Apartado ac correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function FinalizarFichaje($id, $fecha_salida)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $fecha_salida = mysqli_real_escape_string($this->DBLink, $fecha_salida);

        $sql = mysqli_query($this->DBLink, "UPDATE `fichajes` SET `estado` = 'Finalizado',`fecha_salida` = '{$fecha_salida}'  WHERE (`id_fichaje` = '{$id}');");

        if ($sql) {

            echo "Apartado ac correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function CreateFichaje($user_id, $fecha_entrada, $estado, $fecha_salida = null, $horas_descanso = null)

    {

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);

        $fecha_entrada = mysqli_real_escape_string($this->DBLink, $fecha_entrada);

        $horas_descanso = mysqli_real_escape_string($this->DBLink, $horas_descanso);

        $today = date($fecha_entrada);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        if ($fecha_salida != null) {

            $fecha_salida = mysqli_real_escape_string($this->DBLink, $fecha_salida);

            $sql = mysqli_query($this->DBLink, "INSERT INTO `fichajes` (`id_miembro`, `fecha_entrada`, `fecha_salida`, `horas_descanso`, `fecha`, `estado`)

				VALUES ('{$user_id}', '{$fecha_entrada}', '{$fecha_salida}', '{$horas_descanso}','{$today}','{$estado}');");

        } else {

            $sql = mysqli_query($this->DBLink, "INSERT INTO `fichajes` (`id_miembro`, `fecha_entrada`, `fecha_salida`, `horas_descanso`, `fecha`, `estado`)

				VALUES ('{$user_id}', '{$fecha_entrada}', NULL, '{$horas_descanso}','{$today}','{$estado}');");

        }

        $id_fichaje = mysqli_insert_id($this->DBLink);

        if ($sql) {

            echo "Records added successfully.";

            return $id_fichaje;

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function GetMiembroEquipo($PresupuestoID)

    {

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `miembro_equipo` WHERE (`id_miembro` = '{$PresupuestoID}');")) {

            $Folders = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;

            }

            if (!empty($Folders)) {

                return $Folders[0];

            } else {

                return null;

            }

        }

    }

    public function GetMiembroEquipoXIdUsuario($PresupuestoID)

    {

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `miembro_equipo` WHERE (`user_id` = '{$PresupuestoID}');")) {

            $Folders = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;

            }

            if (!empty($Folders)) {

                return $Folders[0];

            } else {

                return null;

            }

        }

    }

    public function GetMiembroEquipoById($PresupuestoID)

    {

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `miembro_equipo` WHERE (`id_miembro` = '{$PresupuestoID}');")) {

            $Folders = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;

            }

            if (!empty($Folders)) {

                return $Folders[0];

            } else {

                return null;

            }

        }

    }

    public function GetSubvencion($PresupuestoID)

    {

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `subvenciones` WHERE (`id_subvencion` = '{$PresupuestoID}');")) {

            $Folders = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;

            }

            if (!empty($Folders)) {

                return $Folders[0];

            } else {

                return null;

            }

        }

    }

    public function GetFichaje($PresupuestoID)

    {

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fichajes` WHERE (`id_fichaje` = '{$PresupuestoID}');")) {

            $Folders = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;

            }

            if (!empty($Folders)) {

                return $Folders[0];

            } else {

                return null;

            }

        }

    }

    public function GetEmpleado($PresupuestoID)

    {

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `empleados` WHERE (`id_empleado` = '{$PresupuestoID}');")) {

            $Folders = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;

            }

            if (!empty($Folders)) {

                return $Folders[0];

            } else {

                return null;

            }

        }

    }

    public function GetFacturaEmpleado($PresupuestoID)

    {

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_empleado` WHERE (`id_factura_empleado` = '{$PresupuestoID}');")) {

            $Folders = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;

            }

            if (!empty($Folders)) {

                return $Folders[0];

            } else {

                return null;

            }

        }

    }

    public function GetFichajeActivo($PresupuestoID)

    {

        // Validar el PresupuestoID para asegurarse de que no sea vacío o no válido

        if (empty($PresupuestoID)) {

            return null;

        }

        // Escapar la entrada para prevenir inyecciones SQL

        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);

        // Realizar la consulta SQL

        $query = "SELECT * FROM `fichajes` WHERE `id_miembro` = '{$PresupuestoID}' AND fecha_salida IS NULL LIMIT 1";

        $result = mysqli_query($this->DBLink, $query);

        // Comprobar si la consulta fue exitosa

        if ($result === false) {

            // Manejo de errores de consulta si es necesario

            error_log('Error en la consulta: ' . mysqli_error($this->DBLink));

            return null;

        }

        // Obtener el primer resultado (si existe)

        $fichajeActivo = mysqli_fetch_assoc($result);

        // Si se encontró un fichaje activo, devolverlo

        if ($fichajeActivo) {

            return $fichajeActivo;

        }

        // Si no hay fichaje activo, devolver null

        return null;

    }

    public function GetListFichajes($FechaInicio = 0, $FechaFinal = 0)

    {

        if ($FechaInicio != 0 && $FechaFinal != 0) {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fichajes` where (fecha_entrada BETWEEN '{$FechaInicio}' AND '{$FechaFinal}');")) {

                $Clientes = array();

                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query)) {

                    $Clientes[] = $Result;

                }

                return $Clientes;

            }

        } else {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fichajes`;")) {

                $Clientes = array();

                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query)) {

                    $Clientes[] = $Result;

                }

                return $Clientes;

            }

        }

    }

    public function GetAnomaliasList($FechaInicio = 0, $FechaFinal = 0)

    {

        if ($FechaInicio != 0 && $FechaFinal != 0) {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `anomalia` where (fecha BETWEEN '{$FechaInicio}' AND '{$FechaFinal}');")) {

                $Clientes = array();

                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query)) {

                    $Clientes[] = $Result;

                }

                return $Clientes;

            }

        } else {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `anomalia`;")) {

                $Clientes = array();

                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query)) {

                    $Clientes[] = $Result;

                }

                return $Clientes;

            }

        }

    }

    public function GetListFichajesHoy()

    {

        $date = date('Y-m-d');

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fichajes` WHERE (`fecha` = '{$date}');")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            return $Clientes;

        }

    }

    public function GetListJornadas()

    {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `jornada_laboral`;")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            return $Clientes;

        }

    }

    public function GetListFichajesUsuario($User_id)

    {

        $User_id = mysqli_real_escape_string($this->DBLink, $User_id);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fichajes` WHERE (`id_miembro` = '{$User_id}');")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            return $Clientes;

        }

    }

    public function GetMiembroByIdUser($User_id)

    {

        $User_id = mysqli_real_escape_string($this->DBLink, $User_id);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `miembro_equipo` WHERE (`user_id` = '{$User_id}');")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            if (empty($Clientes)) {

                return null;

            } else {

                return $Clientes[0];

            }

        }

    }

    public function GetUserByMiembro($id_miembro)

    {

        // Aseguramos que el ID del miembro sea seguro para la consulta

        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        // Realizamos una consulta JOIN entre 'miembro_equipo' y 'users'

        $query = "

            SELECT u.* 

            FROM users u

            JOIN miembro_equipo me ON u.user_id = me.user_id

            WHERE me.id_miembro = '{$id_miembro}'

        ";

        if ($result = mysqli_query($this->DBLink, $query)) {

            // Inicializamos un array para almacenar los datos

            $Clientes = array();

            // Iteramos sobre los resultados de la consulta

            while ($row = mysqli_fetch_assoc($result)) {

                $Clientes[] = $row;

            }

            // Si encontramos un usuario, devolvemos el primer resultado, si no, retornamos null

            if (empty($Clientes)) {

                return null;

            } else {

                return $Clientes[0];

            }

        } else {

            // Si la consulta falla, podemos retornar null o manejar el error según sea necesario

            return null;

        }

    }

    public function SetEstadoSubvencionEnviada($id, $estado)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        $sql = mysqli_query($this->DBLink, "UPDATE `cliente_subvencion` SET `estado` = '{$estado}' WHERE (`id_cliente_subvencion` = '{$id}');");

        if ($sql) {

            echo "Apartado editado correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function GetRol($User_id)

    {

        $User_id = mysqli_real_escape_string($this->DBLink, $User_id);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `roles` WHERE (`id_rol` = '{$User_id}');")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            if (empty($Clientes)) {

                return null;

            } else {

                return $Clientes[0];

            }

        }

    }

    public function ExisteJornada($id_miembro)

    {

        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        $sql = mysqli_query($this->DBLink, "SELECT * FROM `jornada_laboral` WHERE (`id_miembro` = '{$id_miembro}');");

        $Clientes = array();

        //Loop around the Referrals

        while ($Result = mysqli_fetch_assoc($sql)) {

            $Clientes[] = $Result;

        }

        return count($Clientes);

    }

    public function GetJornada($id_miembro)

    {

        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        $sql = mysqli_query($this->DBLink, "SELECT * FROM `jornada_laboral` WHERE (`id_miembro` = '{$id_miembro}');");

        $Clientes = array();

        //Loop around the Referrals

        while ($Result = mysqli_fetch_assoc($sql)) {

            $Clientes[] = $Result;

        }

        if (empty($Clientes)) {

            return null;

        } else {

            return $Clientes[0];

        }

    }

    public function GetDatosCliente($id_miembro)

    {

        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        $sql = mysqli_query($this->DBLink, "SELECT * FROM `datos_cliente` WHERE (`id_cliente_subvencion` = '{$id_miembro}');");

        $Clientes = array();

        //Loop around the Referrals

        while ($Result = mysqli_fetch_assoc($sql)) {

            $Clientes[] = $Result;

        }

        if (empty($Clientes)) {

            return null;

        } else {

            return $Clientes[0];

        }

    }

    public function GetAnomaliasMiembro($id_miembro)

    {

        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        $sql = mysqli_query($this->DBLink, "SELECT * FROM `anomalia` WHERE (`id_miembro` = '{$id_miembro}');");

        $Clientes = array();

        //Loop around the Referrals

        while ($Result = mysqli_fetch_assoc($sql)) {

            $Clientes[] = $Result;

        }

        return $Clientes;

    }

    public function CreateJornada($id_miembro, $tipo)

    {

        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        $tipo = mysqli_real_escape_string($this->DBLink, $tipo);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `jornada_laboral` (`id_miembro`,`tipo`) VALUES ('{$id_miembro}','{$tipo}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function CreateAnomalia($id_fichaje, $id_miembro, $anomalia)

    {

        $id_fichaje = mysqli_real_escape_string($this->DBLink, $id_fichaje);

        $id_fichaje = !empty($id_fichaje) ? "'$id_fichaje'" : "NULL";

        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        $anomalia = mysqli_real_escape_string($this->DBLink, $anomalia);

        $fecha = date("Y-m-d H:i:s");

        $sql = mysqli_query($this->DBLink, "INSERT INTO `anomalia` (`id_fichaje`,`id_miembro`,`anomalia`,`fecha`) VALUES ({$id_fichaje},'{$id_miembro}','{$anomalia}','{$fecha}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function EditJornada($id_jornada, $tipo, $lunes_e = null, $lunes_s = null, $martes_e = null, $martes_s = null, $miercoles_e = null, $miercoles_s = null, $jueves_e = null, $jueves_s = null, $viernes_e = null, $viernes_s = null, $sabado_e = null, $sabado_s = null, $lunes2_e = null, $lunes2_s = null, $martes2_e = null, $martes2_s = null, $miercoles2_e = null, $miercoles2_s = null, $jueves2_e = null, $jueves2_s = null, $viernes2_e = null, $viernes2_s = null, $sabado2_e = null, $sabado2_s = null, $vacaciones = null)

    {

        $id_jornada = mysqli_real_escape_string($this->DBLink, $id_jornada);

        $tipo = mysqli_real_escape_string($this->DBLink, $tipo);

        $lunes_e = mysqli_real_escape_string($this->DBLink, $lunes_e);

        $lunes_s = mysqli_real_escape_string($this->DBLink, $lunes_s);

        $martes_e = mysqli_real_escape_string($this->DBLink, $martes_e);

        $martes_s = mysqli_real_escape_string($this->DBLink, $martes_s);

        $miercoles_e = mysqli_real_escape_string($this->DBLink, $miercoles_e);

        $miercoles_s = mysqli_real_escape_string($this->DBLink, $miercoles_s);

        $jueves_e = mysqli_real_escape_string($this->DBLink, $jueves_e);

        $jueves_s = mysqli_real_escape_string($this->DBLink, $jueves_s);

        $viernes_e = mysqli_real_escape_string($this->DBLink, $viernes_e);

        $viernes_s = mysqli_real_escape_string($this->DBLink, $viernes_s);

        $sabado_e = mysqli_real_escape_string($this->DBLink, $sabado_e);

        $sabado_s = mysqli_real_escape_string($this->DBLink, $sabado_s);

        $vacaciones = mysqli_real_escape_string($this->DBLink, $vacaciones);

        $lunes2_e = mysqli_real_escape_string($this->DBLink, $lunes2_e);

        $lunes2_s = mysqli_real_escape_string($this->DBLink, $lunes2_s);

        $martes2_e = mysqli_real_escape_string($this->DBLink, $martes2_e);

        $martes2_s = mysqli_real_escape_string($this->DBLink, $martes2_s);

        $miercoles2_e = mysqli_real_escape_string($this->DBLink, $miercoles2_e);

        $miercoles2_s = mysqli_real_escape_string($this->DBLink, $miercoles2_s);

        $jueves2_e = mysqli_real_escape_string($this->DBLink, $jueves2_e);

        $jueves2_s = mysqli_real_escape_string($this->DBLink, $jueves2_s);

        $viernes2_e = mysqli_real_escape_string($this->DBLink, $viernes2_e);

        $viernes2_s = mysqli_real_escape_string($this->DBLink, $viernes2_s);

        $sabado2_e = mysqli_real_escape_string($this->DBLink, $sabado2_e);

        $sabado2_s = mysqli_real_escape_string($this->DBLink, $sabado2_s);

        $sql = mysqli_query($this->DBLink, "UPDATE `jornada_laboral` SET

	`lunes_e`='{$lunes_e}',

	`lunes_s`='{$lunes_s}',

	`martes_e`='{$martes_e}',

	`martes_s`='{$martes_s}',

	`miercoles_e`='{$miercoles_e}',

	`miercoles_s`='{$miercoles_s}',

	`jueves_e`='{$jueves_e}',

	`jueves_s`='{$jueves_s}',

	`viernes_e`='{$viernes_e}',

	`viernes_s`='{$viernes_s}',

	`sabado_e`='{$sabado_e}',

	`sabado_s`='{$sabado_s}',

	`vacaciones`='{$vacaciones}',

	`tipo`='{$tipo}',

	`lunes2_e`='{$lunes2_e}',

	`lunes2_s`='{$lunes2_s}',

	`martes2_e`='{$martes2_e}',

	`martes2_s`='{$martes2_s}',

	`miercoles2_e`='{$miercoles2_e}',

	`miercoles2_s`='{$miercoles2_s}',

	`jueves2_e`='{$jueves2_e}',

	`jueves2_s`='{$jueves2_s}',

	`viernes2_e`='{$viernes2_e}',

	`viernes2_s`='{$viernes2_s}',

	`sabado2_e`='{$sabado2_e}',

	`sabado2_s`='{$sabado2_s}'

	WHERE (`id_jornada` = '{$id_jornada}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function CreateDatosCliente($id_cliente_subvencion, $cif, $cp, $telefono, $email, $nombre_comercial, $id_sector, $id_fase, $id_zona, $tipo, $numero_empleados, $importe, $tipo_enlace, $user_id, $domicilio, $titulo)

    {

        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);

        $id_cliente_subvencion = mysqli_real_escape_string($this->DBLink, $id_cliente_subvencion);

        $cp = mysqli_real_escape_string($this->DBLink, $cp);

        $cif = mysqli_real_escape_string($this->DBLink, $cif);

        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);

        $email = mysqli_real_escape_string($this->DBLink, $email);

        $nombre_comercial = mysqli_real_escape_string($this->DBLink, $nombre_comercial);

        $id_sector = !empty($id_sector) ? "'$id_sector'" : "NULL";

        $id_fase = !empty($id_fase) ? "'$id_fase'" : "NULL";

        $id_zona = !empty($id_zona) ? "'$id_zona'" : "NULL";

        $tipo = mysqli_real_escape_string($this->DBLink, $tipo);

        $numero_empleados = mysqli_real_escape_string($this->DBLink, $numero_empleados);

        $importe = mysqli_real_escape_string($this->DBLink, $importe);

        $tipo_enlace = mysqli_real_escape_string($this->DBLink, $tipo_enlace);

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);

        $domicilio = mysqli_real_escape_string($this->DBLink, $domicilio);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `datos_cliente` (`id_cliente_subvencion`,`cp`,`cif`,`telefono`,`email`,`nombre_comercial`,`id_sector`,`id_fase`,`id_zona`,`tipo`,`numero_empleados`,`importe`,`tipo_enlace`,`user_id`,`domicilio`,`titulo` )

		VALUES ( '{$id_cliente_subvencion}','{$cp}','{$cif}','{$telefono}','{$email}','{$nombre_comercial}',$id_sector,$id_fase,$id_zona,'{$tipo}','{$numero_empleados}','{$importe}','{$tipo_enlace}','{$user_id}','{$domicilio}','{$titulo}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function EnviarSubvencion($id_cliente, $id_subvencion, $email, $email_marketing, $url_portada, $condiciones, $fecha_envio = null)

    {

        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);

        $id_subvencion = mysqli_real_escape_string($this->DBLink, $id_subvencion);

        $email = mysqli_real_escape_string($this->DBLink, $email);

        $email_marketing = mysqli_real_escape_string($this->DBLink, $email_marketing);

        $url_portada = mysqli_real_escape_string($this->DBLink, $url_portada);

        $condiciones = mysqli_real_escape_string($this->DBLink, $condiciones);

        if ($fecha_envio != null) {

            $fecha_envio = mysqli_real_escape_string($this->DBLink, $fecha_envio);

            $sql = mysqli_query($this->DBLink, "INSERT INTO `cliente_subvencion` (`id_cliente`, `id_subvencion`, `email`, `estado`, `fecha_envio`, `email_marketing`, `url_portada`, `condiciones`)

			VALUES ('{$id_cliente}', '{$id_subvencion}', '{$email}', 'Enviado','{$fecha_envio}','{$email_marketing}','{$url_portada}','{$condiciones}');");

        } else {

            $sql = mysqli_query($this->DBLink, "INSERT INTO `cliente_subvencion` (`id_cliente`, `id_subvencion`, `email`, `estado`, `fecha_envio`, `email_marketing`, `url_portada`, `condiciones`)

			VALUES ('{$id_cliente}', '{$id_subvencion}', '{$email}', 'No enviado',NULL,'{$email_marketing}','{$url_portada}','{$condiciones}');");

        }

        if ($sql) {

            echo ("New record");

            return mysqli_insert_id($this->DBLink);

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function SetNotificado($id, $bool)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $bool = mysqli_real_escape_string($this->DBLink, $bool);

        $sql = mysqli_query($this->DBLink, "UPDATE `users` SET `notificado` = '{$bool}' WHERE (`user_id` = '{$id}');");

        if ($sql) {

            echo "Apartado editado correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function SetTrabajadorPeluqueria($id, $bool)

    {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $bool = mysqli_real_escape_string($this->DBLink, $bool);

        $sql = mysqli_query($this->DBLink, "UPDATE `users` SET `trabajador_peluqueria` = '{$bool}' WHERE (`user_id` = '{$id}');");

        if ($sql) {

            echo "Apartado editado correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function DeleteLog($id)

    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `logins` WHERE (`login_id`='{$id}')");

        if ($sql) {

            echo "Nota eliminada correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function DeleteAnomalia($id)

    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `anomalia` WHERE (`id_anomalia`='{$id}')");

        if ($sql) {

            echo "Nota eliminada correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function DeleteServicioTrabajador($id)

    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `servicio_trabajador` WHERE (`id_servicio_trabajador`='{$id}')");

        if ($sql) {

            echo "Nota eliminada correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function GetListMiembros()

    {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `miembro_equipo`;")) {

            $Clientes = array();

            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;

            }

            return $Clientes;

        }

    }

    public function GetLoginsList()

    {

        //Search this User Logins on the DataBase

        $Query = mysqli_query($this->DBLink, "SELECT * FROM `logins`;");

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1) {

            $Result = array();

            while ($Login = mysqli_fetch_assoc($Query)) {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

            }

            return $Result;

        }

        //Can't Get the Users List

        return -2;

    }

    public function GetNavegadoresList()

    {

        //Search this User Logins on the DataBase

        $Query = mysqli_query($this->DBLink, "SELECT * FROM `navegadores`;");

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1) {

            $Result = array();

            while ($Login = mysqli_fetch_assoc($Query)) {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

            }

            return $Result;

        }

        //Can't Get the Users List

        return -2;

    }


    public function GetProvinciasList()

    {

        //Search this User Logins on the DataBase

        $Query = mysqli_query($this->DBLink, "SELECT * FROM `provincias`;");

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1) {

            $Result = array();

            while ($Login = mysqli_fetch_assoc($Query)) {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

            }

            return $Result;

        }

        //Can't Get the Users List

        return -2;

    }
    public function GetLocalidadesList()

    {

        //Search this User Logins on the DataBase

        $Query = mysqli_query($this->DBLink, "SELECT * FROM `localidades`;");

        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1) {

            $Result = array();

            while ($Login = mysqli_fetch_assoc($Query)) {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

            }

            return $Result;

        }

        //Can't Get the Users List

        return -2;

    }

    public function CreateServicioTrabajador($user_id, $fecha_i, $fecha_f)

    {

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);

        $fecha_i = mysqli_real_escape_string($this->DBLink, $fecha_i);

        $fecha_f = mysqli_real_escape_string($this->DBLink, $fecha_f);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `servicio_trabajador` (`user_id`,`fecha_i`, `fecha_f`)

														VALUES ('{$user_id}','{$fecha_i}', '{$fecha_f}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function CreateTurnoCompleto($user_id, $client_id, $id_servicio_calendario, $fecha_i, $fecha_f)

    {

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        $client_id = !empty($client_id) ? "'$client_id'" : "NULL";

        $id_servicio_calendario = mysqli_real_escape_string($this->DBLink, $id_servicio_calendario);

        $fecha_i = mysqli_real_escape_string($this->DBLink, $fecha_i);

        $fecha_f = mysqli_real_escape_string($this->DBLink, $fecha_f);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `servicio_trabajador` (`user_id`,`client_id`, `id_servicio_calendario`,`fecha_i`, `fecha_f`)

														VALUES ('{$user_id}',{$client_id}, '{$id_servicio_calendario}','{$fecha_i}', '{$fecha_f}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function EditarTurno($id_servicio_trabajador, $user_id, $client_id, $id_servicio_calendario, $fecha_i, $fecha_f)

    {

        $id_servicio_trabajador = mysqli_real_escape_string($this->DBLink, $id_servicio_trabajador);

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        $client_id = !empty($client_id) ? "'$client_id'" : "NULL";

        $id_servicio_calendario = mysqli_real_escape_string($this->DBLink, $id_servicio_calendario);

        $fecha_i = mysqli_real_escape_string($this->DBLink, $fecha_i);

        $fecha_f = mysqli_real_escape_string($this->DBLink, $fecha_f);

        $sql = mysqli_query($this->DBLink, "UPDATE `servicio_trabajador`

		SET

		`user_id` = '{$user_id}',

		`client_id` = {$client_id},

		`id_servicio_calendario` = '{$id_servicio_calendario}',

		`fecha_i` = '{$fecha_i}',

		`fecha_f` = '{$fecha_f}'

		WHERE (`id_servicio_trabajador` = '{$id_servicio_trabajador}');");

        if ($sql) {

            echo "Apartado editado correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function CambiarDia($id_servicio_trabajador, $fecha_i, $fecha_f)

    {

        $id_servicio_trabajador = mysqli_real_escape_string($this->DBLink, $id_servicio_trabajador);

        $fecha_i = mysqli_real_escape_string($this->DBLink, $fecha_i);

        $fecha_f = mysqli_real_escape_string($this->DBLink, $fecha_f);

        $sql = mysqli_query($this->DBLink, "UPDATE `servicio_trabajador`

		SET

		`fecha_i` = '{$fecha_i}',

		`fecha_f` = '{$fecha_f}'

		WHERE (`id_servicio_trabajador` = '{$id_servicio_trabajador}');");

        if ($sql) {

            echo "Apartado editado correctamente";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

    public function CreateServicioCalendario($id_servicio, $color_servicio)

    {

        $id_servicio = mysqli_real_escape_string($this->DBLink, $id_servicio);

        $color_servicio = mysqli_real_escape_string($this->DBLink, $color_servicio);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `servicio_calendario` (`id_servicio`,`color`)

														VALUES ('{$id_servicio}','{$color_servicio}');");

        if ($sql) {

            echo "Records added successfully.";

        } else {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

        }

    }

}