<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__'))
    {
    exit();
    }

class _TrabajadoresModel
    {
    private $DBLink;

    public function __construct(&$DBLink)
        {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
            {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
            } else
            {
            trigger_error('No MySQL connection!', E_USER_ERROR);
            }

        $Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false)
            {
            $Users->_Logout();

            header('Location: ./login');
            exit();
            }
        }

    public function CreateTrabajador($nombre, $cif, $precio_hora, $horas_totales, $email, $precio_horas_extra, $telefono)
        {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);
        $cif = mysqli_real_escape_string($this->DBLink, $cif);
        $precio_hora = mysqli_real_escape_string($this->DBLink, $precio_hora);
        $horas_totales = mysqli_real_escape_string($this->DBLink, $horas_totales);

        $email = mysqli_real_escape_string($this->DBLink, $email);
        $precio_horas_extra = mysqli_real_escape_string($this->DBLink, $precio_horas_extra);
        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `trabajadores` (`nombre`, `cif`, `precio_hora`, `horas_totales`, `email`, `precio_horas_extra`,`telefono`)
															VALUES ('{$nombre}', '{$cif}','{$precio_hora}','{$horas_totales}', '{$email}','{$precio_horas_extra}','{$telefono}');");
        if ($sql)
            {
            echo "Records added successfully.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }
    public function CreateProyecto($nombre, $color)
        {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);
        $color = mysqli_real_escape_string($this->DBLink, $color);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `proyectos` (`nombre`, `color`)
														VALUES ('{$nombre}', '{$color}');");
        if ($sql)
            {
            echo "Records added successfully.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }

    public function AsignarProyecto($proyecto_trabajador, $id_proyecto)
        {

        $proyecto_trabajador = mysqli_real_escape_string($this->DBLink, $proyecto_trabajador);
        $id_proyecto = mysqli_real_escape_string($this->DBLink, $id_proyecto);

        $sql = mysqli_query($this->DBLink, "UPDATE `proyecto_trabajador` SET `id_proyecto` = '{$id_proyecto}' WHERE (`id_proyecto_trabajador` = '{$proyecto_trabajador}');");
        if ($sql)
            {
            echo "Records added successfully.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }
    public function CambiarDia($proyecto_trabajador, $fecha_i, $fecha_f)
        {

        $fecha_i = mysqli_real_escape_string($this->DBLink, $fecha_i);
        $fecha_f = mysqli_real_escape_string($this->DBLink, $fecha_f);
        $proyecto_trabajador = mysqli_real_escape_string($this->DBLink, $proyecto_trabajador);

        $sql = mysqli_query($this->DBLink, "UPDATE `proyecto_trabajador` SET `fecha_i` = '{$fecha_i}',`fecha_f` = '{$fecha_f}' WHERE (`id_proyecto_trabajador` = '{$proyecto_trabajador}');");
        if ($sql)
            {
            echo "Records added successfully.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }
    public function setDates($proyecto_trabajador, $fecha_i, $fecha_f)
        {
        $fecha_i = mysqli_real_escape_string($this->DBLink, $fecha_i);
        $fecha_f = mysqli_real_escape_string($this->DBLink, $fecha_f);
        $sql = mysqli_query($this->DBLink, "UPDATE `proyecto_trabajador` SET `fecha_i` = '{$fecha_i}', `fecha_f` = '{$fecha_f}' WHERE (`id_proyecto_trabajador` = '{$proyecto_trabajador}');");
        if ($sql)
            {
            echo "Records added successfully.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }
    public function AsignarTrabajador($id_trabajador, $fecha_i, $fecha_f)
        {

        $id_trabajador = mysqli_real_escape_string($this->DBLink, $id_trabajador);

        $fecha_i = mysqli_real_escape_string($this->DBLink, $fecha_i);
        $fecha_f = mysqli_real_escape_string($this->DBLink, $fecha_f);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `proyecto_trabajador` (`id_trabajador`,`fecha_i`, `fecha_f`)
													VALUES ('{$id_trabajador}','{$fecha_i}', '{$fecha_f}');");
        if ($sql)
            {
            echo "Records added successfully.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }

    public function ReenviarPresupuesto($id)
        {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `presupuestos` SET `estado` = 'Pendiente' WHERE (`id_presupuesto` = '{$id}');");

        if ($sql)
            {
            echo "Apartado editado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }
    public function DeleteProyectoTrabajador($id)
        {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `proyecto_trabajador` WHERE id_proyecto_trabajador={$id}");

        if ($sql)
            {
            echo "Presupuesto eliminado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }
    public function EliminarPresupuesto($id)
        {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `presupuestos` WHERE id_presupuesto={$id}");

        if ($sql)
            {
            echo "Presupuesto eliminado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }
    public function DeleteProyecto($id)
        {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `proyectos` WHERE id_proyecto={$id}");

        if ($sql)
            {
            echo "Presupuesto eliminado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }
    public function DeleteTrabajador($id)
        {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `trabajadores` WHERE id_trabajador={$id}");

        if ($sql)
            {
            echo "Presupuesto eliminado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }
    public function RechazarPresupuesto($id)
        {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `presupuestos` SET `estado` = 'Rechazado' WHERE (`id_presupuesto` = '{$id}');");

        if ($sql)
            {
            echo "Apartado editado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }

    public function GetListTrabajadores()
        {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `trabajadores`;"))
            {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Clientes[] = $Result;
                }

            return $Clientes;
            }
        }
    public function GetListProyectos()
        {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `proyectos`;"))
            {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Clientes[] = $Result;
                }

            return $Clientes;
            }
        }
    public function GetListEmpleados()
        {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `empleados`;"))
            {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Clientes[] = $Result;
                }

            return $Clientes;
            }
        }
    public function GetListGrupos2()
        {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `grupos2`;"))
            {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Clientes[] = $Result;
                }

            return $Clientes;
            }
        }
    public function GetPresupuestosCliente($ClienteID)
        {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `presupuestos` WHERE id_cliente = {$ClienteID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders;
            }
        }
    public function GetEmpleado($ClienteID)
        {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `empleados` WHERE id_empleado = {$ClienteID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders[0];
            }
        }

    public function GetTrabajadoresCount()
        {
        //Count the Users on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`id_trabajador`) AS `total` FROM `trabajadores`;"))
            {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total']))
                {
                return $Result['total'];
                } else
                {
                return -1;
                }
            //DataBase Query Error
            } else
            {
            return -2;
            }
        }

    public function RenameFile($FileID, $FileName)
        {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        $FileName = mysqli_real_escape_string($this->DBLink, $FileName);

        $File = $this->GetFileID($FileID);
        $Adress = "./folders" . $File['file_address'] . $File['file_name'] . '.' . $File['file_extension'];
        $Rename = "./folders" . $File['file_address'] . $FileName . '.' . $File['file_extension'];
        rename($Adress, $Rename);

        //Update the file name
        if (!mysqli_query($this->DBLink, "UPDATE `files` SET `file_name` = '{$FileName}' WHERE (`file_id` = '{$FileID}');"))
            {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -1;
            }

        return true;
        }

    }