<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    echo "hola";
    if (isset($_GET['id_factura'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM facturas where id_factura=:id_factura");
        $sql->bindValue(':id_factura', $_GET['id_factura']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    }

    if (isset($_GET['dias'])) {

        $dias = json_decode($_GET['dias']);
        $recursos = array();
        echo var_dump($dias);
        foreach ($dias as $fecha_formato) {

            $sql = "SELECT * FROM files WHERE DATE(fecha) = :fecha AND file_type = 'URL'";
            // Preparar la consulta SQL utilizando PDO
            $stmt = $dbConn->prepare($sql);
            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);
            $stmt->execute();
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $cantidad = $row['cantidad'];

            // Crear un objeto con la fecha y la cantidad de facturas y agregarlo al arreglo $facturas_por_dia
            $objeto = array("dia" => $fecha_formato, "cantidad_url" => $cantidad);
            array_push($recursos, $objeto);
        }
        // Devolver los resultados en formato JSON
        header('Content-Type: application/json');
        echo json_encode($recursos);
        exit();
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM files");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());
        exit();
    }
}

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = $_POST;
    $sql = "INSERT INTO posts
          (title, status, content, user_id)
          VALUES
          (:title, :status, :content, :user_id)";
    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);
    $statement->execute();
    $postId = $dbConn->lastInsertId();
    if ($postId) {
        $input['id'] = $postId;
        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }
}

//Borrar
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    $id = $_GET['id'];
    $statement = $dbConn->prepare("DELETE FROM posts where id=:id");
    $statement->bindValue(':id', $id);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");
