<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) {
    exit();
}

class _ProductosyserviciosModel
{
    private $DBLink;

    public function __construct(&$DBLink)
    {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false) {
            $Users->_Logout();

            header('Location: ./login');
            exit();
        }
    }

    public function CreateProducto($nombre, $imagen, $precio, $numero, $id_subcategoria, $descripcion, $oxidacion)
    {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);
        $imagen = mysqli_real_escape_string($this->DBLink, $imagen);
        $precio = mysqli_real_escape_string($this->DBLink, $precio);
        $numero = mysqli_real_escape_string($this->DBLink, $numero);
        $id_subcategoria = mysqli_real_escape_string($this->DBLink, $id_subcategoria);
        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);
        $oxidacion = mysqli_real_escape_string($this->DBLink, $oxidacion);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `producto` (`nombre`,`imagen`,`precio`,`numero`,`id_subcategoria`,`descripcion`,`oxidacion`)
													VALUES ('{$nombre}','{$imagen}','{$precio}','{$numero}','{$id_subcategoria}','{$descripcion}','{$oxidacion}');");
        if ($sql) {
            echo "Producto agregado correctamente.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }
    public function CreateServicio($nombre, $imagen, $precio, $id_subcategoria, $descripcion)
    {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);
        $imagen = mysqli_real_escape_string($this->DBLink, $imagen);
        $precio = mysqli_real_escape_string($this->DBLink, $precio);

        $id_subcategoria = mysqli_real_escape_string($this->DBLink, $id_subcategoria);
        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `servicio` (`nombre`,`imagen`,`precio`,`id_subcategoria`,`descripcion`)
													VALUES ('{$nombre}','{$imagen}','{$precio}','{$id_subcategoria}','{$descripcion}');");
        if ($sql) {
            echo "Producto agregado correctamente.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }
    public function CreateCompra($client_id, $detallado, $igic, $importe, $tipo, $importe_final, $fecha)
    {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);
        $detallado = mysqli_real_escape_string($this->DBLink, $detallado);
        $client_id = !empty($client_id) ? "'$client_id'" : "NULL";

        $igic = mysqli_real_escape_string($this->DBLink, $igic);
        $importe = mysqli_real_escape_string($this->DBLink, $importe);
        $importe_final = mysqli_real_escape_string($this->DBLink, $importe_final);
        $fecha = mysqli_real_escape_string($this->DBLink, $fecha);
        $tipo = mysqli_real_escape_string($this->DBLink, $tipo);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `compras` (`client_id`,`detallado`,`igic`,`importe`,`tipo`,`importe_final`,`fecha`)
													VALUES ({$client_id},'{$detallado}','{$igic}','{$importe}','{$tipo}','{$importe_final}','{$fecha}');");
        if ($sql) {
            echo "Producto agregado correctamente.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }
    public function UpdateProducto($id, $nombre, $imagen, $precio, $numero, $id_subcategoria, $descripcion, $oxidacion)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);
        $imagen = mysqli_real_escape_string($this->DBLink, $imagen);
        $precio = mysqli_real_escape_string($this->DBLink, $precio);
        $numero = mysqli_real_escape_string($this->DBLink, $numero);
        $id_subcategoria = mysqli_real_escape_string($this->DBLink, $id_subcategoria);
        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);
        $oxidacion = mysqli_real_escape_string($this->DBLink, $oxidacion);
        $sql = mysqli_query($this->DBLink, "UPDATE `producto` SET `nombre` = '{$nombre}',`imagen` = '{$imagen}',`precio` = '{$precio}',`numero` = '{$numero}',`id_subcategoria` = '{$id_subcategoria}',`descripcion` = '{$descripcion}',`oxidacion` = '{$oxidacion}' WHERE (`id_producto` = '{$id}');");

        if ($sql) {
            echo "Producto editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function UpdateServicio($id, $nombre, $imagen, $precio, $id_subcategoria, $descripcion)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);
        $imagen = mysqli_real_escape_string($this->DBLink, $imagen);
        $precio = mysqli_real_escape_string($this->DBLink, $precio);

        $id_subcategoria = mysqli_real_escape_string($this->DBLink, $id_subcategoria);
        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);

        $sql = mysqli_query($this->DBLink, "UPDATE `servicio` SET `nombre` = '{$nombre}',`imagen` = '{$imagen}',`precio` = '{$precio}',`id_subcategoria` = '{$id_subcategoria}',`descripcion` = '{$descripcion}' WHERE (`id_servicio` = '{$id}');");

        if ($sql) {
            echo "Servicio editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function EliminarProducto($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `producto` WHERE (`id_producto` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function DeleteCOmpra($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `compras` WHERE (`id_compra` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function EliminarServicio($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `servicio` WHERE (`id_servicio` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function CambiarColor($id_servicio_calendario, $color)
    {

        $id_servicio_calendario = mysqli_real_escape_string($this->DBLink, $id_servicio_calendario);
        $color = mysqli_real_escape_string($this->DBLink, $color);
        $sql = mysqli_query($this->DBLink, "UPDATE `servicio_calendario` SET `color` = '{$color}' WHERE (`id_servicio_calendario` = '{$id_servicio_calendario}');");

        if ($sql) {
            echo "Apartado editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function SetEstadoCliente($client_id, $peluqueria)
    {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);
        $peluqueria = mysqli_real_escape_string($this->DBLink, $peluqueria);
        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `peluqueria` = '{$peluqueria}' WHERE (`client_id` = '{$client_id}');");

        if ($sql) {
            echo "Apartado editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function CreateSubcategoria($nombre)
    {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);
        $sql = mysqli_query($this->DBLink, "INSERT INTO `subcategorias` (`nombre`) VALUES ('{$nombre}');");
        if ($sql) {
            echo "Subcategoría agregada";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }

    public function EliminarSubcategoria($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `subcategorias` WHERE (`id_subcategoria` = '{$id}');");

        if ($sql) {
            echo "Subcategoria eliminada";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function GetListProductos()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `producto`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListServiciosTrabajadores()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `servicio_trabajador`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }

    public function GetListSubcategoria()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `subcategorias`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }

    public function GetListCompras($FechaInicio = 0, $FechaFinal = 0)
    {
        if ($FechaInicio != 0 && $FechaFinal != 0) {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `compras` where (fecha BETWEEN '{$FechaInicio}' AND '{$FechaFinal}');")) {
                $Clientes = array();

                //Loop around the Referrals
                while ($Result = mysqli_fetch_assoc($Query)) {
                    $Clientes[] = $Result;
                }

                return $Clientes;
            }

        } else {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `compras`;")) {
                $Clientes = array();

                //Loop around the Referrals
                while ($Result = mysqli_fetch_assoc($Query)) {
                    $Clientes[] = $Result;
                }

                return $Clientes;
            }
        }

    }
    public function GetListComprasAt($Fecha)
    {
        $date = date('Y-m-d', strtotime($Fecha));
        $date1 = $date . ' 00:00:00';
        $date2 = $date . ' 23:59:59';

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `compras` where (`fecha` BETWEEN '{$date1}' AND '{$date2}');")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        } else {
            echo mysqli_error($this->DBLink);
        }

    }
    public function GetListComprasFrom($client_id)
    {
        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `compras` where (`client_id` = '{$client_id}');")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        } else {
            echo mysqli_error($this->DBLink);
        }

    }
    public function GetListServicios()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `servicio`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListServiciosCalendario()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `servicio_calendario`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }

    public function GetSubcategoria($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `subcategorias` WHERE (`id_subcategoria` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }
    public function GetCompra($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `compras` WHERE (`id_compra` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }
    public function GetServicio($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `servicio` WHERE (`id_servicio` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }
            if (!empty($Folders)) {
                return $Folders[0];
            } else {
                return null;
            }

        }
    }

    public function GetPresupuesto($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `presupuestos` WHERE (`id_presupuesto` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }

    public function EliminarPresupuesto($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `presupuestos` WHERE (`id_presupuesto` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function EliminarCondicion($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `condiciones` WHERE (`id_condicion` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function UpdateCondicion($id, $condicion, $titulo)
    {
        $condicion = mysqli_real_escape_string($this->DBLink, $condicion);
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);

        $sql = mysqli_query($this->DBLink, "UPDATE `condiciones` SET `condicion` = '{$condicion}',`titulo` = '{$titulo}' WHERE (`id_condicion` = '{$id}');");

        if ($sql) {
            echo "Apartado editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function GetListCondiciones()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `condiciones`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function RechazarPresupuesto($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `presupuestos` SET `estado` = 'Rechazado' WHERE (`id_presupuesto` = '{$id}');");

        if ($sql) {
            echo "Apartado editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function AceptarPresupuesto($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `presupuestos` SET `estado` = 'Aceptado' WHERE (`id_presupuesto` = '{$id}');");

        if ($sql) {
            echo "Apartado ac correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function GetListPresupuestos()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `presupuestos`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetPresupuestosCliente($ClienteID)
    {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `presupuestos` WHERE id_cliente = {$ClienteID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders;
        }
    }

    public function GetListObras()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `obras`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListSectores()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `sectores`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListFases()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fases`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }

    public function GetPresupuestosCount()
    {
        //Count the Users on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`id_presupuesto`) AS `total` FROM `presupuestos`;")) {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total'])) {
                return $Result['total'];
            } else {
                return -1;
            }
            //DataBase Query Error
        } else {
            return -2;
        }
    }

    public function RenameFile($FileID, $FileName)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        $FileName = mysqli_real_escape_string($this->DBLink, $FileName);

        $File = $this->GetFileID($FileID);
        $Adress = "./folders" . $File['file_address'] . $File['file_name'] . '.' . $File['file_extension'];
        $Rename = "./folders" . $File['file_address'] . $FileName . '.' . $File['file_extension'];
        rename($Adress, $Rename);

        //Update the file name
        if (!mysqli_query($this->DBLink, "UPDATE `files` SET `file_name` = '{$FileName}' WHERE (`file_id` = '{$FileID}');")) {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -1;
        }

        return true;
    }

}