<?php

//Exit if isn't called from the main controller

if (

    !defined('__MODELS__') ||

    !defined('__VIEWS__') ||

    !defined('__CONTROLLERS__') ||

    !defined('__LIBRARIES__')

) {

    exit();

}



class _PedidosObservacionesModel

{

    private $DBLink;

    private $table_name = 'pedidos_observaciones';



    public function __construct(&$DBLink)

    {

        //Continue if DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {

            trigger_error('No MySQL connection!', E_USER_ERROR);

        }



        $Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session

        if (isset($_GET['logout']) || $Users->_IsLogged() == false) {

            $Users->_Logout();



            header('Location: ./login');

            exit();

        }

    }



    public function pedidosObservacionesExecSql($sql)

    {

        $pedidos_observaciones = [];



        if ($Query = mysqli_query($this->DBLink, $sql)) {

            while ($Result = mysqli_fetch_assoc($Query)) {

                $pedidos_observaciones[] = $Result;

            }

        }



        return $pedidos_observaciones;

    }



    public function gePedidosObservaciones()

    {

        return $this->pedidosObservacionesExecSql("SELECT * FROM `$this->table_name`");

    }

}

