<?php 

class _PdfModel {
    private $Keywords; //array(array([0]Search, [1]Replacement), array([0]Search, [1]Replacement), array([0]Search, ...), ...)

    public function __construct()
    {
        
        $this->Keywords = array();

    }

    public function _Pdf($Name){
        if (empty($Name) || !preg_match('/^[a-zA-Z0-9_]+\.html$/', $Name)) {
            return -2;
        }
        
        $pdf = __ROOT__.'/pdf/'.$Name;
        
        if (!is_file($pdf) || !file_exists($pdf)) {
            return -3;
        }
        
        //Get the Email Content
        $pdf = file_get_contents($pdf);
        
        //Check for Email Reading Error
        if ($pdf == false) {
            return -4;
        }

    
        $pdf = $this->_ReplaceKeywords($pdf);

        return $pdf;
    }

    
    
    public function _SetKeywords($Keywords) {
        if (is_array($Keywords)) {
            $this->Keywords = $Keywords;
            
            return true;
        }
        
        return false;
    }

    private function _ReplaceKeywords($Body) {
        if (!isset($Body) || empty($Body)) {
            return -1;
        }
        
        if (!isset($this->Keywords) || !is_array($this->Keywords)) {
            return -2;
        }
        
        foreach ($this->Keywords as $Keyword) {
            if (!isset($Keyword[0]) || !isset($Keyword[1])) {
                continue;
            }
            
            $Body = str_replace($Keyword[0], $Keyword[1], $Body);
        }
        
        return $Body;
    }
}  