<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) {
    exit();
}

class _PagosModel
{
    private $DBLink;

    public function __construct(&$DBLink)
    {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false) {
            $Users->_Logout();

            header('Location: ./login');
            exit();
        }
    }

    public function GetListFacturasProveedor()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_proveedor`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListFacturasEmpleado()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_empleado`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListBancos()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `bancos`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListProveedores()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `proveedores`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListMetodos()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `metodos_pago`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }

    public function GetPagosFacturaProveedor($id)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `pago_proveedor` WHERE id_factura_proveedor = {$id};")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetPagosFacturaEmpleado($id)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `pago_empleado` WHERE id_factura_empleado = {$id};")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetBanco($id)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `bancos` WHERE id_banco = {$id};")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes[0];
        }
    }
    public function GetMetodo($id)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `metodos_pago` WHERE id_metodo = {$id};")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes[0];
        }
    }
    public function GetImportePagado($id)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT SUM(importe) as total_pagado FROM `pago_proveedor` WHERE id_factura_proveedor = {$id};")) {
            $row = mysqli_fetch_assoc($Query);
            return $row['total_pagado'];
        } else {
            return 0;
        }
    }
    public function GetImportePagadoEmpleado($id)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT SUM(importe) as total_pagado FROM `pago_empleado` WHERE id_factura_empleado = {$id};")) {
            $row = mysqli_fetch_assoc($Query);
            return $row['total_pagado'];
        } else {
            return 0;
        }
    }
    public function GetEstadoFactura($id, $total_factura)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT SUM(importe) as total_pagado FROM `pago_proveedor` WHERE id_factura_proveedor = {$id};")) {
            $row = mysqli_fetch_assoc($Query);
            $total = $row['total_pagado'];
        } else {
            $total = 0;
        }
        if ($total == 0) {
            return 'Pendiente';
        } elseif ($total < $total_factura) {
            return 'Pago parcial';
        } else {
            return 'Pagado';
        }
    }
    public function GetEstadoFacturaEmpleado($id, $total_factura)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT SUM(importe) as total_pagado FROM `pago_empleado` WHERE id_factura_empleado = {$id};")) {
            $row = mysqli_fetch_assoc($Query);
            $total = $row['total_pagado'];
        } else {
            $total = 0;
        }
        if ($total == 0) {
            return 'Pendiente';
        } elseif ($total < $total_factura) {
            return 'Pago parcial';
        } else {
            return 'Pagado';
        }
    }
    public function GetImporteRestante($id, $total_factura)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT SUM(importe) as total_pagado FROM `pago_proveedor` WHERE id_factura_proveedor = {$id};")) {
            $row = mysqli_fetch_assoc($Query);
            $total = $row['total_pagado'];
        } else {
            $total = 0;
        }

        return $total_factura - $total;

    }
    public function GetImporteRestanteEmpleado($id, $total_factura)
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT SUM(importe) as total_pagado FROM `pago_empleado` WHERE id_factura_empleado = {$id};")) {
            $row = mysqli_fetch_assoc($Query);
            $total = $row['total_pagado'];
        } else {
            $total = 0;
        }

        return $total_factura - $total;

    }
}
