<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) exit();

	//Include the MessageBird SDK
	require_once(__LIBRARIES__.'messagebird/autoload.php');
	
	class _MessageBirdModel {
		private $MessageBird;
		
		public function __construct() {
			//Declare the MessageBird Class
			$this->MessageBird = new \MessageBird\Client(MESSAGEBIRD_API_KEY); // Set your own API access key here.
		}
		
		public function _CreateVerification($Number, $Message = '', $Originator = 'OneUP', $Length = 6, $Timeout = 600) {
			$Number = str_replace(array('+', ' '), '', $Number);
			
			$Verify	= new \MessageBird\Objects\Verify();
			$Verify->recipient = $Number;
			$Verify->originator = $Originator;
			
			if ($Message == '') {
				$Verify->template = '%token';
			} else {
				$Verify->template = $Message.' %token';
			}
			
			$Verify->tokenLength = $Length; //Between 6 and 10
			$Verify->timeout = $Timeout;	//Verification Timeout in Seconds

			try {
				$VerifyResult = $this->MessageBird->verify->create($Verify);
				
				//var_dump($VerifyResult);
				
				return $VerifyResult->getId();
			} catch (\MessageBird\Exceptions\AuthenticateException $e) {
				//That means that your accessKey is unknown
				return -1;
			} catch (\MessageBird\Exceptions\BalanceException $e) {
				//That means that you are out of credits, so do something about it
				return -2;
			} catch (\Exception $e) {
				//Unknown API Error
				//echo $e->getMessage();
				return -3;
			}
			
			//Unknown Error
			return -4;
		}
		
		public function _CheckVerification($VerificationID) {
			try {
				$VerifyResult = $this->MessageBird->verify->read($VerificationID); // Set a message id here
				
				//var_dump($VerifyResult);
				
				return $VerifyResult->getStatus();
			} catch (\MessageBird\Exceptions\AuthenticateException $e) {
				// That means that your accessKey is unknown
				return -1;
			} catch (\Exception $e) {
				//Unknown API Error
				//echo $e->getMessage();
				return -2;
			}
			
			//Unknown Error
			return -3;
		}
		
		public function _VerifyVerification($VerificationID, $Code) {
			try {
				$VerifyResult = $this->MessageBird->verify->verify($VerificationID, $Code); // Set a message id and the token here
				
				//var_dump($VerifyResult);

				if ($VerifyResult->getStatus() === MessageBird\Objects\Verify::STATUS_VERIFIED) {
					return true;
				}
				
				return -1;
			} catch (\MessageBird\Exceptions\RequestException $e) {
				//Invalid Verification Code
				return -2;
			} catch (\MessageBird\Exceptions\AuthenticateException $e) {
				//That means that your accessKey is unknown
				return -3;
			} catch (\Exception $e) {
				//Unknown API Error
				//echo $e->getMessage();
				return -4;
			}
			
			//Unknown Error
			return -5;
		}
	}
?>