<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__'))
	exit();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require_once(__LIBRARIES__ . '/phpmailer/Exception.php');
require_once(__LIBRARIES__ . '/phpmailer/PHPMailer.php');
require_once(__LIBRARIES__ . '/phpmailer/SMTP.php');

class _MailerModel
{
	private $Mailer;
	private $Server;
	private $Port;
	private $Username;
	private $Password;
	private $Keywords; //array(array([0]Search, [1]Replacement), array([0]Search, [1]Replacement), array([0]Search, ...), ...)

	public function __construct($Server, $Port, $Username, $Password, $Debug = 0)
	{
		$this->Server = $Server;
		$this->Port = $Port;
		$this->Username = $Username;
		$this->Password = $Password;

		//Instantiation and passing `true` enables exceptions
		$this->Mailer = new PHPMailer(true);

		try {
			//Server settings
			$this->Mailer->SMTPDebug = $Debug; // Enable verbose debug output
			$this->Mailer->isSMTP(); // Set mailer to use SMTP
			$this->Mailer->Host = $Server; // Specify main and backup SMTP servers
			$this->Mailer->SMTPAuth = true; // Enable SMTP authentication
			$this->Mailer->Username = $Username; // SMTP username
			$this->Mailer->Password = $Password; // SMTP password
			$this->Mailer->SMTPSecure = 'ssl'; // Enable TLS encryption, `ssl` also accepted
			$this->Mailer->Port = $Port; // TCP port to connect to
		} catch (Exception $e) {

			return -1;
		}

		$this->Keywords = array();

		return true;
	}

	function _Mail(
		$From,
		$To,
		$Subject,
		$Body,
		$FromName = '',
		$ToName = '',
		$pdf = NULL,
		$HTML = true,
		$SearchTitle = true,
		$Document = "Documento",
		$Tipo = ".pdf"
	) {
		include __ROOT__ . "/api/utils.php";
		$dbConn = connect($db);

		try {
			if (!is_null($pdf)) {
				if (is_array($pdf)) {
					for ($i = 0; $i < count($pdf['name']); $i++) {
						$nombreArchivo = $pdf['name'][$i];
						$tipoArchivo = $pdf['type'][$i];
						$archivoTemporal = $pdf['tmp_name'][$i];
						$tamañoArchivo = $pdf['size'][$i];

						$contenidoArchivo = file_get_contents($archivoTemporal);

						// Agregar el archivo adjunto al correo
						$this->Mailer->addStringAttachment($contenidoArchivo, $nombreArchivo);
					}
				} else {
					$this->Mailer->addStringAttachment($pdf, $Document . $Tipo);
				}
			}
			$this->Mailer->ClearAllRecipients(); //Clear Previous Recipients

			$this->Mailer->CharSet = 'UTF-8';


			if ($FromName != '') {
				$this->Mailer->setFrom($From, $FromName);
				$this->Mailer->addReplyTo($From, $FromName);
			} else {
				$this->Mailer->setFrom($From);
				$this->Mailer->addReplyTo($From);
			}

			if ($ToName != '') {
				$this->Mailer->addAddress($To, $ToName);
			} else {
				$this->Mailer->addAddress($To);
			}

			$this->_ReplaceKeywords($Body);


			$this->Mailer->isHTML(true);
			$this->Mailer->Subject = $Subject;
			$this->Mailer->Body = $Body;
			/*
						if ($HTML == true) {
							$this->Mailer->isHTML(true);

							if ($SearchTitle === true) {
								$Title = $this->_ReadTitle($Body);

								if ($Title !== false) {
									$Subject = $Title;

									$this->_ReplaceKeywords($Subject);
								}
							}

							$this->Mailer->Subject = $Subject;
							$this->Mailer->Body = $Body;
							//$this->Mailer->AltBody = $Body;
						} else {
							$this->Mailer->isHTML(false);
							$this->Mailer->Subject = $Subject;
							$this->Mailer->Body = $Body;
						}
			*/

			$statement = $dbConn->prepare("INSERT INTO mailing
			(from_address, to_address, body, used, attachments, status, createdAt, title)
			VALUES
			(:from_address, :to_address, :body, :used, :attachments, :status, :createdAt, :title)");
			
			$statement->bindValue(':from_address', $From);
			$statement->bindValue(':to_address', $To);
			$statement->bindValue(':body', addslashes($Body));
			$statement->bindValue(':used', 0);
			$statement->bindValue(':attachments', addslashes(json_encode($pdf)));
			$statement->bindValue(':status', 1);
			$statement->bindValue(':createdAt', date('Y-m-d H:i:s'));
			$statement->bindValue(':title', $Subject);
			$statement->execute();

			return $this->Mailer->send();
		} catch (Exception $e) {
			//echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
			return trim(preg_replace('/\s\s+/', ' ', $this->Mailer->ErrorInfo));
			//return -1;
		}

		return -2;
	}

	public function _SetKeywords($Keywords)
	{
		if (is_array($Keywords)) {
			$this->Keywords = $Keywords;

			return true;
		}

		return false;
	}

	public function _ReadTitle($Template)
	{
		if (preg_match('/<title>(.*?)<\/title>/i', $Template, $Match) == 1) {
			return $Match[1];
		}

		return false;
	}

	public function _ReadEmail($Name)
	{
		if (empty($Name) || !preg_match('/^[a-zA-Z0-9_]+\.html$/', $Name)) {
			return -2;
		}

		$Email = __ROOT__ . '/emails/' . $Name;

		if (!is_file($Email) || !file_exists($Email)) {
			return -3;
		}

		//Get the Email Content
		$Email = file_get_contents($Email);

		//Check for Email Reading Error
		if ($Email == false) {
			return -4;
		}

		return $Email;
	}

	private function _ReplaceKeywords(&$Body)
	{
		if (!isset($Body) || empty($Body)) {
			return -1;
		}

		if (!isset($this->Keywords) || !is_array($this->Keywords)) {
			return -2;
		}

		foreach ($this->Keywords as $Keyword) {
			if (!isset($Keyword[0]) || !isset($Keyword[1])) {
				continue;
			}

			$Body = str_replace($Keyword[0], $Keyword[1], $Body);
		}

		return true;
	}
}
