<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__')) exit();

class _GoogleModel
{
	private $DBLink;
	private $GGClient;
	private $GGHelper;

	public function __construct(&$DBLink)
	{
		//Continue if DataBase Link is Valid
		if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
			//Link the Class DataBase Link to the Given DataBase Link
			$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
		} else trigger_error('No MySQL connection!', E_USER_ERROR);

		//Start the Session
		if (!isset($_SESSION)) {
			session_start();
		}

		//Load the Google PHP SDK
		require_once(__LIBRARIES__ . '/google/vendor/autoload.php');

		//Declare the Google SDK Class
		$this->GGClient = new Google_Client();

		$this->GGClient->setApplicationName('Login Regrasa');

		$googleData = $this->GetGoogleData()[0];

		$this->GGClient->setClientId($googleData['client_id']);
		$this->GGClient->setClientSecret($googleData['client_secret']);
		$this->GGClient->setRedirectUri($googleData['redirect_link']);

		$this->GGClient->addScope('email');
		$this->GGClient->addScope('profile');
		$this->GGClient->addScope('https://www.googleapis.com/auth/userinfo.profile');
	}

	public function _LoginURL()
	{
		//This Page isn't Loaded by Google Callback URL
		if (!isset($_GET['code'])) {
			return $this->GGClient->createAuthUrl();
		}

		return false;
	}

	public function GetGoogleData()
	{	
		if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `google` LIMIT 1")) {
			$googleDa = array();

			//Loop around the Referrals
			while ($Result = mysqli_fetch_assoc($Query)) {
				$googleDa[] = $Result;
			}

			return $googleDa;
		}
	}

	#####################################################################
	##	Function Description:
	##		Add new Product Type to the Database.
	##	Parameters:
	##		@param $Name [String: The Product Name]
	##		@param $Limit [Integer: The Product Limit]
	##		@param $Price [Integer: The Product Price]
	##		@param $Duration [Integer: The Product Duration (On Days)]
	##	Return:
	##		true = Sucess
	##		-1 = Google Graph returned an Error
	##		-2 = Google SDK returned an Error
	##		-3 = Google SDK don't return the Token
	##		-4 = Google Graph returned an Error
	##		-5 = Google SDK returned an Error
	##		-6 = Invalid Google Callback URL
	#####################################################################
	public function _LoginCallback()
	{
		//Read the Access Token from previous Session (If Exists)
		if (!empty($_SESSION['gg_access_token'])) {
			$this->GGClient->setAccessToken($_SESSION['gg_access_token']);

			if ($this->GGClient->isAccessTokenExpired()) {
				unset($_SESSION['gg_access_token']);

				return -1;
			}
		}

		//This Page is Loaded by Google API Callback URL
		if (isset($_GET['code'])) {
			//Get the Access Token from the Auth Code
			$accessToken = $this->GGClient->fetchAccessTokenWithAuthCode($_GET['code']);

			//Set the Access Token on Google API Client

			$this->GGClient->setAccessToken($accessToken);

			//Save the Access Token to a Session
			$_SESSION['gg_access_token'] = $accessToken;
		}

		$OAuth2 = new Google_Service_Oauth2($this->GGClient);
		$userInfo = $OAuth2->userinfo->get();

		//Default Return is Invalid for Avoid Unknown Errors
		return $userInfo;
	}

	public function _Logout()
	{
		session_destroy();

		return true;
	}
}
