<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__'))
    exit();

class _FoldersModel
{
    private $DBLink;

    public function __construct(&$DBLink)
    {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else
            trigger_error('No MySQL connection!', E_USER_ERROR);

        $Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false) {
            $Users->_Logout();

            header('Location: ./login');
            exit();
        }
    }
    public function GetEstadoArchivo($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `estado_archivo` WHERE (`id_estado_archivo` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }

    public function GetEstadosArchivo()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `estado_archivo`")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders;
        }
    }



    public function CreateFile($FileNamePost, $TypeFile, $PulledApart, $Folder, $Tags, $File)
    {
        $FileNamePost = mysqli_real_escape_string($this->DBLink, $FileNamePost);
        $PulledApart = mysqli_real_escape_string($this->DBLink, $PulledApart);
        $TypeFile = mysqli_real_escape_string($this->DBLink, $TypeFile);
        $Folder = mysqli_real_escape_string($this->DBLink, $Folder);
        $Tags = mysqli_real_escape_string($this->DBLink, $Tags);

        $Address = $this->GetAddressFolder($Folder);

        $Time = time();
        $Fecha = date('Y-m-d');


        //Condición para roles de usuarios   
        if (($_SESSION['role'] == 1) or ($PulledApart == 0 && $_SESSION['role'] != 5) or ($PulledApart == 1 && $_SESSION['role'] != 4) or ($PulledApart == 2 && $_SESSION['role'] != 6) or ($PulledApart == 3 && $_SESSION['role'] != 2) or ($PulledApart == 4 && $_SESSION['role'] != 3)) {

            //Si no es adminitrador
            if ($_SESSION['role'] != 7) {
                return -1;
            }
        }

        //Verificar que exista la carpeta
        if ($Folder != 0) {
            $Query = mysqli_query($this->DBLink, "SELECT `folder_id` FROM `folders` WHERE (`folder_id` = '{$Folder}' AND `folder_section` = '{$PulledApart}');");

            //Sucessfull Search
            if (!($Query && mysqli_num_rows($Query) > 0)) {

                return -1;
            }
        }

        if (empty($FileNamePost)) {
            return -2;
        }

        //Si es una URL
        if ($TypeFile == 'URL') {

            if (empty($File)) {
                return -3;
            }

            if (!mysqli_query($this->DBLink, "INSERT INTO `files` (`file_user`, `file_name`, `file_type`, `file_section`, `file_folder`, `file_address`, `file_tags`, `file_data`,`fecha`) VALUES ('{$_SESSION['id']}', '{$FileNamePost}',  '{$TypeFile}', '{$PulledApart}', '{$Folder}', '{$File}', '{$Tags}', '{$Time}','{$Fecha}');")) {
                //Revert the DataBase Queries
                mysqli_rollback($this->DBLink);

                //Start the DataBase Auto-Commit
                mysqli_autocommit($this->DBLink, true);

                return -1;
            }
            return true;
        }


        $output_dir = './folders' . $Address;


        $ret = array();


        $error = $File["error"];

        //You need to handle  both cases
        //If Any browser does not support serializing of multiple files using FormData() 
        if (!is_array($File["name"])) //single file
        {
            if ($File["error"] == UPLOAD_ERR_NO_FILE) {
                return -4;
            }

            $valores = explode('.', $File["name"]);
            $extension = $valores[count($valores) - 1];
            $fileName = $FileNamePost . '.' . $extension;
            //Comprobar si existe el fichero
            if (file_exists($output_dir . $fileName)) {
                return -5;
            }

            move_uploaded_file($File["tmp_name"], $output_dir . $fileName);
            $ret[] = $fileName;

            if (!mysqli_query($this->DBLink, "INSERT INTO `files` (`file_user`, `file_name`, `file_extension`, `file_type`, `file_section`, `file_folder`, `file_address`, `file_tags`, `file_data`,`fecha`) VALUES ('{$_SESSION['id']}', '{$FileNamePost}', '{$extension}',  '{$TypeFile}', '{$PulledApart}', '{$Folder}', '{$Address}', '{$Tags}', '{$Time}','{$Fecha}');")) {
                //Revert the DataBase Queries
                mysqli_rollback($this->DBLink);

                //Start the DataBase Auto-Commit
                mysqli_autocommit($this->DBLink, true);

                return -1;
            }
        } else //Multiple files, file[]
        {


            $fileCount = count($File["name"]);

            for ($i = 0; $i < $fileCount; $i++) {
                if ($File["error"][$i] == UPLOAD_ERR_NO_FILE) {
                    return -4;
                }

                $fileName = $FileNamePost;
                //Obtener extensión de archivo
                $valores = explode('.', $File["name"][$i]);
                $extension = $valores[count($valores) - 1];

                if ($i > 0) {
                    $Incrementable = ' (' . $i . ')';
                } else {
                    $Incrementable = '';
                }

                //Comprobar si existe el fichero
                if (file_exists($output_dir . $fileName . $Incrementable . '.' . $extension)) {
                    return -5;
                }

                move_uploaded_file($File["tmp_name"][$i], $output_dir . $fileName . $Incrementable . '.' . $extension);


                if (!mysqli_query($this->DBLink, "INSERT INTO `files` (`file_user`, `file_name`, `file_extension`, `file_type`, `file_section`, `file_folder`, `file_address`, `file_tags`, `file_data`,`fecha`) VALUES ('{$_SESSION['id']}', '{$fileName}{$Incrementable}', '{$extension}',  '{$TypeFile}', '{$PulledApart}', '{$Folder}', '{$Address}', '{$Tags}', '{$Time}','{$Fecha}');")) {
                    //Revert the DataBase Queries
                    mysqli_rollback($this->DBLink);

                    //Start the DataBase Auto-Commit
                    mysqli_autocommit($this->DBLink, true);

                    return -1;
                }
            }
        }

        return true;
    }



    public function GetAddressFolder($UserFolder)
    {
        $UserFolder = mysqli_real_escape_string($this->DBLink, $UserFolder);
        if ($UserFolder != 0) {
            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `folders` WHERE folder_id = {$UserFolder}")) {

                $FolderFather = mysqli_fetch_assoc($Query);

                if ($FolderFather['folder_address'] != '/') {


                    $Address = $FolderFather['folder_address'] . $FolderFather['folder_id'] . '/';
                } else {

                    $Address = '/' . $FolderFather['folder_id'] . '/';
                }
            }
        } else {
            $Address = '/';
        }


        return $Address;
    }

    public function CreateFolder($FolderName, $PulledApart, $Folder, $Tags)
    {

        $FolderName = mysqli_real_escape_string($this->DBLink, $FolderName);
        $PulledApart = mysqli_real_escape_string($this->DBLink, $PulledApart);
        $Folder = mysqli_real_escape_string($this->DBLink, $Folder);
        $Tags = mysqli_real_escape_string($this->DBLink, $Tags);
        $Time = time();
        $explode = explode("&", $PulledApart);

        $is_other_folder = false;
        if (count($explode) > 1) {
            $is_other_folder = true;
        }

        //Condición para roles de usuarios   
        if (($_SESSION['role'] == 1) or ($PulledApart == 0 && $_SESSION['role'] != 5) or ($PulledApart == 1 && $_SESSION['role'] != 4) or ($PulledApart == 2 && $_SESSION['role'] != 6) or ($PulledApart == 3 && $_SESSION['role'] != 2) or ($PulledApart == 4 && $_SESSION['role'] != 3)) {

            //Si no es adminitrador
            if ($_SESSION['role'] != 7) {
                return -1;
            }
        }

        //Verificar que exista la carpeta
        if ($Folder != 0) {
            if ($is_other_folder) {
                $Query = mysqli_query($this->DBLink, "SELECT `folder_id` FROM `folders` WHERE (`folder_id` = '{$Folder}' AND `id_extra_folder` = '{$explode[0]}');");
            } else {
                $Query = mysqli_query($this->DBLink, "SELECT `folder_id` FROM `folders` WHERE (`folder_id` = '{$Folder}' AND `folder_section` = '{$PulledApart}');");
            }

            //Sucessfull Search
            if (!($Query && mysqli_num_rows($Query) > 0)) {

                return -1;
            }
        }

        if ($Folder != 0) {

            $Address = $this->GetAddressFolder($Folder);
        } else {
            $Address = '/';
        }

        $txt_query = '';
        if($is_other_folder){
            $txt_query = "INSERT INTO `folders` (`folder_user`, `folder_name`, `id_extra_folder`, `folder_folder`, `folder_address`, `folder_tag`, `folder_data`) VALUES ('{$_SESSION['id']}', '{$FolderName}',  '{$PulledApart}', '{$Folder}', '{$Address}', '{$Tags}', '{$Time}');";
        } else {
            $txt_query = "INSERT INTO `folders` (`folder_user`, `folder_name`, `folder_section`, `folder_folder`, `folder_address`, `folder_tag`, `folder_data`) VALUES ('{$_SESSION['id']}', '{$FolderName}',  '{$PulledApart}', '{$Folder}', '{$Address}', '{$Tags}', '{$Time}');";
        }

        if (!mysqli_query($this->DBLink, $txt_query)) {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -3;
        }

        $FolderID = mysqli_insert_id($this->DBLink);

        //Crear carpeta en el servidor           
        $estructura = './folders' . $Address . $FolderID;
        if (!mkdir($estructura, 0777, true)) {
            return -4;
        }

        return true;
    }

    public function CreateFavorite($TypeID, $Type)
    {
        $TypeID = mysqli_real_escape_string($this->DBLink, $TypeID);
        $Type = mysqli_real_escape_string($this->DBLink, $Type);

        $Time = time();

        //Si ya se ha añadido a favorito, elimina el favorito
        if (is_array($this->GetFavoriteTypeID($_SESSION['id'], $TypeID))) {

            $DataFavorite = $this->GetFavoriteTypeID($_SESSION['id'], $TypeID);
            //Delete favorite
            if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_id` = '{$DataFavorite['favorite_id']}');")) {
                //Revert the DataBase Queries
                mysqli_rollback($this->DBLink);

                //Start the DataBase Auto-Commit
                mysqli_autocommit($this->DBLink, true);

                return -10;
            }

            return -1;
        }

        if (!is_array($this->GetFileID($TypeID)) && !is_array($this->GetFolderID($TypeID))) {
            return -2;
        }

        if (!mysqli_query($this->DBLink, "INSERT INTO `favorites` (`favorite_user`, `favorite_type`, `favorite_type_id`, `favorite_data`) VALUES ('{$_SESSION['id']}', '{$Type}',  '{$TypeID}', '{$Time}');")) {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -2;
        }
        return true;
    }

    private function deleteDirectory($dir)
    {
        if (!$dh = @opendir($dir))
            return;
        while (false !== ($current = readdir($dh))) {
            if ($current != '.' && $current != '..') {

                if (!@unlink($dir . '/' . $current))
                    $this->deleteDirectory($dir . '/' . $current);
            }
        }
        closedir($dh);

        @rmdir($dir);
    }

    public function DeleteFolder($FolderID)
    {
        $FolderID = mysqli_real_escape_string($this->DBLink, $FolderID);
        $Address = $this->GetAddressFolder($FolderID);

        if ($QueryCountFolder = mysqli_query($this->DBLink, "SELECT folder_id FROM `folders` WHERE folder_id = {$FolderID}")) {
            //Check for valid Search
            if ($QueryCountFolder && mysqli_num_rows($QueryCountFolder) == 0) {

                return -6;
            }
        }

        $estructura = './folders' . $Address;
        //Eliminar carpeta y todo lo que haya dentro
        $this->deleteDirectory($estructura);

        //Eliminar carpetas dentro de la carpeta en la BBDD 
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `folders`")) {
            $Folders = array();

            //Loop around the folders
            while ($Result = mysqli_fetch_assoc($Query)) {

                $array = explode("/", $Result['folder_address']);
                $CountArray = count($array);
                //Comprobar si coincide la ruta 
                for ($i = 0; $i <= $CountArray - 1; $i++) {
                    //Si coincida la ruta
                    if ($array[$i] == $FolderID) {

                        if (!mysqli_query($this->DBLink, "DELETE FROM `folders` WHERE (`folder_id` = '{$Result['folder_id']}');")) {
                            //Can't Delete this User
                            return -1;
                        }

                        if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$Result['folder_id']}' AND `favorite_type` = '');")) {
                            //Revert the DataBase Queries
                            mysqli_rollback($this->DBLink);

                            //Start the DataBase Auto-Commit
                            mysqli_autocommit($this->DBLink, true);

                            return -2;
                        }
                    }
                }
            }
        }

        //Eliminar archivos dentro de la carpeta
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `files`")) {
            $Files = array();

            //Loop around the files
            while ($Result = mysqli_fetch_assoc($Query)) {

                $array = explode("/", $Result['file_address']);
                $CountArray = count($array);
                //Comprobar si coincide la ruta 
                for ($i = 0; $i <= $CountArray - 1; $i++) {
                    //Si coincida la ruta
                    if ($array[$i] == $FolderID) {
                        //Eliminar archivos de la BD
                        if (!mysqli_query($this->DBLink, "DELETE FROM `files` WHERE (`file_id` = '{$Result['file_id']}');")) {
                            //Can't Delete this User
                            return -1;
                        }

                        if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$Result['file_id']}' AND `favorite_type` != '');")) {
                            //Revert the DataBase Queries
                            mysqli_rollback($this->DBLink);

                            //Start the DataBase Auto-Commit
                            mysqli_autocommit($this->DBLink, true);

                            return -2;
                        }
                    }
                }
            }
        }
        //Eliminar carpeta
        if (!mysqli_query($this->DBLink, "DELETE FROM `folders` WHERE (`folder_id` = '{$FolderID}');")) {
            //Can't Delete this User
            return -1;
        }

        //eliminar favorito
        if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$FolderID}' AND `favorite_type` = '');")) {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -2;
        }
        return true;
    }

    public function DeleteFiles($FileID)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);

        if ($Query = mysqli_query($this->DBLink, "SELECT file_id, file_name, file_extension, file_address FROM `files` WHERE file_id = '$FileID'")) {
            $Result = mysqli_fetch_assoc($Query);

            $estructura = './folders' . $Result['file_address'] . $Result['file_name'] . '.' . $Result['file_extension'];

            @unlink($estructura);

            if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$Result['file_id']}' AND `favorite_type` != '');")) {
                //Revert the DataBase Queries
                mysqli_rollback($this->DBLink);

                //Start the DataBase Auto-Commit
                mysqli_autocommit($this->DBLink, true);

                return -2;
            }
        }


        //Eliminar archivo
        if (!mysqli_query($this->DBLink, "DELETE FROM `files` WHERE (`file_id` = '{$FileID}');")) {
            //Can't Delete this User
            return -1;
        }

        return true;
    }
    public function GetListFilesAt($Fecha)
    {


        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `files` where (`fecha` ='{$Fecha}');")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListFolders($user_id = null)
    {
        // Construir la consulta SQL
        if ($user_id !== null) {
            // Consulta con JOIN para cuando $user_id está presente
            $sql = "
                    SELECT DISTINCT f.* 
                    FROM folders f
                    LEFT JOIN user_permiso up ON f.folder_id = up.folder_id AND up.user_id = ?
                    WHERE f.folder_user = ? OR up.folder_id IS NOT NULL
                ";
        } else {
            // Consulta simple para cuando $user_id no está presente
            $sql = "SELECT * FROM folders";
        }

        // Preparar la consulta
        $stmt = mysqli_prepare($this->DBLink, $sql);

        // Vincular parámetros si $user_id está presente
        if ($user_id !== null) {
            mysqli_stmt_bind_param($stmt, "ii", $user_id, $user_id);
        }

        // Ejecutar la consulta
        mysqli_stmt_execute($stmt);

        // Obtener resultados
        $result = mysqli_stmt_get_result($stmt);
        $Folders = array();

        // Recorrer los resultados
        while ($row = mysqli_fetch_assoc($result)) {
            $Folders[] = $row;
        }

        // Cerrar la declaración
        mysqli_stmt_close($stmt);

        return $Folders;
    }


    public function GetListFolderSection($SectionID)
    {
        $SectionID = mysqli_real_escape_string($this->DBLink, $SectionID);
        if (isset($_REQUEST['other_folder'])) {
            if ($Query = mysqli_query($this->DBLink, "SELECT folder_id, folder_name FROM `folders` WHERE id_extra_folder = {$SectionID}")) {
                $Folders = array();

                //Loop around the Referrals
                while ($Result = mysqli_fetch_assoc($Query)) {
                    $Folders[] = $Result;
                }

                return $Folders;
            }
        } else {
            if ($Query = mysqli_query($this->DBLink, "SELECT folder_id, folder_name FROM `folders` WHERE folder_section = {$SectionID}")) {
                $Folders = array();

                //Loop around the Referrals
                while ($Result = mysqli_fetch_assoc($Query)) {
                    $Folders[] = $Result;
                }

                return $Folders;
            }
        }
    }
    public function GetFolders($FolderID)
    {
        $FolderID = mysqli_real_escape_string($this->DBLink, $FolderID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `folders` WHERE folder_id = '{$FolderID}'")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders = $Result;
            }

            return $Folders;
        }
    }

    public function GetListFiles()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `files`")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders;
        }
    }

    public function GetListFilesAndFolders()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `files`")) {
            $Files = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Files[] = $Result;
            }
        }
        if ($Query2 = mysqli_query($this->DBLink, "SELECT * FROM `folders`")) {

            //Loop around the Referrals
            while ($Result2 = mysqli_fetch_assoc($Query2)) {
                $Folders = array_merge($Files, $Result2);
            }
        }
        return $Folders;
    }
    public function GetFiles($FileID)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `files` WHERE file_user = {$FileID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders;
        }
    }
    public function GetFileID($FileID)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `files` WHERE file_id = {$FileID}")) {
            //Check for valid Search
            if ($Query && mysqli_num_rows($Query) == 1) {
                //Loop around the Referrals
                $Result = mysqli_fetch_assoc($Query);

                return $Result;
            }
            return false;
        }
    }

    public function GetFolderID($FolderID)
    {
        $FolderID = mysqli_real_escape_string($this->DBLink, $FolderID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `folders` WHERE folder_id = {$FolderID}")) {
            //Check for valid Search
            if ($Query && mysqli_num_rows($Query) == 1) {
                //Loop around the Referrals
                $Result = mysqli_fetch_assoc($Query);

                return $Result;
            }
            return false;
        }
    }
    public function GetFavoriteTypeID($UserID, $FavoriteID)
    {
        $FavoriteID = mysqli_real_escape_string($this->DBLink, $FavoriteID);
        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `favorites` WHERE favorite_type_id = {$FavoriteID} AND favorite_user = '{$UserID}'")) {
            //Check for valid Search
            if ($Query && mysqli_num_rows($Query) == 1) {
                //Loop around the Referrals
                $Result = mysqli_fetch_assoc($Query);

                return $Result;
            }
            return false;
        }
    }

    public function GetFavoriteUserID($UserID)
    {

        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `favorites` WHERE favorite_user = {$UserID}")) {
            $Favorite = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Favorite[] = $Result;
            }

            return $Favorite;
        }
    }

    public function GetFilesAndFoldersSections($Sections, $Order, $Limit = 15, $Folder = 0, $Search = NULL, $id_estado_archivo = 0, $is_extra_folder = false)
    {
        $user_id = $_SESSION["id"];
        $Sections = mysqli_real_escape_string($this->DBLink, $Sections);
        $Order = mysqli_real_escape_string($this->DBLink, $Order);

        if (is_numeric($Limit)) {
            $Limit = 'LIMIT ' . $Limit;
        } else {
            $Limit = '';
        }

        if ($is_extra_folder) {
            $baseQuery = "(
                SELECT folder_id, folder_user, folder_name, folder_data, folder_type, folder_address, folder_tag, folder_section, id_estado_archivo
                FROM folders
                WHERE id_extra_folder = '{$Sections}'";
        } else {
            // Base query for folders and files
            $baseQuery = "(
                SELECT folder_id, folder_user, folder_name, folder_data, folder_type, folder_address, folder_tag, folder_section, id_estado_archivo
                FROM folders
                WHERE folder_section = '{$Sections}' AND folder_folder = '{$Folder}' AND folder_user = '{$user_id}'";

            // Conditionally add the filter for id_estado_archivo
            if ($id_estado_archivo != 0) {
                $baseQuery .= " AND id_estado_archivo = '{$id_estado_archivo}'";
            }
        }

        $baseQuery .= "
                UNION ALL
                SELECT file_id AS folder_id, file_user AS folder_user, file_name AS folder_name, file_data AS folder_data, file_type AS folder_type, file_address AS folder_address, file_tags AS folder_tag, file_section AS folder_section, id_estado_archivo
                FROM files
                WHERE file_section = '{$Sections}' AND file_folder = '{$Folder}'";

        // Conditionally add the filter for id_estado_archivo
        if ($id_estado_archivo != 0) {
            $baseQuery .= " AND id_estado_archivo = '{$id_estado_archivo}'";
        }

        $baseQuery .= ")";

        $permissionQuery = "(
                SELECT f.folder_id, f.folder_user, f.folder_name, f.folder_data, f.folder_type, f.folder_address, f.folder_tag, f.folder_section, f.id_estado_archivo
                FROM folders f
                INNER JOIN user_permiso up ON f.folder_id = up.folder_id
                WHERE f.folder_section = '{$Sections}' AND f.folder_folder = '{$Folder}' AND up.user_id = '{$user_id}'";

        // Conditionally add the filter for id_estado_archivo
        if ($id_estado_archivo != 0) {
            $permissionQuery .= " AND f.id_estado_archivo = '{$id_estado_archivo}'";
        }

        $permissionQuery .= ")";

        // Combine base query with permission query
        $fullQuery = "
                ($baseQuery)
                UNION
                ($permissionQuery)
            ";

        if ($Sections == 'todas' || $is_extra_folder) {
            if ($Search != NULL) {
                if ($Search[0] == '#') {
                    $Search = substr($Search, 1);
                    // Búsqueda por tags
                    $Query = mysqli_query($this->DBLink, "$fullQuery AND folder_tag LIKE '%$Search%' $Order $Limit;");
                } else {
                    // Búsqueda general
                    $Query = mysqli_query($this->DBLink, "$fullQuery AND (folder_name LIKE '%$Search%' OR folder_tag LIKE '%$Search%') $Order $Limit;");
                }
                $Folders = array();
                while ($Result = mysqli_fetch_array($Query)) {
                    $Folders[] = $Result;
                }
                return $Folders;
            } else {
                if ($Query = mysqli_query($this->DBLink, "$fullQuery $Order $Limit;")) {
                    $Folders = array();
                    while ($Result = mysqli_fetch_array($Query)) {
                        $Folders[] = $Result;
                    }
                    return $Folders;
                }
            }
        }

        // Obtener favoritos
        if ($Sections == 'favorites') {
            $Order = $Order == 'ancient' ? 'ORDER BY favorite_data ASC' : 'ORDER BY favorite_data DESC';

            $Favorite = array();
            if ($QueryFavorite = mysqli_query($this->DBLink, "SELECT * FROM `favorites` WHERE favorite_user = {$_SESSION['id']} $Order $Limit;")) {
                while ($ResultFavorite = mysqli_fetch_assoc($QueryFavorite)) {
                    if ($Search != NULL) {
                        if ($Search[0] == '#') {
                            $Search = substr($Search, 1);
                            // Búsqueda por tags
                            $Query = mysqli_query($this->DBLink, "$fullQuery AND folder_tag LIKE '%$Search%' AND folder_id = '{$ResultFavorite['favorite_type_id']}'");
                        } else {
                            // Búsqueda general
                            $Query = mysqli_query($this->DBLink, "$fullQuery AND (folder_name LIKE '%$Search%' OR folder_tag LIKE '%$Search%') AND folder_id = '{$ResultFavorite['favorite_type_id']}'");
                        }

                        if ($Query && mysqli_num_rows($Query) == 1) {
                            $Result = mysqli_fetch_assoc($Query);
                            $Favorite[] = $Result;
                        }
                    } else {
                        if ($Query = mysqli_query($this->DBLink, "$fullQuery AND folder_id = '{$ResultFavorite['favorite_type_id']}'")) {
                            if ($Query && mysqli_num_rows($Query) == 1) {
                                $Result = mysqli_fetch_assoc($Query);
                                $Favorite[] = $Result;
                            }
                        }
                    }
                }
            }
            return $Favorite;
        }

        if (!empty($Order)) {
            if ($Order == 'recent' || $Order == 'folders' || $Order == 'files' || $Order == 'images' || $Order == 'urls') {
                $Order = 'ORDER BY folder_data DESC';
            } else if ($Order == 'ancient') {
                $Order = 'ORDER BY folder_data ASC';
            } else {
                $Order = '';
            }
        }

        // Handle search criteria
        if ($Search != NULL) {
            if ($Search[0] == '#') {
                $Search = substr($Search, 1);
                // Search by tags
                $fullQuery .= " AND folder_tag LIKE '%$Search%'";
            } else {
                // General search
                $fullQuery .= " AND (folder_name LIKE '%$Search%' OR folder_tag LIKE '%$Search%')";
            }
        }

        $fullQuery .= " $Order $Limit;";

        // Execute the query
        if ($Query = mysqli_query($this->DBLink, $fullQuery)) {
            $Folders = array();
            while ($Result = mysqli_fetch_array($Query)) {
                $Folders[] = $Result;
            }
            return $Folders;
        }

        return array();
    }



    public function _GetFoldersCount()
    {
        //Count the Users on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`folder_id`) AS `total` FROM `folders`;")) {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total'])) {
                return $Result['total'];
            } else {
                return -1;
            }
            //DataBase Query Error
        } else {
            return -2;
        }
    }

    public function _GetFilesCount()
    {
        //Count the Users on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`file_id`) AS `total` FROM `files`;")) {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total'])) {
                return $Result['total'];
            } else {
                return -1;
            }
            //DataBase Query Error
        } else {
            return -2;
        }
    }

    public function _GetFilesCountID($FileID)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        //Count the files on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`file_id`) AS `total` FROM `files` WHERE file_folder = '{$FileID}';")) {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total'])) {
                return $Result['total'];
            } else {
                return -1;
            }
            //DataBase Query Error
        } else {
            return -2;
        }
    }

    public function RenameFile($FileID, $FileName)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        $FileName = mysqli_real_escape_string($this->DBLink, $FileName);

        $File = $this->GetFileID($FileID);
        $Adress = "./folders" . $File['file_address'] . $File['file_name'] . '.' . $File['file_extension'];
        $Rename = "./folders" . $File['file_address'] . $FileName . '.' . $File['file_extension'];
        rename($Adress, $Rename);

        //Update the file name
        if (!mysqli_query($this->DBLink, "UPDATE `files` SET `file_name` = '{$FileName}' WHERE (`file_id` = '{$FileID}');")) {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -1;
        }




        return true;
    }
}
